<?php
namespace engine;
class Res{
    private $costLevel = 1000;
    private $costLud   = 100;
    public function __construct(&$game){
        $this->game = $game;
    }
    public function takeRes($have, $take){
        $arr = [];
        foreach ($have as $key => $value) {
            $arr[$key] = $value - $take[$key];
        }
        return $arr; 
    }
    public function lacks($have, $take){
        $arr = [];
        foreach ($have as $key => $value) {
            if($value<$take[$key])
                $arr[$key] = $take[$key]-$value;
        }
        return $arr; 
    }
    public function showCost($cost){
        $text = '';
        foreach ($cost as $key => $value) {
            $text .= '<img src="'.$this->game->url.'/img/icons/'.$key.'.png" class="vs" height="25">'.$value.' ';
        }
        return $text;
    }
    public function showLacks($lacks){
        $text = '<span class="red">';
        foreach ($lacks as $key => $value) {
            $text .= '<img src="'.$this->game->url.'/img/icons/'.$key.'.png" class="vs" height="25">'.$value.' ';
        }
        $text .= '</span>';
        return $text;
    }
    public function setTimer($id){
        $query = "UPDATE `map` SET `getResources` = {?} WHERE `id` = {?}";
	    $this->game->db->query($query,[time(), $id]);
    }
    public function plass($id, $res){
        $query = "UPDATE `map` SET `les` = `les` + {?}, `kam` = `kam` + {?} , `zel` = `zel` + {?}, `eda` = `eda` + {?}, `lud` = `lud` + {?} WHERE `id` = {?}";
	    $this->game->db->query($query,[$res["les"], $res["kam"], $res["zel"], $res["eda"], $res["lud"], $id]);
    }
    public function update($id, $res){
        $query = "UPDATE `map` SET `les` = {?}, `kam` = {?}, `zel` = {?}, `eda` = {?}, `lud` = {?} WHERE `id` = {?}";
	    $this->game->db->query($query,[$res["les"], $res["kam"], $res["zel"], $res["eda"], $res["lud"], $id]);
    }
    public function getInvaders($user, $param){
        $query = '
        SELECT  
        sum(`city_map`.les) as les,
        sum(`city_map`.kam) as kam,
        sum(`city_map`.zel) as zel,
        sum(`city_map`.eda) as eda,
        sum(`city_map`.lud) as lud,
        sum(`city_map`.lud_storage) as lud_storage,
        sum(`city_map`.storage) as storage
        FROM `map`
        left JOIN (SELECT id,  city, type, 
                   SUM(IF(type=1, '.$param["increaseInResources"].'*level, 0)) AS les,
                   SUM(IF(type=2, '.$param["increaseInResources"].'*level, 0)) AS kam,
                   SUM(IF(type=3, '.$param["increaseInResources"].'*level, 0)) AS zel,
                   SUM(IF(type=4, '.$param["increaseInResources"].'*level, 0)) AS eda,
                   SUM(IF(type=5, '.$param["populationGrowth"].'*level, 0)) AS lud,
                   SUM(IF(type=5, '.$param["shackSize"].'*level, 0)) AS lud_storage,
                   SUM(IF(type=6, '.$param["storageSize"].'*level, 0)) AS storage
        FROM `build` WHERE `type` >= 1 and `type`<= 6   GROUP BY  `city` ) 
        `city_map` ON `map`.id  = `city_map`.city
        WHERE `map`.invader = {?}';
        return $this->game->db->query($query,[$user])->fetch_assoc();
    }
    public function getMy($city, $param){
        $query = '
        SELECT  
        SUM(IF(type=1, '.$param["increaseInResources"].'*level, 0)) AS les,
        SUM(IF(type=2, '.$param["increaseInResources"].'*level, 0)) AS kam,
        SUM(IF(type=3, '.$param["increaseInResources"].'*level, 0)) AS zel,
        SUM(IF(type=4, '.$param["increaseInResources"].'*level, 0)) AS eda,
        SUM(IF(type=5, '.$param["populationGrowth"].'*level, 0)) AS lud,
        SUM(IF(type=5, '.$param["shackSize"].'*level, 0)) AS lud_storage,
        SUM(IF(type=6, '.$param["storageSize"].'*level, 0)) AS storage
        FROM `build`
        WHERE `build`.city = {?}';
        return $this->game->db->query($query,[$city])->fetch_assoc();
    }
    public function canTake($have){
        foreach ($have as $key => $value)
		    if($value>0)
	            return true;
        
    }
    public function calculateCostUp($level, $price = 1){
        $cost = $level * $price;
        $discount = 100-100*$level/10;//Скидка
        return $cost - ($cost*$discount/100);
    }
    public function getAllStorage($city){
        $query = "SELECT * FROM `build` WHERE `type` =  {?} and  `city` = {?}";
		return $this->game->db->query($query, [6, $city]);
    }
    public function getAllZemliBuild($city){
		$query = "SELECT * FROM `build` WHERE `type` >= 1 and `type`<= 5  and `city` = {?}";
		return $this->game->db->query($query, [$city]);
	}
}