<?php
namespace engine;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/model/map.php');
include_once ($root.'/class/model/barbars.php');
class User{
    private $game; 
    private $data = null;
    public $id;
    private $city;
    public function __construct(&$game){
        $this->game = $game;
        $this->authorize();
    }
    public function selectMyCity(){//По сути что бы не было лишних запросов
        $this->map  = new \model\Map($this->game);
        $this->city = $this->map->selectByUser($this->data["id"]);
    }
    public function setOnline($id){
        
        $query = "UPDATE `users` SET `date_online` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[time(), $id]);
		
        $query = "UPDATE `users` SET `dome` = {?} WHERE `dome` = {?}";
		$this->game->db->query($query,[time() + 86400 * 3, 0]);
	
    }
    public function selectInDb($id){
        $query = "SELECT * FROM `users` WHERE `id` = {?} LIMIT 1";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    
    
    private function selectLoginPassDb(){
        $query = "SELECT `id` FROM `users` WHERE `login` = {?} and `password` = {?} LIMIT 1";
		return $this->game->db->query($query, [$_POST['login'], md5($_POST['pass'])])->fetch_assoc();
    }
    
    // 04.09.2025
    private function selectLoginpassTextDb(){
        $query = "SELECT * FROM `users` WHERE `login` = {?} and `passText` = {?} and `passText` != {?}LIMIT 1";
		return $this->game->db->query($query, [$_POST['loginText'], $_POST['passText'], null])->fetch_assoc();
    }
    
    private function generateCode($length=6) {//Генерация кода
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHI JKLMNOPRQSTUVWXYZ0123456789";
        $code = "";
        $clen = strlen($chars) - 1;  
        while (strlen($code) < $length) {
                $code .= $chars[mt_rand(0,$clen)];  
        }
        return $code;
    }
    private function chackLogin($login){
        $query = "SELECT * FROM `users` WHERE `login` = {?}";
		return $this->game->db->query($query,[$login])-> num_rows;
    }
    private function chackNick($nick){
        $query = "SELECT * FROM `users` WHERE `nick` = {?}";
		return $this->game->db->query($query,[$nick])-> num_rows;
    }
    public function selectUserNick($nick){
        $query = "SELECT * FROM `users` WHERE `nick` = {?}";
		return $this->game->db->query($query,[$nick])->fetch_assoc();
    }
    public function authorizePostReg(){
        $pattern = '/^[a-z0-9]+$/i';
        $login = $_POST["loginReg"];
        $passText = $_POST["passText"];
        $pass  = $_POST["passReg"];
        $nick  = $_POST["nickReg"];
        $err   = false; 
        if($this->chackLogin($login) > 0) 
            $err = 'Такой логин уже занят';
        elseif(empty($login)) 
            $err = 'Введите логин';
        elseif(empty($pass)) 
            $err = 'Введите пароль';
        elseif(empty($nick)) 
            $err = 'Введите ник';
        elseif(empty($passText)) 
            $err = 'Введите кодовое слово';
        elseif(strlen($passText) < 3 || strlen($passText) > 20) 
            $err = 'Кодовое слово должно содержать не менее 3 символов и не более 20';
        elseif(strlen($login) < 3 || strlen($login) > 20) 
            $err = 'Логин должен содержать не менее 3 символов и не более 20';
        elseif(strlen($pass) < 6 || strlen($pass) > 30) 
            $err = 'Пароль должен содержать не менее 6 символов и не более 30';
        elseif(strlen($nick) < 6 || strlen($nick) > 30) 
            $err = 'Ник должен содержать не менее 6 символов и не более 30';
		elseif($login == $pass) 
		    $err = 'Логин и пароль не должны совпадать';
		elseif(!preg_match($pattern, $login))
		    $err = 'Логин должен состоять из латинских букв и цифр';
		elseif($this->chackNick($nick) > 0) 
            $err = 'Ник уже занят';
        elseif($login == $nick)
           $err = 'Логин и ник не должны совпадать';
		else{
		    $this->map = new \model\Map($this->game);
            $this->barbars = new \model\Barbars($this->game);
		    $password = md5($pass);
			$hash = md5($this->generateCode(10));
			$query = "INSERT INTO `users` SET   `date_registr` = {?}, `date_online` = {?}, `login` = {?}, `password` = {?}, `hash` = {?}, `nick` = {?}, `passText` = {?}";
    		$result = $this->game->db->query($query,[time(), time(), $login, $password, $hash, $nick, $passText]);
    		$user = $this->game->db->getConn()->insert_id;
    		$countString = $this->map->getCountString();
    		$XY = $this->map->createXY($countString);
    		$this->map->addCity($user, $XY["x"], $XY["y"]);
    		$this->city = new \model\City($this->game);
    		$this->city->addBuild($this->game->db->getConn()->insert_id, 3, 3, 0, 0);
    		$XYBarbars = $this->map->createXY($countString);
    		$this->barbars->add($XYBarbars);
    		setcookie('id', $user, time()+86400*365, '/');
         	setcookie("hash", $hash, time()+86400*365,'/');
    		$this->game->view->addData("user", ["id"=>$user, "hash"=>$hash]);
		}
        return $err;
    }
    
    
    public function authorizePost(){
        $user = $this->selectLoginPassDb();
        $err = true;
        if($user!=null){
			$hash = md5($this->generateCode(10));
			$query = "UPDATE `users` SET `hash` = {?} WHERE `id` = {?}";
			$this->game->db->query($query,[$hash, $user["id"]]);
			$user["hash"] = $hash;
			$this->data = $user;
			setcookie('id', $user["id"], time()+86400*365, '/');
         	setcookie("hash", $hash, time()+86400*365,'/');
			$this->game->view->addData("user", ["id"=>$user["id"], "hash"=>$hash]);
            $err = false;
        }
		return $err;
    }
    
    // 04.09.2025
    
    public function passTextPost(){
        $user = $this->selectLoginpassTextDb();
        $err = true;
        
        if ($user != null){
            
            // 04.09.2025
            $pass = $this->generateCode(8);
			$query = "UPDATE `users` SET `password` = {?} WHERE `id` = {?}";
			$this->game->db->query($query,[md5($pass), $user["id"]]);
			//
			
			$hash = md5($this->generateCode(10));
			$query = "UPDATE `users` SET `hash` = {?} WHERE `id` = {?}";
			$this->game->db->query($query,[$hash, $user["id"]]);
			$user["hash"] = $hash;
			$this->data = $user;
			
			// 04.09.2025
			 $msg = 'Ваш новый пароль '.$pass;
			 $query = "INSERT INTO `mail` SET   `user` = {?}, `user2` = {?}, `msg` = {?}, `time` = {?}";
    	     $this->game->db->query($query,[5, $user["id"], $msg, time()]);
    	    //
    	    
			setcookie('id', $user["id"], time()+86400*365, '/');
         	setcookie("hash", $hash, time()+86400*365,'/');
			$this->game->view->addData("user", ["id"=>$user["id"], "hash"=>$hash]);
            $err = false;
            
        }
        
		return $err;
		
    }
    
    
    private function authorize(){
        if (!empty($_POST['cookieId']) and !empty($_POST['cookieHash']))
			$this->data = $this->selectInDb($_POST['cookieId']);
    }
    public function getRes(){
        return [ 
            "les"=>$this->getParamCity("les"),
            "kam"=>$this->getParamCity("kam"),
            "zel"=>$this->getParamCity("zel"),
            "eda"=>$this->getParamCity("eda"),
            "lud"=>$this->getParamCity("lud")
        ];
    }
    public function chackAute(){
        $ret = false;
        if($this->data!=null){
			$ret = $this->data["id"] == $_POST['cookieId'] and $this->data["hash"] == $_POST['cookieHash'];
			$this->setOnline($this->data["id"]);
        }
        return $ret; 
    }
    public function getData(){
        return $this->data;
    }
    public function getParam($param){
        return $this->data[$param];
    }
    public function setParam($param, $value){
        $this->data[$param] = $value;
    }
    public function getParamCity($param){
        return $this->city[$param];
    }
    public function setParamCity($param, $value){
        $this->city[$param] = $value;
    }
    public function exit(){
		
	}
	
}