<?php
namespace local\build;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Build extends \engine\Game{
    protected $buildList = [];
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    private function createBuildList(){
        $this->buildList = [
            "townHall",
            "les",
            "kam",
            "zel",
            "eda",
            "lud",
            "storage",
            "staff",
            "barracks",
            "church",
            "diplomat",
            "market",
            "university"
        ];
    }
    public function setType($type){
        if($type == "html"){
            if($this->user->chackAute() != false)
                $this->htmlFormat();
        }
        else{//json
            
        }
        $this->view->setType($type);
        $this->view->echoEver(); 
    }
    private function showJsonBuilds(){
       
    }
    private function chackPost(){
        $this->place = [
            "0_0", "0_1", "0_2", "0_3", "0_4", "0_5", "0_6",
            "1_0", "1_1", "1_2", "1_3", "1_4", "1_5", "1_6",
            "2_0", "2_1", "2_2", "2_3", "2_4", "2_5", "2_6",
            "3_0", "3_1", "3_2", "3_3", "3_4", "3_5", "3_6",
            "4_0", "4_1", "4_2",        "4_4", "4_5", "4_6",
            "5_0", "5_1", "5_2",        "5_4", "5_5", "5_6",
            "6_0", "6_1", "6_2",        "6_4", "6_5", "6_6"
        ];
        $issetPlace = false;
        foreach ($this->place as &$value) {
            if($_POST["x"].'_'.$_POST["y"] == $value){
                $issetPlace = true;
                break;
            }
        }
        if($issetPlace == true )
            $this->search();
        else
            $this->dontFind();
    }
    private function dontFind(){
        $this->html = '<div>Это за пределами города</div>';
    }
    private function search(){
        $this->createBuildList();
        $this->build = new \model\build($this);
        $this->user->selectMyCity();
        $this->buildData = $this->build->getBuildXY($this->user->getParamCity("id"), $_POST["x"], $_POST["y"]);
        if($this->buildData != null){
            $this->selectBuild();
        }
        else
            $this->createBuild();
    }
    private function selectBuild(){
        $name = $this->buildList[$this->buildData["type"]];
        $cname = '\\local\\build\\model\\'.$name;
        $this->modelBuild = new $cname($this);
        $this->modelBuild->setData($this->buildData);
        $this->modelBuild->setImg($name);
        $this->modelBuild->setView();
        $this->html = $this->modelBuild->getView();
    }
    private function createBuild(){
        $script = '
        <script>
            function createBuild(type){
                window.brouser.openPage("'.$this->url.'/html/html/local/build/build.php", {"x": '.$_POST["x"].', "y": '.$_POST["y"].', "type": type}, false);
            }
        </script>';
        $this->view->addScript($script);
        $this->view->addTop("Строительство");
        $this->city = new \model\city($this);
        $result = $this->city->getAllBuild($this->user->getParamCity("id"));
        $this->buildAll = [];
        while($q = $result->fetch_assoc()){
            array_push($this->buildAll, $q["type"]);
        }
        foreach ($this->buildList as $key => $value) {
            $this->parserBuildCreate($key, $value);    
        }
    }
    private function parserBuildCreate($key, $value){
        $name = $value;
        $cname = '\\local\\build\\model\\'.$name;
        $modelBuild = new $cname($this);
        $exist = false;//Существует
        if(in_array($key, $this->buildAll))
            $exist = true;
        $modelBuild->setId($key);
        $modelBuild->setImg($this->buildList[$key]);
        $modelBuild->setCreate($exist);
        $view = $modelBuild->getView();
        if($view != ''){
            if((count($this->buildList)-1) != $key)
                $view .= '<hr>';
            $this->html .= $view;
        }
    }
    public function htmlFormat(){
        $this->html = '';
        $this->chackPost();
        $script = '
        <script>
	        $("#viewPage").append(window.brouser.navigator);
        </script>';
        $this->view->addBody($this->html);
        $this->view->addScript($script);
    }
}