<?php
namespace local\build\model;
class Church extends GeneralModel {
    protected $name = 'Храм';
    protected $view = '';
    protected $description = 'Священное место, где вы можете получить от богов свитки. Количество получаемых свитков зависит от уровня здания.';
    protected $les = 400;
    protected $kam = 400;
    protected $zel = 300;
    protected $eda = 400;
    protected $lud = 100;
    protected $time = 5;
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    protected $page = ["Rituals"];
    public function __construct(&$game){
        $this->game = $game;
    }
    private function setRitualTime($time){
        $query = "UPDATE `map` SET `ritual` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$time, $this->game->user->getParamCity("id")]);
		$this->game->user->setParamCity("ritual", $time);
    }
    private function goRitual(){
        $time = time() + 3600;
		$this->setRitualTime($time);
		$this->setProcessRitual();
    }
    private function setRitualStart(){
        if(isset($_GET["go"]))
            $this->goRitual();
        else{
            $script = '
            <script>
                function goRitual(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Rituals&go", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                }
            </script>';
            $this->game->view->addScript($script);
            $html .= $this->mess.'
            <div class="center">
                <div class="p-5-10 fz20">
        			Помолись богам и получай свитки в дар.<br>
        			Молебен длится <img src="'.$this->game->url.'/img/icons/time.png" class="vs" height="20">1ч.
        		</div>
        		<hr>
        		<div class="p-3-0">
        		    <div class="bottonMini w70 mAuto" onclick=goRitual()>
        		        Молиться
        		    </div>
        	    </div>
    	    </div>
            ';
            $this->game->view->addBody($html);   
        }
    }
    private function setProcessRitual(){
        $html = '
            <div class="p-5-10 fz20 center">
    			Идёт молебен. Осталось: <img src="'.$this->game->url.'/img/icons/time.png" class="vs" height="20">'.$this->game->timer->tl($this->game->user->getParamCity("ritual")-time()).'
    		</div>
        ';
        $this->game->view->addBody($html);   
    }
    private function nailScroll(){
        
        $count  = $this->data["level"];
        $this->mess .= $this->game->view->getButtonBlueGood('Награда', ("Получено: <img src=".$this->game->url."/img/icons/scroll.png class='vs' height='20'>".$count));
        
        $scroll = new \model\Scroll($this->game);
        $scroll->plass($this->game->user->getParamCity("id"), $count);
        $this->setRitualTime($time);
        $this->setRitualStart();
    }
    private function setRitualEnd(){
        if(isset($_GET["pick"]))
            $this->nailScroll();
        else{
            $script = '
                <script>
                    function goPick(){
                        window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Rituals&pick", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                    }
                </script>';
                $this->game->view->addScript($script);
            $html .= $this->mess.'
                <div class="center">
                    <div class="p-5-10 fz20">
            			Молебен завершён, вы можете забрать свитки.
            		</div>
            		<hr>
            		<div class="p-3-0">
            		    <div class="bottonMini w70 mAuto" onclick=goPick()>
            		        Забрать
            		    </div>
            	    </div>
        	    </div>
            ';
            $this->game->view->addBody($html); 
        }
    }
    protected function setPageRituals(){
        $this->game->view->addTop("Ритуалы");
        if($this->game->user->getParamCity("ritual")==0)
            $this->setRitualStart();
        elseif($this->game->user->getParamCity("ritual")>time())
            $this->setProcessRitual();
        else
            $this->setRitualEnd();
    }
    protected function getDiscription(){
        return $this->description.'<br>
        Свитки: <img src="'.$this->game->url.'/img/icons/scroll.png" class="vs" height="25">'.$this->game->user->getParamCity("scroll");
    }
    protected function getBuildBotton(){
        $script = '
            <script>
                function setPageRituals(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Rituals", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        return '
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageRituals()>
		        Ритуалы
		    </div>
	    </div>
        ';
    }
}