<?php
namespace local\build\model;
class University extends GeneralModel {
    protected $name = 'Университет';
    protected $view = '';
    protected $description = 'Занимается обучением ваших легионеров военному делу. Качество обучения зависит от уровня здания.';
    protected $les = 200;
    protected $kam = 200;
    protected $zel = 15;
    protected $eda = 150;
    protected $lud = 30;
    protected $time = 12;
    protected $copy = false;//Запрещено(false) или разрешено(true) копировать
    protected $page = ["Teaching"];
    private $up = [
        "hp"    => "Здоровье",
        "ataka" => "Атака",
        "speed" => "Скорость"
    ];
    public function __construct(&$game){
        $this->game = $game;
    }
    protected function getDiscription(){
        return $this->description;
    }
    private function getСhance($chance){
        if($chance>9)
            $chance = 9;
        $chance *= 10;
        return $chance;
    }
    private function setHtmlTeachingId(){
        $this->game->view->addTop("Обучение");
        $script = '
            <script>
                function goArm(name){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Teaching&id='.$this->armSql["id"].'&up="+name+"", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        $hp     = $this->arm["hp"]*$this->armSql["level"];
        $hpT    = $this->arms->getTeaching($hp, $this->armSql["up_hp"]);
        $ataka  = $this->arm["ataka"]*$this->armSql["level"];
        $atakaT = $this->arms->getTeaching($ataka, $this->armSql["up_ataka"]);
        $speed  = $this->arm["speed"]*$this->armSql["level"];
        $speedT = $this->arms->getTeaching($speed, $this->armSql["up_speed"]);
        $this->html .= '
        <div class="p-5-10 center">
    	    <div onclick=goArm("hp") class="p-3-0">
        		<div class="w100 m1 bottonMini7p">
        		    <div class="btn-link">
        		        <div class="fl p6">
        		            <img src="'.$this->game->getUrl().'/img/arms/param/hp.png" class="vs" height="30px">
        		        </div>
        		        <div class="fl"><b>Здоровье</b></div>
        		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$this->armSql["up_hp"].'ур.</div>
        		    </div>
        		</div>
        	</div>
    	    <div onclick=goArm("ataka") class="p-3-0">
        		<div class="w100 m1 bottonMini7p">
        		    <div class="btn-link">
        		        <div class="fl p6">
        		            <img src="'.$this->game->getUrl().'/img/arms/param/ataka.png" class="vs" height="30px">
        		        </div>
        		        <div class="fl"><b>Атака</b></div>
        		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$this->armSql["up_ataka"].'ур.</div>
        		    </div>
        		</div>
        	</div>
    	    <div onclick=goArm("speed") class="p-3-0">
        		<div class="w100 m1 bottonMini7p">
        		    <div class="btn-link">
        		        <div class="fl p6">
        		            <img src="'.$this->game->getUrl().'/img/arms/param/speed.png" class="vs" height="30px">
        		        </div>
        		        <div class="fl"><b>Скорость</b></div>
        		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$this->armSql["up_speed"].'ур.</div>
        		    </div>
        		</div>
        	</div>
    	    
        </div>';
    }
    private function setIndicator(){
        $this->indicator = '
        <div id="indicator" class="absolute right" style="height: 0px;bottom: 10px; width: 0%">
            <div class="rel">
                <img src="'.$this->game->getUrl().'/img/icons/indicator.png" class="absolute" style="right: -10px" height="50px">
            </div>
        </div>';
    }
    private function testOfSleepLearning(){
        if($this->rand>=$this->chance){
            $this->arms->up($this->armSql["id"], ("up_".$this->nameUp));
            
        }
        $scroll = new \model\Scroll($this->game);
        $scroll->minus($this->game->user->getParamCity("id"), $this->armSql["up_".$this->nameUp]);
    }
    private function setClickUp(){
        if($this->game->user->getParamCity("scroll")>=$this->armSql["up_".$this->nameUp]){
            $this->rand = rand(0, 100);
            $this->testOfSleepLearning();
            $script = '
            <script>
                window.brouser.getLast().w = $("#indicator").width();
                window.brouser.getLast().p = $("#indicator").parent("div").width();
                window.brouser.getLast().speed = window.brouser.getLast().p*0.2/100;
                window.brouser.getLast().wP = 0;
                window.brouser.getLast().rand = '.$this->rand.';
                window.brouser.getLast().update = 10;
                window.brouser.addTimer(()=>{
                    if(((window.brouser.getLast().w/window.brouser.getLast().p)*100)<window.brouser.getLast().rand)
                        draw();
                    else{
                        window.brouser.getLast().delTimer(window.brouser.getLast().timerIndicator);
                        window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Teaching&id='.$this->armSql["id"].'&up='.$this->nameUp.'", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                    }
                }, window.brouser.getLast().update);
                function draw() {
                    let speed = window.brouser.getLast().speed;   
                    let prosent = (window.brouser.getLast().w/window.brouser.getLast().p)*100;
                    window.brouser.getLast().wP += speed;
                    window.brouser.getLast().w += window.brouser.getLast().speed; 
                    $("#indicator").width($("#indicator").width()+speed);
                }
                window.brouser.getLast().timerIndicator = window.brouser.getLast().getLastTimer();
                $("#educate").hide();
            </script>';
            $this->game->view->addScript($script);   
        }
        else{
            $this->game->view->addError('Ошибка', "Не хватает <img src=".$this->game->url."/img/icons/scroll.png class='vs' height='20'>".($this->armSql["up_".$this->nameUp]-$this->game->user->getParamCity("scroll"))." свитков");
        }
    }
    private function setButton(){
        if($this->game->user->getParamCity("scroll")<$this->armSql["up_".$this->nameUp]){
            $this->button = '
                <div class="p-5-10 center fz20">
        	        Не хватает <img src="'.$this->game->getUrl().'/img/icons/scroll.png" class="vs" height="25px">'.($this->armSql["up_".$this->nameUp]-$this->game->user->getParamCity("scroll")).'
        	    </div>';   
        }
        elseif($this->data["level"]<$this->armSql['up_'.$this->nameUp]){
            $this->button = '
            <div class="p-5-10 center fz20">
    	        Уровень университета не позволяет проводить дальнейшее обучение. Улучшите здание.
    	    </div>';  
        }
        else{
            if(isset($_GET["click"]))
                $this->setClickUp();
            $script = '
                <script>
                    function clickUp(){
                        console.log("Нажал");
                        window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Teaching&id='.$this->armSql["id"].'&click&up='.$this->nameUp.'", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'}, false);
                    }
                </script>';
            $this->game->view->addScript($script);
            $this->button = '
                <div class="p-3-0 center">
        	        <div id="educate" class="bottonMini w70 mAuto" onclick=clickUp()>
        		        Обучить <img src="'.$this->game->getUrl().'/img/icons/scroll.png" class="vs" height="20px">'.$this->armSql["up_".$this->nameUp].'
        		    </div>
        	    </div>';   
        }
    }
    private function setHtmlPageUp(){
        $this->nameUp = $_GET["up"];
        $this->chance = $this->getСhance($this->armSql['up_'.$this->nameUp]);
        $this->procent = 100-$this->chance;
        $paramD     = $this->arm[$this->nameUp]+($this->armSql["level"]*($this->arm[$this->nameUp]/10));
        $paramTD    = $this->arms->getTeaching($paramD, $this->armSql["up_".$this->nameUp]);
        $paramTP    = $this->arms->getTeaching($paramD, $this->armSql["up_".$this->nameUp]+1);
        $this->game->view->addTop($this->up[$this->nameUp]);
        // if(isset($_GET["click"]))
        //     $this->setClickUp();
        $this->setButton();
        $this->setIndicator();
        $this->html = '
            <div class="p-5-10 center">
                <div class="p-5-10 bgPanelMini white fz20">
                    <img src="'.$this->game->getUrl().'/img/icons/scroll.png" class="vs" height="25px">'.$this->game->user->getParamCity("scroll").'
                </div>
            </div>
            <hr>
            <div class="p-5-10 left">
                <div class="p-5-10 bgPanelMini white fz20">
                    <div>
                        До: <img src="'.$this->game->getUrl().'/img/arms/param/'.$this->nameUp.'.png" class="vs" height="25px">'.round(($paramD+$paramTD), 1).'
                        <span class="green">
                            (+'.round($paramTD, 1).')
                        </span>
                    </div>
                    <div>
                        После: <img src="'.$this->game->getUrl().'/img/arms/param/'.$this->nameUp.'.png" class="vs" height="25px">'.round(($paramD+$paramTP), 1).'
                        <span class="green">
                            (+'.round($paramTP, 1).')
                        </span>
                    </div>
                    <div>
                        Уровень: <img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="25px">'.$this->armSql["up_".$this->nameUp].'
                    </div>
                    <div>
                        Вероятность: <img src="'.$this->game->getUrl().'/img/icons/rand.png" class="vs" height="25px">'.round((100-$this->chance), 1).'%
                    </div>
                </div>
            </div>
            <hr>
            <div class="p-5-10 center">
                <div class="w100 scale" style="height: 22px;">
                    <div class="rel">
                        <div class="absolute w90 scaleRed" style="height: 22px;width: '.$this->chance.'%;">
                        </div>
                        '.$this->indicator.'
                    </div>
                </div>
            </div>
            '.$this->button.'
        ';
    }
    private function selectUp(){
        if($this->up[$_GET["up"]] != null){
            $this->setHtmlPageUp();
        }
        else{
            $this->game->view->addTop("Ошибка");
            $this->html .= '
            <div class="p-5-10 center">
                Направление не найдено.
            </div>';
        }
    }
    private function setSelectTeachingId(){
        $this->arm = $this->arms->getArmId($this->armSql["type"]);
        if(isset($_GET["up"]))
            $this->selectUp();
        else
            $this->setHtmlTeachingId();
    }
    private function noSearcheArm(){
        $this->game->view->addTop("Легионер");
        $this->html .= '
        <div class="p-5-10 center">
            Легионер не найден 
        </div>';
    }
    private function setPageTeachingId(){
        $this->armSql = $this->arms->getSqlId($this->game->user->getParamCity("id"), $_GET["id"])->fetch_assoc();
        if($this->armSql != null){
            $this->setSelectTeachingId(); 
        }
        else
            $this->noSearcheArm();
    }
    private function setHtmlTeachingAll(){
        $this->game->view->addTop("Выбор легионера");
        $script = '
            <script>
                function goArm(id){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Teaching&id="+id+"", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
                
            </script>';
        $this->game->view->addScript($script);
        $this->armsSql = $this->arms->getSql($this->game->user->getParamCity("id"));
        $this->html = '<div class="p-5-10 center">'; 
        if($this->armsSql->num_rows>0){
            $i = 0;
            while($q = $this->armsSql->fetch_assoc()){
                $i++;
                $this->html .= '
                    <div onclick=goArm('.$q["id"].') class="p-3-0">
                		<div class="w100 m1 bottonMini7p">
                		    <div class="btn-link">
                		        <div class="fl p6">
                		            <img src="'.$this->game->getUrl().'/img/arms/'.$q["type"].'.png" class="vs" height="30px">
                		        </div>
                		        <div class="fl"><b>'.$q["name"].'</b></div>
                		        <div class="fr p1-6"><img src="'.$this->game->getUrl().'/img/icons/level.png" class="vs" height="20px">'.$q["level"].'ур.</div>
                		    </div>
                		</div>
                	</div>';
            }
        }
        else
            $this->html .= '<span class="fz20">Пусто</div>'; 
        $this->html .= '</div>'; 
    }
    protected function setPageTeaching(){
        $this->arms = new \model\Arms($this->game);
        if(isset($_GET["id"]))
            $this->setPageTeachingId();
        else
            $this->setHtmlTeachingAll();
        $this->game->view->addBody($this->html);
    }
    protected function getBuildBotton(){
        $script = '
            <script>
                function setPageTeaching(){
                    window.brouser.openPage("'.$this->game->url.'/html/html/local/build/build.php?page=Teaching", {"x": '.$this->data["x"].', "y": '.$this->data["y"].'});
                }
            </script>';
        $this->game->view->addScript($script);
        return '
        <div class="p-3-0">
		    <div class="bottonMini w70 mAuto" onclick=setPageTeaching()>
		        Обучение
		    </div>
	    </div>
        ';
    }
}