<?php
namespace model;
class Arms{
    private $type = [
        ["name"=>"Мечник", "hp" => 500, "ataka"=> 5, "speed"=> 25, "enemy"=>1],//
        ["name"=>"Лучник", "hp" => 400, "ataka"=> 10, "speed"=> 20, "enemy"=>2],//
        ["name"=>"Копьеносец", "hp" => 300, "ataka"=> 15, "speed"=> 15, "enemy"=>3],//Выходят из засады
        ["name"=>"Колесница", "hp" => 200, "ataka"=> 20, "speed"=> 10, "enemy"=>4],//Разведка, находят войска вражеские
        ["name"=>"Баллиста", "hp" => 100, "ataka"=> 25, "speed"=> 5, "enemy"=>0]
    ];
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getTeaching($value, $teach){
        return $value*($teach*10)/100;
    }
    public function getArmId($id){
        return $this->type[$id];
    }
    public function getAllArms(){
        return $this->type;
    }
    public function getSqlId($city, $id){
        $query = "SELECT * FROM `arms` WHERE `city` = {?} and `id` = {?}";
        return $this->game->db->query($query, [$city, $id]);
    }
    public function getSql($city){
        $query = "SELECT * FROM `arms` WHERE `city` = {?}";
        return $this->game->db->query($query, [$city]);
    }
    public function create($city, $type, $level){
        $query = "INSERT INTO `arms` SET   `city` = {?}, `type` = {?}, `level` = {?}, `name` = {?}";
    	$this->game->db->query($query,[$city, $type, $level, $this->type[$type]["name"]]);
    }
    public function reName($id, $name){
        $query = "UPDATE `arms` SET `name` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$name, $id]);
    }
    public function up($id, $name){
        $query = "UPDATE `arms` SET `".$name."` = `".$name."` + 1 WHERE `id` = {?}";
		$this->game->db->query($query,[$id]);
    }
    public function del($id){
        $query = "DELETE FROM `arms` WHERE  `id` = {?}";
        $this->game->db->query($query, [$id]);
    }
    public function howManyHp($arms){
        $armHp = 0;
        while($q = $arms->fetch_assoc()){
            $startHp = $this->type[$q["type"]]["hp"];
            $hp     = $startHp+($q["level"]*($startHp/10));
            $hpT    = $this->getTeaching($hp, $q["up_hp"]);
            $armHp += $hp+$hpT;
        }
        return $armHp;
    }
    public function getParam($name, $type, $level, $up){
        
        $startParam = $this->type[$type][$name];
        $paramStandart     = $startParam+($level*($startParam/10));
        return floor ($this->getTeaching($paramStandart, $up)+$paramStandart);
    }
}