<?php
namespace model;
class Battle{
    public function __construct(&$game){
        $this->game = $game;
    }
    public function selectArmsDowngrade($cityId){
        $query = "SELECT * FROM `arms` WHERE `city` = {?} and `level` > 1";
        return $this->game->db->query($query, [$cityId]);
    }
    public function setArmsDowngrade($cityId){
        $query = "UPDATE `arms` SET `level` = `level` - 1 WHERE `city` = {?} and `level` > 1";
		$this->game->db->query($query,[$cityId]);
    }
    public function del($id, $time){
        $query = "UPDATE `battle` SET `timer` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$time, $id]);
    }
    public function delState($battleId){
        $query = "DELETE FROM  `battle_state` WHERE `battle` = {?}";
		$this->game->db->query($query,[$battleId]);
    }
    public function delArms($battleId){
        $query = "DELETE FROM  `battle_arms` WHERE `battle` = {?}";
		$this->game->db->query($query,[$battleId]);
    }
    public function delLog($battleId){
        $query = "DELETE FROM  `battle_log` WHERE `battle` = {?}";
		$this->game->db->query($query,[$battleId]);
    }
    public function mapLevelUp($id){
        $query = "UPDATE `map` SET `level` = `level` + 1 WHERE `id` = {?}";
		$this->game->db->query($query,[$id]);
    }
    public function updateHp($id, $hp){
        $query = "UPDATE `battle_state` SET `hp` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$hp, $id]);
    }
    public function updateHpBarbar($id, $hp){
        $query = "UPDATE `map` SET `hp` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$hp, $id]);
    }
    public function scullPlass($id, $scull){
        $query = "UPDATE `alliance` SET `scull` = `scull` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$scull, $id]);
    }
    public function clefPlass($clef, $id){
        $query = "UPDATE `users` SET `clef` = `clef` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$clef, $id]);
    }
    public function goldPlass($gold, $id){
        $query = "UPDATE `users` SET `gold` = `gold` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$gold, $id]);
    }
    public function selectCity($id){
        $query = "SELECT `user`, `invader` FROM `map` WHERE `id` = {?}";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    public function selectCityByUser($userId){
        $query = "SELECT id, user FROM `map` WHERE `user` = {?}";
        return $this->game->db->query($query, [$userId])->fetch_assoc();
    }
    public function searchForBattle($user, $city){
        $query = "SELECT * FROM `battle` WHERE `user` = {?} and `city` = {?} and `timer` = 0";
        return $this->game->db->query($query, [$user, $city])->fetch_assoc();
    }
    public function findDefendersCol($idCity){
        $query = "SELECT count(*) col FROM `crusade` WHERE `city2` = {?} and `reinforcement` = 1";
        return $this->game->db->query($query, [$idCity])->fetch_assoc()["col"];
    }
    public function findDefenders($idCity){
        $query = "SELECT id FROM `crusade` WHERE `city2` = {?} and `reinforcement` = 1 ORDER BY rand() LIMIT 1";
        return $this->game->db->query($query, [$idCity])->fetch_assoc();
    }
    public function selectLog($cityId){
        $query = "SELECT `battle_log`.*, users_log.nick AS nick, users_log.alliance AS alliance
        FROM `battle_log`
        left JOIN (SELECT id, nick, alliance FROM `users`  GROUP BY  `id` ) users_log
		ON `battle_log`.user  = users_log.id
        WHERE `battle_log`.city = {?} ORDER BY id DESC LIMIT 6";
        return $this->game->db->query($query, [$cityId]);
    }
    public function addLog($user, $city, $ataka, $typeArm, $ataka2, $typeArm2){
        $query = "INSERT INTO `battle_log` SET   `user` = {?}, `city` = {?}, `ataka` = {?}, `type_arm` = {?}, `ataka2` = {?}, `type_arm2` = {?} ";
    	$this->game->db->query($query,[$user, $city, $ataka, $typeArm, $ataka2, $typeArm2]);
    }
    public function selectArms($battleId){
        $query = "SELECT `battle_arms`.*, 
        legion.city as city, legion.type as type, legion.up_ataka as up_ataka, legion.level as level 
        FROM `battle_arms` 
        left JOIN (SELECT * FROM `arms`  GROUP BY  `id` ) legion
		ON `battle_arms`.legion  = legion.id
        WHERE `battle_arms`.`battle` = {?} ORDER BY `battle_arms`.`position` ASC";
        return $this->game->db->query($query, [$battleId]);
    }
    public function selectRandLegion($cityId){
        $query = "SELECT * FROM `arms` WHERE `city` = {?} ORDER BY rand() LIMIT 1";
        return $this->game->db->query($query, [$cityId])->fetch_assoc();
    }
    public function createArm($battle, $position, $legion, $luck){
        $query = "INSERT INTO `battle_arms` SET   `battle` = {?}, `position` = {?}, `legion` = {?} , `luck` = {?}";
    	$this->game->db->query($query,[$battle, $position, $legion, $luck]);
    }
    public function updateArm($armId, $legion, $luck){
        $query = "UPDATE `battle_arms` SET `legion` = {?}, `luck` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$legion, $luck, $armId]);
    }
    public function capture($city, $user){
        $query = "UPDATE `map` SET `invader` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$user, $city]);
    }
    public function create($user, $city, $withWhom){
        $query = "INSERT INTO `battle` SET    `user` = {?}, `city` = {?}, `withWhom` = {?}";
    	$this->game->db->query($query,[$user, $city, $withWhom]);
    }
    public function createStatus($battle, $user, $hp){
        $query = "INSERT INTO `battle_state` SET   `battle` = {?}, `user` = {?}, `hp` = {?}";
    	$this->game->db->query($query,[$battle, $user, $hp]);
    }
    public function selectStatus($battle){
        $query = "SELECT * FROM `battle_state` WHERE `battle` = {?}";
        return $this->game->db->query($query, [$battle]);
    }
    public function getUserByCity($city){
        $query = "SELECT `map` .*, user_enemy.nick as nick, user_enemy.id as user_id
		FROM `map` 
		left JOIN (SELECT id, nick FROM `users`  GROUP BY  `id` ) user_enemy
		ON map.user  = user_enemy.id
		WHERE map.`user` = {?}";
        return $this->game->db->query($query, [$city])->fetch_assoc();
    }
    public function showHtmlLegion($ataka, $type, $position = 0){
        return '
        <div class="legion" '.($position != 0?'id="myLegion'.$position:'').'">
            <div class="legion-top goldBottonColor">
                '.$ataka.'
            </div>
            <img src="'.$this->game->url.'/img/arms/'.$type.'.png" class="vs" height="30px">
        </div>';
    }
    public function showHtmlDuel($position, $myAtaka, $myType, $enemyAtaka, $enemyType, $luck, $unknown = false){
        if($unknown)
            $enemyLegion = $this->showHtmlLegion('???', 'unknown');
        else
            $enemyLegion = $this->showHtmlLegion($enemyAtaka, $enemyType);
        $myLegion = $this->showHtmlLegion($myAtaka, $myType, $position);
        return '
        <div class="duel inline-block paddingtb5" onclick=goDuel('.$position.');>
            '.$enemyLegion.'
            <div>
                x'.($luck*0.5).'
            </div>
            <div class="rel">
                <div class="inherit" id="legion'.$position.'">
                    '.$myLegion.'
                </div>
            </div>
        </div>';
    }
    public function showHtmlLogMy($ataka, $type){
        return '<img src="'.$this->game->url.'/img/arms/'.$type.'.png" class="vs" height="30px"><span class="green">'.$ataka.'</span>';
    }
    public function showHtmlLogEnemy($ataka, $type){
        return '<span class="red">'.$ataka.'</span><img src="'.$this->game->url.'/img/arms/'.$type.'.png" class="vs reflection" height="30px"> ';
    }
    public function showHtmlLogId($q){
        $my = '';
        $enemy = '';
        if($this->game->user->getParam("id")==$q["user"]){
            $my = $this->showHtmlLogMy($q["ataka"], $q["type_arm"]);
            $enemy = $this->showHtmlLogEnemy($q["ataka2"], $q["type_arm2"]);
        }
        else{
            $my = $this->showHtmlLogMy($q["ataka2"], $q["type_arm2"]);
            $enemy = $this->showHtmlLogEnemy($q["ataka"], $q["type_arm"]);
        }
        return $my.' x '.$enemy;
    }
    
    public function showHtmlLog($battleId){
        $logSql = $this->selectLog($battleId);
        $log = '';
        if($logSql->num_rows>0){
            while($q = $logSql->fetch_assoc()){
                $log .= '<div>'.$this->showHtmlLogId($q).'</div>';
            }
            return '
            <hr>
            <div class="p-5-10">
                <div class="center bgPanelMini white fz20">
                    <div>
                        Журнал
                    </div>
                    
                    '.$log.'    
                </div>
            </div>';   
        }
        else
            return '';
    }
    public function showHtmlUser($id, $nick, $hp, $ataka, $type = 'def'){
        if($ataka>0)
            $hpMinus = '<span class="red">'.floor($ataka).'</span>';
        if($type=='def')
            $img = '<img src="'.$this->game->url.'/img/icons/reinforcement.png" class="vs" height="30">';
        else
            $img = '<img src="'.$this->game->url.'/img/icons/attack.png" class="vs" height="30">';
        return '
        <div class="p-3-0">
        		<div class="w100 blacPanelRedButton borderRadius5px">
    		        <div class="table w100"> 
						<div class="white row">
							<div class="cell">
							    <div class="p6">
							        '.$img.'
								    <span class="fz20 fBold">'.$nick.'</span>
								</div>
							</div>
							<div class="cell fz20 right vam p6">
							    '.$hpMinus.'
							    <img src="'.$this->game->url.'/img/arms/param/hp.png" class="vs" height="20">'.ceil($hp).'
							</div>
						</div>
					</div>
        		</div>
        	</div>';
    }
    public function getScriptMsgCapture($user){
        return '
        <script>
            function goProfil(){
                window.brouser.openPage("'.$this->game->url.'/html/page/profil.php", {"userId": '.$user.'});
            }
        </script>';
    }
    public function getScriptMsg($user, $city){
        return '
        <script>
            function goProfil(){
                window.brouser.openPage("'.$this->game->url.'/html/page/profil.php", {"userId": '.$user.'});
            }
            function goCity(){
                window.brouser.openPage("'.$this->game->url.'/html/page/city.php", {"cityId": '.$city.'});
            }
        </script>';
    }
}