<?php
namespace model;
class Box{
    public $miniBox = [
        ["name"=>"Древний","price"=>100, "present"=>
            [
                ["name"=>"cristal", "price" => 1, "procent"=>1],
                ["name"=>"gold", "price" => 100, "procent"=>1],
                ["name"=>"gold", "price" => 10, "procent"=>50],
                ["name"=>"clef", "price" => 100, "procent"=>1],
                ["name"=>"clef", "price" => 10, "procent"=>50],
                ["name"=>"scroll", "price" => 10, "procent"=>1],
                ["name"=>"scroll", "price" => 1, "procent"=>50]
            ]
        ],
        ["name"=>"Королевский","price"=>500, "present"=>
            [
                ["name"=>"cristal", "price" => 10, "procent"=>1],
                ["name"=>"cristal", "price" => 5, "procent"=>2],
                ["name"=>"cristal", "price" => 1, "procent"=>50],
                ["name"=>"gold", "price" => 150, "procent"=>1],
                ["name"=>"gold", "price" => 100, "procent"=>2],
                ["name"=>"gold", "price" => 10, "procent"=>50],
                ["name"=>"clef", "price" => 150, "procent"=>1],
                ["name"=>"clef", "price" => 100, "procent"=>2],
                ["name"=>"clef", "price" => 10, "procent"=>50],
                ["name"=>"scroll", "price" => 15, "procent"=>1],
                ["name"=>"scroll", "price" => 10, "procent"=>2],
                ["name"=>"scroll", "price" => 1, "procent"=>50],
            ]
        ],
        ["name"=>"Варварский","price"=>2500, "present"=>
            [
                ["name"=>"cristal", "price" => 15, "procent"=>1],
                ["name"=>"cristal", "price" => 10, "procent"=>3],
                ["name"=>"cristal", "price" => 1, "procent"=>50],
                ["name"=>"gold", "price" => 1500, "procent"=>1],
                ["name"=>"gold", "price" => 1000, "procent"=>3],
                ["name"=>"gold", "price" => 100, "procent"=>50],
                ["name"=>"clef", "price" => 1500, "procent"=>1],
                ["name"=>"clef", "price" => 1000, "procent"=>3],
                ["name"=>"clef", "price" => 100, "procent"=>50],
                ["name"=>"scroll", "price" => 150, "procent"=>1],
                ["name"=>"scroll", "price" => 100, "procent"=>3],
                ["name"=>"scroll", "price" => 10, "procent"=>50]
            ]
        ]
    ];
    public $largeBox = ["name"=>"Имперский","price"=>25000, "present"=>[
            ["name"=>"cristal", "price" => 150, "procent"=>1],
            ["name"=>"cristal", "price" => 100, "procent"=>30],
            ["name"=>"cristal", "price" => 10, "procent"=>50],
            ["name"=>"gold", "price" => 1500, "procent"=>1],
            ["name"=>"gold", "price" => 1000, "procent"=>30],
            ["name"=>"gold", "price" => 100, "procent"=>50],
            ["name"=>"clef", "price" => 1500, "procent"=>1],
            ["name"=>"clef", "price" => 1000, "procent"=>30],
            ["name"=>"clef", "price" => 100, "procent"=>50],
            ["name"=>"scroll", "price" => 150, "procent"=>1],
            ["name"=>"scroll", "price" => 100, "procent"=>30],
            ["name"=>"scroll", "price" => 10, "procent"=>50]
        ]
    ];
    public function setRewar($arr){
        $this->game->user->selectMyCity();
        $textRewarOpen = '';
        foreach ($arr as $key => $value) {
            $rewar = '';
            switch ($value["name"]) {
                case "gold":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/gold.png" class="vs" height="20px"> '.$value["price"];
                    $this->game->modelMarket->plassGold($this->game->user->getParam("id"), $value["price"]);
                    break;
                case "cristal":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/cristal.png" class="vs" height="20px"> '.$value["price"];
                    $this->game->modelMarket->plassCristal($this->game->user->getParam("id"), $value["price"]);
                    break;
                case "clef":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px"> '.$value["price"];
                    $this->game->modelMarket->plassClef($this->game->user->getParam("id"), $value["price"]);
                    break;
                case "scroll":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/scroll.png" class="vs" height="20px"> '.$value["price"];
                    $this->game->modelMarket->plassScroll($this->game->user->getParamCity("id"), $value["price"]);
                    break;
            }
            $textRewarOpen .= $rewar.' ';
        }
        if(count($arr) == 0)
            $textRewarOpen = 'Сундук пуст';
        return $textRewarOpen;
    }
    public function randRewar($arr){
        $goodPresent = [];
        foreach ($arr as $key => $value) {
            $rand = rand(1, 100);
            if($rand<=$value["procent"])
                array_push($goodPresent, $value);
        }
        return $goodPresent;
    }
    
    public function showRewardText($arr){
        $textReward = '';
        foreach ($arr as $key => $value) {
            $rewar = '';
            switch ($value["name"]) {
                case "gold":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/gold.png" class="vs" height="20px"> '.$value["price"];
                    break;
                case "cristal":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/cristal.png" class="vs" height="20px"> '.$value["price"];
                    break;
                case "clef":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px"> '.$value["price"];
                    break;
                case "scroll":
                    $rewar = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/scroll.png" class="vs" height="20px"> '.$value["price"];
                    break;
            }
            $rewar = '
            <div>
                '.$rewar.' <span class="green">('.$value["procent"].'%)</span>
            </div>';
            $textReward .= $rewar;
        }
        return $textReward;
    }
    public function selectLargeByUser($user){
        $query = "SELECT * FROM `box` WHERE `user` = {?}";
        return $this->game->db->query($query, [$user])->fetch_assoc();
    }
    public function selectLarge($user){
        $large = $this->selectLargeByUser($user);
        if($large==null){
            $this->addLarge($user);
            $large = $this->selectLarge($user);
        }
        return $large;
    }
    public function addLarge($user){
        $query = "INSERT INTO `box` SET   `user` = {?}";
    	$this->game->db->query($query,[$user]);
    }
    public function plassBox($id, $plass){
        $query = "UPDATE `box` SET `clef` = `clef` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$plass, $id]);
    }
    public function minusBox($id, $minus){
        echo $id.'<br>';
        echo $minus.'<br>';
        $query = "UPDATE `box` SET `clef` = `clef` - {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$minus, $id]);
    }
    public function getProcent($price, $clef){
        $procent = floor($clef*100/$price);
        if($procent >100)
            $procent = 100;
        return $procent;
    }
    public function __construct(&$game){
        $this->game = $game;
    }
}