<?php

namespace model;
class Map{
    public $cityType = ["CityJunior" => 0, "CityMiddle" => 300, "CitySenior" => 1000];
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getCountString(){
        $query = "SELECT * FROM `map`";
        return $this->game->db->query($query, [])->num_rows;
    }
    public function selectXY($x, $y){
        $query = "
        SELECT `map`.*, 
        `users`.nick AS nick,
        `rating`.sum AS rating,
        IFNULL(`invader_user_rating`.rating, 0)+IFNULL(`rating`.sum, 0) AS user_rating
        FROM `map` 
        LEFT JOIN `users` 
		ON `users`.id = `map`.user 
        left JOIN (SELECT `city`,  sum(level) sum  FROM `build`  GROUP BY  `city` ) `rating` ON `map`.id  = `rating`.city
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON id  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user_rating` ON `map`.user  = `invader_user_rating`.invader 
        WHERE `x` = {?} and `y` = {?} LIMIT 1";
        return $this->game->db->query($query, [$x, $y])->fetch_assoc();
    }
    
    public function selectById($id){
        $query = "
        SELECT `map`.*, 
        `users`.nick AS nick,
        `rating`.sum AS rating,
        IFNULL(`invader_user_rating`.rating, 0)+IFNULL(`rating`.sum, 0) AS user_rating
        FROM `map` 
        LEFT JOIN `users` 
		ON `users`.id = `map`.user 
		
        left JOIN (SELECT `city`,  sum(level) sum  FROM `build`  GROUP BY  `city` ) `rating` ON `map`.id  = `rating`.city
        
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON id  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user_rating` ON `map`.user  = `invader_user_rating`.invader 
        WHERE `map`.id = {?} LIMIT 1";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    public function selectByUser($id){
        $query = "SELECT * FROM `map` WHERE `user` = {?} LIMIT 1";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    
        public function selectByUserId($id){
        $query = "SELECT * FROM `users` WHERE `id` = {?} LIMIT 1";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    
    
    public function addCity($user, $x, $y){
        $query = "INSERT INTO `map` SET   `user` = {?}, `x` = {?}, `y` = {?}";
    	$this->game->db->query($query,[$user, $x, $y]);
    }
    public function selectSector($x1, $y1, $x2, $y2){
        $query = "SELECT `map`.*, `rating`.sum AS rating FROM `map` 
        left JOIN (SELECT `city`,  sum(level) sum  FROM `build`  GROUP BY  `city` ) `rating` ON `map`.id  = `rating`.city
        WHERE `map`.`x` >= {?} and `map`.`y` >= {?} and `map`.`x` <= {?} and `map`.`y` <= {?} ";
        return $this->game->db->query($query,[$x1, $y1, $x2, $y2]);
    }
    public function getXYById($id){
        $userId = intval($id);
	    $userId = $id;
	    $id=ceil($userId/5);
	    $diametr=5;
	    $sektor_senter=ceil(sqrt($id))*ceil(sqrt($id));
	    $result=$id%2;
	    if(!$result==0) {
	        $x_r=ceil(sqrt($id));
	    }
	    else
	    {
	        $x=ceil(sqrt($id));
	        $result_s=$sektor_senter%2;
	        if(!$result_s==0){
	            $x_r=(($sektor_senter-$id)/2)+0.5;
	        }
	        else{
	            $x_r=($sektor_senter-$id)/2;
	        }
	        $x_r=ceil(sqrt($id))-$x_r;
	    }
	    if($result==0) {
	        $y_r=ceil(sqrt($id));
	    }
	    else{
	        $y=ceil(sqrt($id));
	        $result_s=$sektor_senter%2;
	        if(!$result_s==0)
	            $y_r=($sektor_senter-$id)/2;
	        else
	            $y_r=(($sektor_senter-$id)/2)+0.5;
	        $y_r=ceil(sqrt($id))-$y_r;
	    }
	    $uids=$userId%5;//2
	    $x=$x_r*5-$uids;
	    $y=$y_r*5-rand(1,5);
	    if($y<0)
	    	$y *= -1;
	    return ["x"=>$x, "y"=>$y];
    }
    private function findPosition($x, $y){
        $query = "SELECT id FROM `map` WHERE `x` = {?} and `y` = {?} LIMIT 1";
        return $this->game->db->query($query, [$x, $y])->fetch_assoc();
    }
    public function createXY($id){
		$XY = $this->getXYById($id);
		if($this->findPosition($XY["x"], $XY["y"])!=null)
		    $XY = $this->createXY($id+1);
		return $XY;
	}
}