<?php
namespace model;
class News{
    private $dialog = 0;
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getCount(){
        $query = "
        SELECT count(*) col
		FROM `news`";
		return $this->game->db->query($query,[])->fetch_assoc()["col"];
    }
    public function getTheNumberOfUnread($userId){
        $query = "
        SELECT count(*) col
        FROM `news`
        left JOIN (SELECT *  FROM `news_reading` WHERE user = {?} GROUP BY  `news` ) `quest_select_user` ON `news`.id  =`quest_select_user`.news
        WHERE `quest_select_user`.news is NULL ";
		return $this->game->db->query($query, [$userId])->fetch_assoc()["col"];
    }
    public function getList($userId, $start){
        $query = "SELECT news.* ,  IFNULL(`quest_select_user`.col, 0)  AS reading
		FROM `news` 
		left JOIN (SELECT news, count(*) AS col  FROM `news_reading` WHERE user = {?} GROUP BY  `news` ) `quest_select_user` ON `news`.id  =`quest_select_user`.news
		ORDER BY `news`.id DESC LIMIT $start, 10"; 
		return $this->game->db->query($query, [$userId]);
    }
    public function getPosition($id){
        $query = "
        SELECT *
		FROM `support`
		WHERE `user` = {?} and `news` = 1";
		return $this->game->db->query($query,[$id])->fetch_assoc();
    }
    public function selectById($userId, $id){
        $query = "SELECT `news`.*, IFNULL(`quest_select_user`.col, 0)  AS reading  FROM `news` 
        left JOIN (SELECT news, count(*) AS col  FROM `news_reading` WHERE user = {?} GROUP BY  `news` ) `quest_select_user` ON `news`.id  =`quest_select_user`.news
        WHERE `news`.id = {?} LIMIT 1";
        return $this->game->db->query($query, [$userId, $id])->fetch_assoc();
    }
    public function addReading($userId, $newsId){
        $query = "INSERT INTO `news_reading` SET `news` = {?}, `user` = {?}";
    	$this->game->db->query($query,[$newsId, $userId]);
    }
    public function getButtonPanel($id, $name, $select){
        if($select)
            $css = 'redPanelSelect redPanelBack';
        else
            $css = 'redPanelSelectOff redPanelBack';
        return '
        <div class="cell p-5-0 w10 '.$css.'" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/page/news.php?panel='.$name.'&newsId='.$id.'&quot;,{}, false)">
		   <img src="'.$this->game->url.'/img/icons/'.mb_strtolower($name).'.png" class="vs maxH40" >
		</div>';
    }
    public function getCountChat($id){
        $query = "
        SELECT count(*) col
		FROM `news_comments` 
		WHERE `news_comments`.news = {?}";
		return $this->game->db->query($query,[$id])->fetch_assoc()["col"];
    }
    public function getChat($id, $start){
        $query = "
        SELECT `news_comments`.*, `user_comment`.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `news_comments` 
        left JOIN (SELECT invader, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
        GROUP BY  `invader` ) `invader_user` ON `news_comments` .user  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `news_comments` .user  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        left JOIN (SELECT id, nick  FROM `users`  GROUP BY  `id` ) `user_comment` ON `news_comments`.user  =`user_comment`.id
        WHERE `news_comments`.news = {?}
        ORDER BY `news_comments`.id DESC LIMIT $start, 10";
        return $this->game->db->query($query,[$id]);
    }
    public function addComment($user, $news, $text){
        $query = "INSERT INTO `news_comments` SET `news` = {?}, `user` = {?}, `msg` = {?}, `timer`= {?}";
    	$this->game->db->query($query,[$news, $user, $text, time()]);
    }
    public function addNews($user, $name, $msg){
        $query = "INSERT INTO `news` SET `user` = {?}, `name` = {?}, `msg` = {?}, `timer`= {?}";
    	$this->game->db->query($query,[$user, $name, $msg, time()]);
    }
}