<?php
namespace model;
class Present{
    public $type = [
        ["name"=>"Почасовой", "time"=> 3600, "present"=>
            [
                ["name"=>"cristal", "price" => 1, "procent"=>1],
                ["name"=>"gold", "price" => 100, "procent"=>1],
                ["name"=>"gold", "price" => 10, "procent"=>100],
                ["name"=>"clef", "price" => 100, "procent"=>1],
                ["name"=>"clef", "price" => 10, "procent"=>100],
                ["name"=>"scroll", "price" => 10, "procent"=>1],
                ["name"=>"scroll", "price" => 1, "procent"=>100]
            ]
        ],
        ["name"=>"Дневной", "time"=> 86400, "present"=>
            [
                ["name"=>"cristal", "price" => 10, "procent"=>1],
                ["name"=>"cristal", "price" => 5, "procent"=>10],
                ["name"=>"cristal", "price" => 1, "procent"=>100],
                ["name"=>"gold", "price" => 150, "procent"=>1],
                ["name"=>"gold", "price" => 100, "procent"=>10],
                ["name"=>"gold", "price" => 10, "procent"=>100],
                ["name"=>"clef", "price" => 1000, "procent"=>1],
                ["name"=>"clef", "price" => 100, "procent"=>10],
                ["name"=>"clef", "price" => 10, "procent"=>100],
                ["name"=>"scroll", "price" => 100, "procent"=>1],
                ["name"=>"scroll", "price" => 10, "procent"=>10],
                ["name"=>"scroll", "price" => 1, "procent"=>100],
            ]
        ],
        ["name"=>"Недельный", "time"=> 604800, "present"=>
            [
                ["name"=>"cristal", "price" => 150, "procent"=>1],
                ["name"=>"cristal", "price" => 100, "procent"=>30],
                ["name"=>"cristal", "price" => 10, "procent"=>100],
                ["name"=>"gold", "price" => 1500, "procent"=>1],
                ["name"=>"gold", "price" => 1000, "procent"=>30],
                ["name"=>"gold", "price" => 100, "procent"=>100],
                ["name"=>"clef", "price" => 1500, "procent"=>1],
                ["name"=>"clef", "price" => 1000, "procent"=>30],
                ["name"=>"clef", "price" => 100, "procent"=>100],
                ["name"=>"scroll", "price" => 150, "procent"=>1],
                ["name"=>"scroll", "price" => 100, "procent"=>30],
                ["name"=>"scroll", "price" => 10, "procent"=>100]
            ]
        ],
        ["name"=>"Месячный", "time"=> 2592000, "present"=>
            [
                ["name"=>"cristal", "price" => 150, "procent"=>100],
                ["name"=>"cristal", "price" => 100, "procent"=>100],
                ["name"=>"cristal", "price" => 10, "procent"=>100],
                ["name"=>"gold", "price" => 1500, "procent"=>100],
                ["name"=>"gold", "price" => 1000, "procent"=>100],
                ["name"=>"gold", "price" => 100, "procent"=>100],
                ["name"=>"clef", "price" => 1500, "procent"=>100],
                ["name"=>"clef", "price" => 1000, "procent"=>100],
                ["name"=>"clef", "price" => 100, "procent"=>100],
                ["name"=>"scroll", "price" => 150, "procent"=>100],
                ["name"=>"scroll", "price" => 100, "procent"=>100],
                ["name"=>"scroll", "price" => 10, "procent"=>100]
            ]
        ]
    ];
    public function __construct(&$game){
        $this->game = $game;
    }
    public function addPresentSql($user, $id){
        $timer = $this->type[$id]["time"]+time(); 
        $query = "INSERT INTO `present` SET   `user` = {?}, `type`={?} , `timer` = {?}";
    	$this->game->db->query($query,[$user, $id, $timer]);
    }
    public function getPresent($user){
        $query = "SELECT * FROM `present` WHERE `user` = {?} and `timer`>= {?}";
        return $this->game->db->query($query, [$user, time()]);
    }
    private function getPresentText($id, $name, $time){
        if($time!=null)
                $timeText = '<img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/time.png" class="vs" height="20">'.($this->game->timer->tl($time-time()));
            else
                $timeText = '<span class="green">Готово</span>';
        return '
        <div class="p-5-10 fz20">
                <div class="redPanel p-5-10 redPanelBack" onclick="window.brouser.openPage(&quot;'.\engine\Engine::getInstance()->game->url.'/html/page/present.php?openId='.$id.'&quot;,{}, false)">
                    <div class="table w100 tborder10-5"> 
            			<div class="white row">
            				<div class="cell w10">
            				    <div class="p6">
            				        <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/present.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 left vam p6">
            				    '.$name.'
            				</div>
            				<div class="cell fz20 right vam p6 ">
            				    '.$timeText.'
            				</div>
            			</div>
            		</div>
            	</div>
            </div>';
    }
    public function getText($data){
        $text = '';
        foreach ($data as $key => $value) {
            $text .= $this->getPresentText($key, $value["name"], $value["end"]);
        }
        return $text;
    }
    public function getData($sql){
        $sqlData = [];
        while($q = $sql->fetch_assoc()){
            $sqlData[$q["type"]] = $q;
        }
        foreach ($this->type as $key => $value) {
            if($sqlData[$key]!=null)
                $this->type[$key]["end"] = $sqlData[$key]["timer"];
        }
        return $this->type;
    }
}