<?php
namespace model;
class Union{
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getById($id){
        $query = "
        SELECT *
        FROM `alliance`
        WHERE `alliance`.id = {?}";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    public function getPanelUnion($id){
        $query = "
        SELECT COUNT(*) col ,  users.id, sum(IFNULL(city_build.summ, 0)+IFNULL(user_city_invader.rating, 0)) AS rating
        FROM `users`
        left JOIN (SELECT id, user FROM `map`
        GROUP BY  `user` ) user_city
        ON `users`.id  = `user_city`.user 
        
        left JOIN (SELECT city, sum(`level`) summ FROM `build`       
        GROUP BY  `city`) city_build
        ON `user_city`.id  = `city_build`.city 
        
        left JOIN (SELECT id, invader, sum(IFNULL(city_build_invader.summ, 0)) as rating FROM `map`
        
            left JOIN (SELECT city, sum(`level`) summ FROM `build`       
            GROUP BY  `city`) city_build_invader
            ON id  = `city_build_invader`.city            
                   
        GROUP BY  `invader` ) user_city_invader
        ON `users`.id  = `user_city_invader`.invader 
        
        
        
        WHERE `users`.alliance = {?}";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    
    public function getUsers($id, $start){
        $query = "
        SELECT users.id, users.nick , IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `users`.alliance = {?}
        ORDER BY rating DESC LIMIT $start, 10";
        return $this->game->db->query($query, [$id]);
    }
    public function selectStatute($union){
        $query = "
        SELECT *
		FROM `alliance_statute` 
		WHERE alliance = {?}";
		return $this->game->db->query($query,[$union])->fetch_assoc();
    }
    public function getUsersCount($id){
        $query = "
        SELECT count(*) col
		FROM `users` 
		WHERE `users`.alliance = {?}";
		return $this->game->db->query($query,[$id])->fetch_assoc()["col"];
    }
    public function getUsersPosition($id){
        $query = "
        SELECT `users`.id, `users`.nick, `user_position`.name AS name_position, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `users`
        right JOIN (SELECT id, user, name  FROM `alliance_position`  GROUP BY  `user` ) `user_position` ON `users`.id  = `user_position`.user
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `users`.alliance = {?}
        ORDER BY rating DESC ";
        return $this->game->db->query($query, [$id]);
    }
    public function getPositionCount($id){
        $query = "
        SELECT count(*) col
		FROM `users`
		right JOIN (SELECT id, user  FROM `alliance_position`  GROUP BY  `user` ) `user_position` ON `users`.id  = `user_position`.user
		WHERE `users`.alliance = {?}";
		return $this->game->db->query($query,[$id])->fetch_assoc()["col"];
    }
    public function create($name){
        $query = "INSERT INTO `alliance` SET `date_registr` = {?}, `name` = {?}";
    	$this->game->db->query($query,[time(), $name]);
    }
    public function joinTheUnion($name, $union, $user){
        $this->setUser($union, $user);
        $this->setPosition($name, $union, $user);
    }
    public function setPosition($name, $union, $user){
        $query = "INSERT INTO `alliance_position` SET `name` = {?}, `user` = {?}, `alliance` = {?}";
    	$this->game->db->query($query,[$name, $user, $union]);
    }
    public function setUser($union, $user){
        $query = "UPDATE `users` SET `alliance` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$union, $user]);
    }
    public function chackName($name){
        $query = "SELECT count(*) as col FROM `alliance` WHERE `name` = {?}";
        return $this->game->db->query($query, [$name])->fetch_assoc()["col"];
    }
    public function getButtonPanel($id, $name, $select){
        if($select)
            $css = 'redPanelSelect redPanelBack';
        else
            $css = 'redPanelSelectOff redPanelBack';
        return '
        <div class="cell p-5-0 w10 '.$css.'" onclick="window.brouser.openPage(&quot;'.$this->game->url.'/html/page/union.php?panel='.$name.'&quot;,{&quot;unionId&quot;: &quot;'.$id.'&quot;}, false)">
		   <img src="'.$this->game->url.'/img/icons/'.mb_strtolower($name).'.png" class="vs maxH40" >
		</div>';
    }
    public function getPosition($user, $union){
        $query = "SELECT * FROM `alliance_position` WHERE `user` = {?} and `alliance` = {?}";
        return $this->game->db->query($query, [$user, $union])->fetch_assoc();
    }
    public function deleteStatute($union){
        $query = "DELETE FROM `alliance_statute` WHERE `alliance` = {?}";
    	$this->game->db->query($query,[$union]);
    }
    public function deletePosition($union, $user){
        $query = "DELETE FROM `alliance_position` WHERE `alliance` = {?} and `user` = {?}";
    	$this->game->db->query($query,[$union, $user]);
    }
    public function createStatute($union, $text){
        $query = "INSERT INTO `alliance_statute` SET `alliance` = {?}, `text` = {?}";
    	$this->game->db->query($query,[$union, $text]);
    }
    public function getCountNotice($union){
        $query = "SELECT sum(`notice_user`.col) AS col
		FROM `users` 
		left JOIN (SELECT id, user, count(*) col  FROM `notice`  GROUP BY  `user` ) `notice_user` ON `users`.id  = `notice_user`.user
		WHERE `users`.alliance = {?}"; 
        return $this->game->db->query($query, [$union])->fetch_assoc()["col"];
    }
    public function getNotice($union, $start){
        $query = "SELECT `users`.id, `users`.nick ,`notice`.tema AS tema, `notice`.msg AS msg, `notice`.time AS time, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
		FROM `users` 
        RIGHT JOIN notice 
		ON notice.user = users.id
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `users`.alliance = {?}
		ORDER BY `notice`.id DESC LIMIT $start, 10"; 
        return $this->game->db->query($query, [$union]);
    }
    public function getNewsCount($id){
        $query = "
        SELECT count(*) col
		FROM `alliance_news` 
		WHERE `alliance_news`.alliance = {?}";
		return $this->game->db->query($query,[$id])->fetch_assoc()["col"];
    }
    public function getNews($id, $start){
        $query = "
        SELECT `alliance_news`.* , `users`.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `alliance_news`
		LEFT JOIN `users` 
		ON `users`.id = `alliance_news`.user 
        
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `alliance_news`.alliance = {?}
        ORDER BY `alliance_news`.id DESC LIMIT $start, 10";
        return $this->game->db->query($query, [$id]);
    }
    public function createNews($user, $alliance, $name, $text){
        $query = "INSERT INTO `alliance_news` SET `user` = {?}, `alliance` = {?}, `name` = {?}, `msg` = {?}, `time` = {?}";
    	$this->game->db->query($query,[$user, $alliance, $name, $text, time()]);
    }
    public function getNewsId($id, $alliance){
        $query = "
        SELECT `alliance_news`.* , `users`.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `alliance_news`
		LEFT JOIN `users` 
		ON `users`.id = `alliance_news`.user 
        
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `alliance_news`.alliance = {?} and `alliance_news`.id = {?}";
        return $this->game->db->query($query, [$alliance, $id])->fetch_assoc();
    }
    public function getUsersToAppoint($id, $start){
        $query = "
        SELECT users.id, users.nick , IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating, `user_position`.name AS position_name
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        left JOIN (SELECT user, name  FROM `alliance_position`  GROUP BY  `user` ) `user_position` ON `users`.id  = `user_position`.user
        WHERE `users`.alliance = {?}
        ORDER BY rating DESC LIMIT $start, 10";
        return $this->game->db->query($query, [$id]);
    }
    public function getUserIdUnion($userId, $union){
        $query = "
        SELECT users.id
        FROM `users`
        WHERE `users`.alliance = {?} and `users`.id = {?}";
        return $this->game->db->query($query, [$union, $userId])->fetch_assoc();
    }
    public function getUserUnion($user, $union){
        $query = "SELECT count(*) AS col FROM `users` WHERE `id` = {?} and `alliance` = {?}";
        return $this->game->db->query($query, [$user, $union])->fetch_assoc();
    }
    public function showNumberInvitations($user){
        $query = "SELECT count(*) AS col FROM `alliance_invitation` WHERE `user` = {?}";
        return $this->game->db->query($query, [$user])->fetch_assoc()["col"];
    }
    public function showInvitations($user, $start){
        $query = "
        SELECT `alliance_invitation`.*, `alliance_name`.name AS name FROM `alliance_invitation`
        left JOIN (SELECT id, name FROM `alliance`  GROUP BY  `id` ) `alliance_name` ON `alliance_invitation`.alliance  = `alliance_name`.id  
        WHERE `user` = {?}
        ORDER BY id DESC LIMIT $start, 10";
        return $this->game->db->query($query, [$user]);
    }
    public function getInvitationId($id, $user){
        $query = "
        SELECT * FROM `alliance_invitation` WHERE `id` = {?} and `user`={?}";
        return $this->game->db->query($query, [$id, $user])->fetch_assoc();
    }
    public function deleteInvitation($id){
        $query = "DELETE FROM `alliance_invitation` WHERE `id` = {?}";
    	$this->game->db->query($query,[$id]);
    }
    public function countRaids($union){
        $query = "
        SELECT COUNT(*) col
        FROM `map`
        WHERE hp > 0 and type = 'barbar'";
        return $this->game->db->query($query, [])->fetch_assoc()["col"];
    }
    public function getRaids($union, $start){
        $query = "
        SELECT map.id, map.hp, map.level
        FROM `map`
        WHERE hp > 0 and type = 'barbar'
        ORDER BY map.level DESC ,map.hp ASC LIMIT $start, 10";
        return $this->game->db->query($query, []);
    }
}