<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');

function formatSecondsToDHMS($seconds) {
    $days = floor($seconds / (3600 * 24));
    $hours = floor(($seconds % (3600 * 24)) / 3600);
    $minutes = floor(($seconds % 3600) / 60);
    $seconds = $seconds % 60;

    return sprintf("%d д. %02d ч. %02d м. %02d с.", $days, $hours, $minutes, $seconds);
}

class City extends \engine\Game{
    private $html = '  ';
    private $top = 'Карта';
	public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->war = new \model\War($this);
        $this->city = new \model\City($this);
        $this->modelBattle = new \model\Battle($this);
    }
    private function selectHp(){
        if($this->sql["hp"]>0)
        $this->hp = '
        
        
         
        <div>
            Здоровье: <img src="'.$this->getUrl().'/img/arms/param/hp.png" class="vs" height="25">'.$this->sql["hp"].'
        </div>';
    }
    private function selectInvader(){
        if($this->sql["invader"]>0){
            $userInvader = $this->modelUser->getById($this->sql["invader"]);
            $icon = '<img src="'.$this->getUrl().'/img/rank/'.$this->rank->getRank($userInvader["rating"]).'.png" class="vs" height="25">';
            $nick = $userInvader["nick"];
        }
        $this->invader = '
            <div '.($this->sql["invader"]>0?'onclick=goProfilInvader()':'').'>
	            Захватчик: '.($this->sql["invader"]>0?'<span class="textUnder">'.$icon.$nick.'</span>':'-').'
	        </div>
            ';
    }
    private function getTypeCity(){
        $type = 1;
        if($this->sql["rating"] >300 and $this->sql["rating"]<=1000)
            $type = 2;
        elseif($this->sql["rating"] >1000)
            $type = 3;
        return $type;
    }
    private function setCountCrusade(){
        $this->textCrusade = '';
        if($this->user->getParam("alliance")>0){
            $sql = $this->city->getCityCrusadeUnion($this->sql["id"], $this->user->getParam("alliance"), $this->user->getParam("id"));
            $this->textCrusade = $sql["col"].' <span class="green">(Союзники '.$sql["union_col"].')</span>';
        }
        else{
            $sql = $this->city->getCityCrusade($this->sql["id"]);
            $this->textCrusade = $sql["col"];
        }
    }
    private function setRewardScull(){
        if($this->user->getParam("alliance")>0){
            $this->textRewardScull = '<img src="'.$this->getUrl().'/img/icons/scull.png" class="vs" height="25">'.$this->sql["level"].'';
        }
    }
    private function showBarbar(){
        $this->setCountCrusade();
        $this->setRewardScull();
        $this->selectHp();
        $this->setButtonArms();
        $clef = 100 * $this->sql["level"];
        $this->top = 'Варвары';
        $this->html = '
        <script>
            function goMap(){
                window.brouser.game.local.selectMap('.$this->sql["x"].', '.$this->sql["y"].');
                window.brouser.exit();
            }
            function goWar(){
                window.brouser.openPage("'.$this->getUrl().'/html/page/city.php?war", {"x": '.$this->sql["x"].', "y": '.$this->sql["y"].'});
            }
        </script>
        <div class="p-5-10">	
    	    <div class="redPanel redPanelBack">
                
                        
                <div class="p10 center white" onclick=goMap()>
                    <img src="'.$this->getUrl().'/img/map/barbars.png" class="vs" height="100">
                    <div onclick=goMap()>X:'.$this->sql["x"].' Y:'.$this->sql["y"].'</div>
                </div>
    			
			    <div class="hrRed">
			    </div>
			    <div class="p-5-10 blacPanelRedButton white left fz20">
			        '.$this->hp.'
			        <div>
			            Уровень: <img src="'.$this->getUrl().'/img/icons/level.png" class="vs" height="25">'.$this->sql["level"].'
			        </div>
			        <div>
			            Награда: '.$this->textRewardScull.' <img src="'.$this->getUrl().'/img/icons/clef.png" class="vs" height="25">'.$clef.'
			        </div>
			        <div>
			            Походы: <img src="'.$this->getUrl().'/img/icons/attack.png" class="vs" height="25">'.$this->textCrusade.'
			        </div>
			    </div>
			    <div class="hrRed">
			    </div>
    			<div class="p-5-10">
            		
                    <div class="p10-0">
                        '.$this->buttonsArms.'
                    </div>
                </div>
            </div>
        </div>';
    }
    private function showCity(){
        $this->selectHp();
        $this->selectInvader();
        $this->setButtonArms();
        $script = '
            <script>
                function goMap(){
                    window.brouser.game.local.selectMap('.$this->sql["x"].', '.$this->sql["y"].');
                    window.brouser.exit();
                }
                function goWar(){
                    window.brouser.openPage("'.$this->getUrl().'/html/page/city.php?war", {"x": '.$this->sql["x"].', "y": '.$this->sql["y"].'});
                }
                function goProfil(){
                    window.brouser.openPage("'.$this->getUrl().'/html/page/profil.php", {"userId": '.$this->sql["user"].'});
                }
                function goProfilInvader(){
                    window.brouser.openPage("'.$this->getUrl().'/html/page/profil.php", {"userId": '.$this->sql["invader"].'});
                }
            </script>';
        $this->view->addScript($script);
        $this->top = "Город";
        $this->html = '
        <div class="p-5-10">
            
            <div class="redPanel redPanelBack">
                <div class="p10 center white" onclick=goMap()>
                    <img src="'.$this->getUrl().'/img/map/'.$this->getTypeCity().'.png" class="vs" height="100">
                    <div onclick=goMap()>X:'.$this->sql["x"].' Y:'.$this->sql["y"].'</div>
                </div>
    			
    			<div class="hrRed">
			    </div>
			    <div class="p-5-10 blacPanelRedButton white left fz20">
			        <div>
			            Рейтинг: <img src="'.$this->getUrl().'/img/icons/rating.png" class="vs" height="25">'.$this->sql["rating"].'
			        </div>
			        <div>
			            Владелец: 
			            <span class="textUnder" onclick=goProfil()>
			                <img src="'.$this->getUrl().'/img/rank/'.$this->rank->getRank($this->sql["user_rating"]).'.png" class="vs" height="25">'.$this->sql["nick"].'
			            </span>
			        </div>
			        '.$this->invader.'
			        
			    </div>
			    <div class="hrRed">
			    </div>
        		<div class="p10-0">
                    '.$this->buttonsArms.'
                </div>
            </div>
        </div>';
    }
    private function goLoss(){
        $this->user->selectMyCity();
        $this->speed = floor($this->war->getSpeed($this->user->getParamCity("id")));
        $this->timeCrusade = $this->war->getTimeCrusade(["x"=>$this->user->getParamCity("x"), "y"=>$this->user->getParamCity("y")], ["x"=>$this->sql["x"], "y"=>$this->sql["y"]], $this->speed);
        $this->modelBattle->del($this->battle["id"], ($this->timeCrusade+time()));
        $this->modelBattle->delState($this->battle["id"]);
        $this->modelBattle->delArms($this->battle["id"]);
        $this->modelBattle->delLog($this->battle["id"]);
        unset($_GET["loss"]);
        $this->buttonsArms = '';
        $this->setButtonArms();
    }
    private function showLoss(){
        if(isset($_GET["go"]))
            $this->goLoss();
        else{
            $exit = '"window.brouser.openPage(&quot;'.$this->getUrl().'/html/page/city.php&quot;,{&quot;x&quot;: '.$this->sql["x"].', &quot;y&quot;: '.$this->sql["y"].'}, false)"';
            $ok = '"window.brouser.openPage(&quot;'.$this->getUrl().'/html/page/city.php?loss&go&quot;,{&quot;x&quot;: '.$this->sql["x"].', &quot;y&quot;: '.$this->sql["y"].'}, false)"';
            $this->buttonsArms .= $this->view->getButtonQuestion("Внимание", "Вы уверены что хотите сдаться?", $ok, $exit);
        }        
    }
    private function showArmyInBattle(){//В битве
        
        $this->buttonsArms .= '
        <script>
            function goLoss(){
                window.brouser.openPage("'.$this->getUrl().'/html/page/city.php?loss", {"x": '.$this->sql["x"].', "y": '.$this->sql["y"].'}, false);
            }
        </script>
        <div class="p-5-3 fz20 white center">
			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=goWar()>
		        Продолжить битву
		    </div>
        </div>
        <div class="p-5-3 fz20 white center" onclick=goLoss()>
			<div class="redButton w70 mAuto borderRadius10px p10-0">
		        Сдаться
		    </div>
        </div>';
        if(isset($_GET["loss"]))
            $this->showLoss();
    }
    private function showReleaseBattle(){//В битве
        $this->buttonsArms = '
        <div class="p-5-3 fz20 white center">
			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=goWar()>
		        Освободить
		    </div>
        </div>';
    }
    private function showToSeizeBattle(){//В битве
        $this->buttonsArms = '
        <div class="p-5-3 fz20 white center">
			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=goWar()>
		        Захватить
		    </div>
        </div>';
    }
    
    
    private function showAtakaBattle(){//В битве
    
    
    
    
        $this->buttonsArms = '
        <div class="p-5-3 fz20 white center">
			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=goWar()>
		        Нападение 
		    </div>
        </div>';
        
        
    }
    
    
    
    
    private function battleRouterButton(){//Распределить
    
        $this->user->selectMyCity();
        
        
        
        
        if($this->sql["invader"]>0 and $this->sql["invader"]!=$this->user->getParam("id"))
            $this->showReleaseBattle();
        elseif($this->sql["invader"]==0 and $this->sql["id"]!=$this->user->getParamCity("id") and $this->sql["type"] == 'city')
            $this->showToSeizeBattle();
        elseif($this->sql["type"] == 'barbar')
        
        
        
            $this->showAtakaBattle();
            
            
    }
    
    
    
    private function setButtonArms(){
        $this->battle = $this->modelBattle->searchForBattle($this->user->getParam("id"), $this->sql["id"]);
        if($this->battle!=null)
            $this->showArmyInBattle();
        else
            $this->battleRouterButton();
    }
    private function showEmptiness($x, $y){
        
        $_SESSION['city_x'] = $x;
        $_SESSION['city_y'] = $y;
        
        $this->top = "Карта";
        
        $this->html = '
        
                    <script>

                function moveCity(){
                    window.brouser.openPage("'.$this->getUrl().'/html/page/moveCity.php", {});
                }

            </script>
        
        <div class="p-5-10 center">
            Пустое место
		</div>
		
		        <div class="p-5-3 fz20 white center">
			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=moveCity()>
		        Переместить замок сюда 
		    </div>
        </div>
		
		
		';
		
    }
    
    private function selectLegionsCount(){
        $this->legionsMax = $this->city->countLegions($this->user->getParamCity("id"));
        $this->legionsArms = $this->city->countLegionsArms($this->user->getParamCity("id"));
        $this->legionsCrusade = $this->city->countCrusade($this->user->getParam("id"));
    }
    private function showBattle(){
        $this->pageBattle = new \addPage\Battle($this);
        $this->pageBattle->start();
        $this->top = $this->pageBattle->top;
        $this->html = $this->pageBattle->html;
    }
    private function capacityСheck(){
        //Проверяем битву
        //
        $this->battle = $this->modelBattle->searchForBattle($this->user->getParam("id"), $this->sql["id"]);
        if($this->battle!=null)
            $this->showBattle();
        else{
            if($this->legionsCrusade<$this->legionsMax)
                if($this->legionsArms==0)
                    $this->showNoLegionnaireError();
                else
                    $this->showWar();
            else
                $this->showOverflowError();   
        }
    }
    private function showOverflowError(){
        $this->top = "Нападение";
        if($this->legionsMax>0)
            $legions = '
            У вас нет свободных легионов.<br>
            <img src="'.$this->getUrl().'/img/icons/kazarma.png" class="vs" height="50">'.$this->legionsCrusade.'/'.$this->legionsMax;
        else
            $legions = 'Постройте Лагерь';
        $this->html = '
        <div class="p-5-10 center fz20">
            '.$legions.'
        </div>';
    }
    private function showNoLegionnaireError(){
        $this->top = "Нападение";
        $this->html = '
        <div class="p-5-10 center fz20">
            У вас нет легионеров.<br>
        </div>';
    }
    private function barbarHelp(){
        
        $hp = 10000*$this->sql["level"];
        $this->sql["hp"] = $hp;
        $this->modelBattle->updateHpBarbar($this->sql["id"], $this->sql["hp"]);
    }
    private function goCrusade(){
        if($this->sql["invader"]==0 and $this->sql["type"]=='city')
            $withWhom = $this->sql["user"];
        elseif($this->sql["invader"]!=0 and $this->sql["type"]=='city')
            $withWhom = $this->sql["invader"];
        elseif($this->sql["type"]=='barbar'){
            $withWhom = 0;
            if($this->sql["hp"] == 0)
                $this->barbarHelp();
        }
        
        
        
        
        
       // $this->modelBattle->create($this->user->getParam("id"), $this->sql["id"], $withWhom);
        
        $this->modelBattle->create($_COOKIE['id'], $this->sql["id"], $withWhom);
        
        
        
        
        $this->capacityСheck();
    }
    private function showCrusade(){
        
        

        // кто владеет  01.09.2025
        
        if ($this->sql["invader"] == 0)
        {

        $userInvader = $this->modelUser->getByDome($this->sql["user"]);
        $dome = $userInvader["dome"];
        
        }
        else
        {

        $userInvader = $this->modelUser->getByDome($this->sql["invader"]);
        $dome = $userInvader["dome"];
        
        }
        
        //


        // вычисляем если ли у нападавющего купол  02.09.2025
        
        $userIm = $this->modelUser->getByDome($this->user->getParam("id"));
        
        if ($userIm["dome"] > time())
        {


        $js_scr = '    
        

        function goWar(){
        
                if (confirm("Вы лишитесь купола, если нападёте!"))
                {
                    goWar_ok();
                    
                }    else {

                    console.log("Exit goWar");
                    
                }
                
            }
            
            
        function goWar_ok(){
                window.brouser.openPage("'.$this->getUrl().'/html/page/city.php?war&go", {"x": '.$this->sql["x"].', "y": '.$this->sql["y"].'}, false);
            }
            
            
            ';
            
        
        }
        else
        {

        $js_scr = '            function goWar(){
                window.brouser.openPage("'.$this->getUrl().'/html/page/city.php?war&go", {"x": '.$this->sql["x"].', "y": '.$this->sql["y"].'}, false);
            }';
        
        
        }
        
        //
        
        if (time() > $dome)
        $msg_dome = '        			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick=goWar()>
        		        Продолжить
        		    </div>';
        else
        $msg_dome = '			<div>
        		        У игрока действует защита от нападения еще '.formatSecondsToDHMS($dome - time()).'
        		    </div>';
        
        
        
        if (time() > $dome and time() < $userIm["dome"])
        $none = '';
        else
        $none = 'none';
        //        //        //
        
        $this->html = '
        
        <script>
            '.$js_scr.'
        </script>
        
        
        
        
        
        
                <div id="error" class="h100 w100" style="display: '.$none.';"> 
            <div class="center50pros maxWidth400px w100 center">
                <div class="p10">
                    <div class="errorName w100 mAuto p10-0 fz30 ">
                        Внимание
                    </div>
                    <div class="p10-0 errorYellow boderRBottom5px">
                        <div class="p-5-10 errorText fz20">
                            Вы лишитесь купола, если нападёте!
                        </div>
                        <div class="p-3-0">
                            <div class="buttonError w70 mAuto" onclick="goWar_ok()">
                                Продолжить
                            </div>
                        </div>
                        <div class="p-3-0">
                            <div class="bottonMini w70 mAuto" onclick="window.brouser.exit()">
                                Нет
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        



        
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack white ">
                <div class="p-5-10 center fz20">
                    <div>Длительность: <img src="'.$this->getUrl().'/img/icons/time.png" class="vs" height="20">'.$this->timer->tl($this->timeCrusade).'</div>
                    <div>Скрость: <img src="'.$this->getUrl().'/img/arms/param/speed.png" class="vs" height="20">'.$this->speed.' ед.</div>
                </div> 
                
                <div class="p-5-3 fz20 white center">
                    '.$msg_dome.'
                </div>

            </div>
        </div>';
    }
    
    
    private function showWar(){
        $this->top = "Нападение";
        $this->speed = floor($this->war->getSpeed($this->user->getParamCity("id")));
        $this->timeCrusade = $this->war->getTimeCrusade(["x"=>$this->user->getParamCity("x"), "y"=>$this->user->getParamCity("y")], ["x"=>$this->sql["x"], "y"=>$this->sql["y"]], $this->speed);
        if(isset($_GET["go"]))
            $this->goCrusade();
        else
            $this->showCrusade();
    }
    private function setWarSystem(){
        $this->user->selectMyCity();
        $this->selectLegionsCount();
        $this->capacityСheck();
    }
    private function selectPage(){
        if(isset($_GET["war"]))
            $this->setWarSystem();
        elseif($this->sql["type"]== 'barbar')
            $this->showBarbar();
        elseif($this->sql["type"]== 'city')
            $this->showCity();
    }
    private function selectSector(){
        $this->sql = $this->map->selectXY($this->x, $this->y);
        if($this->sql!=null)
            $this->selectPage();
        else
            $this->showEmptiness($this->x, $this->y);
    }
    private function showNotSearch(){
        $this->top = "Ошибка";
        $this->html = '
        <div class="p-5-10 center fz20">
            Город не найден
		</div>';
    }
    private function selectById(){
        $id       = intval($_POST["cityId"]);
        $this->sql = $this->map->selectById($id);
        if($this->sql!=null)
            $this->selectPage();
        else
            $this->showNotSearch();
    }
    private function selectXY(){
        $this->map = new \model\Map($this);
        $this->rank = new \model\Rank($this);
        $this->modelUser = new \model\User($this);
        if(isset($_POST["x"]) and isset($_POST["y"])){
            $this->x = intval($_POST["x"]);
            $this->y = intval($_POST["y"]);
            if($this->x>1000000 or $this->x<0)
                $this->x = 0;
             if($this->y>1000000 or $this->y<0)
                $this->y = 0;  
            $this->selectSector();
        }
        elseif(isset($_POST["cityId"])){
            $this->selectById();
        }
        else{
            $this->showEmptiness($this->x, $this->y);
        }
    }
    public function setView(){
        $this->selectXY();
        $this->view->addTop($this->top);
        $this->view->addScript($this->scripts);
        $this->view->setNavigator();
        $this->view->addBody($this->html);
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}