<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Mail extends \engine\Game{
    private $html = '';
    private $top  = '';
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    
    private function showSent(){
        $this->view->addError("Внимание", "Сообщение отправлено");
    }  
    
    private function addMsg(){
        $this->model->addMsg($this->user->getParam("id"), $this->userRecipient["id"], $this->text);
        $this->showSent();
    }

    private function sendMsg(){
    $this->text = htmlspecialchars($_POST["text"]);
    $msg = '';
    
    // Удаляем все запрещенные слова/символы
    $this->text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $this->text);
    
    // Удаляем все звездочки и пробелы для проверки
    $cleanText = str_replace(['*', ' '], '', $this->text);
    
    if(trim($this->text) == '') {
        $msg = 'Введите сообщение';
    }
    elseif(empty($cleanText)) {
        $msg = 'Сообщение содержит только запрещенные символы';
    }
    elseif(strlen(trim($this->text)) < 3 || strlen($this->text) > 400) {
        $msg = 'Сообщение должно содержать не менее 3 символов и не более 400';
    }
    else {
        $this->addMsg();
        return;
    }
    
    if($msg != '') {
        $this->view->addError("Ошибка", $msg);
    }
}
    
    private function newMail(){
    $this->top = 'Новое сообщение';
    if(isset($_POST["nick"])) {
        $this->userRecipient = $this->user->selectUserNick($_POST["nick"]);
    }
    
    if($this->userRecipient != null && isset($_POST["text"])){
        $this->antiSpamMsg();
    }
    
    if($this->userRecipient == null && isset($_POST["nick"]) && isset($_POST["text"])){
        $this->view->addError("Ошибка", 'Игрок не найден');
    }
    
    $this->html= '
    <script>
        function createMsg(){
            window.brouser.openPage("'.$this->url.'/html/page/mail.php?new", {"nick": $("#nick").val(), "text": $("#text").val()}, false);
        }
        
        function updateCharCounter(textarea) {
            var length = textarea.value.length;
            var maxLength = 400;
            var counter = textarea.nextElementSibling;
            counter.textContent = length + "/" + maxLength;
            counter.style.color = length > maxLength - 50 ? "#d32f2f" : "#666";
        }
    </script>
    <div class="p-5-10 center fz20">
        <div id="mailNew" style="display:none"></div>
        <div class="p-3-0">Кому:</div>
        <input id="nick" type="text" name="nick" value="'.($this->userRecipient!=null?$this->userRecipient["nick"]:'').'" class="form-input w70">
        <div class="p-3-0">Текст:</div>
        <div style="position:relative; display:inline-block; width:70%;">
            <textarea id="text" name="text" class="form-input w70"
                style="padding:8px 25px 8px 8px; border:1px solid #ccc; border-radius:4px; resize:vertical; min-height:100px; font-family:inherit; font-size:inherit; box-sizing:border-box;"
                maxlength="400"
                oninput="updateCharCounter(this)"></textarea>
            <div id="charCounter" 
                style="position:absolute; bottom:10px; right:10px; font-size:12px; pointer-events:none;">
                0/400
            </div>
        </div>
        <br>
        <div class="bottonMini w70 mAuto" onclick="createMsg()">
            Написать
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var textarea = document.querySelector("textarea[name=\'text\']");
            if(textarea) {
                textarea.addEventListener("input", function() {
                    updateCharCounter(this);
                });
            }
        });
    </script>';
}
    
    private function showDialogs(){
        $count = $this->model->countDialog($this->user->getParam("id"));
        $this->top = 'Входящие - '.$count;
        $k_page = \engine\Page::k_page($count, 10);
        $page = \engine\Page::page($k_page);
        $start = 10 * $page - 10;
        $result = $this->model->getPageDialog($this->user->getParam("id"), $start);
        $this->html .= '
        <div class="p-5-10">
        <script>
            function goDialog(id){
                window.brouser.openPage("'.$this->url.'/html/page/mail.php?dialog="+id, {});
            }
        </script>';
        
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $userRank = $this->rank->getRank($q["rating"]);
                $nick = $q["nick"];
                if(strlen($q["msg"]) > 30) 
                    $q["msg"] = mb_strimwidth($q["msg"], 0, 30, '...');
                $this->html .= '
                    <div onclick=goDialog('.$q["id"].') class="p-3-0 white">
                        <div class="w100 bottonMini0p">
                            <div class="btn-link2">
                                <div class="table w100"> 
                                    <div class="white row">
                                        <div class="cell">
                                            <div class="p6">
                                                <img src="'.$this->url.'/img/rank/'.$userRank.'.png" class="vs" height="30">
                                                <span class="fz20">'.$nick.'</span>
                                                <span>'.$this->timer->tl(time()-$q["time"]).'</span>
                                                '.($q["read"]==0?'<span class="green">Новое</span>':'').'
                                                <br>
                                                <span class="fz15">
                                                    '.\engine\Smile::text_msg($q["msg"]).'
                                                </span>
                                            </div>
                                        </div>
                                        <div class="cell fz20 right vam p6" >
                                            <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                ';
            }
        }
        else {
            $this->html .= '<div class="center fz20">Пусто</div>';
        }
        
        $this->html .= '</div>';
        
        if($count >= 11){
            $classPage = new \engine\Page();
            $this->html .= '<hr><div class="p-5-10">'.$classPage->str('/html/page/mail.php?', $k_page, $page).'</div>';   
        }
    }
    
    private function addMsgSql(){
        $this->view->addMessBlue('Сообщение', 'Сообщение отправлено');
        $t = time();
        $antiSpam = $t + 5;
        $this->model->addMsg($this->user->getParam("id"), $this->userRecipient["id"], $this->text);
        $query = "UPDATE `users` SET `antispam` = {?} WHERE `id` = {?}";
        $this->db->query($query, [$antiSpam, $this->user->getParam("id")]);
    }
    
    private function antiSpamError(){
        $this->view->addError("Ошибка", "Анти спам ");
    }
    
    private function antiSpamMsg(){
        if($this->user->getParam("antispam")>time())
            $this->antiSpamError();
        else
            $this->sendMsg();
    }
    
    private function readMsg(){
        if($this->msg["read"]==0){
            $this->model->readMsg($this->msg["id"]);
            $this->msg["read"] = 1;
        }
    }
    
    private function showMsgDialog(){
        $this->smile = new \engine\Smile();
        $this->top = 'Сообщение';
        $this->msg = $this->model->getMsgDialog($this->dialogId);
        $this->readMsg();
        $userRank = $this->rank->getRank($this->msg["rating"]);
        $this->html .= '
        <script>
            function goProfil(id){
                window.brouser.openPage("'.$this->url.'/html/page/profil.php?", {"userId": id});
            }
        </script>
        ';
        $this->html .= '
        <div class="p-5-10">
            <div class="msg white">
                <div class="table w100"> 
                    <div class="white row">
                        <div class="cell fz20">
                            <div onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$this->msg["user"].'})">
                                <img src="'.$this->url.'/img/rank/'.$userRank.'.png" class="vs" height="30">
                                <span class="textUnder fBold">'.$this->msg["nick"].'</span>
                            </div>
                        </div>
                        <div class="cell fz15 right" >
                            '.$this->timer->tl(time()-$this->msg["time"]).'
                        </div>
                    </div>
                </div>
                <div class="fz15 textWrapping">'.\engine\Smile::text_msg($this->msg["msg"]).'</div>
            </div>
        </div>
        <div class="p-5-3 fz20 white center">
            <div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/mail.php?new&quot;,{&quot;nick&quot;: &quot;'.$this->msg["nick"].'&quot;})">
                Ответить
            </div>
        </div>
        ';
    }
    
    private function checkingAccessRights(){
        if($this->model->checkInStockDialog($this->dialogId, $this->user->getParam("id"))>0)
            $this->showMsgDialog();
        else{
            $this->top = 'Ошибка';
            $this->html = '<div class="center fz20">Диалог не найден</div>';
        }
    }
    
    private function showMsg(){
        $this->dialogId = $_GET["dialog"];
        $this->checkingAccessRights();
    }
    
    private function showOutgoing(){
        $count = $this->model->countDialogOutgoing($this->user->getParam("id"));
        $this->top = 'Исходящие - '.$count;
        $k_page = \engine\Page::k_page($count, 10);
        $page = \engine\Page::page($k_page);
        $start = 10 * $page - 10;
        $result = $this->model->getPageDialogOutgoing($this->user->getParam("id"), $start);
        $this->html .= '
        <div class="p-5-10">
        <script>
            function goDialog(id){
                window.brouser.openPage("'.$this->url.'/html/page/mail.php?dialogOutgoing="+id, {});
            }
        </script>';
        
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $userRank = $this->rank->getRank($q["rating"]);
                $nick = $q["nick"];
                if(strlen($q["msg"]) > 30) 
                    $q["msg"] = mb_strimwidth($q["msg"], 0, 30, '...');
                $this->html .= '
                    <div onclick=goDialog('.$q["id"].') class="p-3-0 white">
                        <div class="w100 bottonMini0p">
                            <div class="btn-link2">
                                <div class="table w100"> 
                                    <div class="white row">
                                        <div class="cell">
                                            <div class="p6">
                                                <img src="'.$this->url.'/img/rank/'.$userRank.'.png" class="vs" height="30">
                                                <span class="fz20">'.$nick.'</span>
                                                <span>'.$this->timer->tl(time()-$q["time"]).'</span>
                                                '.($q["read"]==0?'<span class="green">Непрочитанное</span>':'').'
                                                <br>
                                                <span class="fz15">
                                                    '.\engine\Smile::text_msg($q["msg"]).'
                                                </span>
                                            </div>
                                        </div>
                                        <div class="cell fz20 right vam p6" >
                                            <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
            }
        }
        else {
            $this->html .= '<div class="center fz20">Пусто</div>';
        }
        
        $this->html .= '</div>';
        
        if($count >= 11){
            $classPage = new \engine\Page();
            $this->html .= '<hr><div class="p-5-10">'.$classPage->str('/html/page/mail.php?outgoing&', $k_page, $page).'</div>';   
        }
    }
    
    private function showMsgDialogOutgoing(){
        $this->smile = new \engine\Smile();
        $this->top = 'Сообщение';
        $this->msg = $this->model->getMsgDialogOutgoing($this->dialogId);
        $userRank = $this->rank->getRank($this->msg["rating"]);
        $this->html .= '
        <script>
            function goProfil(id){
                window.brouser.openPage("'.$this->url.'/html/page/profil.php?", {"userId": id});
            }
        </script>
        ';
        $this->html .= '
        <div class="p-5-10">
            <div class="msg white">
                <div class="table w100"> 
                    <div class="white row">
                        <div class="cell fz20">
                            <div onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$this->msg["user2"].'})">
                                <img src="'.$this->url.'/img/rank/'.$userRank.'.png" class="vs" height="30">
                                <span class="textUnder fBold">'.$this->msg["nick"].'</span>
                            </div>
                        </div>
                        <div class="cell fz15 right" >
                            '.$this->timer->tl(time()-$this->msg["time"]).'
                        </div>
                    </div>
                </div>
                <div class="fz15 textWrapping">'.\engine\Smile::text_msg($this->msg["msg"]).'</div>
            </div>
        </div>';
    }
    
    private function checkingAccessRightsOutgoing(){
        if($this->model->checkInStockDialogOutgoing($this->dialogId, $this->user->getParam("id"))>0)
            $this->showMsgDialogOutgoing();
        else{
            $this->top = 'Ошибка';
            $this->html = '<div class="center fz20">Диалог не найден</div>';
        }
    }
    
    private function showMsgOutgoing(){
        $this->dialogId = $_GET["dialogOutgoing"];
        $this->checkingAccessRightsOutgoing();
    }
    
    private function start(){
        if(isset($_GET["new"]))
            $this->newMail();
        elseif(isset($_GET["dialog"]))
            $this->showMsg();
        elseif(isset($_GET["outgoing"]))
            $this->showOutgoing();
        elseif(isset($_GET["dialogOutgoing"]))
            $this->showMsgOutgoing();
        else
            $this->showDialogs();
    }
    
    public function setView(){
        $this->model = new \model\Mail($this);
        $this->rank = new \model\Rank($this);
        $this->start();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}