<?php
namespace page;

function formatSecondsToDHMS($seconds) {
    $days = floor($seconds / (3600 * 24));
    $hours = floor(($seconds % (3600 * 24)) / 3600);
    $minutes = floor(($seconds % 3600) / 60);
    $seconds = $seconds % 60;

    return sprintf("%d д. %02d ч. %02d м. %02d с.", $days, $hours, $minutes, $seconds);
}

$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Market extends \engine\Game{
    private $html = '';
    private $top  = 'Магазин';
    private $indexPage = [
        ['url'=>'cristal', 'icon'=>'cristal', 'name'=> 'Кристаллы'],
        ['url'=>'gold', 'icon'=>'gold', 'name'=> 'Золото'],
        ['url'=>'scroll', 'icon'=>'scroll', 'name'=> 'Свитки'],
        ['url'=>'clef', 'icon'=>'clef', 'name'=> 'Ключи'],
        ['url'=>'cupol', 'icon'=>'cupol', 'name'=> 'Купол'],
        ['url'=>'builder', 'icon'=>'builder', 'name'=> 'Строитель']
    ];
    
    private $scroll = [
        ["amount" => 5,  "price"=> 500, "discount"=> 5],
        ["amount" => 20,  "price"=> 2000, "discount"=> 10],
        ["amount" => 60,  "price"=> 6000, "discount"=> 15],
        ["amount" => 100, "price"=> 10000, "discount"=> 20],
    ];
    private $clef = [
        ["amount" => 300, "price"=> 30, "discount"=> 10],
        ["amount" => 1700,  "price"=> 170, "discount"=> 15],
        ["amount" => 8000,  "price"=> 800, "discount"=> 35],
        ["amount" => 25000,  "price"=> 2500, "discount"=> 65],
    ];
    private $gold = [
        ["amount" => 100, "price"=> 29, "discount"=> 200, "sale"=> 0],
        ["amount" => 500,  "price"=> 75, "discount"=> 1000, "sale"=> 0],
        ["amount" => 1000,  "price"=> 149, "discount"=> 2000, "sale"=> 0],
        ["amount" => 2000,  "price"=> 229, "discount"=> 4000, "sale"=> 0],
        ["amount" => 3000,  "price"=> 379, "discount"=> 6000, "sale"=> 0],
        ["amount" => 7000,  "price"=> 749, "discount"=> 14000, "sale"=> 0],
        ["amount" => 15000,  "price"=> 999, "discount"=> 30000, "sale"=> 0],
    ];
    
    // Добавляем варианты для купола
    private $cupol = [
        ["duration" => 24, "price"=> 25, "discount"=> 0, "name"=> "24 часа"],
        ["duration" => 168, "price"=> 125, "discount"=> 20, "name"=> "7 дней"],
        ["duration" => 720, "price"=> 400, "discount"=> 40, "name"=> "30 дней"],
    ];
    
    // Добавляем варианты для строителя
    private $builder = [
        ["duration" => 24, "price"=> 35, "discount"=> 0, "name"=> "24 часа"],
        ["duration" => 168, "price"=> 150, "discount"=> 25, "name"=> "7 дней"],
        ["duration" => 720, "price"=> 500, "discount"=> 45, "name"=> "30 дней"],
    ];

    private $payments = [
        1 => [
            'name' => 'ЮMoney',
            'key' => 'yoomoney',
            'img' => 'iomoney_icon_color_examlpe.png'
        ],[
            'name' => 'Payeer',
            'key' => 'payeer',
            'img' => 'payeer.png'
        ],
    ];

    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Market($this);
        $this->modelDiscount = new \model\Discount($this);
        $this->modelTreasury = new \model\Treasury($this);
        $this->modelWorldKassa = new \model\WorldKassa($this);
    }
    
    // Методы для купола
    private function buyCupolOk($key, $discount){
        $duration_hours = $this->cupol[$key]["duration"];
        $this->user->selectMyCity();
        
        // Активируем защиту купола
        //$this->model->activateCupol($this->user->getParamCity("id"), $duration_hours);
        
        $this->model->activateCupol($this->user->getParam("id"), $duration_hours);
        
        // Списываем кристаллы
        $this->model->minusCristal($this->user->getParam("id"), $discount);
        $this->user->setParam("cristal", ($this->user->getParam("cristal")-$discount));
        
        $this->buttonsCupol .= $this->model->goodBuy('Покупка', 'Вы активировали купол на '.$this->cupol[$key]["name"], 'Хорошо');
    }
    
    private function buyCupol($key, $discount){
        if($this->user->getParam("cristal") >= $discount)
            $this->buyCupolOk($key, $discount);
        else
            $this->buttonsCupol .= $this->model->error('Ошибка', 'Вам не хватает <img src="'.$this->url.'/img/icons/cristal.png" class="vs" height="20px">'.($discount-$this->user->getParam("cristal")), 'Хорошо');
    }
    
    private function getButtonsPageCupol(){
        $this->buttonsCupol .= '
        <script>
            function buyCupol(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?cupol&cupolId="+id, {}, false);
            }
        </script>';
        
        foreach ($this->cupol as $key => $value) {
            $discount = $value["price"] - $value["price"] * $value["discount"] / 100;
            
            if(isset($_GET["cupolId"]) and $_GET["cupolId"] == $key)
                $this->buyCupol($key, $discount);
                
            $this->buttonsCupol .= $this->model->getButtonCupol($key, "cupol", $value["name"], $value["price"], $discount);
        }
    }
    
    private function showCupol(){
    $this->top = 'Купол';
    $this->getButtonsPageCupol();

    if ($this->user->getParam("dome") > time()) {
        $dome_im = '
        <div class="p-5-10">
            <div class="redPanel p-5-10 redPanelBack">
                <div class="table w100 tborder10-5"> 
                    <div class="white row">
                        <div class="cell w10">
                            <div class="p6">
                                <img src="'.$this->url.'/img/icons/cupol.png" class="vs" height="30">
                            </div>
                        </div>
                        <div class="cell fz16 left vam p6">
                            <img src="'.$this->url.'/img/icons/time.png" class="vs" height="20">
                            '.formatSecondsToDHMS($this->user->getParam("dome") - time()).'
                        </div>
                        <div class="cell fz16 right vam p6 green">
                            <b>У Вас активирован "Купол"</b>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
    } else {
        $dome_im = '';
    }
    
    $this->html = $this->modelTreasury->getPanelCristal().'
    <div class="p-5-10">
        '.$dome_im.'
        '.$this->buttonsCupol.'
    </div>';
}
    
    // Методы для строителя
    private function buyBuilderOk($key, $discount){
        $duration_hours = $this->builder[$key]["duration"];
        
        // Активируем дополнительного строителя
        $this->model->activateBuilder($this->user->getParam("id"), $duration_hours);
        
        // Списываем кристаллы
        $this->model->minusCristal($this->user->getParam("id"), $discount);
        $this->user->setParam("cristal", ($this->user->getParam("cristal")-$discount));
        
        $this->buttonsBuilder .= $this->model->goodBuy('Покупка', 'Вы активировали строителя на '.$this->builder[$key]["name"], 'Хорошо');
    }
    
    private function buyBuilder($key, $discount){
        if($this->user->getParam("cristal") >= $discount)
            $this->buyBuilderOk($key, $discount);
        else
            $this->buttonsBuilder .= $this->model->error('Ошибка', 'Вам не хватает <img src="'.$this->url.'/img/icons/cristal.png" class="vs" height="20px">'.($discount-$this->user->getParam("cristal")), 'Хорошо');
    }
    
    private function getButtonsPageBuilder(){
        $this->buttonsBuilder .= '
        <script>
            function buyBuilder(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?builder&builderId="+id, {}, false);
            }
        </script>';
        
        foreach ($this->builder as $key => $value) {
            $discount = $value["price"] - $value["price"] * $value["discount"] / 100;
            
            if(isset($_GET["builderId"]) and $_GET["builderId"] == $key)
                $this->buyBuilder($key, $discount);
                
            $this->buttonsBuilder .= $this->model->getButtonBuilder($key, "builder", $value["name"], $value["price"], $discount);
        }
    }
    
    private function showBuilder(){
        $this->top = 'Дополнительный строитель';
        $this->getButtonsPageBuilder();
        

    if ($this->user->getParam("builder_end_time") > time()) {
        $builder_end_time_im = '
        <div class="p-5-10">
            <div class="redPanel p-5-10 redPanelBack">
                <div class="table w100 tborder10-5"> 
                    <div class="white row">
                        <div class="cell w10">
                            <div class="p6">
                                <img src="'.$this->url.'/img/icons/builder.png" class="vs" height="30">
                            </div>
                        </div>
                        <div class="cell fz16 left vam p6">
                            <img src="'.$this->url.'/img/icons/time.png" class="vs" height="20">
                     <small>       '.formatSecondsToDHMS($this->user->getParam("builder_end_time") - time()).'</small>
                        </div>
                        <div class="cell fz16 right vam p6 green">
                         <small>   <b>У Вас активирован "Строитель"</b></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
    } else {
        $builder_end_time_im = '';
    }
    
        $this->html = $this->modelTreasury->getPanelCristal().'
        <div class="p-5-10">
        
       '.$builder_end_time_im.'
        
            '.$this->buttonsBuilder.'
        </div>';
    }

    private function buyScrollOk($key, $discount){
        $this->user->selectMyCity();
        $this->model->plassScroll($this->user->getParamCity("id"), $this->scroll[$key]["amount"]);
        $this->model->minusGold($this->user->getParam("id"), $discount);
        $this->user->setParam("gold", ($this->user->getParam("gold")-$discount));
        $this->user->setParamCity("scroll", ($this->user->getParamCity("scroll")+$this->scroll[$key]["amount"]));
        $this->buttonsScroll .= $this->model->goodBuy('Покупка', 'Вы получили <img src="'.$this->url.'/img/icons/scroll.png" class="vs" height="20px">'.($this->scroll[$key]["amount"]), 'Хорошо');
    }
    private function buyScroll($key, $discount){
        if($this->user->getParam("gold") >= $discount)
            $this->buyScrollOk($key, $discount);
        else
            $this->buttonsScroll .= $this->model->error('Ошибка', 'Вам не хватает <img src="'.$this->url.'/img/icons/gold.png" class="vs" height="20px">'.($discount-$this->user->getParam("gold")), 'Хорошо');
    }
    private function getButtonsPageScroll(){
        $this->buttonsScroll .= '
        <script>
            function buyScroll(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?scroll&scrollId="+id, {}, false);
            }
        </script>';
        foreach ($this->scroll as $key => $value) {
            $discount = $value["price"]- $value["price"]*$value["discount"]/100;
            if(isset($_GET["scrollId"]) and $_GET["scrollId"]==$key)
                $this->buyScroll($key, $discount);
            $this->buttonsScroll .= $this->model->getButtonScroll($key, "scroll", $value["amount"], $value["price"], $discount);
        }
    }
    private function getButtonsPageClef(){
        $this->buttonsClef .= '
        <script>
            function buyClef(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?clef&clefId="+id, {}, false);
            }
        </script>';
        foreach ($this->clef as $key => $value) {
            $discount = round($value["price"]- $value["price"]*$value["discount"]/100);
            if(isset($_GET["clefId"]) and $_GET["clefId"]==$key)
                $this->buyClef($key, $discount);
            $this->buttonsClef .= $this->model->getButtonClef($key, "clef", $value["amount"], $value["price"], $discount);
        }
    }
    private function getButtonsPageIndex(){
        foreach ($this->indexPage as $key => $value) {
             $this->buttonsIndex .= $this->model->getButton($value["url"], $value["icon"], $value["name"]);
        }
    }
    private function showIndex(){
        $this->getButtonsPageIndex();
        $this->html = $this->modelTreasury->getPanelIndex().'
        <div class="p-5-10">
            '.$this->buttonsIndex.'
        </div>';
    }
    private function showScroll(){
        $this->top = 'Свитки';
        $this->getButtonsPageScroll();
        $this->html = $this->modelTreasury->getPanelGoldAndScroll().'
        <div class="p-5-10">
            '.$this->buttonsScroll.'
        </div>';
    }
    private function showPresent(){
        $this->top = 'Подарки';
    }
    private function buyClefOk($key, $discount){
        $this->user->selectMyCity();
        $this->model->plassClef($this->user->getParam("id"), $this->clef[$key]["amount"]);
        $this->model->minusCristal($this->user->getParam("id"), $discount);
        $this->user->setParam("cristal", ($this->user->getParam("cristal")-$discount));
        $this->user->setParam("clef", ($this->user->getParam("clef")+$this->clef[$key]["amount"]));
        $this->buttonsClef .= $this->model->goodBuy('Покупка', 'Вы получили <img src="'.$this->url.'/img/icons/clef.png" class="vs" height="20px">'.($this->clef[$key]["amount"]), 'Хорошо');
    }
    private function buyClef($key, $discount){
        if($this->user->getParam("cristal") >= $discount)
            $this->buyClefOk($key, $discount);
        else
            $this->buttonsClef .= $this->model->error('Ошибка', 'Вам не хватает <img src="'.$this->url.'/img/icons/cristal.png" class="vs" height="20px">'.($discount-$this->user->getParam("cristal")), 'Хорошо');
    }
    private function showClef(){
        $this->top = 'Ключи';
        $this->getButtonsPageClef();
        $this->html = $this->modelTreasury->getPanelClefAndCristal().'
        <div class="p-5-10">
            '.$this->buttonsClef.'
        </div>';
    }
    private function buyGoldOk($key){
        $this->model->plassGold($this->user->getParam("id"), $this->gold[$key]["discount"]);
        $this->model->minusCristal($this->user->getParam("id"), $this->gold[$key]["price"]);
        $this->user->setParam("cristal", ($this->user->getParam("cristal")-$this->gold[$key]["price"]));
        $this->user->setParam("gold", ($this->user->getParam("gold")+$this->gold[$key]["discount"]));
        $this->buttonsGold .= $this->model->goodBuy('Покупка', 'Вы получили <img src="'.$this->url.'/img/icons/gold.png" class="vs" height="20px">'.($this->gold[$key]["discount"]), 'Хорошо');
    }
    private function buyGold($key){
        if($this->user->getParam("cristal") >= $this->gold[$key]["price"])
            $this->buyGoldOk($key);
        else
            $this->buttonsGold .= $this->model->error('Ошибка', 'Вам не хватает <img src="'.$this->url.'/img/icons/cristal.png" class="vs" height="20px">'.($this->gold[$key]["price"]-$this->user->getParam("cristal")), 'Хорошо');
    }
    private function setDiscontGold(){
        $result = $this->modelDiscount->getAll($this->user->getParam("id"));
        while($q = $result->fetch_assoc()){
            $this->gold[$q["level"]]["sale"] =  $q["reward_gold"];
            $this->gold[$q["level"]]["price"] = floor($this->gold[$q["level"]]["price"] * $q["reward_gold"] / 100);
        }
    }
    private function showGold(){
        $this->top  = 'Золото';
        $this->buttonsGold .= '
        <script>
            function buyGold(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?gold&goldId="+id, {}, false);
            }
        </script>';
        $this->setDiscontGold();
        foreach ($this->gold as $key => $value) {
            if(isset($_GET["goldId"]) and $_GET["goldId"]==$key)
                $this->buyGold($key);
            $this->buttonsGold .= $this->model->getButtonGold($key, $value["amount"], $value["price"], $value["discount"], $value["sale"]);
        }
        $this->html = $this->modelTreasury->getPanel().'
        <div class="p-5-10">
            '.$this->buttonsGold.'
        </div>';
    }
    private function buyCristal($key, $count){
        $searchKey = $key ?? null;

        if ($searchKey !== null && in_array($searchKey, array_column($this->payments, 'key'), true) && array_key_exists($count, $this->modelWorldKassa->cristal)) {
            $id_hash = uniqid();

            switch ($key) {
                case 'yoomoney':
                    $form_data = [
                        'receiver' => $this->modelWorldKassa->walletYoo,
                        'quickpay-form' => 'button',
                        'paymentType' => 'AC',
                        'sum' => $count,
                        'label' => $id_hash,
                        'successURL' => 'https://' . $_SERVER['HTTP_HOST'] . '/pay?success'
                    ];
                    $redirect = 'https://yoomoney.ru/quickpay/confirm';
                    break;
                case 'payeer':
                    $desc = base64_encode('Покупка кристаллов №' . $id_hash);
                    $m_amount = number_format($count, 2, '.', '');
                    $arHash = [
                        $this->modelWorldKassa->idShopPayeer, $id_hash, $m_amount, 'RUB', $desc
                    ];
                    $key_params = $this->modelWorldKassa->keyShopPayeer;
                    $arHash[] = $key_params;
                    $sign = strtoupper(hash('sha256', implode(':', $arHash)));
                    $form_data = [
                        'm_shop' => $this->modelWorldKassa->idShopPayeer,
                        'm_orderid' => $id_hash,
                        'm_amount' => $m_amount,
                        'm_curr' => 'RUB',
                        'm_desc' => $desc,
                        'm_sign' => $sign,
                        'm_process' => 'send',
                    ];
                    $redirect = 'https://payeer.com/merchant/';
                    break;
            }

            if (!empty($redirect)) {
                $this->modelWorldKassa->add($this->user->getParam("id"), $id_hash, $count, $key);
            }
            
            
            $_SESSION['market'] = $redirect . '?' . http_build_query($form_data);
            
            echo '<script>
                window.brouser.openPage("'.$this->url.'/html/page/go.php", {}, false);
		    </script>';
		    
            /*
            echo '<script>
                window.brouser.openPage("'.$this->url.'/html/page/market.php?cristal", {}, false);
		        window.open("' . $redirect . '?' . http_build_query($form_data) . '");
		    </script>';
		    */
		    
		    
        }
        die;
    }
    private function showCristal(){
        $this->top  = 'Кристаллы';
        $this->buttonsCristal .= '
        <script>
            function buyCristal(id){
                window.brouser.openPage("'.$this->url.'/html/page/market.php?cristal&cristalId="+id, {}, false);
            }
        </script>';
        foreach ($this->modelWorldKassa->cristal as $key => $value) {
            $this->buttonsCristal .= $this->model->getButtonCristal($key, $key);
        }
        $this->html = $this->modelTreasury->getPanelCristal().'
        <div class="p-5-10">
            '.$this->buttonsCristal.'
        </div>';
    }

    private function showPriceId($price) {
        if (array_key_exists($price, $this->modelWorldKassa->cristal)) {
            $this->top = 'Покупка кристаллы: ' . $price . ' <img src="' . $this->game->url . '/img/icons/cristal.png" class="vs" height="30">';
        }

        $buttonsIndex = null;

        foreach ($this->payments as $payment ) {
            $buttonsIndex .= '<div onclick=window.brouser.go("'.$this->game->url.'/html/page/market.php?key='.$payment['key'].'&count=' . $price . '") class="p-3-0">
        		<div class="w100 m1 bottonMini7p">
        		    <div class="btn-link">
        		        <div class="fl p6">
        		            <img src="'.$this->game->url.'/img/icons/'.$payment['img'] . '" class="vs" height="30">
        		        </div>
        		        
        		        <div class="fl">
        		        <b>'.$payment['name'].'</b>
        		        </div>
        		    </div>
        		</div>
        	</div>';
        }
        $this->html = $this->modelTreasury->getPanelCristal().'
        <div class="p-5-10">
            '.$buttonsIndex.'
        </div>';
    }

    private function start(){
        if (!empty($_GET['key']) && !empty($_GET['count'])) {
            $this->buyCristal($_GET['key'], $_GET['count']);
        } else if(isset($_GET["scroll"]))
            $this->showScroll();
        elseif(isset($_GET["clef"]))
            $this->showClef();
        elseif(isset($_GET["gold"]))
            $this->showGold();
        elseif(isset($_GET["cristal"])) {
            if (!empty($_GET["cristalId"])) {
                $this->showPriceId($_GET["cristalId"]);
            } else {
                $this->showCristal();
            }
        }
        elseif(isset($_GET["cupol"]))
            $this->showCupol();
        elseif(isset($_GET["builder"]))
            $this->showBuilder();
        else    
            $this->showIndex();
    }
    
    public function setView(){
        $this->start();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}