<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class News extends \engine\Game{
    private $html = '';
    private $top  = '';
    private $panel = [
        'News', 
        'Chat'
    ];
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    private function showErrorIdNews(){
        $this->top = 'Ошибка';
        $this->html = '<div class="p-5-10 center ">Новость не найдена</div>';
    }
    private function chackIdNews(){
        $this->sql = $this->model->selectById($this->user->getParam("id"), $_GET["newsId"]);
        if($this->sql!=null)
            $this->showIdNews();
        else
            $this->showErrorIdNews();
    }
    private function getNews(){
        $this->top = $this->sql["name"];
        if($this->sql["reading"]==0)
            $this->model->addReading($this->user->getParam("id"), $this->sql["id"]);
        $this->page = '
        <div class="white">
            <div class="p-5-10 left fz20">
                '.$this->sql["msg"].'
            </div>
        </div>';
    }
    private function addMsg(){
        $text = $_POST["text"];
        $text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $text);
        $msg = '';
        
        if(trim($text) != ''){
            if(empty(trim($text))) {
                $msg = 'Комментарий содержит только запрещенные символы';
            }
            elseif(strlen(trim($text)) < 2 || strlen($text) > 1000) {
                $msg = 'Комментарий должен содержать не менее 2 символов и не более 1000';
            }
            else {
                $this->model->addComment($this->user->getParam("id"),$this->sql["id"], $text);
                return;
            }
        }
        else {
            $msg = 'Введите комментарий';
        }
        
        $this->view->addMessRed('Ошибка', $msg);
    }
    private function getChat(){
        if(isset($_POST["text"]))
            $this->addMsg();
        $count = $this->model->getCountChat($this->sql["id"]);
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getChat($this->sql["id"], $start);
        $this->top = 'Комментарии - '.$count;
        if($result->num_rows != 0){
		    while($q = $result->fetch_assoc()){
		        $rank = $this->rank->getRank($q["rating"]);
		        $comments .= '
		        <div class="p-3-0">
		            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
		                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["user"].'})"> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                    				        <img src="'.$this->url.'/img/rank/'.$rank.'.png" class="vs w30px" height="30">
                        				    '.$q["nick"].' ['.$this->timer->tl(time()-$q["timer"]).']
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->union->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                		</div>
                		<div class="p0-10 fz20">
        				    '.$q["msg"].'
        				</div>
		            </div>
	            </div>';
		    }
        }
        else{
            $comments = '<div class="p-5-10 white fz20 center">Нет Комментариев</div>';  
        }
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav = '<div class="p-5-10">'.$classPage->str('/html/page/news.php?newsId='.$this->sql["id"].'&panel=Chat&', $k_page, $page, '{}').'</div>';   
	    }
        $this->page = '
        <div class="center">
            <div class="p-5-3 fz20 white center">
    		    <input id="text" type="text" maxlength="1024" name="text" value="" class="form-inputPanelRed w70 left p-3-0">
            </div>
            <div class="p-5-3 fz20 white center">
                <div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/news.php?panel=Chat&newsId='.$this->sql["id"].'&quot;,{&quot;text&quot;: $(&quot;#text&quot;).val()}, false)">
    		        Написать
    		    </div>
    		</div>
        </div>
        <div class="p-5-10 left">
            '.$comments.'
        </div>
        <div class="center">
            '.$nav.'
        </div>
        ';
    }
    
    private function selectPanel(){
        foreach ($this->panel as $key => $value) {
            if(!isset($_GET["panel"]))
                $_GET["panel"] = 'News';
            if($_GET["panel"]==$value){
                $name = 'get'.$value;
                $this->$name();
                $select = true;
            }
            else
                $select = false;
            $this->panelButtons .= $this->model->getButtonPanel($this->sql["id"], $value, $select);
        }
    }
    private function showIdNews(){
        $this->selectPanel();
        $this->html = '
        <div class="p-5-10">
            <div class=" rel h52px">
                <div class="redPanelTop center w100">
                    <div class="table w100 tborder5-0"> 
            			<div class="row center">
            				'.$this->panelButtons.'
            			</div>
            		</div>
            	</div>
            </div>
            <div class="redPanel redPanelBack p10-0">
                '.$this->page.'
            </div>
        </div>';
    }
    private function showButtonAdd(){
        $this->position = $this->model->getPosition($this->user->getParam("id"));
        if($this->position!=null)
            $this->buttonAdd = '
            <div class="p-5-3 fz20 white center">
    			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/news.php?add&quot;,{})">
    		        Добавить
    		    </div>
            </div>'; 
    }
    private function showNews(){
        $this->showButtonAdd();
        $count = $this->model->getCount();
        $this->top = 'Новости - '.$count;
		$k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
        $result = $this->model->getList($this->user->getParam("id"), $start);
		if($result->num_rows != 0){
		    while($q = $result->fetch_assoc()){
		        $reading = '';
		        if($q["reading"]==0)
		            $reading = '<span class="red">Новое</span>';
		        $news .= '
		            <div class="p-3-0">
    		            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
    		                <div class="table w100  borderRadius5px" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/news.php?newsId='.$q["id"].'&quot;,{})"> 
                    			<div class="row">
                    				<div class="cell p0-10 vam center w10">
                    				    <img src="'.$this->url.'/img/icons/news.png" class="vs" height="30">
                    				</div>
                    				<div class="cell vam">
    									    <div class="fz20">'.$q["name"].' '.$reading.'</div>
    									    <div class="fz15">['.$this->timer->tl(time()-$q["timer"]).']</div>
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
    		            </div>
		            </div>';
		    }
		}
		else
		    $news .= '<div class="center fz20">Нет новостей</div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav .= '<div class="p-5-10">'.$classPage->str('/html/page/news.php?', $k_page, $page).'</div>';   
	    }
	    $this->html = '
	    <div class="p-5-10">
            <div class="redPanel redPanelBack p-5-10">
                '.$this->buttonAdd.$news.$nav.'
            </div>
        </div>
	    ';
    }
    private function addMNews(){
        $text = $_POST["text"];
        $text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $text);
        if(strlen($text) < 2 or strlen($text) >= 1000)
            $this->view->addMessRed('Ошибка', 'Комментарий должен содержать не менее 2 символов и не более 1000');
        else
            $this->model->addComment($this->user->getParam("id"),$this->sql["id"], $text);
    }
    private function addNews(){
        $this->theme  = htmlspecialchars($_POST["theme"]);
        $this->text   = htmlspecialchars($_POST["text"]);
        $msg    = '';
        if(empty($this->theme)) 
			$msg = 'Введите тему';
	    elseif(empty($this->text))
	        $msg = 'Введите текст';
	    elseif(strlen($this->theme) < 3 || strlen($this->theme) > 100) 
			$msg = 'Тема должна содержать не менее 3 символов и не более 100';
	    elseif(strlen($this->text) < 3 || strlen($this->text) > 1024) 
			$msg = 'Текст должен содержать не менее 3 символов и не более 1024';
		else{
		    $this->model->addNews($this->user->getParam("id"), $this->theme, $this->text);
		    $this->view->addMessBlue('Новость', 'Добавил новость');
		}
		if($msg!='')
	        $this->view->addMessRed("Ошибка", $msg);
    }
    private function showAdd(){
        if(isset($_POST["theme"]) and isset($_POST["text"]))
            $this->addNews();
        $this->top = 'Добавление';
        $this->html = '
        <script>
            function newNews(){
                window.brouser.openPage("'.$this->url.'/html/page/news.php?add", {"theme": $("#theme").val(), "text": $("#text").val()}, false);
            }
        </script>
	    <div class="p-5-10">
            <div class="redPanel redPanelBack p-5-10 white fz20 center">
                <div class="p-5-3">
                    Тема:<br>
        		    <input id="theme" type="text" maxlength="100" name="text" value="" class="form-inputPanelRed w70 left p-3-0">
                </div>
                <div class="p-5-3">
                    Текст:<br>
        		    <textarea id="text" type="text" maxlength="4000"  name="text" value="" class="form-inputPanelRed w70 left p-3-0 h150px"></textarea>
                </div>	
                <div class="p-5-3">
                    <div class="redButton w70 mAuto borderRadius10px p10-0" onclick=newNews()>
        		        Добавить
        		    </div>
        		</div>
            </div>
        </div>';
    }
    private function addError(){
        $this->top = 'Ошибка';
        $this->html = '
	    <div class="p-5-10 center">
            <div class="redPanel redPanelBack p-5-10 white">
                У вас нет прав
            </div>
        </div>';
    }
    private function add(){
        $this->position = $this->model->getPosition($this->user->getParam("id"));
        if($this->position!=null)
            $this->showAdd();
        else
            $this->addError();
    }
    private function start(){
        if(isset($_GET["newsId"]))
            $this->chackIdNews();
        elseif(isset($_GET["add"]))
            $this->add();
        else
            $this->showNews();
    }
    public function setView(){
        $this->model = new \model\News($this);
        $this->rank = new \model\Rank($this);
        $this->start();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}