<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Pass extends \engine\Game{
    private $html = '';
    private $top  = 'Сменить пароль';
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Pass($this);
    }
    private function replace(){
        $err = '';
        $old = $_POST["old"];
        $new = $_POST["new"];
        $repeat = $_POST["repeat"];
        if(empty($old))
            $err = 'Введите старый пароль';
        elseif(empty($new))
            $err = 'Введите новый пароль';
        elseif(empty($repeat))
            $err = 'Введите повтор пароля';
        elseif(strlen($new) < 6 || strlen($login) > 30) 
            $err = 'Пароль должен содержать не менее 6 символов и не более 30';
        elseif($new != $repeat)
            $err = 'Пароли не совпадают';
        elseif($this->user->getParam("password") != md5($old))
            $err = 'Старый пароль введён не верно';
        if($err == ''){
            $this->model->replace($this->user->getParam("id"), $new);
            $this->view->addMessBlue('Пароль', 'Пароль изменён');
        }
        else
            $this->view->addMessRed('Ошибка', $err);
    }
    private function main(){
        if(isset($_GET["go"]))
            $this->replace();
        $this->html = '
        <script>
            function newPass(){
                window.brouser.openPage("'.$this->game->url.'/html/page/pass.php?go", {"old": $("#oldPass").val(), "new": $("#newPass").val(), "repeat": $("#repeatPass").val()}, false);
            }
        </script>
        <div class="p-5-10 center fz20 white">
            <div>
	            <input id="oldPass" type="password" name="oldPass" class="form-input w70" placeholder="Старый" maxlength="32" value="">
	            <input id="newPass" type="password" name="newPass" class="form-input w70" placeholder="Новый" maxlength="32" value="">
	            <input id="repeatPass" type="password" name="repeatPass" class="form-input w70" placeholder="Повторите" maxlength="32" value="">
	        </div>
		    <div class="redButton w70 mAuto borderRadius10px p10-0" onclick=newPass()>
		        Сменить
		    </div>
		</div>';
    }
    public function setView(){
        $this->main();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}