<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Quest extends \engine\Game{
    private $html = '';
    private $top  = 'Задания';
    private $responseTime = 3600;//Время через которое можно дать повторный ответ
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Quest($this);
    }
    private function chackId(){
        $id = intval($_GET["quest_id"]);
        $this->sqlId = $this->model->chackId($id, $this->user->getParam("id"));
        if($this->sqlId!=NULL)
            $this->showId();
        else
            $this->notSearchId();
    }
    private function notSearchId(){
        $this->top = 'Ошибка';
        $this->html = '
        <div class="p-5-10 center fz20">
            Задание не найдено
        </div>';
    }
    private function choseRight($option){//Выбрал верно
        $this->user->selectMyCity();
        $user = $this->user->getParam("id");
        $city = $this->user->getParamCity("id");
        $text = $this->model->issueAnAward($this->sqlId, $user, $city);
        $this->view->addMessBlue("Награда", $text);
        $this->model->done($this->userOptions["id"]);
    }
    private function choseWrong($option){//Выбрал неверно
        $time = time()+$this->sqlId["time_error"];
        $this->model->setTimeUserQuest($this->userOptions["id"], $time);
        $this->userOptions["response_time"] = $time;
        $text = 'Вы дали неверный ответ. Ожидайте <img src="'.$this->url.'/img/icons/time.png" class="vs" height="18">'.$this->timer->tl($this->sqlId["time_error"]);
        $this->view->addMessRed("Ошибка", $text);
    }
    private function checkTimeWrong($option){
        if($this->userOptions["response_time"]<time()){
            $this->choseWrong($option);
        }
    } 
    private function checkTime($option){
        if($this->userOptions["response_time"]<time()){
            $this->choseRight($option);
        }
    } 
    private function selectUserQuest(){
        $this->userOptions = $this->model->getQuestUserId($this->user->getParam("id"), $this->sqlId["id"]);
        if($this->userOptions==NULL){
            $this->model->addUserQuest($this->user->getParam("id"), $this->sqlId["id"]);
            $this->selectUserQuest();
        }
    }
    private function getOptions(){
        $this->option = '';
        $result = $this->model->getQuestOption($this->sqlId["id"]);
        
        while($q = $result->fetch_assoc()){
            $color = 'blacPanelRedButton';
            if($_GET["option_id"] == $q["id"]){
                
                if($q["correct"]==1){
                    $this->checkTime($q);
                    $color = 'questGreen';
                }
                else{
                    $this->checkTimeWrong($q);
                    $color = 'questRed';
                }
            }
            
            $this->option .= '
            <div class="p-3-0">
		        <div class="table '.$color.' borderRadius5px w100" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/quest.php?quest_id='.$q["quest_id"].'&option_id='.$q["id"].'&quot;,{}, false)"> 
        			<div class="row">
        				<div class="cell p10 fz20">
        				    '.$q["msg"].'
        				</div>
        				<div class="cell fz20 right vam p6">
    					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
    					</div>
        			</div>
        		</div>
		    </div>';
        }
    }
    private function getRestTime(){
        $this->option = '<div class="center fz15">Вы дали неверный ответ. Ожидание <img src="'.$this->url.'/img/icons/time.png" class="vs" height="18">'.$this->timer->tl($this->userOptions["response_time"]-time()).'</div>';
    }
    private function getSupport(){
        $this->support = $this->model->getSupport($this->user->getParam("id"));
    }
    private function addButtonSupport(){
        if($this->support!=null){
            $this->buttonSupport = '
            <div class="p-5-3 fz20 white center">
    			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/quest.php?admin&quot;,{})">
    		        Управление
    		    </div>
            </div>
            <hr>';
        }
    }
    private function showId(){
        $this->selectUserQuest();
        if($this->userOptions["response_time"]>=time())
            $this->getRestTime();
        else
            $this->getOptions();
        $this->top      = $this->sqlId["name"];
        $this->msg      = $this->sqlId["msg"];
        $this->question = $this->sqlId["question"];
        $this->reward   = $this->model->getReward($this->sqlId);
        $this->html = '
        <div class="p-5-10">
            <div class="redPanel redPanelBack">
                <div class="p-5-10 ">
            		<div class="white fz20">
            		    <img src="'.$this->url.'/'.$this->sqlId["icon"].'" class="leftImgQuest" height="50">
                		'.$this->msg.'
            		</div>
        		</div>
            	<div class="p-3-0 center blacPanelRedButton white borderLine1px">
        		    Награда: 
        		    <div>
        		        '.$this->reward.'
        		    </div>
        		</div>
        		<div class="p-5-10">
            		<div class="p-3-0">
        	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
        	                <div class="p10">
        	                    <div class="center fz20">
            				        '.$this->question.'
            				    </div>
            				    '.$this->option.'
                    		</div>
        	            </div>
                    </div>
                </div>
            </div>
        </div>';
    }
    private function showList(){
        $this->getSupport();
        $this->addButtonSupport();
        $buttons = '';
        $count = $this->model->getCount($this->user->getParam("id"));
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getList($this->user->getParam("id"), $start);
        $this->top = 'Задания - '.$count;
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $arr = ["name" => $q["name"], "icon" => $q["icon"],  "url" => 'quest_id='.$q["id"]];
                $buttons .= $this->model->showViewButton($arr);
            }
            if($count >= 11){
    	        $classPage = new \engine\Page();
    	        $nav = '<div class="p-5-10">'.$classPage->str('/html/page/quest.php', $k_page, $page, '{}').'</div>';// Поменять   
    	    }
        }
        else{
            $buttons = '<div class="center fz20">Активных заданий не найдено</div>';
        }
        $this->html = '
        <div class="">
            '.$this->buttonSupport.'
            '.$buttons.'
            
            <div class="center">
                '.$nav.'
            </div>
        </div>';
    }
    public function showAdmin(){
        $control = new \addPage\Quest($this);
        $this->top  = $control->top;
        $this->html = $control->html;
    }
    public function start(){
        
        if(isset($_GET["quest_id"]))
            $this->chackId();
        elseif(isset($_GET["admin"]))
            $this->showAdmin();
        else
            $this->showList();
    }
    public function setView(){
        $this->start();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}