<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Rank extends \engine\Game{
    private $html = '';
    private $top  = 'Боевой пропуск';
    private $timerRank = [];// Награду за какие звания уже забрали
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Rank($this);
        $this->userModel = new \model\User($this);
         $this->modelMarket = new \model\Market($this);
    }
    public function parserPriz($prize, $filter = false){
        $textPrize = '';
        foreach ($prize as $key => $value) {
            $textPrize .= '<img src="'.$this->url.'/img/icons/'.$key.'.png" class="vs '.($filter?'filterGray':'').'" height="25">'.$value.' ';
        }
        return $textPrize;
    }
    private function notSearchTake(){
        $this->view->addMessRed('Ошибка', 'Награда не найдена');       
    }
    private function notLevelTake(){
        $this->view->addMessRed('Ошибка', 'Поднимите звание');       
    }
    private function notTimeTake(){
        $this->view->addMessRed('Ошибка', 'Осталось: <img src="'.$this->url.'/img/icons/time.png" class="vs" height="25">'.$this->timer->tl($this->sql["timer"]-time()));       
    }
    private function takeOk(){
        $this->view->getButtonQuestionBlueOk('Награда', 'Награда: '.$this->setRewar($this->model->prize[$this->takeId]), '"window.brouser.openPage(&quot;'.$this->url.'/html/page/rank.php&quot;,{}, false)"');
        $this->model->add($this->user->getParam("id"), ($this->model->timerUpdate+time()), $this->takeId);
        
    }
    private function setTimer(){
        $result = $this->model->getAll($this->user->getParam("id"));
        while($q = $result->fetch_assoc()){
            $this->timerRank[$q["level"]] = $q["timer"];
        }
    }
    public function setRewar($arr){
        $this->user->selectMyCity();
        $textRewarOpen = '';
        foreach ($arr as $key => $value) {
            $rewar = '';
            switch ($key) {
                case "gold":
                    $rewar = '<img src="'.$this->url.'/img/icons/gold.png" class="vs" height="20px"> '.$value;
                    $this->modelMarket->plassGold($this->user->getParam("id"), $value);
                    break;
                case "cristal":
                    $rewar = '<img src="'.$this->url.'/img/icons/cristal.png" class="vs" height="20px"> '.$value;
                    $this->modelMarket->plassCristal($this->user->getParam("id"), $value);
                    break;
                case "clef":
                    $rewar = '<img src="'.$this->url.'/img/icons/clef.png" class="vs" height="20px"> '.$value;
                    $this->modelMarket->plassClef($this->user->getParam("id"), $value);
                    break;
            }
            $textRewarOpen .= $rewar.' ';
        }
        return $textRewarOpen;
    }
    private function chackTake(){
        $this->takeId = intval($_GET["take"]);
        if(array_key_exists($this->takeId, $this->model->prize)){
            if($this->takeId<=$this->userRank){
                $this->sql = $this->model->getId($this->takeId, $this->user->getParam("id"));
                if($this->sql==null)
                    $this->takeOk();
                else
                    $this->notTimeTake();
            }
            else
                $this->notLevelTake();
        }
        else
            $this->notSearchTake();  
    }
    public function start(){
        $this->sql          = $this->userModel->getById($this->user->getParam("id"));
        $this->xp           = $this->sql["rating"];
        $this->userRank     = $this->model->getRank($this->xp);
        $this->setTimer();
        if(isset($_GET["take"]))
            $this->chackTake();
        $rankText = '';
        foreach ($this->model->prize as $key => $value) {
            if($key<=$this->userRank){
                $textTimer = '';
                if(array_key_exists($key, $this->timerRank))
                    $textTimer = '<img src="'.$this->url.'/img/icons/time.png" class="vs" height="25">'.$this->timer->tl($this->timerRank[$key]-time());
                $rankText .= '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/rank.php?take='.$key.'&quot;,{}, false)">
                        <div class="table w100 tborder10-5"> 
                			<div class="white row">
                				<div class="cell w10">
                				    <div class="p6">
                				        <img src="'.$this->url.'/img/rank/'.$key.'.png" class="vs" height="50">
                					</div>
                				</div>
                				<div class="cell fz20 left vam p6 '.($textTimer!='red'?'':'green').'">
                				    '.($textTimer!=''?$textTimer:'Забрать награду').'
                				    
                				</div>
                				<div class="cell fz20 right vam p6 ">
                				    '.$this->parserPriz($value).'
                				</div>
                			</div>
                		</div>
                	</div>
                </div>';     
            }
            else{
                $rankText .= '
                <div class="p-5-10 fz20">
                    <div class="p-5-10 offPanelBack borderRadius5">
                        <div class="table w100 tborder10-5"> 
                			<div class="white row">
                				<div class="cell w10">
                				    <div class="p6">
                				        <img src="'.$this->url.'/img/rank/'.$key.'.png" class="vs filterGray" height="50">
                					</div>
                				</div>
                				<div class="cell fz20 left vam p6">
                				    '.$this->model->rankName[$key].'
                				</div>
                				<div class="cell fz20 right vam p6 ">
                				    '.$this->parserPriz($value, true).'
                				</div>
                			</div>
                		</div>
                	</div>
                </div>'; 
            }
        }
        $this->html = $rankText;
    }
    public function setView(){
        $this->start();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}