<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Rating extends \engine\Game{
    private $html = '';
    private $top  = '';
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Rating($this);
        $this->userModel = new \model\User($this);
        $this->rank = new \model\Rank($this);
        $this->modelUnion = new \model\Union($this);
    }
    private function showUnion(){
        $count = $this->model->getUnionCount();
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getUnion($start);
        $this->top = 'Союзы - '.$count;
        $position = 1;
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $n = $page * 10 + $position - 10;
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/union.php&quot;,{&quot;unionId&quot;: '.$q["id"].'})"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				        '.$n.'.
            				        '.$q["name"].'
            				    </div>
            				    <div>
            				        <img src="'.$this->url.'/img/icons/rating.png" class="vs w30px" height="25">'.($q["rating"]).'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
        					</div>
            			</div>
            		</div>
        		</div>';
        		$position++;
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/rating.php?union&', $k_page, $page).'</div>';   
	    }
	    if($this->user->getParam("alliance")>0){
            $myUnion = $this->model->getMyUnion($this->user->getParam("alliance"));
	        $myUnionText = '
	        <div class="p-5-10">
                <div class="table w100 borderRadius5px alternationNotEvenRed" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$this->user->getParam("id").'})"> 
        			<div class="row">
        				<div class="cell p10">
        				    <div>
        				        '.$myUnion["rank"].'.
            				    '.$myUnion["name"].'
        				    </div>
        				    <div>
        				        <img src="'.$this->url.'/img/icons/rating.png" class="vs w30px" height="25">'.($myUnion["rating"]).'
        				    </div>
        				</div>
        				<div class="cell fz20 right vam p6">
    					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
    					</div>
        			</div>
        		</div>
    		</div>';    
	    }
	    
        $this->html = '
        <div class="p-5-3 fz20">
            '.$users.'
            '.$myUnionText.'
            '.$nav.'
        </div>';
    }
    private function showProvinces(){
        $this->top = 'Провинции';
        $count = $this->model->getUsersCount();
        $myRank = $this->model->getMyRankProvinces($this->user->getParam("id"));
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$position = 1;
		$result = $this->model->getProvinces($start);
		if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $n = $page * 10 + $position - 10;
                $rank = $this->rank->getRank($q["rating"]);
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["id"].'})"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				    '.$n.'.
            				    <img src="'.$this->url.'/img/rank/'.$rank.'.png" class="vs w30px" height="30">
            				        '.$q["nick"].'
            				    </div>
            				    <div>
            				        <img src="'.$this->url.'/img/icons/provinces.png" class="vs w30px" height="25">'.($q["invader_col"]).'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
        					</div>
            			</div>
            		</div>
        		</div>';
        		$position++;
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/rating.php?provinces&', $k_page, $page).'</div>';   
	    }
	    
        $this->html = $this->nav.'
        <div class="p-5-3 fz20">
            '.$users.'
            <div class="p-5-10">
                <div class="table w100 borderRadius5px alternationNotEvenRed" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$this->user->getParam("id").'})"> 
        			<div class="row">
        				<div class="cell p10">
        				    <div>
        				        '.$myRank["rank"].'.
            				    <img src="'.$this->url.'/img/rank/'.$rank.'.png" class="vs w30px" height="30">
            				    '.$myRank["nick"].'
        				    </div>
        				    <div>
        				        <img src="'.$this->url.'/img/icons/provinces.png" class="vs w30px" height="25">'.($myRank["col"]).'
        				    </div>
        				</div>
        				<div class="cell fz20 right vam p6">
    					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
    					</div>
        			</div>
        		</div>
    		</div>
            '.$nav.'
        </div>';
    }
    private function showRating(){
        $count = $this->model->getUsersCount();
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getUsers($start);
        $this->top = 'Рейтинг - '.$count;
        $position = 1;
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $n = $page * 10 + $position - 10;
                $rank = $this->rank->getRank($q["rating"]);
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["id"].'})"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				    '.$n.'.
            				    <img src="'.$this->url.'/img/rank/'.$rank.'.png" class="vs w30px" height="30">
            				        '.$q["nick"].'
            				    </div>
            				    <div>
            				        <img src="'.$this->url.'/img/icons/rating.png" class="vs w30px" height="25">'.($q["rating"]).'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
        					</div>
            			</div>
            		</div>
        		</div>';
        		$position++;
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/rating.php?rating&', $k_page, $page).'</div>';   
	    }
	    $rank = $this->rank->getRank($myRank["my_rating"]);
        $this->html = $this->nav.'
        <div class="p-5-3 fz20">
            '.$users.'
            '.$nav.'
        </div>';
    }
    private function showOnline(){
        $count = $this->model->getUsersCountOnline();
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getUsersOnline($start);
        $this->top = 'Онлайн - '.$count;
        $position = 1;
        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                $n = $page * 10 + $position - 10;
                $rank = $this->rank->getRank($q["rating"]);
                $users .= '
                <div class="p-5-10">
                    <div class="table w100 borderRadius5px alternationNotEven" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["id"].'})"> 
            			<div class="row">
            				<div class="cell p10">
            				    <div>
            				    '.$n.'.
            				    <img src="'.$this->url.'/img/rank/'.$rank.'.png" class="vs w30px" height="30">
            				        '.$q["nick"].'
            				    </div>
            				</div>
            				<div class="cell fz20 right vam p6">
        					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="40">
        					</div>
            			</div>
            		</div>
        		</div>';
        		$position++;
            }
        }
        else
            $users = '
            <div class="p-5-3 fz20">
                Пусто
            </div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav= '<div class="p-5-10">'.$classPage->str('/html/page/rating.php?online&', $k_page, $page).'</div>';   
	    }
        $this->html = $this->nav.'
        <div class="p-5-3 fz20">
            '.$users.'
            '.$nav.'
        </div>';
        
    }
    private function router(){
        if(isset($_GET["union"]))
            $this->showUnion();
        elseif(isset($_GET["provinces"]))
            $this->showProvinces();
        elseif(isset($_GET["online"]))
            $this->showOnline();
        else
            $this->showRating();
    }
    public function setView(){
        $this->router();
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                '.$this->html.'
            </div>
        </div>';
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}