<?php
namespace page;

$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');

class Pass extends \engine\Game{
    private $html = '';
    private $top  = 'Сменить кодовое слово';
    
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Pass($this);
    }
    
    private function replace(){
        $err = '';
        $old = $_POST["old"] ?? '';
        $new = $_POST["new"] ?? '';
        $repeat = $_POST["repeat"] ?? '';
        
        if(empty($old))
            $err = 'Введите старое кодовое слово';
        elseif(empty($new))
            $err = 'Введите новое кодовое слово';
        elseif(empty($repeat))
            $err = 'Введите повтор кодового слова';
        elseif(strlen($new) < 6 || strlen($new) > 30) 
            $err = 'Кодовое слово должно содержать от 6 до 30 символов';
        elseif($new != $repeat)
            $err = 'Кодовые слова не совпадают';
        elseif($this->user->getParam("kodslovo") != md5($old))
            $err = 'Старое кодовое слово введено неверно';
            
        if($err == ''){
            $success = $this->model->replace($this->user->getParam("id"), $new);
            if($success){
                $this->view->addMessBlue('Кодовое слово', 'Кодовое слово изменено');
            } else {
                $this->view->addMessRed('Ошибка', 'Не удалось изменить кодовое слово');
            }
        } else {
            $this->view->addMessRed('Ошибка', $err);
        }
    }
    
    private function main(){
        if(isset($_GET["go"]))
            $this->replace();
            
        $this->html = '
        <script>
            function newPass(){
                window.brouser.openPage("'.$this->game->url.'/html/page/slovo.php?go", {
                    "old": $("#oldPass").val(), 
                    "new": $("#newPass").val(), 
                    "repeat": $("#repeatPass").val()
                }, false);
            }
        </script>
        <div class="p-5-10 center fz20 white">
            <div>
	            <input id="oldPass" type="password" name="oldPass" class="form-input w70" placeholder="Старое кодовое слово" maxlength="30" value="">
	            <input id="newPass" type="password" name="newPass" class="form-input w70" placeholder="Новое кодовое слово" maxlength="30" value="">
	            <input id="repeatPass" type="password" name="repeatPass" class="form-input w70" placeholder="Повторите кодовое слово" maxlength="30" value="">
	        </div>
		    <div class="redButton w70 mAuto borderRadius10px p10-0" onclick="newPass()">
		        Сменить
		    </div>
		</div>';
    }
    
    public function setView(){
        $this->main();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}