<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

if (!isAdmin()) {
    header('Location: /login.php');
    exit;
}

$title = "Управление товарами";
include '../templates/admin/header.php';
include '../templates/admin/sidebar.php';

$db = db();
?>

<div class="container-fluid">
    <h2>Управление товарами</h2>
    
    <div class="mb-3">
        <a href="product-edit.php" class="btn btn-success">
            <i class="fas fa-plus"></i> Добавить товар
        </a>
    </div>
    
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Изображение</th>
                    <th>Название</th>
                    <th>Цена</th>
                    <th>Категория</th>
                    <th>Статус</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $result = $db->query("
                    SELECT p.*, c.name as category_name 
                    FROM products p 
                    LEFT JOIN categories c ON p.category_id = c.id 
                    ORDER BY p.id DESC
                ");
                
                while ($row = $result->fetch_assoc()):
                ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td>
                        <?php if ($row['image']): ?>
                            <img src="<?php echo $row['image']; ?>" width="50" height="50" style="object-fit: cover;">
                        <?php endif; ?>
                    </td>
                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                    <td><?php echo number_format($row['price'], 2); ?> ₽</td>
                    <td><?php echo htmlspecialchars($row['category_name']); ?></td>
                    <td>
                        <span class="badge badge-<?php echo $row['status'] === 'active' ? 'success' : 'secondary'; ?>">
                            <?php echo $row['status']; ?>
                        </span>
                    </td>
                    <td>
                        <a href="product-edit.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit"></i>
                        </a>
                        <button onclick="deleteProduct(<?php echo $row['id']; ?>)" class="btn btn-sm btn-danger">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deleteProduct(id) {
    if (confirm('Вы уверены, что хотите удалить этот товар?')) {
        fetch('../api/admin.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'delete_product',
                product_id: id
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Ошибка: ' + data.error);
            }
        });
    }
}
</script>

<?php include '../templates/admin/footer.php'; ?>