<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

$db = db();

// Очищаем старые сессии (старше 7 дней)
$db->query("DELETE FROM cart WHERE added_at < DATE_SUB(NOW(), INTERVAL 7 DAY)");

// Очищаем истекшие токены скачивания
$db->query("UPDATE orders SET download_token = NULL WHERE token_expires < NOW()");

// Очищаем неоплаченные заказы (старше 3 дней)
$db->query("DELETE FROM orders WHERE payment_status = 'pending' AND created_at < DATE_SUB(NOW(), INTERVAL 3 DAY)");

// Очищаем временные файлы
$tempDir = '../uploads/temp/';
if (is_dir($tempDir)) {
    $files = glob($tempDir . '*');
    foreach ($files as $file) {
        if (is_file($file) && time() - filemtime($file) >= 3600) {
            unlink($file);
        }
    }
}

// Логируем очистку
file_put_contents('../logs/cron.log', date('Y-m-d H:i:s') . " - Cleanup completed\n", FILE_APPEND);
?>