<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$token = $_GET['token'] ?? '';

if (empty($token)) {
    die('Токен не указан');
}

$db = db();

// Находим заказ по токену
$stmt = $db->prepare("
    SELECT o.*, oi.product_id, oi.downloads_used, p.file_path, p.name as product_name,
           p.max_downloads, u.id as user_id
    FROM orders o
    JOIN order_items oi ON o.id = oi.order_id
    JOIN products p ON oi.product_id = p.id
    LEFT JOIN users u ON o.user_id = u.id
    WHERE o.download_token = ? 
    AND o.token_expires > NOW()
    AND o.payment_status = 'paid'
    AND oi.downloads_used < p.max_downloads
");

$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die('Неверный токен или время его действия истекло');
}

$orderData = $result->fetch_assoc();
$filePath = $orderData['file_path'];

// Проверяем существование файла
if (!file_exists($filePath)) {
    die('Файл не найден на сервере');
}

// Увеличиваем счетчик скачиваний
$db->begin_transaction();

try {
    // Обновляем счетчик в order_items
    $stmt = $db->prepare("
        UPDATE order_items 
        SET downloads_used = downloads_used + 1, 
            last_download = NOW() 
        WHERE order_id = ? AND product_id = ?
    ");
    $stmt->bind_param("ii", $orderData['id'], $orderData['product_id']);
    $stmt->execute();
    
    // Обновляем общий счетчик продукта
    $stmt = $db->prepare("
        UPDATE products 
        SET downloads_count = downloads_count + 1 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $orderData['product_id']);
    $stmt->execute();
    
    // Логируем скачивание
    $stmt = $db->prepare("
        INSERT INTO download_logs (order_id, product_id, user_id, ip_address, downloaded_at)
        VALUES (?, ?, ?, ?, NOW())
    ");
    $ip = $_SERVER['REMOTE_ADDR'];
    $stmt->bind_param("iiis", $orderData['id'], $orderData['product_id'], $orderData['user_id'], $ip);
    $stmt->execute();
    
    $db->commit();
    
} catch (Exception $e) {
    $db->rollback();
    // Продолжаем скачивание даже при ошибке логирования
}

// Отправляем файл
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
header('Content-Transfer-Encoding: binary');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));

// Очищаем буфер вывода
ob_clean();
flush();
readfile($filePath);

// Если достигнут лимит скачиваний, удаляем токен
if (($orderData['downloads_used'] + 1) >= $orderData['max_downloads']) {
    $stmt = $db->prepare("UPDATE orders SET download_token = NULL WHERE id = ?");
    $stmt->bind_param("i", $orderData['id']);
    $stmt->execute();
}

exit;
?>