<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$title = "Как купить товар - инструкция";
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

include 'templates/header.php';
?>

<div class="container py-5">
    <!-- Заголовок -->
    <div class="row mb-5">
        <div class="col-12">
            <h1 class="display-5 mb-3">
                <i class="fas fa-shopping-cart text-primary me-2"></i>Как купить товар
            </h1>
            <p class="lead text-muted">
                Пошаговая инструкция по покупке цифровых товаров в нашем магазине. 
                Все просто и быстро - всего несколько кликов отделяют вас от нужного товара!
            </p>
        </div>
    </div>
    
    <!-- Шаги покупки -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="mb-4">Процесс покупки в 5 простых шагов</h2>
            
            <div class="steps-timeline">
                <!-- Шаг 1 -->
                <div class="step-card">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h4>Найдите нужный товар</h4>
                        <p class="text-muted">
                            Используйте поиск по сайту или просмотрите каталог товаров. 
                            Вы можете фильтровать товары по категориям, цене, популярности и другим параметрам.
                        </p>
                        <div class="step-links">
                            <a href="/catalog.php" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-th-large me-1"></i>Перейти в каталог
                            </a>
                            <a href="/categories.php" class="btn btn-sm btn-outline-secondary ms-2">
                                <i class="fas fa-tags me-1"></i>Посмотреть категории
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Шаг 2 -->
                <div class="step-card">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h4>Добавьте товар в корзину</h4>
                        <p class="text-muted">
                            На странице товара нажмите кнопку "В корзину". 
                            Вы можете добавить несколько товаров, а затем перейти к оформлению заказа.
                        </p>
                        <div class="alert alert-info small">
                            <i class="fas fa-info-circle me-2"></i>
                            Для добавления в корзину не требуется регистрация. Вы можете войти в аккаунт позже.
                        </div>
                    </div>
                </div>
                
                <!-- Шаг 3 -->
                <div class="step-card">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h4>Перейдите в корзину и проверьте заказ</h4>
                        <p class="text-muted">
                            В корзине вы можете изменить количество товаров, удалить ненужные позиции 
                            и применить промокод для получения скидки.
                        </p>
                        <div class="step-links">
                            <a href="/cart.php" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-shopping-cart me-1"></i>Перейти в корзину
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Шаг 4 -->
                <div class="step-card">
                    <div class="step-number">4</div>
                    <div class="step-content">
                        <h4>Оформите заказ и выберите способ оплаты</h4>
                        <p class="text-muted">
                            Нажмите кнопку "Оформить заказ", выберите удобный способ оплаты 
                            и заполните необходимые данные.
                        </p>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="card h-100 border-primary">
                                    <div class="card-body text-center">
                                        <i class="fab fa-yandex-money fa-2x text-primary mb-3"></i>
                                        <h6>ЮMoney</h6>
                                        <p class="small text-muted">Кошелек Яндекс.Деньги</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card h-100 border-success">
                                    <div class="card-body text-center">
                                        <i class="fas fa-credit-card fa-2x text-success mb-3"></i>
                                        <h6>Банковские карты</h6>
                                        <p class="small text-muted">Visa, MasterCard, МИР</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card h-100 border-info">
                                    <div class="card-body text-center">
                                        <i class="fas fa-wallet fa-2x text-info mb-3"></i>
                                        <h6>Баланс аккаунта</h6>
                                        <p class="small text-muted">Оплата внутренним балансом</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Шаг 5 -->
                <div class="step-card">
                    <div class="step-number">5</div>
                    <div class="step-content">
                        <h4>Оплатите заказ и получите товар</h4>
                        <p class="text-muted">
                            После успешной оплаты вы мгновенно получите доступ к скачиванию товара. 
                            Ссылка для скачивания придет на ваш email и будет доступна в личном кабинете.
                        </p>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle me-2"></i>
                            <strong>Мгновенная доставка!</strong> Все цифровые товары доступны для скачивания сразу после оплаты.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Важная информация -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h3 class="card-title mb-4">
                        <i class="fas fa-exclamation-triangle text-warning me-2"></i>Важная информация
                    </h3>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-user-check text-primary fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Регистрация аккаунта</h6>
                                    <p class="small text-muted mb-0">
                                        Для сохранения истории покупок и быстрого оформления заказов 
                                        рекомендуется <a href="/register.php">зарегистрировать аккаунт</a>.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-shield-alt text-success fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Безопасность оплаты</h6>
                                    <p class="small text-muted mb-0">
                                        Все платежи защищены SSL-шифрованием. Мы не храним данные ваших 
                                        банковских карт.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-undo text-info fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Возврат средств</h6>
                                    <p class="small text-muted mb-0">
                                        В случае технических проблем с товаром вы можете 
                                        <a href="/refund.php">запросить возврат средств</a> в течение 14 дней.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-headset text-warning fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Поддержка 24/7</h6>
                                    <p class="small text-muted mb-0">
                                        Если возникли проблемы с покупкой - обратитесь в 
                                        <a href="/contacts.php">службу поддержки</a>. Мы поможем!
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Частые вопросы о покупке -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Частые вопросы о покупке</h3>
            
            <div class="accordion" id="buyingQuestions">
                <!-- Вопрос 1 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                            Нужно ли регистрироваться для покупки?
                        </button>
                    </h3>
                    <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#buyingQuestions">
                        <div class="accordion-body">
                            <strong>Нет, регистрация не обязательна.</strong> Вы можете совершить покупку как гость. 
                            Однако для сохранения истории заказов, быстрого оформления будущих покупок и 
                            получения персональных скидок рекомендуется создать аккаунт.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 2 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                            Сколько времени занимает доставка цифровых товаров?
                        </button>
                    </h3>
                    <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#buyingQuestions">
                        <div class="accordion-body">
                            <strong>Мгновенно!</strong> Все цифровые товары доступны для скачивания сразу после 
                            успешной оплаты. Ссылка для скачивания придет на ваш email и будет доступна 
                            в личном кабинете (если вы авторизованы).
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 3 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                            Можно ли оплатить заказ несколькими способами?
                        </button>
                    </h3>
                    <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#buyingQuestions">
                        <div class="accordion-body">
                            <strong>Да, можно комбинировать способы оплаты.</strong> Например, часть суммы 
                            оплатить с баланса аккаунта, а остальное - банковской картой. Для этого 
                            пополните баланс аккаунта, а затем при оформлении заказа выберите оплату 
                            с баланса.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 4 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour">
                            Что делать, если платеж не прошел?
                        </button>
                    </h3>
                    <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#buyingQuestions">
                        <div class="accordion-body">
                            Если платеж не прошел, проверьте:
                            <ul>
                                <li>Достаточно ли средств на счете/карте</li>
                                <li>Не превышен ли лимит операций по карте</li>
                                <li>Правильно ли введены данные карты</li>
                                <li>Не заблокирована ли карта банком</li>
                            </ul>
                            Если проблема не решена, обратитесь в службу поддержки вашего банка или 
                            <a href="/contacts.php">напишите нам</a>.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 5 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive">
                            Как использовать промокод?
                        </button>
                    </h3>
                    <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#buyingQuestions">
                        <div class="accordion-body">
                            Чтобы использовать промокод:
                            <ol>
                                <li>Добавьте товары в корзину</li>
                                <li>Перейдите в корзину</li>
                                <li>Введите промокод в специальное поле</li>
                                <li>Нажмите "Применить"</li>
                                <li>Скидка автоматически будет учтена при оформлении заказа</li>
                            </ol>
                            <div class="alert alert-warning small mt-2">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Промокоды имеют ограничения по времени действия и могут не суммироваться 
                                с другими акциями.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Готовы совершить покупку? -->
    <div class="row">
        <div class="col-12">
            <div class="card text-center border-primary">
                <div class="card-body py-5">
                    <h3 class="card-title mb-4">Готовы совершить покупку?</h3>
                    <p class="card-text lead mb-4">
                        Выберите нужный товар и получите его мгновенно после оплаты!
                    </p>
                    <div class="d-grid gap-2 d-md-block">
                        <a href="/catalog.php" class="btn btn-primary btn-lg me-md-3">
                            <i class="fas fa-shopping-bag me-2"></i>Перейти в каталог
                        </a>
                        <a href="/faq.php" class="btn btn-outline-primary btn-lg">
                            <i class="fas fa-question-circle me-2"></i>Частые вопросы
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.steps-timeline {
    position: relative;
    padding-left: 40px;
}

.steps-timeline::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 0;
    bottom: 0;
    width: 4px;
    background: linear-gradient(to bottom, var(--primary-color), var(--secondary-color));
    border-radius: 2px;
}

.step-card {
    position: relative;
    margin-bottom: 40px;
    background: white;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.step-number {
    position: absolute;
    left: -50px;
    top: 0;
    width: 40px;
    height: 40px;
    background: var(--primary-color);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 18px;
    box-shadow: 0 4px 8px rgba(13, 110, 253, 0.3);
}

.step-content {
    padding-left: 20px;
}

.step-links {
    margin-top: 15px;
}

@media (max-width: 768px) {
    .steps-timeline {
        padding-left: 0;
    }
    
    .steps-timeline::before {
        display: none;
    }
    
    .step-number {
        position: relative;
        left: 0;
        top: 0;
        margin-bottom: 15px;
        display: inline-block;
    }
    
    .step-content {
        padding-left: 0;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Анимация шагов при прокрутке
    const observerOptions = {
        threshold: 0.2,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);
    
    document.querySelectorAll('.step-card').forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        card.style.transition = `opacity 0.5s ${index * 0.1}s, transform 0.5s ${index * 0.1}s`;
        observer.observe(card);
    });
});
</script>

<?php include 'templates/footer.php'; ?>