<?php
require_once 'functions.php';

function registerUser($email, $password, $username) {
    $db = db();
    
    // Проверка существования email
    $stmt = $db->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows > 0) {
        return ['error' => 'Email уже зарегистрирован'];
    }
    
    // Хэширование пароля
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $activation_token = generateToken();
    
    $stmt = $db->prepare("
        INSERT INTO users (email, password, username, activation_token, created_at) 
        VALUES (?, ?, ?, ?, NOW())
    ");
    $stmt->bind_param("ssss", $email, $hashed_password, $username, $activation_token);
    
    if ($stmt->execute()) {
        // Отправка email для активации
        $activation_link = SITE_URL . "/activate.php?token=" . $activation_token;
        $message = "Для активации аккаунта перейдите по ссылке: $activation_link";
        sendEmail($email, "Активация аккаунта", $message);
        
        return ['success' => true];
    }
    
    return ['error' => 'Ошибка регистрации'];
}

function loginUser($email, $password) {
    $db = db();
    
    $stmt = $db->prepare("
        SELECT id, email, password, username, role, is_active 
        FROM users 
        WHERE email = ? AND is_active = 1
    ");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['user_email'] = $row['email'];
            $_SESSION['user_name'] = $row['username'];
            $_SESSION['user_role'] = $row['role'];
            
            // Обновляем время последнего входа
            $update = $db->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
            $update->bind_param("i", $row['id']);
            $update->execute();
            
            return ['success' => true];
        }
    }
    
    return ['error' => 'Неверный email или пароль'];
}

function logoutUser() {
    session_destroy();
    header("Location: /login.php");
    exit;
}
?>