<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$title = "Возврат средств - условия и процедура";
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

include 'templates/header.php';
?>

<div class="container py-5">
    <!-- Заголовок -->
    <div class="row mb-5">
        <div class="col-12">
            <h1 class="display-5 mb-3">
                <i class="fas fa-undo text-info me-2"></i>Возврат средств
            </h1>
            <p class="lead text-muted">
                Информация о порядке возврата денежных средств за цифровые товары. 
                Мы ценим наших клиентов и стремимся решать все вопросы максимально быстро и справедливо.
            </p>
        </div>
    </div>
    
    <!-- Основная информация о возврате -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-info">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-info-circle me-2"></i>Основные положения о возврате
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-check-circle text-success fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Возврат возможен</h6>
                                    <ul class="small text-muted mb-0">
                                        <li>При технических неполадках в товаре</li>
                                        <li>Если товар не соответствует описанию</li>
                                        <li>При ошибочной оплате</li>
                                        <li>По требованию правообладателя</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <i class="fas fa-times-circle text-danger fa-2x me-3"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <h6>Возврат невозможен</h6>
                                    <ul class="small text-muted mb-0">
                                        <li>Если товар был скачан</li>
                                        <li>При изменении решения о покупке</li>
                                        <li>Если товар работает, но не устраивает качество</li>
                                        <li>По истечении 14 дней с момента покупки</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-warning mt-3">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Внимание!</strong> В соответствии с законодательством РФ, 
                        цифровые товары надлежащего качества не подлежат возврату и обмену 
                        (Постановление Правительства РФ №246 от 31.12.2020).
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Условия возврата -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Условия возврата средств</h3>
            
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-primary">
                        <div class="card-body text-center">
                            <div class="refund-condition-icon mb-3">
                                <i class="fas fa-calendar-alt fa-3x text-primary"></i>
                            </div>
                            <h5>Срок возврата</h5>
                            <p class="text-muted small">
                                Возврат возможен в течение <strong>14 дней</strong> с момента покупки
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-success">
                        <div class="card-body text-center">
                            <div class="refund-condition-icon mb-3">
                                <i class="fas fa-file-alt fa-3x text-success"></i>
                            </div>
                            <h5>Обоснование</h5>
                            <p class="text-muted small">
                                Необходимо предоставить <strong>доказательства</strong> проблемы
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-info">
                        <div class="card-body text-center">
                            <div class="refund-condition-icon mb-3">
                                <i class="fas fa-clock fa-3x text-info"></i>
                            </div>
                            <h5>Срок рассмотрения</h5>
                            <p class="text-muted small">
                                Рассмотрение заявки занимает <strong>до 10 рабочих дней</strong>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Процедура возврата -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Процедура возврата средств</h3>
            
            <div class="steps-timeline-refund">
                <!-- Шаг 1 -->
                <div class="step-card-refund">
                    <div class="step-number-refund">1</div>
                    <div class="step-content-refund">
                        <h5>Проверьте соответствие условиям</h5>
                        <p class="text-muted small mb-0">
                            Убедитесь, что ваш случай соответствует условиям возврата:
                            технические проблемы, несоответствие описанию, ошибочная оплата.
                        </p>
                    </div>
                </div>
                
                <!-- Шаг 2 -->
                <div class="step-card-refund">
                    <div class="step-number-refund">2</div>
                    <div class="step-content-refund">
                        <h5>Соберите доказательства</h5>
                        <p class="text-muted small mb-0">
                            Подготовьте скриншоты, видео или подробное описание проблемы. 
                            Укажите номер заказа и email, использованный при покупке.
                        </p>
                    </div>
                </div>
                
                <!-- Шаг 3 -->
                <div class="step-card-refund">
                    <div class="step-number-refund">3</div>
                    <div class="step-content-refund">
                        <h5>Напишите в поддержку</h5>
                        <p class="text-muted small mb-0">
                            Отправьте запрос на возврат через 
                            <a href="/contacts.php">форму обратной связи</a> или на email 
                            support@<?php echo parse_url(SITE_URL, PHP_URL_HOST); ?>
                        </p>
                    </div>
                </div>
                
                <!-- Шаг 4 -->
                <div class="step-card-refund">
                    <div class="step-number-refund">4</div>
                    <div class="step-content-refund">
                        <h5>Ожидайте рассмотрения</h5>
                        <p class="text-muted small mb-0">
                            Мы рассмотрим ваш запрос в течение 10 рабочих дней. 
                            В случае одобрения вернем средства тем же способом, которым была произведена оплата.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Форма запроса возврата -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-warning">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">
                        <i class="fas fa-file-signature me-2"></i>Запрос на возврат средств
                    </h5>
                </div>
                <div class="card-body">
                    <form id="refundRequestForm">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="refundName" class="form-label">Ваше имя *</label>
                                <input type="text" class="form-control" id="refundName" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="refundEmail" class="form-label">Email для связи *</label>
                                <input type="email" class="form-control" id="refundEmail" required>
                                <div class="form-text">Тот же email, который использовался при покупке</div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="orderNumber" class="form-label">Номер заказа *</label>
                            <input type="text" class="form-control" id="orderNumber" 
                                   placeholder="ORD-2023-XXXXX" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="refundReason" class="form-label">Причина возврата *</label>
                            <select class="form-select" id="refundReason" required>
                                <option value="">Выберите причину</option>
                                <option value="technical">Технические проблемы с товаром</option>
                                <option value="description">Товар не соответствует описанию</option>
                                <option value="double_payment">Двойная оплата/ошибочный платеж</option>
                                <option value="copyright">Нарушение авторских прав</option>
                                <option value="other">Другая причина</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="problemDescription" class="form-label">Подробное описание проблемы *</label>
                            <textarea class="form-control" id="problemDescription" rows="4" required
                                      placeholder="Опишите подробно, в чем заключается проблема..."></textarea>
                            <div class="form-text">
                                Чем подробнее вы опишете проблему, тем быстрее мы сможем ее решить
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="proofLinks" class="form-label">Ссылки на доказательства</label>
                            <textarea class="form-control" id="proofLinks" rows="2"
                                      placeholder="Ссылки на скриншоты, видео или другие доказательства..."></textarea>
                            <div class="form-text">
                                Можно использовать облачные хранилища (Google Drive, Yandex.Disk и т.д.)
                            </div>
                        </div>
                        
                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="agreeTerms" required>
                            <label class="form-check-label" for="agreeTerms">
                                Я ознакомлен с условиями возврата и согласен с ними *
                            </label>
                        </div>
                        
                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" id="deleteFiles">
                            <label class="form-check-label" for="deleteFiles">
                                Я удалил скачанные файлы (если производилось скачивание)
                            </label>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-warning btn-lg">
                                <i class="fas fa-paper-plane me-2"></i>Отправить запрос на возврат
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Частые вопросы о возврате -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Частые вопросы о возврате</h3>
            
            <div class="accordion" id="refundQuestions">
                <!-- Вопрос 1 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="refundHeadingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#refundCollapseOne">
                            В течение какого времени возвращаются деньги?
                        </button>
                    </h3>
                    <div id="refundCollapseOne" class="accordion-collapse collapse show" data-bs-parent="#refundQuestions">
                        <div class="accordion-body">
                            <strong>Срок возврата зависит от способа оплаты:</strong>
                            <ul class="mt-2">
                                <li><strong>ЮMoney:</strong> 1-3 рабочих дня</li>
                                <li><strong>Банковские карты:</strong> 3-10 рабочих дней</li>
                                <li><strong>Баланс аккаунта:</strong> 1-24 часа</li>
                            </ul>
                            <p class="mb-0 mt-2 small text-muted">
                                Сначала мы рассматриваем заявку (до 10 дней), затем производим возврат.
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 2 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="refundHeadingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#refundCollapseTwo">
                            Можно ли вернуть товар, если я его уже скачал?
                        </button>
                    </h3>
                    <div id="refundCollapseTwo" class="accordion-collapse collapse" data-bs-parent="#refundQuestions">
                        <div class="accordion-body">
                            <strong>Как правило, нет.</strong> После скачивания цифрового товара возврат 
                            возможен только в исключительных случаях:
                            <ul class="mt-2">
                                <li>Товар содержит вирусы или вредоносный код</li>
                                <li>Товар существенно не соответствует описанию</li>
                                <li>Товар технически неработоспособен</li>
                            </ul>
                            <p class="mb-0 mt-2 small text-muted">
                                В таких случаях необходимо предоставить доказательства проблемы.
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 3 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="refundHeadingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#refundCollapseThree">
                            Что делать, если я оплатил дважды по ошибке?
                        </button>
                    </h3>
                    <div id="refundCollapseThree" class="accordion-collapse collapse" data-bs-parent="#refundQuestions">
                        <div class="accordion-body">
                            <strong>Обратитесь в поддержку немедленно.</strong> В случае двойной оплаты 
                            мы вернем лишний платеж в течение 24 часов. Предоставьте:
                            <ul class="mt-2">
                                <li>Номера обоих заказов</li>
                                <li>Данные платежей (если есть)</li>
                                <li>Email, использованный при оплате</li>
                            </ul>
                            <div class="alert alert-info small mt-2">
                                <i class="fas fa-info-circle me-2"></i>
                                Двойные платежи часто случаются при медленном интернете или 
                                многократном нажатии кнопки "Оплатить".
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 4 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="refundHeadingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#refundCollapseFour">
                            Можно ли обменять товар на другой?
                        </button>
                    </h3>
                    <div id="refundCollapseFour" class="accordion-collapse collapse" data-bs-parent="#refundQuestions">
                        <div class="accordion-body">
                            <strong>Да, возможен обмен в некоторых случаях.</strong> Если купленный товар 
                            вам не подошел, но соответствует описанию и технически исправен, вы можете:
                            <ol class="mt-2">
                                <li>Запросить возврат средств (если не скачивали товар)</li>
                                <li>После возврата купить другой товар</li>
                            </ol>
                            <p class="mb-0 mt-2 small text-muted">
                                Прямой обмен одного товара на другой технически невозможен из-за 
                                особенностей цифровых продуктов.
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 5 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="refundHeadingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#refundCollapseFive">
                            Что делать, если продавец не отвечает на запрос о возврате?
                        </button>
                    </h3>
                    <div id="refundCollapseFive" class="accordion-collapse collapse" data-bs-parent="#refundQuestions">
                        <div class="accordion-body">
                            <strong>Мы отвечаем на все запросы в течение 10 рабочих дней.</strong> 
                            Если прошло больше времени:
                            <ul class="mt-2">
                                <li>Проверьте папку "Спам" в вашем email</li>
                                <li>Напишите повторный запрос с пометкой "Повтор"</li>
                                <li>Обратитесь через другой канал связи</li>
                            </ul>
                            <p class="mb-0 mt-2 small text-muted">
                                В крайнем случае вы можете обратиться в Роспотребнадзор или суд, 
                                но мы стремимся решать все вопросы до этого этапа.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Контакты для вопросов -->
    <div class="row">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body text-center">
                    <h5 class="card-title mb-3">
                        <i class="fas fa-headset text-primary me-2"></i>Остались вопросы?
                    </h5>
                    <p class="card-text mb-4">
                        Свяжитесь с нашей службой поддержки для получения дополнительной информации
                    </p>
                    <div class="d-grid gap-2 d-md-block">
                        <a href="/contacts.php" class="btn btn-primary me-md-2">
                            <i class="fas fa-envelope me-2"></i>Написать в поддержку
                        </a>
                        <a href="/faq.php" class="btn btn-outline-primary">
                            <i class="fas fa-question-circle me-2"></i>Частые вопросы
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.steps-timeline-refund {
    position: relative;
    padding-left: 40px;
}

.steps-timeline-refund::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 0;
    bottom: 0;
    width: 4px;
    background: linear-gradient(to bottom, #17a2b8, #20c997);
    border-radius: 2px;
}

.step-card-refund {
    position: relative;
    margin-bottom: 30px;
    background: white;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.step-number-refund {
    position: absolute;
    left: -50px;
    top: 0;
    width: 40px;
    height: 40px;
    background: #17a2b8;
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 18px;
    box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
}

.step-content-refund {
    padding-left: 20px;
}

.refund-condition-icon {
    height: 100px;
    display: flex;
    align-items: center;
    justify-content: center;
}

@media (max-width: 768px) {
    .steps-timeline-refund {
        padding-left: 0;
    }
    
    .steps-timeline-refund::before {
        display: none;
    }
    
    .step-number-refund {
        position: relative;
        left: 0;
        top: 0;
        margin-bottom: 15px;
        display: inline-block;
    }
    
    .step-content-refund {
        padding-left: 0;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Форма запроса возврата
    const refundForm = document.getElementById('refundRequestForm');
    
    if (refundForm) {
        refundForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Валидация
            const name = document.getElementById('refundName').value;
            const email = document.getElementById('refundEmail').value;
            const orderNumber = document.getElementById('orderNumber').value;
            const reason = document.getElementById('refundReason').value;
            const description = document.getElementById('problemDescription').value;
            const agreeTerms = document.getElementById('agreeTerms').checked;
            
            if (!name || !email || !orderNumber || !reason || !description || !agreeTerms) {
                showNotification('Заполните все обязательные поля', 'error');
                return;
            }
            
            // Собираем данные
            const formData = {
                name: name,
                email: email,
                order_number: orderNumber,
                reason: reason,
                description: description,
                proof_links: document.getElementById('proofLinks').value,
                delete_files: document.getElementById('deleteFiles').checked,
                timestamp: new Date().toISOString()
            };
            
            // Отправляем запрос
            fetch('/api/request-refund.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-Token': window.App.csrfToken
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification('Запрос на возврат успешно отправлен! Мы свяжемся с вами в течение 10 рабочих дней.', 'success');
                    refundForm.reset();
                } else {
                    showNotification(data.error || 'Ошибка отправки запроса', 'error');
                }
            })
            .catch(error => {
                showNotification('Ошибка соединения с сервером', 'error');
                console.error('Error:', error);
            });
        });
    }
    
    // Анимация шагов возврата
    const observerOptions = {
        threshold: 0.2,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateX(0)';
            }
        });
    }, observerOptions);
    
    document.querySelectorAll('.step-card-refund').forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateX(-20px)';
        card.style.transition = `opacity 0.5s ${index * 0.1}s, transform 0.5s ${index * 0.1}s`;
        observer.observe(card);
    });
});
</script>

<?php include 'templates/footer.php'; ?>