        </main>
    </div>
</div>

<!-- Скрипты -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>

<!-- Админ JavaScript -->
<script src="/assets/js/admin.js"></script>

<script>
    // Инициализация Feather иконок
    feather.replace();
    
    // Активация тултипов
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // Активация поповеров
    var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
    var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl);
    });
    
    // Автосохранение форм в админке
    document.querySelectorAll('form[data-autosave]').forEach(form => {
        const formId = form.id || 'admin-form-' + Math.random().toString(36).substr(2, 9);
        
        // Восстановление данных
        const savedData = localStorage.getItem('admin_form_' + formId);
        if (savedData) {
            try {
                const data = JSON.parse(savedData);
                Object.keys(data).forEach(key => {
                    const input = form.querySelector(`[name="${key}"]`);
                    if (input) {
                        input.value = data[key];
                    }
                });
            } catch(e) {
                console.error('Error restoring form data:', e);
            }
        }
        
        // Автосохранение
        form.addEventListener('input', debounce(() => {
            const formData = {};
            new FormData(form).forEach((value, key) => {
                formData[key] = value;
            });
            localStorage.setItem('admin_form_' + formId, JSON.stringify(formData));
        }, 1000));
        
        // Очистка при отправке
        form.addEventListener('submit', () => {
            localStorage.removeItem('admin_form_' + formId);
        });
    });
    
    // Подтверждение удаления
    document.querySelectorAll('a[data-confirm], button[data-confirm]').forEach(element => {
        element.addEventListener('click', function(e) {
            const message = this.getAttribute('data-confirm') || 'Вы уверены?';
            if (!confirm(message)) {
                e.preventDefault();
                return false;
            }
        });
    });
    
    // Копирование в буфер обмена
    document.querySelectorAll('[data-copy]').forEach(element => {
        element.addEventListener('click', function() {
            const text = this.getAttribute('data-copy');
            navigator.clipboard.writeText(text).then(() => {
                const originalHTML = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check me-1"></i>Скопировано';
                setTimeout(() => {
                    this.innerHTML = originalHTML;
                }, 2000);
            });
        });
    });
    
    // Debounce функция
    function debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
    
    // Уведомления в админке
    function showAdminNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = 'top: 70px; right: 20px; z-index: 9999; max-width: 400px;';
        
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.remove();
        }, 5000);
    }
    
    // Глобальные переменные админки
    window.Admin = {
        showNotification: showAdminNotification,
        confirmAction: function(message, callback) {
            if (confirm(message)) {
                callback();
            }
        },
        updateCounter: function(counterId, value) {
            const counter = document.getElementById(counterId);
            if (counter) {
                counter.textContent = value;
            }
        }
    };
    
    // Отслеживание изменений в формах
    document.querySelectorAll('form').forEach(form => {
        let isDirty = false;
        const initialData = new FormData(form);
        
        form.addEventListener('input', () => {
            isDirty = true;
        });
        
        window.addEventListener('beforeunload', (e) => {
            if (isDirty) {
                e.preventDefault();
                e.returnValue = 'У вас есть несохраненные изменения. Вы уверены, что хотите уйти?';
                return e.returnValue;
            }
        });
        
        form.addEventListener('submit', () => {
            isDirty = false;
        });
    });
</script>

</body>
</html>
<?php ob_end_flush(); ?>