<!-- Основной контейнер -->
<div class="container-fluid">
    <div class="row">
        <!-- Сайдбар -->
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
            <div class="sidebar-sticky pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>" 
                           href="/admin/">
                            <i class="fas fa-tachometer-alt me-2"></i>
                            Панель управления
                        </a>
                    </li>
                </ul>
                
                <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <span>Контент</span>
                </h6>
                
                <ul class="nav flex-column mb-2">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'active' : ''; ?>" 
                           href="/admin/products.php">
                            <i class="fas fa-box me-2"></i>
                            Товары
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : ''; ?>" 
                           href="/admin/categories.php">
                            <i class="fas fa-tags me-2"></i>
                            Категории
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'moderation.php' ? 'active' : ''; ?>" 
                           href="/admin/moderation.php">
                            <i class="fas fa-check-circle me-2"></i>
                            Модерация
                            <?php 
                            $db = db();
                            $modCount = $db->query("SELECT COUNT(*) as cnt FROM products WHERE requires_moderation = 1")->fetch_assoc()['cnt'];
                            if ($modCount > 0): ?>
                            <span class="badge bg-danger rounded-pill float-end"><?php echo $modCount; ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                </ul>
                
                <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <span>Продажи</span>
                </h6>
                
                <ul class="nav flex-column mb-2">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'orders.php' ? 'active' : ''; ?>" 
                           href="/admin/orders.php">
                            <i class="fas fa-shopping-cart me-2"></i>
                            Заказы
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'payments.php' ? 'active' : ''; ?>" 
                           href="/admin/payments.php">
                            <i class="fas fa-credit-card me-2"></i>
                            Платежи
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'discounts.php' ? 'active' : ''; ?>" 
                           href="/admin/discounts.php">
                            <i class="fas fa-percent me-2"></i>
                            Скидки
                        </a>
                    </li>
                </ul>
                
                <?php if ($_SESSION['user_role'] === 'admin'): ?>
                <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <span>Администрирование</span>
                </h6>
                
                <ul class="nav flex-column mb-2">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>" 
                           href="/admin/users.php">
                            <i class="fas fa-users me-2"></i>
                            Пользователи
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'reviews.php' ? 'active' : ''; ?>" 
                           href="/admin/reviews.php">
                            <i class="fas fa-star me-2"></i>
                            Отзывы
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'logs.php' ? 'active' : ''; ?>" 
                           href="/admin/logs.php">
                            <i class="fas fa-clipboard-list me-2"></i>
                            Логи
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : ''; ?>" 
                           href="/admin/settings.php">
                            <i class="fas fa-cog me-2"></i>
                            Настройки
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'backup.php' ? 'active' : ''; ?>" 
                           href="/admin/backup.php">
                            <i class="fas fa-database me-2"></i>
                            Резервные копии
                        </a>
                    </li>
                </ul>
                <?php endif; ?>
                
                <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
                    <span>Аналитика</span>
                </h6>
                
                <ul class="nav flex-column mb-2">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'statistics.php' ? 'active' : ''; ?>" 
                           href="/admin/statistics.php">
                            <i class="fas fa-chart-bar me-2"></i>
                            Статистика
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : ''; ?>" 
                           href="/admin/reports.php">
                            <i class="fas fa-file-alt me-2"></i>
                            Отчеты
                        </a>
                    </li>
                </ul>
                
                <!-- Быстрые действия -->
                <div class="px-3 mt-4">
                    <h6 class="text-muted mb-2">Быстрые действия</h6>
                    <div class="d-grid gap-2">
                        <a href="/admin/products.php?action=add" class="btn btn-sm btn-success">
                            <i class="fas fa-plus me-1"></i>Добавить товар
                        </a>
                        <a href="/admin/orders.php?filter=today" class="btn btn-sm btn-primary">
                            <i class="fas fa-shopping-cart me-1"></i>Заказы сегодня
                        </a>
                    </div>
                </div>
            </div>
        </nav>
        
        <!-- Основной контент -->
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4 pt-3">