    </main>
    
    <!-- Подвал -->
    <footer class="footer mt-auto">
        <div class="container">
            <div class="row py-5">
                <!-- Информация о магазине -->
                <div class="col-lg-4 mb-4">
                    <h5 class="mb-3">
                        <i class="fas fa-store me-2"></i><?php echo SITE_NAME; ?>
                    </h5>
                    <p class="text-muted">
                        Магазин цифровых товаров. Программы, игры, шаблоны, курсы и графика.
                        Быстрая доставка, мгновенное скачивание после оплаты.
                    </p>
                    <div class="social-links mt-3">
                        <a href="#" class="me-3" title="VK"><i class="fab fa-vk fa-lg"></i></a>
                        <a href="#" class="me-3" title="Telegram"><i class="fab fa-telegram fa-lg"></i></a>
                        <a href="#" class="me-3" title="YouTube"><i class="fab fa-youtube fa-lg"></i></a>
                        <a href="#" title="GitHub"><i class="fab fa-github fa-lg"></i></a>
                    </div>
                </div>
                
                <!-- Быстрые ссылки -->
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5 class="mb-3">Магазин</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="/catalog.php" class="text-decoration-none">Каталог товаров</a></li>
                        <li class="mb-2"><a href="/categories.php" class="text-decoration-none">Категории</a></li>
                        <li class="mb-2"><a href="/popular.php" class="text-decoration-none">Популярное</a></li>
                        <li class="mb-2"><a href="/new.php" class="text-decoration-none">Новинки</a></li>
                        <li class="mb-2"><a href="/discounts.php" class="text-decoration-none">Скидки</a></li>
                    </ul>
                </div>
                
                <!-- Помощь -->
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5 class="mb-3">Помощь</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="/faq.php" class="text-decoration-none">FAQ</a></li>
                        <li class="mb-2"><a href="/help.php" class="text-decoration-none">Как купить</a></li>
                        <li class="mb-2"><a href="/download-guide.php" class="text-decoration-none">Как скачать</a></li>
                        <li class="mb-2"><a href="/refund.php" class="text-decoration-none">Возврат</a></li>
                        <li class="mb-2"><a href="/contacts.php" class="text-decoration-none">Контакты</a></li>
                    </ul>
                </div>
                
                <!-- Контакты -->
                <div class="col-lg-4 mb-4">
                    <h5 class="mb-3">Контакты</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            <a href="mailto:support@<?php echo parse_url(SITE_URL, PHP_URL_HOST); ?>" class="text-decoration-none">
                                support@<?php echo parse_url(SITE_URL, PHP_URL_HOST); ?>
                            </a>
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-clock me-2"></i>
                            Поддержка: 24/7
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-shield-alt me-2"></i>
                            Безопасная оплата
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-download me-2"></i>
                            Мгновенная доставка
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Нижняя часть -->
            <div class="border-top pt-4">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <p class="mb-0 text-muted">
                            &copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. Все права защищены.
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <ul class="list-inline mb-0">
                            <li class="list-inline-item">
                                <a href="/privacy.php" class="text-decoration-none text-muted small">Политика конфиденциальности</a>
                            </li>
                            <li class="list-inline-item">
                                <a href="/terms.php" class="text-decoration-none text-muted small">Пользовательское соглашение</a>
                            </li>
                        </ul>
                    </div>
                </div>
        
                <!-- Платежные системы -->
                <div class="mt-3 text-center">
                    <small class="text-muted d-block mb-2">Принимаем к оплате:</small>
                    <div class="payment-methods">
                        <i class="fab fa-cc-yandex-money fa-2x me-3" title="ЮMoney"></i>
                        <i class="fab fa-cc-visa fa-2x me-3" title="Visa"></i>
                        <i class="fab fa-cc-mastercard fa-2x me-3" title="MasterCard"></i>
                        <i class="fab fa-cc-mir fa-2x me-3" title="Мир"></i>
                        <i class="fas fa-mobile-alt fa-2x" title="Мобильные платежи"></i>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Модальное окно для уведомлений -->
    <div class="modal fade" id="notificationModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="notificationTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="notificationBody"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Скрипты -->
    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Основной JavaScript -->
    <script src="/assets/js/main.js"></script>
    
    <!-- Ленивая загрузка -->
    <script src="<?php echo SITE_URL; ?>/assets/js/lazy-load.js"></script>
    
    <!-- Анимации -->
    <script src="<?php echo SITE_URL; ?>/assets/js/animations.js"></script>
    
    <!-- Инициализация -->
    <script>
        // Показываем страницу после загрузки
        document.addEventListener('DOMContentLoaded', function() {
            document.documentElement.classList.add('loaded');
            
            // Инициализация иконки темы
            updateThemeIcon('<?php echo $theme_cookie; ?>');
            
            // Инициализация CSRF токена для AJAX
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            
            // Глобальный объект для хранения данных
            window.App = {
                csrfToken: csrfToken,
                userId: <?php echo $is_logged_in ? $_SESSION['user_id'] : 'null'; ?>,
                isAdmin: <?php echo $is_admin ? 'true' : 'false'; ?>,
                siteUrl: '<?php echo SITE_URL; ?>'
            };
            
            // Отслеживание событий для аналитики
            document.addEventListener('click', function(e) {
                if (e.target.matches('a[href], button')) {
                    const element = e.target.closest('a[href]') || e.target.closest('button');
                    logEvent('click', {
                        element: element.tagName,
                        text: element.textContent.substring(0, 50),
                        href: element.href || null,
                        page: '<?php echo $current_page; ?>'
                    });
                }
            });
            
            // Обработка формы подписки
            const subscribeForm = document.getElementById('subscribeForm');
            if (subscribeForm) {
                subscribeForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const email = this.querySelector('input[type="email"]').value;
                    
                    fetch('/api/subscribe.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-Token': csrfToken
                        },
                        body: JSON.stringify({ email: email })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            showNotification('Спасибо за подписку!', 'success');
                            this.reset();
                        } else {
                            showNotification(data.error || 'Ошибка подписки', 'error');
                        }
                    });
                });
            }
            
            // Автосохранение форм
            const forms = document.querySelectorAll('form[autosave]');
            forms.forEach(form => {
                form.addEventListener('input', debounce(function() {
                    saveFormData(form);
                }, 1000));
                
                // Восстановление данных при загрузке
                restoreFormData(form);
            });
            
            // Плавная прокрутка к якорям
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href === '#') return;
                    
                    const target = document.querySelector(href);
                    if (target) {
                        e.preventDefault();
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
        });
        
        // Вспомогательные функции
        function updateThemeIcon(theme) {
            const icon = document.getElementById('theme-icon');
            if (icon) {
                icon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon';
            }
        }
        
        function toggleTheme() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            // Обновляем атрибут и иконку
            document.documentElement.setAttribute('data-theme', newTheme);
            updateThemeIcon(newTheme);
            
            // Динамически загружаем CSS темы
            const themeLink = document.getElementById('theme-css');
            if (themeLink) {
                themeLink.href = `/assets/css/${newTheme}-theme.css?t=${Date.now()}`;
            }
            
            // Сохраняем в куки
            document.cookie = `theme=${newTheme}; path=/; max-age=${60*60*24*365}; samesite=strict`;
            
            // Отправляем на сервер (если пользователь авторизован)
            if (window.App.userId) {
                fetch('/api/update-theme.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-Token': window.App.csrfToken
                    },
                    body: JSON.stringify({ theme: newTheme })
                });
            }
            
            // Логируем событие
            logEvent('theme_change', { theme: newTheme });
        }
        
        function showNotification(message, type = 'info') {
            // Используем Bootstrap тосты
            const toastContainer = document.getElementById('toastContainer');
            if (!toastContainer) {
                // Создаем контейнер для тостов
                const container = document.createElement('div');
                container.id = 'toastContainer';
                container.style.cssText = 'position: fixed; top: 20px; right: 20px; z-index: 99999;';
                document.body.appendChild(container);
            }
            
            const toastId = 'toast-' + Date.now();
            const toast = document.createElement('div');
            toast.className = `toast align-items-center text-bg-${type} border-0`;
            toast.setAttribute('role', 'alert');
            toast.id = toastId;
            
            toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;
            
            document.getElementById('toastContainer').appendChild(toast);
            
            const bsToast = new bootstrap.Toast(toast, {
                delay: 3000,
                autohide: true
            });
            
            bsToast.show();
            
            // Удаляем после скрытия
            toast.addEventListener('hidden.bs.toast', function() {
                toast.remove();
            });
        }
        
        function logEvent(action, data = {}) {
            // Отправляем события на сервер для аналитики
            if (navigator.sendBeacon) {
                const logData = {
                    action: action,
                    data: data,
                    timestamp: Date.now(),
                    userAgent: navigator.userAgent,
                    referrer: document.referrer,
                    url: window.location.href
                };
                
                navigator.sendBeacon('/api/log-event.php', JSON.stringify(logData));
            }
        }
        
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
        
        function saveFormData(form) {
            const formData = {};
            const inputs = form.querySelectorAll('input, textarea, select');
            
            inputs.forEach(input => {
                if (input.name) {
                    formData[input.name] = input.value;
                }
            });
            
            localStorage.setItem(`form_${form.id || 'auto'}_${window.location.pathname}`, 
                JSON.stringify(formData));
        }
        
        function restoreFormData(form) {
            const saved = localStorage.getItem(`form_${form.id || 'auto'}_${window.location.pathname}`);
            if (saved) {
                const formData = JSON.parse(saved);
                Object.keys(formData).forEach(name => {
                    const input = form.querySelector(`[name="${name}"]`);
                    if (input) {
                        input.value = formData[name];
                    }
                });
            }
        }
        
        // Обработка ошибок
        window.addEventListener('error', function(e) {
            logEvent('js_error', {
                message: e.message,
                filename: e.filename,
                lineno: e.lineno,
                colno: e.colno
            });
        });
        
        window.addEventListener('unhandledrejection', function(e) {
            logEvent('promise_error', {
                reason: e.reason?.toString()
            });
        });
        
        // Отслеживание производительности
        if ('PerformanceObserver' in window) {
            const perfObserver = new PerformanceObserver((list) => {
                list.getEntries().forEach(entry => {
                    if (entry.entryType === 'largest-contentful-paint') {
                        logEvent('performance_lcp', { value: entry.startTime });
                    }
                });
            });
            
            perfObserver.observe({ entryTypes: ['largest-contentful-paint'] });
        }
        
        // Проверка онлайн статуса
        window.addEventListener('online', function() {
            showNotification('Соединение восстановлено', 'success');
        });
        
        window.addEventListener('offline', function() {
            showNotification('Нет подключения к интернету', 'warning');
        });
    </script>
    
    <!-- Yandex.Metrika counter -->
    <script type="text/javascript" >
        (function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
        m[i].l=1*new Date();
        for (var j = 0; j < document.scripts.length; j++) {if (document.scripts[j].src === r) { return; }}
        k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})
        (window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");
        
        ym(00000000, "init", {
            clickmap:true,
            trackLinks:true,
            accurateTrackBounce:true,
            webvisor:true
        });
    </script>
    <noscript><div><img src="https://mc.yandex.ru/watch/00000000" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
    <!-- /Yandex.Metrika counter -->
    
    <!-- LiveInternet counter -->
    <script type="text/javascript">
        new Image().src = "//counter.yadro.ru/hit?r"+
        escape(document.referrer)+((typeof(screen)=="undefined")?"":
        ";s"+screen.width+"*"+screen.height+"*"+(screen.colorDepth?
        screen.colorDepth:screen.pixelDepth))+";u"+escape(document.URL)+
        ";h"+escape(document.title.substring(0,150))+
        ";"+Math.random();
    </script>
    <!-- /LiveInternet counter -->
</body>
</html>
<?php
// Завершаем буферизацию и выводим содержимое
ob_end_flush();
?>