<?php
$title = 'Чёрный список URL';
require_once '../sys/sys.php';
require_once '../sys/db.php';
require_once '../sys/head.php';

if (!isset($_SESSION['admin'])) {
    echo '<div class="menu">Ошибка! Такой страницы не существует!</div>';
    require_once '../sys/foot.php';
    exit;
}

$query = "SELECT * FROM `sett` LIMIT 1";
$result = $mysqli->query($query);
if (!$result) {
    die('Ошибка при получении настроек: ' . $mysqli->error);
}
if ($result->num_rows === 0) {
    die('Ошибка: Настройки не найдены в таблице `sett`.');
}
$set = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ok'])) {
    $black_links = !empty($_POST['black_links']) ? json_encode(mb_strtolower($_POST['black_links']), JSON_FORCE_OBJECT) : 0;

    $query = "UPDATE `sett` SET `black_links` = ?";
    $stmt = $pdo->prepare($query);
    
    if (!$stmt) {
        error_log('Ошибка подготовки запроса');
        echo '<div class="alert alert-danger">Ошибка при обновлении настроек. Пожалуйста, попробуйте позже.</div>';
    } else if ($stmt->execute([$black_links])) {
        echo '<div class="alert alert-success">Настройки успешно изменены!<br/><a href="/admin/filtr">Назад</a></div>';
        require_once '../sys/foot.php';
        exit;
    } else {
        echo '<div class="alert alert-danger">Ошибка при обновлении настроек</div>';
    }
}

echo '<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">Черный список сайтов</h2>
    </div>
    <br/>
</div><br/>
<div class="container">
    <div class="row">
        <div class="col-lg-4 col-md-3"></div>
        <div class="col-lg-4 col-md-6">
            <div class="alert bg-light stat" style="margin-top: -55px;">
                <h5>Черный список URL</h5><hr>
                <form action="/admin/filtr" method="post" name="form">
                    <div class="form-group login-form">                        
                        <label>Cсылка через запятую:</label>
                        <textarea name="black_links" cols="30" rows="10" class="form-control">' . htmlspecialchars(json_decode($set['black_links'])) . '</textarea>
                        
                        <input name="ok" type="submit" value="Сохранить" class="btn btn-info btn-lg mt-3" style="width: 100%;"/>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>';

echo '<div class="container">
    <div class="row">
        <div class="col-lg-4 col-md-3"></div>
        <div class="col-lg-4 col-md-6">
            <div class="alert bg-light stat" style="margin-top: -55px;">
                <center><a href="/admin/" class="btn btn-secondary">Админ панель</a></center>
            </div>
        </div>
    </div>
</div>';

require_once '../sys/foot.php';
?>