<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$title = 'Контакты';
require_once 'sys/sys.php';
require_once 'sys/head.php';
require_once 'sys/db.php';
require_once 'sys/censure.php';

$notifications = [];

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$name = '';
$email = '';
$message = '';
$ip = $_SERVER['REMOTE_ADDR'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrfToken = $_POST['csrf_token'] ?? '';
    $honeypot = $_POST['website'] ?? '';
    $name = htmlspecialchars(trim($_POST['name'] ?? ''));
    $email = htmlspecialchars(trim($_POST['email'] ?? ''));
    $message = htmlspecialchars(trim($_POST['message'] ?? ''));

    if ($honeypot !== '') {
        $notifications[] = 'Обнаружен спам.';
    }

    if ($csrfToken !== $_SESSION['csrf_token']) {
        $notifications[] = 'Неверный токен безопасности.';
    }

    if (isset($_SESSION['last_submit_time'])) {
        $lastSubmitTime = $_SESSION['last_submit_time'];
        if (time() - $lastSubmitTime < 600) {
            $notifications[] = 'Вы можете отправлять сообщения не чаще, чем раз в 10 минут.';
        }
    }

    if (empty($notifications)) {
        if (empty($name) || empty($email) || empty($message)) {
            $notifications[] = 'Пожалуйста, заполните все поля формы.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $notifications[] = 'Укажите корректный email.';
        } elseif (strlen($message) > 5000) {
            $notifications[] = 'Сообщение не должно превышать 5000 символов.';
        } elseif (censure($name)) {
            $notifications[] = 'Имя содержит недопустимые слова. Пожалуйста, используйте другое имя.';
        } elseif (censure($message)) {
            $notifications[] = 'Сообщение содержит недопустимые слова. Пожалуйста, перефразируйте его.';
        } else {
            $to = 'ваша почта';
            $subject = 'Новое сообщение от ' . $name;
            $headers = "From: ваша почта\r\n";
            $headers .= "Reply-To: $email\r\n";
            $headers .= "Content-Type: text/plain; charset=utf-8\r\n";
            $emailBody = "Имя: $name\nEmail: $email\nСообщение:\n$message";

            $mailSent = mail($to, $subject, $emailBody, $headers);
            $stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, message, ip_address) 
                                   VALUES (:name, :email, :message, :ip)");
            if ($stmt->execute([
                'name' => $name,
                'email' => $email,
                'message' => $message,
                'ip' => $ip
            ])) {
                if ($mailSent) {
                    $notifications[] = 'Сообщение успешно отправлено!';
                    $_SESSION['last_submit_time'] = time();
                    $name = $email = $message = '';
                } else {
                    $notifications[] = 'Ошибка при отправке письма.';
                }
            } else {
                $notifications[] = 'Ошибка при записи в базу данных.';
            }
        }
    }
}
?>

<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">Техническая поддержка</h2>
    </div>
    <div class="container">
        <center>
            <p class="text-light" style="position: relative;z-index: 99;font-size: 120%;">
                Для решения проблем, по-поводу сотрудничества и других вопросов.
            </p>
        </center>
    </div><br/>
</div><br/>

<div class="container">
    <center>
        <div class="row">
            <div class="col-md-12">
                <div class="card bg-light">
                    <div class="card-header">Обратная связь</div>
                    <div class="card-body">
                        <?php if (!empty($notifications)): ?>
                            <?php foreach ($notifications as $notification): ?>
                                <div class="<?= (strpos($notification, 'успешно') !== false ? 'alert alert-success' : 'alert alert-danger'); ?>">
                                    <?= $notification; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>

                        <form method="POST" action="" onsubmit="return validateForm()">
                            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token']; ?>">
                            <input type="text" name="website" style="display: none;">

                            <div class="form-group mb-3">
                                <label for="name">Имя:</label>
                                <input type="text" id="name" name="name" class="form-control" value="<?= htmlspecialchars($name); ?>" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="email">Email:</label>
                                <input type="email" id="email" name="email" class="form-control" value="<?= htmlspecialchars($email); ?>" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="message">Сообщение:</label>
                                <textarea id="message" name="message" rows="5" maxlength="5000" class="form-control" required><?= htmlspecialchars($message); ?></textarea>
                                <div id="charCount" class="text-muted">Введено символов: <?= strlen($message); ?>/5000</div>
                            </div>

                            <div class="form-group mb-3">
                                <button type="submit" class="btn btn-primary">Отправить</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </center>
</div>

<script>
    const messageInput = document.getElementById('message');
    const charCount = document.getElementById('charCount');

    messageInput.addEventListener('input', function() {
        const currentLength = messageInput.value.length;
        charCount.textContent = `Введено символов: ${currentLength}/5000`;
    });

    function validateForm() {
        const name = document.getElementById('name').value.trim();
        const email = document.getElementById('email').value.trim();
        const message = document.getElementById('message').value.trim();

        if (name === "" || email === "" || message === "") {
            alert("Пожалуйста, заполните все поля формы.");
            return false;
        }

        const emailPattern = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,6}$/;
        if (!emailPattern.test(email)) {
            alert("Пожалуйста, введите корректный email.");
            return false;
        }

        return true;
    }
</script>

<?php
require_once 'sys/foot.php';
?>