<?php 
  
/*
------------------------------------------------
AlphaCMS - универсальный движок для вашего сайта
E-mail администрации проекта: adm@alpha-cms.ru
Официальный сайт поддержки: alpha-cms.ru
Руководитель проекта: adm (ID 1)
------------------------------------------------
*/
  
FOREACH (ARRAY('config', 'connect', 'users') AS $connect) {
  
  INCLUDE_ONCE ("../../system/connections/global/$connect.php"); 
  
}

ACCESS('management');

IF (ISSET($_FILES['file']) && AJAX() == TRUE){
  
  //От
  $from = INTVAL(POST('from'));
  
  //До
  $before = INTVAL(POST('before'));
  
  //Максимальный размер для выгрузки
  $MaxFileSize = CONFIG('MAXFILESIZE');
  
  //Разрешенные форматы для выгрузки
  $AllowFileExtension = ARRAY('jpg', 'jpeg', 'png', 'gif');
  
  //Оригинальное название изображения
  $FileNameExp = $_FILES['file']['name'];
  
  //Расширение изображения
  $Exp = STRTOLOWER(PREG_REPLACE('#^.*\.#', NULL, $FileNameExp));
  
  //Временный файл
  $TempName = $_FILES['file']['tmp_name'];
  
  //Папка куда будут загружаться изображения
  $UploadDir = ROOT."/files/upload/medal/";
  
  //Проверка расширения изображения
  $FileExtension = PATHINFO(STRTOLOWER($FileNameExp), PATHINFO_EXTENSION);
  
  //Определяем ширину и высоту изображения
  $xy = GETIMAGESIZE($TempName);  
  $width = $xy[0]; 
  $height = $xy[1];  
  
  $err_data = 0;
  
  IF ($from > $before){
    
    $error = "Значение в поле От не может быть больше значения в поле До";
    $err_data = 1;
  
  }
  
  IF ($before <= 0){
    
    $error = "Значение в поле До не может быть меньше 0";
    $err_data = 1;
  
  }
  
  IF ($xy == FALSE) {
    
    $error = "Не удалось получить содержимое изображения";
    $err_data = 1;
  
  }
  
  IF ($width > 100) {
    
    $error = "Ширина изображения не может быть больше 100px. Текущая ширина: ".$width."px";
    $err_data = 1;
  
  }
  
  IF ($height > 100) {
    
    $error = "Высота изображения не может быть больше 100px. Текущая высота: ".$height."px";
    $err_data = 1;
  
  }
  
  IF (!IN_ARRAY($FileExtension, $AllowFileExtension)) {
    
    $error = "Неверный формат изображения";
    $err_data = 1;
  
  }
  
  //Проверка размера изображения
  IF (FILESIZE($TempName) > $MaxFileSize) {
    
    $error = "Размер загружаемого изображения превышает установленные ограничения";
    $err_data = 1;
  
  }
  
  IF ($err_data == 1){
    
    ECHO "<div class='file-upload-progress'><i class='fa fa-exclamation-triangle fa-fw'></i> ".LG($error)."</div>";
  
  }ELSE{
    
    $ID = DB::GET_ADD("INSERT INTO `RATING_MEDAL` (`FROM`, `BEFORE`, `EXT`) VALUES ('".$from."', '".$before."', '".$Exp."')");
    
    //Сохраняем изображение если все хорошо
    $CopyFile = COPY($TempName, "".$UploadDir."".$ID.".".$Exp."");
    
    IF (!$CopyFile) {
      
      ECHO "<div class='file-upload-progress'><i class='fa fa-exclamation-triangle fa-fw'></i> ".LG('Неизвестная ошибка')."</div>";
      
      DB::GET_SET("DELETE FROM `RATING_MEDA` WHERE `ID` = '".$ID."' LIMIT 1");
    
    }ELSE{
      
      //Отправляем запрос на обновление листа если успешно
      ?>
      <script>  
        
      var data = "/panel/?path=site&section=modules&mod=rating&get=add_medal";
      var toLoad = data+' #medal_upgrade';
      
      $("#medal_upgrade").load(toLoad);
      
      </script>  
      <?
    
    }
  
  }
  
}ELSE{
  
  ECHO LG('Не удалось установить соединение с ресивером.');

}
 
?>