<?php  
$game = db::get_string("SELECT * FROM `GAMES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$game_count = db::get_column("SELECT COUNT(*) FROM `GAMES_USERS` WHERE `GAME_ID` = ?", [$game['ID']]);
acms_header(lg('Пользователи в игре %s', tabs($game['NAME'])), 'users');
is_active_module('PRIVATE_GAMES');

if (!isset($game['ID'])) {
  
  error('Неверная директива');
  redirect('/m/games/');

}

if (get('get') == 'friends') {
  
  $root = 'friends';
  $name = 'Друзья в игре';
  $column = db::get_column("SELECT COUNT(`FRIENDS`.`USER_ID`) AS `count_fr` FROM `GAMES_USERS` LEFT JOIN `FRIENDS` ON (`FRIENDS`.`USER_ID` = `GAMES_USERS`.`USER_ID`) WHERE `FRIENDS`.`USER_ID` > '0' AND `GAMES_USERS`.`GAME_ID` = ? AND `FRIENDS`.`MY_ID` = ? AND `FRIENDS`.`ACT` = '0'", [$game['ID'], user('ID')]);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
  $data = db::get_string_all("SELECT `FRIENDS`.`USER_ID` FROM `GAMES_USERS` LEFT JOIN `FRIENDS` ON (`FRIENDS`.`USER_ID` = `GAMES_USERS`.`USER_ID`) WHERE `FRIENDS`.`USER_ID` > '0' AND `GAMES_USERS`.`GAME_ID` = ? AND `FRIENDS`.`MY_ID` = ? AND `FRIENDS`.`ACT` = '0' ORDER BY `GAMES_USERS`.`ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$game['ID'], user('ID')]);
  
}else{
  
  $root = 'users';
  $name = 'Пользователи в игре';
  $column = db::get_column("SELECT COUNT(`ID`) FROM `GAMES_USERS` WHERE `GAME_ID` = ?", [$game['ID']]);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
  $data = db::get_string_all("SELECT * FROM `GAMES_USERS` WHERE `GAME_ID` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$game['ID']]);
  
}

?>  
<div class='list'>
<div class="user-avatar-mini">
<img class="img" src="/games/<?=tabs($game['LINK'])?>/img/<?=tabs($game['IMG'])?>" style="width: 60px; height: 60px">
</div>
<div class="user-login-mini" style="padding-left: 20px; width: 55%">
<b><?=tabs($game['NAME'])?></b><br />
<p class="games_info"><?=icons('user', 15, 'fa-fw')?> <?=lg('играют')?> <?=num_format($game_count, 2)?> <?=num_decline($game_count, ['человек', 'человека', 'человек'], 0)?></p>
</div>
</div>

<div class='list-body'>
<div class='list-menu'>
<a href='/m/games/players/?id=<?=$game['ID']?>&get=users' class='btn<?=($root != 'friends' ? '-o' : null)?>'><?=lg('Все пользователи')?></a>
<a href='/m/games/players/?id=<?=$game['ID']?>&get=friends' class='btn<?=($root == 'friends' ? '-o' : null)?>'><?=lg('Друзья')?></a>
</div>
<div class='list-menu'><b><?=lg($name)?>:</b></div>
<?php if ($column == 0) : ?>
<div class='list-menu'><?=lg('Нет пользователей')?></div>
<?php endif ?>
<?

while ($list = $data->fetch()) {
  
  //if ($root == 'friends') { $list['USER_ID'] = $list['MY_ID']; }
  
  require (ROOT.'/modules/users/plugins/list-mini.php');
  echo $list_mini;
  
}
  
?></div><?
  
get_page('/m/games/players/?id='.$game['ID'].'&get='.$root.'&', $spage, $page, 'list');

forward('/m/games/show/?id='.$game['ID'], 'К игре');
back('/m/games/');
acms_footer();