<?php  
$movie = db::get_string("SELECT * FROM `MOVIES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
acms_header(lg('Редактировать - %s', tabs($movie['NAME'])));
access('users');
get_check_valid();
is_active_module('PRIVATE_MOVIES');

if (!isset($movie['ID'])) {
  
  error('Неверная директива');
  redirect('/m/movies/');

}

if (access('movies', null) == false){
  
  error('Нет прав');
  redirect('/m/movies/');
  
}

if (post('ok_edit')){
  
  valid::create(array(
    
    'MOVIE_NAME' => ['name', 'text', [2, 120], 'Название фильма', 0],
    'MOVIE_OPIS' => ['message', 'text', [10, 3000], 'Описание фильма', 0],
    'MOVIE_GENRE' => ['genre', 'text', [0, 250], 'Жанр', 0],
    'MOVIE_COUNTRY' => ['country', 'text', [0, 250], 'Страна', 0],
    'MOVIE_DIRECTOR' => ['director', 'text', [0, 250], 'Режиссер', 0],
    'MOVIE_CREATE' => ['create', 'text', [0, 40], 'Год выпуска', 0]
  
  ));
  
  if ($movie['TITLE'] != MOVIE_TITLE && db::get_column("SELECT COUNT(*) FROM `MOVIES` WHERE `ID` = ? AND `NAME` = ? LIMIT 1", [$movie['ID'], MOVIE_NAME]) > 0){
    
    error('Фильм с таким названием уже существует');
    redirect('/m/movies/edit/?id='.$movie['ID'].'&'.TOKEN_URL);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/movies/edit/?id='.$movie['ID'].'&'.TOKEN_URL);
  
  }
  
  db::get_set("UPDATE `MOVIES` SET `NAME` = ?, `OPIS` = ?, `CREATE` = ?, `DIRECTOR` = ?, `COUNTRY` = ?, `GENRE` = ? WHERE `ID` = ? LIMIT 1", [MOVIE_NAME, MOVIE_OPIS, MOVIE_CREATE, MOVIE_DIRECTOR, MOVIE_COUNTRY, MOVIE_GENRE, $movie['ID']]);
  
  if (access('movies', null) == true){
    
    logs('Онлайн кинотеатр - редактирование фильма [url=/m/movies/show/?id='.$movie['ID'].']'.$movie['NAME'].'[/url]', user('ID'));
    
  }
  
  success('Изменения успешно приняты');
  redirect('/m/movies/show/?id='.$movie['ID']);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/movies/edit/?id=<?=$movie['ID']?>&<?=TOKEN_URL?>'>
<?=html::input('name', 'Название фильма', null, null, tabs($movie['NAME']), 'form-control-100', 'text', null, 'text-width')?>
<?=html::textarea(tabs($movie['OPIS']), 'message', 'Описание фильма', null, 'form-control-textarea', 9, 0)?>  
<br /><br />
<?=html::input('create', 'Год выпуска', null, null, tabs($movie['CREATE']), 'form-control-100', 'text', null, 'clock-o')?>
<?=html::input('country', 'Страна (перечисляйте через ":" без пробелов)', null, null, tabs($movie['COUNTRY']), 'form-control-100', 'text', null, 'globe')?>
<?=html::input('genre', 'Жанр (перечисляйте через ":" без пробелов)', null, null, tabs($movie['GENRE']), 'form-control-100', 'text', null, 'text-width')?>
<?=html::input('director', 'Режиссер (перечисляйте через ":" без пробелов)', null, null, tabs($movie['DIRECTOR']), 'form-control-100', 'text', null, 'text-width')?>
<?=html::button('button ajax-button', 'ok_edit', 'save', 'Сохранить')?> 
<a class='button-o' href='/m/movies/show/?id=<?=$movie['ID']?>'><?=lg('Отмена')?></a>
</form>
</div>
<?

back('/m/movies/show/?id='.$movie['ID']);
acms_footer();