<?php
$movie = db::get_string("SELECT * FROM `MOVIES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
acms_header(lg('Скачать на телефон или смотреть онлайн фильм - %s', tabs($movie['NAME'])));
is_active_module('PRIVATE_MOVIES');

if (!isset($movie['ID'])) {
  
  error('Неверная директива');
  redirect('/m/movies/');

}

/*
---------
Просмотры
---------
*/

if (user('ID') > 0){
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $movie['ID'], 'movies']) == 0){
    
    db::get_add("INSERT INTO `EYE` (`USER_ID`, `TIME`, `OBJECT_ID`, `TYPE`) VALUES (?, ?, ?, ?)", [user('ID'), TM, $movie['ID'], 'movies']);
    
    if ($movie['TIME'] > TM - 9800) {
      
      db::get_set("UPDATE `MOVIES` SET `RATING` = `RATING` + '1' WHERE `ID` = ? LIMIT 1", [$movie['ID']]);
      
    }
  
  }else{
    
    db::get_set("UPDATE `EYE` SET `TIME` = ? WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [TM, $movie['ID'], 'movies']);
    
  }

}

if (user('ID') > 0 && access('movies', null) == true){
  
  require_once (ROOT.'/modules/movies/plugins/delete.php');
  
}

if (user('ID') > 0 && access('movies', null) == true){
  
  ?>
  <div class='list'>
  <a href='/m/movies/edit/?id=<?=$movie['ID']?>&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>        
  <a href='/m/movies/show/?id=<?=$movie['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
  </div>
  <?
  
}

if (str($movie['GENRE']) > 0 && str($movie['GENRE']) < 60){
  
  $ex = explode(':', $movie['GENRE']);  
  $genre = null;
  foreach ($ex as $key => $value) {
    
    if (str($value) > 0) {
      
      $genre .= " <span class='info red' style='margin-top: 5px'>".lg(tabs($value))."</span> ";
    
    }
  
  }
  
  $genre = "<b>".lg('Жанр').":</b><br />".$genre;

}else{
  
  $genre = null;
  
}

if (str($movie['CREATE']) > 0){
  
  $create = "<b>".lg('Год выхода').":</b> ".lg(tabs($movie['CREATE']));

}else{
  
  $create = null;
  
}

if (str($movie['COUNTRY']) > 0){
  
  $ex = explode(':', $movie['COUNTRY']);  
  $country = null;
  foreach ($ex as $key => $value) {
    
    if (str($value) > 0) {
      
      $country .= " <span class='info blue' style='margin-top: 5px'>".lg(tabs($value))."</span> ";
    
    }
  
  }
  
  $country = "<b>".lg('Страна').":</b><br />".$country;

}else{
  
  $country = null;
  
}

if (str($movie['DIRECTOR']) > 0){
  
  $ex = explode(':', $movie['DIRECTOR']);  
  $director = null;
  $s = 0;
  foreach ($ex as $key => $value) {
    
    $s++;
    
    if ($s <= 20 && str($value) > 0) {
      
      $director .= " <span class='info green' style='margin-top: 5px'>".lg(tabs($value))."</span> ";
    
    }
  
  }
  
  $director = "<b>".lg('Актер(-ы)').":</b><br />".$director;

}else{
  
  $director = null;
  
}

if (str($movie['DURATION']) > 0){
  
  $duration = "<b>".lg('Длительность').":</b> ".tabs($movie['DURATION'])." ".lg('мин.');

}else{
  
  $duration = null;
  
}

require_once (ROOT.'/modules/movies/plugins/rating.php');

?>
<div class='list-body'> 
<div class='list-menu'>
<center>
<b style='font-size: 18px'><?=lg(tabs($movie['NAME']))?></b><br /><br />
<iframe src="//73869.annacdn.cc/DgjD3E1WIX7e/<?=$movie['TYPE']?>/<?=intval($movie['DONOR'])?>" width="100%" height="280" frameborder="0" allowfullscreen></iframe><br />
<b><?=lg('Смотреть онлайн')?></b>  
</center>  
<br />
<?=lg(text($movie['OPIS']))?><br /><br />
<b><?=lg('Рейтинг фильма')?>:</b> <?=$mrating?>
<br /><br />
<b><?=lg('Фильм добавлен на сайт')?>:</b> <?=ftime($movie['TIME'])?><br />
<?=$duration.'<br />'.$create.'<br /><br />'.$genre.'<br /><br />'.$country.'<br /><br />'.$director?>
<?php
likes_ajax($movie['ID'], 'movies', 0, 1);
dislikes_ajax($movie['ID'], 'movies');
$action = '/m/movies/show/?id='.$movie['ID'];
?>

<div id='like'>
<?=likes_list($movie['ID'], 'movies', $action)?>
<div class='menu-sw-cont'> 
<a class='menu-sw-cont-left-33' href="/m/eye/?id=<?=$movie['ID']?>&url=<?=base64_encode($action)?>&type=movies&<?=TOKEN_URL?>"><?=icons('eye', 18, 'fa-fw')?> <?=db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [$movie['ID'], 'movies'])?></a><?=mlikes($movie['ID'], $action, 'movies', 'menu-sw-cont-left-33')?><?=mdislikes($movie['ID'], $action, 'movies', 'menu-sw-cont-left-33')?>
</div>
</div>
  
</div>
</div>
  
<div class='list'>
<b><?=lg('Комментарии')?></b> <span class='count'><?=db::get_column("SELECT COUNT(`ID`) FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? LIMIT 1", [$movie['ID'], 'movies_comments'])?></span>
</div>
  
<?  
if (user('ID') == 0){
  
  $comments_set = 'Извините, для вас комментирование недоступно';
  
}

comments($action, 'movies_comments', 1, 'message', 0, $movie['ID']);

back('/m/movies/', 'Назад к фильмам');
acms_footer();