<?php
$account = db::get_string("SELECT `ID` FROM `USERS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);   
acms_header(lg('Сделать подарок %s', user::login_mini($account['ID'])), 'users');

if (!isset($account['ID'])){
  
  error('Неверная директива');
  redirect('/');

}

if ($account['ID'] == user('ID')){
  
  error('Вы не можете делать подарки самому себе');
  redirect('/');

}

if (post('search')){
  
  session('search_gift', esc(post('search')));
  
}

define('SEARCH', tabs(session('search_gift')));

/*
----------------
Подарить подарок
----------------
*/

if (get('id_gift')){
  
  $gift = db::get_string("SELECT * FROM `GIFTS` WHERE `ID` = ? AND `ACT` = '1' LIMIT 1", [intval(get('id_gift'))]);
  
  $sum = $gift['SUM'];
  
  if ($gift['ATIME'] > TM) {
    
    $sum = $gift['SUM'] / 100;
    $sum = $sum * $gift['PERCENT'];
    $sum = $gift['SUM'] - $sum;
    
  }
  
  if (is_file(ROOT.'/users/shop_service/vip_status.php')) {
    
    if (db::get_column("SELECT COUNT(*) FROM `USERS_SETTINGS` WHERE `USER_ID` = ? AND `VIP_STATUS_TIME` > ? LIMIT 1", [user('ID'), TM]) > 0){
      
      $vip = $sum / 2;
      $vip2 = "(".lg('Скидка')." -50%)";
    
    }else{
      
      $vip = $sum;
      $vip2 = null;
    
    }
    
  }else{
    
    $vip = $sum;
    $vip2 = null;
    
  }
  
  if (!isset($gift['ID'])){
    
    error('Неверная директива');
    redirect('/');
  
  }    
  
  if (post('ok_give_gift')){
    
    valid::create(array(
      
      'GIFT_PRIVATE' => ['private', 'number', [0, 10], 'Приватность'],
      'GIFT_MESSAGE' => ['message', 'text', [0, 300], 'Сообщение', 0]
    
    ));
    
    if (ERROR_LOG == 1){
      
      redirect('/account/gifts/give/?id='.$account['ID'].'&id_gift='.$gift['ID']);
    
    }
    
    if ($gift['SUM'] > user('MONEY')){
      
      error('Недостаточно средств на счету');
      redirect('/account/gifts/give/?id='.$account['ID'].'&id_gift='.$gift['ID']);
    
    }
    
    $ID = db::get_add("INSERT INTO `GIFTS_USER` (`PRIVATE`, `USER_ID`, `MY_ID`, `MESSAGE`, `TIME`, `GIFT_ID`) VALUES (?, ?, ?, ?, ?, ?)", [GIFT_PRIVATE, user('ID'), $account['ID'], GIFT_MESSAGE, TM, $gift['ID']]);
    
    if (db::get_column("SELECT COUNT(*) FROM `NOTIFICATIONS_SETTINGS` WHERE `USER_ID` = ? AND `GIFTS` = ? LIMIT 1", [$account['ID'], 1]) == 1){ 
      
      db::get_add("INSERT INTO `NOTIFICATIONS` (`USER_ID`, `OBJECT_ID`, `OBJECT_ID_LIST`, `TIME`, `TYPE`) VALUES (?, ?, ?, ?, ?)", [$account['ID'], user('ID'), $gift['ID'], TM, 'gift']);
    
    }        
    
    db::get_set("UPDATE `USERS` SET `MONEY` = ? WHERE `ID` = ? LIMIT 1", [(user('MONEY') - $vip), user('ID')]);
    db::get_set("UPDATE `GIFTS` SET `RATING` = `RATING` + ? WHERE `ID` = ? LIMIT 1", [1, $gift['ID']]);
    
    success('Подарок успешно отправлен');
    redirect('/id'.$account['ID']);
    
  }
  
  ?>
  <div class='list'>
  <img class='img' src='/files/upload/gifts/<?=$gift['ID']?>.<?=$gift['EXT']?>' style='max-width: 100px'><br /><br />
  <b><?=lg('Название')?>:</b> <?=tabs($gift['NAME'])?><br />
  <b><?=lg('Цена')?>:</b> <?=money($vip, 1)?> <?=$vip2?><br />
  <b><?=lg('Получатель')?>:</b>
  <?=user::login($account['ID'], 0, 1)?><br /><br />
    
  <form method='post' class='ajax-form' action='/account/gifts/give/?id=<?=$account['ID']?>&id_gift=<?=$gift['ID']?>'>
  <b><?=lg('Введите сообщение для получателя')?></b> (<?=lg('до 300 символов')?>):<br />
  <?=html::textarea(null, 'message', 'Введите сообщение', null, 'form-control-textarea', 6, 0)?>
  <br /><br />
  <?=html::select('private', array(
    0 => ['Все', 0], 
    1 => ['Только я и получатель', 1]
  ), 'Кто увидит ваш логин и сообщение', 'form-control-100-modify-select', 'lock')?>  
  <?=html::button('button ajax-button', 'ok_give_gift', 'gift', 'Отправить подарок')?>
  </form>
  </div>
  <?
  
  back('/account/gifts/give/?id='.$account['ID'].'&id_dir='.$gift['ID_DIR']);
  acms_footer();
  
}

/*
--------------
Поиск подарков
--------------
*/

if (get('get') == 'search') {
  
  ?>
  <div class='menu-nav-content'>
  <a class='menu-nav h' href='/account/gifts/give/?id=<?=$account['ID']?>'>
  <?=lg('Каталог')?>
  </a>
  <a class='menu-nav' href='/account/gifts/give/?id=<?=$account['ID']?>&get=cat'>
  <?=lg('Категории')?>
  </a>  
  <a class='menu-nav' href='/account/gifts/?id=<?=user('ID')?>&user_id=<?=$account['ID']?>'>
  <?=lg('Мои подарки')?> <span class='menu-nav-count'><?=db::get_column("SELECT COUNT(*) FROM `GIFTS_USER` WHERE `MY_ID` = ?", [user('ID')])?></span>
  </a>  
  </div>
    
  <div class='search-main-optimize'>
  <form method='post' class='ajax-form2' action='/account/gifts/give/?id=<?=$account['ID']?>&get=search'>
  <input type='text' name='search' class='search-main' placeholder='<?=lg('Поиск подарка по названию')?>' value='<?=SEARCH?>'> 
  <button class="search-main-button ajax-button-search"><?=icons('search', 20)?></button>
  </form>
  </div>
  <?
  
  $column = db::get_column("SELECT COUNT(*) FROM `GIFTS` WHERE `NAME` LIKE ? AND `ACT` = '1'", ['%'.SEARCH.'%']);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
  if ($column == 0){
  
    html::empty('Нет результатов', 'search');
  
  }else{
    
    ?>
    <div class='list-body'>
    <div class='list-menu'>
    <b><?=lg('Результаты поиска')?>:</b>  
    </div>
    <?
  
  }
  
  $data = db::get_string_all("SELECT * FROM `GIFTS` WHERE `NAME` LIKE ? AND `ACT` = '1' ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, ['%'.SEARCH.'%']);  
  while ($list = $data->fetch()){
    
    $sum = $list['SUM'];
    
    if ($list['ATIME'] > TM) {
      
      $sum = $list['SUM'] / 100;
      $sum = $sum * $list['PERCENT'];
      $sum = $list['SUM'] - $sum;
      
    }
    
    ?>
    <div class='list-menu'>
    <img class='img' src='/files/upload/gifts/<?=$list['ID']?>.<?=$list['EXT']?>' style='max-width: 80px'><br /><br />
    <b><?=lg('Название')?>:</b> <?=tabs($list['NAME'])?><br />
    <b><?=lg('Цена')?>:</b> <?=money($sum, 1)?><br /><br />
    <a href='/account/gifts/give/?id=<?=$account['ID']?>&id_gift=<?=$list['ID']?>' class='btn'><?=icons('gift', 15, 'fa-fw')?> <?=lg('Подарить')?> <?=user::login_mini($account['ID'])?></a>
    </div>
    <?
    
  }
  
  if ($column > 0){
    
    ?></div><?
  
  }
  
  get_page('/account/gifts/give/?id='.$account['ID'].'&get=search&', $spage, $page, 'list');
  
  back('/account/gifts/give/?id='.$account['ID']);
  acms_footer();
  
}

/*
------------------
Категория подарков
------------------
*/

if (get('id_dir')){
  
  $dir = db::get_string("SELECT * FROM `GIFTS_DIR` WHERE `ID` = ? LIMIT 1", [intval(get('id_dir'))]);
  
  if (!isset($dir['ID'])){
    
    error('Неверная директива');
    redirect('/');
  
  }
  
  ?>
  <div class='menu-nav-content'>
  <a class='menu-nav' href='/account/gifts/give/?id=<?=$account['ID']?>'>
  <?=lg('Каталог')?>
  </a>
  <a class='menu-nav h' href='/account/gifts/give/?id=<?=$account['ID']?>&get=cat'>
  <?=lg('Категории')?>
  </a>  
  <a class='menu-nav' href='/account/gifts/?id=<?=user('ID')?>&user_id=<?=$account['ID']?>'>
  <?=lg('Мои подарки')?> <span class='menu-nav-count'><?=db::get_column("SELECT COUNT(*) FROM `GIFTS_USER` WHERE `MY_ID` = ?", [user('ID')])?></span>
  </a>  
  </div>
    
  <div class='search-main-optimize'>
  <form method='post' class='ajax-form2' action='/account/gifts/give/?id=<?=$account['ID']?>&get=search'>
  <input type='text' name='search' class='search-main' placeholder='<?=lg('Поиск подарка по названию')?>' value='<?=SEARCH?>'> 
  <button class="search-main-button ajax-button-search"><?=icons('search', 20)?></button>
  </form>
  </div>
    
  <div class='list'>
  <small style='color: #607883'><?=lg('Подарок будет отправлен')?>:</small>
  <a href='/shopping/' class='info green' style='float: right'><?=lg('Счет')?>: <?=money(user('MONEY'), 2)?></a><br />
  <br />
  <span style='position: relative; top: -4px'><?=user::login($account['ID'], 0, 1)?></span>
  <?php if (config('SHOP_REP') == 1) : ?>
  <a href='/shopping/rep/' style='float: right; font-size: 13px; color: #F9A825'><?=lg('Пополнить счет')?></a>
  <?php endif ?>
  </div>
  <?
  
  $column = db::get_column("SELECT COUNT(*) FROM `GIFTS` WHERE `ID_DIR` = ? AND `ACT` = '1'", [$dir['ID']]);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

  if ($column == 0){
  
    html::empty();
  
  }else{
    
    ?>
    <div class='list-body'>
    <div class='list-menu'>
    <center><b><?=lg('Категория')?> "<?=tabs($dir['NAME'])?>"</b></center>  
    </div>
    <div class='list-menu'>
    <b><?=lg('Выберите подарок')?>:</b>  
    </div>
    <?
  
  }
  
  $data = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ID_DIR` = ? AND `ACT` = '1' ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$dir['ID']]);  
  while ($list = $data->fetch()){
    
    $sum = $list['SUM'];
    
    if ($list['ATIME'] > TM) {
      
      $sum = $list['SUM'] / 100;
      $sum = $sum * $list['PERCENT'];
      $sum = $list['SUM'] - $sum;
      
    }
    
    ?>
    <div class='list-menu'>
    <img class='img' src='/files/upload/gifts/<?=$list['ID']?>.<?=$list['EXT']?>' style='max-width: 80px'><br /><br />
    <b><?=lg('Название')?>:</b> <?=tabs($list['NAME'])?><br />
    <b><?=lg('Цена')?>:</b> <?=money($sum, 1)?><br /><br />
    <a href='/account/gifts/give/?id=<?=$account['ID']?>&id_gift=<?=$list['ID']?>' class='btn'><?=icons('gift', 15, 'fa-fw')?> <?=lg('Подарить')?></a>
    </div>
    <?
    
  }
  
  if ($column > 0){
  
    ?></div><?
  
  }
  
  get_page('/account/gifts/give/?id='.$account['ID'].'&id_dir='.$dir['ID'].'&', $spage, $page, 'list');
  
  back('/account/gifts/give/?id='.$account['ID']);
  acms_footer();
  
}

/*
----------------------------
Категории подарков и каталог
----------------------------
*/

if (get('get') == 'cat') {
  
  ?>
  <div class='menu-nav-content'>
  <a class='menu-nav' href='/account/gifts/give/?id=<?=$account['ID']?>'>
  <?=lg('Каталог')?>
  </a>
  <a class='menu-nav h' href='/account/gifts/give/?id=<?=$account['ID']?>&get=cat'>
  <?=lg('Категории')?>
  </a>  
  <a class='menu-nav' href='/account/gifts/?id=<?=user('ID')?>&user_id=<?=$account['ID']?>'>
  <?=lg('Мои подарки')?> <span class='menu-nav-count'><?=db::get_column("SELECT COUNT(*) FROM `GIFTS_USER` WHERE `MY_ID` = ?", [user('ID')])?></span>
  </a>  
  </div>
    
  <div class='search-main-optimize'>
  <form method='post' class='ajax-form2' action='/account/gifts/give/?id=<?=$account['ID']?>&get=search'>
  <input type='text' name='search' class='search-main' placeholder='<?=lg('Поиск подарка по названию')?>' value='<?=SEARCH?>'> 
  <button class="search-main-button ajax-button-search"><?=icons('search', 20)?></button>
  </form>
  </div>
    
  <div class='list'>
  <small style='color: #607883'><?=lg('Подарок будет отправлен')?>:</small>
  <a href='/shopping/' class='info green' style='float: right'><?=lg('Счет')?>: <?=money(user('MONEY'), 2)?></a><br />
  <br />
  <span style='position: relative; top: -4px'><?=user::login($account['ID'], 0, 1)?></span>
  <?php if (config('SHOP_REP') == 1) : ?>
  <a href='/shopping/rep/' style='float: right; font-size: 13px; color: #F9A825'><?=lg('Пополнить счет')?></a>
  <?php endif ?>
  </div>
  <?
  
  $column = db::get_column("SELECT COUNT(*) FROM `GIFTS_DIR`");
  
  if ($column == 0){
    
    html::empty('Пока нет категорий подарков', 'gift');
  
  }
  
  $data = db::get_string_all("SELECT * FROM `GIFTS_DIR` ORDER BY `ID` DESC");
  while ($list = $data->fetch()){
    
    $count = db::get_column("SELECT COUNT(*) FROM `GIFTS` WHERE `ID_DIR` = ? AND `ACT` = '1'", [$list['ID']]);
    
    $html = null;
    $data2 = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ID_DIR` = ? AND `ACT` = '1' ORDER BY RAND() LIMIT 12", [$list['ID']]);
    while ($list2 = $data2->fetch()){
      
      $html .= "<a style='display: inline-block; position: relative; overflow: hidden; width: 90px; height: 90px' class='img' href='/account/gifts/give/?id=".$account['ID']."&id_gift=".$list2['ID']."'><img src='/files/upload/gifts/".$list2['ID'].".".$list2['EXT']."' style='max-width: 90px'><span class='info blue' style='font-size: 9px; position: absolute; bottom: 0; left: 50%; transform: translateX(-50%)'>".money($list2['SUM'], 2)."</span></a>";
      
    }
    
    ?>
    <div class='list-body'>
    <a href='/account/gifts/give/?id=<?=$account['ID']?>&id_dir=<?=$list['ID']?>'>
    <div class='list-menu' style='background-color: #FFE8C2; margin-top: -1px; text-transform: uppercase; padding: 10px; padding-bottom: 9px'>
    <small><b><?=tabs($list['NAME'])?></b></small> <span class='count' style='background-color: #F9A825'><?=$count?></span>
    <span style='float: right; position: relative; color: #455058; top: 5px'><b><?=lg('Все')?> <?=icons('chevron-right', 16, 'fa-fw')?></b></span>
    </div>
    </a>
    <?php if (str($html) > 0) : ?>
    <div class='list-menu'>
    <div class='files-main-list'>
    <?=$html?>
    </div>
    </div>
    <?php else : ?>
    <div class='list-menu'><?=lg('Категория пуста')?></div>
    <?php endif ?>
    </div>
    <?
    
  }
  
  back('/account/gifts/give/?id='.$account['ID']);  
  acms_footer();
  
}

?>
<div class='menu-nav-content'>
<a class='menu-nav h' href='/account/gifts/give/?id=<?=$account['ID']?>'>
<?=lg('Каталог')?>
</a>
<a class='menu-nav' href='/account/gifts/give/?id=<?=$account['ID']?>&get=cat'>
<?=lg('Категории')?>
</a>  
<a class='menu-nav' href='/account/gifts/?id=<?=user('ID')?>&user_id=<?=$account['ID']?>'>
<?=lg('Мои подарки')?> <span class='menu-nav-count'><?=db::get_column("SELECT COUNT(*) FROM `GIFTS_USER` WHERE `MY_ID` = ?", [user('ID')])?></span>
</a>  
</div>
    
<div class='search-main-optimize'>
<form method='post' class='ajax-form2' action='/account/gifts/give/?id=<?=$account['ID']?>&get=search'>
<input type='text' name='search' class='search-main' placeholder='<?=lg('Поиск подарка по названию')?>' value='<?=SEARCH?>'> 
<button class="search-main-button ajax-button-search"><?=icons('search', 20)?></button>
</form>
</div>
    
<div class='list'>
<small style='color: #607883'><?=lg('Подарок будет отправлен')?>:</small>
<a href='/shopping/' class='info green' style='float: right'><?=lg('Счет')?>: <?=money(user('MONEY'), 2)?></a><br />
<br />
<span style='position: relative; top: -4px'><?=user::login($account['ID'], 0, 1)?></span>
<?php if (config('SHOP_REP') == 1) : ?>
<a href='/shopping/rep/' style='float: right; font-size: 13px; color: #F9A825'><?=lg('Пополнить счет')?></a>
<?php endif ?>
</div>
<?
  
$html = null;
$s = 0;
$data2 = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ATIME` > ? AND `ACT` = '1' ORDER BY RAND()", [TM]);
while ($list2 = $data2->fetch()){
  
  $s++;
  
  $sum = $list2['SUM'] / 100;
  $sum = $sum * $list2['PERCENT'];
  $sum = $list2['SUM'] - $sum;
  
  $html .= "<a style='display: inline-block; position: relative; overflow: hidden; width: 90px; height: 90px' class='img' href='/account/gifts/give/?id=".$account['ID']."&id_gift=".$list2['ID']."'><img src='/files/upload/gifts/".$list2['ID'].".".$list2['EXT']."' style='max-width: 90px'><span class='info red' style='font-size: 9px; position: absolute; top: 0; right: 0; background-color: red'>-".$list2['PERCENT']."%</span><span class='info blue' style='font-size: 9px; position: absolute; bottom: 0; left: 50%; transform: translateX(-50%)'>".money($sum, 2)."</span></a>";

}

?>
<div class='list-body'>
<div class='list-menu' style='background-color: #FFE8C2; margin-top: -1px; text-transform: uppercase; padding: 10px; padding-bottom: 9px'>
<small><b><?=lg('Акции')?></b></small> <span class='count' style='background-color: #F9A825'><?=$s?></span>
</div>
<?php if (str($html) > 0) : ?>
<div class='list-menu'>
<div class='files-main-list'>
<?=$html?>
</div>
</div>
<?php else : ?>
<div class='list-menu'><?=lg('Пока нет акционных подарков')?></div>
<?php endif ?>
</div>
<?
  
$html = null;
$s = 0;
$data2 = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ACT` = '1' ORDER BY `RATING` DESC LIMIT 30");
while ($list2 = $data2->fetch()){
  
  $s++;
  
  $html .= "<a style='display: inline-block; position: relative; overflow: hidden; width: 90px; height: 90px' class='img' href='/account/gifts/give/?id=".$account['ID']."&id_gift=".$list2['ID']."'><img src='/files/upload/gifts/".$list2['ID'].".".$list2['EXT']."' style='max-width: 90px'><span class='info blue' style='font-size: 9px; position: absolute; bottom: 0; left: 50%; transform: translateX(-50%)'>".money($list2['SUM'], 2)."</span></a>";

}

?>
<div class='list-body'>
<div class='list-menu' style='background-color: #FFE8C2; margin-top: -1px; text-transform: uppercase; padding: 10px; padding-bottom: 9px'>
<small><b><?=lg('Популярные')?></b></small> <span class='count' style='background-color: #F9A825'><?=$s?></span>
</div>
<?php if (str($html) > 0) : ?>
<div class='list-menu'>
<div class='files-main-list'>
<?=$html?>
</div>
</div>
<?php else : ?>
<div class='list-menu'><?=lg('Пока нет подарков')?></div>
<?php endif ?>
</div>
<?
  
$html = null;
$s = 0;
$data2 = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ACT` = '1' ORDER BY `ID` DESC LIMIT 30");
while ($list2 = $data2->fetch()){
  
  $s++;
  
  $html .= "<a style='display: inline-block; position: relative; overflow: hidden; width: 90px; height: 90px' class='img' href='/account/gifts/give/?id=".$account['ID']."&id_gift=".$list2['ID']."'><img src='/files/upload/gifts/".$list2['ID'].".".$list2['EXT']."' style='max-width: 90px'><span class='info blue' style='font-size: 9px; position: absolute; bottom: 0; left: 50%; transform: translateX(-50%)'>".money($list2['SUM'], 2)."</span></a>";

}

?>
<div class='list-body'>
<div class='list-menu' style='background-color: #FFE8C2; margin-top: -1px; text-transform: uppercase; padding: 10px; padding-bottom: 9px'>
<small><b><?=lg('Новые')?></b></small> <span class='count' style='background-color: #F9A825'><?=$s?></span>
</div>
<?php if (str($html) > 0) : ?>
<div class='list-menu'>
<div class='files-main-list'>
<?=$html?>
</div>
</div>
<?php else : ?>
<div class='list-menu'><?=lg('Пока нет подарков')?></div>
<?php endif ?>
</div>
<?
  
$html = null;
$s = 0;
$data2 = db::get_string_all("SELECT * FROM `GIFTS` WHERE `ACT` = '1' AND (`NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ? OR `NAME` LIKE ?) ORDER BY `ID` DESC LIMIT 50", ['%новый год%', '%8 марта%', '%23 февраля%', '%9 мая%', '%цвет%', '%шар%', '%торт%', '%шамп%', '%пиво%']);
while ($list2 = $data2->fetch()){
  
  $s++;
  
  $html .= "<a style='display: inline-block; position: relative; overflow: hidden; width: 90px; height: 90px' class='img' href='/account/gifts/give/?id=".$account['ID']."&id_gift=".$list2['ID']."'><img src='/files/upload/gifts/".$list2['ID'].".".$list2['EXT']."' style='max-width: 90px'><span class='info blue' style='font-size: 9px; position: absolute; bottom: 0; left: 50%; transform: translateX(-50%)'>".money($list2['SUM'], 2)."</span></a>";

}

?>
<div class='list-body'>
<div class='list-menu' style='background-color: #FFE8C2; margin-top: -1px; text-transform: uppercase; padding: 10px; padding-bottom: 9px'>
<small><b><?=lg('Праздничные')?></b></small> <span class='count' style='background-color: #F9A825'><?=$s?></span>
</div>
<?php if (str($html) > 0) : ?>
<div class='list-menu'>
<div class='files-main-list'>
<?=$html?>
</div>
</div>
<?php else : ?>
<div class='list-menu'><?=lg('Пока нет подарков')?></div>
<?php endif ?>
</div>
<?

back('/id'.$account['ID']);
acms_footer();