<?php

if (post('ok')){
  
  $sum = abs(post('sum'));
  $block = abs(intval(post('block')));
  
  if ($block < 1) {
    
    error('Количество рекламных блоков не может быть меньше 1');
    redirect('/admin/site/modules/?mod=3ads');
    
  }
  
  if ($block > 10) {
    
    error('Количество рекламных блоков не может быть больше 10');
    redirect('/admin/site/modules/?mod=3ads');
    
  }
  
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'ADS3_SUM', $sum);
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'ADS3_BLOCK', $block);
  
  success('Изменения успешно приняты');
  redirect('/admin/site/modules/?mod=3ads');
  
}

if (get('delete') && db::get_column("SELECT COUNT(*) FROM `ADS3` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]) > 0){
  
  get_check_valid();
  
  $ads = db::get_string("SELECT * FROM `ADS3` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  $message = "Модератор удалил вашу рекламную площадку [url=/m/3ads/]".$ads['NAME']."[/url]."; 
  messages::get(config('SYSTEM'), $ads['USER_ID'], $message, 0);
  
  db::get_set("DELETE FROM `ADS3` WHERE `ID` = ? LIMIT 1", [$ads['ID']]);
  
  success('Площадка успешно удалена');
  redirect('/admin/site/modules/?mod=3ads');
  
}

if (get('ok') && db::get_column("SELECT COUNT(*) FROM `ADS3` WHERE `ACT` = '2' AND `ID` = ? LIMIT 1", [intval(get('ok'))]) > 0){
  
  get_check_valid();
  
  $ads = db::get_string("SELECT * FROM `ADS3` WHERE `ID` = ? LIMIT 1", [intval(get('ok'))]);  
  db::get_set("UPDATE `ADS3` SET `ACT` = '1' WHERE `ID` = ? LIMIT 1", [$ads['ID']]);
  
  $message = "Модератор одобрил вашу рекламную площадку [url=/m/3ads/]".$ads['NAME']."[/url]."; 
  messages::get(config('SYSTEM'), $ads['USER_ID'], $message, 0);
  
  success('Площадка успешно одобрена');
  redirect('/admin/site/modules/?mod=3ads');
  
}

if (get('no') && db::get_column("SELECT COUNT(*) FROM `ADS3` WHERE `ACT` = '2' AND `ID` = ? LIMIT 1", [intval(get('no'))]) > 0){
  
  get_check_valid();
  
  $ads = db::get_string("SELECT * FROM `ADS3` WHERE `ID` = ? LIMIT 1", [intval(get('no'))]);  
  db::get_set("UPDATE `ADS3` SET `ACT` = '3' WHERE `ID` = ? LIMIT 1", [$ads['ID']]);
  
  $message = "Модератор отклонил вашу рекламную площадку [url=/m/3ads/?get=delete]".$ads['NAME']."[/url].";
  messages::get(config('SYSTEM'), $ads['USER_ID'], $message, 0);
  
  success('Площадка успешно отклонена');
  redirect('/admin/site/modules/?mod=3ads');
  
}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/admin/site/modules/?mod=3ads'>
<?=html::input('sum', 0, 'Сколько стоит 1 день рекламы:', null, abs(config('ADS3_SUM')), 'form-control-30', 'number', null, 'money')?>
<?=html::input('block', 0, 'Сколько рекламных блоков показывать рандомно на странице (от 1 до 10):', null, abs(config('ADS3_BLOCK')), 'form-control-30', 'number', null, 'sort-numeric-desc')?>
<?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?><br /><br />
<?php if (get('get') != 'all') : ?>
<a href='/admin/site/modules/?mod=3ads&get=all' class='button3'><?=icons('list', 15, 'fa-fw')?> <?=lg('Все рекламные площадки')?></a>
<?php else : ?>
<a href='/admin/site/modules/?mod=3ads&get=mod' class='button3'><?=icons('list', 15, 'fa-fw')?> <?=lg('Список площадок ждущих одобрения')?></a>
<?php endif ?>
</form>
</div>
<?
  
if (get('get') == 'all') {
  
  $name = 'Все рекламные площадки';
  $sql = null;
  $get = 'all';
  
}else{
  
  $name = 'Список площадок ждущих одобрения';
  $sql = "WHERE `ACT` = '2'";
  $get = 'mod';
  
}

$column = db::get_column("SELECT COUNT(*) FROM `ADS3` ".$sql);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

?>
<div class='list-body'>
<div class='list-menu list-title'><b><?=lg($name)?> <span class='count'><?=$column?></span></b></div>
<?

if ($column == 0){ 
  
  html::empty();

}

$data = db::get_string_all("SELECT * FROM `ADS3` ".$sql." ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()){
  
  ?>
  <div class='list-menu'>
  <a ajax='no' href='<?=tabs($list['LINK'])?>'><font color='<?=$list['COLOR_NAME']?>'><b><?=tabs($list['NAME'])?></b></font></a><br />
  <?=tabs($list['MESSAGE'])?><br />
  <b><?=lg('Создана')?>:</b> <?=ftime($list['TIME'])?><br />
  <b><?=lg('Создал')?>:</b> <?=user::login($list['USER_ID'], 0, 1)?><br /><br />
  <?php if ($list['ACT'] == 2) : ?>
  <a class='button' href='/admin/site/modules/?mod=3ads&ok=<?=$list['ID']?>&<?=TOKEN_URL?>'><?=icons('check', 15, 'fa-fw')?> <?=lg('Одобрить')?></a>
  <a class='button' href='/admin/site/modules/?mod=3ads&no=<?=$list['ID']?>&<?=TOKEN_URL?>'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отклонить')?></a>
  <?php endif ?>
  <a class='button' href='/admin/site/modules/?mod=3ads&delete=<?=$list['ID']?>&<?=TOKEN_URL?>'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
  </div>
  <?
  
}

get_page('/admin/site/modules/?mod=3ads&get='.$get.'&', $spage, $page, 'list-menu');

?></div>