<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<title>Payment Via Stripe</title>
	<link rel='stylesheet prefetch' href='<?php echo base_url('assets/lib/bootstrap/dist/css/bootstrap.min.css') ?>'>
	<link rel="stylesheet" href="<?php echo base_url('assets/css/ciuis.css') ?>">
	<style>
		.amex {
			background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAeCAMAAABdem3zAAAAA3NCSVQICAjb4U/gAAACi1BMVEUAAAAAAAAAdKIAdqcGdqoDeqkDeKoDe6sFeqoFeqwCeqoGe6wGeasGeqwGe6wFeqwFeqwFeqsGe6oFeawEeqwEeqwFe6wHeaoFe6oFeasFe6wFeawHe6wIfKwJfKwKfa0Lfa0Mfq0Of64Pf64QgK8RgK8Sga8TgbAUgrAVgrAWg7EXg7EYhLEZhLIahbIbhbIdhrMfh7QgiLQhiLQjirUkirUli7YnjLYojLcqjbcsj7gtj7kukLkvkLkwkbkxkboykrozkro0k7s1k7s2lLs3lLw4lbw5lbw6lr07lr08l709l75Amb9Bmr9Dm8BFnMBHncFIncFJnsJKnsJLn8JMn8NNoMNOocRPocRQosRRosVUpMZVpMZWpcZXpcdYpsdZp8dap8dbqMheqclgqslhq8pjrMpkrMtnrsxpr8xqr81tsc5vss5wss9xs89ztNB0tdB1ttF6uNJ8udN9utN+utR/u9SAu9SBvNWCvNWDvdWEvdWGvtaHv9aIv9eKwNeMwdiPw9mQw9mRxNqTxdqUxtuVx9uWx9yXyNyYyNyZyd2ayd2byt2cyt6dy96fzN+gzN+hzd+izeCjzuCkzuCn0OGp0eKq0eKr0uOs0+Ot0+Ov1OSw1eSy1uWz1uW01+W32Oa62ui72+i82+i+3Om/3enC3urE3+vF4OvH4ezI4uzJ4u3K4+3L4+3N5O7O5e7P5e/R5u/S5/DT5/DV6PHW6fHX6fHY6vHa6/Lb7PPc7PPd7fPe7fTf7vTg7vTi7/Xj8PXk8fbm8vbn8vfo8/fp8/fq9Pjr9Pjs9fjt9fnu9vnv9vnw9/rx9/ry+Prz+Pv0+fv1+fv2+vz4+/z5+/37/P38/f7+/v7///+B6xdgAAAAHHRSTlMAARYaJ0FIT1pcYG6YmZyssrPDys3T2tvt9PX+1nJQbwAAAnFJREFUOMtjYOAWESMWiAqwMzBwyZAEOBn4SdMgzCBImgYJUjVI0UeDkoGBrq6BgZ6MhgECqAA56nJ6ICZIWN3AQAeuoevIrvOHDuy6ZLl1366ru3ft2nVl167dJ08cOXHo/P6Dl3Yd33Nm15mdJw+thGnQO2ei2nzDRaZp405Zmd2KxhYWW2TMTeUmJOWv0NOPKVJ1uNEi4329LByuoXKaabvZNZcQw8u5IUANrYuX7pA5eNSxJCk/OPfGBe2ZKotbnAw6kTSs8Axslpnh0mtRr74YqME7LGaHjI6G4uakfOfGG21q3c5hLf7TNDMQGhqUMjN9vFz6O2TCjgA11M+Zs13m4oXIvKT8bOs+i7DMNJks/xuhcggNKQ3b+vfGpS65kLTqVNyRpLi4uP1xl6d09jRPPF+blHC29WB+SsX5PXF1cA0lE/1lWiZOnFg2saZrIgxkgojiyr6JZTLxQFZ5ycSJpRTHdOAmMMiM2Agk103esGnTxiWzwELTVwOJyes29aFqiFtrCQR+x05FuVpaWqcfA3I8FlQDyandjpaWh5KtLI3RNCxTA8ZypHewb7vNrvWKk2QW7wiIzU3YteusXtXWrQvllm+diK5BRl6+4JyW2omJ2qkRiqtknN2VF+UCxWbmKCi5b3GU1fRE16B+4cK5RCe3pH6z6bP3nZOZsyYoMzftwsWrp4+skZt/4kA1mqfjVqgAgcORw/Z23kejg86r7JxXm1AIFOqzVdFLAEoahaNqiDgMBplZQGKNjC6QbD0MA3vmAomN5XTLcaQASQZe0jSIM3CQpoGPgZFHmgT1QkwMDAzMrOxEAjYWBgYAvI9h1MHdhQIAAAAASUVORK5CYII=") #fff;
		}
		
		.visa {
			background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAeCAMAAABdem3zAAAAA3NCSVQICAjb4U/gAAABvFBMVEUAAADQ0NDa2tra2trZ2dnY2Nja2trt7e3t7e0mM3onNHspNXkqN30rN30sOH4tN3ovO4AwPIAyPoE1QYM3Q4Q4Q4U4RIU5RYY8R4g9SIhCTYtDToxGUY5HUo5JU49JVJBOWJJQW5RSXJVTXZZVX5dXYZhYYplaY5pfaJ1kbaBlbqFoaZFocaNpcqNqc6RtdqZvd6dzcpV0fKp2f6x5ga18g698hK99hK99hbB+hrCAh7GDi7OHjrWIj7aJkLeNk7mNlLqOlbqRl7yUmr6WnL6YnsCbocKepMSjqMekqceprsqrsMysscytss2uss2xts+xttC0uNG1udK1utK2utK3u9O6vdS7v9W8wNa9wda9wdfBxNnDx9rEx9vFyNzFydvHy93Kzd/Mz+DR0+LS1OPT1uTVnV/V1+XX2ebY2NjZuJbZ2+faoVza3Ojc3+rf4evf4ezi5O7j5e7n6fHp6/Lq6/Lr7PPsmC3snTfs7fPunjnu7/Tu7/Xw8fbx8vfy8/f09fj09fn19vn29/r3z5332LH39/r42LD42bL42bP5+fv76tX77dz7+/v7+/387dv9/f7+9ev//v3///9+dhG/AAAACXRSTlMAGxuq7e7u+vsOT6YMAAABbklEQVQ4y+WUV1cTYRQAlwSIsxoLltgLKgZ7AwV777FiL9gT1x4FGxpb0Gg0On/YBx83D+wz8z7nu+fe800QpNKtpTHSmk4FQUt7pu4YqWfaW4L0BBOQSQdt9SRCvS0omYjSOBZ+fB0d/f5T/VQoDHi6cF4b1/Zt6d9fUZ+cLFyMvfDny6vhN3/1EOwegW4/LAHgpb6bBpNr8ZE2PBz+rQvIvrgJ2+2DdaeOba7pXoBbceHAxHvfHIRNHoHjLobLqlZnkIeDcaHIlAeuh6Jb4bb9EG58rh6G4nTWNNnSHFYNZcnrcsKK1d4Qpl63MY9lrmRmE6GHcCdc0Q7mqt5ZAfM9C7uKvfA0LlyASSzUt7Daz+pIyGw7+c+JuPAxCxzV+7DHrq5tOzqhbxA6crlcSE+TS+dhVk0vwRk7AFhb64a76lIWva7EhKEoKqvvo6jqs6sD526UNYoeq5ajR78a4/k/JM5M4pAlTGUqSBrjf5znrWNE0ZcCAAAAAElFTkSuQmCC") #fff;
		}
		
		.mastercard {
			background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAeCAMAAABdem3zAAAAA3NCSVQICAjb4U/gAAACc1BMVEUAAADQ0NDa2tra2trZ2dnY2Nja2trt7e3t7e3MAADMAQHMBATNCQnOCwvODAzODg7PDwnPERHRGxvSFgfSHh7SHx/SIB7THhDTJCTTJibTJyfUKSnVIAXVLS3VMDDWMjLWNTXWNjbXIQDXLyLXNS7XNzfXOzvYLxbYPT3YPj7Y2NjZOy/ZRUXaSEjaSUnbLQDbLgDbS0vbTU3cSj/cU1PdNADdSjTdVVXdVlbeNwDeW1vfYmLgUDPgZWXgZmbgaGjhXkvhamrhbW3ia2Lib2/jXDfja1njdXXkeHjkeXnke3vlgIDlgYHmg4PmhITmhobnh4fniIjni4voVgDojIzokJDqXADqaiTqlpbqmJjqmZnqmprrnJzrn5/tpqbuqqrura3urq7vsbHvsrLvs7PwbADwbQDwtLTwtbXwt7fxvLzycgDyjULyvr7yv7/zdQDzmVvzn2fzxMTzxcXzx8f2fwD21tb3gQD3x6/3ybL32Nj4hAD43t7439/44OD5iQD54eH54uL65ub65+f76+v7+/v88vL89PT99/f9+Pj9+fn+lwD+/f3/mQD/mgT/nQv/nw//oRT/oRX/oRb/ohj/qCf/qSn/qSr/qy3/rDH/rjX/rjb/sT7/sj//s0L/tEX/tUf/tUj/tkn/t0v/uVD/uVH/u1X/vFj/vVr/vl7/v2H/w2n/xGz/x3P/yHb/yXr/zob/z4j/0Iv/1Zj/1pr/153/2J7/26X/3q7/4LL/4LP/4bX/4bb/5cD/5sL/58P/58T/58X/6sz/7NH/7dL/8d7/8t//9OX/9eb/9ef/9ur/9+v/+vT/+/X//Pj//fz///90HdR0AAAACXRSTlMAGxuq7e7u+vsOT6YMAAABmElEQVQ4y2NgYGJm0SISsDAzMTAwsrG3XiAStLKzMTIwc1wgAbAzM7C2kqKhlZVB6wJJQItSDS3R5orSmo7pPUD2+d2r506bvWzLKdwaOr14OSFAMuXCzqm9ENC//hwODc2KnHDAVdCLALNOYNXQLo9QzylgGoykY+YZbBqckNSrpKamdSPpWINFQw03kgZhJSUlSyQNfUcxNfjzyfFISUDUi5WCQO+EOZOgGmZswNSgY3VBpyPOxJZf1d4uWdxZW9k45+SBtStWTVowffH8o/MxNUgHNsY0entmxrW5R6VnhNb6NlVu6p247uCOs3sOH941DYuG9MTa3JCiGp+S+CzdrrziBOuK5b1L9x8/tG3vko0bsWjQafCKaIhNqon0qyvzqApyKZMtPLZl8/bTR1Zv3Xd6JRYnBeiJChkJGqppWIgoKKi7mTnIVC9YPHnhnHlTJiyaM3EDgWANz87OLicQrCgRx6VvYJBPIOJQk4ZNWD3BpIGS+DhdCSc+0pM3JAOpkpCBaJOnSS5mSC7ISCwqgYUriYUxAINRRW57ksG5AAAAAElFTkSuQmCC") #fff;
		}
				
		.expiry-date-group {
			float: left;
			width: 50%
		}
		
		.expiry-date-group input {
			width: calc(100%+ 1px);
			border-top-right-radius: 0;
			border-bottom-right-radius: 0;
		}
		
		.expiry-date-group input:focus {
			position: relative;
			z-index: 10;
		}
		
		.security-code-group {
			float: right;
			width: 50%
		}
		
		.security-code-group input {
			border-top-left-radius: 0;
			border-bottom-left-radius: 0;
		}
		
		.zip-code-group {
			clear: both;
		}
		
		#PayButton {
			outline: 0!important;
			height: 42px;
			font-size: 16px;
			background-color: #84b211 !important;
			border: none;
		}
		
		#PayButton:hover {
			background-color: #84b211 !important;
		}
		
		#PayButton:active {
			background-color: #84b211 !important;
		}
		
		#PayButton:disabled {
			background: rgba(84, 199, 195, .5)!important;
			color: #FFF!important;
		}
		
		.container {
			margin-top: 50px;
		}
		
		#Checkout {
			z-index: 100001;
			background: ;
			width: 50%;
			min-width: 300px;
			height: 100%;
			min-height: 100%;
			background: 0 0 #ffffff;
			border-radius: 8px;
			border: 1px solid #dedede;
			margin-left: auto;
			margin-right: auto;
			display: block;
		}
		
		#Checkout>h1 {
			margin: 0;
			padding: 20px;
			text-align: center;
			background: #EEF2F4;
			color: #5D6F78;
			font-size: 24px;
			font-weight: 300;
			border-bottom: 1px solid #DEDEDE;
			border-top-left-radius: 8px;
			border-top-right-radius: 8px;
		}
		
		#Checkout>form {
			margin: 0 25px 25px;
		}
		
		label {
			color: #46545C;
			margin-bottom: 2px;
		}
		
		.input-container {
			position: relative;
		}
		
		.input-container input {
			padding-right: 25px;
		}
		
		.input-container>i,
		a[role="button"] {
			color: #d3d3d3;
			width: 25px;
			height: 30px;
			line-height: 30px;
			font-size: 16px;
			position: absolute;
			top: 2px;
			right: 2px;
			cursor: pointer;
			text-align: center;
		}
		
		.input-container>i:hover,
		a[role="button"]:hover {
			color: #777;
		}
		
		.amount-placeholder {
			font-size: 20px;
			height: 34px;
		}
		
		.amount-placeholder>button {
			float: right;
			width: 60px;
		}
		
		.amount-placeholder>span {
			line-height: 34px;
		}
		
		.card-row {
			text-align: center;
			margin: 20px 25px 10px;
		}
		
		.card-row span {
			width: 48px;
			height: 30px;
			margin-right: 3px;
			background-repeat: no-repeat;
			display: inline-block;
			background-size: contain;
		}
		
		.card-image {
			background-repeat: no-repeat;
			padding-right: 50px;
			background-position: right 2px center;
			background-size: auto 90%
		}
		
		.cvc-preview-container {
			overflow: hidden;
		}
		
		.cvc-preview-container.two-card div {
			width: 48%;
			height: 80px;
		}
		
		.cvc-preview-container.two-card div.amex-cvc-preview {
			float: right;
		}
		
		.cvc-preview-container.two-card div.visa-mc-dis-cvc-preview {
			float: left;
		}
		
		.cvc-preview-container div {
			height: 160px;
		}
		
		.amex-cvc-preview {
			background: url("data:image/png;base64,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") center center/contain no-repeat;
		}
		
		.visa-mc-dis-cvc-preview {
			background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOYAAACOCAMAAAASE4S+AAAAAXNSR0IArs4c6QAAAadQTFRFAAAAzbFj+NyAyLNg+N2DzbRk+96CzrVj+96AzrNj+92By7Rl+92AzbRl/eCDzrRl/t+DzrVl/t+CzbVm/t+C3MFt3MFv/N2B/N6CzrRm/uCDzrRm/uCC7M93/N6CAAAAAQEBAgIBBAQCBQUDBwcECQgFDAsGDg0HEA4IEQ8JFRMLFxUMIBwQIR0RJSETKyYWLikYLyoYMCsZMSsZNC4bNzEcOTIdQDkhQTkhQzsiRT0jRj4kSkEmTEMnWE4tWU8uWk8uXFEvXVIwXlMwX1QxaV02bWA4bmE5cWQ6eGo+eWs+fW5Afm9Bi3pHjHtIkH9KmIZOmYdPnIlQnYpRo5BUppJVqJRWqpZXq5dYrJdYrZhZuaNfvaZhvqdiwKljwapjxK1lybFnyrJoy7NozrVm1Ltq171u2L5v2b9s2b9t2sBt3cNy3zEx3zIx38Rz4MVz4cZ04kI552NI6GVJ6Mx36s5368957dF674xb79J78NN78dV78tV789Z99Nd99dh+9rZv9th+9tl+99l/+duA+sx5+sx6+t2B+92B/N6B/d+C/uCD////AikOogAAAB90Uk5TACQkJSU9PT4+Q0NERJqav7/AwNjY4uLi4u7u8/P6+u6knPAAAAJkSURBVHja7d3pTxNBGMfxQbwAW06Pcj0tntQT8b7v+0JFxaserQcuKlQUFbFUaqvjH+1uG0lMfEETie4z39+bJ/tik/1kjt3MbDLGBFkWbeu0CtPZFq03v7KwxSpO04KKcmm7VZ32xeW2VK70nUF7tlj1afJnH+tA6k3UBWbUrHKBudJ0u8DsNtaJwIQJEyZMmDBhwoQJEyZMmPPCFCcCEyZMmDBhwoQJEyZMmDBhwoQJEyZMmDBhwoQJ010m+5swYcKECRMmTJgwYcKECRMmTJgwYcIMFfPHP8/vz5PLjnpzzmg2F07mxIhXVUYmwsjMVan0nbkQMrOeN1aY+zAsjHleNoRMf1x+rWa6KfjjM4RMvxdWN63+4QaYMGHC/EvM6b0HgpI6tvtoyq9vz+4/clcf89sJ2eiXIZGEyJD9sEl6RAa1MVPbpczsk8vT52SHHZCDUxelXxtzW/x4wPx+6cxn+0A2208PX9pB2aONef7xk3JrBjkth4Jysnf9fX1T0Czzmqx+6pcvcel/pJd5RRLXg1p6d0vWvdHKHJCeG2XljLVb5aZS5r2E3A6uTiUu2Km1klLK3CXxZDK5xd6RNYd3St+MTuaryr94G6y92iuy77X+b9rSi/d8usOEyZIXC5gsR7O5MN9bRexvwoQJEyZMmDBhwoQJEyZMmDBhwoT5vzNLLihLJu8CM2+6XGB2meUuMFeYyEf9ysmIqcsUtSuLmQZjGp8pdxafNxtjamIZ1f12MhOrDQ6uXhRLD4/nVb4/S/nx4XRsSeUY8prGtOI0186eKl8Xae3QSOxojTSUgT8BEvkXyqDHONgAAAAASUVORK5CYII=") center center/contain no-repeat;
		}
		
		.submit-button-lock {
			height: 20px;
			margin-top: -2px;
			margin-right: 7px;
			vertical-align: middle;
			background: url("data:image/png;base64,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") center center/contain no-repeat;
			width: 14px;
			display: inline-block;
		}
		
		.align-middle {
			vertical-align: middle;
		}
		
		input {
			box-shadow: none!important;
		}
		
		input:focus {
			border-color: #b0e5e3!important;
			background-color: #EEF9F9!important;
		}
		li {
			list-style: none;
		}
		.form-group {
		    width: 95%;
		    margin-left: auto;
		    margin-right: auto;
		}
	</style>
</head>
<body>
    <div id="authorize_gateway">
    	<div class="container">
    		<div id="Checkout" class="inline">
				<h1>Pay Invoice via Stripe</h1>
				<div class="card-row"> <span class="visa"></span> <span class="mastercard"></span> <span class="amex"></span> <span class="discover"></span> </div>
				
				<div class="form-group">
					<label for="PaymentAmount">Payment amount</label>
					<div class="amount-placeholder"> <span><?php echo $currency?></span>
						<span>
							<?php echo $invoice['total']?>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label or="NameOnCard">Description</label>
					<input readonly="" required="" id="productinfo" name="productinfo" class="form-control" type="text" maxlength="500" value="Invoice <?php echo $invoice['inv_id'] ?> Payment">
				</div>
			    <div class="modal-body" style="text-align: center;">
			        <?php
			        //if (!empty($_POST)) {
			            $form = '<form name="redirect" action="' . site_url('gateway/stripe_success') . '" method="POST">'; ?>
			            <?php $form .= '<script
			            src="https://checkout.stripe.com/checkout.js" class="stripe-button"
			            data-key="' . $payment['input_value2'] . '" 
			            data-amount="' . ($invoice['total']*100) . '"
			            data-image="'.$logo.'" 
			            data-name="'.$crm_name.'" 
			            data-billing-address="true"
			            data-description="Invoice ' . $invoice['inv_id'] . ' payment via Stripe " ;
			            data-locale="auto"
			            data-currency="' . $currency . '">
			        </script>
			        ' . form_hidden('invoice_id', $invoice['id']) . '
			        ' . form_hidden('amount', $invoice['total']) . '
			        ' . form_hidden('currency', $currency) . '
			        </form>';
			            echo $form;
			        //} else {
			        ?> 
			    </div>
			    <form action="<?= base_url($this->uri->uri_string()) ?>" method="post">
			    <div id="payment-errors"></div>
			    <input type="hidden" name="invoice_id" value="<?= $invoice['id'] ?>">
			    <input type="hidden" name="currency" value="<?= $currency ?>">
			    <input name="amount" id="amount" value="<?= $invoice['total'] ?>" type="hidden">
			    <!-- <button id="PayButton" class="btn btn-block btn-success submit-button" type="submit"> 
			    	<span class="submit-button-lock"></span> 
			    	<span class="align-middle">Pay <?php echo $currency?> <?php echo $invoice['total']?></span> 
			    </button> -->
			</form>
			<ul class="card-types">
				<li class="right"><span> Payments powered by 
					<img style="height: 20px;" src="<?php echo base_url('assets/img/payment-modes/stripe.png')?>" alt=""></span>
				</li>
			</ul>
		</div>
	</div>
</div>
    <?php //} ?>
    <script src='<?php echo base_url('assets/lib/jquery/jquery.min.js') ?>'></script>
	<script src='<?php echo base_url('assets/lib/bootstrap/dist/js/bootstrap.min.js') ?>'></script>
</body>
</html>