<?php  
$news = db::get_string("SELECT * FROM `RNEWS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
acms_header(lg('Редактировать - %s', tabs($news['NAME'])), 'management');
is_active_module('PRIVATE_RNEWS');
get_check_valid();

if (!isset($news['ID'])) {
  
  error('Неверная директива');
  redirect('/m/rnews/');

}

if (post('ok_edit')){
  
  valid::create(array(
    
    'NEWS_NAME' => ['name', 'text', [2, 200], 'Заголовок', 0],
    'NEWS_MESSAGE' => ['message', 'text', [2, 10000], 'Описание', 0],
    'NEWS_CATEGORY' => ['category', 'text', [0, 100], 'Категория', 0],
    'NEWS_LINK' => ['link', 'text', [0, 200], 'Ссылка на новость', 0],
    'NEWS_TYPE' => ['type', 'text', [0, 200], 'Ссылка на источник', 0],
    'NEWS_TYPE_RU' => ['type_ru', 'text', [0, 200], 'Название источника', 0]
  
  ));
  
  if ($news['NAME'] != NEWS_NAME && db::get_column("SELECT COUNT(*) FROM `RNEWS` WHERE `NAME` = ? LIMIT 1", [user('ID'), 0, NEWS_NAME]) > 0){
    
    error('Такая новость уже существует');
    redirect('/m/rnews/edit/?id='.$news['ID'].'&'.TOKEN_URL);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/rnews/edit/?id='.$news['ID'].'&'.TOKEN_URL);
  
  }
  
  db::get_set("UPDATE `RNEWS` SET `CATEGORY` = ?, `NAME` = ?, `OPIS` = ?, `LINK` = ?, `TYPE` = ?, `TYPE_RU` = ? WHERE `ID` = ? LIMIT 1", [NEWS_CATEGORY, NEWS_NAME, NEWS_MESSAGE, NEWS_LINK, NEWS_TYPE, NEWS_TYPE_RU, $news['ID']]);
  
  success('Изменения успешно приняты');
  redirect('/m/rnews/show/?id='.$news['ID']);
  
}

define('ACTION', '/m/rnews/edit/?id='.$news['ID'].'&'.TOKEN_URL);
define('TYPE', 'rnews');
define('ID', $news['ID']);

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/rnews/edit/?id=<?=$news['ID']?>&<?=TOKEN_URL?>'>
<?=html::input('name', 'Заголовок', null, null, tabs($news['NAME']), 'form-control-100', 'text', null, 'text-width')?>
<?=html::textarea(tabs($news['OPIS']), 'message', 'Введите описание', null, 'form-control-textarea', 9)?><br /><br />
<?=html::input('link', 'Ссылка на статью (пожеланию)', null, null, tabs($news['LINK']), 'form-control-100', 'text', null, 'link')?>
<?=html::input('type', 'Ссылка на источник (пожеланию)', null, null, tabs($news['TYPE']), 'form-control-100', 'text', null, 'link')?>
<?=html::input('type_ru', 'Название источника (пожеланию)', null, null, tabs($news['TYPE_RU']), 'form-control-100', 'text', null, 'link')?>
<?=html::button('button ajax-button', 'ok_edit', 'save', 'Сохранить')?>
<a class='button-o' href='/m/rnews/show/?id=<?=$news['ID']?>'><?=lg('Отмена')?></a>
</form>
</div>
<?

back('/m/rnews/show/?id='.$news['ID']);
acms_footer();