<?php

function news_rss_parser($url, $type, $type_ru, $num) {

  $rss = @simplexml_load_file($url);
  
  if (isset($rss) && str($rss) > 0) {
    
    $i = 0;
    foreach ($rss->channel->item as $item) {
    
      $title = null;
      if (isset($item->title)) { $title = esc(strip_tags($item->title)); }
    
      $description = null;
      if (isset($item->description)) { $description = esc(str_replace(array('Читать далее', 'Читать далее.', 'читать далее', 'читать далее.', 'Читать полностью', 'Читать полностью.', 'читать полностью', 'читать полностью.'), "", strip_tags($item->description))); }
      
      $category = null;
      if (isset($item->category)) { $category = esc(strip_tags($item->category)); }
    
      $link = null;
      if (isset($item->link)) { $link = esc(strip_tags($item->link)); }
    
      $prew = null;
      if (isset($item->description)) { 
      
        preg_match_all('/<img(?:\\s[^<>]*?)?\\bsrc\\s*=\\s*(?|"([^"]*)"|\'([^\']*)\'|([^<>\'"\\s]*))[^<>]*>/i', $item->description, $pr);
      
        if (isset($pr[1][0])) {
        
          $prew = esc($pr[1][0]);
        
        }
      
      }
      
      if (str($prew) == 0) {
        
        if (isset($item->enclosure)) {
          
          foreach ($item->enclosure->attributes() as $img_name => $img_value) {
            
            if ($img_name == 'url') {
              
              $prew = esc($img_value);
            
            }
            
          }
        
        }
        
      }
      
      if (str($title) > 0 && str($link) > 0 && db::get_column("SELECT COUNT(*) FROM `RNEWS` WHERE `LINK` = ? LIMIT 1", [$link]) == 0) {
        
        db::get_add("INSERT INTO `RNEWS` (`NAME`, `OPIS`, `CATEGORY`, `TIME`, `TYPE`, `TYPE_RU`, `LINK`, `POSTER`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", [$title, $description, $category, (TM - rand(1,100)), $type, $type_ru, $link, $prew]);
        
      }
    
      if (++$i == $num) break;
  
    }
    
  }
  
}