<?php
$news = db::get_string("SELECT * FROM `RNEWS` WHERE `ID` = ? AND `DELETE` = '0' LIMIT 1", [intval(get('id'))]);
acms_header(lg('Новости мира - %s', tabs($news['NAME'])));
is_active_module('PRIVATE_RNEWS');

if (!isset($news['ID'])) {
  
  error('Неверная директива');
  redirect('/m/rnews/');

}

/*
---------
Просмотры
---------
*/

if (user('ID') > 0){
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $news['ID'], 'rnews']) == 0){
    
    db::get_add("INSERT INTO `EYE` (`USER_ID`, `TIME`, `OBJECT_ID`, `TYPE`) VALUES (?, ?, ?, ?)", [user('ID'), TM, $news['ID'], 'rnews']);
    db::get_set("UPDATE `RNEWS` SET `RATING` = `RATING` + '1' WHERE `ID` = ? LIMIT 1", [$news['ID']]);
  
  }else{
    
    db::get_set("UPDATE `EYE` SET `TIME` = ? WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [TM, $news['ID'], 'rnews']);
    
  }

}

if (user('ID') > 0 && MANAGEMENT == 1){
  
  require (ROOT.'/modules/rnews/plugins/delete.php');
  
  ?>
  <div class='list'>
  <a href='/m/rnews/edit/?id=<?=$news['ID']?>&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>        
  <a href='/m/rnews/show/?id=<?=$news['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
  </div>
  <?
  
}

?>
<div class='list-body'> 
<div class='list-menu'>
<img src="https://www.google.com/s2/favicons?domain=<?=tabs($news['TYPE'])?>" style="position: relative; top: 3px; right: 1px"> <b style='position: relative; left: 2px'><?=lg(tabs($news['NAME']))?></b><br />
<span class='time'><?=lg('Добавлен на сайт:')?> <?=mb_strtolower(ftime($news['TIME']), 'UTF-8')?></span><br />
<?php if (db::get_column("SELECT COUNT(*) FROM `ATTACHMENTS` WHERE `TYPE_POST` = ? AND `ID_POST` = ? LIMIT 1", ['rnews', $news['ID']]) > 0) : ?>
<?=attachments_files($news['ID'], 'rnews', 320)?>  
<?php elseif (str($news['POSTER']) > 0) : ?>
<br /><img src="<?=tabs($news['POSTER'])?>" style="max-width: 100%"><br />
<?php endif ?>
<br />
<?=lg((str($news['OPIS']) > 0 ? text($news['OPIS']) : 'Без описания'))?>
<?php if (str($news['LINK']) > 0) : ?>
<br /><br />
<a href='<?=tabs($news['LINK'])?>' ajax='no' class='btn' target='_blank'><?=(str($news['OPIS']) > 0 ? lg('Читать далее') : lg('Описание в источнике'))?> <?=icons('arrow-right', 15, 'fa-fw')?></a>
<?php endif ?>
<?php if (str($news['TYPE']) > 0) : ?>
<br /><br />
<?=lg('Источник')?>: <a href='<?=tabs($news['TYPE'])?>' ajax='no' target='_blank'><?=(str($news['TYPE_RU']) == 0 ? tabs($news['TYPE']) : tabs(lg($news['TYPE_RU'])))?></a>
<?php endif ?>
<?php if (str($news['CATEGORY']) > 0) : ?>
<br /><br />
<span class='info blue'><?=tabs(lg($news['CATEGORY']))?></span>
<?php endif ?>
<?php
likes_ajax($news['ID'], 'rnews', 0, 1);
dislikes_ajax($news['ID'], 'rnews');
$action = '/m/rnews/show/?id='.$news['ID'];
?>

<div id='like'>
<?=likes_list($news['ID'], 'rnews', $action)?>
<div class='menu-sw-cont'> 
<a class='menu-sw-cont-left-33' href="/m/eye/?id=<?=$news['ID']?>&url=<?=base64_encode($action)?>&type=rnews&<?=TOKEN_URL?>"><?=icons('eye', 18, 'fa-fw')?> <?=db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [$news['ID'], 'rnews'])?></a><?=mlikes($news['ID'], $action, 'rnews', 'menu-sw-cont-left-33')?><?=mdislikes($news['ID'], $action, 'rnews', 'menu-sw-cont-left-33')?>
</div>
</div>
  
</div>
</div>
  
<div class='list'>
<b><?=lg('Комментарии')?></b> <span class='count'><?=db::get_column("SELECT COUNT(`ID`) FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? LIMIT 1", [$news['ID'], 'rnews_comments'])?></span>
</div>
  
<?  
if (user('ID') == 0){
  
  $comments_set = 'Извините, для вас комментирование недоступно';
  
}

comments($action, 'rnews_comments', 1, 'message', 0, $news['ID']);

back('/m/rnews/', 'Назад к новостям');
acms_footer();