;(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory():typeof define==='function'&&define.amd?define(factory):global.moment=factory()}(this,(function(){'use strict';var hookCallback;function hooks(){return hookCallback.apply(null,arguments);}
function setHookCallback(callback){hookCallback=callback;}
function isArray(input){return input instanceof Array||Object.prototype.toString.call(input)==='[object Array]';}
function isObject(input){return input!=null&&Object.prototype.toString.call(input)==='[object Object]';}
function isObjectEmpty(obj){if(Object.getOwnPropertyNames){return(Object.getOwnPropertyNames(obj).length===0);}else{var k;for(k in obj){if(obj.hasOwnProperty(k)){return false;}}
return true;}}
function isUndefined(input){return input===void 0;}
function isNumber(input){return typeof input==='number'||Object.prototype.toString.call(input)==='[object Number]';}
function isDate(input){return input instanceof Date||Object.prototype.toString.call(input)==='[object Date]';}
function map(arr,fn){var res=[],i;for(i=0;i<arr.length;++i){res.push(fn(arr[i],i));}
return res;}
function hasOwnProp(a,b){return Object.prototype.hasOwnProperty.call(a,b);}
function extend(a,b){for(var i in b){if(hasOwnProp(b,i)){a[i]=b[i];}}
if(hasOwnProp(b,'toString')){a.toString=b.toString;}
if(hasOwnProp(b,'valueOf')){a.valueOf=b.valueOf;}
return a;}
function createUTC(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,true).utc();}
function defaultParsingFlags(){return{empty:false,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:false,invalidMonth:null,invalidFormat:false,userInvalidated:false,iso:false,parsedDateParts:[],meridiem:null,rfc2822:false,weekdayMismatch:false};}
function getParsingFlags(m){if(m._pf==null){m._pf=defaultParsingFlags();}
return m._pf;}
var some;if(Array.prototype.some){some=Array.prototype.some;}else{some=function(fun){var t=Object(this);var len=t.length>>>0;for(var i=0;i<len;i++){if(i in t&&fun.call(this,t[i],i,t)){return true;}}
return false;};}
function isValid(m){if(m._isValid==null){var flags=getParsingFlags(m);var parsedParts=some.call(flags.parsedDateParts,function(i){return i!=null;});var isNowValid=!isNaN(m._d.getTime())&&flags.overflow<0&&!flags.empty&&!flags.invalidMonth&&!flags.invalidWeekday&&!flags.weekdayMismatch&&!flags.nullInput&&!flags.invalidFormat&&!flags.userInvalidated&&(!flags.meridiem||(flags.meridiem&&parsedParts));if(m._strict){isNowValid=isNowValid&&flags.charsLeftOver===0&&flags.unusedTokens.length===0&&flags.bigHour===undefined;}
if(Object.isFrozen==null||!Object.isFrozen(m)){m._isValid=isNowValid;}
else{return isNowValid;}}
return m._isValid;}
function createInvalid(flags){var m=createUTC(NaN);if(flags!=null){extend(getParsingFlags(m),flags);}
else{getParsingFlags(m).userInvalidated=true;}
return m;}
var momentProperties=hooks.momentProperties=[];function copyConfig(to,from){var i,prop,val;if(!isUndefined(from._isAMomentObject)){to._isAMomentObject=from._isAMomentObject;}
if(!isUndefined(from._i)){to._i=from._i;}
if(!isUndefined(from._f)){to._f=from._f;}
if(!isUndefined(from._l)){to._l=from._l;}
if(!isUndefined(from._strict)){to._strict=from._strict;}
if(!isUndefined(from._tzm)){to._tzm=from._tzm;}
if(!isUndefined(from._isUTC)){to._isUTC=from._isUTC;}
if(!isUndefined(from._offset)){to._offset=from._offset;}
if(!isUndefined(from._pf)){to._pf=getParsingFlags(from);}
if(!isUndefined(from._locale)){to._locale=from._locale;}
if(momentProperties.length>0){for(i=0;i<momentProperties.length;i++){prop=momentProperties[i];val=from[prop];if(!isUndefined(val)){to[prop]=val;}}}
return to;}
var updateInProgress=false;function Moment(config){copyConfig(this,config);this._d=new Date(config._d!=null?config._d.getTime():NaN);if(!this.isValid()){this._d=new Date(NaN);}
if(updateInProgress===false){updateInProgress=true;hooks.updateOffset(this);updateInProgress=false;}}
function isMoment(obj){return obj instanceof Moment||(obj!=null&&obj._isAMomentObject!=null);}
function absFloor(number){if(number<0){return Math.ceil(number)||0;}else{return Math.floor(number);}}
function toInt(argumentForCoercion){var coercedNumber=+argumentForCoercion,value=0;if(coercedNumber!==0&&isFinite(coercedNumber)){value=absFloor(coercedNumber);}
return value;}
function compareArrays(array1,array2,dontConvert){var len=Math.min(array1.length,array2.length),lengthDiff=Math.abs(array1.length-array2.length),diffs=0,i;for(i=0;i<len;i++){if((dontConvert&&array1[i]!==array2[i])||(!dontConvert&&toInt(array1[i])!==toInt(array2[i]))){diffs++;}}
return diffs+lengthDiff;}
function warn(msg){if(hooks.suppressDeprecationWarnings===false&&(typeof console!=='undefined')&&console.warn){console.warn('Deprecation warning: '+msg);}}
function deprecate(msg,fn){var firstTime=true;return extend(function(){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(null,msg);}
if(firstTime){var args=[];var arg;for(var i=0;i<arguments.length;i++){arg='';if(typeof arguments[i]==='object'){arg+='\n['+i+'] ';for(var key in arguments[0]){arg+=key+': '+arguments[0][key]+', ';}
arg=arg.slice(0,-2);}else{arg=arguments[i];}
args.push(arg);}
warn(msg+'\nArguments: '+Array.prototype.slice.call(args).join('')+'\n'+(new Error()).stack);firstTime=false;}
return fn.apply(this,arguments);},fn);}
var deprecations={};function deprecateSimple(name,msg){if(hooks.deprecationHandler!=null){hooks.deprecationHandler(name,msg);}
if(!deprecations[name]){warn(msg);deprecations[name]=true;}}
hooks.suppressDeprecationWarnings=false;hooks.deprecationHandler=null;function isFunction(input){return input instanceof Function||Object.prototype.toString.call(input)==='[object Function]';}
function set(config){var prop,i;for(i in config){prop=config[i];if(isFunction(prop)){this[i]=prop;}else{this['_'+i]=prop;}}
this._config=config;this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+
'|'+(/\d{1,2}/).source);}
function mergeConfigs(parentConfig,childConfig){var res=extend({},parentConfig),prop;for(prop in childConfig){if(hasOwnProp(childConfig,prop)){if(isObject(parentConfig[prop])&&isObject(childConfig[prop])){res[prop]={};extend(res[prop],parentConfig[prop]);extend(res[prop],childConfig[prop]);}else if(childConfig[prop]!=null){res[prop]=childConfig[prop];}else{delete res[prop];}}}
for(prop in parentConfig){if(hasOwnProp(parentConfig,prop)&&!hasOwnProp(childConfig,prop)&&isObject(parentConfig[prop])){res[prop]=extend({},res[prop]);}}
return res;}
function Locale(config){if(config!=null){this.set(config);}}
var keys;if(Object.keys){keys=Object.keys;}else{keys=function(obj){var i,res=[];for(i in obj){if(hasOwnProp(obj,i)){res.push(i);}}
return res;};}
var defaultCalendar={sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'};function calendar(key,mom,now){var output=this._calendar[key]||this._calendar['sameElse'];return isFunction(output)?output.call(mom,now):output;}
var defaultLongDateFormat={LTS:'h:mm:ss A',LT:'h:mm A',L:'MM/DD/YYYY',LL:'MMMM D, YYYY',LLL:'MMMM D, YYYY h:mm A',LLLL:'dddd, MMMM D, YYYY h:mm A'};function longDateFormat(key){var format=this._longDateFormat[key],formatUpper=this._longDateFormat[key.toUpperCase()];if(format||!formatUpper){return format;}
this._longDateFormat[key]=formatUpper.replace(/MMMM|MM|DD|dddd/g,function(val){return val.slice(1);});return this._longDateFormat[key];}
var defaultInvalidDate='Invalid date';function invalidDate(){return this._invalidDate;}
var defaultOrdinal='%d';var defaultDayOfMonthOrdinalParse=/\d{1,2}/;function ordinal(number){return this._ordinal.replace('%d',number);}
var defaultRelativeTime={future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'};function relativeTime(number,withoutSuffix,string,isFuture){var output=this._relativeTime[string];return(isFunction(output))?output(number,withoutSuffix,string,isFuture):output.replace(/%d/i,number);}
function pastFuture(diff,output){var format=this._relativeTime[diff>0?'future':'past'];return isFunction(format)?format(output):format.replace(/%s/i,output);}
var aliases={};function addUnitAlias(unit,shorthand){var lowerCase=unit.toLowerCase();aliases[lowerCase]=aliases[lowerCase+'s']=aliases[shorthand]=unit;}
function normalizeUnits(units){return typeof units==='string'?aliases[units]||aliases[units.toLowerCase()]:undefined;}
function normalizeObjectUnits(inputObject){var normalizedInput={},normalizedProp,prop;for(prop in inputObject){if(hasOwnProp(inputObject,prop)){normalizedProp=normalizeUnits(prop);if(normalizedProp){normalizedInput[normalizedProp]=inputObject[prop];}}}
return normalizedInput;}
var priorities={};function addUnitPriority(unit,priority){priorities[unit]=priority;}
function getPrioritizedUnits(unitsObj){var units=[];for(var u in unitsObj){units.push({unit:u,priority:priorities[u]});}
units.sort(function(a,b){return a.priority-b.priority;});return units;}
function zeroFill(number,targetLength,forceSign){var absNumber=''+Math.abs(number),zerosToFill=targetLength-absNumber.length,sign=number>=0;return(sign?(forceSign?'+':''):'-')+
Math.pow(10,Math.max(0,zerosToFill)).toString().substr(1)+absNumber;}
var formattingTokens=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;var localFormattingTokens=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;var formatFunctions={};var formatTokenFunctions={};function addFormatToken(token,padded,ordinal,callback){var func=callback;if(typeof callback==='string'){func=function(){return this[callback]();};}
if(token){formatTokenFunctions[token]=func;}
if(padded){formatTokenFunctions[padded[0]]=function(){return zeroFill(func.apply(this,arguments),padded[1],padded[2]);};}
if(ordinal){formatTokenFunctions[ordinal]=function(){return this.localeData().ordinal(func.apply(this,arguments),token);};}}
function removeFormattingTokens(input){if(input.match(/\[[\s\S]/)){return input.replace(/^\[|\]$/g,'');}
return input.replace(/\\/g,'');}
function makeFormatFunction(format){var array=format.match(formattingTokens),i,length;for(i=0,length=array.length;i<length;i++){if(formatTokenFunctions[array[i]]){array[i]=formatTokenFunctions[array[i]];}else{array[i]=removeFormattingTokens(array[i]);}}
return function(mom){var output='',i;for(i=0;i<length;i++){output+=isFunction(array[i])?array[i].call(mom,format):array[i];}
return output;};}
function formatMoment(m,format){if(!m.isValid()){return m.localeData().invalidDate();}
format=expandFormat(format,m.localeData());formatFunctions[format]=formatFunctions[format]||makeFormatFunction(format);return formatFunctions[format](m);}
function expandFormat(format,locale){var i=5;function replaceLongDateFormatTokens(input){return locale.longDateFormat(input)||input;}
localFormattingTokens.lastIndex=0;while(i>=0&&localFormattingTokens.test(format)){format=format.replace(localFormattingTokens,replaceLongDateFormatTokens);localFormattingTokens.lastIndex=0;i-=1;}
return format;}
var match1=/\d/;var match2=/\d\d/;var match3=/\d{3}/;var match4=/\d{4}/;var match6=/[+-]?\d{6}/;var match1to2=/\d\d?/;var match3to4=/\d\d\d\d?/;var match5to6=/\d\d\d\d\d\d?/;var match1to3=/\d{1,3}/;var match1to4=/\d{1,4}/;var match1to6=/[+-]?\d{1,6}/;var matchUnsigned=/\d+/;var matchSigned=/[+-]?\d+/;var matchOffset=/Z|[+-]\d\d:?\d\d/gi;var matchShortOffset=/Z|[+-]\d\d(?::?\d\d)?/gi;var matchTimestamp=/[+-]?\d+(\.\d{1,3})?/;var matchWord=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;var regexes={};function addRegexToken(token,regex,strictRegex){regexes[token]=isFunction(regex)?regex:function(isStrict,localeData){return(isStrict&&strictRegex)?strictRegex:regex;};}
function getParseRegexForToken(token,config){if(!hasOwnProp(regexes,token)){return new RegExp(unescapeFormat(token));}
return regexes[token](config._strict,config._locale);}
function unescapeFormat(s){return regexEscape(s.replace('\\','').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(matched,p1,p2,p3,p4){return p1||p2||p3||p4;}));}
function regexEscape(s){return s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');}
var tokens={};function addParseToken(token,callback){var i,func=callback;if(typeof token==='string'){token=[token];}
if(isNumber(callback)){func=function(input,array){array[callback]=toInt(input);};}
for(i=0;i<token.length;i++){tokens[token[i]]=func;}}
function addWeekParseToken(token,callback){addParseToken(token,function(input,array,config,token){config._w=config._w||{};callback(input,config._w,config,token);});}
function addTimeToArrayFromToken(token,input,config){if(input!=null&&hasOwnProp(tokens,token)){tokens[token](input,config._a,config,token);}}
var YEAR=0;var MONTH=1;var DATE=2;var HOUR=3;var MINUTE=4;var SECOND=5;var MILLISECOND=6;var WEEK=7;var WEEKDAY=8;addFormatToken('Y',0,0,function(){var y=this.year();return y<=9999?''+y:'+'+y;});addFormatToken(0,['YY',2],0,function(){return this.year()%100;});addFormatToken(0,['YYYY',4],0,'year');addFormatToken(0,['YYYYY',5],0,'year');addFormatToken(0,['YYYYYY',6,true],0,'year');addUnitAlias('year','y');addUnitPriority('year',1);addRegexToken('Y',matchSigned);addRegexToken('YY',match1to2,match2);addRegexToken('YYYY',match1to4,match4);addRegexToken('YYYYY',match1to6,match6);addRegexToken('YYYYYY',match1to6,match6);addParseToken(['YYYYY','YYYYYY'],YEAR);addParseToken('YYYY',function(input,array){array[YEAR]=input.length===2?hooks.parseTwoDigitYear(input):toInt(input);});addParseToken('YY',function(input,array){array[YEAR]=hooks.parseTwoDigitYear(input);});addParseToken('Y',function(input,array){array[YEAR]=parseInt(input,10);});function daysInYear(year){return isLeapYear(year)?366:365;}
function isLeapYear(year){return(year%4===0&&year%100!==0)||year%400===0;}
hooks.parseTwoDigitYear=function(input){return toInt(input)+(toInt(input)>68?1900:2000);};var getSetYear=makeGetSet('FullYear',true);function getIsLeapYear(){return isLeapYear(this.year());}
function makeGetSet(unit,keepTime){return function(value){if(value!=null){set$1(this,unit,value);hooks.updateOffset(this,keepTime);return this;}else{return get(this,unit);}};}
function get(mom,unit){return mom.isValid()?mom._d['get'+(mom._isUTC?'UTC':'')+unit]():NaN;}
function set$1(mom,unit,value){if(mom.isValid()&&!isNaN(value)){if(unit==='FullYear'&&isLeapYear(mom.year())&&mom.month()===1&&mom.date()===29){mom._d['set'+(mom._isUTC?'UTC':'')+unit](value,mom.month(),daysInMonth(value,mom.month()));}
else{mom._d['set'+(mom._isUTC?'UTC':'')+unit](value);}}}
function stringGet(units){units=normalizeUnits(units);if(isFunction(this[units])){return this[units]();}
return this;}
function stringSet(units,value){if(typeof units==='object'){units=normalizeObjectUnits(units);var prioritized=getPrioritizedUnits(units);for(var i=0;i<prioritized.length;i++){this[prioritized[i].unit](units[prioritized[i].unit]);}}else{units=normalizeUnits(units);if(isFunction(this[units])){return this[units](value);}}
return this;}
function mod(n,x){return((n%x)+x)%x;}
var indexOf;if(Array.prototype.indexOf){indexOf=Array.prototype.indexOf;}else{indexOf=function(o){var i;for(i=0;i<this.length;++i){if(this[i]===o){return i;}}
return-1;};}
function daysInMonth(year,month){if(isNaN(year)||isNaN(month)){return NaN;}
var modMonth=mod(month,12);year+=(month-modMonth)/12;return modMonth===1?(isLeapYear(year)?29:28):(31-modMonth%7%2);}
addFormatToken('M',['MM',2],'Mo',function(){return this.month()+1;});addFormatToken('MMM',0,0,function(format){return this.localeData().monthsShort(this,format);});addFormatToken('MMMM',0,0,function(format){return this.localeData().months(this,format);});addUnitAlias('month','M');addUnitPriority('month',8);addRegexToken('M',match1to2);addRegexToken('MM',match1to2,match2);addRegexToken('MMM',function(isStrict,locale){return locale.monthsShortRegex(isStrict);});addRegexToken('MMMM',function(isStrict,locale){return locale.monthsRegex(isStrict);});addParseToken(['M','MM'],function(input,array){array[MONTH]=toInt(input)-1;});addParseToken(['MMM','MMMM'],function(input,array,config,token){var month=config._locale.monthsParse(input,token,config._strict);if(month!=null){array[MONTH]=month;}else{getParsingFlags(config).invalidMonth=input;}});var MONTHS_IN_FORMAT=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;var defaultLocaleMonths='January_February_March_April_May_June_July_August_September_October_November_December'.split('_');function localeMonths(m,format){if(!m){return isArray(this._months)?this._months:this._months['standalone'];}
return isArray(this._months)?this._months[m.month()]:this._months[(this._months.isFormat||MONTHS_IN_FORMAT).test(format)?'format':'standalone'][m.month()];}
var defaultLocaleMonthsShort='Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');function localeMonthsShort(m,format){if(!m){return isArray(this._monthsShort)?this._monthsShort:this._monthsShort['standalone'];}
return isArray(this._monthsShort)?this._monthsShort[m.month()]:this._monthsShort[MONTHS_IN_FORMAT.test(format)?'format':'standalone'][m.month()];}
function handleStrictParse(monthName,format,strict){var i,ii,mom,llc=monthName.toLocaleLowerCase();if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];for(i=0;i<12;++i){mom=createUTC([2000,i]);this._shortMonthsParse[i]=this.monthsShort(mom,'').toLocaleLowerCase();this._longMonthsParse[i]=this.months(mom,'').toLocaleLowerCase();}}
if(strict){if(format==='MMM'){ii=indexOf.call(this._shortMonthsParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._longMonthsParse,llc);return ii!==-1?ii:null;}}else{if(format==='MMM'){ii=indexOf.call(this._shortMonthsParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._longMonthsParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._longMonthsParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortMonthsParse,llc);return ii!==-1?ii:null;}}}
function localeMonthsParse(monthName,format,strict){var i,mom,regex;if(this._monthsParseExact){return handleStrictParse.call(this,monthName,format,strict);}
if(!this._monthsParse){this._monthsParse=[];this._longMonthsParse=[];this._shortMonthsParse=[];}
for(i=0;i<12;i++){mom=createUTC([2000,i]);if(strict&&!this._longMonthsParse[i]){this._longMonthsParse[i]=new RegExp('^'+this.months(mom,'').replace('.','')+'$','i');this._shortMonthsParse[i]=new RegExp('^'+this.monthsShort(mom,'').replace('.','')+'$','i');}
if(!strict&&!this._monthsParse[i]){regex='^'+this.months(mom,'')+'|^'+this.monthsShort(mom,'');this._monthsParse[i]=new RegExp(regex.replace('.',''),'i');}
if(strict&&format==='MMMM'&&this._longMonthsParse[i].test(monthName)){return i;}else if(strict&&format==='MMM'&&this._shortMonthsParse[i].test(monthName)){return i;}else if(!strict&&this._monthsParse[i].test(monthName)){return i;}}}
function setMonth(mom,value){var dayOfMonth;if(!mom.isValid()){return mom;}
if(typeof value==='string'){if(/^\d+$/.test(value)){value=toInt(value);}else{value=mom.localeData().monthsParse(value);if(!isNumber(value)){return mom;}}}
dayOfMonth=Math.min(mom.date(),daysInMonth(mom.year(),value));mom._d['set'+(mom._isUTC?'UTC':'')+'Month'](value,dayOfMonth);return mom;}
function getSetMonth(value){if(value!=null){setMonth(this,value);hooks.updateOffset(this,true);return this;}else{return get(this,'Month');}}
function getDaysInMonth(){return daysInMonth(this.year(),this.month());}
var defaultMonthsShortRegex=matchWord;function monthsShortRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,'_monthsRegex')){computeMonthsParse.call(this);}
if(isStrict){return this._monthsShortStrictRegex;}else{return this._monthsShortRegex;}}else{if(!hasOwnProp(this,'_monthsShortRegex')){this._monthsShortRegex=defaultMonthsShortRegex;}
return this._monthsShortStrictRegex&&isStrict?this._monthsShortStrictRegex:this._monthsShortRegex;}}
var defaultMonthsRegex=matchWord;function monthsRegex(isStrict){if(this._monthsParseExact){if(!hasOwnProp(this,'_monthsRegex')){computeMonthsParse.call(this);}
if(isStrict){return this._monthsStrictRegex;}else{return this._monthsRegex;}}else{if(!hasOwnProp(this,'_monthsRegex')){this._monthsRegex=defaultMonthsRegex;}
return this._monthsStrictRegex&&isStrict?this._monthsStrictRegex:this._monthsRegex;}}
function computeMonthsParse(){function cmpLenRev(a,b){return b.length-a.length;}
var shortPieces=[],longPieces=[],mixedPieces=[],i,mom;for(i=0;i<12;i++){mom=createUTC([2000,i]);shortPieces.push(this.monthsShort(mom,''));longPieces.push(this.months(mom,''));mixedPieces.push(this.months(mom,''));mixedPieces.push(this.monthsShort(mom,''));}
shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<12;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i]);}
for(i=0;i<24;i++){mixedPieces[i]=regexEscape(mixedPieces[i]);}
this._monthsRegex=new RegExp('^('+mixedPieces.join('|')+')','i');this._monthsShortRegex=this._monthsRegex;this._monthsStrictRegex=new RegExp('^('+longPieces.join('|')+')','i');this._monthsShortStrictRegex=new RegExp('^('+shortPieces.join('|')+')','i');}
function createDate(y,m,d,h,M,s,ms){var date;if(y<100&&y>=0){date=new Date(y+400,m,d,h,M,s,ms);if(isFinite(date.getFullYear())){date.setFullYear(y);}}else{date=new Date(y,m,d,h,M,s,ms);}
return date;}
function createUTCDate(y){var date;if(y<100&&y>=0){var args=Array.prototype.slice.call(arguments);args[0]=y+400;date=new Date(Date.UTC.apply(null,args));if(isFinite(date.getUTCFullYear())){date.setUTCFullYear(y);}}else{date=new Date(Date.UTC.apply(null,arguments));}
return date;}
function firstWeekOffset(year,dow,doy){var
fwd=7+dow-doy,fwdlw=(7+createUTCDate(year,0,fwd).getUTCDay()-dow)%7;return-fwdlw+fwd-1;}
function dayOfYearFromWeeks(year,week,weekday,dow,doy){var localWeekday=(7+weekday-dow)%7,weekOffset=firstWeekOffset(year,dow,doy),dayOfYear=1+7*(week-1)+localWeekday+weekOffset,resYear,resDayOfYear;if(dayOfYear<=0){resYear=year-1;resDayOfYear=daysInYear(resYear)+dayOfYear;}else if(dayOfYear>daysInYear(year)){resYear=year+1;resDayOfYear=dayOfYear-daysInYear(year);}else{resYear=year;resDayOfYear=dayOfYear;}
return{year:resYear,dayOfYear:resDayOfYear};}
function weekOfYear(mom,dow,doy){var weekOffset=firstWeekOffset(mom.year(),dow,doy),week=Math.floor((mom.dayOfYear()-weekOffset-1)/7)+1,resWeek,resYear;if(week<1){resYear=mom.year()-1;resWeek=week+weeksInYear(resYear,dow,doy);}else if(week>weeksInYear(mom.year(),dow,doy)){resWeek=week-weeksInYear(mom.year(),dow,doy);resYear=mom.year()+1;}else{resYear=mom.year();resWeek=week;}
return{week:resWeek,year:resYear};}
function weeksInYear(year,dow,doy){var weekOffset=firstWeekOffset(year,dow,doy),weekOffsetNext=firstWeekOffset(year+1,dow,doy);return(daysInYear(year)-weekOffset+weekOffsetNext)/7;}
addFormatToken('w',['ww',2],'wo','week');addFormatToken('W',['WW',2],'Wo','isoWeek');addUnitAlias('week','w');addUnitAlias('isoWeek','W');addUnitPriority('week',5);addUnitPriority('isoWeek',5);addRegexToken('w',match1to2);addRegexToken('ww',match1to2,match2);addRegexToken('W',match1to2);addRegexToken('WW',match1to2,match2);addWeekParseToken(['w','ww','W','WW'],function(input,week,config,token){week[token.substr(0,1)]=toInt(input);});function localeWeek(mom){return weekOfYear(mom,this._week.dow,this._week.doy).week;}
var defaultLocaleWeek={dow:0,doy:6};function localeFirstDayOfWeek(){return this._week.dow;}
function localeFirstDayOfYear(){return this._week.doy;}
function getSetWeek(input){var week=this.localeData().week(this);return input==null?week:this.add((input-week)*7,'d');}
function getSetISOWeek(input){var week=weekOfYear(this,1,4).week;return input==null?week:this.add((input-week)*7,'d');}
addFormatToken('d',0,'do','day');addFormatToken('dd',0,0,function(format){return this.localeData().weekdaysMin(this,format);});addFormatToken('ddd',0,0,function(format){return this.localeData().weekdaysShort(this,format);});addFormatToken('dddd',0,0,function(format){return this.localeData().weekdays(this,format);});addFormatToken('e',0,0,'weekday');addFormatToken('E',0,0,'isoWeekday');addUnitAlias('day','d');addUnitAlias('weekday','e');addUnitAlias('isoWeekday','E');addUnitPriority('day',11);addUnitPriority('weekday',11);addUnitPriority('isoWeekday',11);addRegexToken('d',match1to2);addRegexToken('e',match1to2);addRegexToken('E',match1to2);addRegexToken('dd',function(isStrict,locale){return locale.weekdaysMinRegex(isStrict);});addRegexToken('ddd',function(isStrict,locale){return locale.weekdaysShortRegex(isStrict);});addRegexToken('dddd',function(isStrict,locale){return locale.weekdaysRegex(isStrict);});addWeekParseToken(['dd','ddd','dddd'],function(input,week,config,token){var weekday=config._locale.weekdaysParse(input,token,config._strict);if(weekday!=null){week.d=weekday;}else{getParsingFlags(config).invalidWeekday=input;}});addWeekParseToken(['d','e','E'],function(input,week,config,token){week[token]=toInt(input);});function parseWeekday(input,locale){if(typeof input!=='string'){return input;}
if(!isNaN(input)){return parseInt(input,10);}
input=locale.weekdaysParse(input);if(typeof input==='number'){return input;}
return null;}
function parseIsoWeekday(input,locale){if(typeof input==='string'){return locale.weekdaysParse(input)%7||7;}
return isNaN(input)?null:input;}
function shiftWeekdays(ws,n){return ws.slice(n,7).concat(ws.slice(0,n));}
var defaultLocaleWeekdays='Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');function localeWeekdays(m,format){var weekdays=isArray(this._weekdays)?this._weekdays:this._weekdays[(m&&m!==true&&this._weekdays.isFormat.test(format))?'format':'standalone'];return(m===true)?shiftWeekdays(weekdays,this._week.dow):(m)?weekdays[m.day()]:weekdays;}
var defaultLocaleWeekdaysShort='Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');function localeWeekdaysShort(m){return(m===true)?shiftWeekdays(this._weekdaysShort,this._week.dow):(m)?this._weekdaysShort[m.day()]:this._weekdaysShort;}
var defaultLocaleWeekdaysMin='Su_Mo_Tu_We_Th_Fr_Sa'.split('_');function localeWeekdaysMin(m){return(m===true)?shiftWeekdays(this._weekdaysMin,this._week.dow):(m)?this._weekdaysMin[m.day()]:this._weekdaysMin;}
function handleStrictParse$1(weekdayName,format,strict){var i,ii,mom,llc=weekdayName.toLocaleLowerCase();if(!this._weekdaysParse){this._weekdaysParse=[];this._shortWeekdaysParse=[];this._minWeekdaysParse=[];for(i=0;i<7;++i){mom=createUTC([2000,1]).day(i);this._minWeekdaysParse[i]=this.weekdaysMin(mom,'').toLocaleLowerCase();this._shortWeekdaysParse[i]=this.weekdaysShort(mom,'').toLocaleLowerCase();this._weekdaysParse[i]=this.weekdays(mom,'').toLocaleLowerCase();}}
if(strict){if(format==='dddd'){ii=indexOf.call(this._weekdaysParse,llc);return ii!==-1?ii:null;}else if(format==='ddd'){ii=indexOf.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}}else{if(format==='dddd'){ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}else if(format==='ddd'){ii=indexOf.call(this._shortWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._minWeekdaysParse,llc);return ii!==-1?ii:null;}else{ii=indexOf.call(this._minWeekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._weekdaysParse,llc);if(ii!==-1){return ii;}
ii=indexOf.call(this._shortWeekdaysParse,llc);return ii!==-1?ii:null;}}}
function localeWeekdaysParse(weekdayName,format,strict){var i,mom,regex;if(this._weekdaysParseExact){return handleStrictParse$1.call(this,weekdayName,format,strict);}
if(!this._weekdaysParse){this._weekdaysParse=[];this._minWeekdaysParse=[];this._shortWeekdaysParse=[];this._fullWeekdaysParse=[];}
for(i=0;i<7;i++){mom=createUTC([2000,1]).day(i);if(strict&&!this._fullWeekdaysParse[i]){this._fullWeekdaysParse[i]=new RegExp('^'+this.weekdays(mom,'').replace('.','\\.?')+'$','i');this._shortWeekdaysParse[i]=new RegExp('^'+this.weekdaysShort(mom,'').replace('.','\\.?')+'$','i');this._minWeekdaysParse[i]=new RegExp('^'+this.weekdaysMin(mom,'').replace('.','\\.?')+'$','i');}
if(!this._weekdaysParse[i]){regex='^'+this.weekdays(mom,'')+'|^'+this.weekdaysShort(mom,'')+'|^'+this.weekdaysMin(mom,'');this._weekdaysParse[i]=new RegExp(regex.replace('.',''),'i');}
if(strict&&format==='dddd'&&this._fullWeekdaysParse[i].test(weekdayName)){return i;}else if(strict&&format==='ddd'&&this._shortWeekdaysParse[i].test(weekdayName)){return i;}else if(strict&&format==='dd'&&this._minWeekdaysParse[i].test(weekdayName)){return i;}else if(!strict&&this._weekdaysParse[i].test(weekdayName)){return i;}}}
function getSetDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
var day=this._isUTC?this._d.getUTCDay():this._d.getDay();if(input!=null){input=parseWeekday(input,this.localeData());return this.add(input-day,'d');}else{return day;}}
function getSetLocaleDayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
var weekday=(this.day()+7-this.localeData()._week.dow)%7;return input==null?weekday:this.add(input-weekday,'d');}
function getSetISODayOfWeek(input){if(!this.isValid()){return input!=null?this:NaN;}
if(input!=null){var weekday=parseIsoWeekday(input,this.localeData());return this.day(this.day()%7?weekday:weekday-7);}else{return this.day()||7;}}
var defaultWeekdaysRegex=matchWord;function weekdaysRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysStrictRegex;}else{return this._weekdaysRegex;}}else{if(!hasOwnProp(this,'_weekdaysRegex')){this._weekdaysRegex=defaultWeekdaysRegex;}
return this._weekdaysStrictRegex&&isStrict?this._weekdaysStrictRegex:this._weekdaysRegex;}}
var defaultWeekdaysShortRegex=matchWord;function weekdaysShortRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysShortStrictRegex;}else{return this._weekdaysShortRegex;}}else{if(!hasOwnProp(this,'_weekdaysShortRegex')){this._weekdaysShortRegex=defaultWeekdaysShortRegex;}
return this._weekdaysShortStrictRegex&&isStrict?this._weekdaysShortStrictRegex:this._weekdaysShortRegex;}}
var defaultWeekdaysMinRegex=matchWord;function weekdaysMinRegex(isStrict){if(this._weekdaysParseExact){if(!hasOwnProp(this,'_weekdaysRegex')){computeWeekdaysParse.call(this);}
if(isStrict){return this._weekdaysMinStrictRegex;}else{return this._weekdaysMinRegex;}}else{if(!hasOwnProp(this,'_weekdaysMinRegex')){this._weekdaysMinRegex=defaultWeekdaysMinRegex;}
return this._weekdaysMinStrictRegex&&isStrict?this._weekdaysMinStrictRegex:this._weekdaysMinRegex;}}
function computeWeekdaysParse(){function cmpLenRev(a,b){return b.length-a.length;}
var minPieces=[],shortPieces=[],longPieces=[],mixedPieces=[],i,mom,minp,shortp,longp;for(i=0;i<7;i++){mom=createUTC([2000,1]).day(i);minp=this.weekdaysMin(mom,'');shortp=this.weekdaysShort(mom,'');longp=this.weekdays(mom,'');minPieces.push(minp);shortPieces.push(shortp);longPieces.push(longp);mixedPieces.push(minp);mixedPieces.push(shortp);mixedPieces.push(longp);}
minPieces.sort(cmpLenRev);shortPieces.sort(cmpLenRev);longPieces.sort(cmpLenRev);mixedPieces.sort(cmpLenRev);for(i=0;i<7;i++){shortPieces[i]=regexEscape(shortPieces[i]);longPieces[i]=regexEscape(longPieces[i]);mixedPieces[i]=regexEscape(mixedPieces[i]);}
this._weekdaysRegex=new RegExp('^('+mixedPieces.join('|')+')','i');this._weekdaysShortRegex=this._weekdaysRegex;this._weekdaysMinRegex=this._weekdaysRegex;this._weekdaysStrictRegex=new RegExp('^('+longPieces.join('|')+')','i');this._weekdaysShortStrictRegex=new RegExp('^('+shortPieces.join('|')+')','i');this._weekdaysMinStrictRegex=new RegExp('^('+minPieces.join('|')+')','i');}
function hFormat(){return this.hours()%12||12;}
function kFormat(){return this.hours()||24;}
addFormatToken('H',['HH',2],0,'hour');addFormatToken('h',['hh',2],0,hFormat);addFormatToken('k',['kk',2],0,kFormat);addFormatToken('hmm',0,0,function(){return ''+hFormat.apply(this)+zeroFill(this.minutes(),2);});addFormatToken('hmmss',0,0,function(){return ''+hFormat.apply(this)+zeroFill(this.minutes(),2)+
zeroFill(this.seconds(),2);});addFormatToken('Hmm',0,0,function(){return ''+this.hours()+zeroFill(this.minutes(),2);});addFormatToken('Hmmss',0,0,function(){return ''+this.hours()+zeroFill(this.minutes(),2)+
zeroFill(this.seconds(),2);});function meridiem(token,lowercase){addFormatToken(token,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),lowercase);});}
meridiem('a',true);meridiem('A',false);addUnitAlias('hour','h');addUnitPriority('hour',13);function matchMeridiem(isStrict,locale){return locale._meridiemParse;}
addRegexToken('a',matchMeridiem);addRegexToken('A',matchMeridiem);addRegexToken('H',match1to2);addRegexToken('h',match1to2);addRegexToken('k',match1to2);addRegexToken('HH',match1to2,match2);addRegexToken('hh',match1to2,match2);addRegexToken('kk',match1to2,match2);addRegexToken('hmm',match3to4);addRegexToken('hmmss',match5to6);addRegexToken('Hmm',match3to4);addRegexToken('Hmmss',match5to6);addParseToken(['H','HH'],HOUR);addParseToken(['k','kk'],function(input,array,config){var kInput=toInt(input);array[HOUR]=kInput===24?0:kInput;});addParseToken(['a','A'],function(input,array,config){config._isPm=config._locale.isPM(input);config._meridiem=input;});addParseToken(['h','hh'],function(input,array,config){array[HOUR]=toInt(input);getParsingFlags(config).bigHour=true;});addParseToken('hmm',function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos));getParsingFlags(config).bigHour=true;});addParseToken('hmmss',function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2));getParsingFlags(config).bigHour=true;});addParseToken('Hmm',function(input,array,config){var pos=input.length-2;array[HOUR]=toInt(input.substr(0,pos));array[MINUTE]=toInt(input.substr(pos));});addParseToken('Hmmss',function(input,array,config){var pos1=input.length-4;var pos2=input.length-2;array[HOUR]=toInt(input.substr(0,pos1));array[MINUTE]=toInt(input.substr(pos1,2));array[SECOND]=toInt(input.substr(pos2));});function localeIsPM(input){return((input+'').toLowerCase().charAt(0)==='p');}
var defaultLocaleMeridiemParse=/[ap]\.?m?\.?/i;function localeMeridiem(hours,minutes,isLower){if(hours>11){return isLower?'pm':'PM';}else{return isLower?'am':'AM';}}
var getSetHour=makeGetSet('Hours',true);var baseConfig={calendar:defaultCalendar,longDateFormat:defaultLongDateFormat,invalidDate:defaultInvalidDate,ordinal:defaultOrdinal,dayOfMonthOrdinalParse:defaultDayOfMonthOrdinalParse,relativeTime:defaultRelativeTime,months:defaultLocaleMonths,monthsShort:defaultLocaleMonthsShort,week:defaultLocaleWeek,weekdays:defaultLocaleWeekdays,weekdaysMin:defaultLocaleWeekdaysMin,weekdaysShort:defaultLocaleWeekdaysShort,meridiemParse:defaultLocaleMeridiemParse};var locales={};var localeFamilies={};var globalLocale;function normalizeLocale(key){return key?key.toLowerCase().replace('_','-'):key;}
function chooseLocale(names){var i=0,j,next,locale,split;while(i<names.length){split=normalizeLocale(names[i]).split('-');j=split.length;next=normalizeLocale(names[i+1]);next=next?next.split('-'):null;while(j>0){locale=loadLocale(split.slice(0,j).join('-'));if(locale){return locale;}
if(next&&next.length>=j&&compareArrays(split,next,true)>=j-1){break;}
j--;}
i++;}
return globalLocale;}
function loadLocale(name){var oldLocale=null;if(!locales[name]&&(typeof module!=='undefined')&&module&&module.exports){try{oldLocale=globalLocale._abbr;var aliasedRequire=require;aliasedRequire('./locale/'+name);getSetGlobalLocale(oldLocale);}catch(e){}}
return locales[name];}
function getSetGlobalLocale(key,values){var data;if(key){if(isUndefined(values)){data=getLocale(key);}
else{data=defineLocale(key,values);}
if(data){globalLocale=data;}
else{if((typeof console!=='undefined')&&console.warn){console.warn('Locale '+key+' not found. Did you forget to load it?');}}}
return globalLocale._abbr;}
function defineLocale(name,config){if(config!==null){var locale,parentConfig=baseConfig;config.abbr=name;if(locales[name]!=null){deprecateSimple('defineLocaleOverride','use moment.updateLocale(localeName, config) to change '+
'an existing locale. moment.defineLocale(localeName, '+
'config) should only be used for creating a new locale '+
'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');parentConfig=locales[name]._config;}else if(config.parentLocale!=null){if(locales[config.parentLocale]!=null){parentConfig=locales[config.parentLocale]._config;}else{locale=loadLocale(config.parentLocale);if(locale!=null){parentConfig=locale._config;}else{if(!localeFamilies[config.parentLocale]){localeFamilies[config.parentLocale]=[];}
localeFamilies[config.parentLocale].push({name:name,config:config});return null;}}}
locales[name]=new Locale(mergeConfigs(parentConfig,config));if(localeFamilies[name]){localeFamilies[name].forEach(function(x){defineLocale(x.name,x.config);});}
getSetGlobalLocale(name);return locales[name];}else{delete locales[name];return null;}}
function updateLocale(name,config){if(config!=null){var locale,tmpLocale,parentConfig=baseConfig;tmpLocale=loadLocale(name);if(tmpLocale!=null){parentConfig=tmpLocale._config;}
config=mergeConfigs(parentConfig,config);locale=new Locale(config);locale.parentLocale=locales[name];locales[name]=locale;getSetGlobalLocale(name);}else{if(locales[name]!=null){if(locales[name].parentLocale!=null){locales[name]=locales[name].parentLocale;}else if(locales[name]!=null){delete locales[name];}}}
return locales[name];}
function getLocale(key){var locale;if(key&&key._locale&&key._locale._abbr){key=key._locale._abbr;}
if(!key){return globalLocale;}
if(!isArray(key)){locale=loadLocale(key);if(locale){return locale;}
key=[key];}
return chooseLocale(key);}
function listLocales(){return keys(locales);}
function checkOverflow(m){var overflow;var a=m._a;if(a&&getParsingFlags(m).overflow===-2){overflow=a[MONTH]<0||a[MONTH]>11?MONTH:a[DATE]<1||a[DATE]>daysInMonth(a[YEAR],a[MONTH])?DATE:a[HOUR]<0||a[HOUR]>24||(a[HOUR]===24&&(a[MINUTE]!==0||a[SECOND]!==0||a[MILLISECOND]!==0))?HOUR:a[MINUTE]<0||a[MINUTE]>59?MINUTE:a[SECOND]<0||a[SECOND]>59?SECOND:a[MILLISECOND]<0||a[MILLISECOND]>999?MILLISECOND:-1;if(getParsingFlags(m)._overflowDayOfYear&&(overflow<YEAR||overflow>DATE)){overflow=DATE;}
if(getParsingFlags(m)._overflowWeeks&&overflow===-1){overflow=WEEK;}
if(getParsingFlags(m)._overflowWeekday&&overflow===-1){overflow=WEEKDAY;}
getParsingFlags(m).overflow=overflow;}
return m;}
function defaults(a,b,c){if(a!=null){return a;}
if(b!=null){return b;}
return c;}
function currentDateArray(config){var nowValue=new Date(hooks.now());if(config._useUTC){return[nowValue.getUTCFullYear(),nowValue.getUTCMonth(),nowValue.getUTCDate()];}
return[nowValue.getFullYear(),nowValue.getMonth(),nowValue.getDate()];}
function configFromArray(config){var i,date,input=[],currentDate,expectedWeekday,yearToUse;if(config._d){return;}
currentDate=currentDateArray(config);if(config._w&&config._a[DATE]==null&&config._a[MONTH]==null){dayOfYearFromWeekInfo(config);}
if(config._dayOfYear!=null){yearToUse=defaults(config._a[YEAR],currentDate[YEAR]);if(config._dayOfYear>daysInYear(yearToUse)||config._dayOfYear===0){getParsingFlags(config)._overflowDayOfYear=true;}
date=createUTCDate(yearToUse,0,config._dayOfYear);config._a[MONTH]=date.getUTCMonth();config._a[DATE]=date.getUTCDate();}
for(i=0;i<3&&config._a[i]==null;++i){config._a[i]=input[i]=currentDate[i];}
for(;i<7;i++){config._a[i]=input[i]=(config._a[i]==null)?(i===2?1:0):config._a[i];}
if(config._a[HOUR]===24&&config._a[MINUTE]===0&&config._a[SECOND]===0&&config._a[MILLISECOND]===0){config._nextDay=true;config._a[HOUR]=0;}
config._d=(config._useUTC?createUTCDate:createDate).apply(null,input);expectedWeekday=config._useUTC?config._d.getUTCDay():config._d.getDay();if(config._tzm!=null){config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm);}
if(config._nextDay){config._a[HOUR]=24;}
if(config._w&&typeof config._w.d!=='undefined'&&config._w.d!==expectedWeekday){getParsingFlags(config).weekdayMismatch=true;}}
function dayOfYearFromWeekInfo(config){var w,weekYear,week,weekday,dow,doy,temp,weekdayOverflow;w=config._w;if(w.GG!=null||w.W!=null||w.E!=null){dow=1;doy=4;weekYear=defaults(w.GG,config._a[YEAR],weekOfYear(createLocal(),1,4).year);week=defaults(w.W,1);weekday=defaults(w.E,1);if(weekday<1||weekday>7){weekdayOverflow=true;}}else{dow=config._locale._week.dow;doy=config._locale._week.doy;var curWeek=weekOfYear(createLocal(),dow,doy);weekYear=defaults(w.gg,config._a[YEAR],curWeek.year);week=defaults(w.w,curWeek.week);if(w.d!=null){weekday=w.d;if(weekday<0||weekday>6){weekdayOverflow=true;}}else if(w.e!=null){weekday=w.e+dow;if(w.e<0||w.e>6){weekdayOverflow=true;}}else{weekday=dow;}}
if(week<1||week>weeksInYear(weekYear,dow,doy)){getParsingFlags(config)._overflowWeeks=true;}else if(weekdayOverflow!=null){getParsingFlags(config)._overflowWeekday=true;}else{temp=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy);config._a[YEAR]=temp.year;config._dayOfYear=temp.dayOfYear;}}
var extendedIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var basicIsoRegex=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;var tzRegex=/Z|[+-]\d\d(?::?\d\d)?/;var isoDates=[['YYYYYY-MM-DD',/[+-]\d{6}-\d\d-\d\d/],['YYYY-MM-DD',/\d{4}-\d\d-\d\d/],['GGGG-[W]WW-E',/\d{4}-W\d\d-\d/],['GGGG-[W]WW',/\d{4}-W\d\d/,false],['YYYY-DDD',/\d{4}-\d{3}/],['YYYY-MM',/\d{4}-\d\d/,false],['YYYYYYMMDD',/[+-]\d{10}/],['YYYYMMDD',/\d{8}/],['GGGG[W]WWE',/\d{4}W\d{3}/],['GGGG[W]WW',/\d{4}W\d{2}/,false],['YYYYDDD',/\d{7}/]];var isoTimes=[['HH:mm:ss.SSSS',/\d\d:\d\d:\d\d\.\d+/],['HH:mm:ss,SSSS',/\d\d:\d\d:\d\d,\d+/],['HH:mm:ss',/\d\d:\d\d:\d\d/],['HH:mm',/\d\d:\d\d/],['HHmmss.SSSS',/\d\d\d\d\d\d\.\d+/],['HHmmss,SSSS',/\d\d\d\d\d\d,\d+/],['HHmmss',/\d\d\d\d\d\d/],['HHmm',/\d\d\d\d/],['HH',/\d\d/]];var aspNetJsonRegex=/^\/?Date\((\-?\d+)/i;function configFromISO(config){var i,l,string=config._i,match=extendedIsoRegex.exec(string)||basicIsoRegex.exec(string),allowTime,dateFormat,timeFormat,tzFormat;if(match){getParsingFlags(config).iso=true;for(i=0,l=isoDates.length;i<l;i++){if(isoDates[i][1].exec(match[1])){dateFormat=isoDates[i][0];allowTime=isoDates[i][2]!==false;break;}}
if(dateFormat==null){config._isValid=false;return;}
if(match[3]){for(i=0,l=isoTimes.length;i<l;i++){if(isoTimes[i][1].exec(match[3])){timeFormat=(match[2]||' ')+isoTimes[i][0];break;}}
if(timeFormat==null){config._isValid=false;return;}}
if(!allowTime&&timeFormat!=null){config._isValid=false;return;}
if(match[4]){if(tzRegex.exec(match[4])){tzFormat='Z';}else{config._isValid=false;return;}}
config._f=dateFormat+(timeFormat||'')+(tzFormat||'');configFromStringAndFormat(config);}else{config._isValid=false;}}
var rfc2822=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;function extractFromRFC2822Strings(yearStr,monthStr,dayStr,hourStr,minuteStr,secondStr){var result=[untruncateYear(yearStr),defaultLocaleMonthsShort.indexOf(monthStr),parseInt(dayStr,10),parseInt(hourStr,10),parseInt(minuteStr,10)];if(secondStr){result.push(parseInt(secondStr,10));}
return result;}
function untruncateYear(yearStr){var year=parseInt(yearStr,10);if(year<=49){return 2000+year;}else if(year<=999){return 1900+year;}
return year;}
function preprocessRFC2822(s){return s.replace(/\([^)]*\)|[\n\t]/g,' ').replace(/(\s\s+)/g,' ').replace(/^\s\s*/,'').replace(/\s\s*$/,'');}
function checkWeekday(weekdayStr,parsedInput,config){if(weekdayStr){var weekdayProvided=defaultLocaleWeekdaysShort.indexOf(weekdayStr),weekdayActual=new Date(parsedInput[0],parsedInput[1],parsedInput[2]).getDay();if(weekdayProvided!==weekdayActual){getParsingFlags(config).weekdayMismatch=true;config._isValid=false;return false;}}
return true;}
var obsOffsets={UT:0,GMT:0,EDT:-4*60,EST:-5*60,CDT:-5*60,CST:-6*60,MDT:-6*60,MST:-7*60,PDT:-7*60,PST:-8*60};function calculateOffset(obsOffset,militaryOffset,numOffset){if(obsOffset){return obsOffsets[obsOffset];}else if(militaryOffset){return 0;}else{var hm=parseInt(numOffset,10);var m=hm%100,h=(hm-m)/100;return h*60+m;}}
function configFromRFC2822(config){var match=rfc2822.exec(preprocessRFC2822(config._i));if(match){var parsedArray=extractFromRFC2822Strings(match[4],match[3],match[2],match[5],match[6],match[7]);if(!checkWeekday(match[1],parsedArray,config)){return;}
config._a=parsedArray;config._tzm=calculateOffset(match[8],match[9],match[10]);config._d=createUTCDate.apply(null,config._a);config._d.setUTCMinutes(config._d.getUTCMinutes()-config._tzm);getParsingFlags(config).rfc2822=true;}else{config._isValid=false;}}
function configFromString(config){var matched=aspNetJsonRegex.exec(config._i);if(matched!==null){config._d=new Date(+matched[1]);return;}
configFromISO(config);if(config._isValid===false){delete config._isValid;}else{return;}
configFromRFC2822(config);if(config._isValid===false){delete config._isValid;}else{return;}
hooks.createFromInputFallback(config);}
hooks.createFromInputFallback=deprecate('value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), '+
'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are '+
'discouraged and will be removed in an upcoming major release. Please refer to '+
'http://momentjs.com/guides/#/warnings/js-date/ for more info.',function(config){config._d=new Date(config._i+(config._useUTC?' UTC':''));});hooks.ISO_8601=function(){};hooks.RFC_2822=function(){};function configFromStringAndFormat(config){if(config._f===hooks.ISO_8601){configFromISO(config);return;}
if(config._f===hooks.RFC_2822){configFromRFC2822(config);return;}
config._a=[];getParsingFlags(config).empty=true;var string=''+config._i,i,parsedInput,tokens,token,skipped,stringLength=string.length,totalParsedInputLength=0;tokens=expandFormat(config._f,config._locale).match(formattingTokens)||[];for(i=0;i<tokens.length;i++){token=tokens[i];parsedInput=(string.match(getParseRegexForToken(token,config))||[])[0];if(parsedInput){skipped=string.substr(0,string.indexOf(parsedInput));if(skipped.length>0){getParsingFlags(config).unusedInput.push(skipped);}
string=string.slice(string.indexOf(parsedInput)+parsedInput.length);totalParsedInputLength+=parsedInput.length;}
if(formatTokenFunctions[token]){if(parsedInput){getParsingFlags(config).empty=false;}
else{getParsingFlags(config).unusedTokens.push(token);}
addTimeToArrayFromToken(token,parsedInput,config);}
else if(config._strict&&!parsedInput){getParsingFlags(config).unusedTokens.push(token);}}
getParsingFlags(config).charsLeftOver=stringLength-totalParsedInputLength;if(string.length>0){getParsingFlags(config).unusedInput.push(string);}
if(config._a[HOUR]<=12&&getParsingFlags(config).bigHour===true&&config._a[HOUR]>0){getParsingFlags(config).bigHour=undefined;}
getParsingFlags(config).parsedDateParts=config._a.slice(0);getParsingFlags(config).meridiem=config._meridiem;config._a[HOUR]=meridiemFixWrap(config._locale,config._a[HOUR],config._meridiem);configFromArray(config);checkOverflow(config);}
function meridiemFixWrap(locale,hour,meridiem){var isPm;if(meridiem==null){return hour;}
if(locale.meridiemHour!=null){return locale.meridiemHour(hour,meridiem);}else if(locale.isPM!=null){isPm=locale.isPM(meridiem);if(isPm&&hour<12){hour+=12;}
if(!isPm&&hour===12){hour=0;}
return hour;}else{return hour;}}
function configFromStringAndArray(config){var tempConfig,bestMoment,scoreToBeat,i,currentScore;if(config._f.length===0){getParsingFlags(config).invalidFormat=true;config._d=new Date(NaN);return;}
for(i=0;i<config._f.length;i++){currentScore=0;tempConfig=copyConfig({},config);if(config._useUTC!=null){tempConfig._useUTC=config._useUTC;}
tempConfig._f=config._f[i];configFromStringAndFormat(tempConfig);if(!isValid(tempConfig)){continue;}
currentScore+=getParsingFlags(tempConfig).charsLeftOver;currentScore+=getParsingFlags(tempConfig).unusedTokens.length*10;getParsingFlags(tempConfig).score=currentScore;if(scoreToBeat==null||currentScore<scoreToBeat){scoreToBeat=currentScore;bestMoment=tempConfig;}}
extend(config,bestMoment||tempConfig);}
function configFromObject(config){if(config._d){return;}
var i=normalizeObjectUnits(config._i);config._a=map([i.year,i.month,i.day||i.date,i.hour,i.minute,i.second,i.millisecond],function(obj){return obj&&parseInt(obj,10);});configFromArray(config);}
function createFromConfig(config){var res=new Moment(checkOverflow(prepareConfig(config)));if(res._nextDay){res.add(1,'d');res._nextDay=undefined;}
return res;}
function prepareConfig(config){var input=config._i,format=config._f;config._locale=config._locale||getLocale(config._l);if(input===null||(format===undefined&&input==='')){return createInvalid({nullInput:true});}
if(typeof input==='string'){config._i=input=config._locale.preparse(input);}
if(isMoment(input)){return new Moment(checkOverflow(input));}else if(isDate(input)){config._d=input;}else if(isArray(format)){configFromStringAndArray(config);}else if(format){configFromStringAndFormat(config);}else{configFromInput(config);}
if(!isValid(config)){config._d=null;}
return config;}
function configFromInput(config){var input=config._i;if(isUndefined(input)){config._d=new Date(hooks.now());}else if(isDate(input)){config._d=new Date(input.valueOf());}else if(typeof input==='string'){configFromString(config);}else if(isArray(input)){config._a=map(input.slice(0),function(obj){return parseInt(obj,10);});configFromArray(config);}else if(isObject(input)){configFromObject(config);}else if(isNumber(input)){config._d=new Date(input);}else{hooks.createFromInputFallback(config);}}
function createLocalOrUTC(input,format,locale,strict,isUTC){var c={};if(locale===true||locale===false){strict=locale;locale=undefined;}
if((isObject(input)&&isObjectEmpty(input))||(isArray(input)&&input.length===0)){input=undefined;}
c._isAMomentObject=true;c._useUTC=c._isUTC=isUTC;c._l=locale;c._i=input;c._f=format;c._strict=strict;return createFromConfig(c);}
function createLocal(input,format,locale,strict){return createLocalOrUTC(input,format,locale,strict,false);}
var prototypeMin=deprecate('moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other<this?this:other;}else{return createInvalid();}});var prototypeMax=deprecate('moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',function(){var other=createLocal.apply(null,arguments);if(this.isValid()&&other.isValid()){return other>this?this:other;}else{return createInvalid();}});function pickBy(fn,moments){var res,i;if(moments.length===1&&isArray(moments[0])){moments=moments[0];}
if(!moments.length){return createLocal();}
res=moments[0];for(i=1;i<moments.length;++i){if(!moments[i].isValid()||moments[i][fn](res)){res=moments[i];}}
return res;}
function min(){var args=[].slice.call(arguments,0);return pickBy('isBefore',args);}
function max(){var args=[].slice.call(arguments,0);return pickBy('isAfter',args);}
var now=function(){return Date.now?Date.now():+(new Date());};var ordering=['year','quarter','month','week','day','hour','minute','second','millisecond'];function isDurationValid(m){for(var key in m){if(!(indexOf.call(ordering,key)!==-1&&(m[key]==null||!isNaN(m[key])))){return false;}}
var unitHasDecimal=false;for(var i=0;i<ordering.length;++i){if(m[ordering[i]]){if(unitHasDecimal){return false;}
if(parseFloat(m[ordering[i]])!==toInt(m[ordering[i]])){unitHasDecimal=true;}}}
return true;}
function isValid$1(){return this._isValid;}
function createInvalid$1(){return createDuration(NaN);}
function Duration(duration){var normalizedInput=normalizeObjectUnits(duration),years=normalizedInput.year||0,quarters=normalizedInput.quarter||0,months=normalizedInput.month||0,weeks=normalizedInput.week||normalizedInput.isoWeek||0,days=normalizedInput.day||0,hours=normalizedInput.hour||0,minutes=normalizedInput.minute||0,seconds=normalizedInput.second||0,milliseconds=normalizedInput.millisecond||0;this._isValid=isDurationValid(normalizedInput);this._milliseconds=+milliseconds+
seconds*1e3+
minutes*6e4+
hours*1000*60*60;this._days=+days+
weeks*7;this._months=+months+
quarters*3+
years*12;this._data={};this._locale=getLocale();this._bubble();}
function isDuration(obj){return obj instanceof Duration;}
function absRound(number){if(number<0){return Math.round(-1*number)*-1;}else{return Math.round(number);}}
function offset(token,separator){addFormatToken(token,0,0,function(){var offset=this.utcOffset();var sign='+';if(offset<0){offset=-offset;sign='-';}
return sign+zeroFill(~~(offset/60),2)+separator+zeroFill(~~(offset)%60,2);});}
offset('Z',':');offset('ZZ','');addRegexToken('Z',matchShortOffset);addRegexToken('ZZ',matchShortOffset);addParseToken(['Z','ZZ'],function(input,array,config){config._useUTC=true;config._tzm=offsetFromString(matchShortOffset,input);});var chunkOffset=/([\+\-]|\d\d)/gi;function offsetFromString(matcher,string){var matches=(string||'').match(matcher);if(matches===null){return null;}
var chunk=matches[matches.length-1]||[];var parts=(chunk+'').match(chunkOffset)||['-',0,0];var minutes=+(parts[1]*60)+toInt(parts[2]);return minutes===0?0:parts[0]==='+'?minutes:-minutes;}
function cloneWithOffset(input,model){var res,diff;if(model._isUTC){res=model.clone();diff=(isMoment(input)||isDate(input)?input.valueOf():createLocal(input).valueOf())-res.valueOf();res._d.setTime(res._d.valueOf()+diff);hooks.updateOffset(res,false);return res;}else{return createLocal(input).local();}}
function getDateOffset(m){return-Math.round(m._d.getTimezoneOffset()/15)*15;}
hooks.updateOffset=function(){};function getSetOffset(input,keepLocalTime,keepMinutes){var offset=this._offset||0,localAdjust;if(!this.isValid()){return input!=null?this:NaN;}
if(input!=null){if(typeof input==='string'){input=offsetFromString(matchShortOffset,input);if(input===null){return this;}}else if(Math.abs(input)<16&&!keepMinutes){input=input*60;}
if(!this._isUTC&&keepLocalTime){localAdjust=getDateOffset(this);}
this._offset=input;this._isUTC=true;if(localAdjust!=null){this.add(localAdjust,'m');}
if(offset!==input){if(!keepLocalTime||this._changeInProgress){addSubtract(this,createDuration(input-offset,'m'),1,false);}else if(!this._changeInProgress){this._changeInProgress=true;hooks.updateOffset(this,true);this._changeInProgress=null;}}
return this;}else{return this._isUTC?offset:getDateOffset(this);}}
function getSetZone(input,keepLocalTime){if(input!=null){if(typeof input!=='string'){input=-input;}
this.utcOffset(input,keepLocalTime);return this;}else{return-this.utcOffset();}}
function setOffsetToUTC(keepLocalTime){return this.utcOffset(0,keepLocalTime);}
function setOffsetToLocal(keepLocalTime){if(this._isUTC){this.utcOffset(0,keepLocalTime);this._isUTC=false;if(keepLocalTime){this.subtract(getDateOffset(this),'m');}}
return this;}
function setOffsetToParsedOffset(){if(this._tzm!=null){this.utcOffset(this._tzm,false,true);}else if(typeof this._i==='string'){var tZone=offsetFromString(matchOffset,this._i);if(tZone!=null){this.utcOffset(tZone);}
else{this.utcOffset(0,true);}}
return this;}
function hasAlignedHourOffset(input){if(!this.isValid()){return false;}
input=input?createLocal(input).utcOffset():0;return(this.utcOffset()-input)%60===0;}
function isDaylightSavingTime(){return(this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset());}
function isDaylightSavingTimeShifted(){if(!isUndefined(this._isDSTShifted)){return this._isDSTShifted;}
var c={};copyConfig(c,this);c=prepareConfig(c);if(c._a){var other=c._isUTC?createUTC(c._a):createLocal(c._a);this._isDSTShifted=this.isValid()&&compareArrays(c._a,other.toArray())>0;}else{this._isDSTShifted=false;}
return this._isDSTShifted;}
function isLocal(){return this.isValid()?!this._isUTC:false;}
function isUtcOffset(){return this.isValid()?this._isUTC:false;}
function isUtc(){return this.isValid()?this._isUTC&&this._offset===0:false;}
var aspNetRegex=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;var isoRegex=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function createDuration(input,key){var duration=input,match=null,sign,ret,diffRes;if(isDuration(input)){duration={ms:input._milliseconds,d:input._days,M:input._months};}else if(isNumber(input)){duration={};if(key){duration[key]=input;}else{duration.milliseconds=input;}}else if(!!(match=aspNetRegex.exec(input))){sign=(match[1]==='-')?-1:1;duration={y:0,d:toInt(match[DATE])*sign,h:toInt(match[HOUR])*sign,m:toInt(match[MINUTE])*sign,s:toInt(match[SECOND])*sign,ms:toInt(absRound(match[MILLISECOND]*1000))*sign};}else if(!!(match=isoRegex.exec(input))){sign=(match[1]==='-')?-1:1;duration={y:parseIso(match[2],sign),M:parseIso(match[3],sign),w:parseIso(match[4],sign),d:parseIso(match[5],sign),h:parseIso(match[6],sign),m:parseIso(match[7],sign),s:parseIso(match[8],sign)};}else if(duration==null){duration={};}else if(typeof duration==='object'&&('from'in duration||'to'in duration)){diffRes=momentsDifference(createLocal(duration.from),createLocal(duration.to));duration={};duration.ms=diffRes.milliseconds;duration.M=diffRes.months;}
ret=new Duration(duration);if(isDuration(input)&&hasOwnProp(input,'_locale')){ret._locale=input._locale;}
return ret;}
createDuration.fn=Duration.prototype;createDuration.invalid=createInvalid$1;function parseIso(inp,sign){var res=inp&&parseFloat(inp.replace(',','.'));return(isNaN(res)?0:res)*sign;}
function positiveMomentsDifference(base,other){var res={};res.months=other.month()-base.month()+
(other.year()-base.year())*12;if(base.clone().add(res.months,'M').isAfter(other)){--res.months;}
res.milliseconds=+other-+(base.clone().add(res.months,'M'));return res;}
function momentsDifference(base,other){var res;if(!(base.isValid()&&other.isValid())){return{milliseconds:0,months:0};}
other=cloneWithOffset(other,base);if(base.isBefore(other)){res=positiveMomentsDifference(base,other);}else{res=positiveMomentsDifference(other,base);res.milliseconds=-res.milliseconds;res.months=-res.months;}
return res;}
function createAdder(direction,name){return function(val,period){var dur,tmp;if(period!==null&&!isNaN(+period)){deprecateSimple(name,'moment().'+name+'(period, number) is deprecated. Please use moment().'+name+'(number, period). '+
'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');tmp=val;val=period;period=tmp;}
val=typeof val==='string'?+val:val;dur=createDuration(val,period);addSubtract(this,dur,direction);return this;};}
function addSubtract(mom,duration,isAdding,updateOffset){var milliseconds=duration._milliseconds,days=absRound(duration._days),months=absRound(duration._months);if(!mom.isValid()){return;}
updateOffset=updateOffset==null?true:updateOffset;if(months){setMonth(mom,get(mom,'Month')+months*isAdding);}
if(days){set$1(mom,'Date',get(mom,'Date')+days*isAdding);}
if(milliseconds){mom._d.setTime(mom._d.valueOf()+milliseconds*isAdding);}
if(updateOffset){hooks.updateOffset(mom,days||months);}}
var add=createAdder(1,'add');var subtract=createAdder(-1,'subtract');function getCalendarFormat(myMoment,now){var diff=myMoment.diff(now,'days',true);return diff<-6?'sameElse':diff<-1?'lastWeek':diff<0?'lastDay':diff<1?'sameDay':diff<2?'nextDay':diff<7?'nextWeek':'sameElse';}
function calendar$1(time,formats){var now=time||createLocal(),sod=cloneWithOffset(now,this).startOf('day'),format=hooks.calendarFormat(this,sod)||'sameElse';var output=formats&&(isFunction(formats[format])?formats[format].call(this,now):formats[format]);return this.format(output||this.localeData().calendar(format,this,createLocal(now)));}
function clone(){return new Moment(this);}
function isAfter(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(units)||'millisecond';if(units==='millisecond'){return this.valueOf()>localInput.valueOf();}else{return localInput.valueOf()<this.clone().startOf(units).valueOf();}}
function isBefore(input,units){var localInput=isMoment(input)?input:createLocal(input);if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(units)||'millisecond';if(units==='millisecond'){return this.valueOf()<localInput.valueOf();}else{return this.clone().endOf(units).valueOf()<localInput.valueOf();}}
function isBetween(from,to,units,inclusivity){var localFrom=isMoment(from)?from:createLocal(from),localTo=isMoment(to)?to:createLocal(to);if(!(this.isValid()&&localFrom.isValid()&&localTo.isValid())){return false;}
inclusivity=inclusivity||'()';return(inclusivity[0]==='('?this.isAfter(localFrom,units):!this.isBefore(localFrom,units))&&(inclusivity[1]===')'?this.isBefore(localTo,units):!this.isAfter(localTo,units));}
function isSame(input,units){var localInput=isMoment(input)?input:createLocal(input),inputMs;if(!(this.isValid()&&localInput.isValid())){return false;}
units=normalizeUnits(units)||'millisecond';if(units==='millisecond'){return this.valueOf()===localInput.valueOf();}else{inputMs=localInput.valueOf();return this.clone().startOf(units).valueOf()<=inputMs&&inputMs<=this.clone().endOf(units).valueOf();}}
function isSameOrAfter(input,units){return this.isSame(input,units)||this.isAfter(input,units);}
function isSameOrBefore(input,units){return this.isSame(input,units)||this.isBefore(input,units);}
function diff(input,units,asFloat){var that,zoneDelta,output;if(!this.isValid()){return NaN;}
that=cloneWithOffset(input,this);if(!that.isValid()){return NaN;}
zoneDelta=(that.utcOffset()-this.utcOffset())*6e4;units=normalizeUnits(units);switch(units){case 'year':output=monthDiff(this,that)/12;break;case 'month':output=monthDiff(this,that);break;case 'quarter':output=monthDiff(this,that)/3;break;case 'second':output=(this-that)/1e3;break;case 'minute':output=(this-that)/6e4;break;case 'hour':output=(this-that)/36e5;break;case 'day':output=(this-that-zoneDelta)/864e5;break;case 'week':output=(this-that-zoneDelta)/6048e5;break;default:output=this-that;}
return asFloat?output:absFloor(output);}
function monthDiff(a,b){var wholeMonthDiff=((b.year()-a.year())*12)+(b.month()-a.month()),anchor=a.clone().add(wholeMonthDiff,'months'),anchor2,adjust;if(b-anchor<0){anchor2=a.clone().add(wholeMonthDiff-1,'months');adjust=(b-anchor)/(anchor-anchor2);}else{anchor2=a.clone().add(wholeMonthDiff+1,'months');adjust=(b-anchor)/(anchor2-anchor);}
return-(wholeMonthDiff+adjust)||0;}
hooks.defaultFormat='YYYY-MM-DDTHH:mm:ssZ';hooks.defaultFormatUtc='YYYY-MM-DDTHH:mm:ss[Z]';function toString(){return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');}
function toISOString(keepOffset){if(!this.isValid()){return null;}
var utc=keepOffset!==true;var m=utc?this.clone().utc():this;if(m.year()<0||m.year()>9999){return formatMoment(m,utc?'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]':'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');}
if(isFunction(Date.prototype.toISOString)){if(utc){return this.toDate().toISOString();}else{return new Date(this.valueOf()+this.utcOffset()*60*1000).toISOString().replace('Z',formatMoment(m,'Z'));}}
return formatMoment(m,utc?'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]':'YYYY-MM-DD[T]HH:mm:ss.SSSZ');}
function inspect(){if(!this.isValid()){return 'moment.invalid(/* '+this._i+' */)';}
var func='moment';var zone='';if(!this.isLocal()){func=this.utcOffset()===0?'moment.utc':'moment.parseZone';zone='Z';}
var prefix='['+func+'("]';var year=(0<=this.year()&&this.year()<=9999)?'YYYY':'YYYYYY';var datetime='-MM-DD[T]HH:mm:ss.SSS';var suffix=zone+'[")]';return this.format(prefix+year+datetime+suffix);}
function format(inputString){if(!inputString){inputString=this.isUtc()?hooks.defaultFormatUtc:hooks.defaultFormat;}
var output=formatMoment(this,inputString);return this.localeData().postformat(output);}
function from(time,withoutSuffix){if(this.isValid()&&((isMoment(time)&&time.isValid())||createLocal(time).isValid())){return createDuration({to:this,from:time}).locale(this.locale()).humanize(!withoutSuffix);}else{return this.localeData().invalidDate();}}
function fromNow(withoutSuffix){return this.from(createLocal(),withoutSuffix);}
function to(time,withoutSuffix){if(this.isValid()&&((isMoment(time)&&time.isValid())||createLocal(time).isValid())){return createDuration({from:this,to:time}).locale(this.locale()).humanize(!withoutSuffix);}else{return this.localeData().invalidDate();}}
function toNow(withoutSuffix){return this.to(createLocal(),withoutSuffix);}
function locale(key){var newLocaleData;if(key===undefined){return this._locale._abbr;}else{newLocaleData=getLocale(key);if(newLocaleData!=null){this._locale=newLocaleData;}
return this;}}
var lang=deprecate('moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',function(key){if(key===undefined){return this.localeData();}else{return this.locale(key);}});function localeData(){return this._locale;}
var MS_PER_SECOND=1000;var MS_PER_MINUTE=60*MS_PER_SECOND;var MS_PER_HOUR=60*MS_PER_MINUTE;var MS_PER_400_YEARS=(365*400+97)*24*MS_PER_HOUR;function mod$1(dividend,divisor){return(dividend%divisor+divisor)%divisor;}
function localStartOfDate(y,m,d){if(y<100&&y>=0){return new Date(y+400,m,d)-MS_PER_400_YEARS;}else{return new Date(y,m,d).valueOf();}}
function utcStartOfDate(y,m,d){if(y<100&&y>=0){return Date.UTC(y+400,m,d)-MS_PER_400_YEARS;}else{return Date.UTC(y,m,d);}}
function startOf(units){var time;units=normalizeUnits(units);if(units===undefined||units==='millisecond'||!this.isValid()){return this;}
var startOfDate=this._isUTC?utcStartOfDate:localStartOfDate;switch(units){case 'year':time=startOfDate(this.year(),0,1);break;case 'quarter':time=startOfDate(this.year(),this.month()-this.month()%3,1);break;case 'month':time=startOfDate(this.year(),this.month(),1);break;case 'week':time=startOfDate(this.year(),this.month(),this.date()-this.weekday());break;case 'isoWeek':time=startOfDate(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case 'day':case 'date':time=startOfDate(this.year(),this.month(),this.date());break;case 'hour':time=this._d.valueOf();time-=mod$1(time+(this._isUTC?0:this.utcOffset()*MS_PER_MINUTE),MS_PER_HOUR);break;case 'minute':time=this._d.valueOf();time-=mod$1(time,MS_PER_MINUTE);break;case 'second':time=this._d.valueOf();time-=mod$1(time,MS_PER_SECOND);break;}
this._d.setTime(time);hooks.updateOffset(this,true);return this;}
function endOf(units){var time;units=normalizeUnits(units);if(units===undefined||units==='millisecond'||!this.isValid()){return this;}
var startOfDate=this._isUTC?utcStartOfDate:localStartOfDate;switch(units){case 'year':time=startOfDate(this.year()+1,0,1)-1;break;case 'quarter':time=startOfDate(this.year(),this.month()-this.month()%3+3,1)-1;break;case 'month':time=startOfDate(this.year(),this.month()+1,1)-1;break;case 'week':time=startOfDate(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case 'isoWeek':time=startOfDate(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case 'day':case 'date':time=startOfDate(this.year(),this.month(),this.date()+1)-1;break;case 'hour':time=this._d.valueOf();time+=MS_PER_HOUR-mod$1(time+(this._isUTC?0:this.utcOffset()*MS_PER_MINUTE),MS_PER_HOUR)-1;break;case 'minute':time=this._d.valueOf();time+=MS_PER_MINUTE-mod$1(time,MS_PER_MINUTE)-1;break;case 'second':time=this._d.valueOf();time+=MS_PER_SECOND-mod$1(time,MS_PER_SECOND)-1;break;}
this._d.setTime(time);hooks.updateOffset(this,true);return this;}
function valueOf(){return this._d.valueOf()-((this._offset||0)*60000);}
function unix(){return Math.floor(this.valueOf()/1000);}
function toDate(){return new Date(this.valueOf());}
function toArray(){var m=this;return[m.year(),m.month(),m.date(),m.hour(),m.minute(),m.second(),m.millisecond()];}
function toObject(){var m=this;return{years:m.year(),months:m.month(),date:m.date(),hours:m.hours(),minutes:m.minutes(),seconds:m.seconds(),milliseconds:m.milliseconds()};}
function toJSON(){return this.isValid()?this.toISOString():null;}
function isValid$2(){return isValid(this);}
function parsingFlags(){return extend({},getParsingFlags(this));}
function invalidAt(){return getParsingFlags(this).overflow;}
function creationData(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict};}
addFormatToken(0,['gg',2],0,function(){return this.weekYear()%100;});addFormatToken(0,['GG',2],0,function(){return this.isoWeekYear()%100;});function addWeekYearFormatToken(token,getter){addFormatToken(0,[token,token.length],0,getter);}
addWeekYearFormatToken('gggg','weekYear');addWeekYearFormatToken('ggggg','weekYear');addWeekYearFormatToken('GGGG','isoWeekYear');addWeekYearFormatToken('GGGGG','isoWeekYear');addUnitAlias('weekYear','gg');addUnitAlias('isoWeekYear','GG');addUnitPriority('weekYear',1);addUnitPriority('isoWeekYear',1);addRegexToken('G',matchSigned);addRegexToken('g',matchSigned);addRegexToken('GG',match1to2,match2);addRegexToken('gg',match1to2,match2);addRegexToken('GGGG',match1to4,match4);addRegexToken('gggg',match1to4,match4);addRegexToken('GGGGG',match1to6,match6);addRegexToken('ggggg',match1to6,match6);addWeekParseToken(['gggg','ggggg','GGGG','GGGGG'],function(input,week,config,token){week[token.substr(0,2)]=toInt(input);});addWeekParseToken(['gg','GG'],function(input,week,config,token){week[token]=hooks.parseTwoDigitYear(input);});function getSetWeekYear(input){return getSetWeekYearHelper.call(this,input,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy);}
function getSetISOWeekYear(input){return getSetWeekYearHelper.call(this,input,this.isoWeek(),this.isoWeekday(),1,4);}
function getISOWeeksInYear(){return weeksInYear(this.year(),1,4);}
function getWeeksInYear(){var weekInfo=this.localeData()._week;return weeksInYear(this.year(),weekInfo.dow,weekInfo.doy);}
function getSetWeekYearHelper(input,week,weekday,dow,doy){var weeksTarget;if(input==null){return weekOfYear(this,dow,doy).year;}else{weeksTarget=weeksInYear(input,dow,doy);if(week>weeksTarget){week=weeksTarget;}
return setWeekAll.call(this,input,week,weekday,dow,doy);}}
function setWeekAll(weekYear,week,weekday,dow,doy){var dayOfYearData=dayOfYearFromWeeks(weekYear,week,weekday,dow,doy),date=createUTCDate(dayOfYearData.year,0,dayOfYearData.dayOfYear);this.year(date.getUTCFullYear());this.month(date.getUTCMonth());this.date(date.getUTCDate());return this;}
addFormatToken('Q',0,'Qo','quarter');addUnitAlias('quarter','Q');addUnitPriority('quarter',7);addRegexToken('Q',match1);addParseToken('Q',function(input,array){array[MONTH]=(toInt(input)-1)*3;});function getSetQuarter(input){return input==null?Math.ceil((this.month()+1)/3):this.month((input-1)*3+this.month()%3);}
addFormatToken('D',['DD',2],'Do','date');addUnitAlias('date','D');addUnitPriority('date',9);addRegexToken('D',match1to2);addRegexToken('DD',match1to2,match2);addRegexToken('Do',function(isStrict,locale){return isStrict?(locale._dayOfMonthOrdinalParse||locale._ordinalParse):locale._dayOfMonthOrdinalParseLenient;});addParseToken(['D','DD'],DATE);addParseToken('Do',function(input,array){array[DATE]=toInt(input.match(match1to2)[0]);});var getSetDayOfMonth=makeGetSet('Date',true);addFormatToken('DDD',['DDDD',3],'DDDo','dayOfYear');addUnitAlias('dayOfYear','DDD');addUnitPriority('dayOfYear',4);addRegexToken('DDD',match1to3);addRegexToken('DDDD',match3);addParseToken(['DDD','DDDD'],function(input,array,config){config._dayOfYear=toInt(input);});function getSetDayOfYear(input){var dayOfYear=Math.round((this.clone().startOf('day')-this.clone().startOf('year'))/864e5)+1;return input==null?dayOfYear:this.add((input-dayOfYear),'d');}
addFormatToken('m',['mm',2],0,'minute');addUnitAlias('minute','m');addUnitPriority('minute',14);addRegexToken('m',match1to2);addRegexToken('mm',match1to2,match2);addParseToken(['m','mm'],MINUTE);var getSetMinute=makeGetSet('Minutes',false);addFormatToken('s',['ss',2],0,'second');addUnitAlias('second','s');addUnitPriority('second',15);addRegexToken('s',match1to2);addRegexToken('ss',match1to2,match2);addParseToken(['s','ss'],SECOND);var getSetSecond=makeGetSet('Seconds',false);addFormatToken('S',0,0,function(){return~~(this.millisecond()/100);});addFormatToken(0,['SS',2],0,function(){return~~(this.millisecond()/10);});addFormatToken(0,['SSS',3],0,'millisecond');addFormatToken(0,['SSSS',4],0,function(){return this.millisecond()*10;});addFormatToken(0,['SSSSS',5],0,function(){return this.millisecond()*100;});addFormatToken(0,['SSSSSS',6],0,function(){return this.millisecond()*1000;});addFormatToken(0,['SSSSSSS',7],0,function(){return this.millisecond()*10000;});addFormatToken(0,['SSSSSSSS',8],0,function(){return this.millisecond()*100000;});addFormatToken(0,['SSSSSSSSS',9],0,function(){return this.millisecond()*1000000;});addUnitAlias('millisecond','ms');addUnitPriority('millisecond',16);addRegexToken('S',match1to3,match1);addRegexToken('SS',match1to3,match2);addRegexToken('SSS',match1to3,match3);var token;for(token='SSSS';token.length<=9;token+='S'){addRegexToken(token,matchUnsigned);}
function parseMs(input,array){array[MILLISECOND]=toInt(('0.'+input)*1000);}
for(token='S';token.length<=9;token+='S'){addParseToken(token,parseMs);}
var getSetMillisecond=makeGetSet('Milliseconds',false);addFormatToken('z',0,0,'zoneAbbr');addFormatToken('zz',0,0,'zoneName');function getZoneAbbr(){return this._isUTC?'UTC':'';}
function getZoneName(){return this._isUTC?'Coordinated Universal Time':'';}
var proto=Moment.prototype;proto.add=add;proto.calendar=calendar$1;proto.clone=clone;proto.diff=diff;proto.endOf=endOf;proto.format=format;proto.from=from;proto.fromNow=fromNow;proto.to=to;proto.toNow=toNow;proto.get=stringGet;proto.invalidAt=invalidAt;proto.isAfter=isAfter;proto.isBefore=isBefore;proto.isBetween=isBetween;proto.isSame=isSame;proto.isSameOrAfter=isSameOrAfter;proto.isSameOrBefore=isSameOrBefore;proto.isValid=isValid$2;proto.lang=lang;proto.locale=locale;proto.localeData=localeData;proto.max=prototypeMax;proto.min=prototypeMin;proto.parsingFlags=parsingFlags;proto.set=stringSet;proto.startOf=startOf;proto.subtract=subtract;proto.toArray=toArray;proto.toObject=toObject;proto.toDate=toDate;proto.toISOString=toISOString;proto.inspect=inspect;proto.toJSON=toJSON;proto.toString=toString;proto.unix=unix;proto.valueOf=valueOf;proto.creationData=creationData;proto.year=getSetYear;proto.isLeapYear=getIsLeapYear;proto.weekYear=getSetWeekYear;proto.isoWeekYear=getSetISOWeekYear;proto.quarter=proto.quarters=getSetQuarter;proto.month=getSetMonth;proto.daysInMonth=getDaysInMonth;proto.week=proto.weeks=getSetWeek;proto.isoWeek=proto.isoWeeks=getSetISOWeek;proto.weeksInYear=getWeeksInYear;proto.isoWeeksInYear=getISOWeeksInYear;proto.date=getSetDayOfMonth;proto.day=proto.days=getSetDayOfWeek;proto.weekday=getSetLocaleDayOfWeek;proto.isoWeekday=getSetISODayOfWeek;proto.dayOfYear=getSetDayOfYear;proto.hour=proto.hours=getSetHour;proto.minute=proto.minutes=getSetMinute;proto.second=proto.seconds=getSetSecond;proto.millisecond=proto.milliseconds=getSetMillisecond;proto.utcOffset=getSetOffset;proto.utc=setOffsetToUTC;proto.local=setOffsetToLocal;proto.parseZone=setOffsetToParsedOffset;proto.hasAlignedHourOffset=hasAlignedHourOffset;proto.isDST=isDaylightSavingTime;proto.isLocal=isLocal;proto.isUtcOffset=isUtcOffset;proto.isUtc=isUtc;proto.isUTC=isUtc;proto.zoneAbbr=getZoneAbbr;proto.zoneName=getZoneName;proto.dates=deprecate('dates accessor is deprecated. Use date instead.',getSetDayOfMonth);proto.months=deprecate('months accessor is deprecated. Use month instead',getSetMonth);proto.years=deprecate('years accessor is deprecated. Use year instead',getSetYear);proto.zone=deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/',getSetZone);proto.isDSTShifted=deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information',isDaylightSavingTimeShifted);function createUnix(input){return createLocal(input*1000);}
function createInZone(){return createLocal.apply(null,arguments).parseZone();}
function preParsePostFormat(string){return string;}
var proto$1=Locale.prototype;proto$1.calendar=calendar;proto$1.longDateFormat=longDateFormat;proto$1.invalidDate=invalidDate;proto$1.ordinal=ordinal;proto$1.preparse=preParsePostFormat;proto$1.postformat=preParsePostFormat;proto$1.relativeTime=relativeTime;proto$1.pastFuture=pastFuture;proto$1.set=set;proto$1.months=localeMonths;proto$1.monthsShort=localeMonthsShort;proto$1.monthsParse=localeMonthsParse;proto$1.monthsRegex=monthsRegex;proto$1.monthsShortRegex=monthsShortRegex;proto$1.week=localeWeek;proto$1.firstDayOfYear=localeFirstDayOfYear;proto$1.firstDayOfWeek=localeFirstDayOfWeek;proto$1.weekdays=localeWeekdays;proto$1.weekdaysMin=localeWeekdaysMin;proto$1.weekdaysShort=localeWeekdaysShort;proto$1.weekdaysParse=localeWeekdaysParse;proto$1.weekdaysRegex=weekdaysRegex;proto$1.weekdaysShortRegex=weekdaysShortRegex;proto$1.weekdaysMinRegex=weekdaysMinRegex;proto$1.isPM=localeIsPM;proto$1.meridiem=localeMeridiem;function get$1(format,index,field,setter){var locale=getLocale();var utc=createUTC().set(setter,index);return locale[field](utc,format);}
function listMonthsImpl(format,index,field){if(isNumber(format)){index=format;format=undefined;}
format=format||'';if(index!=null){return get$1(format,index,field,'month');}
var i;var out=[];for(i=0;i<12;i++){out[i]=get$1(format,i,field,'month');}
return out;}
function listWeekdaysImpl(localeSorted,format,index,field){if(typeof localeSorted==='boolean'){if(isNumber(format)){index=format;format=undefined;}
format=format||'';}else{format=localeSorted;index=format;localeSorted=false;if(isNumber(format)){index=format;format=undefined;}
format=format||'';}
var locale=getLocale(),shift=localeSorted?locale._week.dow:0;if(index!=null){return get$1(format,(index+shift)%7,field,'day');}
var i;var out=[];for(i=0;i<7;i++){out[i]=get$1(format,(i+shift)%7,field,'day');}
return out;}
function listMonths(format,index){return listMonthsImpl(format,index,'months');}
function listMonthsShort(format,index){return listMonthsImpl(format,index,'monthsShort');}
function listWeekdays(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdays');}
function listWeekdaysShort(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdaysShort');}
function listWeekdaysMin(localeSorted,format,index){return listWeekdaysImpl(localeSorted,format,index,'weekdaysMin');}
getSetGlobalLocale('en',{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(number){var b=number%10,output=(toInt(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;}});hooks.lang=deprecate('moment.lang is deprecated. Use moment.locale instead.',getSetGlobalLocale);hooks.langData=deprecate('moment.langData is deprecated. Use moment.localeData instead.',getLocale);var mathAbs=Math.abs;function abs(){var data=this._data;this._milliseconds=mathAbs(this._milliseconds);this._days=mathAbs(this._days);this._months=mathAbs(this._months);data.milliseconds=mathAbs(data.milliseconds);data.seconds=mathAbs(data.seconds);data.minutes=mathAbs(data.minutes);data.hours=mathAbs(data.hours);data.months=mathAbs(data.months);data.years=mathAbs(data.years);return this;}
function addSubtract$1(duration,input,value,direction){var other=createDuration(input,value);duration._milliseconds+=direction*other._milliseconds;duration._days+=direction*other._days;duration._months+=direction*other._months;return duration._bubble();}
function add$1(input,value){return addSubtract$1(this,input,value,1);}
function subtract$1(input,value){return addSubtract$1(this,input,value,-1);}
function absCeil(number){if(number<0){return Math.floor(number);}else{return Math.ceil(number);}}
function bubble(){var milliseconds=this._milliseconds;var days=this._days;var months=this._months;var data=this._data;var seconds,minutes,hours,years,monthsFromDays;if(!((milliseconds>=0&&days>=0&&months>=0)||(milliseconds<=0&&days<=0&&months<=0))){milliseconds+=absCeil(monthsToDays(months)+days)*864e5;days=0;months=0;}
data.milliseconds=milliseconds%1000;seconds=absFloor(milliseconds/1000);data.seconds=seconds%60;minutes=absFloor(seconds/60);data.minutes=minutes%60;hours=absFloor(minutes/60);data.hours=hours%24;days+=absFloor(hours/24);monthsFromDays=absFloor(daysToMonths(days));months+=monthsFromDays;days-=absCeil(monthsToDays(monthsFromDays));years=absFloor(months/12);months%=12;data.days=days;data.months=months;data.years=years;return this;}
function daysToMonths(days){return days*4800/146097;}
function monthsToDays(months){return months*146097/4800;}
function as(units){if(!this.isValid()){return NaN;}
var days;var months;var milliseconds=this._milliseconds;units=normalizeUnits(units);if(units==='month'||units==='quarter'||units==='year'){days=this._days+milliseconds/864e5;months=this._months+daysToMonths(days);switch(units){case 'month':return months;case 'quarter':return months/3;case 'year':return months/12;}}else{days=this._days+Math.round(monthsToDays(this._months));switch(units){case 'week':return days/7+milliseconds/6048e5;case 'day':return days+milliseconds/864e5;case 'hour':return days*24+milliseconds/36e5;case 'minute':return days*1440+milliseconds/6e4;case 'second':return days*86400+milliseconds/1000;case 'millisecond':return Math.floor(days*864e5)+milliseconds;default:throw new Error('Unknown unit '+units);}}}
function valueOf$1(){if(!this.isValid()){return NaN;}
return(this._milliseconds+
this._days*864e5+
(this._months%12)*2592e6+
toInt(this._months/12)*31536e6);}
function makeAs(alias){return function(){return this.as(alias);};}
var asMilliseconds=makeAs('ms');var asSeconds=makeAs('s');var asMinutes=makeAs('m');var asHours=makeAs('h');var asDays=makeAs('d');var asWeeks=makeAs('w');var asMonths=makeAs('M');var asQuarters=makeAs('Q');var asYears=makeAs('y');function clone$1(){return createDuration(this);}
function get$2(units){units=normalizeUnits(units);return this.isValid()?this[units+'s']():NaN;}
function makeGetter(name){return function(){return this.isValid()?this._data[name]:NaN;};}
var milliseconds=makeGetter('milliseconds');var seconds=makeGetter('seconds');var minutes=makeGetter('minutes');var hours=makeGetter('hours');var days=makeGetter('days');var months=makeGetter('months');var years=makeGetter('years');function weeks(){return absFloor(this.days()/7);}
var round=Math.round;var thresholds={ss:44,s:45,m:45,h:22,d:26,M:11};function substituteTimeAgo(string,number,withoutSuffix,isFuture,locale){return locale.relativeTime(number||1,!!withoutSuffix,string,isFuture);}
function relativeTime$1(posNegDuration,withoutSuffix,locale){var duration=createDuration(posNegDuration).abs();var seconds=round(duration.as('s'));var minutes=round(duration.as('m'));var hours=round(duration.as('h'));var days=round(duration.as('d'));var months=round(duration.as('M'));var years=round(duration.as('y'));var a=seconds<=thresholds.ss&&['s',seconds]||seconds<thresholds.s&&['ss',seconds]||minutes<=1&&['m']||minutes<thresholds.m&&['mm',minutes]||hours<=1&&['h']||hours<thresholds.h&&['hh',hours]||days<=1&&['d']||days<thresholds.d&&['dd',days]||months<=1&&['M']||months<thresholds.M&&['MM',months]||years<=1&&['y']||['yy',years];a[2]=withoutSuffix;a[3]=+posNegDuration>0;a[4]=locale;return substituteTimeAgo.apply(null,a);}
function getSetRelativeTimeRounding(roundingFunction){if(roundingFunction===undefined){return round;}
if(typeof(roundingFunction)==='function'){round=roundingFunction;return true;}
return false;}
function getSetRelativeTimeThreshold(threshold,limit){if(thresholds[threshold]===undefined){return false;}
if(limit===undefined){return thresholds[threshold];}
thresholds[threshold]=limit;if(threshold==='s'){thresholds.ss=limit-1;}
return true;}
function humanize(withSuffix){if(!this.isValid()){return this.localeData().invalidDate();}
var locale=this.localeData();var output=relativeTime$1(this,!withSuffix,locale);if(withSuffix){output=locale.pastFuture(+this,output);}
return locale.postformat(output);}
var abs$1=Math.abs;function sign(x){return((x>0)-(x<0))||+x;}
function toISOString$1(){if(!this.isValid()){return this.localeData().invalidDate();}
var seconds=abs$1(this._milliseconds)/1000;var days=abs$1(this._days);var months=abs$1(this._months);var minutes,hours,years;minutes=absFloor(seconds/60);hours=absFloor(minutes/60);seconds%=60;minutes%=60;years=absFloor(months/12);months%=12;var Y=years;var M=months;var D=days;var h=hours;var m=minutes;var s=seconds?seconds.toFixed(3).replace(/\.?0+$/,''):'';var total=this.asSeconds();if(!total){return 'P0D';}
var totalSign=total<0?'-':'';var ymSign=sign(this._months)!==sign(total)?'-':'';var daysSign=sign(this._days)!==sign(total)?'-':'';var hmsSign=sign(this._milliseconds)!==sign(total)?'-':'';return totalSign+'P'+
(Y?ymSign+Y+'Y':'')+
(M?ymSign+M+'M':'')+
(D?daysSign+D+'D':'')+
((h||m||s)?'T':'')+
(h?hmsSign+h+'H':'')+
(m?hmsSign+m+'M':'')+
(s?hmsSign+s+'S':'');}
var proto$2=Duration.prototype;proto$2.isValid=isValid$1;proto$2.abs=abs;proto$2.add=add$1;proto$2.subtract=subtract$1;proto$2.as=as;proto$2.asMilliseconds=asMilliseconds;proto$2.asSeconds=asSeconds;proto$2.asMinutes=asMinutes;proto$2.asHours=asHours;proto$2.asDays=asDays;proto$2.asWeeks=asWeeks;proto$2.asMonths=asMonths;proto$2.asQuarters=asQuarters;proto$2.asYears=asYears;proto$2.valueOf=valueOf$1;proto$2._bubble=bubble;proto$2.clone=clone$1;proto$2.get=get$2;proto$2.milliseconds=milliseconds;proto$2.seconds=seconds;proto$2.minutes=minutes;proto$2.hours=hours;proto$2.days=days;proto$2.weeks=weeks;proto$2.months=months;proto$2.years=years;proto$2.humanize=humanize;proto$2.toISOString=toISOString$1;proto$2.toString=toISOString$1;proto$2.toJSON=toISOString$1;proto$2.locale=locale;proto$2.localeData=localeData;proto$2.toIsoString=deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)',toISOString$1);proto$2.lang=lang;addFormatToken('X',0,0,'unix');addFormatToken('x',0,0,'valueOf');addRegexToken('x',matchSigned);addRegexToken('X',matchTimestamp);addParseToken('X',function(input,array,config){config._d=new Date(parseFloat(input,10)*1000);});addParseToken('x',function(input,array,config){config._d=new Date(toInt(input));});hooks.version='2.24.0';setHookCallback(createLocal);hooks.fn=proto;hooks.min=min;hooks.max=max;hooks.now=now;hooks.utc=createUTC;hooks.unix=createUnix;hooks.months=listMonths;hooks.isDate=isDate;hooks.locale=getSetGlobalLocale;hooks.invalid=createInvalid;hooks.duration=createDuration;hooks.isMoment=isMoment;hooks.weekdays=listWeekdays;hooks.parseZone=createInZone;hooks.localeData=getLocale;hooks.isDuration=isDuration;hooks.monthsShort=listMonthsShort;hooks.weekdaysMin=listWeekdaysMin;hooks.defineLocale=defineLocale;hooks.updateLocale=updateLocale;hooks.locales=listLocales;hooks.weekdaysShort=listWeekdaysShort;hooks.normalizeUnits=normalizeUnits;hooks.relativeTimeRounding=getSetRelativeTimeRounding;hooks.relativeTimeThreshold=getSetRelativeTimeThreshold;hooks.calendarFormat=getCalendarFormat;hooks.prototype=proto;hooks.HTML5_FMT={DATETIME_LOCAL:'YYYY-MM-DDTHH:mm',DATETIME_LOCAL_SECONDS:'YYYY-MM-DDTHH:mm:ss',DATETIME_LOCAL_MS:'YYYY-MM-DDTHH:mm:ss.SSS',DATE:'YYYY-MM-DD',TIME:'HH:mm',TIME_SECONDS:'HH:mm:ss',TIME_MS:'HH:mm:ss.SSS',WEEK:'GGGG-[W]WW',MONTH:'YYYY-MM'};hooks.defineLocale('af',{months:'Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember'.split('_'),monthsShort:'Jan_Feb_Mrt_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des'.split('_'),weekdays:'Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag'.split('_'),weekdaysShort:'Son_Maa_Din_Woe_Don_Vry_Sat'.split('_'),weekdaysMin:'So_Ma_Di_Wo_Do_Vr_Sa'.split('_'),meridiemParse:/vm|nm/i,isPM:function(input){return /^nm$/i.test(input);},meridiem:function(hours,minutes,isLower){if(hours<12){return isLower?'vm':'VM';}else{return isLower?'nm':'NM';}},longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Vandag om] LT',nextDay:'[MÃ´re om] LT',nextWeek:'dddd [om] LT',lastDay:'[Gister om] LT',lastWeek:'[Laas] dddd [om] LT',sameElse:'L'},relativeTime:{future:'oor %s',past:'%s gelede',s:'\'n paar sekondes',ss:'%d sekondes',m:'\'n minuut',mm:'%d minute',h:'\'n uur',hh:'%d ure',d:'\'n dag',dd:'%d dae',M:'\'n maand',MM:'%d maande',y:'\'n jaar',yy:'%d jaar'},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(number){return number+((number===1||number===8||number>=20)?'ste':'de');},week:{dow:1,doy:4}});hooks.defineLocale('ar-dz',{months:'Ø¬Ø§Ù†ÙÙŠ_ÙÙŠÙØ±ÙŠ_Ù…Ø§Ø±Ø³_Ø£ÙØ±ÙŠÙ„_Ù…Ø§ÙŠ_Ø¬ÙˆØ§Ù†_Ø¬ÙˆÙŠÙ„ÙŠØ©_Ø£ÙˆØª_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),monthsShort:'Ø¬Ø§Ù†ÙÙŠ_ÙÙŠÙØ±ÙŠ_Ù…Ø§Ø±Ø³_Ø£ÙØ±ÙŠÙ„_Ù…Ø§ÙŠ_Ø¬ÙˆØ§Ù†_Ø¬ÙˆÙŠÙ„ÙŠØ©_Ø£ÙˆØª_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥Ø«Ù†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø§ØØ¯_Ø§Ø«Ù†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø£Ø_Ø¥Ø«_Ø«Ù„Ø§_Ø£Ø±_Ø®Ù…_Ø¬Ù…_Ø³Ø¨'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ø§ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'ÙÙŠ %s',past:'Ù…Ù†Ø° %s',s:'Ø«ÙˆØ§Ù†',ss:'%d Ø«Ø§Ù†ÙŠØ©',m:'Ø¯Ù‚ÙŠÙ‚Ø©',mm:'%d Ø¯Ù‚Ø§Ø¦Ù‚',h:'Ø³Ø§Ø¹Ø©',hh:'%d Ø³Ø§Ø¹Ø§Øª',d:'ÙŠÙˆÙ…',dd:'%d Ø£ÙŠØ§Ù…',M:'Ø´Ù‡Ø±',MM:'%d Ø£Ø´Ù‡Ø±',y:'Ø³Ù†Ø©',yy:'%d Ø³Ù†ÙˆØ§Øª'},week:{dow:0,doy:4}});hooks.defineLocale('ar-kw',{months:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆØ²_ØºØ´Øª_Ø´ØªÙ†Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙ†Ø¨Ø±_Ø¯Ø¬Ù†Ø¨Ø±'.split('_'),monthsShort:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆØ²_ØºØ´Øª_Ø´ØªÙ†Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙ†Ø¨Ø±_Ø¯Ø¬Ù†Ø¨Ø±'.split('_'),weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥ØªÙ†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø§ØØ¯_Ø§ØªÙ†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ø§ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'ÙÙŠ %s',past:'Ù…Ù†Ø° %s',s:'Ø«ÙˆØ§Ù†',ss:'%d Ø«Ø§Ù†ÙŠØ©',m:'Ø¯Ù‚ÙŠÙ‚Ø©',mm:'%d Ø¯Ù‚Ø§Ø¦Ù‚',h:'Ø³Ø§Ø¹Ø©',hh:'%d Ø³Ø§Ø¹Ø§Øª',d:'ÙŠÙˆÙ…',dd:'%d Ø£ÙŠØ§Ù…',M:'Ø´Ù‡Ø±',MM:'%d Ø£Ø´Ù‡Ø±',y:'Ø³Ù†Ø©',yy:'%d Ø³Ù†ÙˆØ§Øª'},week:{dow:0,doy:12}});var symbolMap={'1':'1','2':'2','3':'3','4':'4','5':'5','6':'6','7':'7','8':'8','9':'9','0':'0'},pluralForm=function(n){return n===0?0:n===1?1:n===2?2:n%100>=3&&n%100<=10?3:n%100>=11?4:5;},plurals={s:['Ø£Ù‚Ù„ Ù…Ù† Ø«Ø§Ù†ÙŠØ©','Ø«Ø§Ù†ÙŠØ© ÙˆØ§ØØ¯Ø©',['Ø«Ø§Ù†ÙŠØªØ§Ù†','Ø«Ø§Ù†ÙŠØªÙŠÙ†'],'%d Ø«ÙˆØ§Ù†','%d Ø«Ø§Ù†ÙŠØ©','%d Ø«Ø§Ù†ÙŠØ©'],m:['Ø£Ù‚Ù„ Ù…Ù† Ø¯Ù‚ÙŠÙ‚Ø©','Ø¯Ù‚ÙŠÙ‚Ø© ÙˆØ§ØØ¯Ø©',['Ø¯Ù‚ÙŠÙ‚ØªØ§Ù†','Ø¯Ù‚ÙŠÙ‚ØªÙŠÙ†'],'%d Ø¯Ù‚Ø§Ø¦Ù‚','%d Ø¯Ù‚ÙŠÙ‚Ø©','%d Ø¯Ù‚ÙŠÙ‚Ø©'],h:['Ø£Ù‚Ù„ Ù…Ù† Ø³Ø§Ø¹Ø©','Ø³Ø§Ø¹Ø© ÙˆØ§ØØ¯Ø©',['Ø³Ø§Ø¹ØªØ§Ù†','Ø³Ø§Ø¹ØªÙŠÙ†'],'%d Ø³Ø§Ø¹Ø§Øª','%d Ø³Ø§Ø¹Ø©','%d Ø³Ø§Ø¹Ø©'],d:['Ø£Ù‚Ù„ Ù…Ù† ÙŠÙˆÙ…','ÙŠÙˆÙ… ÙˆØ§ØØ¯',['ÙŠÙˆÙ…Ø§Ù†','ÙŠÙˆÙ…ÙŠÙ†'],'%d Ø£ÙŠØ§Ù…','%d ÙŠÙˆÙ…Ù‹Ø§','%d ÙŠÙˆÙ…'],M:['Ø£Ù‚Ù„ Ù…Ù† Ø´Ù‡Ø±','Ø´Ù‡Ø± ÙˆØ§ØØ¯',['Ø´Ù‡Ø±Ø§Ù†','Ø´Ù‡Ø±ÙŠÙ†'],'%d Ø£Ø´Ù‡Ø±','%d Ø´Ù‡Ø±Ø§','%d Ø´Ù‡Ø±'],y:['Ø£Ù‚Ù„ Ù…Ù† Ø¹Ø§Ù…','Ø¹Ø§Ù… ÙˆØ§ØØ¯',['Ø¹Ø§Ù…Ø§Ù†','Ø¹Ø§Ù…ÙŠÙ†'],'%d Ø£Ø¹ÙˆØ§Ù…','%d Ø¹Ø§Ù…Ù‹Ø§','%d Ø¹Ø§Ù…']},pluralize=function(u){return function(number,withoutSuffix,string,isFuture){var f=pluralForm(number),str=plurals[u][pluralForm(number)];if(f===2){str=str[withoutSuffix?0:1];}
return str.replace(/%d/i,number);};},months$1=['ÙŠÙ†Ø§ÙŠØ±','ÙØ¨Ø±Ø§ÙŠØ±','Ù…Ø§Ø±Ø³','Ø£Ø¨Ø±ÙŠÙ„','Ù…Ø§ÙŠÙˆ','ÙŠÙˆÙ†ÙŠÙˆ','ÙŠÙˆÙ„ÙŠÙˆ','Ø£ØºØ³Ø·Ø³','Ø³Ø¨ØªÙ…Ø¨Ø±','Ø£ÙƒØªÙˆØ¨Ø±','Ù†ÙˆÙÙ…Ø¨Ø±','Ø¯ÙŠØ³Ù…Ø¨Ø±'];hooks.defineLocale('ar-ly',{months:months$1,monthsShort:months$1,weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥Ø«Ù†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø£ØØ¯_Ø¥Ø«Ù†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'D/\u200FM/\u200FYYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},meridiemParse:/Øµ|Ù…/,isPM:function(input){return 'Ù…'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'Øµ';}else{return 'Ù…';}},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ù‹Ø§ Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'Ø¨Ø¹Ø¯ %s',past:'Ù…Ù†Ø° %s',s:pluralize('s'),ss:pluralize('s'),m:pluralize('m'),mm:pluralize('m'),h:pluralize('h'),hh:pluralize('h'),d:pluralize('d'),dd:pluralize('d'),M:pluralize('M'),MM:pluralize('M'),y:pluralize('y'),yy:pluralize('y')},preparse:function(string){return string.replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap[match];}).replace(/,/g,'ØŒ');},week:{dow:6,doy:12}});hooks.defineLocale('ar-ma',{months:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆØ²_ØºØ´Øª_Ø´ØªÙ†Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙ†Ø¨Ø±_Ø¯Ø¬Ù†Ø¨Ø±'.split('_'),monthsShort:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆØ²_ØºØ´Øª_Ø´ØªÙ†Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙ†Ø¨Ø±_Ø¯Ø¬Ù†Ø¨Ø±'.split('_'),weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥ØªÙ†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø§ØØ¯_Ø§ØªÙ†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ø§ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'ÙÙŠ %s',past:'Ù…Ù†Ø° %s',s:'Ø«ÙˆØ§Ù†',ss:'%d Ø«Ø§Ù†ÙŠØ©',m:'Ø¯Ù‚ÙŠÙ‚Ø©',mm:'%d Ø¯Ù‚Ø§Ø¦Ù‚',h:'Ø³Ø§Ø¹Ø©',hh:'%d Ø³Ø§Ø¹Ø§Øª',d:'ÙŠÙˆÙ…',dd:'%d Ø£ÙŠØ§Ù…',M:'Ø´Ù‡Ø±',MM:'%d Ø£Ø´Ù‡Ø±',y:'Ø³Ù†Ø©',yy:'%d Ø³Ù†ÙˆØ§Øª'},week:{dow:6,doy:12}});var symbolMap$1={'1':'Ù¡','2':'Ù¢','3':'Ù£','4':'Ù¤','5':'Ù¥','6':'Ù¦','7':'Ù§','8':'Ù¨','9':'Ù©','0':'Ù '},numberMap={'Ù¡':'1','Ù¢':'2','Ù£':'3','Ù¤':'4','Ù¥':'5','Ù¦':'6','Ù§':'7','Ù¨':'8','Ù©':'9','Ù ':'0'};hooks.defineLocale('ar-sa',{months:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠÙˆ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆ_Ø£ØºØ³Ø·Ø³_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),monthsShort:'ÙŠÙ†Ø§ÙŠØ±_ÙØ¨Ø±Ø§ÙŠØ±_Ù…Ø§Ø±Ø³_Ø£Ø¨Ø±ÙŠÙ„_Ù…Ø§ÙŠÙˆ_ÙŠÙˆÙ†ÙŠÙˆ_ÙŠÙˆÙ„ÙŠÙˆ_Ø£ØºØ³Ø·Ø³_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥Ø«Ù†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø£ØØ¯_Ø¥Ø«Ù†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},meridiemParse:/Øµ|Ù…/,isPM:function(input){return 'Ù…'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'Øµ';}else{return 'Ù…';}},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ø§ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'ÙÙŠ %s',past:'Ù…Ù†Ø° %s',s:'Ø«ÙˆØ§Ù†',ss:'%d Ø«Ø§Ù†ÙŠØ©',m:'Ø¯Ù‚ÙŠÙ‚Ø©',mm:'%d Ø¯Ù‚Ø§Ø¦Ù‚',h:'Ø³Ø§Ø¹Ø©',hh:'%d Ø³Ø§Ø¹Ø§Øª',d:'ÙŠÙˆÙ…',dd:'%d Ø£ÙŠØ§Ù…',M:'Ø´Ù‡Ø±',MM:'%d Ø£Ø´Ù‡Ø±',y:'Ø³Ù†Ø©',yy:'%d Ø³Ù†ÙˆØ§Øª'},preparse:function(string){return string.replace(/[Ù¡Ù¢Ù£Ù¤Ù¥Ù¦Ù§Ù¨Ù©Ù ]/g,function(match){return numberMap[match];}).replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$1[match];}).replace(/,/g,'ØŒ');},week:{dow:0,doy:6}});hooks.defineLocale('ar-tn',{months:'Ø¬Ø§Ù†ÙÙŠ_ÙÙŠÙØ±ÙŠ_Ù…Ø§Ø±Ø³_Ø£ÙØ±ÙŠÙ„_Ù…Ø§ÙŠ_Ø¬ÙˆØ§Ù†_Ø¬ÙˆÙŠÙ„ÙŠØ©_Ø£ÙˆØª_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),monthsShort:'Ø¬Ø§Ù†ÙÙŠ_ÙÙŠÙØ±ÙŠ_Ù…Ø§Ø±Ø³_Ø£ÙØ±ÙŠÙ„_Ù…Ø§ÙŠ_Ø¬ÙˆØ§Ù†_Ø¬ÙˆÙŠÙ„ÙŠØ©_Ø£ÙˆØª_Ø³Ø¨ØªÙ…Ø¨Ø±_Ø£ÙƒØªÙˆØ¨Ø±_Ù†ÙˆÙÙ…Ø¨Ø±_Ø¯ÙŠØ³Ù…Ø¨Ø±'.split('_'),weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥Ø«Ù†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø£ØØ¯_Ø¥Ø«Ù†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ø§ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù„Ù‰ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'ÙÙŠ %s',past:'Ù…Ù†Ø° %s',s:'Ø«ÙˆØ§Ù†',ss:'%d Ø«Ø§Ù†ÙŠØ©',m:'Ø¯Ù‚ÙŠÙ‚Ø©',mm:'%d Ø¯Ù‚Ø§Ø¦Ù‚',h:'Ø³Ø§Ø¹Ø©',hh:'%d Ø³Ø§Ø¹Ø§Øª',d:'ÙŠÙˆÙ…',dd:'%d Ø£ÙŠØ§Ù…',M:'Ø´Ù‡Ø±',MM:'%d Ø£Ø´Ù‡Ø±',y:'Ø³Ù†Ø©',yy:'%d Ø³Ù†ÙˆØ§Øª'},week:{dow:1,doy:4}});var symbolMap$2={'1':'Ù¡','2':'Ù¢','3':'Ù£','4':'Ù¤','5':'Ù¥','6':'Ù¦','7':'Ù§','8':'Ù¨','9':'Ù©','0':'Ù '},numberMap$1={'Ù¡':'1','Ù¢':'2','Ù£':'3','Ù¤':'4','Ù¥':'5','Ù¦':'6','Ù§':'7','Ù¨':'8','Ù©':'9','Ù ':'0'},pluralForm$1=function(n){return n===0?0:n===1?1:n===2?2:n%100>=3&&n%100<=10?3:n%100>=11?4:5;},plurals$1={s:['Ø£Ù‚Ù„ Ù…Ù† Ø«Ø§Ù†ÙŠØ©','Ø«Ø§Ù†ÙŠØ© ÙˆØ§ØØ¯Ø©',['Ø«Ø§Ù†ÙŠØªØ§Ù†','Ø«Ø§Ù†ÙŠØªÙŠÙ†'],'%d Ø«ÙˆØ§Ù†','%d Ø«Ø§Ù†ÙŠØ©','%d Ø«Ø§Ù†ÙŠØ©'],m:['Ø£Ù‚Ù„ Ù…Ù† Ø¯Ù‚ÙŠÙ‚Ø©','Ø¯Ù‚ÙŠÙ‚Ø© ÙˆØ§ØØ¯Ø©',['Ø¯Ù‚ÙŠÙ‚ØªØ§Ù†','Ø¯Ù‚ÙŠÙ‚ØªÙŠÙ†'],'%d Ø¯Ù‚Ø§Ø¦Ù‚','%d Ø¯Ù‚ÙŠÙ‚Ø©','%d Ø¯Ù‚ÙŠÙ‚Ø©'],h:['Ø£Ù‚Ù„ Ù…Ù† Ø³Ø§Ø¹Ø©','Ø³Ø§Ø¹Ø© ÙˆØ§ØØ¯Ø©',['Ø³Ø§Ø¹ØªØ§Ù†','Ø³Ø§Ø¹ØªÙŠÙ†'],'%d Ø³Ø§Ø¹Ø§Øª','%d Ø³Ø§Ø¹Ø©','%d Ø³Ø§Ø¹Ø©'],d:['Ø£Ù‚Ù„ Ù…Ù† ÙŠÙˆÙ…','ÙŠÙˆÙ… ÙˆØ§ØØ¯',['ÙŠÙˆÙ…Ø§Ù†','ÙŠÙˆÙ…ÙŠÙ†'],'%d Ø£ÙŠØ§Ù…','%d ÙŠÙˆÙ…Ù‹Ø§','%d ÙŠÙˆÙ…'],M:['Ø£Ù‚Ù„ Ù…Ù† Ø´Ù‡Ø±','Ø´Ù‡Ø± ÙˆØ§ØØ¯',['Ø´Ù‡Ø±Ø§Ù†','Ø´Ù‡Ø±ÙŠÙ†'],'%d Ø£Ø´Ù‡Ø±','%d Ø´Ù‡Ø±Ø§','%d Ø´Ù‡Ø±'],y:['Ø£Ù‚Ù„ Ù…Ù† Ø¹Ø§Ù…','Ø¹Ø§Ù… ÙˆØ§ØØ¯',['Ø¹Ø§Ù…Ø§Ù†','Ø¹Ø§Ù…ÙŠÙ†'],'%d Ø£Ø¹ÙˆØ§Ù…','%d Ø¹Ø§Ù…Ù‹Ø§','%d Ø¹Ø§Ù…']},pluralize$1=function(u){return function(number,withoutSuffix,string,isFuture){var f=pluralForm$1(number),str=plurals$1[u][pluralForm$1(number)];if(f===2){str=str[withoutSuffix?0:1];}
return str.replace(/%d/i,number);};},months$2=['ÙŠÙ†Ø§ÙŠØ±','ÙØ¨Ø±Ø§ÙŠØ±','Ù…Ø§Ø±Ø³','Ø£Ø¨Ø±ÙŠÙ„','Ù…Ø§ÙŠÙˆ','ÙŠÙˆÙ†ÙŠÙˆ','ÙŠÙˆÙ„ÙŠÙˆ','Ø£ØºØ³Ø·Ø³','Ø³Ø¨ØªÙ…Ø¨Ø±','Ø£ÙƒØªÙˆØ¨Ø±','Ù†ÙˆÙÙ…Ø¨Ø±','Ø¯ÙŠØ³Ù…Ø¨Ø±'];hooks.defineLocale('ar',{months:months$2,monthsShort:months$2,weekdays:'Ø§Ù„Ø£ØØ¯_Ø§Ù„Ø¥Ø«Ù†ÙŠÙ†_Ø§Ù„Ø«Ù„Ø§Ø«Ø§Ø¡_Ø§Ù„Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø§Ù„Ø®Ù…ÙŠØ³_Ø§Ù„Ø¬Ù…Ø¹Ø©_Ø§Ù„Ø³Ø¨Øª'.split('_'),weekdaysShort:'Ø£ØØ¯_Ø¥Ø«Ù†ÙŠÙ†_Ø«Ù„Ø§Ø«Ø§Ø¡_Ø£Ø±Ø¨Ø¹Ø§Ø¡_Ø®Ù…ÙŠØ³_Ø¬Ù…Ø¹Ø©_Ø³Ø¨Øª'.split('_'),weekdaysMin:'Ø_Ù†_Ø«_Ø±_Ø®_Ø¬_Ø³'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'D/\u200FM/\u200FYYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},meridiemParse:/Øµ|Ù…/,isPM:function(input){return 'Ù…'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'Øµ';}else{return 'Ù…';}},calendar:{sameDay:'[Ø§Ù„ÙŠÙˆÙ… Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextDay:'[ØºØ¯Ù‹Ø§ Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',nextWeek:'dddd [Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastDay:'[Ø£Ù…Ø³ Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',lastWeek:'dddd [Ø¹Ù†Ø¯ Ø§Ù„Ø³Ø§Ø¹Ø©] LT',sameElse:'L'},relativeTime:{future:'Ø¨Ø¹Ø¯ %s',past:'Ù…Ù†Ø° %s',s:pluralize$1('s'),ss:pluralize$1('s'),m:pluralize$1('m'),mm:pluralize$1('m'),h:pluralize$1('h'),hh:pluralize$1('h'),d:pluralize$1('d'),dd:pluralize$1('d'),M:pluralize$1('M'),MM:pluralize$1('M'),y:pluralize$1('y'),yy:pluralize$1('y')},preparse:function(string){return string.replace(/[Ù¡Ù¢Ù£Ù¤Ù¥Ù¦Ù§Ù¨Ù©Ù ]/g,function(match){return numberMap$1[match];}).replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$2[match];}).replace(/,/g,'ØŒ');},week:{dow:6,doy:12}});var suffixes={1:'-inci',5:'-inci',8:'-inci',70:'-inci',80:'-inci',2:'-nci',7:'-nci',20:'-nci',50:'-nci',3:'-Ã¼ncÃ¼',4:'-Ã¼ncÃ¼',100:'-Ã¼ncÃ¼',6:'-ncÄ±',9:'-uncu',10:'-uncu',30:'-uncu',60:'-Ä±ncÄ±',90:'-Ä±ncÄ±'};hooks.defineLocale('az',{months:'yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr'.split('_'),monthsShort:'yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek'.split('_'),weekdays:'Bazar_Bazar ertÉ™si_Ã‡É™rÅŸÉ™nbÉ™ axÅŸamÄ±_Ã‡É™rÅŸÉ™nbÉ™_CÃ¼mÉ™ axÅŸamÄ±_CÃ¼mÉ™_ÅžÉ™nbÉ™'.split('_'),weekdaysShort:'Baz_BzE_Ã‡Ax_Ã‡É™r_CAx_CÃ¼m_ÅžÉ™n'.split('_'),weekdaysMin:'Bz_BE_Ã‡A_Ã‡É™_CA_CÃ¼_ÅžÉ™'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[bugÃ¼n saat] LT',nextDay:'[sabah saat] LT',nextWeek:'[gÉ™lÉ™n hÉ™ftÉ™] dddd [saat] LT',lastDay:'[dÃ¼nÉ™n] LT',lastWeek:'[keÃ§É™n hÉ™ftÉ™] dddd [saat] LT',sameElse:'L'},relativeTime:{future:'%s sonra',past:'%s É™vvÉ™l',s:'birneÃ§É™ saniyÉ™',ss:'%d saniyÉ™',m:'bir dÉ™qiqÉ™',mm:'%d dÉ™qiqÉ™',h:'bir saat',hh:'%d saat',d:'bir gÃ¼n',dd:'%d gÃ¼n',M:'bir ay',MM:'%d ay',y:'bir il',yy:'%d il'},meridiemParse:/gecÉ™|sÉ™hÉ™r|gÃ¼ndÃ¼z|axÅŸam/,isPM:function(input){return /^(gÃ¼ndÃ¼z|axÅŸam)$/.test(input);},meridiem:function(hour,minute,isLower){if(hour<4){return 'gecÉ™';}else if(hour<12){return 'sÉ™hÉ™r';}else if(hour<17){return 'gÃ¼ndÃ¼z';}else{return 'axÅŸam';}},dayOfMonthOrdinalParse:/\d{1,2}-(Ä±ncÄ±|inci|nci|Ã¼ncÃ¼|ncÄ±|uncu)/,ordinal:function(number){if(number===0){return number+'-Ä±ncÄ±';}
var a=number%10,b=number%100-a,c=number>=100?100:null;return number+(suffixes[a]||suffixes[b]||suffixes[c]);},week:{dow:1,doy:7}});function plural(word,num){var forms=word.split('_');return num%10===1&&num%100!==11?forms[0]:(num%10>=2&&num%10<=4&&(num%100<10||num%100>=20)?forms[1]:forms[2]);}
function relativeTimeWithPlural(number,withoutSuffix,key){var format={'ss':withoutSuffix?'ÑÐµÐºÑƒÐ½Ð´Ð°_ÑÐµÐºÑƒÐ½Ð´Ñ‹_ÑÐµÐºÑƒÐ½Ð´':'ÑÐµÐºÑƒÐ½Ð´Ñƒ_ÑÐµÐºÑƒÐ½Ð´Ñ‹_ÑÐµÐºÑƒÐ½Ð´','mm':withoutSuffix?'Ñ…Ð²Ñ–Ð»Ñ–Ð½Ð°_Ñ…Ð²Ñ–Ð»Ñ–Ð½Ñ‹_Ñ…Ð²Ñ–Ð»Ñ–Ð½':'Ñ…Ð²Ñ–Ð»Ñ–Ð½Ñƒ_Ñ…Ð²Ñ–Ð»Ñ–Ð½Ñ‹_Ñ…Ð²Ñ–Ð»Ñ–Ð½','hh':withoutSuffix?'Ð³Ð°Ð´Ð·Ñ–Ð½Ð°_Ð³Ð°Ð´Ð·Ñ–Ð½Ñ‹_Ð³Ð°Ð´Ð·Ñ–Ð½':'Ð³Ð°Ð´Ð·Ñ–Ð½Ñƒ_Ð³Ð°Ð´Ð·Ñ–Ð½Ñ‹_Ð³Ð°Ð´Ð·Ñ–Ð½','dd':'Ð´Ð·ÐµÐ½ÑŒ_Ð´Ð½Ñ–_Ð´Ð·Ñ‘Ð½','MM':'Ð¼ÐµÑÑÑ†_Ð¼ÐµÑÑÑ†Ñ‹_Ð¼ÐµÑÑÑ†Ð°Ñž','yy':'Ð³Ð¾Ð´_Ð³Ð°Ð´Ñ‹_Ð³Ð°Ð´Ð¾Ñž'};if(key==='m'){return withoutSuffix?'Ñ…Ð²Ñ–Ð»Ñ–Ð½Ð°':'Ñ…Ð²Ñ–Ð»Ñ–Ð½Ñƒ';}
else if(key==='h'){return withoutSuffix?'Ð³Ð°Ð´Ð·Ñ–Ð½Ð°':'Ð³Ð°Ð´Ð·Ñ–Ð½Ñƒ';}
else{return number+' '+plural(format[key],+number);}}
hooks.defineLocale('be',{months:{format:'ÑÑ‚ÑƒÐ´Ð·ÐµÐ½Ñ_Ð»ÑŽÑ‚Ð°Ð³Ð°_ÑÐ°ÐºÐ°Ð²Ñ–ÐºÐ°_ÐºÑ€Ð°ÑÐ°Ð²Ñ–ÐºÐ°_Ñ‚Ñ€Ð°ÑžÐ½Ñ_Ñ‡ÑÑ€Ð²ÐµÐ½Ñ_Ð»Ñ–Ð¿ÐµÐ½Ñ_Ð¶Ð½Ñ–ÑžÐ½Ñ_Ð²ÐµÑ€Ð°ÑÐ½Ñ_ÐºÐ°ÑÑ‚Ñ€Ñ‹Ñ‡Ð½Ñ–ÐºÐ°_Ð»Ñ–ÑÑ‚Ð°Ð¿Ð°Ð´Ð°_ÑÐ½ÐµÐ¶Ð½Ñ'.split('_'),standalone:'ÑÑ‚ÑƒÐ´Ð·ÐµÐ½ÑŒ_Ð»ÑŽÑ‚Ñ‹_ÑÐ°ÐºÐ°Ð²Ñ–Ðº_ÐºÑ€Ð°ÑÐ°Ð²Ñ–Ðº_Ñ‚Ñ€Ð°Ð²ÐµÐ½ÑŒ_Ñ‡ÑÑ€Ð²ÐµÐ½ÑŒ_Ð»Ñ–Ð¿ÐµÐ½ÑŒ_Ð¶Ð½Ñ–Ð²ÐµÐ½ÑŒ_Ð²ÐµÑ€Ð°ÑÐµÐ½ÑŒ_ÐºÐ°ÑÑ‚Ñ€Ñ‹Ñ‡Ð½Ñ–Ðº_Ð»Ñ–ÑÑ‚Ð°Ð¿Ð°Ð´_ÑÐ½ÐµÐ¶Ð°Ð½ÑŒ'.split('_')},monthsShort:'ÑÑ‚ÑƒÐ´_Ð»ÑŽÑ‚_ÑÐ°Ðº_ÐºÑ€Ð°Ñ_Ñ‚Ñ€Ð°Ð²_Ñ‡ÑÑ€Ð²_Ð»Ñ–Ð¿_Ð¶Ð½Ñ–Ð²_Ð²ÐµÑ€_ÐºÐ°ÑÑ‚_Ð»Ñ–ÑÑ‚_ÑÐ½ÐµÐ¶'.split('_'),weekdays:{format:'Ð½ÑÐ´Ð·ÐµÐ»ÑŽ_Ð¿Ð°Ð½ÑÐ´Ð·ÐµÐ»Ð°Ðº_Ð°ÑžÑ‚Ð¾Ñ€Ð°Ðº_ÑÐµÑ€Ð°Ð´Ñƒ_Ñ‡Ð°Ñ†Ð²ÐµÑ€_Ð¿ÑÑ‚Ð½Ñ–Ñ†Ñƒ_ÑÑƒÐ±Ð¾Ñ‚Ñƒ'.split('_'),standalone:'Ð½ÑÐ´Ð·ÐµÐ»Ñ_Ð¿Ð°Ð½ÑÐ´Ð·ÐµÐ»Ð°Ðº_Ð°ÑžÑ‚Ð¾Ñ€Ð°Ðº_ÑÐµÑ€Ð°Ð´Ð°_Ñ‡Ð°Ñ†Ð²ÐµÑ€_Ð¿ÑÑ‚Ð½Ñ–Ñ†Ð°_ÑÑƒÐ±Ð¾Ñ‚Ð°'.split('_'),isFormat:/\[ ?[Ð£ÑƒÑž] ?(?:Ð¼Ñ–Ð½ÑƒÐ»ÑƒÑŽ|Ð½Ð°ÑÑ‚ÑƒÐ¿Ð½ÑƒÑŽ)? ?\] ?dddd/},weekdaysShort:'Ð½Ð´_Ð¿Ð½_Ð°Ñ‚_ÑÑ€_Ñ‡Ñ†_Ð¿Ñ‚_ÑÐ±'.split('_'),weekdaysMin:'Ð½Ð´_Ð¿Ð½_Ð°Ñ‚_ÑÑ€_Ñ‡Ñ†_Ð¿Ñ‚_ÑÐ±'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY Ð³.',LLL:'D MMMM YYYY Ð³., HH:mm',LLLL:'dddd, D MMMM YYYY Ð³., HH:mm'},calendar:{sameDay:'[Ð¡Ñ‘Ð½Ð½Ñ Ñž] LT',nextDay:'[Ð—Ð°ÑžÑ‚Ñ€Ð° Ñž] LT',lastDay:'[Ð£Ñ‡Ð¾Ñ€Ð° Ñž] LT',nextWeek:function(){return '[Ð£] dddd [Ñž] LT';},lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return '[Ð£ Ð¼Ñ–Ð½ÑƒÐ»ÑƒÑŽ] dddd [Ñž] LT';case 1:case 2:case 4:return '[Ð£ Ð¼Ñ–Ð½ÑƒÐ»Ñ‹] dddd [Ñž] LT';}},sameElse:'L'},relativeTime:{future:'Ð¿Ñ€Ð°Ð· %s',past:'%s Ñ‚Ð°Ð¼Ñƒ',s:'Ð½ÐµÐºÐ°Ð»ÑŒÐºÑ– ÑÐµÐºÑƒÐ½Ð´',m:relativeTimeWithPlural,mm:relativeTimeWithPlural,h:relativeTimeWithPlural,hh:relativeTimeWithPlural,d:'Ð´Ð·ÐµÐ½ÑŒ',dd:relativeTimeWithPlural,M:'Ð¼ÐµÑÑÑ†',MM:relativeTimeWithPlural,y:'Ð³Ð¾Ð´',yy:relativeTimeWithPlural},meridiemParse:/Ð½Ð¾Ñ‡Ñ‹|Ñ€Ð°Ð½Ñ–Ñ†Ñ‹|Ð´Ð½Ñ|Ð²ÐµÑ‡Ð°Ñ€Ð°/,isPM:function(input){return /^(Ð´Ð½Ñ|Ð²ÐµÑ‡Ð°Ñ€Ð°)$/.test(input);},meridiem:function(hour,minute,isLower){if(hour<4){return 'Ð½Ð¾Ñ‡Ñ‹';}else if(hour<12){return 'Ñ€Ð°Ð½Ñ–Ñ†Ñ‹';}else if(hour<17){return 'Ð´Ð½Ñ';}else{return 'Ð²ÐµÑ‡Ð°Ñ€Ð°';}},dayOfMonthOrdinalParse:/\d{1,2}-(Ñ–|Ñ‹|Ð³Ð°)/,ordinal:function(number,period){switch(period){case 'M':case 'd':case 'DDD':case 'w':case 'W':return(number%10===2||number%10===3)&&(number%100!==12&&number%100!==13)?number+'-Ñ–':number+'-Ñ‹';case 'D':return number+'-Ð³Ð°';default:return number;}},week:{dow:1,doy:7}});hooks.defineLocale('bg',{months:'ÑÐ½ÑƒÐ°Ñ€Ð¸_Ñ„ÐµÐ²Ñ€ÑƒÐ°Ñ€Ð¸_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€Ð¸Ð»_Ð¼Ð°Ð¹_ÑŽÐ½Ð¸_ÑŽÐ»Ð¸_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ¿Ñ‚ÐµÐ¼Ð²Ñ€Ð¸_Ð¾ÐºÑ‚Ð¾Ð¼Ð²Ñ€Ð¸_Ð½Ð¾ÐµÐ¼Ð²Ñ€Ð¸_Ð´ÐµÐºÐµÐ¼Ð²Ñ€Ð¸'.split('_'),monthsShort:'ÑÐ½Ñ€_Ñ„ÐµÐ²_Ð¼Ð°Ñ€_Ð°Ð¿Ñ€_Ð¼Ð°Ð¹_ÑŽÐ½Ð¸_ÑŽÐ»Ð¸_Ð°Ð²Ð³_ÑÐµÐ¿_Ð¾ÐºÑ‚_Ð½Ð¾Ðµ_Ð´ÐµÐº'.split('_'),weekdays:'Ð½ÐµÐ´ÐµÐ»Ñ_Ð¿Ð¾Ð½ÐµÐ´ÐµÐ»Ð½Ð¸Ðº_Ð²Ñ‚Ð¾Ñ€Ð½Ð¸Ðº_ÑÑ€ÑÐ´Ð°_Ñ‡ÐµÑ‚Ð²ÑŠÑ€Ñ‚ÑŠÐº_Ð¿ÐµÑ‚ÑŠÐº_ÑÑŠÐ±Ð¾Ñ‚Ð°'.split('_'),weekdaysShort:'Ð½ÐµÐ´_Ð¿Ð¾Ð½_Ð²Ñ‚Ð¾_ÑÑ€Ñ_Ñ‡ÐµÑ‚_Ð¿ÐµÑ‚_ÑÑŠÐ±'.split('_'),weekdaysMin:'Ð½Ð´_Ð¿Ð½_Ð²Ñ‚_ÑÑ€_Ñ‡Ñ‚_Ð¿Ñ‚_ÑÐ±'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'D.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY H:mm',LLLL:'dddd, D MMMM YYYY H:mm'},calendar:{sameDay:'[Ð”Ð½ÐµÑ Ð²] LT',nextDay:'[Ð£Ñ‚Ñ€Ðµ Ð²] LT',nextWeek:'dddd [Ð²] LT',lastDay:'[Ð’Ñ‡ÐµÑ€Ð° Ð²] LT',lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return '[Ð’ Ð¸Ð·Ð¼Ð¸Ð½Ð°Ð»Ð°Ñ‚Ð°] dddd [Ð²] LT';case 1:case 2:case 4:case 5:return '[Ð’ Ð¸Ð·Ð¼Ð¸Ð½Ð°Ð»Ð¸Ñ] dddd [Ð²] LT';}},sameElse:'L'},relativeTime:{future:'ÑÐ»ÐµÐ´ %s',past:'Ð¿Ñ€ÐµÐ´Ð¸ %s',s:'Ð½ÑÐºÐ¾Ð»ÐºÐ¾ ÑÐµÐºÑƒÐ½Ð´Ð¸',ss:'%d ÑÐµÐºÑƒÐ½Ð´Ð¸',m:'Ð¼Ð¸Ð½ÑƒÑ‚Ð°',mm:'%d Ð¼Ð¸Ð½ÑƒÑ‚Ð¸',h:'Ñ‡Ð°Ñ',hh:'%d Ñ‡Ð°ÑÐ°',d:'Ð´ÐµÐ½',dd:'%d Ð´Ð½Ð¸',M:'Ð¼ÐµÑÐµÑ†',MM:'%d Ð¼ÐµÑÐµÑ†Ð°',y:'Ð³Ð¾Ð´Ð¸Ð½Ð°',yy:'%d Ð³Ð¾Ð´Ð¸Ð½Ð¸'},dayOfMonthOrdinalParse:/\d{1,2}-(ÐµÐ²|ÐµÐ½|Ñ‚Ð¸|Ð²Ð¸|Ñ€Ð¸|Ð¼Ð¸)/,ordinal:function(number){var lastDigit=number%10,last2Digits=number%100;if(number===0){return number+'-ÐµÐ²';}else if(last2Digits===0){return number+'-ÐµÐ½';}else if(last2Digits>10&&last2Digits<20){return number+'-Ñ‚Ð¸';}else if(lastDigit===1){return number+'-Ð²Ð¸';}else if(lastDigit===2){return number+'-Ñ€Ð¸';}else if(lastDigit===7||lastDigit===8){return number+'-Ð¼Ð¸';}else{return number+'-Ñ‚Ð¸';}},week:{dow:1,doy:7}});hooks.defineLocale('bm',{months:'Zanwuyekalo_Fewuruyekalo_Marisikalo_Awirilikalo_MÉ›kalo_ZuwÉ›nkalo_Zuluyekalo_Utikalo_SÉ›tanburukalo_É”kutÉ”burukalo_Nowanburukalo_Desanburukalo'.split('_'),monthsShort:'Zan_Few_Mar_Awi_MÉ›_Zuw_Zul_Uti_SÉ›t_É”ku_Now_Des'.split('_'),weekdays:'Kari_NtÉ›nÉ›n_Tarata_Araba_Alamisa_Juma_Sibiri'.split('_'),weekdaysShort:'Kar_NtÉ›_Tar_Ara_Ala_Jum_Sib'.split('_'),weekdaysMin:'Ka_Nt_Ta_Ar_Al_Ju_Si'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'MMMM [tile] D [san] YYYY',LLL:'MMMM [tile] D [san] YYYY [lÉ›rÉ›] HH:mm',LLLL:'dddd MMMM [tile] D [san] YYYY [lÉ›rÉ›] HH:mm'},calendar:{sameDay:'[Bi lÉ›rÉ›] LT',nextDay:'[Sini lÉ›rÉ›] LT',nextWeek:'dddd [don lÉ›rÉ›] LT',lastDay:'[Kunu lÉ›rÉ›] LT',lastWeek:'dddd [tÉ›mÉ›nen lÉ›rÉ›] LT',sameElse:'L'},relativeTime:{future:'%s kÉ”nÉ”',past:'a bÉ› %s bÉ”',s:'sanga dama dama',ss:'sekondi %d',m:'miniti kelen',mm:'miniti %d',h:'lÉ›rÉ› kelen',hh:'lÉ›rÉ› %d',d:'tile kelen',dd:'tile %d',M:'kalo kelen',MM:'kalo %d',y:'san kelen',yy:'san %d'},week:{dow:1,doy:4}});var symbolMap$3={'1':'à§§','2':'à§¨','3':'à§©','4':'à§ª','5':'à§«','6':'à§¬','7':'à§','8':'à§®','9':'à§¯','0':'à§¦'},numberMap$2={'à§§':'1','à§¨':'2','à§©':'3','à§ª':'4','à§«':'5','à§¬':'6','à§':'7','à§®':'8','à§¯':'9','à§¦':'0'};hooks.defineLocale('bn',{months:'à¦œà¦¾à¦¨à§à¦¯à¦¼à¦¾à¦°à§€_à¦«à§‡à¦¬à§à¦°à§à¦¯à¦¼à¦¾à¦°à¦¿_à¦®à¦¾à¦°à§à¦š_à¦à¦ªà§à¦°à¦¿à¦²_à¦®à§‡_à¦œà§à¦¨_à¦œà§à¦²à¦¾à¦‡_à¦†à¦—à¦¸à§à¦Ÿ_à¦¸à§‡à¦ªà§à¦Ÿà§‡à¦®à§à¦¬à¦°_à¦…à¦•à§à¦Ÿà§‹à¦¬à¦°_à¦¨à¦à§‡à¦®à§à¦¬à¦°_à¦¡à¦¿à¦¸à§‡à¦®à§à¦¬à¦°'.split('_'),monthsShort:'à¦œà¦¾à¦¨à§_à¦«à§‡à¦¬_à¦®à¦¾à¦°à§à¦š_à¦à¦ªà§à¦°_à¦®à§‡_à¦œà§à¦¨_à¦œà§à¦²_à¦†à¦—_à¦¸à§‡à¦ªà§à¦Ÿ_à¦…à¦•à§à¦Ÿà§‹_à¦¨à¦à§‡_à¦¡à¦¿à¦¸à§‡'.split('_'),weekdays:'à¦°à¦¬à¦¿à¦¬à¦¾à¦°_à¦¸à§‹à¦®à¦¬à¦¾à¦°_à¦®à¦™à§à¦—à¦²à¦¬à¦¾à¦°_à¦¬à§à¦§à¦¬à¦¾à¦°_à¦¬à§ƒà¦¹à¦¸à§à¦ªà¦¤à¦¿à¦¬à¦¾à¦°_à¦¶à§à¦•à§à¦°à¦¬à¦¾à¦°_à¦¶à¦¨à¦¿à¦¬à¦¾à¦°'.split('_'),weekdaysShort:'à¦°à¦¬à¦¿_à¦¸à§‹à¦®_à¦®à¦™à§à¦—à¦²_à¦¬à§à¦§_à¦¬à§ƒà¦¹à¦¸à§à¦ªà¦¤à¦¿_à¦¶à§à¦•à§à¦°_à¦¶à¦¨à¦¿'.split('_'),weekdaysMin:'à¦°à¦¬à¦¿_à¦¸à§‹à¦®_à¦®à¦™à§à¦—_à¦¬à§à¦§_à¦¬à§ƒà¦¹à¦ƒ_à¦¶à§à¦•à§à¦°_à¦¶à¦¨à¦¿'.split('_'),longDateFormat:{LT:'A h:mm à¦¸à¦®à¦¯à¦¼',LTS:'A h:mm:ss à¦¸à¦®à¦¯à¦¼',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm à¦¸à¦®à¦¯à¦¼',LLLL:'dddd, D MMMM YYYY, A h:mm à¦¸à¦®à¦¯à¦¼'},calendar:{sameDay:'[à¦†à¦œ] LT',nextDay:'[à¦†à¦—à¦¾à¦®à§€à¦•à¦¾à¦²] LT',nextWeek:'dddd, LT',lastDay:'[à¦—à¦¤à¦•à¦¾à¦²] LT',lastWeek:'[à¦—à¦¤] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à¦ªà¦°à§‡',past:'%s à¦†à¦—à§‡',s:'à¦•à¦¯à¦¼à§‡à¦• à¦¸à§‡à¦•à§‡à¦¨à§à¦¡',ss:'%d à¦¸à§‡à¦•à§‡à¦¨à§à¦¡',m:'à¦à¦• à¦®à¦¿à¦¨à¦¿à¦Ÿ',mm:'%d à¦®à¦¿à¦¨à¦¿à¦Ÿ',h:'à¦à¦• à¦˜à¦¨à§à¦Ÿà¦¾',hh:'%d à¦˜à¦¨à§à¦Ÿà¦¾',d:'à¦à¦• à¦¦à¦¿à¦¨',dd:'%d à¦¦à¦¿à¦¨',M:'à¦à¦• à¦®à¦¾à¦¸',MM:'%d à¦®à¦¾à¦¸',y:'à¦à¦• à¦¬à¦›à¦°',yy:'%d à¦¬à¦›à¦°'},preparse:function(string){return string.replace(/[à§§à§¨à§©à§ªà§«à§¬à§à§®à§¯à§¦]/g,function(match){return numberMap$2[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$3[match];});},meridiemParse:/à¦°à¦¾à¦¤|à¦¸à¦•à¦¾à¦²|à¦¦à§à¦ªà§à¦°|à¦¬à¦¿à¦•à¦¾à¦²|à¦°à¦¾à¦¤/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if((meridiem==='à¦°à¦¾à¦¤'&&hour>=4)||(meridiem==='à¦¦à§à¦ªà§à¦°'&&hour<5)||meridiem==='à¦¬à¦¿à¦•à¦¾à¦²'){return hour+12;}else{return hour;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à¦°à¦¾à¦¤';}else if(hour<10){return 'à¦¸à¦•à¦¾à¦²';}else if(hour<17){return 'à¦¦à§à¦ªà§à¦°';}else if(hour<20){return 'à¦¬à¦¿à¦•à¦¾à¦²';}else{return 'à¦°à¦¾à¦¤';}},week:{dow:0,doy:6}});var symbolMap$4={'1':'à¼¡','2':'à¼¢','3':'à¼£','4':'à¼¤','5':'à¼¥','6':'à¼¦','7':'à¼§','8':'à¼¨','9':'à¼©','0':'à¼ '},numberMap$3={'à¼¡':'1','à¼¢':'2','à¼£':'3','à¼¤':'4','à¼¥':'5','à¼¦':'6','à¼§':'7','à¼¨':'8','à¼©':'9','à¼ ':'0'};hooks.defineLocale('bo',{months:'à½Ÿà¾³à¼‹à½–à¼‹à½‘à½„à¼‹à½”à½¼_à½Ÿà¾³à¼‹à½–à¼‹à½‚à½‰à½²à½¦à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‚à½¦à½´à½˜à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½žà½²à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½£à¾”à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‘à¾²à½´à½‚à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½‘à½´à½“à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½¢à¾’à¾±à½‘à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‘à½‚à½´à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½‚à½…à½²à½‚à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½‚à½‰à½²à½¦à¼‹à½”'.split('_'),monthsShort:'à½Ÿà¾³à¼‹à½–à¼‹à½‘à½„à¼‹à½”à½¼_à½Ÿà¾³à¼‹à½–à¼‹à½‚à½‰à½²à½¦à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‚à½¦à½´à½˜à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½žà½²à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½£à¾”à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‘à¾²à½´à½‚à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½‘à½´à½“à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½¢à¾’à¾±à½‘à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½‘à½‚à½´à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½‚à½…à½²à½‚à¼‹à½”_à½Ÿà¾³à¼‹à½–à¼‹à½–à½…à½´à¼‹à½‚à½‰à½²à½¦à¼‹à½”'.split('_'),weekdays:'à½‚à½Ÿà½ à¼‹à½‰à½²à¼‹à½˜à¼‹_à½‚à½Ÿà½ à¼‹à½Ÿà¾³à¼‹à½–à¼‹_à½‚à½Ÿà½ à¼‹à½˜à½²à½‚à¼‹à½‘à½˜à½¢à¼‹_à½‚à½Ÿà½ à¼‹à½£à¾·à½‚à¼‹à½”à¼‹_à½‚à½Ÿà½ à¼‹à½•à½´à½¢à¼‹à½–à½´_à½‚à½Ÿà½ à¼‹à½”à¼‹à½¦à½„à½¦à¼‹_à½‚à½Ÿà½ à¼‹à½¦à¾¤à½ºà½“à¼‹à½”à¼‹'.split('_'),weekdaysShort:'à½‰à½²à¼‹à½˜à¼‹_à½Ÿà¾³à¼‹à½–à¼‹_à½˜à½²à½‚à¼‹à½‘à½˜à½¢à¼‹_à½£à¾·à½‚à¼‹à½”à¼‹_à½•à½´à½¢à¼‹à½–à½´_à½”à¼‹à½¦à½„à½¦à¼‹_à½¦à¾¤à½ºà½“à¼‹à½”à¼‹'.split('_'),weekdaysMin:'à½‰à½²à¼‹à½˜à¼‹_à½Ÿà¾³à¼‹à½–à¼‹_à½˜à½²à½‚à¼‹à½‘à½˜à½¢à¼‹_à½£à¾·à½‚à¼‹à½”à¼‹_à½•à½´à½¢à¼‹à½–à½´_à½”à¼‹à½¦à½„à½¦à¼‹_à½¦à¾¤à½ºà½“à¼‹à½”à¼‹'.split('_'),longDateFormat:{LT:'A h:mm',LTS:'A h:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm',LLLL:'dddd, D MMMM YYYY, A h:mm'},calendar:{sameDay:'[à½‘à½²à¼‹à½¢à½²à½„] LT',nextDay:'[à½¦à½„à¼‹à½‰à½²à½“] LT',nextWeek:'[à½–à½‘à½´à½“à¼‹à½•à¾²à½‚à¼‹à½¢à¾—à½ºà½¦à¼‹à½˜], LT',lastDay:'[à½à¼‹à½¦à½„] LT',lastWeek:'[à½–à½‘à½´à½“à¼‹à½•à¾²à½‚à¼‹à½˜à½à½ à¼‹à½˜] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à½£à¼‹',past:'%s à½¦à¾”à½“à¼‹à½£',s:'à½£à½˜à¼‹à½¦à½„',ss:'%d à½¦à¾à½¢à¼‹à½†à¼',m:'à½¦à¾à½¢à¼‹à½˜à¼‹à½‚à½…à½²à½‚',mm:'%d à½¦à¾à½¢à¼‹à½˜',h:'à½†à½´à¼‹à½šà½¼à½‘à¼‹à½‚à½…à½²à½‚',hh:'%d à½†à½´à¼‹à½šà½¼à½‘',d:'à½‰à½²à½“à¼‹à½‚à½…à½²à½‚',dd:'%d à½‰à½²à½“à¼‹',M:'à½Ÿà¾³à¼‹à½–à¼‹à½‚à½…à½²à½‚',MM:'%d à½Ÿà¾³à¼‹à½–',y:'à½£à½¼à¼‹à½‚à½…à½²à½‚',yy:'%d à½£à½¼'},preparse:function(string){return string.replace(/[à¼¡à¼¢à¼£à¼¤à¼¥à¼¦à¼§à¼¨à¼©à¼ ]/g,function(match){return numberMap$3[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$4[match];});},meridiemParse:/à½˜à½šà½“à¼‹à½˜à½¼|à½žà½¼à½‚à½¦à¼‹à½€à½¦|à½‰à½²à½“à¼‹à½‚à½´à½„|à½‘à½‚à½¼à½„à¼‹à½‘à½‚|à½˜à½šà½“à¼‹à½˜à½¼/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if((meridiem==='à½˜à½šà½“à¼‹à½˜à½¼'&&hour>=4)||(meridiem==='à½‰à½²à½“à¼‹à½‚à½´à½„'&&hour<5)||meridiem==='à½‘à½‚à½¼à½„à¼‹à½‘à½‚'){return hour+12;}else{return hour;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à½˜à½šà½“à¼‹à½˜à½¼';}else if(hour<10){return 'à½žà½¼à½‚à½¦à¼‹à½€à½¦';}else if(hour<17){return 'à½‰à½²à½“à¼‹à½‚à½´à½„';}else if(hour<20){return 'à½‘à½‚à½¼à½„à¼‹à½‘à½‚';}else{return 'à½˜à½šà½“à¼‹à½˜à½¼';}},week:{dow:0,doy:6}});function relativeTimeWithMutation(number,withoutSuffix,key){var format={'mm':'munutenn','MM':'miz','dd':'devezh'};return number+' '+mutation(format[key],number);}
function specialMutationForYears(number){switch(lastNumber(number)){case 1:case 3:case 4:case 5:case 9:return number+' bloaz';default:return number+' vloaz';}}
function lastNumber(number){if(number>9){return lastNumber(number%10);}
return number;}
function mutation(text,number){if(number===2){return softMutation(text);}
return text;}
function softMutation(text){var mutationTable={'m':'v','b':'v','d':'z'};if(mutationTable[text.charAt(0)]===undefined){return text;}
return mutationTable[text.charAt(0)]+text.substring(1);}
hooks.defineLocale('br',{months:'Genver_C\'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu'.split('_'),monthsShort:'Gen_C\'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker'.split('_'),weekdays:'Sul_Lun_Meurzh_Merc\'her_Yaou_Gwener_Sadorn'.split('_'),weekdaysShort:'Sul_Lun_Meu_Mer_Yao_Gwe_Sad'.split('_'),weekdaysMin:'Su_Lu_Me_Mer_Ya_Gw_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'h[e]mm A',LTS:'h[e]mm:ss A',L:'DD/MM/YYYY',LL:'D [a viz] MMMM YYYY',LLL:'D [a viz] MMMM YYYY h[e]mm A',LLLL:'dddd, D [a viz] MMMM YYYY h[e]mm A'},calendar:{sameDay:'[Hiziv da] LT',nextDay:'[Warc\'hoazh da] LT',nextWeek:'dddd [da] LT',lastDay:'[Dec\'h da] LT',lastWeek:'dddd [paset da] LT',sameElse:'L'},relativeTime:{future:'a-benn %s',past:'%s \'zo',s:'un nebeud segondennoÃ¹',ss:'%d eilenn',m:'ur vunutenn',mm:relativeTimeWithMutation,h:'un eur',hh:'%d eur',d:'un devezh',dd:relativeTimeWithMutation,M:'ur miz',MM:relativeTimeWithMutation,y:'ur bloaz',yy:specialMutationForYears},dayOfMonthOrdinalParse:/\d{1,2}(aÃ±|vet)/,ordinal:function(number){var output=(number===1)?'aÃ±':'vet';return number+output;},week:{dow:1,doy:4}});function translate(number,withoutSuffix,key){var result=number+' ';switch(key){case 'ss':if(number===1){result+='sekunda';}else if(number===2||number===3||number===4){result+='sekunde';}else{result+='sekundi';}
return result;case 'm':return withoutSuffix?'jedna minuta':'jedne minute';case 'mm':if(number===1){result+='minuta';}else if(number===2||number===3||number===4){result+='minute';}else{result+='minuta';}
return result;case 'h':return withoutSuffix?'jedan sat':'jednog sata';case 'hh':if(number===1){result+='sat';}else if(number===2||number===3||number===4){result+='sata';}else{result+='sati';}
return result;case 'dd':if(number===1){result+='dan';}else{result+='dana';}
return result;case 'MM':if(number===1){result+='mjesec';}else if(number===2||number===3||number===4){result+='mjeseca';}else{result+='mjeseci';}
return result;case 'yy':if(number===1){result+='godina';}else if(number===2||number===3||number===4){result+='godine';}else{result+='godina';}
return result;}}
hooks.defineLocale('bs',{months:'januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar'.split('_'),monthsShort:'jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'nedjelja_ponedjeljak_utorak_srijeda_Äetvrtak_petak_subota'.split('_'),weekdaysShort:'ned._pon._uto._sri._Äet._pet._sub.'.split('_'),weekdaysMin:'ne_po_ut_sr_Äe_pe_su'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[danas u] LT',nextDay:'[sutra u] LT',nextWeek:function(){switch(this.day()){case 0:return '[u] [nedjelju] [u] LT';case 3:return '[u] [srijedu] [u] LT';case 6:return '[u] [subotu] [u] LT';case 1:case 2:case 4:case 5:return '[u] dddd [u] LT';}},lastDay:'[juÄer u] LT',lastWeek:function(){switch(this.day()){case 0:case 3:return '[proÅ¡lu] dddd [u] LT';case 6:return '[proÅ¡le] [subote] [u] LT';case 1:case 2:case 4:case 5:return '[proÅ¡li] dddd [u] LT';}},sameElse:'L'},relativeTime:{future:'za %s',past:'prije %s',s:'par sekundi',ss:translate,m:translate,mm:translate,h:translate,hh:translate,d:'dan',dd:translate,M:'mjesec',MM:translate,y:'godinu',yy:translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});hooks.defineLocale('ca',{months:{standalone:'gener_febrer_marÃ§_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre'.split('_'),format:'de gener_de febrer_de marÃ§_d\'abril_de maig_de juny_de juliol_d\'agost_de setembre_d\'octubre_de novembre_de desembre'.split('_'),isFormat:/D[oD]?(\s)+MMMM/},monthsShort:'gen._febr._marÃ§_abr._maig_juny_jul._ag._set._oct._nov._des.'.split('_'),monthsParseExact:true,weekdays:'diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte'.split('_'),weekdaysShort:'dg._dl._dt._dc._dj._dv._ds.'.split('_'),weekdaysMin:'dg_dl_dt_dc_dj_dv_ds'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM [de] YYYY',ll:'D MMM YYYY',LLL:'D MMMM [de] YYYY [a les] H:mm',lll:'D MMM YYYY, H:mm',LLLL:'dddd D MMMM [de] YYYY [a les] H:mm',llll:'ddd D MMM YYYY, H:mm'},calendar:{sameDay:function(){return '[avui a '+((this.hours()!==1)?'les':'la')+'] LT';},nextDay:function(){return '[demÃ  a '+((this.hours()!==1)?'les':'la')+'] LT';},nextWeek:function(){return 'dddd [a '+((this.hours()!==1)?'les':'la')+'] LT';},lastDay:function(){return '[ahir a '+((this.hours()!==1)?'les':'la')+'] LT';},lastWeek:function(){return '[el] dddd [passat a '+((this.hours()!==1)?'les':'la')+'] LT';},sameElse:'L'},relativeTime:{future:'d\'aquÃ %s',past:'fa %s',s:'uns segons',ss:'%d segons',m:'un minut',mm:'%d minuts',h:'una hora',hh:'%d hores',d:'un dia',dd:'%d dies',M:'un mes',MM:'%d mesos',y:'un any',yy:'%d anys'},dayOfMonthOrdinalParse:/\d{1,2}(r|n|t|Ã¨|a)/,ordinal:function(number,period){var output=(number===1)?'r':(number===2)?'n':(number===3)?'r':(number===4)?'t':'Ã¨';if(period==='w'||period==='W'){output='a';}
return number+output;},week:{dow:1,doy:4}});var months$3='leden_Ãºnor_bÅ™ezen_duben_kvÄ›ten_Äerven_Äervenec_srpen_zÃ¡Å™Ã_Å™Ãjen_listopad_prosinec'.split('_'),monthsShort='led_Ãºno_bÅ™e_dub_kvÄ›_Ävn_Ävc_srp_zÃ¡Å™_Å™Ãj_lis_pro'.split('_');var monthsParse=[/^led/i,/^Ãºno/i,/^bÅ™e/i,/^dub/i,/^kvÄ›/i,/^(Ävn|Äerven$|Äervna)/i,/^(Ävc|Äervenec|Äervence)/i,/^srp/i,/^zÃ¡Å™/i,/^Å™Ãj/i,/^lis/i,/^pro/i];var monthsRegex$1=/^(leden|Ãºnor|bÅ™ezen|duben|kvÄ›ten|Äervenec|Äervence|Äerven|Äervna|srpen|zÃ¡Å™Ã|Å™Ãjen|listopad|prosinec|led|Ãºno|bÅ™e|dub|kvÄ›|Ävn|Ävc|srp|zÃ¡Å™|Å™Ãj|lis|pro)/i;function plural$1(n){return(n>1)&&(n<5)&&(~~(n/10)!==1);}
function translate$1(number,withoutSuffix,key,isFuture){var result=number+' ';switch(key){case 's':return(withoutSuffix||isFuture)?'pÃ¡r sekund':'pÃ¡r sekundami';case 'ss':if(withoutSuffix||isFuture){return result+(plural$1(number)?'sekundy':'sekund');}else{return result+'sekundami';}
break;case 'm':return withoutSuffix?'minuta':(isFuture?'minutu':'minutou');case 'mm':if(withoutSuffix||isFuture){return result+(plural$1(number)?'minuty':'minut');}else{return result+'minutami';}
break;case 'h':return withoutSuffix?'hodina':(isFuture?'hodinu':'hodinou');case 'hh':if(withoutSuffix||isFuture){return result+(plural$1(number)?'hodiny':'hodin');}else{return result+'hodinami';}
break;case 'd':return(withoutSuffix||isFuture)?'den':'dnem';case 'dd':if(withoutSuffix||isFuture){return result+(plural$1(number)?'dny':'dnÃ');}else{return result+'dny';}
break;case 'M':return(withoutSuffix||isFuture)?'mÄ›sÃc':'mÄ›sÃcem';case 'MM':if(withoutSuffix||isFuture){return result+(plural$1(number)?'mÄ›sÃce':'mÄ›sÃcÅ¯');}else{return result+'mÄ›sÃci';}
break;case 'y':return(withoutSuffix||isFuture)?'rok':'rokem';case 'yy':if(withoutSuffix||isFuture){return result+(plural$1(number)?'roky':'let');}else{return result+'lety';}
break;}}
hooks.defineLocale('cs',{months:months$3,monthsShort:monthsShort,monthsRegex:monthsRegex$1,monthsShortRegex:monthsRegex$1,monthsStrictRegex:/^(leden|ledna|Ãºnora|Ãºnor|bÅ™ezen|bÅ™ezna|duben|dubna|kvÄ›ten|kvÄ›tna|Äervenec|Äervence|Äerven|Äervna|srpen|srpna|zÃ¡Å™Ã|Å™Ãjen|Å™Ãjna|listopadu|listopad|prosinec|prosince)/i,monthsShortStrictRegex:/^(led|Ãºno|bÅ™e|dub|kvÄ›|Ävn|Ävc|srp|zÃ¡Å™|Å™Ãj|lis|pro)/i,monthsParse:monthsParse,longMonthsParse:monthsParse,shortMonthsParse:monthsParse,weekdays:'nedÄ›le_pondÄ›lÃ_ÃºterÃ½_stÅ™eda_Ätvrtek_pÃ¡tek_sobota'.split('_'),weekdaysShort:'ne_po_Ãºt_st_Ät_pÃ¡_so'.split('_'),weekdaysMin:'ne_po_Ãºt_st_Ät_pÃ¡_so'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd D. MMMM YYYY H:mm',l:'D. M. YYYY'},calendar:{sameDay:'[dnes v] LT',nextDay:'[zÃtra v] LT',nextWeek:function(){switch(this.day()){case 0:return '[v nedÄ›li v] LT';case 1:case 2:return '[v] dddd [v] LT';case 3:return '[ve stÅ™edu v] LT';case 4:return '[ve Ätvrtek v] LT';case 5:return '[v pÃ¡tek v] LT';case 6:return '[v sobotu v] LT';}},lastDay:'[vÄera v] LT',lastWeek:function(){switch(this.day()){case 0:return '[minulou nedÄ›li v] LT';case 1:case 2:return '[minulÃ©] dddd [v] LT';case 3:return '[minulou stÅ™edu v] LT';case 4:case 5:return '[minulÃ½] dddd [v] LT';case 6:return '[minulou sobotu v] LT';}},sameElse:'L'},relativeTime:{future:'za %s',past:'pÅ™ed %s',s:translate$1,ss:translate$1,m:translate$1,mm:translate$1,h:translate$1,hh:translate$1,d:translate$1,dd:translate$1,M:translate$1,MM:translate$1,y:translate$1,yy:translate$1},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('cv',{months:'ÐºÓ‘Ñ€Ð»Ð°Ñ‡_Ð½Ð°Ñ€Ó‘Ñ_Ð¿ÑƒÑˆ_Ð°ÐºÐ°_Ð¼Ð°Ð¹_Ò«Ó—Ñ€Ñ‚Ð¼Ðµ_ÑƒÑ‚Ó‘_Ò«ÑƒÑ€Ð»Ð°_Ð°Ð²Ó‘Ð½_ÑŽÐ¿Ð°_Ñ‡Ó³Ðº_Ñ€Ð°ÑˆÑ‚Ð°Ð²'.split('_'),monthsShort:'ÐºÓ‘Ñ€_Ð½Ð°Ñ€_Ð¿ÑƒÑˆ_Ð°ÐºÐ°_Ð¼Ð°Ð¹_Ò«Ó—Ñ€_ÑƒÑ‚Ó‘_Ò«ÑƒÑ€_Ð°Ð²Ð½_ÑŽÐ¿Ð°_Ñ‡Ó³Ðº_Ñ€Ð°Ñˆ'.split('_'),weekdays:'Ð²Ñ‹Ñ€ÑÐ°Ñ€Ð½Ð¸ÐºÑƒÐ½_Ñ‚ÑƒÐ½Ñ‚Ð¸ÐºÑƒÐ½_Ñ‹Ñ‚Ð»Ð°Ñ€Ð¸ÐºÑƒÐ½_ÑŽÐ½ÐºÑƒÐ½_ÐºÓ—Ò«Ð½ÐµÑ€Ð½Ð¸ÐºÑƒÐ½_ÑÑ€Ð½ÐµÐºÑƒÐ½_ÑˆÓ‘Ð¼Ð°Ñ‚ÐºÑƒÐ½'.split('_'),weekdaysShort:'Ð²Ñ‹Ñ€_Ñ‚ÑƒÐ½_Ñ‹Ñ‚Ð»_ÑŽÐ½_ÐºÓ—Ò«_ÑÑ€Ð½_ÑˆÓ‘Ð¼'.split('_'),weekdaysMin:'Ð²Ñ€_Ñ‚Ð½_Ñ‹Ñ‚_ÑŽÐ½_ÐºÒ«_ÑÑ€_ÑˆÐ¼'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD-MM-YYYY',LL:'YYYY [Ò«ÑƒÐ»Ñ…Ð¸] MMMM [ÑƒÐ¹Ó‘Ñ…Ó—Ð½] D[-Ð¼Ó—ÑˆÓ—]',LLL:'YYYY [Ò«ÑƒÐ»Ñ…Ð¸] MMMM [ÑƒÐ¹Ó‘Ñ…Ó—Ð½] D[-Ð¼Ó—ÑˆÓ—], HH:mm',LLLL:'dddd, YYYY [Ò«ÑƒÐ»Ñ…Ð¸] MMMM [ÑƒÐ¹Ó‘Ñ…Ó—Ð½] D[-Ð¼Ó—ÑˆÓ—], HH:mm'},calendar:{sameDay:'[ÐŸÐ°ÑÐ½] LT [ÑÐµÑ…ÐµÑ‚Ñ€Ðµ]',nextDay:'[Ð«Ñ€Ð°Ð½] LT [ÑÐµÑ…ÐµÑ‚Ñ€Ðµ]',lastDay:'[Ó–Ð½ÐµÑ€] LT [ÑÐµÑ…ÐµÑ‚Ñ€Ðµ]',nextWeek:'[ÒªÐ¸Ñ‚ÐµÑ] dddd LT [ÑÐµÑ…ÐµÑ‚Ñ€Ðµ]',lastWeek:'[Ð˜Ñ€Ñ‚Ð½Ó—] dddd LT [ÑÐµÑ…ÐµÑ‚Ñ€Ðµ]',sameElse:'L'},relativeTime:{future:function(output){var affix=/ÑÐµÑ…ÐµÑ‚$/i.exec(output)?'Ñ€ÐµÐ½':/Ò«ÑƒÐ»$/i.exec(output)?'Ñ‚Ð°Ð½':'Ñ€Ð°Ð½';return output+affix;},past:'%s ÐºÐ°ÑÐ»Ð»Ð°',s:'Ð¿Ó—Ñ€-Ð¸Ðº Ò«ÐµÐºÐºÑƒÐ½Ñ‚',ss:'%d Ò«ÐµÐºÐºÑƒÐ½Ñ‚',m:'Ð¿Ó—Ñ€ Ð¼Ð¸Ð½ÑƒÑ‚',mm:'%d Ð¼Ð¸Ð½ÑƒÑ‚',h:'Ð¿Ó—Ñ€ ÑÐµÑ…ÐµÑ‚',hh:'%d ÑÐµÑ…ÐµÑ‚',d:'Ð¿Ó—Ñ€ ÐºÑƒÐ½',dd:'%d ÐºÑƒÐ½',M:'Ð¿Ó—Ñ€ ÑƒÐ¹Ó‘Ñ…',MM:'%d ÑƒÐ¹Ó‘Ñ…',y:'Ð¿Ó—Ñ€ Ò«ÑƒÐ»',yy:'%d Ò«ÑƒÐ»'},dayOfMonthOrdinalParse:/\d{1,2}-Ð¼Ó—Ñˆ/,ordinal:'%d-Ð¼Ó—Ñˆ',week:{dow:1,doy:7}});hooks.defineLocale('cy',{months:'Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr'.split('_'),monthsShort:'Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag'.split('_'),weekdays:'Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn'.split('_'),weekdaysShort:'Sul_Llun_Maw_Mer_Iau_Gwe_Sad'.split('_'),weekdaysMin:'Su_Ll_Ma_Me_Ia_Gw_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Heddiw am] LT',nextDay:'[Yfory am] LT',nextWeek:'dddd [am] LT',lastDay:'[Ddoe am] LT',lastWeek:'dddd [diwethaf am] LT',sameElse:'L'},relativeTime:{future:'mewn %s',past:'%s yn Ã´l',s:'ychydig eiliadau',ss:'%d eiliad',m:'munud',mm:'%d munud',h:'awr',hh:'%d awr',d:'diwrnod',dd:'%d diwrnod',M:'mis',MM:'%d mis',y:'blwyddyn',yy:'%d flynedd'},dayOfMonthOrdinalParse:/\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,ordinal:function(number){var b=number,output='',lookup=['','af','il','ydd','ydd','ed','ed','ed','fed','fed','fed','eg','fed','eg','eg','fed','eg','eg','fed','eg','fed'];if(b>20){if(b===40||b===50||b===60||b===80||b===100){output='fed';}else{output='ain';}}else if(b>0){output=lookup[b];}
return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('da',{months:'januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december'.split('_'),monthsShort:'jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec'.split('_'),weekdays:'sÃ¸ndag_mandag_tirsdag_onsdag_torsdag_fredag_lÃ¸rdag'.split('_'),weekdaysShort:'sÃ¸n_man_tir_ons_tor_fre_lÃ¸r'.split('_'),weekdaysMin:'sÃ¸_ma_ti_on_to_fr_lÃ¸'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY HH:mm',LLLL:'dddd [d.] D. MMMM YYYY [kl.] HH:mm'},calendar:{sameDay:'[i dag kl.] LT',nextDay:'[i morgen kl.] LT',nextWeek:'pÃ¥ dddd [kl.] LT',lastDay:'[i gÃ¥r kl.] LT',lastWeek:'[i] dddd[s kl.] LT',sameElse:'L'},relativeTime:{future:'om %s',past:'%s siden',s:'fÃ¥ sekunder',ss:'%d sekunder',m:'et minut',mm:'%d minutter',h:'en time',hh:'%d timer',d:'en dag',dd:'%d dage',M:'en mÃ¥ned',MM:'%d mÃ¥neder',y:'et Ã¥r',yy:'%d Ã¥r'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});function processRelativeTime(number,withoutSuffix,key,isFuture){var format={'m':['eine Minute','einer Minute'],'h':['eine Stunde','einer Stunde'],'d':['ein Tag','einem Tag'],'dd':[number+' Tage',number+' Tagen'],'M':['ein Monat','einem Monat'],'MM':[number+' Monate',number+' Monaten'],'y':['ein Jahr','einem Jahr'],'yy':[number+' Jahre',number+' Jahren']};return withoutSuffix?format[key][0]:format[key][1];}
hooks.defineLocale('de-at',{months:'JÃ¤nner_Februar_MÃ¤rz_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),monthsShort:'JÃ¤n._Feb._MÃ¤rz_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.'.split('_'),monthsParseExact:true,weekdays:'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),weekdaysShort:'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),weekdaysMin:'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY HH:mm',LLLL:'dddd, D. MMMM YYYY HH:mm'},calendar:{sameDay:'[heute um] LT [Uhr]',sameElse:'L',nextDay:'[morgen um] LT [Uhr]',nextWeek:'dddd [um] LT [Uhr]',lastDay:'[gestern um] LT [Uhr]',lastWeek:'[letzten] dddd [um] LT [Uhr]'},relativeTime:{future:'in %s',past:'vor %s',s:'ein paar Sekunden',ss:'%d Sekunden',m:processRelativeTime,mm:'%d Minuten',h:processRelativeTime,hh:'%d Stunden',d:processRelativeTime,dd:processRelativeTime,M:processRelativeTime,MM:processRelativeTime,y:processRelativeTime,yy:processRelativeTime},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});function processRelativeTime$1(number,withoutSuffix,key,isFuture){var format={'m':['eine Minute','einer Minute'],'h':['eine Stunde','einer Stunde'],'d':['ein Tag','einem Tag'],'dd':[number+' Tage',number+' Tagen'],'M':['ein Monat','einem Monat'],'MM':[number+' Monate',number+' Monaten'],'y':['ein Jahr','einem Jahr'],'yy':[number+' Jahre',number+' Jahren']};return withoutSuffix?format[key][0]:format[key][1];}
hooks.defineLocale('de-ch',{months:'Januar_Februar_MÃ¤rz_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),monthsShort:'Jan._Feb._MÃ¤rz_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.'.split('_'),monthsParseExact:true,weekdays:'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),weekdaysShort:'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),weekdaysMin:'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY HH:mm',LLLL:'dddd, D. MMMM YYYY HH:mm'},calendar:{sameDay:'[heute um] LT [Uhr]',sameElse:'L',nextDay:'[morgen um] LT [Uhr]',nextWeek:'dddd [um] LT [Uhr]',lastDay:'[gestern um] LT [Uhr]',lastWeek:'[letzten] dddd [um] LT [Uhr]'},relativeTime:{future:'in %s',past:'vor %s',s:'ein paar Sekunden',ss:'%d Sekunden',m:processRelativeTime$1,mm:'%d Minuten',h:processRelativeTime$1,hh:'%d Stunden',d:processRelativeTime$1,dd:processRelativeTime$1,M:processRelativeTime$1,MM:processRelativeTime$1,y:processRelativeTime$1,yy:processRelativeTime$1},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});function processRelativeTime$2(number,withoutSuffix,key,isFuture){var format={'m':['eine Minute','einer Minute'],'h':['eine Stunde','einer Stunde'],'d':['ein Tag','einem Tag'],'dd':[number+' Tage',number+' Tagen'],'M':['ein Monat','einem Monat'],'MM':[number+' Monate',number+' Monaten'],'y':['ein Jahr','einem Jahr'],'yy':[number+' Jahre',number+' Jahren']};return withoutSuffix?format[key][0]:format[key][1];}
hooks.defineLocale('de',{months:'Januar_Februar_MÃ¤rz_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),monthsShort:'Jan._Feb._MÃ¤rz_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.'.split('_'),monthsParseExact:true,weekdays:'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),weekdaysShort:'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),weekdaysMin:'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY HH:mm',LLLL:'dddd, D. MMMM YYYY HH:mm'},calendar:{sameDay:'[heute um] LT [Uhr]',sameElse:'L',nextDay:'[morgen um] LT [Uhr]',nextWeek:'dddd [um] LT [Uhr]',lastDay:'[gestern um] LT [Uhr]',lastWeek:'[letzten] dddd [um] LT [Uhr]'},relativeTime:{future:'in %s',past:'vor %s',s:'ein paar Sekunden',ss:'%d Sekunden',m:processRelativeTime$2,mm:'%d Minuten',h:processRelativeTime$2,hh:'%d Stunden',d:processRelativeTime$2,dd:processRelativeTime$2,M:processRelativeTime$2,MM:processRelativeTime$2,y:processRelativeTime$2,yy:processRelativeTime$2},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var months$4=['Þ–Þ¬Þ‚ÞªÞ‡Þ¦ÞƒÞ©','ÞŠÞ¬Þ„Þ°ÞƒÞªÞ‡Þ¦ÞƒÞ©','Þ‰Þ§ÞƒÞ¨Þ—Þª','Þ‡ÞÞ•Þ°ÞƒÞ©ÞÞª','Þ‰Þ','Þ–Þ«Þ‚Þ°','Þ–ÞªÞÞ¦Þ‡Þ¨','Þ‡Þ¯ÞŽÞ¦ÞÞ°Þ“Þª','ÞÞ¬Þ•Þ°Þ“Þ¬Þ‰Þ°Þ„Þ¦ÞƒÞª','Þ‡Þ®Þ†Þ°Þ“Þ¯Þ„Þ¦ÞƒÞª','Þ‚Þ®ÞˆÞ¬Þ‰Þ°Þ„Þ¦ÞƒÞª','Þ‘Þ¨ÞÞ¬Þ‰Þ°Þ„Þ¦ÞƒÞª'],weekdays=['Þ‡Þ§Þ‹Þ¨Þ‡Þ°ÞŒÞ¦','Þ€Þ¯Þ‰Þ¦','Þ‡Þ¦Þ‚Þ°ÞŽÞ§ÞƒÞ¦','Þ„ÞªÞ‹Þ¦','Þ„ÞªÞƒÞ§ÞÞ°ÞŠÞ¦ÞŒÞ¨','Þ€ÞªÞ†ÞªÞƒÞª','Þ€Þ®Þ‚Þ¨Þ€Þ¨ÞƒÞª'];hooks.defineLocale('dv',{months:months$4,monthsShort:months$4,weekdays:weekdays,weekdaysShort:weekdays,weekdaysMin:'Þ‡Þ§Þ‹Þ¨_Þ€Þ¯Þ‰Þ¦_Þ‡Þ¦Þ‚Þ°_Þ„ÞªÞ‹Þ¦_Þ„ÞªÞƒÞ§_Þ€ÞªÞ†Þª_Þ€Þ®Þ‚Þ¨'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'D/M/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},meridiemParse:/Þ‰Þ†|Þ‰ÞŠ/,isPM:function(input){return 'Þ‰ÞŠ'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'Þ‰Þ†';}else{return 'Þ‰ÞŠ';}},calendar:{sameDay:'[Þ‰Þ¨Þ‡Þ¦Þ‹Þª] LT',nextDay:'[Þ‰Þ§Þ‹Þ¦Þ‰Þ§] LT',nextWeek:'dddd LT',lastDay:'[Þ‡Þ¨Þ‡Þ°Þ”Þ¬] LT',lastWeek:'[ÞŠÞ§Þ‡Þ¨ÞŒÞªÞˆÞ¨] dddd LT',sameElse:'L'},relativeTime:{future:'ÞŒÞ¬ÞƒÞÞŽÞ¦Þ‡Þ¨ %s',past:'Þ†ÞªÞƒÞ¨Þ‚Þ° %s',s:'ÞÞ¨Þ†ÞªÞ‚Þ°ÞŒÞªÞ†Þ®Þ…Þ¬Þ‡Þ°',ss:'d% ÞÞ¨Þ†ÞªÞ‚Þ°ÞŒÞª',m:'Þ‰Þ¨Þ‚Þ¨Þ“Þ¬Þ‡Þ°',mm:'Þ‰Þ¨Þ‚Þ¨Þ“Þª %d',h:'ÞŽÞ¦Þ‘Þ¨Þ‡Þ¨ÞƒÞ¬Þ‡Þ°',hh:'ÞŽÞ¦Þ‘Þ¨Þ‡Þ¨ÞƒÞª %d',d:'Þ‹ÞªÞˆÞ¦Þ€Þ¬Þ‡Þ°',dd:'Þ‹ÞªÞˆÞ¦ÞÞ° %d',M:'Þ‰Þ¦Þ€Þ¬Þ‡Þ°',MM:'Þ‰Þ¦ÞÞ° %d',y:'Þ‡Þ¦Þ€Þ¦ÞƒÞ¬Þ‡Þ°',yy:'Þ‡Þ¦Þ€Þ¦ÞƒÞª %d'},preparse:function(string){return string.replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/,/g,'ØŒ');},week:{dow:7,doy:12}});hooks.defineLocale('el',{monthsNominativeEl:'Î™Î±Î½Î¿Ï…Î¬ÏÎ¹Î¿Ï‚_Î¦ÎµÎ²ÏÎ¿Ï…Î¬ÏÎ¹Î¿Ï‚_ÎœÎ¬ÏÏ„Î¹Î¿Ï‚_Î‘Ï€ÏÎ¯Î»Î¹Î¿Ï‚_ÎœÎ¬Î¹Î¿Ï‚_Î™Î¿ÏÎ½Î¹Î¿Ï‚_Î™Î¿ÏÎ»Î¹Î¿Ï‚_Î‘ÏÎ³Î¿Ï…ÏƒÏ„Î¿Ï‚_Î£ÎµÏ€Ï„ÎÎ¼Î²ÏÎ¹Î¿Ï‚_ÎŸÎºÏ„ÏŽÎ²ÏÎ¹Î¿Ï‚_ÎÎ¿ÎÎ¼Î²ÏÎ¹Î¿Ï‚_Î”ÎµÎºÎÎ¼Î²ÏÎ¹Î¿Ï‚'.split('_'),monthsGenitiveEl:'Î™Î±Î½Î¿Ï…Î±ÏÎ¯Î¿Ï…_Î¦ÎµÎ²ÏÎ¿Ï…Î±ÏÎ¯Î¿Ï…_ÎœÎ±ÏÏ„Î¯Î¿Ï…_Î‘Ï€ÏÎ¹Î»Î¯Î¿Ï…_ÎœÎ±ÎÎ¿Ï…_Î™Î¿Ï…Î½Î¯Î¿Ï…_Î™Î¿Ï…Î»Î¯Î¿Ï…_Î‘Ï…Î³Î¿ÏÏƒÏ„Î¿Ï…_Î£ÎµÏ€Ï„ÎµÎ¼Î²ÏÎ¯Î¿Ï…_ÎŸÎºÏ„Ï‰Î²ÏÎ¯Î¿Ï…_ÎÎ¿ÎµÎ¼Î²ÏÎ¯Î¿Ï…_Î”ÎµÎºÎµÎ¼Î²ÏÎ¯Î¿Ï…'.split('_'),months:function(momentToFormat,format){if(!momentToFormat){return this._monthsNominativeEl;}else if(typeof format==='string'&&/D/.test(format.substring(0,format.indexOf('MMMM')))){return this._monthsGenitiveEl[momentToFormat.month()];}else{return this._monthsNominativeEl[momentToFormat.month()];}},monthsShort:'Î™Î±Î½_Î¦ÎµÎ²_ÎœÎ±Ï_Î‘Ï€Ï_ÎœÎ±ÏŠ_Î™Î¿Ï…Î½_Î™Î¿Ï…Î»_Î‘Ï…Î³_Î£ÎµÏ€_ÎŸÎºÏ„_ÎÎ¿Îµ_Î”ÎµÎº'.split('_'),weekdays:'ÎšÏ…ÏÎ¹Î±ÎºÎ®_Î”ÎµÏ…Ï„ÎÏÎ±_Î¤ÏÎ¯Ï„Î·_Î¤ÎµÏ„Î¬ÏÏ„Î·_Î ÎÎ¼Ï€Ï„Î·_Î Î±ÏÎ±ÏƒÎºÎµÏ…Î®_Î£Î¬Î²Î²Î±Ï„Î¿'.split('_'),weekdaysShort:'ÎšÏ…Ï_Î”ÎµÏ…_Î¤ÏÎ¹_Î¤ÎµÏ„_Î ÎµÎ¼_Î Î±Ï_Î£Î±Î²'.split('_'),weekdaysMin:'ÎšÏ…_Î”Îµ_Î¤Ï_Î¤Îµ_Î Îµ_Î Î±_Î£Î±'.split('_'),meridiem:function(hours,minutes,isLower){if(hours>11){return isLower?'Î¼Î¼':'ÎœÎœ';}else{return isLower?'Ï€Î¼':'Î Îœ';}},isPM:function(input){return((input+'').toLowerCase()[0]==='Î¼');},meridiemParse:/[Î Îœ]\.?Îœ?\.?/i,longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendarEl:{sameDay:'[Î£Î®Î¼ÎµÏÎ± {}] LT',nextDay:'[Î‘ÏÏÎ¹Î¿ {}] LT',nextWeek:'dddd [{}] LT',lastDay:'[Î§Î¸ÎµÏ‚ {}] LT',lastWeek:function(){switch(this.day()){case 6:return '[Ï„Î¿ Ï€ÏÎ¿Î·Î³Î¿ÏÎ¼ÎµÎ½Î¿] dddd [{}] LT';default:return '[Ï„Î·Î½ Ï€ÏÎ¿Î·Î³Î¿ÏÎ¼ÎµÎ½Î·] dddd [{}] LT';}},sameElse:'L'},calendar:function(key,mom){var output=this._calendarEl[key],hours=mom&&mom.hours();if(isFunction(output)){output=output.apply(mom);}
return output.replace('{}',(hours%12===1?'ÏƒÏ„Î·':'ÏƒÏ„Î¹Ï‚'));},relativeTime:{future:'ÏƒÎµ %s',past:'%s Ï€ÏÎ¹Î½',s:'Î»Î¯Î³Î± Î´ÎµÏ…Ï„ÎµÏÏŒÎ»ÎµÏ€Ï„Î±',ss:'%d Î´ÎµÏ…Ï„ÎµÏÏŒÎ»ÎµÏ€Ï„Î±',m:'ÎÎ½Î± Î»ÎµÏ€Ï„ÏŒ',mm:'%d Î»ÎµÏ€Ï„Î¬',h:'Î¼Î¯Î± ÏŽÏÎ±',hh:'%d ÏŽÏÎµÏ‚',d:'Î¼Î¯Î± Î¼ÎÏÎ±',dd:'%d Î¼ÎÏÎµÏ‚',M:'ÎÎ½Î±Ï‚ Î¼Î®Î½Î±Ï‚',MM:'%d Î¼Î®Î½ÎµÏ‚',y:'ÎÎ½Î±Ï‚ Ï‡ÏÏŒÎ½Î¿Ï‚',yy:'%d Ï‡ÏÏŒÎ½Î¹Î±'},dayOfMonthOrdinalParse:/\d{1,2}Î·/,ordinal:'%dÎ·',week:{dow:1,doy:4}});hooks.defineLocale('en-SG',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('en-au',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('en-ca',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'YYYY-MM-DD',LL:'MMMM D, YYYY',LLL:'MMMM D, YYYY h:mm A',LLLL:'dddd, MMMM D, YYYY h:mm A'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;}});hooks.defineLocale('en-gb',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('en-ie',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('en-il',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;}});hooks.defineLocale('en-nz',{months:'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),weekdays:'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),weekdaysShort:'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),weekdaysMin:'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendar:{sameDay:'[Today at] LT',nextDay:'[Tomorrow at] LT',nextWeek:'dddd [at] LT',lastDay:'[Yesterday at] LT',lastWeek:'[Last] dddd [at] LT',sameElse:'L'},relativeTime:{future:'in %s',past:'%s ago',s:'a few seconds',ss:'%d seconds',m:'a minute',mm:'%d minutes',h:'an hour',hh:'%d hours',d:'a day',dd:'%d days',M:'a month',MM:'%d months',y:'a year',yy:'%d years'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('eo',{months:'januaro_februaro_marto_aprilo_majo_junio_julio_aÅgusto_septembro_oktobro_novembro_decembro'.split('_'),monthsShort:'jan_feb_mar_apr_maj_jun_jul_aÅg_sep_okt_nov_dec'.split('_'),weekdays:'dimanÄ‰o_lundo_mardo_merkredo_ÄµaÅdo_vendredo_sabato'.split('_'),weekdaysShort:'dim_lun_mard_merk_ÄµaÅ_ven_sab'.split('_'),weekdaysMin:'di_lu_ma_me_Äµa_ve_sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'D[-a de] MMMM, YYYY',LLL:'D[-a de] MMMM, YYYY HH:mm',LLLL:'dddd, [la] D[-a de] MMMM, YYYY HH:mm'},meridiemParse:/[ap]\.t\.m/i,isPM:function(input){return input.charAt(0).toLowerCase()==='p';},meridiem:function(hours,minutes,isLower){if(hours>11){return isLower?'p.t.m.':'P.T.M.';}else{return isLower?'a.t.m.':'A.T.M.';}},calendar:{sameDay:'[HodiaÅ je] LT',nextDay:'[MorgaÅ je] LT',nextWeek:'dddd [je] LT',lastDay:'[HieraÅ je] LT',lastWeek:'[pasinta] dddd [je] LT',sameElse:'L'},relativeTime:{future:'post %s',past:'antaÅ %s',s:'sekundoj',ss:'%d sekundoj',m:'minuto',mm:'%d minutoj',h:'horo',hh:'%d horoj',d:'tago',dd:'%d tagoj',M:'monato',MM:'%d monatoj',y:'jaro',yy:'%d jaroj'},dayOfMonthOrdinalParse:/\d{1,2}a/,ordinal:'%da',week:{dow:1,doy:7}});var monthsShortDot='ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_'),monthsShort$1='ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_');var monthsParse$1=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i];var monthsRegex$2=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;hooks.defineLocale('es-do',{months:'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortDot;}else if(/-MMM-/.test(format)){return monthsShort$1[m.month()];}else{return monthsShortDot[m.month()];}},monthsRegex:monthsRegex$2,monthsShortRegex:monthsRegex$2,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:monthsParse$1,longMonthsParse:monthsParse$1,shortMonthsParse:monthsParse$1,weekdays:'domingo_lunes_martes_miÃ©rcoles_jueves_viernes_sÃ¡bado'.split('_'),weekdaysShort:'dom._lun._mar._miÃ©._jue._vie._sÃ¡b.'.split('_'),weekdaysMin:'do_lu_ma_mi_ju_vi_sÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY h:mm A',LLLL:'dddd, D [de] MMMM [de] YYYY h:mm A'},calendar:{sameDay:function(){return '[hoy a la'+((this.hours()!==1)?'s':'')+'] LT';},nextDay:function(){return '[maÃ±ana a la'+((this.hours()!==1)?'s':'')+'] LT';},nextWeek:function(){return 'dddd [a la'+((this.hours()!==1)?'s':'')+'] LT';},lastDay:function(){return '[ayer a la'+((this.hours()!==1)?'s':'')+'] LT';},lastWeek:function(){return '[el] dddd [pasado a la'+((this.hours()!==1)?'s':'')+'] LT';},sameElse:'L'},relativeTime:{future:'en %s',past:'hace %s',s:'unos segundos',ss:'%d segundos',m:'un minuto',mm:'%d minutos',h:'una hora',hh:'%d horas',d:'un dÃa',dd:'%d dÃas',M:'un mes',MM:'%d meses',y:'un aÃ±o',yy:'%d aÃ±os'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});var monthsShortDot$1='ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_'),monthsShort$2='ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_');var monthsParse$2=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i];var monthsRegex$3=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;hooks.defineLocale('es-us',{months:'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortDot$1;}else if(/-MMM-/.test(format)){return monthsShort$2[m.month()];}else{return monthsShortDot$1[m.month()];}},monthsRegex:monthsRegex$3,monthsShortRegex:monthsRegex$3,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:monthsParse$2,longMonthsParse:monthsParse$2,shortMonthsParse:monthsParse$2,weekdays:'domingo_lunes_martes_miÃ©rcoles_jueves_viernes_sÃ¡bado'.split('_'),weekdaysShort:'dom._lun._mar._miÃ©._jue._vie._sÃ¡b.'.split('_'),weekdaysMin:'do_lu_ma_mi_ju_vi_sÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'MM/DD/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY h:mm A',LLLL:'dddd, D [de] MMMM [de] YYYY h:mm A'},calendar:{sameDay:function(){return '[hoy a la'+((this.hours()!==1)?'s':'')+'] LT';},nextDay:function(){return '[maÃ±ana a la'+((this.hours()!==1)?'s':'')+'] LT';},nextWeek:function(){return 'dddd [a la'+((this.hours()!==1)?'s':'')+'] LT';},lastDay:function(){return '[ayer a la'+((this.hours()!==1)?'s':'')+'] LT';},lastWeek:function(){return '[el] dddd [pasado a la'+((this.hours()!==1)?'s':'')+'] LT';},sameElse:'L'},relativeTime:{future:'en %s',past:'hace %s',s:'unos segundos',ss:'%d segundos',m:'un minuto',mm:'%d minutos',h:'una hora',hh:'%d horas',d:'un dÃa',dd:'%d dÃas',M:'un mes',MM:'%d meses',y:'un aÃ±o',yy:'%d aÃ±os'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:0,doy:6}});var monthsShortDot$2='ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_'),monthsShort$3='ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_');var monthsParse$3=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i];var monthsRegex$4=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;hooks.defineLocale('es',{months:'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortDot$2;}else if(/-MMM-/.test(format)){return monthsShort$3[m.month()];}else{return monthsShortDot$2[m.month()];}},monthsRegex:monthsRegex$4,monthsShortRegex:monthsRegex$4,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:monthsParse$3,longMonthsParse:monthsParse$3,shortMonthsParse:monthsParse$3,weekdays:'domingo_lunes_martes_miÃ©rcoles_jueves_viernes_sÃ¡bado'.split('_'),weekdaysShort:'dom._lun._mar._miÃ©._jue._vie._sÃ¡b.'.split('_'),weekdaysMin:'do_lu_ma_mi_ju_vi_sÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD/MM/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY H:mm',LLLL:'dddd, D [de] MMMM [de] YYYY H:mm'},calendar:{sameDay:function(){return '[hoy a la'+((this.hours()!==1)?'s':'')+'] LT';},nextDay:function(){return '[maÃ±ana a la'+((this.hours()!==1)?'s':'')+'] LT';},nextWeek:function(){return 'dddd [a la'+((this.hours()!==1)?'s':'')+'] LT';},lastDay:function(){return '[ayer a la'+((this.hours()!==1)?'s':'')+'] LT';},lastWeek:function(){return '[el] dddd [pasado a la'+((this.hours()!==1)?'s':'')+'] LT';},sameElse:'L'},relativeTime:{future:'en %s',past:'hace %s',s:'unos segundos',ss:'%d segundos',m:'un minuto',mm:'%d minutos',h:'una hora',hh:'%d horas',d:'un dÃa',dd:'%d dÃas',M:'un mes',MM:'%d meses',y:'un aÃ±o',yy:'%d aÃ±os'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});function processRelativeTime$3(number,withoutSuffix,key,isFuture){var format={'s':['mÃµne sekundi','mÃµni sekund','paar sekundit'],'ss':[number+'sekundi',number+'sekundit'],'m':['Ã¼he minuti','Ã¼ks minut'],'mm':[number+' minuti',number+' minutit'],'h':['Ã¼he tunni','tund aega','Ã¼ks tund'],'hh':[number+' tunni',number+' tundi'],'d':['Ã¼he pÃ¤eva','Ã¼ks pÃ¤ev'],'M':['kuu aja','kuu aega','Ã¼ks kuu'],'MM':[number+' kuu',number+' kuud'],'y':['Ã¼he aasta','aasta','Ã¼ks aasta'],'yy':[number+' aasta',number+' aastat']};if(withoutSuffix){return format[key][2]?format[key][2]:format[key][1];}
return isFuture?format[key][0]:format[key][1];}
hooks.defineLocale('et',{months:'jaanuar_veebruar_mÃ¤rts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember'.split('_'),monthsShort:'jaan_veebr_mÃ¤rts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets'.split('_'),weekdays:'pÃ¼hapÃ¤ev_esmaspÃ¤ev_teisipÃ¤ev_kolmapÃ¤ev_neljapÃ¤ev_reede_laupÃ¤ev'.split('_'),weekdaysShort:'P_E_T_K_N_R_L'.split('_'),weekdaysMin:'P_E_T_K_N_R_L'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[TÃ¤na,] LT',nextDay:'[Homme,] LT',nextWeek:'[JÃ¤rgmine] dddd LT',lastDay:'[Eile,] LT',lastWeek:'[Eelmine] dddd LT',sameElse:'L'},relativeTime:{future:'%s pÃ¤rast',past:'%s tagasi',s:processRelativeTime$3,ss:processRelativeTime$3,m:processRelativeTime$3,mm:processRelativeTime$3,h:processRelativeTime$3,hh:processRelativeTime$3,d:processRelativeTime$3,dd:'%d pÃ¤eva',M:processRelativeTime$3,MM:processRelativeTime$3,y:processRelativeTime$3,yy:processRelativeTime$3},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('eu',{months:'urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua'.split('_'),monthsShort:'urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.'.split('_'),monthsParseExact:true,weekdays:'igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata'.split('_'),weekdaysShort:'ig._al._ar._az._og._ol._lr.'.split('_'),weekdaysMin:'ig_al_ar_az_og_ol_lr'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'YYYY[ko] MMMM[ren] D[a]',LLL:'YYYY[ko] MMMM[ren] D[a] HH:mm',LLLL:'dddd, YYYY[ko] MMMM[ren] D[a] HH:mm',l:'YYYY-M-D',ll:'YYYY[ko] MMM D[a]',lll:'YYYY[ko] MMM D[a] HH:mm',llll:'ddd, YYYY[ko] MMM D[a] HH:mm'},calendar:{sameDay:'[gaur] LT[etan]',nextDay:'[bihar] LT[etan]',nextWeek:'dddd LT[etan]',lastDay:'[atzo] LT[etan]',lastWeek:'[aurreko] dddd LT[etan]',sameElse:'L'},relativeTime:{future:'%s barru',past:'duela %s',s:'segundo batzuk',ss:'%d segundo',m:'minutu bat',mm:'%d minutu',h:'ordu bat',hh:'%d ordu',d:'egun bat',dd:'%d egun',M:'hilabete bat',MM:'%d hilabete',y:'urte bat',yy:'%d urte'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});var symbolMap$5={'1':'Û±','2':'Û²','3':'Û³','4':'Û´','5':'Ûµ','6':'Û¶','7':'Û·','8':'Û¸','9':'Û¹','0':'Û°'},numberMap$4={'Û±':'1','Û²':'2','Û³':'3','Û´':'4','Ûµ':'5','Û¶':'6','Û·':'7','Û¸':'8','Û¹':'9','Û°':'0'};hooks.defineLocale('fa',{months:'Ú˜Ø§Ù†ÙˆÛŒÙ‡_ÙÙˆØ±ÛŒÙ‡_Ù…Ø§Ø±Ø³_Ø¢ÙˆØ±ÛŒÙ„_Ù…Ù‡_Ú˜ÙˆØ¦Ù†_Ú˜ÙˆØ¦ÛŒÙ‡_Ø§ÙˆØª_Ø³Ù¾ØªØ§Ù…Ø¨Ø±_Ø§Ú©ØªØ¨Ø±_Ù†ÙˆØ§Ù…Ø¨Ø±_Ø¯Ø³Ø§Ù…Ø¨Ø±'.split('_'),monthsShort:'Ú˜Ø§Ù†ÙˆÛŒÙ‡_ÙÙˆØ±ÛŒÙ‡_Ù…Ø§Ø±Ø³_Ø¢ÙˆØ±ÛŒÙ„_Ù…Ù‡_Ú˜ÙˆØ¦Ù†_Ú˜ÙˆØ¦ÛŒÙ‡_Ø§ÙˆØª_Ø³Ù¾ØªØ§Ù…Ø¨Ø±_Ø§Ú©ØªØ¨Ø±_Ù†ÙˆØ§Ù…Ø¨Ø±_Ø¯Ø³Ø§Ù…Ø¨Ø±'.split('_'),weekdays:'ÛŒÚ©\u200cØ´Ù†Ø¨Ù‡_Ø¯ÙˆØ´Ù†Ø¨Ù‡_Ø³Ù‡\u200cØ´Ù†Ø¨Ù‡_Ú†Ù‡Ø§Ø±Ø´Ù†Ø¨Ù‡_Ù¾Ù†Ø¬\u200cØ´Ù†Ø¨Ù‡_Ø¬Ù…Ø¹Ù‡_Ø´Ù†Ø¨Ù‡'.split('_'),weekdaysShort:'ÛŒÚ©\u200cØ´Ù†Ø¨Ù‡_Ø¯ÙˆØ´Ù†Ø¨Ù‡_Ø³Ù‡\u200cØ´Ù†Ø¨Ù‡_Ú†Ù‡Ø§Ø±Ø´Ù†Ø¨Ù‡_Ù¾Ù†Ø¬\u200cØ´Ù†Ø¨Ù‡_Ø¬Ù…Ø¹Ù‡_Ø´Ù†Ø¨Ù‡'.split('_'),weekdaysMin:'ÛŒ_Ø¯_Ø³_Ú†_Ù¾_Ø¬_Ø´'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},meridiemParse:/Ù‚Ø¨Ù„ Ø§Ø² Ø¸Ù‡Ø±|Ø¨Ø¹Ø¯ Ø§Ø² Ø¸Ù‡Ø±/,isPM:function(input){return /Ø¨Ø¹Ø¯ Ø§Ø² Ø¸Ù‡Ø±/.test(input);},meridiem:function(hour,minute,isLower){if(hour<12){return 'Ù‚Ø¨Ù„ Ø§Ø² Ø¸Ù‡Ø±';}else{return 'Ø¨Ø¹Ø¯ Ø§Ø² Ø¸Ù‡Ø±';}},calendar:{sameDay:'[Ø§Ù…Ø±ÙˆØ² Ø³Ø§Ø¹Øª] LT',nextDay:'[ÙØ±Ø¯Ø§ Ø³Ø§Ø¹Øª] LT',nextWeek:'dddd [Ø³Ø§Ø¹Øª] LT',lastDay:'[Ø¯ÛŒØ±ÙˆØ² Ø³Ø§Ø¹Øª] LT',lastWeek:'dddd [Ù¾ÛŒØ´] [Ø³Ø§Ø¹Øª] LT',sameElse:'L'},relativeTime:{future:'Ø¯Ø± %s',past:'%s Ù¾ÛŒØ´',s:'Ú†Ù†Ø¯ Ø«Ø§Ù†ÛŒÙ‡',ss:'Ø«Ø§Ù†ÛŒÙ‡ d%',m:'ÛŒÚ© Ø¯Ù‚ÛŒÙ‚Ù‡',mm:'%d Ø¯Ù‚ÛŒÙ‚Ù‡',h:'ÛŒÚ© Ø³Ø§Ø¹Øª',hh:'%d Ø³Ø§Ø¹Øª',d:'ÛŒÚ© Ø±ÙˆØ²',dd:'%d Ø±ÙˆØ²',M:'ÛŒÚ© Ù…Ø§Ù‡',MM:'%d Ù…Ø§Ù‡',y:'ÛŒÚ© Ø³Ø§Ù„',yy:'%d Ø³Ø§Ù„'},preparse:function(string){return string.replace(/[Û°-Û¹]/g,function(match){return numberMap$4[match];}).replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$5[match];}).replace(/,/g,'ØŒ');},dayOfMonthOrdinalParse:/\d{1,2}Ù…/,ordinal:'%dÙ…',week:{dow:6,doy:12}});var numbersPast='nolla yksi kaksi kolme neljÃ¤ viisi kuusi seitsemÃ¤n kahdeksan yhdeksÃ¤n'.split(' '),numbersFuture=['nolla','yhden','kahden','kolmen','neljÃ¤n','viiden','kuuden',numbersPast[7],numbersPast[8],numbersPast[9]];function translate$2(number,withoutSuffix,key,isFuture){var result='';switch(key){case 's':return isFuture?'muutaman sekunnin':'muutama sekunti';case 'ss':return isFuture?'sekunnin':'sekuntia';case 'm':return isFuture?'minuutin':'minuutti';case 'mm':result=isFuture?'minuutin':'minuuttia';break;case 'h':return isFuture?'tunnin':'tunti';case 'hh':result=isFuture?'tunnin':'tuntia';break;case 'd':return isFuture?'pÃ¤ivÃ¤n':'pÃ¤ivÃ¤';case 'dd':result=isFuture?'pÃ¤ivÃ¤n':'pÃ¤ivÃ¤Ã¤';break;case 'M':return isFuture?'kuukauden':'kuukausi';case 'MM':result=isFuture?'kuukauden':'kuukautta';break;case 'y':return isFuture?'vuoden':'vuosi';case 'yy':result=isFuture?'vuoden':'vuotta';break;}
result=verbalNumber(number,isFuture)+' '+result;return result;}
function verbalNumber(number,isFuture){return number<10?(isFuture?numbersFuture[number]:numbersPast[number]):number;}
hooks.defineLocale('fi',{months:'tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesÃ¤kuu_heinÃ¤kuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu'.split('_'),monthsShort:'tammi_helmi_maalis_huhti_touko_kesÃ¤_heinÃ¤_elo_syys_loka_marras_joulu'.split('_'),weekdays:'sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai'.split('_'),weekdaysShort:'su_ma_ti_ke_to_pe_la'.split('_'),weekdaysMin:'su_ma_ti_ke_to_pe_la'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD.MM.YYYY',LL:'Do MMMM[ta] YYYY',LLL:'Do MMMM[ta] YYYY, [klo] HH.mm',LLLL:'dddd, Do MMMM[ta] YYYY, [klo] HH.mm',l:'D.M.YYYY',ll:'Do MMM YYYY',lll:'Do MMM YYYY, [klo] HH.mm',llll:'ddd, Do MMM YYYY, [klo] HH.mm'},calendar:{sameDay:'[tÃ¤nÃ¤Ã¤n] [klo] LT',nextDay:'[huomenna] [klo] LT',nextWeek:'dddd [klo] LT',lastDay:'[eilen] [klo] LT',lastWeek:'[viime] dddd[na] [klo] LT',sameElse:'L'},relativeTime:{future:'%s pÃ¤Ã¤stÃ¤',past:'%s sitten',s:translate$2,ss:translate$2,m:translate$2,mm:translate$2,h:translate$2,hh:translate$2,d:translate$2,dd:translate$2,M:translate$2,MM:translate$2,y:translate$2,yy:translate$2},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('fo',{months:'januar_februar_mars_aprÃl_mai_juni_juli_august_september_oktober_november_desember'.split('_'),monthsShort:'jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_'),weekdays:'sunnudagur_mÃ¡nadagur_tÃ½sdagur_mikudagur_hÃ³sdagur_frÃggjadagur_leygardagur'.split('_'),weekdaysShort:'sun_mÃ¡n_tÃ½s_mik_hÃ³s_frÃ_ley'.split('_'),weekdaysMin:'su_mÃ¡_tÃ½_mi_hÃ³_fr_le'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D. MMMM, YYYY HH:mm'},calendar:{sameDay:'[Ã dag kl.] LT',nextDay:'[Ã morgin kl.] LT',nextWeek:'dddd [kl.] LT',lastDay:'[Ã gjÃ¡r kl.] LT',lastWeek:'[sÃÃ°stu] dddd [kl] LT',sameElse:'L'},relativeTime:{future:'um %s',past:'%s sÃÃ°ani',s:'fÃ¡ sekund',ss:'%d sekundir',m:'ein minuttur',mm:'%d minuttir',h:'ein tÃmi',hh:'%d tÃmar',d:'ein dagur',dd:'%d dagar',M:'ein mÃ¡naÃ°ur',MM:'%d mÃ¡naÃ°ir',y:'eitt Ã¡r',yy:'%d Ã¡r'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('fr-ca',{months:'janvier_fÃ©vrier_mars_avril_mai_juin_juillet_aoÃ»t_septembre_octobre_novembre_dÃ©cembre'.split('_'),monthsShort:'janv._fÃ©vr._mars_avr._mai_juin_juil._aoÃ»t_sept._oct._nov._dÃ©c.'.split('_'),monthsParseExact:true,weekdays:'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),weekdaysShort:'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),weekdaysMin:'di_lu_ma_me_je_ve_sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Aujourdâ€™hui Ã ] LT',nextDay:'[Demain Ã ] LT',nextWeek:'dddd [Ã ] LT',lastDay:'[Hier Ã ] LT',lastWeek:'dddd [dernier Ã ] LT',sameElse:'L'},relativeTime:{future:'dans %s',past:'il y a %s',s:'quelques secondes',ss:'%d secondes',m:'une minute',mm:'%d minutes',h:'une heure',hh:'%d heures',d:'un jour',dd:'%d jours',M:'un mois',MM:'%d mois',y:'un an',yy:'%d ans'},dayOfMonthOrdinalParse:/\d{1,2}(er|e)/,ordinal:function(number,period){switch(period){default:case 'M':case 'Q':case 'D':case 'DDD':case 'd':return number+(number===1?'er':'e');case 'w':case 'W':return number+(number===1?'re':'e');}}});hooks.defineLocale('fr-ch',{months:'janvier_fÃ©vrier_mars_avril_mai_juin_juillet_aoÃ»t_septembre_octobre_novembre_dÃ©cembre'.split('_'),monthsShort:'janv._fÃ©vr._mars_avr._mai_juin_juil._aoÃ»t_sept._oct._nov._dÃ©c.'.split('_'),monthsParseExact:true,weekdays:'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),weekdaysShort:'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),weekdaysMin:'di_lu_ma_me_je_ve_sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Aujourdâ€™hui Ã ] LT',nextDay:'[Demain Ã ] LT',nextWeek:'dddd [Ã ] LT',lastDay:'[Hier Ã ] LT',lastWeek:'dddd [dernier Ã ] LT',sameElse:'L'},relativeTime:{future:'dans %s',past:'il y a %s',s:'quelques secondes',ss:'%d secondes',m:'une minute',mm:'%d minutes',h:'une heure',hh:'%d heures',d:'un jour',dd:'%d jours',M:'un mois',MM:'%d mois',y:'un an',yy:'%d ans'},dayOfMonthOrdinalParse:/\d{1,2}(er|e)/,ordinal:function(number,period){switch(period){default:case 'M':case 'Q':case 'D':case 'DDD':case 'd':return number+(number===1?'er':'e');case 'w':case 'W':return number+(number===1?'re':'e');}},week:{dow:1,doy:4}});hooks.defineLocale('fr',{months:'janvier_fÃ©vrier_mars_avril_mai_juin_juillet_aoÃ»t_septembre_octobre_novembre_dÃ©cembre'.split('_'),monthsShort:'janv._fÃ©vr._mars_avr._mai_juin_juil._aoÃ»t_sept._oct._nov._dÃ©c.'.split('_'),monthsParseExact:true,weekdays:'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),weekdaysShort:'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),weekdaysMin:'di_lu_ma_me_je_ve_sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Aujourdâ€™hui Ã ] LT',nextDay:'[Demain Ã ] LT',nextWeek:'dddd [Ã ] LT',lastDay:'[Hier Ã ] LT',lastWeek:'dddd [dernier Ã ] LT',sameElse:'L'},relativeTime:{future:'dans %s',past:'il y a %s',s:'quelques secondes',ss:'%d secondes',m:'une minute',mm:'%d minutes',h:'une heure',hh:'%d heures',d:'un jour',dd:'%d jours',M:'un mois',MM:'%d mois',y:'un an',yy:'%d ans'},dayOfMonthOrdinalParse:/\d{1,2}(er|)/,ordinal:function(number,period){switch(period){case 'D':return number+(number===1?'er':'');default:case 'M':case 'Q':case 'DDD':case 'd':return number+(number===1?'er':'e');case 'w':case 'W':return number+(number===1?'re':'e');}},week:{dow:1,doy:4}});var monthsShortWithDots='jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.'.split('_'),monthsShortWithoutDots='jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_');hooks.defineLocale('fy',{months:'jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortWithDots;}else if(/-MMM-/.test(format)){return monthsShortWithoutDots[m.month()];}else{return monthsShortWithDots[m.month()];}},monthsParseExact:true,weekdays:'snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon'.split('_'),weekdaysShort:'si._mo._ti._wo._to._fr._so.'.split('_'),weekdaysMin:'Si_Mo_Ti_Wo_To_Fr_So'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD-MM-YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[hjoed om] LT',nextDay:'[moarn om] LT',nextWeek:'dddd [om] LT',lastDay:'[juster om] LT',lastWeek:'[Ã´frÃ»ne] dddd [om] LT',sameElse:'L'},relativeTime:{future:'oer %s',past:'%s lyn',s:'in pear sekonden',ss:'%d sekonden',m:'ien minÃºt',mm:'%d minuten',h:'ien oere',hh:'%d oeren',d:'ien dei',dd:'%d dagen',M:'ien moanne',MM:'%d moannen',y:'ien jier',yy:'%d jierren'},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(number){return number+((number===1||number===8||number>=20)?'ste':'de');},week:{dow:1,doy:4}});var months$5=['EanÃ¡ir','Feabhra','MÃ¡rta','AibreÃ¡n','Bealtaine','MÃ©itheamh','IÃºil','LÃºnasa','MeÃ¡n FÃ³mhair','Deaireadh FÃ³mhair','Samhain','Nollaig'];var monthsShort$4=['EanÃ¡','Feab','MÃ¡rt','Aibr','Beal','MÃ©it','IÃºil','LÃºna','MeÃ¡n','Deai','Samh','Noll'];var weekdays$1=['DÃ© Domhnaigh','DÃ© Luain','DÃ© MÃ¡irt','DÃ© CÃ©adaoin','DÃ©ardaoin','DÃ© hAoine','DÃ© Satharn'];var weekdaysShort=['Dom','Lua','MÃ¡i','CÃ©a','DÃ©a','hAo','Sat'];var weekdaysMin=['Do','Lu','MÃ¡','Ce','DÃ©','hA','Sa'];hooks.defineLocale('ga',{months:months$5,monthsShort:monthsShort$4,monthsParseExact:true,weekdays:weekdays$1,weekdaysShort:weekdaysShort,weekdaysMin:weekdaysMin,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Inniu ag] LT',nextDay:'[AmÃ¡rach ag] LT',nextWeek:'dddd [ag] LT',lastDay:'[InnÃ© aig] LT',lastWeek:'dddd [seo caite] [ag] LT',sameElse:'L'},relativeTime:{future:'i %s',past:'%s Ã³ shin',s:'cÃºpla soicind',ss:'%d soicind',m:'nÃ³imÃ©ad',mm:'%d nÃ³imÃ©ad',h:'uair an chloig',hh:'%d uair an chloig',d:'lÃ¡',dd:'%d lÃ¡',M:'mÃ',MM:'%d mÃ',y:'bliain',yy:'%d bliain'},dayOfMonthOrdinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(number){var output=number===1?'d':number%10===2?'na':'mh';return number+output;},week:{dow:1,doy:4}});var months$6=['Am Faoilleach','An Gearran','Am MÃ rt','An Giblean','An CÃ¨itean','An t-Ã’gmhios','An t-Iuchar','An LÃ¹nastal','An t-Sultain','An DÃ mhair','An t-Samhain','An DÃ¹bhlachd'];var monthsShort$5=['Faoi','Gear','MÃ rt','Gibl','CÃ¨it','Ã’gmh','Iuch','LÃ¹n','Sult','DÃ mh','Samh','DÃ¹bh'];var weekdays$2=['DidÃ²mhnaich','Diluain','DimÃ irt','Diciadain','Diardaoin','Dihaoine','Disathairne'];var weekdaysShort$1=['Did','Dil','Dim','Dic','Dia','Dih','Dis'];var weekdaysMin$1=['DÃ²','Lu','MÃ ','Ci','Ar','Ha','Sa'];hooks.defineLocale('gd',{months:months$6,monthsShort:monthsShort$5,monthsParseExact:true,weekdays:weekdays$2,weekdaysShort:weekdaysShort$1,weekdaysMin:weekdaysMin$1,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[An-diugh aig] LT',nextDay:'[A-mÃ ireach aig] LT',nextWeek:'dddd [aig] LT',lastDay:'[An-dÃ¨ aig] LT',lastWeek:'dddd [seo chaidh] [aig] LT',sameElse:'L'},relativeTime:{future:'ann an %s',past:'bho chionn %s',s:'beagan diogan',ss:'%d diogan',m:'mionaid',mm:'%d mionaidean',h:'uair',hh:'%d uairean',d:'latha',dd:'%d latha',M:'mÃ¬os',MM:'%d mÃ¬osan',y:'bliadhna',yy:'%d bliadhna'},dayOfMonthOrdinalParse:/\d{1,2}(d|na|mh)/,ordinal:function(number){var output=number===1?'d':number%10===2?'na':'mh';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('gl',{months:'xaneiro_febreiro_marzo_abril_maio_xuÃ±o_xullo_agosto_setembro_outubro_novembro_decembro'.split('_'),monthsShort:'xan._feb._mar._abr._mai._xuÃ±._xul._ago._set._out._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'domingo_luns_martes_mÃ©rcores_xoves_venres_sÃ¡bado'.split('_'),weekdaysShort:'dom._lun._mar._mÃ©r._xov._ven._sÃ¡b.'.split('_'),weekdaysMin:'do_lu_ma_mÃ©_xo_ve_sÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD/MM/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY H:mm',LLLL:'dddd, D [de] MMMM [de] YYYY H:mm'},calendar:{sameDay:function(){return '[hoxe '+((this.hours()!==1)?'Ã¡s':'Ã¡')+'] LT';},nextDay:function(){return '[maÃ±Ã¡ '+((this.hours()!==1)?'Ã¡s':'Ã¡')+'] LT';},nextWeek:function(){return 'dddd ['+((this.hours()!==1)?'Ã¡s':'a')+'] LT';},lastDay:function(){return '[onte '+((this.hours()!==1)?'Ã¡':'a')+'] LT';},lastWeek:function(){return '[o] dddd [pasado '+((this.hours()!==1)?'Ã¡s':'a')+'] LT';},sameElse:'L'},relativeTime:{future:function(str){if(str.indexOf('un')===0){return 'n'+str;}
return 'en '+str;},past:'hai %s',s:'uns segundos',ss:'%d segundos',m:'un minuto',mm:'%d minutos',h:'unha hora',hh:'%d horas',d:'un dÃa',dd:'%d dÃas',M:'un mes',MM:'%d meses',y:'un ano',yy:'%d anos'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});function processRelativeTime$4(number,withoutSuffix,key,isFuture){var format={'s':['thodde secondanim','thodde second'],'ss':[number+' secondanim',number+' second'],'m':['eka mintan','ek minute'],'mm':[number+' mintanim',number+' mintam'],'h':['eka voran','ek vor'],'hh':[number+' voranim',number+' voram'],'d':['eka disan','ek dis'],'dd':[number+' disanim',number+' dis'],'M':['eka mhoinean','ek mhoino'],'MM':[number+' mhoineanim',number+' mhoine'],'y':['eka vorsan','ek voros'],'yy':[number+' vorsanim',number+' vorsam']};return withoutSuffix?format[key][0]:format[key][1];}
hooks.defineLocale('gom-latn',{months:'Janer_Febrer_Mars_Abril_Mai_Jun_Julai_Agost_Setembr_Otubr_Novembr_Dezembr'.split('_'),monthsShort:'Jan._Feb._Mars_Abr._Mai_Jun_Jul._Ago._Set._Otu._Nov._Dez.'.split('_'),monthsParseExact:true,weekdays:'Aitar_Somar_Mongllar_Budvar_Brestar_Sukrar_Son\'var'.split('_'),weekdaysShort:'Ait._Som._Mon._Bud._Bre._Suk._Son.'.split('_'),weekdaysMin:'Ai_Sm_Mo_Bu_Br_Su_Sn'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'A h:mm [vazta]',LTS:'A h:mm:ss [vazta]',L:'DD-MM-YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY A h:mm [vazta]',LLLL:'dddd, MMMM[achea] Do, YYYY, A h:mm [vazta]',llll:'ddd, D MMM YYYY, A h:mm [vazta]'},calendar:{sameDay:'[Aiz] LT',nextDay:'[Faleam] LT',nextWeek:'[Ieta to] dddd[,] LT',lastDay:'[Kal] LT',lastWeek:'[Fatlo] dddd[,] LT',sameElse:'L'},relativeTime:{future:'%s',past:'%s adim',s:processRelativeTime$4,ss:processRelativeTime$4,m:processRelativeTime$4,mm:processRelativeTime$4,h:processRelativeTime$4,hh:processRelativeTime$4,d:processRelativeTime$4,dd:processRelativeTime$4,M:processRelativeTime$4,MM:processRelativeTime$4,y:processRelativeTime$4,yy:processRelativeTime$4},dayOfMonthOrdinalParse:/\d{1,2}(er)/,ordinal:function(number,period){switch(period){case 'D':return number+'er';default:case 'M':case 'Q':case 'DDD':case 'd':case 'w':case 'W':return number;}},week:{dow:1,doy:4},meridiemParse:/rati|sokalli|donparam|sanje/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='rati'){return hour<4?hour:hour+12;}else if(meridiem==='sokalli'){return hour;}else if(meridiem==='donparam'){return hour>12?hour:hour+12;}else if(meridiem==='sanje'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'rati';}else if(hour<12){return 'sokalli';}else if(hour<16){return 'donparam';}else if(hour<20){return 'sanje';}else{return 'rati';}}});var symbolMap$6={'1':'à«§','2':'à«¨','3':'à«©','4':'à«ª','5':'à««','6':'à«¬','7':'à«','8':'à«®','9':'à«¯','0':'à«¦'},numberMap$5={'à«§':'1','à«¨':'2','à«©':'3','à«ª':'4','à««':'5','à«¬':'6','à«':'7','à«®':'8','à«¯':'9','à«¦':'0'};hooks.defineLocale('gu',{months:'àªœàª¾àª¨à«àª¯à«àª†àª°à«€_àª«à«‡àª¬à«àª°à«àª†àª°à«€_àª®àª¾àª°à«àªš_àªàªªà«àª°àª¿àª²_àª®à«‡_àªœà«‚àª¨_àªœà«àª²àª¾àªˆ_àª‘àª—àª¸à«àªŸ_àª¸àªªà«àªŸà«‡àª®à«àª¬àª°_àª‘àª•à«àªŸà«àª¬àª°_àª¨àªµà«‡àª®à«àª¬àª°_àª¡àª¿àª¸à«‡àª®à«àª¬àª°'.split('_'),monthsShort:'àªœàª¾àª¨à«àª¯à«._àª«à«‡àª¬à«àª°à«._àª®àª¾àª°à«àªš_àªàªªà«àª°àª¿._àª®à«‡_àªœà«‚àª¨_àªœà«àª²àª¾._àª‘àª—._àª¸àªªà«àªŸà«‡._àª‘àª•à«àªŸà«._àª¨àªµà«‡._àª¡àª¿àª¸à«‡.'.split('_'),monthsParseExact:true,weekdays:'àª°àªµàª¿àªµàª¾àª°_àª¸à«‹àª®àªµàª¾àª°_àª®àª‚àª—àª³àªµàª¾àª°_àª¬à«àª§à«àªµàª¾àª°_àª—à«àª°à«àªµàª¾àª°_àª¶à«àª•à«àª°àªµàª¾àª°_àª¶àª¨àª¿àªµàª¾àª°'.split('_'),weekdaysShort:'àª°àªµàª¿_àª¸à«‹àª®_àª®àª‚àª—àª³_àª¬à«àª§à«_àª—à«àª°à«_àª¶à«àª•à«àª°_àª¶àª¨àª¿'.split('_'),weekdaysMin:'àª°_àª¸à«‹_àª®àª‚_àª¬à«_àª—à«_àª¶à«_àª¶'.split('_'),longDateFormat:{LT:'A h:mm àªµàª¾àª—à«àª¯à«‡',LTS:'A h:mm:ss àªµàª¾àª—à«àª¯à«‡',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm àªµàª¾àª—à«àª¯à«‡',LLLL:'dddd, D MMMM YYYY, A h:mm àªµàª¾àª—à«àª¯à«‡'},calendar:{sameDay:'[àª†àªœ] LT',nextDay:'[àª•àª¾àª²à«‡] LT',nextWeek:'dddd, LT',lastDay:'[àª—àª‡àª•àª¾àª²à«‡] LT',lastWeek:'[àªªàª¾àª›àª²àª¾] dddd, LT',sameElse:'L'},relativeTime:{future:'%s àª®àª¾',past:'%s àªªà«‡àª¹àª²àª¾',s:'àª…àª®à«àª• àªªàª³à«‹',ss:'%d àª¸à«‡àª•àª‚àª¡',m:'àªàª• àª®àª¿àª¨àª¿àªŸ',mm:'%d àª®àª¿àª¨àª¿àªŸ',h:'àªàª• àª•àª²àª¾àª•',hh:'%d àª•àª²àª¾àª•',d:'àªàª• àª¦àª¿àªµàª¸',dd:'%d àª¦àª¿àªµàª¸',M:'àªàª• àª®àª¹àª¿àª¨à«‹',MM:'%d àª®àª¹àª¿àª¨à«‹',y:'àªàª• àªµàª°à«àª·',yy:'%d àªµàª°à«àª·'},preparse:function(string){return string.replace(/[à«§à«¨à«©à«ªà««à«¬à«à«®à«¯à«¦]/g,function(match){return numberMap$5[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$6[match];});},meridiemParse:/àª°àª¾àª¤|àª¬àªªà«‹àª°|àª¸àªµàª¾àª°|àª¸àª¾àª‚àªœ/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='àª°àª¾àª¤'){return hour<4?hour:hour+12;}else if(meridiem==='àª¸àªµàª¾àª°'){return hour;}else if(meridiem==='àª¬àªªà«‹àª°'){return hour>=10?hour:hour+12;}else if(meridiem==='àª¸àª¾àª‚àªœ'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'àª°àª¾àª¤';}else if(hour<10){return 'àª¸àªµàª¾àª°';}else if(hour<17){return 'àª¬àªªà«‹àª°';}else if(hour<20){return 'àª¸àª¾àª‚àªœ';}else{return 'àª°àª¾àª¤';}},week:{dow:0,doy:6}});hooks.defineLocale('he',{months:'×™× ×•××¨_×¤×‘×¨×•××¨_×ž×¨×¥_××¤×¨×™×œ_×ž××™_×™×•× ×™_×™×•×œ×™_××•×’×•×¡×˜_×¡×¤×˜×ž×‘×¨_××•×§×˜×•×‘×¨_× ×•×‘×ž×‘×¨_×“×¦×ž×‘×¨'.split('_'),monthsShort:'×™× ×•×³_×¤×‘×¨×³_×ž×¨×¥_××¤×¨×³_×ž××™_×™×•× ×™_×™×•×œ×™_××•×’×³_×¡×¤×˜×³_××•×§×³_× ×•×‘×³_×“×¦×ž×³'.split('_'),weekdays:'×¨××©×•×Ÿ_×©× ×™_×©×œ×™×©×™_×¨×‘×™×¢×™_×—×ž×™×©×™_×©×™×©×™_×©×‘×ª'.split('_'),weekdaysShort:'××³_×‘×³_×’×³_×“×³_×”×³_×•×³_×©×³'.split('_'),weekdaysMin:'×_×‘_×’_×“_×”_×•_×©'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D [×‘]MMMM YYYY',LLL:'D [×‘]MMMM YYYY HH:mm',LLLL:'dddd, D [×‘]MMMM YYYY HH:mm',l:'D/M/YYYY',ll:'D MMM YYYY',lll:'D MMM YYYY HH:mm',llll:'ddd, D MMM YYYY HH:mm'},calendar:{sameDay:'[×”×™×•× ×‘Ö¾]LT',nextDay:'[×ž×—×¨ ×‘Ö¾]LT',nextWeek:'dddd [×‘×©×¢×”] LT',lastDay:'[××ª×ž×•×œ ×‘Ö¾]LT',lastWeek:'[×‘×™×•×] dddd [×”××—×¨×•×Ÿ ×‘×©×¢×”] LT',sameElse:'L'},relativeTime:{future:'×‘×¢×•×“ %s',past:'×œ×¤× ×™ %s',s:'×ž×¡×¤×¨ ×©× ×™×•×ª',ss:'%d ×©× ×™×•×ª',m:'×“×§×”',mm:'%d ×“×§×•×ª',h:'×©×¢×”',hh:function(number){if(number===2){return '×©×¢×ª×™×™×';}
return number+' ×©×¢×•×ª';},d:'×™×•×',dd:function(number){if(number===2){return '×™×•×ž×™×™×';}
return number+' ×™×ž×™×';},M:'×—×•×“×©',MM:function(number){if(number===2){return '×—×•×“×©×™×™×';}
return number+' ×—×•×“×©×™×';},y:'×©× ×”',yy:function(number){if(number===2){return '×©× ×ª×™×™×';}else if(number%10===0&&number!==10){return number+' ×©× ×”';}
return number+' ×©× ×™×';}},meridiemParse:/××—×”"×¦|×œ×¤× ×”"×¦|××—×¨×™ ×”×¦×”×¨×™×™×|×œ×¤× ×™ ×”×¦×”×¨×™×™×|×œ×¤× ×•×ª ×‘×•×§×¨|×‘×‘×•×§×¨|×‘×¢×¨×‘/i,isPM:function(input){return /^(××—×”"×¦|××—×¨×™ ×”×¦×”×¨×™×™×|×‘×¢×¨×‘)$/.test(input);},meridiem:function(hour,minute,isLower){if(hour<5){return '×œ×¤× ×•×ª ×‘×•×§×¨';}else if(hour<10){return '×‘×‘×•×§×¨';}else if(hour<12){return isLower?'×œ×¤× ×”"×¦':'×œ×¤× ×™ ×”×¦×”×¨×™×™×';}else if(hour<18){return isLower?'××—×”"×¦':'××—×¨×™ ×”×¦×”×¨×™×™×';}else{return '×‘×¢×¨×‘';}}});var symbolMap$7={'1':'à¥§','2':'à¥¨','3':'à¥©','4':'à¥ª','5':'à¥«','6':'à¥¬','7':'à¥','8':'à¥®','9':'à¥¯','0':'à¥¦'},numberMap$6={'à¥§':'1','à¥¨':'2','à¥©':'3','à¥ª':'4','à¥«':'5','à¥¬':'6','à¥':'7','à¥®':'8','à¥¯':'9','à¥¦':'0'};hooks.defineLocale('hi',{months:'à¤œà¤¨à¤µà¤°à¥€_à¤«à¤¼à¤°à¤µà¤°à¥€_à¤®à¤¾à¤°à¥à¤š_à¤…à¤ªà¥à¤°à¥ˆà¤²_à¤®à¤ˆ_à¤œà¥‚à¤¨_à¤œà¥à¤²à¤¾à¤ˆ_à¤…à¤—à¤¸à¥à¤¤_à¤¸à¤¿à¤¤à¤®à¥à¤¬à¤°_à¤…à¤•à¥à¤Ÿà¥‚à¤¬à¤°_à¤¨à¤µà¤®à¥à¤¬à¤°_à¤¦à¤¿à¤¸à¤®à¥à¤¬à¤°'.split('_'),monthsShort:'à¤œà¤¨._à¤«à¤¼à¤°._à¤®à¤¾à¤°à¥à¤š_à¤…à¤ªà¥à¤°à¥ˆ._à¤®à¤ˆ_à¤œà¥‚à¤¨_à¤œà¥à¤²._à¤…à¤—._à¤¸à¤¿à¤¤._à¤…à¤•à¥à¤Ÿà¥‚._à¤¨à¤µ._à¤¦à¤¿à¤¸.'.split('_'),monthsParseExact:true,weekdays:'à¤°à¤µà¤¿à¤µà¤¾à¤°_à¤¸à¥‹à¤®à¤µà¤¾à¤°_à¤®à¤‚à¤—à¤²à¤µà¤¾à¤°_à¤¬à¥à¤§à¤µà¤¾à¤°_à¤—à¥à¤°à¥‚à¤µà¤¾à¤°_à¤¶à¥à¤•à¥à¤°à¤µà¤¾à¤°_à¤¶à¤¨à¤¿à¤µà¤¾à¤°'.split('_'),weekdaysShort:'à¤°à¤µà¤¿_à¤¸à¥‹à¤®_à¤®à¤‚à¤—à¤²_à¤¬à¥à¤§_à¤—à¥à¤°à¥‚_à¤¶à¥à¤•à¥à¤°_à¤¶à¤¨à¤¿'.split('_'),weekdaysMin:'à¤°_à¤¸à¥‹_à¤®à¤‚_à¤¬à¥_à¤—à¥_à¤¶à¥_à¤¶'.split('_'),longDateFormat:{LT:'A h:mm à¤¬à¤œà¥‡',LTS:'A h:mm:ss à¤¬à¤œà¥‡',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm à¤¬à¤œà¥‡',LLLL:'dddd, D MMMM YYYY, A h:mm à¤¬à¤œà¥‡'},calendar:{sameDay:'[à¤†à¤œ] LT',nextDay:'[à¤•à¤²] LT',nextWeek:'dddd, LT',lastDay:'[à¤•à¤²] LT',lastWeek:'[à¤ªà¤¿à¤›à¤²à¥‡] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à¤®à¥‡à¤‚',past:'%s à¤ªà¤¹à¤²à¥‡',s:'à¤•à¥à¤› à¤¹à¥€ à¤•à¥à¤·à¤£',ss:'%d à¤¸à¥‡à¤•à¤‚à¤¡',m:'à¤à¤• à¤®à¤¿à¤¨à¤Ÿ',mm:'%d à¤®à¤¿à¤¨à¤Ÿ',h:'à¤à¤• à¤˜à¤‚à¤Ÿà¤¾',hh:'%d à¤˜à¤‚à¤Ÿà¥‡',d:'à¤à¤• à¤¦à¤¿à¤¨',dd:'%d à¤¦à¤¿à¤¨',M:'à¤à¤• à¤®à¤¹à¥€à¤¨à¥‡',MM:'%d à¤®à¤¹à¥€à¤¨à¥‡',y:'à¤à¤• à¤µà¤°à¥à¤·',yy:'%d à¤µà¤°à¥à¤·'},preparse:function(string){return string.replace(/[à¥§à¥¨à¥©à¥ªà¥«à¥¬à¥à¥®à¥¯à¥¦]/g,function(match){return numberMap$6[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$7[match];});},meridiemParse:/à¤°à¤¾à¤¤|à¤¸à¥à¤¬à¤¹|à¤¦à¥‹à¤ªà¤¹à¤°|à¤¶à¤¾à¤®/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à¤°à¤¾à¤¤'){return hour<4?hour:hour+12;}else if(meridiem==='à¤¸à¥à¤¬à¤¹'){return hour;}else if(meridiem==='à¤¦à¥‹à¤ªà¤¹à¤°'){return hour>=10?hour:hour+12;}else if(meridiem==='à¤¶à¤¾à¤®'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à¤°à¤¾à¤¤';}else if(hour<10){return 'à¤¸à¥à¤¬à¤¹';}else if(hour<17){return 'à¤¦à¥‹à¤ªà¤¹à¤°';}else if(hour<20){return 'à¤¶à¤¾à¤®';}else{return 'à¤°à¤¾à¤¤';}},week:{dow:0,doy:6}});function translate$3(number,withoutSuffix,key){var result=number+' ';switch(key){case 'ss':if(number===1){result+='sekunda';}else if(number===2||number===3||number===4){result+='sekunde';}else{result+='sekundi';}
return result;case 'm':return withoutSuffix?'jedna minuta':'jedne minute';case 'mm':if(number===1){result+='minuta';}else if(number===2||number===3||number===4){result+='minute';}else{result+='minuta';}
return result;case 'h':return withoutSuffix?'jedan sat':'jednog sata';case 'hh':if(number===1){result+='sat';}else if(number===2||number===3||number===4){result+='sata';}else{result+='sati';}
return result;case 'dd':if(number===1){result+='dan';}else{result+='dana';}
return result;case 'MM':if(number===1){result+='mjesec';}else if(number===2||number===3||number===4){result+='mjeseca';}else{result+='mjeseci';}
return result;case 'yy':if(number===1){result+='godina';}else if(number===2||number===3||number===4){result+='godine';}else{result+='godina';}
return result;}}
hooks.defineLocale('hr',{months:{format:'sijeÄnja_veljaÄe_oÅ¾ujka_travnja_svibnja_lipnja_srpnja_kolovoza_rujna_listopada_studenoga_prosinca'.split('_'),standalone:'sijeÄanj_veljaÄa_oÅ¾ujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac'.split('_')},monthsShort:'sij._velj._oÅ¾u._tra._svi._lip._srp._kol._ruj._lis._stu._pro.'.split('_'),monthsParseExact:true,weekdays:'nedjelja_ponedjeljak_utorak_srijeda_Äetvrtak_petak_subota'.split('_'),weekdaysShort:'ned._pon._uto._sri._Äet._pet._sub.'.split('_'),weekdaysMin:'ne_po_ut_sr_Äe_pe_su'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[danas u] LT',nextDay:'[sutra u] LT',nextWeek:function(){switch(this.day()){case 0:return '[u] [nedjelju] [u] LT';case 3:return '[u] [srijedu] [u] LT';case 6:return '[u] [subotu] [u] LT';case 1:case 2:case 4:case 5:return '[u] dddd [u] LT';}},lastDay:'[juÄer u] LT',lastWeek:function(){switch(this.day()){case 0:case 3:return '[proÅ¡lu] dddd [u] LT';case 6:return '[proÅ¡le] [subote] [u] LT';case 1:case 2:case 4:case 5:return '[proÅ¡li] dddd [u] LT';}},sameElse:'L'},relativeTime:{future:'za %s',past:'prije %s',s:'par sekundi',ss:translate$3,m:translate$3,mm:translate$3,h:translate$3,hh:translate$3,d:'dan',dd:translate$3,M:'mjesec',MM:translate$3,y:'godinu',yy:translate$3},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});var weekEndings='vasÃ¡rnap hÃ©tfÅ‘n kedden szerdÃ¡n csÃ¼tÃ¶rtÃ¶kÃ¶n pÃ©nteken szombaton'.split(' ');function translate$4(number,withoutSuffix,key,isFuture){var num=number;switch(key){case 's':return(isFuture||withoutSuffix)?'nÃ©hÃ¡ny mÃ¡sodperc':'nÃ©hÃ¡ny mÃ¡sodperce';case 'ss':return num+(isFuture||withoutSuffix)?' mÃ¡sodperc':' mÃ¡sodperce';case 'm':return 'egy'+(isFuture||withoutSuffix?' perc':' perce');case 'mm':return num+(isFuture||withoutSuffix?' perc':' perce');case 'h':return 'egy'+(isFuture||withoutSuffix?' Ã³ra':' Ã³rÃ¡ja');case 'hh':return num+(isFuture||withoutSuffix?' Ã³ra':' Ã³rÃ¡ja');case 'd':return 'egy'+(isFuture||withoutSuffix?' nap':' napja');case 'dd':return num+(isFuture||withoutSuffix?' nap':' napja');case 'M':return 'egy'+(isFuture||withoutSuffix?' hÃ³nap':' hÃ³napja');case 'MM':return num+(isFuture||withoutSuffix?' hÃ³nap':' hÃ³napja');case 'y':return 'egy'+(isFuture||withoutSuffix?' Ã©v':' Ã©ve');case 'yy':return num+(isFuture||withoutSuffix?' Ã©v':' Ã©ve');}
return '';}
function week(isFuture){return(isFuture?'':'[mÃºlt] ')+'['+weekEndings[this.day()]+'] LT[-kor]';}
hooks.defineLocale('hu',{months:'januÃ¡r_februÃ¡r_mÃ¡rcius_Ã¡prilis_mÃ¡jus_jÃºnius_jÃºlius_augusztus_szeptember_oktÃ³ber_november_december'.split('_'),monthsShort:'jan_feb_mÃ¡rc_Ã¡pr_mÃ¡j_jÃºn_jÃºl_aug_szept_okt_nov_dec'.split('_'),weekdays:'vasÃ¡rnap_hÃ©tfÅ‘_kedd_szerda_csÃ¼tÃ¶rtÃ¶k_pÃ©ntek_szombat'.split('_'),weekdaysShort:'vas_hÃ©t_kedd_sze_csÃ¼t_pÃ©n_szo'.split('_'),weekdaysMin:'v_h_k_sze_cs_p_szo'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'YYYY.MM.DD.',LL:'YYYY. MMMM D.',LLL:'YYYY. MMMM D. H:mm',LLLL:'YYYY. MMMM D., dddd H:mm'},meridiemParse:/de|du/i,isPM:function(input){return input.charAt(1).toLowerCase()==='u';},meridiem:function(hours,minutes,isLower){if(hours<12){return isLower===true?'de':'DE';}else{return isLower===true?'du':'DU';}},calendar:{sameDay:'[ma] LT[-kor]',nextDay:'[holnap] LT[-kor]',nextWeek:function(){return week.call(this,true);},lastDay:'[tegnap] LT[-kor]',lastWeek:function(){return week.call(this,false);},sameElse:'L'},relativeTime:{future:'%s mÃºlva',past:'%s',s:translate$4,ss:translate$4,m:translate$4,mm:translate$4,h:translate$4,hh:translate$4,d:translate$4,dd:translate$4,M:translate$4,MM:translate$4,y:translate$4,yy:translate$4},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('hy-am',{months:{format:'Õ°Õ¸Ö‚Õ¶Õ¾Õ¡Ö€Õ«_ÖƒÕ¥Õ¿Ö€Õ¾Õ¡Ö€Õ«_Õ´Õ¡Ö€Õ¿Õ«_Õ¡ÕºÖ€Õ«Õ¬Õ«_Õ´Õ¡ÕµÕ«Õ½Õ«_Õ°Õ¸Ö‚Õ¶Õ«Õ½Õ«_Õ°Õ¸Ö‚Õ¬Õ«Õ½Õ«_Ö…Õ£Õ¸Õ½Õ¿Õ¸Õ½Õ«_Õ½Õ¥ÕºÕ¿Õ¥Õ´Õ¢Õ¥Ö€Õ«_Õ°Õ¸Õ¯Õ¿Õ¥Õ´Õ¢Õ¥Ö€Õ«_Õ¶Õ¸ÕµÕ¥Õ´Õ¢Õ¥Ö€Õ«_Õ¤Õ¥Õ¯Õ¿Õ¥Õ´Õ¢Õ¥Ö€Õ«'.split('_'),standalone:'Õ°Õ¸Ö‚Õ¶Õ¾Õ¡Ö€_ÖƒÕ¥Õ¿Ö€Õ¾Õ¡Ö€_Õ´Õ¡Ö€Õ¿_Õ¡ÕºÖ€Õ«Õ¬_Õ´Õ¡ÕµÕ«Õ½_Õ°Õ¸Ö‚Õ¶Õ«Õ½_Õ°Õ¸Ö‚Õ¬Õ«Õ½_Ö…Õ£Õ¸Õ½Õ¿Õ¸Õ½_Õ½Õ¥ÕºÕ¿Õ¥Õ´Õ¢Õ¥Ö€_Õ°Õ¸Õ¯Õ¿Õ¥Õ´Õ¢Õ¥Ö€_Õ¶Õ¸ÕµÕ¥Õ´Õ¢Õ¥Ö€_Õ¤Õ¥Õ¯Õ¿Õ¥Õ´Õ¢Õ¥Ö€'.split('_')},monthsShort:'Õ°Õ¶Õ¾_ÖƒÕ¿Ö€_Õ´Ö€Õ¿_Õ¡ÕºÖ€_Õ´ÕµÕ½_Õ°Õ¶Õ½_Õ°Õ¬Õ½_Ö…Õ£Õ½_Õ½ÕºÕ¿_Õ°Õ¯Õ¿_Õ¶Õ´Õ¢_Õ¤Õ¯Õ¿'.split('_'),weekdays:'Õ¯Õ«Ö€Õ¡Õ¯Õ«_Õ¥Ö€Õ¯Õ¸Ö‚Õ·Õ¡Õ¢Õ©Õ«_Õ¥Ö€Õ¥Ö„Õ·Õ¡Õ¢Õ©Õ«_Õ¹Õ¸Ö€Õ¥Ö„Õ·Õ¡Õ¢Õ©Õ«_Õ°Õ«Õ¶Õ£Õ·Õ¡Õ¢Õ©Õ«_Õ¸Ö‚Ö€Õ¢Õ¡Õ©_Õ·Õ¡Õ¢Õ¡Õ©'.split('_'),weekdaysShort:'Õ¯Ö€Õ¯_Õ¥Ö€Õ¯_Õ¥Ö€Ö„_Õ¹Ö€Ö„_Õ°Õ¶Õ£_Õ¸Ö‚Ö€Õ¢_Õ·Õ¢Õ©'.split('_'),weekdaysMin:'Õ¯Ö€Õ¯_Õ¥Ö€Õ¯_Õ¥Ö€Ö„_Õ¹Ö€Ö„_Õ°Õ¶Õ£_Õ¸Ö‚Ö€Õ¢_Õ·Õ¢Õ©'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY Õ©.',LLL:'D MMMM YYYY Õ©., HH:mm',LLLL:'dddd, D MMMM YYYY Õ©., HH:mm'},calendar:{sameDay:'[Õ¡ÕµÕ½Ö…Ö€] LT',nextDay:'[Õ¾Õ¡Õ²Õ¨] LT',lastDay:'[Õ¥Ö€Õ¥Õ¯] LT',nextWeek:function(){return 'dddd [Ö…Ö€Õ¨ ÕªÕ¡Õ´Õ¨] LT';},lastWeek:function(){return '[Õ¡Õ¶ÖÕ¡Õ®] dddd [Ö…Ö€Õ¨ ÕªÕ¡Õ´Õ¨] LT';},sameElse:'L'},relativeTime:{future:'%s Õ°Õ¥Õ¿Õ¸',past:'%s Õ¡Õ¼Õ¡Õ»',s:'Õ´Õ« Ö„Õ¡Õ¶Õ« Õ¾Õ¡ÕµÖ€Õ¯ÕµÕ¡Õ¶',ss:'%d Õ¾Õ¡ÕµÖ€Õ¯ÕµÕ¡Õ¶',m:'Ö€Õ¸ÕºÕ¥',mm:'%d Ö€Õ¸ÕºÕ¥',h:'ÕªÕ¡Õ´',hh:'%d ÕªÕ¡Õ´',d:'Ö…Ö€',dd:'%d Ö…Ö€',M:'Õ¡Õ´Õ«Õ½',MM:'%d Õ¡Õ´Õ«Õ½',y:'Õ¿Õ¡Ö€Õ«',yy:'%d Õ¿Õ¡Ö€Õ«'},meridiemParse:/Õ£Õ«Õ·Õ¥Ö€Õ¾Õ¡|Õ¡Õ¼Õ¡Õ¾Õ¸Õ¿Õ¾Õ¡|ÖÕ¥Ö€Õ¥Õ¯Õ¾Õ¡|Õ¥Ö€Õ¥Õ¯Õ¸ÕµÕ¡Õ¶/,isPM:function(input){return /^(ÖÕ¥Ö€Õ¥Õ¯Õ¾Õ¡|Õ¥Ö€Õ¥Õ¯Õ¸ÕµÕ¡Õ¶)$/.test(input);},meridiem:function(hour){if(hour<4){return 'Õ£Õ«Õ·Õ¥Ö€Õ¾Õ¡';}else if(hour<12){return 'Õ¡Õ¼Õ¡Õ¾Õ¸Õ¿Õ¾Õ¡';}else if(hour<17){return 'ÖÕ¥Ö€Õ¥Õ¯Õ¾Õ¡';}else{return 'Õ¥Ö€Õ¥Õ¯Õ¸ÕµÕ¡Õ¶';}},dayOfMonthOrdinalParse:/\d{1,2}|\d{1,2}-(Õ«Õ¶|Ö€Õ¤)/,ordinal:function(number,period){switch(period){case 'DDD':case 'w':case 'W':case 'DDDo':if(number===1){return number+'-Õ«Õ¶';}
return number+'-Ö€Õ¤';default:return number;}},week:{dow:1,doy:7}});hooks.defineLocale('id',{months:'Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_Mei_Jun_Jul_Agt_Sep_Okt_Nov_Des'.split('_'),weekdays:'Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu'.split('_'),weekdaysShort:'Min_Sen_Sel_Rab_Kam_Jum_Sab'.split('_'),weekdaysMin:'Mg_Sn_Sl_Rb_Km_Jm_Sb'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [pukul] HH.mm',LLLL:'dddd, D MMMM YYYY [pukul] HH.mm'},meridiemParse:/pagi|siang|sore|malam/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='pagi'){return hour;}else if(meridiem==='siang'){return hour>=11?hour:hour+12;}else if(meridiem==='sore'||meridiem==='malam'){return hour+12;}},meridiem:function(hours,minutes,isLower){if(hours<11){return 'pagi';}else if(hours<15){return 'siang';}else if(hours<19){return 'sore';}else{return 'malam';}},calendar:{sameDay:'[Hari ini pukul] LT',nextDay:'[Besok pukul] LT',nextWeek:'dddd [pukul] LT',lastDay:'[Kemarin pukul] LT',lastWeek:'dddd [lalu pukul] LT',sameElse:'L'},relativeTime:{future:'dalam %s',past:'%s yang lalu',s:'beberapa detik',ss:'%d detik',m:'semenit',mm:'%d menit',h:'sejam',hh:'%d jam',d:'sehari',dd:'%d hari',M:'sebulan',MM:'%d bulan',y:'setahun',yy:'%d tahun'},week:{dow:1,doy:7}});function plural$2(n){if(n%100===11){return true;}else if(n%10===1){return false;}
return true;}
function translate$5(number,withoutSuffix,key,isFuture){var result=number+' ';switch(key){case 's':return withoutSuffix||isFuture?'nokkrar sekÃºndur':'nokkrum sekÃºndum';case 'ss':if(plural$2(number)){return result+(withoutSuffix||isFuture?'sekÃºndur':'sekÃºndum');}
return result+'sekÃºnda';case 'm':return withoutSuffix?'mÃnÃºta':'mÃnÃºtu';case 'mm':if(plural$2(number)){return result+(withoutSuffix||isFuture?'mÃnÃºtur':'mÃnÃºtum');}else if(withoutSuffix){return result+'mÃnÃºta';}
return result+'mÃnÃºtu';case 'hh':if(plural$2(number)){return result+(withoutSuffix||isFuture?'klukkustundir':'klukkustundum');}
return result+'klukkustund';case 'd':if(withoutSuffix){return 'dagur';}
return isFuture?'dag':'degi';case 'dd':if(plural$2(number)){if(withoutSuffix){return result+'dagar';}
return result+(isFuture?'daga':'dÃ¶gum');}else if(withoutSuffix){return result+'dagur';}
return result+(isFuture?'dag':'degi');case 'M':if(withoutSuffix){return 'mÃ¡nuÃ°ur';}
return isFuture?'mÃ¡nuÃ°':'mÃ¡nuÃ°i';case 'MM':if(plural$2(number)){if(withoutSuffix){return result+'mÃ¡nuÃ°ir';}
return result+(isFuture?'mÃ¡nuÃ°i':'mÃ¡nuÃ°um');}else if(withoutSuffix){return result+'mÃ¡nuÃ°ur';}
return result+(isFuture?'mÃ¡nuÃ°':'mÃ¡nuÃ°i');case 'y':return withoutSuffix||isFuture?'Ã¡r':'Ã¡ri';case 'yy':if(plural$2(number)){return result+(withoutSuffix||isFuture?'Ã¡r':'Ã¡rum');}
return result+(withoutSuffix||isFuture?'Ã¡r':'Ã¡ri');}}
hooks.defineLocale('is',{months:'janÃºar_febrÃºar_mars_aprÃl_maÃ_jÃºnÃ_jÃºlÃ_Ã¡gÃºst_september_oktÃ³ber_nÃ³vember_desember'.split('_'),monthsShort:'jan_feb_mar_apr_maÃ_jÃºn_jÃºl_Ã¡gÃº_sep_okt_nÃ³v_des'.split('_'),weekdays:'sunnudagur_mÃ¡nudagur_Ã¾riÃ°judagur_miÃ°vikudagur_fimmtudagur_fÃ¶studagur_laugardagur'.split('_'),weekdaysShort:'sun_mÃ¡n_Ã¾ri_miÃ°_fim_fÃ¶s_lau'.split('_'),weekdaysMin:'Su_MÃ¡_Ãžr_Mi_Fi_FÃ¶_La'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY [kl.] H:mm',LLLL:'dddd, D. MMMM YYYY [kl.] H:mm'},calendar:{sameDay:'[Ã dag kl.] LT',nextDay:'[Ã¡ morgun kl.] LT',nextWeek:'dddd [kl.] LT',lastDay:'[Ã gÃ¦r kl.] LT',lastWeek:'[sÃÃ°asta] dddd [kl.] LT',sameElse:'L'},relativeTime:{future:'eftir %s',past:'fyrir %s sÃÃ°an',s:translate$5,ss:translate$5,m:translate$5,mm:translate$5,h:'klukkustund',hh:translate$5,d:translate$5,dd:translate$5,M:translate$5,MM:translate$5,y:translate$5,yy:translate$5},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('it-ch',{months:'gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre'.split('_'),monthsShort:'gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic'.split('_'),weekdays:'domenica_lunedÃ¬_martedÃ¬_mercoledÃ¬_giovedÃ¬_venerdÃ¬_sabato'.split('_'),weekdaysShort:'dom_lun_mar_mer_gio_ven_sab'.split('_'),weekdaysMin:'do_lu_ma_me_gi_ve_sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Oggi alle] LT',nextDay:'[Domani alle] LT',nextWeek:'dddd [alle] LT',lastDay:'[Ieri alle] LT',lastWeek:function(){switch(this.day()){case 0:return '[la scorsa] dddd [alle] LT';default:return '[lo scorso] dddd [alle] LT';}},sameElse:'L'},relativeTime:{future:function(s){return((/^[0-9].+$/).test(s)?'tra':'in')+' '+s;},past:'%s fa',s:'alcuni secondi',ss:'%d secondi',m:'un minuto',mm:'%d minuti',h:'un\'ora',hh:'%d ore',d:'un giorno',dd:'%d giorni',M:'un mese',MM:'%d mesi',y:'un anno',yy:'%d anni'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});hooks.defineLocale('it',{months:'gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre'.split('_'),monthsShort:'gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic'.split('_'),weekdays:'domenica_lunedÃ¬_martedÃ¬_mercoledÃ¬_giovedÃ¬_venerdÃ¬_sabato'.split('_'),weekdaysShort:'dom_lun_mar_mer_gio_ven_sab'.split('_'),weekdaysMin:'do_lu_ma_me_gi_ve_sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[Oggi alle] LT',nextDay:'[Domani alle] LT',nextWeek:'dddd [alle] LT',lastDay:'[Ieri alle] LT',lastWeek:function(){switch(this.day()){case 0:return '[la scorsa] dddd [alle] LT';default:return '[lo scorso] dddd [alle] LT';}},sameElse:'L'},relativeTime:{future:function(s){return((/^[0-9].+$/).test(s)?'tra':'in')+' '+s;},past:'%s fa',s:'alcuni secondi',ss:'%d secondi',m:'un minuto',mm:'%d minuti',h:'un\'ora',hh:'%d ore',d:'un giorno',dd:'%d giorni',M:'un mese',MM:'%d mesi',y:'un anno',yy:'%d anni'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});hooks.defineLocale('ja',{months:'ä¸€æœˆ_äºŒæœˆ_ä¸‰æœˆ_å››æœˆ_äº”æœˆ_å…æœˆ_ä¸ƒæœˆ_å…«æœˆ_ä¹æœˆ_åæœˆ_åä¸€æœˆ_åäºŒæœˆ'.split('_'),monthsShort:'1æœˆ_2æœˆ_3æœˆ_4æœˆ_5æœˆ_6æœˆ_7æœˆ_8æœˆ_9æœˆ_10æœˆ_11æœˆ_12æœˆ'.split('_'),weekdays:'æ—¥æ›œæ—¥_æœˆæ›œæ—¥_ç«æ›œæ—¥_æ°´æ›œæ—¥_æœ¨æ›œæ—¥_é‡‘æ›œæ—¥_åœŸæ›œæ—¥'.split('_'),weekdaysShort:'æ—¥_æœˆ_ç«_æ°´_æœ¨_é‡‘_åœŸ'.split('_'),weekdaysMin:'æ—¥_æœˆ_ç«_æ°´_æœ¨_é‡‘_åœŸ'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY/MM/DD',LL:'YYYYå¹´MæœˆDæ—¥',LLL:'YYYYå¹´MæœˆDæ—¥ HH:mm',LLLL:'YYYYå¹´MæœˆDæ—¥ dddd HH:mm',l:'YYYY/MM/DD',ll:'YYYYå¹´MæœˆDæ—¥',lll:'YYYYå¹´MæœˆDæ—¥ HH:mm',llll:'YYYYå¹´MæœˆDæ—¥(ddd) HH:mm'},meridiemParse:/åˆå‰|åˆå¾Œ/i,isPM:function(input){return input==='åˆå¾Œ';},meridiem:function(hour,minute,isLower){if(hour<12){return 'åˆå‰';}else{return 'åˆå¾Œ';}},calendar:{sameDay:'[ä»Šæ—¥] LT',nextDay:'[æ˜Žæ—¥] LT',nextWeek:function(now){if(now.week()<this.week()){return '[æ¥é€±]dddd LT';}else{return 'dddd LT';}},lastDay:'[æ˜¨æ—¥] LT',lastWeek:function(now){if(this.week()<now.week()){return '[å…ˆé€±]dddd LT';}else{return 'dddd LT';}},sameElse:'L'},dayOfMonthOrdinalParse:/\d{1,2}æ—¥/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'æ—¥';default:return number;}},relativeTime:{future:'%så¾Œ',past:'%så‰',s:'æ•°ç§’',ss:'%dç§’',m:'1åˆ†',mm:'%dåˆ†',h:'1æ™‚é–“',hh:'%dæ™‚é–“',d:'1æ—¥',dd:'%dæ—¥',M:'1ãƒ¶æœˆ',MM:'%dãƒ¶æœˆ',y:'1å¹´',yy:'%då¹´'}});hooks.defineLocale('jv',{months:'Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember'.split('_'),monthsShort:'Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des'.split('_'),weekdays:'Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu'.split('_'),weekdaysShort:'Min_Sen_Sel_Reb_Kem_Jem_Sep'.split('_'),weekdaysMin:'Mg_Sn_Sl_Rb_Km_Jm_Sp'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [pukul] HH.mm',LLLL:'dddd, D MMMM YYYY [pukul] HH.mm'},meridiemParse:/enjing|siyang|sonten|ndalu/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='enjing'){return hour;}else if(meridiem==='siyang'){return hour>=11?hour:hour+12;}else if(meridiem==='sonten'||meridiem==='ndalu'){return hour+12;}},meridiem:function(hours,minutes,isLower){if(hours<11){return 'enjing';}else if(hours<15){return 'siyang';}else if(hours<19){return 'sonten';}else{return 'ndalu';}},calendar:{sameDay:'[Dinten puniko pukul] LT',nextDay:'[Mbenjang pukul] LT',nextWeek:'dddd [pukul] LT',lastDay:'[Kala wingi pukul] LT',lastWeek:'dddd [kepengker pukul] LT',sameElse:'L'},relativeTime:{future:'wonten ing %s',past:'%s ingkang kepengker',s:'sawetawis detik',ss:'%d detik',m:'setunggal menit',mm:'%d menit',h:'setunggal jam',hh:'%d jam',d:'sedinten',dd:'%d dinten',M:'sewulan',MM:'%d wulan',y:'setaun',yy:'%d taun'},week:{dow:1,doy:7}});hooks.defineLocale('ka',{months:{standalone:'áƒ˜áƒáƒœáƒ•áƒáƒ áƒ˜_áƒ—áƒ”áƒ‘áƒ”áƒ áƒ•áƒáƒšáƒ˜_áƒ›áƒáƒ áƒ¢áƒ˜_áƒáƒžáƒ áƒ˜áƒšáƒ˜_áƒ›áƒáƒ˜áƒ¡áƒ˜_áƒ˜áƒ•áƒœáƒ˜áƒ¡áƒ˜_áƒ˜áƒ•áƒšáƒ˜áƒ¡áƒ˜_áƒáƒ’áƒ•áƒ˜áƒ¡áƒ¢áƒ_áƒ¡áƒ”áƒ¥áƒ¢áƒ”áƒ›áƒ‘áƒ”áƒ áƒ˜_áƒáƒ¥áƒ¢áƒáƒ›áƒ‘áƒ”áƒ áƒ˜_áƒœáƒáƒ”áƒ›áƒ‘áƒ”áƒ áƒ˜_áƒ“áƒ”áƒ™áƒ”áƒ›áƒ‘áƒ”áƒ áƒ˜'.split('_'),format:'áƒ˜áƒáƒœáƒ•áƒáƒ áƒ¡_áƒ—áƒ”áƒ‘áƒ”áƒ áƒ•áƒáƒšáƒ¡_áƒ›áƒáƒ áƒ¢áƒ¡_áƒáƒžáƒ áƒ˜áƒšáƒ˜áƒ¡_áƒ›áƒáƒ˜áƒ¡áƒ¡_áƒ˜áƒ•áƒœáƒ˜áƒ¡áƒ¡_áƒ˜áƒ•áƒšáƒ˜áƒ¡áƒ¡_áƒáƒ’áƒ•áƒ˜áƒ¡áƒ¢áƒ¡_áƒ¡áƒ”áƒ¥áƒ¢áƒ”áƒ›áƒ‘áƒ”áƒ áƒ¡_áƒáƒ¥áƒ¢áƒáƒ›áƒ‘áƒ”áƒ áƒ¡_áƒœáƒáƒ”áƒ›áƒ‘áƒ”áƒ áƒ¡_áƒ“áƒ”áƒ™áƒ”áƒ›áƒ‘áƒ”áƒ áƒ¡'.split('_')},monthsShort:'áƒ˜áƒáƒœ_áƒ—áƒ”áƒ‘_áƒ›áƒáƒ _áƒáƒžáƒ _áƒ›áƒáƒ˜_áƒ˜áƒ•áƒœ_áƒ˜áƒ•áƒš_áƒáƒ’áƒ•_áƒ¡áƒ”áƒ¥_áƒáƒ¥áƒ¢_áƒœáƒáƒ”_áƒ“áƒ”áƒ™'.split('_'),weekdays:{standalone:'áƒ™áƒ•áƒ˜áƒ áƒ_áƒáƒ áƒ¨áƒáƒ‘áƒáƒ—áƒ˜_áƒ¡áƒáƒ›áƒ¨áƒáƒ‘áƒáƒ—áƒ˜_áƒáƒ—áƒ®áƒ¨áƒáƒ‘áƒáƒ—áƒ˜_áƒ®áƒ£áƒ—áƒ¨áƒáƒ‘áƒáƒ—áƒ˜_áƒžáƒáƒ áƒáƒ¡áƒ™áƒ”áƒ•áƒ˜_áƒ¨áƒáƒ‘áƒáƒ—áƒ˜'.split('_'),format:'áƒ™áƒ•áƒ˜áƒ áƒáƒ¡_áƒáƒ áƒ¨áƒáƒ‘áƒáƒ—áƒ¡_áƒ¡áƒáƒ›áƒ¨áƒáƒ‘áƒáƒ—áƒ¡_áƒáƒ—áƒ®áƒ¨áƒáƒ‘áƒáƒ—áƒ¡_áƒ®áƒ£áƒ—áƒ¨áƒáƒ‘áƒáƒ—áƒ¡_áƒžáƒáƒ áƒáƒ¡áƒ™áƒ”áƒ•áƒ¡_áƒ¨áƒáƒ‘áƒáƒ—áƒ¡'.split('_'),isFormat:/(áƒ¬áƒ˜áƒœáƒ|áƒ¨áƒ”áƒ›áƒ“áƒ”áƒ’)/},weekdaysShort:'áƒ™áƒ•áƒ˜_áƒáƒ áƒ¨_áƒ¡áƒáƒ›_áƒáƒ—áƒ®_áƒ®áƒ£áƒ—_áƒžáƒáƒ _áƒ¨áƒáƒ‘'.split('_'),weekdaysMin:'áƒ™áƒ•_áƒáƒ _áƒ¡áƒ_áƒáƒ—_áƒ®áƒ£_áƒžáƒ_áƒ¨áƒ'.split('_'),longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendar:{sameDay:'[áƒ“áƒ¦áƒ”áƒ¡] LT[-áƒ–áƒ”]',nextDay:'[áƒ®áƒ•áƒáƒš] LT[-áƒ–áƒ”]',lastDay:'[áƒ’áƒ£áƒ¨áƒ˜áƒœ] LT[-áƒ–áƒ”]',nextWeek:'[áƒ¨áƒ”áƒ›áƒ“áƒ”áƒ’] dddd LT[-áƒ–áƒ”]',lastWeek:'[áƒ¬áƒ˜áƒœáƒ] dddd LT-áƒ–áƒ”',sameElse:'L'},relativeTime:{future:function(s){return(/(áƒ¬áƒáƒ›áƒ˜|áƒ¬áƒ£áƒ—áƒ˜|áƒ¡áƒáƒáƒ—áƒ˜|áƒ¬áƒ”áƒšáƒ˜)/).test(s)?s.replace(/áƒ˜$/,'áƒ¨áƒ˜'):s+'áƒ¨áƒ˜';},past:function(s){if((/(áƒ¬áƒáƒ›áƒ˜|áƒ¬áƒ£áƒ—áƒ˜|áƒ¡áƒáƒáƒ—áƒ˜|áƒ“áƒ¦áƒ”|áƒ—áƒ•áƒ”)/).test(s)){return s.replace(/(áƒ˜|áƒ”)$/,'áƒ˜áƒ¡ áƒ¬áƒ˜áƒœ');}
if((/áƒ¬áƒ”áƒšáƒ˜/).test(s)){return s.replace(/áƒ¬áƒ”áƒšáƒ˜$/,'áƒ¬áƒšáƒ˜áƒ¡ áƒ¬áƒ˜áƒœ');}},s:'áƒ áƒáƒ›áƒ“áƒ”áƒœáƒ˜áƒ›áƒ” áƒ¬áƒáƒ›áƒ˜',ss:'%d áƒ¬áƒáƒ›áƒ˜',m:'áƒ¬áƒ£áƒ—áƒ˜',mm:'%d áƒ¬áƒ£áƒ—áƒ˜',h:'áƒ¡áƒáƒáƒ—áƒ˜',hh:'%d áƒ¡áƒáƒáƒ—áƒ˜',d:'áƒ“áƒ¦áƒ”',dd:'%d áƒ“áƒ¦áƒ”',M:'áƒ—áƒ•áƒ”',MM:'%d áƒ—áƒ•áƒ”',y:'áƒ¬áƒ”áƒšáƒ˜',yy:'%d áƒ¬áƒ”áƒšáƒ˜'},dayOfMonthOrdinalParse:/0|1-áƒšáƒ˜|áƒ›áƒ”-\d{1,2}|\d{1,2}-áƒ”/,ordinal:function(number){if(number===0){return number;}
if(number===1){return number+'-áƒšáƒ˜';}
if((number<20)||(number<=100&&(number%20===0))||(number%100===0)){return 'áƒ›áƒ”-'+number;}
return number+'-áƒ”';},week:{dow:1,doy:7}});var suffixes$1={0:'-ÑˆÑ–',1:'-ÑˆÑ–',2:'-ÑˆÑ–',3:'-ÑˆÑ–',4:'-ÑˆÑ–',5:'-ÑˆÑ–',6:'-ÑˆÑ‹',7:'-ÑˆÑ–',8:'-ÑˆÑ–',9:'-ÑˆÑ‹',10:'-ÑˆÑ‹',20:'-ÑˆÑ‹',30:'-ÑˆÑ‹',40:'-ÑˆÑ‹',50:'-ÑˆÑ–',60:'-ÑˆÑ‹',70:'-ÑˆÑ–',80:'-ÑˆÑ–',90:'-ÑˆÑ‹',100:'-ÑˆÑ–'};hooks.defineLocale('kk',{months:'Ò›Ð°Ò£Ñ‚Ð°Ñ€_Ð°Ò›Ð¿Ð°Ð½_Ð½Ð°ÑƒÑ€Ñ‹Ð·_ÑÓ™ÑƒÑ–Ñ€_Ð¼Ð°Ð¼Ñ‹Ñ€_Ð¼Ð°ÑƒÑÑ‹Ð¼_ÑˆÑ–Ð»Ð´Ðµ_Ñ‚Ð°Ð¼Ñ‹Ð·_Ò›Ñ‹Ñ€ÐºÒ¯Ð¹ÐµÐº_Ò›Ð°Ð·Ð°Ð½_Ò›Ð°Ñ€Ð°ÑˆÐ°_Ð¶ÐµÐ»Ñ‚Ð¾Ò›ÑÐ°Ð½'.split('_'),monthsShort:'Ò›Ð°Ò£_Ð°Ò›Ð¿_Ð½Ð°Ñƒ_ÑÓ™Ñƒ_Ð¼Ð°Ð¼_Ð¼Ð°Ñƒ_ÑˆÑ–Ð»_Ñ‚Ð°Ð¼_Ò›Ñ‹Ñ€_Ò›Ð°Ð·_Ò›Ð°Ñ€_Ð¶ÐµÐ»'.split('_'),weekdays:'Ð¶ÐµÐºÑÐµÐ½Ð±Ñ–_Ð´Ò¯Ð¹ÑÐµÐ½Ð±Ñ–_ÑÐµÐ¹ÑÐµÐ½Ð±Ñ–_ÑÓ™Ñ€ÑÐµÐ½Ð±Ñ–_Ð±ÐµÐ¹ÑÐµÐ½Ð±Ñ–_Ð¶Ò±Ð¼Ð°_ÑÐµÐ½Ð±Ñ–'.split('_'),weekdaysShort:'Ð¶ÐµÐº_Ð´Ò¯Ð¹_ÑÐµÐ¹_ÑÓ™Ñ€_Ð±ÐµÐ¹_Ð¶Ò±Ð¼_ÑÐµÐ½'.split('_'),weekdaysMin:'Ð¶Ðº_Ð´Ð¹_ÑÐ¹_ÑÑ€_Ð±Ð¹_Ð¶Ð¼_ÑÐ½'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ð‘Ò¯Ð³Ñ–Ð½ ÑÐ°Ò“Ð°Ñ‚] LT',nextDay:'[Ð•Ñ€Ñ‚ÐµÒ£ ÑÐ°Ò“Ð°Ñ‚] LT',nextWeek:'dddd [ÑÐ°Ò“Ð°Ñ‚] LT',lastDay:'[ÐšÐµÑˆÐµ ÑÐ°Ò“Ð°Ñ‚] LT',lastWeek:'[Ó¨Ñ‚ÐºÐµÐ½ Ð°Ð¿Ñ‚Ð°Ð½Ñ‹Ò£] dddd [ÑÐ°Ò“Ð°Ñ‚] LT',sameElse:'L'},relativeTime:{future:'%s Ñ–ÑˆÑ–Ð½Ð´Ðµ',past:'%s Ð±Ò±Ñ€Ñ‹Ð½',s:'Ð±Ñ–Ñ€Ð½ÐµÑˆÐµ ÑÐµÐºÑƒÐ½Ð´',ss:'%d ÑÐµÐºÑƒÐ½Ð´',m:'Ð±Ñ–Ñ€ Ð¼Ð¸Ð½ÑƒÑ‚',mm:'%d Ð¼Ð¸Ð½ÑƒÑ‚',h:'Ð±Ñ–Ñ€ ÑÐ°Ò“Ð°Ñ‚',hh:'%d ÑÐ°Ò“Ð°Ñ‚',d:'Ð±Ñ–Ñ€ ÐºÒ¯Ð½',dd:'%d ÐºÒ¯Ð½',M:'Ð±Ñ–Ñ€ Ð°Ð¹',MM:'%d Ð°Ð¹',y:'Ð±Ñ–Ñ€ Ð¶Ñ‹Ð»',yy:'%d Ð¶Ñ‹Ð»'},dayOfMonthOrdinalParse:/\d{1,2}-(ÑˆÑ–|ÑˆÑ‹)/,ordinal:function(number){var a=number%10,b=number>=100?100:null;return number+(suffixes$1[number]||suffixes$1[a]||suffixes$1[b]);},week:{dow:1,doy:7}});var symbolMap$8={'1':'áŸ¡','2':'áŸ¢','3':'áŸ£','4':'áŸ¤','5':'áŸ¥','6':'áŸ¦','7':'áŸ§','8':'áŸ¨','9':'áŸ©','0':'áŸ '},numberMap$7={'áŸ¡':'1','áŸ¢':'2','áŸ£':'3','áŸ¤':'4','áŸ¥':'5','áŸ¦':'6','áŸ§':'7','áŸ¨':'8','áŸ©':'9','áŸ ':'0'};hooks.defineLocale('km',{months:'áž˜áž€ážšáž¶_áž€áž»áž˜áŸ’áž—áŸˆ_áž˜áž¸áž“áž¶_áž˜áŸážŸáž¶_áž§ážŸáž—áž¶_áž˜áž·ážáž»áž“áž¶_áž€áž€áŸ’áž€ážŠáž¶_ážŸáž¸áž áž¶_áž€áž‰áŸ’áž‰áž¶_ážáž»áž›áž¶_ážœáž·áž…áŸ’áž†áž·áž€áž¶_áž’áŸ’áž“áž¼'.split('_'),monthsShort:'áž˜áž€ážšáž¶_áž€áž»áž˜áŸ’áž—áŸˆ_áž˜áž¸áž“áž¶_áž˜áŸážŸáž¶_áž§ážŸáž—áž¶_áž˜áž·ážáž»áž“áž¶_áž€áž€áŸ’áž€ážŠáž¶_ážŸáž¸áž áž¶_áž€áž‰áŸ’áž‰áž¶_ážáž»áž›áž¶_ážœáž·áž…áŸ’áž†áž·áž€áž¶_áž’áŸ’áž“áž¼'.split('_'),weekdays:'áž¢áž¶áž‘áž·ážáŸ’áž™_áž…áŸáž“áŸ’áž‘_áž¢áž„áŸ’áž‚áž¶ážš_áž–áž»áž’_áž–áŸ’ážšáž ážŸáŸ’áž”ážáž·áŸ_ážŸáž»áž€áŸ’ážš_ážŸáŸ…ážšáŸ'.split('_'),weekdaysShort:'áž¢áž¶_áž…_áž¢_áž–_áž–áŸ’ážš_ážŸáž»_ážŸ'.split('_'),weekdaysMin:'áž¢áž¶_áž…_áž¢_áž–_áž–áŸ’ážš_ážŸáž»_ážŸ'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},meridiemParse:/áž–áŸ’ážšáž¹áž€|áž›áŸ’áž„áž¶áž…/,isPM:function(input){return input==='áž›áŸ’áž„áž¶áž…';},meridiem:function(hour,minute,isLower){if(hour<12){return 'áž–áŸ’ážšáž¹áž€';}else{return 'áž›áŸ’áž„áž¶áž…';}},calendar:{sameDay:'[ážáŸ’áž„áŸƒáž“áŸáŸ‡ áž˜áŸ‰áŸ„áž„] LT',nextDay:'[ážŸáŸ’áž¢áŸ‚áž€ áž˜áŸ‰áŸ„áž„] LT',nextWeek:'dddd [áž˜áŸ‰áŸ„áž„] LT',lastDay:'[áž˜áŸ’ážŸáž·áž›áž˜áž·áž‰ áž˜áŸ‰áŸ„áž„] LT',lastWeek:'dddd [ážŸáž”áŸ’ážáž¶áž áŸáž˜áž»áž“] [áž˜áŸ‰áŸ„áž„] LT',sameElse:'L'},relativeTime:{future:'%sáž‘áŸ€áž',past:'%sáž˜áž»áž“',s:'áž”áŸ‰áž»áž“áŸ’áž˜áž¶áž“ážœáž·áž“áž¶áž‘áž¸',ss:'%d ážœáž·áž“áž¶áž‘áž¸',m:'áž˜áž½áž™áž“áž¶áž‘áž¸',mm:'%d áž“áž¶áž‘áž¸',h:'áž˜áž½áž™áž˜áŸ‰áŸ„áž„',hh:'%d áž˜áŸ‰áŸ„áž„',d:'áž˜áž½áž™ážáŸ’áž„áŸƒ',dd:'%d ážáŸ’áž„áŸƒ',M:'áž˜áž½áž™ážáŸ‚',MM:'%d ážáŸ‚',y:'áž˜áž½áž™áž†áŸ’áž“áž¶áŸ†',yy:'%d áž†áŸ’áž“áž¶áŸ†'},dayOfMonthOrdinalParse:/áž‘áž¸\d{1,2}/,ordinal:'áž‘áž¸%d',preparse:function(string){return string.replace(/[áŸ¡áŸ¢áŸ£áŸ¤áŸ¥áŸ¦áŸ§áŸ¨áŸ©áŸ ]/g,function(match){return numberMap$7[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$8[match];});},week:{dow:1,doy:4}});var symbolMap$9={'1':'à³§','2':'à³¨','3':'à³©','4':'à³ª','5':'à³«','6':'à³¬','7':'à³','8':'à³®','9':'à³¯','0':'à³¦'},numberMap$8={'à³§':'1','à³¨':'2','à³©':'3','à³ª':'4','à³«':'5','à³¬':'6','à³':'7','à³®':'8','à³¯':'9','à³¦':'0'};hooks.defineLocale('kn',{months:'à²œà²¨à²µà²°à²¿_à²«à³†à²¬à³à²°à²µà²°à²¿_à²®à²¾à²°à³à²šà³_à²à²ªà³à²°à²¿à²²à³_à²®à³‡_à²œà³‚à²¨à³_à²œà³à²²à³ˆ_à²†à²—à²¸à³à²Ÿà³_à²¸à³†à²ªà³à²Ÿà³†à²‚à²¬à²°à³_à²…à²•à³à²Ÿà³‹à²¬à²°à³_à²¨à²µà³†à²‚à²¬à²°à³_à²¡à²¿à²¸à³†à²‚à²¬à²°à³'.split('_'),monthsShort:'à²œà²¨_à²«à³†à²¬à³à²°_à²®à²¾à²°à³à²šà³_à²à²ªà³à²°à²¿à²²à³_à²®à³‡_à²œà³‚à²¨à³_à²œà³à²²à³ˆ_à²†à²—à²¸à³à²Ÿà³_à²¸à³†à²ªà³à²Ÿà³†à²‚_à²…à²•à³à²Ÿà³‹_à²¨à²µà³†à²‚_à²¡à²¿à²¸à³†à²‚'.split('_'),monthsParseExact:true,weekdays:'à²à²¾à²¨à³à²µà²¾à²°_à²¸à³‹à²®à²µà²¾à²°_à²®à²‚à²—à²³à²µà²¾à²°_à²¬à³à²§à²µà²¾à²°_à²—à³à²°à³à²µà²¾à²°_à²¶à³à²•à³à²°à²µà²¾à²°_à²¶à²¨à²¿à²µà²¾à²°'.split('_'),weekdaysShort:'à²à²¾à²¨à³_à²¸à³‹à²®_à²®à²‚à²—à²³_à²¬à³à²§_à²—à³à²°à³_à²¶à³à²•à³à²°_à²¶à²¨à²¿'.split('_'),weekdaysMin:'à²à²¾_à²¸à³‹_à²®à²‚_à²¬à³_à²—à³_à²¶à³_à²¶'.split('_'),longDateFormat:{LT:'A h:mm',LTS:'A h:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm',LLLL:'dddd, D MMMM YYYY, A h:mm'},calendar:{sameDay:'[à²‡à²‚à²¦à³] LT',nextDay:'[à²¨à²¾à²³à³†] LT',nextWeek:'dddd, LT',lastDay:'[à²¨à²¿à²¨à³à²¨à³†] LT',lastWeek:'[à²•à³Šà²¨à³†à²¯] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à²¨à²‚à²¤à²°',past:'%s à²¹à²¿à²‚à²¦à³†',s:'à²•à³†à²²à²µà³ à²•à³à²·à²£à²—à²³à³',ss:'%d à²¸à³†à²•à³†à²‚à²¡à³à²—à²³à³',m:'à²’à²‚à²¦à³ à²¨à²¿à²®à²¿à²·',mm:'%d à²¨à²¿à²®à²¿à²·',h:'à²’à²‚à²¦à³ à²—à²‚à²Ÿà³†',hh:'%d à²—à²‚à²Ÿà³†',d:'à²’à²‚à²¦à³ à²¦à²¿à²¨',dd:'%d à²¦à²¿à²¨',M:'à²’à²‚à²¦à³ à²¤à²¿à²‚à²—à²³à³',MM:'%d à²¤à²¿à²‚à²—à²³à³',y:'à²’à²‚à²¦à³ à²µà²°à³à²·',yy:'%d à²µà²°à³à²·'},preparse:function(string){return string.replace(/[à³§à³¨à³©à³ªà³«à³¬à³à³®à³¯à³¦]/g,function(match){return numberMap$8[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$9[match];});},meridiemParse:/à²°à²¾à²¤à³à²°à²¿|à²¬à³†à²³à²¿à²—à³à²—à³†|à²®à²§à³à²¯à²¾à²¹à³à²¨|à²¸à²‚à²œà³†/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à²°à²¾à²¤à³à²°à²¿'){return hour<4?hour:hour+12;}else if(meridiem==='à²¬à³†à²³à²¿à²—à³à²—à³†'){return hour;}else if(meridiem==='à²®à²§à³à²¯à²¾à²¹à³à²¨'){return hour>=10?hour:hour+12;}else if(meridiem==='à²¸à²‚à²œà³†'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à²°à²¾à²¤à³à²°à²¿';}else if(hour<10){return 'à²¬à³†à²³à²¿à²—à³à²—à³†';}else if(hour<17){return 'à²®à²§à³à²¯à²¾à²¹à³à²¨';}else if(hour<20){return 'à²¸à²‚à²œà³†';}else{return 'à²°à²¾à²¤à³à²°à²¿';}},dayOfMonthOrdinalParse:/\d{1,2}(à²¨à³‡)/,ordinal:function(number){return number+'à²¨à³‡';},week:{dow:0,doy:6}});hooks.defineLocale('ko',{months:'1ì›”_2ì›”_3ì›”_4ì›”_5ì›”_6ì›”_7ì›”_8ì›”_9ì›”_10ì›”_11ì›”_12ì›”'.split('_'),monthsShort:'1ì›”_2ì›”_3ì›”_4ì›”_5ì›”_6ì›”_7ì›”_8ì›”_9ì›”_10ì›”_11ì›”_12ì›”'.split('_'),weekdays:'ì¼ìš”ì¼_ì›”ìš”ì¼_í™”ìš”ì¼_ìˆ˜ìš”ì¼_ëª©ìš”ì¼_ê¸ˆìš”ì¼_í† ìš”ì¼'.split('_'),weekdaysShort:'ì¼_ì›”_í™”_ìˆ˜_ëª©_ê¸ˆ_í† '.split('_'),weekdaysMin:'ì¼_ì›”_í™”_ìˆ˜_ëª©_ê¸ˆ_í† '.split('_'),longDateFormat:{LT:'A h:mm',LTS:'A h:mm:ss',L:'YYYY.MM.DD.',LL:'YYYYë…„ MMMM Dì¼',LLL:'YYYYë…„ MMMM Dì¼ A h:mm',LLLL:'YYYYë…„ MMMM Dì¼ dddd A h:mm',l:'YYYY.MM.DD.',ll:'YYYYë…„ MMMM Dì¼',lll:'YYYYë…„ MMMM Dì¼ A h:mm',llll:'YYYYë…„ MMMM Dì¼ dddd A h:mm'},calendar:{sameDay:'ì˜¤ëŠ˜ LT',nextDay:'ë‚´ì¼ LT',nextWeek:'dddd LT',lastDay:'ì–´ì œ LT',lastWeek:'ì§€ë‚œì£¼ dddd LT',sameElse:'L'},relativeTime:{future:'%s í›„',past:'%s ì „',s:'ëª‡ ì´ˆ',ss:'%dì´ˆ',m:'1ë¶„',mm:'%dë¶„',h:'í•œ ì‹œê°„',hh:'%dì‹œê°„',d:'í•˜ë£¨',dd:'%dì¼',M:'í•œ ë‹¬',MM:'%dë‹¬',y:'ì¼ ë…„',yy:'%dë…„'},dayOfMonthOrdinalParse:/\d{1,2}(ì¼|ì›”|ì£¼)/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'ì¼';case 'M':return number+'ì›”';case 'w':case 'W':return number+'ì£¼';default:return number;}},meridiemParse:/ì˜¤ì „|ì˜¤í›„/,isPM:function(token){return token==='ì˜¤í›„';},meridiem:function(hour,minute,isUpper){return hour<12?'ì˜¤ì „':'ì˜¤í›„';}});var symbolMap$a={'1':'Ù¡','2':'Ù¢','3':'Ù£','4':'Ù¤','5':'Ù¥','6':'Ù¦','7':'Ù§','8':'Ù¨','9':'Ù©','0':'Ù '},numberMap$9={'Ù¡':'1','Ù¢':'2','Ù£':'3','Ù¤':'4','Ù¥':'5','Ù¦':'6','Ù§':'7','Ù¨':'8','Ù©':'9','Ù ':'0'},months$7=['Ú©Ø§Ù†ÙˆÙ†ÛŒ Ø¯ÙˆÙˆÛ•Ù…','Ø´ÙˆØ¨Ø§Øª','Ø¦Ø§Ø²Ø§Ø±','Ù†ÛŒØ³Ø§Ù†','Ø¦Ø§ÛŒØ§Ø±','ØÙˆØ²Û•ÛŒØ±Ø§Ù†','ØªÛ•Ù…Ù…ÙˆØ²','Ø¦Ø§Ø¨','Ø¦Û•ÛŒÙ„ÙˆÙˆÙ„','ØªØ´Ø±ÛŒÙ†ÛŒ ÛŒÛ•ÙƒÛ•Ù…','ØªØ´Ø±ÛŒÙ†ÛŒ Ø¯ÙˆÙˆÛ•Ù…','ÙƒØ§Ù†ÙˆÙ†ÛŒ ÛŒÛ•Ú©Û•Ù…'];hooks.defineLocale('ku',{months:months$7,monthsShort:months$7,weekdays:'ÛŒÙ‡â€ŒÙƒØ´Ù‡â€ŒÙ…Ù…Ù‡â€Œ_Ø¯ÙˆÙˆØ´Ù‡â€ŒÙ…Ù…Ù‡â€Œ_Ø³ÛŽØ´Ù‡â€ŒÙ…Ù…Ù‡â€Œ_Ú†ÙˆØ§Ø±Ø´Ù‡â€ŒÙ…Ù…Ù‡â€Œ_Ù¾ÛŽÙ†Ø¬Ø´Ù‡â€ŒÙ…Ù…Ù‡â€Œ_Ù‡Ù‡â€ŒÛŒÙ†ÛŒ_Ø´Ù‡â€ŒÙ…Ù…Ù‡â€Œ'.split('_'),weekdaysShort:'ÛŒÙ‡â€ŒÙƒØ´Ù‡â€ŒÙ…_Ø¯ÙˆÙˆØ´Ù‡â€ŒÙ…_Ø³ÛŽØ´Ù‡â€ŒÙ…_Ú†ÙˆØ§Ø±Ø´Ù‡â€ŒÙ…_Ù¾ÛŽÙ†Ø¬Ø´Ù‡â€ŒÙ…_Ù‡Ù‡â€ŒÛŒÙ†ÛŒ_Ø´Ù‡â€ŒÙ…Ù…Ù‡â€Œ'.split('_'),weekdaysMin:'ÛŒ_Ø¯_Ø³_Ú†_Ù¾_Ù‡_Ø´'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},meridiemParse:/Ø¦ÛŽÙˆØ§Ø±Ù‡â€Œ|Ø¨Ù‡â€ŒÛŒØ§Ù†ÛŒ/,isPM:function(input){return /Ø¦ÛŽÙˆØ§Ø±Ù‡â€Œ/.test(input);},meridiem:function(hour,minute,isLower){if(hour<12){return 'Ø¨Ù‡â€ŒÛŒØ§Ù†ÛŒ';}else{return 'Ø¦ÛŽÙˆØ§Ø±Ù‡â€Œ';}},calendar:{sameDay:'[Ø¦Ù‡â€ŒÙ…Ø±Û† ÙƒØ§ØªÚ˜Ù…ÛŽØ±] LT',nextDay:'[Ø¨Ù‡â€ŒÛŒØ§Ù†ÛŒ ÙƒØ§ØªÚ˜Ù…ÛŽØ±] LT',nextWeek:'dddd [ÙƒØ§ØªÚ˜Ù…ÛŽØ±] LT',lastDay:'[Ø¯ÙˆÛŽÙ†ÛŽ ÙƒØ§ØªÚ˜Ù…ÛŽØ±] LT',lastWeek:'dddd [ÙƒØ§ØªÚ˜Ù…ÛŽØ±] LT',sameElse:'L'},relativeTime:{future:'Ù„Ù‡â€Œ %s',past:'%s',s:'Ú†Ù‡â€ŒÙ†Ø¯ Ú†Ø±ÙƒÙ‡â€ŒÛŒÙ‡â€ŒÙƒ',ss:'Ú†Ø±ÙƒÙ‡â€Œ %d',m:'ÛŒÙ‡â€ŒÙƒ Ø®ÙˆÙ„Ù‡â€ŒÙƒ',mm:'%d Ø®ÙˆÙ„Ù‡â€ŒÙƒ',h:'ÛŒÙ‡â€ŒÙƒ ÙƒØ§ØªÚ˜Ù…ÛŽØ±',hh:'%d ÙƒØ§ØªÚ˜Ù…ÛŽØ±',d:'ÛŒÙ‡â€ŒÙƒ Ú•Û†Ú˜',dd:'%d Ú•Û†Ú˜',M:'ÛŒÙ‡â€ŒÙƒ Ù…Ø§Ù†Ú¯',MM:'%d Ù…Ø§Ù†Ú¯',y:'ÛŒÙ‡â€ŒÙƒ Ø³Ø§Úµ',yy:'%d Ø³Ø§Úµ'},preparse:function(string){return string.replace(/[Ù¡Ù¢Ù£Ù¤Ù¥Ù¦Ù§Ù¨Ù©Ù ]/g,function(match){return numberMap$9[match];}).replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$a[match];}).replace(/,/g,'ØŒ');},week:{dow:6,doy:12}});var suffixes$2={0:'-Ñ‡Ò¯',1:'-Ñ‡Ð¸',2:'-Ñ‡Ð¸',3:'-Ñ‡Ò¯',4:'-Ñ‡Ò¯',5:'-Ñ‡Ð¸',6:'-Ñ‡Ñ‹',7:'-Ñ‡Ð¸',8:'-Ñ‡Ð¸',9:'-Ñ‡Ñƒ',10:'-Ñ‡Ñƒ',20:'-Ñ‡Ñ‹',30:'-Ñ‡Ñƒ',40:'-Ñ‡Ñ‹',50:'-Ñ‡Ò¯',60:'-Ñ‡Ñ‹',70:'-Ñ‡Ð¸',80:'-Ñ‡Ð¸',90:'-Ñ‡Ñƒ',100:'-Ñ‡Ò¯'};hooks.defineLocale('ky',{months:'ÑÐ½Ð²Ð°Ñ€ÑŒ_Ñ„ÐµÐ²Ñ€Ð°Ð»ÑŒ_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€ÐµÐ»ÑŒ_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½ÑŒ_Ð¸ÑŽÐ»ÑŒ_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ½Ñ‚ÑÐ±Ñ€ÑŒ_Ð¾ÐºÑ‚ÑÐ±Ñ€ÑŒ_Ð½Ð¾ÑÐ±Ñ€ÑŒ_Ð´ÐµÐºÐ°Ð±Ñ€ÑŒ'.split('_'),monthsShort:'ÑÐ½Ð²_Ñ„ÐµÐ²_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½ÑŒ_Ð¸ÑŽÐ»ÑŒ_Ð°Ð²Ð³_ÑÐµÐ½_Ð¾ÐºÑ‚_Ð½Ð¾Ñ_Ð´ÐµÐº'.split('_'),weekdays:'Ð–ÐµÐºÑˆÐµÐ¼Ð±Ð¸_Ð”Ò¯Ð¹ÑˆÓ©Ð¼Ð±Ò¯_Ð¨ÐµÐ¹ÑˆÐµÐ¼Ð±Ð¸_Ð¨Ð°Ñ€ÑˆÐµÐ¼Ð±Ð¸_Ð‘ÐµÐ¹ÑˆÐµÐ¼Ð±Ð¸_Ð–ÑƒÐ¼Ð°_Ð˜ÑˆÐµÐ¼Ð±Ð¸'.split('_'),weekdaysShort:'Ð–ÐµÐº_Ð”Ò¯Ð¹_Ð¨ÐµÐ¹_Ð¨Ð°Ñ€_Ð‘ÐµÐ¹_Ð–ÑƒÐ¼_Ð˜ÑˆÐµ'.split('_'),weekdaysMin:'Ð–Ðº_Ð”Ð¹_Ð¨Ð¹_Ð¨Ñ€_Ð‘Ð¹_Ð–Ð¼_Ð˜Ñˆ'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ð‘Ò¯Ð³Ò¯Ð½ ÑÐ°Ð°Ñ‚] LT',nextDay:'[ÐÑ€Ñ‚ÐµÒ£ ÑÐ°Ð°Ñ‚] LT',nextWeek:'dddd [ÑÐ°Ð°Ñ‚] LT',lastDay:'[ÐšÐµÑ‡ÑÑ ÑÐ°Ð°Ñ‚] LT',lastWeek:'[Ó¨Ñ‚ÐºÓ©Ð½ Ð°Ð¿Ñ‚Ð°Ð½Ñ‹Ð½] dddd [ÐºÒ¯Ð½Ò¯] [ÑÐ°Ð°Ñ‚] LT',sameElse:'L'},relativeTime:{future:'%s Ð¸Ñ‡Ð¸Ð½Ð´Ðµ',past:'%s Ð¼ÑƒÑ€ÑƒÐ½',s:'Ð±Ð¸Ñ€Ð½ÐµÑ‡Ðµ ÑÐµÐºÑƒÐ½Ð´',ss:'%d ÑÐµÐºÑƒÐ½Ð´',m:'Ð±Ð¸Ñ€ Ð¼Ò¯Ð½Ó©Ñ‚',mm:'%d Ð¼Ò¯Ð½Ó©Ñ‚',h:'Ð±Ð¸Ñ€ ÑÐ°Ð°Ñ‚',hh:'%d ÑÐ°Ð°Ñ‚',d:'Ð±Ð¸Ñ€ ÐºÒ¯Ð½',dd:'%d ÐºÒ¯Ð½',M:'Ð±Ð¸Ñ€ Ð°Ð¹',MM:'%d Ð°Ð¹',y:'Ð±Ð¸Ñ€ Ð¶Ñ‹Ð»',yy:'%d Ð¶Ñ‹Ð»'},dayOfMonthOrdinalParse:/\d{1,2}-(Ñ‡Ð¸|Ñ‡Ñ‹|Ñ‡Ò¯|Ñ‡Ñƒ)/,ordinal:function(number){var a=number%10,b=number>=100?100:null;return number+(suffixes$2[number]||suffixes$2[a]||suffixes$2[b]);},week:{dow:1,doy:7}});function processRelativeTime$5(number,withoutSuffix,key,isFuture){var format={'m':['eng Minutt','enger Minutt'],'h':['eng Stonn','enger Stonn'],'d':['een Dag','engem Dag'],'M':['ee Mount','engem Mount'],'y':['ee Joer','engem Joer']};return withoutSuffix?format[key][0]:format[key][1];}
function processFutureTime(string){var number=string.substr(0,string.indexOf(' '));if(eifelerRegelAppliesToNumber(number)){return 'a '+string;}
return 'an '+string;}
function processPastTime(string){var number=string.substr(0,string.indexOf(' '));if(eifelerRegelAppliesToNumber(number)){return 'viru '+string;}
return 'virun '+string;}
function eifelerRegelAppliesToNumber(number){number=parseInt(number,10);if(isNaN(number)){return false;}
if(number<0){return true;}else if(number<10){if(4<=number&&number<=7){return true;}
return false;}else if(number<100){var lastDigit=number%10,firstDigit=number/10;if(lastDigit===0){return eifelerRegelAppliesToNumber(firstDigit);}
return eifelerRegelAppliesToNumber(lastDigit);}else if(number<10000){while(number>=10){number=number/10;}
return eifelerRegelAppliesToNumber(number);}else{number=number/1000;return eifelerRegelAppliesToNumber(number);}}
hooks.defineLocale('lb',{months:'Januar_Februar_MÃ¤erz_AbrÃ«ll_Mee_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),monthsShort:'Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),monthsParseExact:true,weekdays:'Sonndeg_MÃ©indeg_DÃ«nschdeg_MÃ«ttwoch_Donneschdeg_Freideg_Samschdeg'.split('_'),weekdaysShort:'So._MÃ©._DÃ«._MÃ«._Do._Fr._Sa.'.split('_'),weekdaysMin:'So_MÃ©_DÃ«_MÃ«_Do_Fr_Sa'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm [Auer]',LTS:'H:mm:ss [Auer]',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm [Auer]',LLLL:'dddd, D. MMMM YYYY H:mm [Auer]'},calendar:{sameDay:'[Haut um] LT',sameElse:'L',nextDay:'[Muer um] LT',nextWeek:'dddd [um] LT',lastDay:'[GÃ«schter um] LT',lastWeek:function(){switch(this.day()){case 2:case 4:return '[Leschten] dddd [um] LT';default:return '[Leschte] dddd [um] LT';}}},relativeTime:{future:processFutureTime,past:processPastTime,s:'e puer Sekonnen',ss:'%d Sekonnen',m:processRelativeTime$5,mm:'%d Minutten',h:processRelativeTime$5,hh:'%d Stonnen',d:processRelativeTime$5,dd:'%d Deeg',M:processRelativeTime$5,MM:'%d MÃ©int',y:processRelativeTime$5,yy:'%d Joer'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('lo',{months:'àº¡àº±àº‡àºàºàº™_àºàº¸àº¡àºžàº²_àº¡àºµàº™àº²_à»€àº¡àºªàº²_àºžàº¶àº”àºªàº°àºžàº²_àº¡àº´àº–àº¸àº™àº²_àºà»àº¥àº°àºàº»àº”_àºªàº´àº‡àº«àº²_àºàº±àº™àºàº²_àº•àº¸àº¥àº²_àºžàº°àºˆàº´àº_àº—àº±àº™àº§àº²'.split('_'),monthsShort:'àº¡àº±àº‡àºàºàº™_àºàº¸àº¡àºžàº²_àº¡àºµàº™àº²_à»€àº¡àºªàº²_àºžàº¶àº”àºªàº°àºžàº²_àº¡àº´àº–àº¸àº™àº²_àºà»àº¥àº°àºàº»àº”_àºªàº´àº‡àº«àº²_àºàº±àº™àºàº²_àº•àº¸àº¥àº²_àºžàº°àºˆàº´àº_àº—àº±àº™àº§àº²'.split('_'),weekdays:'àºàº²àº—àº´àº”_àºˆàº±àº™_àºàº±àº‡àº„àº²àº™_àºžàº¸àº”_àºžàº°àº«àº±àº”_àºªàº¸àº_à»€àºªàº»àº²'.split('_'),weekdaysShort:'àº—àº´àº”_àºˆàº±àº™_àºàº±àº‡àº„àº²àº™_àºžàº¸àº”_àºžàº°àº«àº±àº”_àºªàº¸àº_à»€àºªàº»àº²'.split('_'),weekdaysMin:'àº—_àºˆ_àºàº„_àºž_àºžàº«_àºªàº_àºª'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'àº§àº±àº™dddd D MMMM YYYY HH:mm'},meridiemParse:/àº•àºàº™à»€àºŠàº»à»‰àº²|àº•àºàº™à»àº¥àº‡/,isPM:function(input){return input==='àº•àºàº™à»àº¥àº‡';},meridiem:function(hour,minute,isLower){if(hour<12){return 'àº•àºàº™à»€àºŠàº»à»‰àº²';}else{return 'àº•àºàº™à»àº¥àº‡';}},calendar:{sameDay:'[àº¡àº·à»‰àº™àºµà»‰à»€àº§àº¥àº²] LT',nextDay:'[àº¡àº·à»‰àºàº·à»ˆàº™à»€àº§àº¥àº²] LT',nextWeek:'[àº§àº±àº™]dddd[à»œà»‰àº²à»€àº§àº¥àº²] LT',lastDay:'[àº¡àº·à»‰àº§àº²àº™àº™àºµà»‰à»€àº§àº¥àº²] LT',lastWeek:'[àº§àº±àº™]dddd[à»àº¥à»‰àº§àº™àºµà»‰à»€àº§àº¥àº²] LT',sameElse:'L'},relativeTime:{future:'àºàºµàº %s',past:'%sàºœà»ˆàº²àº™àº¡àº²',s:'àºšà»à»ˆà»€àº—àº»à»ˆàº²à»ƒàº”àº§àº´àº™àº²àº—àºµ',ss:'%d àº§àº´àº™àº²àº—àºµ',m:'1 àº™àº²àº—àºµ',mm:'%d àº™àº²àº—àºµ',h:'1 àºŠàº»à»ˆàº§à»‚àº¡àº‡',hh:'%d àºŠàº»à»ˆàº§à»‚àº¡àº‡',d:'1 àº¡àº·à»‰',dd:'%d àº¡àº·à»‰',M:'1 à»€àº”àº·àºàº™',MM:'%d à»€àº”àº·àºàº™',y:'1 àº›àºµ',yy:'%d àº›àºµ'},dayOfMonthOrdinalParse:/(àº—àºµà»ˆ)\d{1,2}/,ordinal:function(number){return 'àº—àºµà»ˆ'+number;}});var units={'ss':'sekundÄ—_sekundÅ¾iÅ³_sekundes','m':'minutÄ—_minutÄ—s_minutÄ™','mm':'minutÄ—s_minuÄiÅ³_minutes','h':'valanda_valandos_valandÄ…','hh':'valandos_valandÅ³_valandas','d':'diena_dienos_dienÄ…','dd':'dienos_dienÅ³_dienas','M':'mÄ—nuo_mÄ—nesio_mÄ—nesÄ¯','MM':'mÄ—nesiai_mÄ—nesiÅ³_mÄ—nesius','y':'metai_metÅ³_metus','yy':'metai_metÅ³_metus'};function translateSeconds(number,withoutSuffix,key,isFuture){if(withoutSuffix){return 'kelios sekundÄ—s';}else{return isFuture?'keliÅ³ sekundÅ¾iÅ³':'kelias sekundes';}}
function translateSingular(number,withoutSuffix,key,isFuture){return withoutSuffix?forms(key)[0]:(isFuture?forms(key)[1]:forms(key)[2]);}
function special(number){return number%10===0||(number>10&&number<20);}
function forms(key){return units[key].split('_');}
function translate$6(number,withoutSuffix,key,isFuture){var result=number+' ';if(number===1){return result+translateSingular(number,withoutSuffix,key[0],isFuture);}else if(withoutSuffix){return result+(special(number)?forms(key)[1]:forms(key)[0]);}else{if(isFuture){return result+forms(key)[1];}else{return result+(special(number)?forms(key)[1]:forms(key)[2]);}}}
hooks.defineLocale('lt',{months:{format:'sausio_vasario_kovo_balandÅ¾io_geguÅ¾Ä—s_birÅ¾elio_liepos_rugpjÅ«Äio_rugsÄ—jo_spalio_lapkriÄio_gruodÅ¾io'.split('_'),standalone:'sausis_vasaris_kovas_balandis_geguÅ¾Ä—_birÅ¾elis_liepa_rugpjÅ«tis_rugsÄ—jis_spalis_lapkritis_gruodis'.split('_'),isFormat:/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|MMMM?(\[[^\[\]]*\]|\s)+D[oD]?/},monthsShort:'sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd'.split('_'),weekdays:{format:'sekmadienÄ¯_pirmadienÄ¯_antradienÄ¯_treÄiadienÄ¯_ketvirtadienÄ¯_penktadienÄ¯_Å¡eÅ¡tadienÄ¯'.split('_'),standalone:'sekmadienis_pirmadienis_antradienis_treÄiadienis_ketvirtadienis_penktadienis_Å¡eÅ¡tadienis'.split('_'),isFormat:/dddd HH:mm/},weekdaysShort:'Sek_Pir_Ant_Tre_Ket_Pen_Å eÅ¡'.split('_'),weekdaysMin:'S_P_A_T_K_Pn_Å '.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'YYYY [m.] MMMM D [d.]',LLL:'YYYY [m.] MMMM D [d.], HH:mm [val.]',LLLL:'YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]',l:'YYYY-MM-DD',ll:'YYYY [m.] MMMM D [d.]',lll:'YYYY [m.] MMMM D [d.], HH:mm [val.]',llll:'YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]'},calendar:{sameDay:'[Å iandien] LT',nextDay:'[Rytoj] LT',nextWeek:'dddd LT',lastDay:'[Vakar] LT',lastWeek:'[PraÄ—jusÄ¯] dddd LT',sameElse:'L'},relativeTime:{future:'po %s',past:'prieÅ¡ %s',s:translateSeconds,ss:translate$6,m:translateSingular,mm:translate$6,h:translateSingular,hh:translate$6,d:translateSingular,dd:translate$6,M:translateSingular,MM:translate$6,y:translateSingular,yy:translate$6},dayOfMonthOrdinalParse:/\d{1,2}-oji/,ordinal:function(number){return number+'-oji';},week:{dow:1,doy:4}});var units$1={'ss':'sekundes_sekundÄ“m_sekunde_sekundes'.split('_'),'m':'minÅ«tes_minÅ«tÄ“m_minÅ«te_minÅ«tes'.split('_'),'mm':'minÅ«tes_minÅ«tÄ“m_minÅ«te_minÅ«tes'.split('_'),'h':'stundas_stundÄm_stunda_stundas'.split('_'),'hh':'stundas_stundÄm_stunda_stundas'.split('_'),'d':'dienas_dienÄm_diena_dienas'.split('_'),'dd':'dienas_dienÄm_diena_dienas'.split('_'),'M':'mÄ“neÅ¡a_mÄ“neÅ¡iem_mÄ“nesis_mÄ“neÅ¡i'.split('_'),'MM':'mÄ“neÅ¡a_mÄ“neÅ¡iem_mÄ“nesis_mÄ“neÅ¡i'.split('_'),'y':'gada_gadiem_gads_gadi'.split('_'),'yy':'gada_gadiem_gads_gadi'.split('_')};function format$1(forms,number,withoutSuffix){if(withoutSuffix){return number%10===1&&number%100!==11?forms[2]:forms[3];}else{return number%10===1&&number%100!==11?forms[0]:forms[1];}}
function relativeTimeWithPlural$1(number,withoutSuffix,key){return number+' '+format$1(units$1[key],number,withoutSuffix);}
function relativeTimeWithSingular(number,withoutSuffix,key){return format$1(units$1[key],number,withoutSuffix);}
function relativeSeconds(number,withoutSuffix){return withoutSuffix?'daÅ¾as sekundes':'daÅ¾Äm sekundÄ“m';}
hooks.defineLocale('lv',{months:'janvÄris_februÄris_marts_aprÄ«lis_maijs_jÅ«nijs_jÅ«lijs_augusts_septembris_oktobris_novembris_decembris'.split('_'),monthsShort:'jan_feb_mar_apr_mai_jÅ«n_jÅ«l_aug_sep_okt_nov_dec'.split('_'),weekdays:'svÄ“tdiena_pirmdiena_otrdiena_treÅ¡diena_ceturtdiena_piektdiena_sestdiena'.split('_'),weekdaysShort:'Sv_P_O_T_C_Pk_S'.split('_'),weekdaysMin:'Sv_P_O_T_C_Pk_S'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY.',LL:'YYYY. [gada] D. MMMM',LLL:'YYYY. [gada] D. MMMM, HH:mm',LLLL:'YYYY. [gada] D. MMMM, dddd, HH:mm'},calendar:{sameDay:'[Å odien pulksten] LT',nextDay:'[RÄ«t pulksten] LT',nextWeek:'dddd [pulksten] LT',lastDay:'[Vakar pulksten] LT',lastWeek:'[PagÄjuÅ¡Ä] dddd [pulksten] LT',sameElse:'L'},relativeTime:{future:'pÄ“c %s',past:'pirms %s',s:relativeSeconds,ss:relativeTimeWithPlural$1,m:relativeTimeWithSingular,mm:relativeTimeWithPlural$1,h:relativeTimeWithSingular,hh:relativeTimeWithPlural$1,d:relativeTimeWithSingular,dd:relativeTimeWithPlural$1,M:relativeTimeWithSingular,MM:relativeTimeWithPlural$1,y:relativeTimeWithSingular,yy:relativeTimeWithPlural$1},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var translator={words:{ss:['sekund','sekunda','sekundi'],m:['jedan minut','jednog minuta'],mm:['minut','minuta','minuta'],h:['jedan sat','jednog sata'],hh:['sat','sata','sati'],dd:['dan','dana','dana'],MM:['mjesec','mjeseca','mjeseci'],yy:['godina','godine','godina']},correctGrammaticalCase:function(number,wordKey){return number===1?wordKey[0]:(number>=2&&number<=4?wordKey[1]:wordKey[2]);},translate:function(number,withoutSuffix,key){var wordKey=translator.words[key];if(key.length===1){return withoutSuffix?wordKey[0]:wordKey[1];}else{return number+' '+translator.correctGrammaticalCase(number,wordKey);}}};hooks.defineLocale('me',{months:'januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar'.split('_'),monthsShort:'jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'nedjelja_ponedjeljak_utorak_srijeda_Äetvrtak_petak_subota'.split('_'),weekdaysShort:'ned._pon._uto._sri._Äet._pet._sub.'.split('_'),weekdaysMin:'ne_po_ut_sr_Äe_pe_su'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[danas u] LT',nextDay:'[sjutra u] LT',nextWeek:function(){switch(this.day()){case 0:return '[u] [nedjelju] [u] LT';case 3:return '[u] [srijedu] [u] LT';case 6:return '[u] [subotu] [u] LT';case 1:case 2:case 4:case 5:return '[u] dddd [u] LT';}},lastDay:'[juÄe u] LT',lastWeek:function(){var lastWeekDays=['[proÅ¡le] [nedjelje] [u] LT','[proÅ¡log] [ponedjeljka] [u] LT','[proÅ¡log] [utorka] [u] LT','[proÅ¡le] [srijede] [u] LT','[proÅ¡log] [Äetvrtka] [u] LT','[proÅ¡log] [petka] [u] LT','[proÅ¡le] [subote] [u] LT'];return lastWeekDays[this.day()];},sameElse:'L'},relativeTime:{future:'za %s',past:'prije %s',s:'nekoliko sekundi',ss:translator.translate,m:translator.translate,mm:translator.translate,h:translator.translate,hh:translator.translate,d:'dan',dd:translator.translate,M:'mjesec',MM:translator.translate,y:'godinu',yy:translator.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});hooks.defineLocale('mi',{months:'Kohi-tÄte_Hui-tanguru_PoutÅ«-te-rangi_Paenga-whÄwhÄ_Haratua_Pipiri_HÅngoingoi_Here-turi-kÅkÄ_Mahuru_Whiringa-Ä-nuku_Whiringa-Ä-rangi_Hakihea'.split('_'),monthsShort:'Kohi_Hui_Pou_Pae_Hara_Pipi_HÅngoi_Here_Mahu_Whi-nu_Whi-ra_Haki'.split('_'),monthsRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsStrictRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsShortRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,monthsShortStrictRegex:/(?:['a-z\u0101\u014D\u016B]+\-?){1,2}/i,weekdays:'RÄtapu_Mane_TÅ«rei_Wenerei_TÄite_Paraire_HÄtarei'.split('_'),weekdaysShort:'Ta_Ma_TÅ«_We_TÄi_Pa_HÄ'.split('_'),weekdaysMin:'Ta_Ma_TÅ«_We_TÄi_Pa_HÄ'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [i] HH:mm',LLLL:'dddd, D MMMM YYYY [i] HH:mm'},calendar:{sameDay:'[i teie mahana, i] LT',nextDay:'[apopo i] LT',nextWeek:'dddd [i] LT',lastDay:'[inanahi i] LT',lastWeek:'dddd [whakamutunga i] LT',sameElse:'L'},relativeTime:{future:'i roto i %s',past:'%s i mua',s:'te hÄ“kona ruarua',ss:'%d hÄ“kona',m:'he meneti',mm:'%d meneti',h:'te haora',hh:'%d haora',d:'he ra',dd:'%d ra',M:'he marama',MM:'%d marama',y:'he tau',yy:'%d tau'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});hooks.defineLocale('mk',{months:'Ñ˜Ð°Ð½ÑƒÐ°Ñ€Ð¸_Ñ„ÐµÐ²Ñ€ÑƒÐ°Ñ€Ð¸_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€Ð¸Ð»_Ð¼Ð°Ñ˜_Ñ˜ÑƒÐ½Ð¸_Ñ˜ÑƒÐ»Ð¸_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ¿Ñ‚ÐµÐ¼Ð²Ñ€Ð¸_Ð¾ÐºÑ‚Ð¾Ð¼Ð²Ñ€Ð¸_Ð½Ð¾ÐµÐ¼Ð²Ñ€Ð¸_Ð´ÐµÐºÐµÐ¼Ð²Ñ€Ð¸'.split('_'),monthsShort:'Ñ˜Ð°Ð½_Ñ„ÐµÐ²_Ð¼Ð°Ñ€_Ð°Ð¿Ñ€_Ð¼Ð°Ñ˜_Ñ˜ÑƒÐ½_Ñ˜ÑƒÐ»_Ð°Ð²Ð³_ÑÐµÐ¿_Ð¾ÐºÑ‚_Ð½Ð¾Ðµ_Ð´ÐµÐº'.split('_'),weekdays:'Ð½ÐµÐ´ÐµÐ»Ð°_Ð¿Ð¾Ð½ÐµÐ´ÐµÐ»Ð½Ð¸Ðº_Ð²Ñ‚Ð¾Ñ€Ð½Ð¸Ðº_ÑÑ€ÐµÐ´Ð°_Ñ‡ÐµÑ‚Ð²Ñ€Ñ‚Ð¾Ðº_Ð¿ÐµÑ‚Ð¾Ðº_ÑÐ°Ð±Ð¾Ñ‚Ð°'.split('_'),weekdaysShort:'Ð½ÐµÐ´_Ð¿Ð¾Ð½_Ð²Ñ‚Ð¾_ÑÑ€Ðµ_Ñ‡ÐµÑ‚_Ð¿ÐµÑ‚_ÑÐ°Ð±'.split('_'),weekdaysMin:'Ð½e_Ð¿o_Ð²Ñ‚_ÑÑ€_Ñ‡Ðµ_Ð¿Ðµ_Ña'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'D.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY H:mm',LLLL:'dddd, D MMMM YYYY H:mm'},calendar:{sameDay:'[Ð”ÐµÐ½ÐµÑ Ð²Ð¾] LT',nextDay:'[Ð£Ñ‚Ñ€Ðµ Ð²Ð¾] LT',nextWeek:'[Ð’Ð¾] dddd [Ð²Ð¾] LT',lastDay:'[Ð’Ñ‡ÐµÑ€Ð° Ð²Ð¾] LT',lastWeek:function(){switch(this.day()){case 0:case 3:case 6:return '[Ð˜Ð·Ð¼Ð¸Ð½Ð°Ñ‚Ð°Ñ‚Ð°] dddd [Ð²Ð¾] LT';case 1:case 2:case 4:case 5:return '[Ð˜Ð·Ð¼Ð¸Ð½Ð°Ñ‚Ð¸Ð¾Ñ‚] dddd [Ð²Ð¾] LT';}},sameElse:'L'},relativeTime:{future:'Ð¿Ð¾ÑÐ»Ðµ %s',past:'Ð¿Ñ€ÐµÐ´ %s',s:'Ð½ÐµÐºÐ¾Ð»ÐºÑƒ ÑÐµÐºÑƒÐ½Ð´Ð¸',ss:'%d ÑÐµÐºÑƒÐ½Ð´Ð¸',m:'Ð¼Ð¸Ð½ÑƒÑ‚Ð°',mm:'%d Ð¼Ð¸Ð½ÑƒÑ‚Ð¸',h:'Ñ‡Ð°Ñ',hh:'%d Ñ‡Ð°ÑÐ°',d:'Ð´ÐµÐ½',dd:'%d Ð´ÐµÐ½Ð°',M:'Ð¼ÐµÑÐµÑ†',MM:'%d Ð¼ÐµÑÐµÑ†Ð¸',y:'Ð³Ð¾Ð´Ð¸Ð½Ð°',yy:'%d Ð³Ð¾Ð´Ð¸Ð½Ð¸'},dayOfMonthOrdinalParse:/\d{1,2}-(ÐµÐ²|ÐµÐ½|Ñ‚Ð¸|Ð²Ð¸|Ñ€Ð¸|Ð¼Ð¸)/,ordinal:function(number){var lastDigit=number%10,last2Digits=number%100;if(number===0){return number+'-ÐµÐ²';}else if(last2Digits===0){return number+'-ÐµÐ½';}else if(last2Digits>10&&last2Digits<20){return number+'-Ñ‚Ð¸';}else if(lastDigit===1){return number+'-Ð²Ð¸';}else if(lastDigit===2){return number+'-Ñ€Ð¸';}else if(lastDigit===7||lastDigit===8){return number+'-Ð¼Ð¸';}else{return number+'-Ñ‚Ð¸';}},week:{dow:1,doy:7}});hooks.defineLocale('ml',{months:'à´œà´¨àµà´µà´°à´¿_à´«àµ†à´¬àµà´°àµà´µà´°à´¿_à´®à´¾àµ¼à´šàµà´šàµ_à´à´ªàµà´°à´¿àµ½_à´®àµ‡à´¯àµ_à´œàµ‚àµº_à´œàµ‚à´²àµˆ_à´“à´—à´¸àµà´±àµà´±àµ_à´¸àµ†à´ªàµà´±àµà´±à´‚à´¬àµ¼_à´’à´•àµà´Ÿàµ‹à´¬àµ¼_à´¨à´µà´‚à´¬àµ¼_à´¡à´¿à´¸à´‚à´¬àµ¼'.split('_'),monthsShort:'à´œà´¨àµ._à´«àµ†à´¬àµà´°àµ._à´®à´¾àµ¼._à´à´ªàµà´°à´¿._à´®àµ‡à´¯àµ_à´œàµ‚àµº_à´œàµ‚à´²àµˆ._à´“à´—._à´¸àµ†à´ªàµà´±àµà´±._à´’à´•àµà´Ÿàµ‹._à´¨à´µà´‚._à´¡à´¿à´¸à´‚.'.split('_'),monthsParseExact:true,weekdays:'à´žà´¾à´¯à´±à´¾à´´àµà´š_à´¤à´¿à´™àµà´•à´³à´¾à´´àµà´š_à´šàµŠà´µàµà´µà´¾à´´àµà´š_à´¬àµà´§à´¨à´¾à´´àµà´š_à´µàµà´¯à´¾à´´à´¾à´´àµà´š_à´µàµ†à´³àµà´³à´¿à´¯à´¾à´´àµà´š_à´¶à´¨à´¿à´¯à´¾à´´àµà´š'.split('_'),weekdaysShort:'à´žà´¾à´¯àµ¼_à´¤à´¿à´™àµà´•àµ¾_à´šàµŠà´µàµà´µ_à´¬àµà´§àµ»_à´µàµà´¯à´¾à´´à´‚_à´µàµ†à´³àµà´³à´¿_à´¶à´¨à´¿'.split('_'),weekdaysMin:'à´žà´¾_à´¤à´¿_à´šàµŠ_à´¬àµ_à´µàµà´¯à´¾_à´µàµ†_à´¶'.split('_'),longDateFormat:{LT:'A h:mm -à´¨àµ',LTS:'A h:mm:ss -à´¨àµ',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm -à´¨àµ',LLLL:'dddd, D MMMM YYYY, A h:mm -à´¨àµ'},calendar:{sameDay:'[à´‡à´¨àµà´¨àµ] LT',nextDay:'[à´¨à´¾à´³àµ†] LT',nextWeek:'dddd, LT',lastDay:'[à´‡à´¨àµà´¨à´²àµ†] LT',lastWeek:'[à´•à´´à´¿à´žàµà´ž] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à´•à´´à´¿à´žàµà´žàµ',past:'%s à´®àµàµ»à´ªàµ',s:'à´…àµ½à´ª à´¨à´¿à´®à´¿à´·à´™àµà´™àµ¾',ss:'%d à´¸àµ†à´•àµà´•àµ»à´¡àµ',m:'à´’à´°àµ à´®à´¿à´¨à´¿à´±àµà´±àµ',mm:'%d à´®à´¿à´¨à´¿à´±àµà´±àµ',h:'à´’à´°àµ à´®à´£à´¿à´•àµà´•àµ‚àµ¼',hh:'%d à´®à´£à´¿à´•àµà´•àµ‚àµ¼',d:'à´’à´°àµ à´¦à´¿à´µà´¸à´‚',dd:'%d à´¦à´¿à´µà´¸à´‚',M:'à´’à´°àµ à´®à´¾à´¸à´‚',MM:'%d à´®à´¾à´¸à´‚',y:'à´’à´°àµ à´µàµ¼à´·à´‚',yy:'%d à´µàµ¼à´·à´‚'},meridiemParse:/à´°à´¾à´¤àµà´°à´¿|à´°à´¾à´µà´¿à´²àµ†|à´‰à´šàµà´š à´•à´´à´¿à´žàµà´žàµ|à´µàµˆà´•àµà´¨àµà´¨àµ‡à´°à´‚|à´°à´¾à´¤àµà´°à´¿/i,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if((meridiem==='à´°à´¾à´¤àµà´°à´¿'&&hour>=4)||meridiem==='à´‰à´šàµà´š à´•à´´à´¿à´žàµà´žàµ'||meridiem==='à´µàµˆà´•àµà´¨àµà´¨àµ‡à´°à´‚'){return hour+12;}else{return hour;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à´°à´¾à´¤àµà´°à´¿';}else if(hour<12){return 'à´°à´¾à´µà´¿à´²àµ†';}else if(hour<17){return 'à´‰à´šàµà´š à´•à´´à´¿à´žàµà´žàµ';}else if(hour<20){return 'à´µàµˆà´•àµà´¨àµà´¨àµ‡à´°à´‚';}else{return 'à´°à´¾à´¤àµà´°à´¿';}}});function translate$7(number,withoutSuffix,key,isFuture){switch(key){case 's':return withoutSuffix?'Ñ…ÑÐ´Ñ…ÑÐ½ ÑÐµÐºÑƒÐ½Ð´':'Ñ…ÑÐ´Ñ…ÑÐ½ ÑÐµÐºÑƒÐ½Ð´Ñ‹Ð½';case 'ss':return number+(withoutSuffix?' ÑÐµÐºÑƒÐ½Ð´':' ÑÐµÐºÑƒÐ½Ð´Ñ‹Ð½');case 'm':case 'mm':return number+(withoutSuffix?' Ð¼Ð¸Ð½ÑƒÑ‚':' Ð¼Ð¸Ð½ÑƒÑ‚Ñ‹Ð½');case 'h':case 'hh':return number+(withoutSuffix?' Ñ†Ð°Ð³':' Ñ†Ð°Ð³Ð¸Ð¹Ð½');case 'd':case 'dd':return number+(withoutSuffix?' Ó©Ð´Ó©Ñ€':' Ó©Ð´Ñ€Ð¸Ð¹Ð½');case 'M':case 'MM':return number+(withoutSuffix?' ÑÐ°Ñ€':' ÑÐ°Ñ€Ñ‹Ð½');case 'y':case 'yy':return number+(withoutSuffix?' Ð¶Ð¸Ð»':' Ð¶Ð¸Ð»Ð¸Ð¹Ð½');default:return number;}}
hooks.defineLocale('mn',{months:'ÐÑÐ³Ð´Ò¯Ð³ÑÑÑ€ ÑÐ°Ñ€_Ð¥Ð¾Ñ‘Ñ€Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_Ð“ÑƒÑ€Ð°Ð²Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_Ð”Ó©Ñ€Ó©Ð²Ð´Ò¯Ð³ÑÑÑ€ ÑÐ°Ñ€_Ð¢Ð°Ð²Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_Ð—ÑƒÑ€Ð³Ð°Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_Ð”Ð¾Ð»Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_ÐÐ°Ð¹Ð¼Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_Ð•ÑÐ´Ò¯Ð³ÑÑÑ€ ÑÐ°Ñ€_ÐÑ€Ð°Ð²Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€_ÐÑ€Ð²Ð°Ð½ Ð½ÑÐ³Ð´Ò¯Ð³ÑÑÑ€ ÑÐ°Ñ€_ÐÑ€Ð²Ð°Ð½ Ñ…Ð¾Ñ‘Ñ€Ð´ÑƒÐ³Ð°Ð°Ñ€ ÑÐ°Ñ€'.split('_'),monthsShort:'1 ÑÐ°Ñ€_2 ÑÐ°Ñ€_3 ÑÐ°Ñ€_4 ÑÐ°Ñ€_5 ÑÐ°Ñ€_6 ÑÐ°Ñ€_7 ÑÐ°Ñ€_8 ÑÐ°Ñ€_9 ÑÐ°Ñ€_10 ÑÐ°Ñ€_11 ÑÐ°Ñ€_12 ÑÐ°Ñ€'.split('_'),monthsParseExact:true,weekdays:'ÐÑÐ¼_Ð”Ð°Ð²Ð°Ð°_ÐœÑÐ³Ð¼Ð°Ñ€_Ð›Ñ…Ð°Ð³Ð²Ð°_ÐŸÒ¯Ñ€ÑÐ²_Ð‘Ð°Ð°ÑÐ°Ð½_Ð‘ÑÐ¼Ð±Ð°'.split('_'),weekdaysShort:'ÐÑÐ¼_Ð”Ð°Ð²_ÐœÑÐ³_Ð›Ñ…Ð°_ÐŸÒ¯Ñ€_Ð‘Ð°Ð°_Ð‘ÑÐ¼'.split('_'),weekdaysMin:'ÐÑ_Ð”Ð°_ÐœÑ_Ð›Ñ…_ÐŸÒ¯_Ð‘Ð°_Ð‘Ñ'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'YYYY Ð¾Ð½Ñ‹ MMMMÑ‹Ð½ D',LLL:'YYYY Ð¾Ð½Ñ‹ MMMMÑ‹Ð½ D HH:mm',LLLL:'dddd, YYYY Ð¾Ð½Ñ‹ MMMMÑ‹Ð½ D HH:mm'},meridiemParse:/Ò®Ó¨|Ò®Ð¥/i,isPM:function(input){return input==='Ò®Ð¥';},meridiem:function(hour,minute,isLower){if(hour<12){return 'Ò®Ó¨';}else{return 'Ò®Ð¥';}},calendar:{sameDay:'[Ó¨Ð½Ó©Ó©Ð´Ó©Ñ€] LT',nextDay:'[ÐœÐ°Ñ€Ð³Ð°Ð°Ñˆ] LT',nextWeek:'[Ð˜Ñ€ÑÑ…] dddd LT',lastDay:'[Ó¨Ñ‡Ð¸Ð³Ð´Ó©Ñ€] LT',lastWeek:'[Ó¨Ð½Ð³Ó©Ñ€ÑÓ©Ð½] dddd LT',sameElse:'L'},relativeTime:{future:'%s Ð´Ð°Ñ€Ð°Ð°',past:'%s Ó©Ð¼Ð½Ó©',s:translate$7,ss:translate$7,m:translate$7,mm:translate$7,h:translate$7,hh:translate$7,d:translate$7,dd:translate$7,M:translate$7,MM:translate$7,y:translate$7,yy:translate$7},dayOfMonthOrdinalParse:/\d{1,2} Ó©Ð´Ó©Ñ€/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+' Ó©Ð´Ó©Ñ€';default:return number;}}});var symbolMap$b={'1':'à¥§','2':'à¥¨','3':'à¥©','4':'à¥ª','5':'à¥«','6':'à¥¬','7':'à¥','8':'à¥®','9':'à¥¯','0':'à¥¦'},numberMap$a={'à¥§':'1','à¥¨':'2','à¥©':'3','à¥ª':'4','à¥«':'5','à¥¬':'6','à¥':'7','à¥®':'8','à¥¯':'9','à¥¦':'0'};function relativeTimeMr(number,withoutSuffix,string,isFuture)
{var output='';if(withoutSuffix){switch(string){case 's':output='à¤•à¤¾à¤¹à¥€ à¤¸à¥‡à¤•à¤‚à¤¦';break;case 'ss':output='%d à¤¸à¥‡à¤•à¤‚à¤¦';break;case 'm':output='à¤à¤• à¤®à¤¿à¤¨à¤¿à¤Ÿ';break;case 'mm':output='%d à¤®à¤¿à¤¨à¤¿à¤Ÿà¥‡';break;case 'h':output='à¤à¤• à¤¤à¤¾à¤¸';break;case 'hh':output='%d à¤¤à¤¾à¤¸';break;case 'd':output='à¤à¤• à¤¦à¤¿à¤µà¤¸';break;case 'dd':output='%d à¤¦à¤¿à¤µà¤¸';break;case 'M':output='à¤à¤• à¤®à¤¹à¤¿à¤¨à¤¾';break;case 'MM':output='%d à¤®à¤¹à¤¿à¤¨à¥‡';break;case 'y':output='à¤à¤• à¤µà¤°à¥à¤·';break;case 'yy':output='%d à¤µà¤°à¥à¤·à¥‡';break;}}
else{switch(string){case 's':output='à¤•à¤¾à¤¹à¥€ à¤¸à¥‡à¤•à¤‚à¤¦à¤¾à¤‚';break;case 'ss':output='%d à¤¸à¥‡à¤•à¤‚à¤¦à¤¾à¤‚';break;case 'm':output='à¤à¤•à¤¾ à¤®à¤¿à¤¨à¤¿à¤Ÿà¤¾';break;case 'mm':output='%d à¤®à¤¿à¤¨à¤¿à¤Ÿà¤¾à¤‚';break;case 'h':output='à¤à¤•à¤¾ à¤¤à¤¾à¤¸à¤¾';break;case 'hh':output='%d à¤¤à¤¾à¤¸à¤¾à¤‚';break;case 'd':output='à¤à¤•à¤¾ à¤¦à¤¿à¤µà¤¸à¤¾';break;case 'dd':output='%d à¤¦à¤¿à¤µà¤¸à¤¾à¤‚';break;case 'M':output='à¤à¤•à¤¾ à¤®à¤¹à¤¿à¤¨à¥à¤¯à¤¾';break;case 'MM':output='%d à¤®à¤¹à¤¿à¤¨à¥à¤¯à¤¾à¤‚';break;case 'y':output='à¤à¤•à¤¾ à¤µà¤°à¥à¤·à¤¾';break;case 'yy':output='%d à¤µà¤°à¥à¤·à¤¾à¤‚';break;}}
return output.replace(/%d/i,number);}
hooks.defineLocale('mr',{months:'à¤œà¤¾à¤¨à¥‡à¤µà¤¾à¤°à¥€_à¤«à¥‡à¤¬à¥à¤°à¥à¤µà¤¾à¤°à¥€_à¤®à¤¾à¤°à¥à¤š_à¤à¤ªà¥à¤°à¤¿à¤²_à¤®à¥‡_à¤œà¥‚à¤¨_à¤œà¥à¤²à¥ˆ_à¤‘à¤—à¤¸à¥à¤Ÿ_à¤¸à¤ªà¥à¤Ÿà¥‡à¤‚à¤¬à¤°_à¤‘à¤•à¥à¤Ÿà¥‹à¤¬à¤°_à¤¨à¥‹à¤µà¥à¤¹à¥‡à¤‚à¤¬à¤°_à¤¡à¤¿à¤¸à¥‡à¤‚à¤¬à¤°'.split('_'),monthsShort:'à¤œà¤¾à¤¨à¥‡._à¤«à¥‡à¤¬à¥à¤°à¥._à¤®à¤¾à¤°à¥à¤š._à¤à¤ªà¥à¤°à¤¿._à¤®à¥‡._à¤œà¥‚à¤¨._à¤œà¥à¤²à¥ˆ._à¤‘à¤—._à¤¸à¤ªà¥à¤Ÿà¥‡à¤‚._à¤‘à¤•à¥à¤Ÿà¥‹._à¤¨à¥‹à¤µà¥à¤¹à¥‡à¤‚._à¤¡à¤¿à¤¸à¥‡à¤‚.'.split('_'),monthsParseExact:true,weekdays:'à¤°à¤µà¤¿à¤µà¤¾à¤°_à¤¸à¥‹à¤®à¤µà¤¾à¤°_à¤®à¤‚à¤—à¤³à¤µà¤¾à¤°_à¤¬à¥à¤§à¤µà¤¾à¤°_à¤—à¥à¤°à¥‚à¤µà¤¾à¤°_à¤¶à¥à¤•à¥à¤°à¤µà¤¾à¤°_à¤¶à¤¨à¤¿à¤µà¤¾à¤°'.split('_'),weekdaysShort:'à¤°à¤µà¤¿_à¤¸à¥‹à¤®_à¤®à¤‚à¤—à¤³_à¤¬à¥à¤§_à¤—à¥à¤°à¥‚_à¤¶à¥à¤•à¥à¤°_à¤¶à¤¨à¤¿'.split('_'),weekdaysMin:'à¤°_à¤¸à¥‹_à¤®à¤‚_à¤¬à¥_à¤—à¥_à¤¶à¥_à¤¶'.split('_'),longDateFormat:{LT:'A h:mm à¤µà¤¾à¤œà¤¤à¤¾',LTS:'A h:mm:ss à¤µà¤¾à¤œà¤¤à¤¾',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm à¤µà¤¾à¤œà¤¤à¤¾',LLLL:'dddd, D MMMM YYYY, A h:mm à¤µà¤¾à¤œà¤¤à¤¾'},calendar:{sameDay:'[à¤†à¤œ] LT',nextDay:'[à¤‰à¤¦à¥à¤¯à¤¾] LT',nextWeek:'dddd, LT',lastDay:'[à¤•à¤¾à¤²] LT',lastWeek:'[à¤®à¤¾à¤—à¥€à¤²] dddd, LT',sameElse:'L'},relativeTime:{future:'%sà¤®à¤§à¥à¤¯à¥‡',past:'%sà¤ªà¥‚à¤°à¥à¤µà¥€',s:relativeTimeMr,ss:relativeTimeMr,m:relativeTimeMr,mm:relativeTimeMr,h:relativeTimeMr,hh:relativeTimeMr,d:relativeTimeMr,dd:relativeTimeMr,M:relativeTimeMr,MM:relativeTimeMr,y:relativeTimeMr,yy:relativeTimeMr},preparse:function(string){return string.replace(/[à¥§à¥¨à¥©à¥ªà¥«à¥¬à¥à¥®à¥¯à¥¦]/g,function(match){return numberMap$a[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$b[match];});},meridiemParse:/à¤°à¤¾à¤¤à¥à¤°à¥€|à¤¸à¤•à¤¾à¤³à¥€|à¤¦à¥à¤ªà¤¾à¤°à¥€|à¤¸à¤¾à¤¯à¤‚à¤•à¤¾à¤³à¥€/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à¤°à¤¾à¤¤à¥à¤°à¥€'){return hour<4?hour:hour+12;}else if(meridiem==='à¤¸à¤•à¤¾à¤³à¥€'){return hour;}else if(meridiem==='à¤¦à¥à¤ªà¤¾à¤°à¥€'){return hour>=10?hour:hour+12;}else if(meridiem==='à¤¸à¤¾à¤¯à¤‚à¤•à¤¾à¤³à¥€'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à¤°à¤¾à¤¤à¥à¤°à¥€';}else if(hour<10){return 'à¤¸à¤•à¤¾à¤³à¥€';}else if(hour<17){return 'à¤¦à¥à¤ªà¤¾à¤°à¥€';}else if(hour<20){return 'à¤¸à¤¾à¤¯à¤‚à¤•à¤¾à¤³à¥€';}else{return 'à¤°à¤¾à¤¤à¥à¤°à¥€';}},week:{dow:0,doy:6}});hooks.defineLocale('ms-my',{months:'Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember'.split('_'),monthsShort:'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis'.split('_'),weekdays:'Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu'.split('_'),weekdaysShort:'Ahd_Isn_Sel_Rab_Kha_Jum_Sab'.split('_'),weekdaysMin:'Ah_Is_Sl_Rb_Km_Jm_Sb'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [pukul] HH.mm',LLLL:'dddd, D MMMM YYYY [pukul] HH.mm'},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='pagi'){return hour;}else if(meridiem==='tengahari'){return hour>=11?hour:hour+12;}else if(meridiem==='petang'||meridiem==='malam'){return hour+12;}},meridiem:function(hours,minutes,isLower){if(hours<11){return 'pagi';}else if(hours<15){return 'tengahari';}else if(hours<19){return 'petang';}else{return 'malam';}},calendar:{sameDay:'[Hari ini pukul] LT',nextDay:'[Esok pukul] LT',nextWeek:'dddd [pukul] LT',lastDay:'[Kelmarin pukul] LT',lastWeek:'dddd [lepas pukul] LT',sameElse:'L'},relativeTime:{future:'dalam %s',past:'%s yang lepas',s:'beberapa saat',ss:'%d saat',m:'seminit',mm:'%d minit',h:'sejam',hh:'%d jam',d:'sehari',dd:'%d hari',M:'sebulan',MM:'%d bulan',y:'setahun',yy:'%d tahun'},week:{dow:1,doy:7}});hooks.defineLocale('ms',{months:'Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember'.split('_'),monthsShort:'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis'.split('_'),weekdays:'Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu'.split('_'),weekdaysShort:'Ahd_Isn_Sel_Rab_Kha_Jum_Sab'.split('_'),weekdaysMin:'Ah_Is_Sl_Rb_Km_Jm_Sb'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [pukul] HH.mm',LLLL:'dddd, D MMMM YYYY [pukul] HH.mm'},meridiemParse:/pagi|tengahari|petang|malam/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='pagi'){return hour;}else if(meridiem==='tengahari'){return hour>=11?hour:hour+12;}else if(meridiem==='petang'||meridiem==='malam'){return hour+12;}},meridiem:function(hours,minutes,isLower){if(hours<11){return 'pagi';}else if(hours<15){return 'tengahari';}else if(hours<19){return 'petang';}else{return 'malam';}},calendar:{sameDay:'[Hari ini pukul] LT',nextDay:'[Esok pukul] LT',nextWeek:'dddd [pukul] LT',lastDay:'[Kelmarin pukul] LT',lastWeek:'dddd [lepas pukul] LT',sameElse:'L'},relativeTime:{future:'dalam %s',past:'%s yang lepas',s:'beberapa saat',ss:'%d saat',m:'seminit',mm:'%d minit',h:'sejam',hh:'%d jam',d:'sehari',dd:'%d hari',M:'sebulan',MM:'%d bulan',y:'setahun',yy:'%d tahun'},week:{dow:1,doy:7}});hooks.defineLocale('mt',{months:'Jannar_Frar_Marzu_April_Mejju_Ä unju_Lulju_Awwissu_Settembru_Ottubru_Novembru_DiÄ‹embru'.split('_'),monthsShort:'Jan_Fra_Mar_Apr_Mej_Ä un_Lul_Aww_Set_Ott_Nov_DiÄ‹'.split('_'),weekdays:'Il-Ä¦add_It-Tnejn_It-Tlieta_L-ErbgÄ§a_Il-Ä¦amis_Il-Ä imgÄ§a_Is-Sibt'.split('_'),weekdaysShort:'Ä¦ad_Tne_Tli_Erb_Ä¦am_Ä im_Sib'.split('_'),weekdaysMin:'Ä¦a_Tn_Tl_Er_Ä¦a_Ä i_Si'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Illum fil-]LT',nextDay:'[GÄ§ada fil-]LT',nextWeek:'dddd [fil-]LT',lastDay:'[Il-bieraÄ§ fil-]LT',lastWeek:'dddd [li gÄ§adda] [fil-]LT',sameElse:'L'},relativeTime:{future:'fâ€™ %s',past:'%s ilu',s:'ftit sekondi',ss:'%d sekondi',m:'minuta',mm:'%d minuti',h:'siegÄ§a',hh:'%d siegÄ§at',d:'Ä¡urnata',dd:'%d Ä¡ranet',M:'xahar',MM:'%d xhur',y:'sena',yy:'%d sni'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});var symbolMap$c={'1':'á','2':'á‚','3':'áƒ','4':'á„','5':'á…','6':'á†','7':'á‡','8':'áˆ','9':'á‰','0':'á€'},numberMap$b={'á':'1','á‚':'2','áƒ':'3','á„':'4','á…':'5','á†':'6','á‡':'7','áˆ':'8','á‰':'9','á€':'0'};hooks.defineLocale('my',{months:'á€‡á€”á€ºá€”á€á€«á€›á€®_á€–á€±á€–á€±á€¬á€ºá€á€«á€›á€®_á€™á€á€º_á€§á€•á€¼á€®_á€™á€±_á€‡á€½á€”á€º_á€‡á€°á€œá€á€¯á€„á€º_á€žá€¼á€‚á€¯á€á€º_á€…á€€á€ºá€á€„á€ºá€˜á€¬_á€¡á€±á€¬á€€á€ºá€á€á€¯á€˜á€¬_á€”á€á€¯á€á€„á€ºá€˜á€¬_á€’á€®á€‡á€„á€ºá€˜á€¬'.split('_'),monthsShort:'á€‡á€”á€º_á€–á€±_á€™á€á€º_á€•á€¼á€®_á€™á€±_á€‡á€½á€”á€º_á€œá€á€¯á€„á€º_á€žá€¼_á€…á€€á€º_á€¡á€±á€¬á€€á€º_á€”á€á€¯_á€’á€®'.split('_'),weekdays:'á€á€”á€„á€ºá€¹á€‚á€”á€½á€±_á€á€”á€„á€ºá€¹á€œá€¬_á€¡á€„á€ºá€¹á€‚á€«_á€—á€¯á€’á€¹á€“á€Ÿá€°á€¸_á€€á€¼á€¬á€žá€•á€á€±á€¸_á€žá€±á€¬á€€á€¼á€¬_á€…á€”á€±'.split('_'),weekdaysShort:'á€”á€½á€±_á€œá€¬_á€‚á€«_á€Ÿá€°á€¸_á€€á€¼á€¬_á€žá€±á€¬_á€”á€±'.split('_'),weekdaysMin:'á€”á€½á€±_á€œá€¬_á€‚á€«_á€Ÿá€°á€¸_á€€á€¼á€¬_á€žá€±á€¬_á€”á€±'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[á€šá€”á€±.] LT [á€™á€¾á€¬]',nextDay:'[á€™á€”á€€á€ºá€–á€¼á€”á€º] LT [á€™á€¾á€¬]',nextWeek:'dddd LT [á€™á€¾á€¬]',lastDay:'[á€™á€”á€±.á€€] LT [á€™á€¾á€¬]',lastWeek:'[á€•á€¼á€®á€¸á€á€²á€·á€žá€±á€¬] dddd LT [á€™á€¾á€¬]',sameElse:'L'},relativeTime:{future:'á€œá€¬á€™á€Šá€·á€º %s á€™á€¾á€¬',past:'á€œá€½á€”á€ºá€á€²á€·á€žá€±á€¬ %s á€€',s:'á€…á€€á€¹á€€á€”á€º.á€¡á€”á€Šá€ºá€¸á€„á€šá€º',ss:'%d á€…á€€á€¹á€€á€”á€·á€º',m:'á€á€…á€ºá€™á€á€”á€…á€º',mm:'%d á€™á€á€”á€…á€º',h:'á€á€…á€ºá€”á€¬á€›á€®',hh:'%d á€”á€¬á€›á€®',d:'á€á€…á€ºá€›á€€á€º',dd:'%d á€›á€€á€º',M:'á€á€…á€ºá€œ',MM:'%d á€œ',y:'á€á€…á€ºá€”á€¾á€…á€º',yy:'%d á€”á€¾á€…á€º'},preparse:function(string){return string.replace(/[áá‚áƒá„á…á†á‡áˆá‰á€]/g,function(match){return numberMap$b[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$c[match];});},week:{dow:1,doy:4}});hooks.defineLocale('nb',{months:'januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember'.split('_'),monthsShort:'jan._feb._mars_april_mai_juni_juli_aug._sep._okt._nov._des.'.split('_'),monthsParseExact:true,weekdays:'sÃ¸ndag_mandag_tirsdag_onsdag_torsdag_fredag_lÃ¸rdag'.split('_'),weekdaysShort:'sÃ¸._ma._ti._on._to._fr._lÃ¸.'.split('_'),weekdaysMin:'sÃ¸_ma_ti_on_to_fr_lÃ¸'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY [kl.] HH:mm',LLLL:'dddd D. MMMM YYYY [kl.] HH:mm'},calendar:{sameDay:'[i dag kl.] LT',nextDay:'[i morgen kl.] LT',nextWeek:'dddd [kl.] LT',lastDay:'[i gÃ¥r kl.] LT',lastWeek:'[forrige] dddd [kl.] LT',sameElse:'L'},relativeTime:{future:'om %s',past:'%s siden',s:'noen sekunder',ss:'%d sekunder',m:'ett minutt',mm:'%d minutter',h:'en time',hh:'%d timer',d:'en dag',dd:'%d dager',M:'en mÃ¥ned',MM:'%d mÃ¥neder',y:'ett Ã¥r',yy:'%d Ã¥r'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var symbolMap$d={'1':'à¥§','2':'à¥¨','3':'à¥©','4':'à¥ª','5':'à¥«','6':'à¥¬','7':'à¥','8':'à¥®','9':'à¥¯','0':'à¥¦'},numberMap$c={'à¥§':'1','à¥¨':'2','à¥©':'3','à¥ª':'4','à¥«':'5','à¥¬':'6','à¥':'7','à¥®':'8','à¥¯':'9','à¥¦':'0'};hooks.defineLocale('ne',{months:'à¤œà¤¨à¤µà¤°à¥€_à¤«à¥‡à¤¬à¥à¤°à¥à¤µà¤°à¥€_à¤®à¤¾à¤°à¥à¤š_à¤…à¤ªà¥à¤°à¤¿à¤²_à¤®à¤ˆ_à¤œà¥à¤¨_à¤œà¥à¤²à¤¾à¤ˆ_à¤…à¤—à¤·à¥à¤Ÿ_à¤¸à¥‡à¤ªà¥à¤Ÿà¥‡à¤®à¥à¤¬à¤°_à¤…à¤•à¥à¤Ÿà¥‹à¤¬à¤°_à¤¨à¥‹à¤à¥‡à¤®à¥à¤¬à¤°_à¤¡à¤¿à¤¸à¥‡à¤®à¥à¤¬à¤°'.split('_'),monthsShort:'à¤œà¤¨._à¤«à¥‡à¤¬à¥à¤°à¥._à¤®à¤¾à¤°à¥à¤š_à¤…à¤ªà¥à¤°à¤¿._à¤®à¤ˆ_à¤œà¥à¤¨_à¤œà¥à¤²à¤¾à¤ˆ._à¤…à¤—._à¤¸à¥‡à¤ªà¥à¤Ÿ._à¤…à¤•à¥à¤Ÿà¥‹._à¤¨à¥‹à¤à¥‡._à¤¡à¤¿à¤¸à¥‡.'.split('_'),monthsParseExact:true,weekdays:'à¤†à¤‡à¤¤à¤¬à¤¾à¤°_à¤¸à¥‹à¤®à¤¬à¤¾à¤°_à¤®à¤™à¥à¤—à¤²à¤¬à¤¾à¤°_à¤¬à¥à¤§à¤¬à¤¾à¤°_à¤¬à¤¿à¤¹à¤¿à¤¬à¤¾à¤°_à¤¶à¥à¤•à¥à¤°à¤¬à¤¾à¤°_à¤¶à¤¨à¤¿à¤¬à¤¾à¤°'.split('_'),weekdaysShort:'à¤†à¤‡à¤¤._à¤¸à¥‹à¤®._à¤®à¤™à¥à¤—à¤²._à¤¬à¥à¤§._à¤¬à¤¿à¤¹à¤¿._à¤¶à¥à¤•à¥à¤°._à¤¶à¤¨à¤¿.'.split('_'),weekdaysMin:'à¤†._à¤¸à¥‹._à¤®à¤‚._à¤¬à¥._à¤¬à¤¿._à¤¶à¥._à¤¶.'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'Aà¤•à¥‹ h:mm à¤¬à¤œà¥‡',LTS:'Aà¤•à¥‹ h:mm:ss à¤¬à¤œà¥‡',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, Aà¤•à¥‹ h:mm à¤¬à¤œà¥‡',LLLL:'dddd, D MMMM YYYY, Aà¤•à¥‹ h:mm à¤¬à¤œà¥‡'},preparse:function(string){return string.replace(/[à¥§à¥¨à¥©à¥ªà¥«à¥¬à¥à¥®à¥¯à¥¦]/g,function(match){return numberMap$c[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$d[match];});},meridiemParse:/à¤°à¤¾à¤¤à¤¿|à¤¬à¤¿à¤¹à¤¾à¤¨|à¤¦à¤¿à¤‰à¤à¤¸à¥‹|à¤¸à¤¾à¤à¤/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à¤°à¤¾à¤¤à¤¿'){return hour<4?hour:hour+12;}else if(meridiem==='à¤¬à¤¿à¤¹à¤¾à¤¨'){return hour;}else if(meridiem==='à¤¦à¤¿à¤‰à¤à¤¸à¥‹'){return hour>=10?hour:hour+12;}else if(meridiem==='à¤¸à¤¾à¤à¤'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<3){return 'à¤°à¤¾à¤¤à¤¿';}else if(hour<12){return 'à¤¬à¤¿à¤¹à¤¾à¤¨';}else if(hour<16){return 'à¤¦à¤¿à¤‰à¤à¤¸à¥‹';}else if(hour<20){return 'à¤¸à¤¾à¤à¤';}else{return 'à¤°à¤¾à¤¤à¤¿';}},calendar:{sameDay:'[à¤†à¤œ] LT',nextDay:'[à¤à¥‹à¤²à¤¿] LT',nextWeek:'[à¤†à¤‰à¤à¤¦à¥‹] dddd[,] LT',lastDay:'[à¤¹à¤¿à¤œà¥‹] LT',lastWeek:'[à¤—à¤à¤•à¥‹] dddd[,] LT',sameElse:'L'},relativeTime:{future:'%sà¤®à¤¾',past:'%s à¤…à¤—à¤¾à¤¡à¤¿',s:'à¤•à¥‡à¤¹à¥€ à¤•à¥à¤·à¤£',ss:'%d à¤¸à¥‡à¤•à¥‡à¤£à¥à¤¡',m:'à¤à¤• à¤®à¤¿à¤¨à¥‡à¤Ÿ',mm:'%d à¤®à¤¿à¤¨à¥‡à¤Ÿ',h:'à¤à¤• à¤˜à¤£à¥à¤Ÿà¤¾',hh:'%d à¤˜à¤£à¥à¤Ÿà¤¾',d:'à¤à¤• à¤¦à¤¿à¤¨',dd:'%d à¤¦à¤¿à¤¨',M:'à¤à¤• à¤®à¤¹à¤¿à¤¨à¤¾',MM:'%d à¤®à¤¹à¤¿à¤¨à¤¾',y:'à¤à¤• à¤¬à¤°à¥à¤·',yy:'%d à¤¬à¤°à¥à¤·'},week:{dow:0,doy:6}});var monthsShortWithDots$1='jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split('_'),monthsShortWithoutDots$1='jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split('_');var monthsParse$4=[/^jan/i,/^feb/i,/^maart|mrt.?$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i];var monthsRegex$5=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;hooks.defineLocale('nl-be',{months:'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortWithDots$1;}else if(/-MMM-/.test(format)){return monthsShortWithoutDots$1[m.month()];}else{return monthsShortWithDots$1[m.month()];}},monthsRegex:monthsRegex$5,monthsShortRegex:monthsRegex$5,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:monthsParse$4,longMonthsParse:monthsParse$4,shortMonthsParse:monthsParse$4,weekdays:'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split('_'),weekdaysShort:'zo._ma._di._wo._do._vr._za.'.split('_'),weekdaysMin:'zo_ma_di_wo_do_vr_za'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[vandaag om] LT',nextDay:'[morgen om] LT',nextWeek:'dddd [om] LT',lastDay:'[gisteren om] LT',lastWeek:'[afgelopen] dddd [om] LT',sameElse:'L'},relativeTime:{future:'over %s',past:'%s geleden',s:'een paar seconden',ss:'%d seconden',m:'Ã©Ã©n minuut',mm:'%d minuten',h:'Ã©Ã©n uur',hh:'%d uur',d:'Ã©Ã©n dag',dd:'%d dagen',M:'Ã©Ã©n maand',MM:'%d maanden',y:'Ã©Ã©n jaar',yy:'%d jaar'},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(number){return number+((number===1||number===8||number>=20)?'ste':'de');},week:{dow:1,doy:4}});var monthsShortWithDots$2='jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split('_'),monthsShortWithoutDots$2='jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split('_');var monthsParse$5=[/^jan/i,/^feb/i,/^maart|mrt.?$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i];var monthsRegex$6=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;hooks.defineLocale('nl',{months:'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split('_'),monthsShort:function(m,format){if(!m){return monthsShortWithDots$2;}else if(/-MMM-/.test(format)){return monthsShortWithoutDots$2[m.month()];}else{return monthsShortWithDots$2[m.month()];}},monthsRegex:monthsRegex$6,monthsShortRegex:monthsRegex$6,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:monthsParse$5,longMonthsParse:monthsParse$5,shortMonthsParse:monthsParse$5,weekdays:'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split('_'),weekdaysShort:'zo._ma._di._wo._do._vr._za.'.split('_'),weekdaysMin:'zo_ma_di_wo_do_vr_za'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD-MM-YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[vandaag om] LT',nextDay:'[morgen om] LT',nextWeek:'dddd [om] LT',lastDay:'[gisteren om] LT',lastWeek:'[afgelopen] dddd [om] LT',sameElse:'L'},relativeTime:{future:'over %s',past:'%s geleden',s:'een paar seconden',ss:'%d seconden',m:'Ã©Ã©n minuut',mm:'%d minuten',h:'Ã©Ã©n uur',hh:'%d uur',d:'Ã©Ã©n dag',dd:'%d dagen',M:'Ã©Ã©n maand',MM:'%d maanden',y:'Ã©Ã©n jaar',yy:'%d jaar'},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(number){return number+((number===1||number===8||number>=20)?'ste':'de');},week:{dow:1,doy:4}});hooks.defineLocale('nn',{months:'januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember'.split('_'),monthsShort:'jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_'),weekdays:'sundag_mÃ¥ndag_tysdag_onsdag_torsdag_fredag_laurdag'.split('_'),weekdaysShort:'sun_mÃ¥n_tys_ons_tor_fre_lau'.split('_'),weekdaysMin:'su_mÃ¥_ty_on_to_fr_lÃ¸'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY [kl.] H:mm',LLLL:'dddd D. MMMM YYYY [kl.] HH:mm'},calendar:{sameDay:'[I dag klokka] LT',nextDay:'[I morgon klokka] LT',nextWeek:'dddd [klokka] LT',lastDay:'[I gÃ¥r klokka] LT',lastWeek:'[FÃ¸regÃ¥ande] dddd [klokka] LT',sameElse:'L'},relativeTime:{future:'om %s',past:'%s sidan',s:'nokre sekund',ss:'%d sekund',m:'eit minutt',mm:'%d minutt',h:'ein time',hh:'%d timar',d:'ein dag',dd:'%d dagar',M:'ein mÃ¥nad',MM:'%d mÃ¥nader',y:'eit Ã¥r',yy:'%d Ã¥r'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var symbolMap$e={'1':'à©§','2':'à©¨','3':'à©©','4':'à©ª','5':'à©«','6':'à©¬','7':'à©','8':'à©®','9':'à©¯','0':'à©¦'},numberMap$d={'à©§':'1','à©¨':'2','à©©':'3','à©ª':'4','à©«':'5','à©¬':'6','à©':'7','à©®':'8','à©¯':'9','à©¦':'0'};hooks.defineLocale('pa-in',{months:'à¨œà¨¨à¨µà¨°à©€_à¨«à¨¼à¨°à¨µà¨°à©€_à¨®à¨¾à¨°à¨š_à¨…à¨ªà©à¨°à©ˆà¨²_à¨®à¨ˆ_à¨œà©‚à¨¨_à¨œà©à¨²à¨¾à¨ˆ_à¨…à¨—à¨¸à¨¤_à¨¸à¨¤à©°à¨¬à¨°_à¨…à¨•à¨¤à©‚à¨¬à¨°_à¨¨à¨µà©°à¨¬à¨°_à¨¦à¨¸à©°à¨¬à¨°'.split('_'),monthsShort:'à¨œà¨¨à¨µà¨°à©€_à¨«à¨¼à¨°à¨µà¨°à©€_à¨®à¨¾à¨°à¨š_à¨…à¨ªà©à¨°à©ˆà¨²_à¨®à¨ˆ_à¨œà©‚à¨¨_à¨œà©à¨²à¨¾à¨ˆ_à¨…à¨—à¨¸à¨¤_à¨¸à¨¤à©°à¨¬à¨°_à¨…à¨•à¨¤à©‚à¨¬à¨°_à¨¨à¨µà©°à¨¬à¨°_à¨¦à¨¸à©°à¨¬à¨°'.split('_'),weekdays:'à¨à¨¤à¨µà¨¾à¨°_à¨¸à©‹à¨®à¨µà¨¾à¨°_à¨®à©°à¨—à¨²à¨µà¨¾à¨°_à¨¬à©à¨§à¨µà¨¾à¨°_à¨µà©€à¨°à¨µà¨¾à¨°_à¨¸à¨¼à©à©±à¨•à¨°à¨µà¨¾à¨°_à¨¸à¨¼à¨¨à©€à¨šà¨°à¨µà¨¾à¨°'.split('_'),weekdaysShort:'à¨à¨¤_à¨¸à©‹à¨®_à¨®à©°à¨—à¨²_à¨¬à©à¨§_à¨µà©€à¨°_à¨¸à¨¼à©à¨•à¨°_à¨¸à¨¼à¨¨à©€'.split('_'),weekdaysMin:'à¨à¨¤_à¨¸à©‹à¨®_à¨®à©°à¨—à¨²_à¨¬à©à¨§_à¨µà©€à¨°_à¨¸à¨¼à©à¨•à¨°_à¨¸à¨¼à¨¨à©€'.split('_'),longDateFormat:{LT:'A h:mm à¨µà¨œà©‡',LTS:'A h:mm:ss à¨µà¨œà©‡',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm à¨µà¨œà©‡',LLLL:'dddd, D MMMM YYYY, A h:mm à¨µà¨œà©‡'},calendar:{sameDay:'[à¨…à¨œ] LT',nextDay:'[à¨•à¨²] LT',nextWeek:'[à¨…à¨—à¨²à¨¾] dddd, LT',lastDay:'[à¨•à¨²] LT',lastWeek:'[à¨ªà¨¿à¨›à¨²à©‡] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à¨µà¨¿à©±à¨š',past:'%s à¨ªà¨¿à¨›à¨²à©‡',s:'à¨•à©à¨ à¨¸à¨•à¨¿à©°à¨Ÿ',ss:'%d à¨¸à¨•à¨¿à©°à¨Ÿ',m:'à¨‡à¨• à¨®à¨¿à©°à¨Ÿ',mm:'%d à¨®à¨¿à©°à¨Ÿ',h:'à¨‡à©±à¨• à¨˜à©°à¨Ÿà¨¾',hh:'%d à¨˜à©°à¨Ÿà©‡',d:'à¨‡à©±à¨• à¨¦à¨¿à¨¨',dd:'%d à¨¦à¨¿à¨¨',M:'à¨‡à©±à¨• à¨®à¨¹à©€à¨¨à¨¾',MM:'%d à¨®à¨¹à©€à¨¨à©‡',y:'à¨‡à©±à¨• à¨¸à¨¾à¨²',yy:'%d à¨¸à¨¾à¨²'},preparse:function(string){return string.replace(/[à©§à©¨à©©à©ªà©«à©¬à©à©®à©¯à©¦]/g,function(match){return numberMap$d[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$e[match];});},meridiemParse:/à¨°à¨¾à¨¤|à¨¸à¨µà©‡à¨°|à¨¦à©à¨ªà¨¹à¨¿à¨°|à¨¸à¨¼à¨¾à¨®/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à¨°à¨¾à¨¤'){return hour<4?hour:hour+12;}else if(meridiem==='à¨¸à¨µà©‡à¨°'){return hour;}else if(meridiem==='à¨¦à©à¨ªà¨¹à¨¿à¨°'){return hour>=10?hour:hour+12;}else if(meridiem==='à¨¸à¨¼à¨¾à¨®'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à¨°à¨¾à¨¤';}else if(hour<10){return 'à¨¸à¨µà©‡à¨°';}else if(hour<17){return 'à¨¦à©à¨ªà¨¹à¨¿à¨°';}else if(hour<20){return 'à¨¸à¨¼à¨¾à¨®';}else{return 'à¨°à¨¾à¨¤';}},week:{dow:0,doy:6}});var monthsNominative='styczeÅ„_luty_marzec_kwiecieÅ„_maj_czerwiec_lipiec_sierpieÅ„_wrzesieÅ„_paÅºdziernik_listopad_grudzieÅ„'.split('_'),monthsSubjective='stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_wrzeÅ›nia_paÅºdziernika_listopada_grudnia'.split('_');function plural$3(n){return(n%10<5)&&(n%10>1)&&((~~(n/10)%10)!==1);}
function translate$8(number,withoutSuffix,key){var result=number+' ';switch(key){case 'ss':return result+(plural$3(number)?'sekundy':'sekund');case 'm':return withoutSuffix?'minuta':'minutÄ™';case 'mm':return result+(plural$3(number)?'minuty':'minut');case 'h':return withoutSuffix?'godzina':'godzinÄ™';case 'hh':return result+(plural$3(number)?'godziny':'godzin');case 'MM':return result+(plural$3(number)?'miesiÄ…ce':'miesiÄ™cy');case 'yy':return result+(plural$3(number)?'lata':'lat');}}
hooks.defineLocale('pl',{months:function(momentToFormat,format){if(!momentToFormat){return monthsNominative;}else if(format===''){return '('+monthsSubjective[momentToFormat.month()]+'|'+monthsNominative[momentToFormat.month()]+')';}else if(/D MMMM/.test(format)){return monthsSubjective[momentToFormat.month()];}else{return monthsNominative[momentToFormat.month()];}},monthsShort:'sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paÅº_lis_gru'.split('_'),weekdays:'niedziela_poniedziaÅ‚ek_wtorek_Å›roda_czwartek_piÄ…tek_sobota'.split('_'),weekdaysShort:'ndz_pon_wt_Å›r_czw_pt_sob'.split('_'),weekdaysMin:'Nd_Pn_Wt_Åšr_Cz_Pt_So'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[DziÅ› o] LT',nextDay:'[Jutro o] LT',nextWeek:function(){switch(this.day()){case 0:return '[W niedzielÄ™ o] LT';case 2:return '[We wtorek o] LT';case 3:return '[W Å›rodÄ™ o] LT';case 6:return '[W sobotÄ™ o] LT';default:return '[W] dddd [o] LT';}},lastDay:'[Wczoraj o] LT',lastWeek:function(){switch(this.day()){case 0:return '[W zeszÅ‚Ä… niedzielÄ™ o] LT';case 3:return '[W zeszÅ‚Ä… Å›rodÄ™ o] LT';case 6:return '[W zeszÅ‚Ä… sobotÄ™ o] LT';default:return '[W zeszÅ‚y] dddd [o] LT';}},sameElse:'L'},relativeTime:{future:'za %s',past:'%s temu',s:'kilka sekund',ss:translate$8,m:translate$8,mm:translate$8,h:translate$8,hh:translate$8,d:'1 dzieÅ„',dd:'%d dni',M:'miesiÄ…c',MM:translate$8,y:'rok',yy:translate$8},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('pt-br',{months:'Janeiro_Fevereiro_MarÃ§o_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro'.split('_'),monthsShort:'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez'.split('_'),weekdays:'Domingo_Segunda-feira_TerÃ§a-feira_Quarta-feira_Quinta-feira_Sexta-feira_SÃ¡bado'.split('_'),weekdaysShort:'Dom_Seg_Ter_Qua_Qui_Sex_SÃ¡b'.split('_'),weekdaysMin:'Do_2Âª_3Âª_4Âª_5Âª_6Âª_SÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY [Ã s] HH:mm',LLLL:'dddd, D [de] MMMM [de] YYYY [Ã s] HH:mm'},calendar:{sameDay:'[Hoje Ã s] LT',nextDay:'[AmanhÃ£ Ã s] LT',nextWeek:'dddd [Ã s] LT',lastDay:'[Ontem Ã s] LT',lastWeek:function(){return(this.day()===0||this.day()===6)?'[Ãšltimo] dddd [Ã s] LT':'[Ãšltima] dddd [Ã s] LT';},sameElse:'L'},relativeTime:{future:'em %s',past:'hÃ¡ %s',s:'poucos segundos',ss:'%d segundos',m:'um minuto',mm:'%d minutos',h:'uma hora',hh:'%d horas',d:'um dia',dd:'%d dias',M:'um mÃªs',MM:'%d meses',y:'um ano',yy:'%d anos'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº'});hooks.defineLocale('pt',{months:'Janeiro_Fevereiro_MarÃ§o_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro'.split('_'),monthsShort:'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez'.split('_'),weekdays:'Domingo_Segunda-feira_TerÃ§a-feira_Quarta-feira_Quinta-feira_Sexta-feira_SÃ¡bado'.split('_'),weekdaysShort:'Dom_Seg_Ter_Qua_Qui_Sex_SÃ¡b'.split('_'),weekdaysMin:'Do_2Âª_3Âª_4Âª_5Âª_6Âª_SÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D [de] MMMM [de] YYYY',LLL:'D [de] MMMM [de] YYYY HH:mm',LLLL:'dddd, D [de] MMMM [de] YYYY HH:mm'},calendar:{sameDay:'[Hoje Ã s] LT',nextDay:'[AmanhÃ£ Ã s] LT',nextWeek:'dddd [Ã s] LT',lastDay:'[Ontem Ã s] LT',lastWeek:function(){return(this.day()===0||this.day()===6)?'[Ãšltimo] dddd [Ã s] LT':'[Ãšltima] dddd [Ã s] LT';},sameElse:'L'},relativeTime:{future:'em %s',past:'hÃ¡ %s',s:'segundos',ss:'%d segundos',m:'um minuto',mm:'%d minutos',h:'uma hora',hh:'%d horas',d:'um dia',dd:'%d dias',M:'um mÃªs',MM:'%d meses',y:'um ano',yy:'%d anos'},dayOfMonthOrdinalParse:/\d{1,2}Âº/,ordinal:'%dÂº',week:{dow:1,doy:4}});function relativeTimeWithPlural$2(number,withoutSuffix,key){var format={'ss':'secunde','mm':'minute','hh':'ore','dd':'zile','MM':'luni','yy':'ani'},separator=' ';if(number%100>=20||(number>=100&&number%100===0)){separator=' de ';}
return number+separator+format[key];}
hooks.defineLocale('ro',{months:'ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie'.split('_'),monthsShort:'ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'duminicÄƒ_luni_marÈ›i_miercuri_joi_vineri_sÃ¢mbÄƒtÄƒ'.split('_'),weekdaysShort:'Dum_Lun_Mar_Mie_Joi_Vin_SÃ¢m'.split('_'),weekdaysMin:'Du_Lu_Ma_Mi_Jo_Vi_SÃ¢'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY H:mm',LLLL:'dddd, D MMMM YYYY H:mm'},calendar:{sameDay:'[azi la] LT',nextDay:'[mÃ¢ine la] LT',nextWeek:'dddd [la] LT',lastDay:'[ieri la] LT',lastWeek:'[fosta] dddd [la] LT',sameElse:'L'},relativeTime:{future:'peste %s',past:'%s Ã®n urmÄƒ',s:'cÃ¢teva secunde',ss:relativeTimeWithPlural$2,m:'un minut',mm:relativeTimeWithPlural$2,h:'o orÄƒ',hh:relativeTimeWithPlural$2,d:'o zi',dd:relativeTimeWithPlural$2,M:'o lunÄƒ',MM:relativeTimeWithPlural$2,y:'un an',yy:relativeTimeWithPlural$2},week:{dow:1,doy:7}});function plural$4(word,num){var forms=word.split('_');return num%10===1&&num%100!==11?forms[0]:(num%10>=2&&num%10<=4&&(num%100<10||num%100>=20)?forms[1]:forms[2]);}
function relativeTimeWithPlural$3(number,withoutSuffix,key){var format={'ss':withoutSuffix?'ÑÐµÐºÑƒÐ½Ð´Ð°_ÑÐµÐºÑƒÐ½Ð´Ñ‹_ÑÐµÐºÑƒÐ½Ð´':'ÑÐµÐºÑƒÐ½Ð´Ñƒ_ÑÐµÐºÑƒÐ½Ð´Ñ‹_ÑÐµÐºÑƒÐ½Ð´','mm':withoutSuffix?'Ð¼Ð¸Ð½ÑƒÑ‚Ð°_Ð¼Ð¸Ð½ÑƒÑ‚Ñ‹_Ð¼Ð¸Ð½ÑƒÑ‚':'Ð¼Ð¸Ð½ÑƒÑ‚Ñƒ_Ð¼Ð¸Ð½ÑƒÑ‚Ñ‹_Ð¼Ð¸Ð½ÑƒÑ‚','hh':'Ñ‡Ð°Ñ_Ñ‡Ð°ÑÐ°_Ñ‡Ð°ÑÐ¾Ð²','dd':'Ð´ÐµÐ½ÑŒ_Ð´Ð½Ñ_Ð´Ð½ÐµÐ¹','MM':'Ð¼ÐµÑÑÑ†_Ð¼ÐµÑÑÑ†Ð°_Ð¼ÐµÑÑÑ†ÐµÐ²','yy':'Ð³Ð¾Ð´_Ð³Ð¾Ð´Ð°_Ð»ÐµÑ‚'};if(key==='m'){return withoutSuffix?'Ð¼Ð¸Ð½ÑƒÑ‚Ð°':'Ð¼Ð¸Ð½ÑƒÑ‚Ñƒ';}
else{return number+' '+plural$4(format[key],+number);}}
var monthsParse$6=[/^ÑÐ½Ð²/i,/^Ñ„ÐµÐ²/i,/^Ð¼Ð°Ñ€/i,/^Ð°Ð¿Ñ€/i,/^Ð¼Ð°[Ð¹Ñ]/i,/^Ð¸ÑŽÐ½/i,/^Ð¸ÑŽÐ»/i,/^Ð°Ð²Ð³/i,/^ÑÐµÐ½/i,/^Ð¾ÐºÑ‚/i,/^Ð½Ð¾Ñ/i,/^Ð´ÐµÐº/i];hooks.defineLocale('ru',{months:{format:'ÑÐ½Ð²Ð°Ñ€Ñ_Ñ„ÐµÐ²Ñ€Ð°Ð»Ñ_Ð¼Ð°Ñ€Ñ‚Ð°_Ð°Ð¿Ñ€ÐµÐ»Ñ_Ð¼Ð°Ñ_Ð¸ÑŽÐ½Ñ_Ð¸ÑŽÐ»Ñ_Ð°Ð²Ð³ÑƒÑÑ‚Ð°_ÑÐµÐ½Ñ‚ÑÐ±Ñ€Ñ_Ð¾ÐºÑ‚ÑÐ±Ñ€Ñ_Ð½Ð¾ÑÐ±Ñ€Ñ_Ð´ÐµÐºÐ°Ð±Ñ€Ñ'.split('_'),standalone:'ÑÐ½Ð²Ð°Ñ€ÑŒ_Ñ„ÐµÐ²Ñ€Ð°Ð»ÑŒ_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€ÐµÐ»ÑŒ_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½ÑŒ_Ð¸ÑŽÐ»ÑŒ_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ½Ñ‚ÑÐ±Ñ€ÑŒ_Ð¾ÐºÑ‚ÑÐ±Ñ€ÑŒ_Ð½Ð¾ÑÐ±Ñ€ÑŒ_Ð´ÐµÐºÐ°Ð±Ñ€ÑŒ'.split('_')},monthsShort:{format:'Ð¯Ð½Ð²._Ð¤ÐµÐ²._ÐœÐ°Ñ€._ÐÐ¿Ñ€._ÐœÐ°Ñ_Ð˜ÑŽÐ½Ñ_ÐÑŽÐ»Ñ_ÐÐ²Ð³._Ð¡ÐµÐ½Ñ‚._ÐžÐºÑ‚._ÐÐ¾ÑÐ±._Ð”ÐµÐº.'.split('_'),standalone:'Ð¯Ð½Ð²._Ð¤ÐµÐ²._ÐœÐ°Ñ€Ñ‚_ÐÐ¿Ñ€._ÐœÐ°Ð¹_Ð˜ÑŽÐ½ÑŒ_ÐÑŽÐ»ÑŒ_ÐÐ²Ð³._Ð¡ÐµÐ½Ñ‚._ÐžÐºÑ‚._ÐÐ¾ÑÐ±._Ð”ÐµÐº.'.split('_')},weekdays:{standalone:'Ð²Ð¾ÑÐºÑ€ÐµÑÐµÐ½ÑŒÐµ_Ð¿Ð¾Ð½ÐµÐ´ÐµÐ»ÑŒÐ½Ð¸Ðº_Ð²Ñ‚Ð¾Ñ€Ð½Ð¸Ðº_ÑÑ€ÐµÐ´Ð°_Ñ‡ÐµÑ‚Ð²ÐµÑ€Ð³_Ð¿ÑÑ‚Ð½Ð¸Ñ†Ð°_ÑÑƒÐ±Ð±Ð¾Ñ‚Ð°'.split('_'),format:'Ð²Ð¾ÑÐºÑ€ÐµÑÐµÐ½ÑŒÐµ_Ð¿Ð¾Ð½ÐµÐ´ÐµÐ»ÑŒÐ½Ð¸Ðº_Ð²Ñ‚Ð¾Ñ€Ð½Ð¸Ðº_ÑÑ€ÐµÐ´Ñƒ_Ñ‡ÐµÑ‚Ð²ÐµÑ€Ð³_Ð¿ÑÑ‚Ð½Ð¸Ñ†Ñƒ_ÑÑƒÐ±Ð±Ð¾Ñ‚Ñƒ'.split('_'),isFormat:/\[ ?[Ð’Ð²] ?(?:Ð¿Ñ€Ð¾ÑˆÐ»ÑƒÑŽ|ÑÐ»ÐµÐ´ÑƒÑŽÑ‰ÑƒÑŽ|ÑÑ‚Ñƒ)? ?\] ?dddd/},weekdaysShort:'Ð²Ñ_Ð¿Ð½_Ð²Ñ‚_ÑÑ€_Ñ‡Ñ‚_Ð¿Ñ‚_ÑÐ±'.split('_'),weekdaysMin:'Ð²Ñ_Ð¿Ð½_Ð²Ñ‚_ÑÑ€_Ñ‡Ñ‚_Ð¿Ñ‚_ÑÐ±'.split('_'),monthsParse:monthsParse$6,longMonthsParse:monthsParse$6,shortMonthsParse:monthsParse$6,monthsRegex:/^(ÑÐ½Ð²Ð°Ñ€[ÑŒÑ]|ÑÐ½Ð²\.?|Ñ„ÐµÐ²Ñ€Ð°Ð»[ÑŒÑ]|Ñ„ÐµÐ²Ñ€?\.?|Ð¼Ð°Ñ€Ñ‚Ð°?|Ð¼Ð°Ñ€\.?|Ð°Ð¿Ñ€ÐµÐ»[ÑŒÑ]|Ð°Ð¿Ñ€\.?|Ð¼Ð°[Ð¹Ñ]|Ð¸ÑŽÐ½[ÑŒÑ]|Ð¸ÑŽÐ½\.?|Ð¸ÑŽÐ»[ÑŒÑ]|Ð¸ÑŽÐ»\.?|Ð°Ð²Ð³ÑƒÑÑ‚Ð°?|Ð°Ð²Ð³\.?|ÑÐµÐ½Ñ‚ÑÐ±Ñ€[ÑŒÑ]|ÑÐµÐ½Ñ‚?\.?|Ð¾ÐºÑ‚ÑÐ±Ñ€[ÑŒÑ]|Ð¾ÐºÑ‚\.?|Ð½Ð¾ÑÐ±Ñ€[ÑŒÑ]|Ð½Ð¾ÑÐ±?\.?|Ð´ÐµÐºÐ°Ð±Ñ€[ÑŒÑ]|Ð´ÐµÐº\.?)/i,monthsShortRegex:/^(ÑÐ½Ð²Ð°Ñ€[ÑŒÑ]|ÑÐ½Ð²\.?|Ñ„ÐµÐ²Ñ€Ð°Ð»[ÑŒÑ]|Ñ„ÐµÐ²Ñ€?\.?|Ð¼Ð°Ñ€Ñ‚Ð°?|Ð¼Ð°Ñ€\.?|Ð°Ð¿Ñ€ÐµÐ»[ÑŒÑ]|Ð°Ð¿Ñ€\.?|Ð¼Ð°[Ð¹Ñ]|Ð¸ÑŽÐ½[ÑŒÑ]|Ð¸ÑŽÐ½\.?|Ð¸ÑŽÐ»[ÑŒÑ]|Ð¸ÑŽÐ»\.?|Ð°Ð²Ð³ÑƒÑÑ‚Ð°?|Ð°Ð²Ð³\.?|ÑÐµÐ½Ñ‚ÑÐ±Ñ€[ÑŒÑ]|ÑÐµÐ½Ñ‚?\.?|Ð¾ÐºÑ‚ÑÐ±Ñ€[ÑŒÑ]|Ð¾ÐºÑ‚\.?|Ð½Ð¾ÑÐ±Ñ€[ÑŒÑ]|Ð½Ð¾ÑÐ±?\.?|Ð´ÐµÐºÐ°Ð±Ñ€[ÑŒÑ]|Ð´ÐµÐº\.?)/i,monthsStrictRegex:/^(ÑÐ½Ð²Ð°Ñ€[ÑÑŒ]|Ñ„ÐµÐ²Ñ€Ð°Ð»[ÑÑŒ]|Ð¼Ð°Ñ€Ñ‚Ð°?|Ð°Ð¿Ñ€ÐµÐ»[ÑÑŒ]|Ð¼Ð°[ÑÐ¹]|Ð¸ÑŽÐ½[ÑÑŒ]|Ð¸ÑŽÐ»[ÑÑŒ]|Ð°Ð²Ð³ÑƒÑÑ‚Ð°?|ÑÐµÐ½Ñ‚ÑÐ±Ñ€[ÑÑŒ]|Ð¾ÐºÑ‚ÑÐ±Ñ€[ÑÑŒ]|Ð½Ð¾ÑÐ±Ñ€[ÑÑŒ]|Ð´ÐµÐºÐ°Ð±Ñ€[ÑÑŒ])/i,monthsShortStrictRegex:/^(ÑÐ½Ð²\.|Ñ„ÐµÐ²Ñ€?\.|Ð¼Ð°Ñ€[Ñ‚.]|Ð°Ð¿Ñ€\.|Ð¼Ð°[ÑÐ¹]|Ð¸ÑŽÐ½[ÑŒÑ.]|Ð¸ÑŽÐ»[ÑŒÑ.]|Ð°Ð²Ð³\.|ÑÐµÐ½Ñ‚?\.|Ð¾ÐºÑ‚\.|Ð½Ð¾ÑÐ±?\.|Ð´ÐµÐº\.)/i,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY Ð³.',LLL:'D MMMM YYYY Ð³., H:mm',LLLL:'dddd, D MMMM YYYY Ð³., H:mm'},calendar:{sameDay:'[Ð¡ÐµÐ³Ð¾Ð´Ð½Ñ, Ð²] LT',nextDay:'[Ð—Ð°Ð²Ñ‚Ñ€Ð°, Ð²] LT',lastDay:'[Ð’Ñ‡ÐµÑ€Ð°, Ð²] LT',nextWeek:function(now){if(now.week()!==this.week()){switch(this.day()){case 0:return '[Ð’ ÑÐ»ÐµÐ´ÑƒÑŽÑ‰ÐµÐµ] dddd, [Ð²] LT';case 1:case 2:case 4:return '[Ð’ ÑÐ»ÐµÐ´ÑƒÑŽÑ‰Ð¸Ð¹] dddd, [Ð²] LT';case 3:case 5:case 6:return '[Ð’ ÑÐ»ÐµÐ´ÑƒÑŽÑ‰ÑƒÑŽ] dddd, [Ð²] LT';}}else{if(this.day()===2){return '[Ð’Ð¾] dddd, [Ð²] LT';}else{return '[Ð’] dddd, [Ð²] LT';}}},lastWeek:function(now){if(now.week()!==this.week()){switch(this.day()){case 0:return '[Ð’ Ð¿Ñ€Ð¾ÑˆÐ»Ð¾Ðµ] dddd, [Ð²] LT';case 1:case 2:case 4:return '[Ð’ Ð¿Ñ€Ð¾ÑˆÐ»Ñ‹Ð¹] dddd, [Ð²] LT';case 3:case 5:case 6:return '[Ð’ Ð¿Ñ€Ð¾ÑˆÐ»ÑƒÑŽ] dddd, [Ð²] LT';}}else{if(this.day()===2){return '[Ð’Ð¾] dddd, [Ð²] LT';}else{return '[Ð’] dddd, [Ð²] LT';}}},sameElse:'L'},relativeTime:{future:'Ñ‡ÐµÑ€ÐµÐ· %s',past:'%s Ð½Ð°Ð·Ð°Ð´',s:'Ð½ÐµÑÐºÐ¾Ð»ÑŒÐºÐ¾ ÑÐµÐºÑƒÐ½Ð´',ss:relativeTimeWithPlural$3,m:relativeTimeWithPlural$3,mm:relativeTimeWithPlural$3,h:'Ñ‡Ð°Ñ',hh:relativeTimeWithPlural$3,d:'Ð´ÐµÐ½ÑŒ',dd:relativeTimeWithPlural$3,M:'Ð¼ÐµÑÑÑ†',MM:relativeTimeWithPlural$3,y:'Ð³Ð¾Ð´',yy:relativeTimeWithPlural$3},meridiemParse:/Ð½Ð¾Ñ‡Ð¸|ÑƒÑ‚Ñ€Ð°|Ð´Ð½Ñ|Ð²ÐµÑ‡ÐµÑ€Ð°/i,isPM:function(input){return /^(Ð´Ð½Ñ|Ð²ÐµÑ‡ÐµÑ€Ð°)$/.test(input);},meridiem:function(hour,minute,isLower){if(hour<4){return 'Ð½Ð¾Ñ‡Ð¸';}else if(hour<12){return 'ÑƒÑ‚Ñ€Ð°';}else if(hour<17){return 'Ð´Ð½Ñ';}else{return 'Ð²ÐµÑ‡ÐµÑ€Ð°';}},dayOfMonthOrdinalParse:/\d{1,2}-(Ð¹|Ð³Ð¾|Ñ)/,ordinal:function(number,period){switch(period){case 'M':case 'd':case 'DDD':return number+'-Ð¹';case 'D':return number+'-Ð³Ð¾';case 'w':case 'W':return number+'-Ñ';default:return number;}},week:{dow:1,doy:4}});var months$8=['Ø¬Ù†ÙˆØ±ÙŠ','ÙÙŠØ¨Ø±ÙˆØ±ÙŠ','Ù…Ø§Ø±Ú†','Ø§Ù¾Ø±ÙŠÙ„','Ù…Ø¦ÙŠ','Ø¬ÙˆÙ†','Ø¬ÙˆÙ„Ø§Ø¡Ù','Ø¢Ú¯Ø³Ù½','Ø³ÙŠÙ¾Ù½Ù…Ø¨Ø±','Ø¢ÚªÙ½ÙˆØ¨Ø±','Ù†ÙˆÙ…Ø¨Ø±','ÚŠØ³Ù…Ø¨Ø±'];var days$1=['Ø¢Ú†Ø±','Ø³ÙˆÙ…Ø±','Ø§Ú±Ø§Ø±Ùˆ','Ø§Ø±Ø¨Ø¹','Ø®Ù…ÙŠØ³','Ø¬Ù…Ø¹','Ú‡Ù†Ú‡Ø±'];hooks.defineLocale('sd',{months:months$8,monthsShort:months$8,weekdays:days$1,weekdaysShort:days$1,weekdaysMin:days$1,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'ddddØŒ D MMMM YYYY HH:mm'},meridiemParse:/ØµØ¨Ø|Ø´Ø§Ù…/,isPM:function(input){return 'Ø´Ø§Ù…'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'ØµØ¨Ø';}
return 'Ø´Ø§Ù…';},calendar:{sameDay:'[Ø§Ú„] LT',nextDay:'[Ø³Ú€Ø§Ú»ÙŠ] LT',nextWeek:'dddd [Ø§Ú³ÙŠÙ† Ù‡ÙØªÙŠ ØªÙŠ] LT',lastDay:'[ÚªØ§Ù„Ù‡Ù‡] LT',lastWeek:'[Ú¯Ø²Ø±ÙŠÙ„ Ù‡ÙØªÙŠ] dddd [ØªÙŠ] LT',sameElse:'L'},relativeTime:{future:'%s Ù¾ÙˆØ¡',past:'%s Ø§Ú³',s:'Ú†Ù†Ø¯ Ø³ÙŠÚªÙ†ÚŠ',ss:'%d Ø³ÙŠÚªÙ†ÚŠ',m:'Ù‡Úª Ù…Ù†Ù½',mm:'%d Ù…Ù†Ù½',h:'Ù‡Úª ÚªÙ„Ø§Úª',hh:'%d ÚªÙ„Ø§Úª',d:'Ù‡Úª ÚÙŠÙ†Ù‡Ù†',dd:'%d ÚÙŠÙ†Ù‡Ù†',M:'Ù‡Úª Ù…Ù‡ÙŠÙ†Ùˆ',MM:'%d Ù…Ù‡ÙŠÙ†Ø§',y:'Ù‡Úª Ø³Ø§Ù„',yy:'%d Ø³Ø§Ù„'},preparse:function(string){return string.replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/,/g,'ØŒ');},week:{dow:1,doy:4}});hooks.defineLocale('se',{months:'oÄ‘Ä‘ajagemÃ¡nnu_guovvamÃ¡nnu_njukÄamÃ¡nnu_cuoÅ‹omÃ¡nnu_miessemÃ¡nnu_geassemÃ¡nnu_suoidnemÃ¡nnu_borgemÃ¡nnu_ÄakÄamÃ¡nnu_golggotmÃ¡nnu_skÃ¡bmamÃ¡nnu_juovlamÃ¡nnu'.split('_'),monthsShort:'oÄ‘Ä‘j_guov_njuk_cuo_mies_geas_suoi_borg_ÄakÄ_golg_skÃ¡b_juov'.split('_'),weekdays:'sotnabeaivi_vuossÃ¡rga_maÅ‹Å‹ebÃ¡rga_gaskavahkku_duorastat_bearjadat_lÃ¡vvardat'.split('_'),weekdaysShort:'sotn_vuos_maÅ‹_gask_duor_bear_lÃ¡v'.split('_'),weekdaysMin:'s_v_m_g_d_b_L'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'MMMM D. [b.] YYYY',LLL:'MMMM D. [b.] YYYY [ti.] HH:mm',LLLL:'dddd, MMMM D. [b.] YYYY [ti.] HH:mm'},calendar:{sameDay:'[otne ti] LT',nextDay:'[ihttin ti] LT',nextWeek:'dddd [ti] LT',lastDay:'[ikte ti] LT',lastWeek:'[ovddit] dddd [ti] LT',sameElse:'L'},relativeTime:{future:'%s geaÅ¾es',past:'maÅ‹it %s',s:'moadde sekunddat',ss:'%d sekunddat',m:'okta minuhta',mm:'%d minuhtat',h:'okta diimmu',hh:'%d diimmut',d:'okta beaivi',dd:'%d beaivvit',M:'okta mÃ¡nnu',MM:'%d mÃ¡nut',y:'okta jahki',yy:'%d jagit'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});hooks.defineLocale('si',{months:'à¶¢à¶±à·€à·à¶»à·’_à¶´à·™à¶¶à¶»à·€à·à¶»à·’_à¶¸à·à¶»à·Šà¶à·”_à¶…à¶´à·Šâ€à¶»à·šà¶½à·Š_à¶¸à·à¶ºà·’_à¶¢à·–à¶±à·’_à¶¢à·–à¶½à·’_à¶…à¶œà·à·ƒà·Šà¶à·”_à·ƒà·à¶´à·Šà¶à·à¶¸à·Šà¶¶à¶»à·Š_à¶”à¶šà·Šà¶à·à¶¶à¶»à·Š_à¶±à·œà·€à·à¶¸à·Šà¶¶à¶»à·Š_à¶¯à·™à·ƒà·à¶¸à·Šà¶¶à¶»à·Š'.split('_'),monthsShort:'à¶¢à¶±_à¶´à·™à¶¶_à¶¸à·à¶»à·Š_à¶…à¶´à·Š_à¶¸à·à¶ºà·’_à¶¢à·–à¶±à·’_à¶¢à·–à¶½à·’_à¶…à¶œà·_à·ƒà·à¶´à·Š_à¶”à¶šà·Š_à¶±à·œà·€à·_à¶¯à·™à·ƒà·'.split('_'),weekdays:'à¶‰à¶»à·’à¶¯à·_à·ƒà¶³à·”à¶¯à·_à¶…à¶Ÿà·„à¶»à·”à·€à·à¶¯à·_à¶¶à¶¯à·à¶¯à·_à¶¶à·Šâ€à¶»à·„à·ƒà·Šà¶´à¶à·’à¶±à·Šà¶¯à·_à·ƒà·’à¶šà·”à¶»à·à¶¯à·_à·ƒà·™à¶±à·ƒà·”à¶»à·à¶¯à·'.split('_'),weekdaysShort:'à¶‰à¶»à·’_à·ƒà¶³à·”_à¶…à¶Ÿ_à¶¶à¶¯à·_à¶¶à·Šâ€à¶»à·„_à·ƒà·’à¶šà·”_à·ƒà·™à¶±'.split('_'),weekdaysMin:'à¶‰_à·ƒ_à¶…_à¶¶_à¶¶à·Šâ€à¶»_à·ƒà·’_à·ƒà·™'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'a h:mm',LTS:'a h:mm:ss',L:'YYYY/MM/DD',LL:'YYYY MMMM D',LLL:'YYYY MMMM D, a h:mm',LLLL:'YYYY MMMM D [à·€à·à¶±à·’] dddd, a h:mm:ss'},calendar:{sameDay:'[à¶…à¶¯] LT[à¶§]',nextDay:'[à·„à·™à¶§] LT[à¶§]',nextWeek:'dddd LT[à¶§]',lastDay:'[à¶Šà¶ºà·š] LT[à¶§]',lastWeek:'[à¶´à·ƒà·”à¶œà·’à¶º] dddd LT[à¶§]',sameElse:'L'},relativeTime:{future:'%sà¶šà·’à¶±à·Š',past:'%sà¶šà¶§ à¶´à·™à¶»',s:'à¶à¶à·Šà¶´à¶» à¶šà·’à·„à·’à¶´à¶º',ss:'à¶à¶à·Šà¶´à¶» %d',m:'à¶¸à·’à¶±à·’à¶à·Šà¶à·”à·€',mm:'à¶¸à·’à¶±à·’à¶à·Šà¶à·” %d',h:'à¶´à·à¶º',hh:'à¶´à·à¶º %d',d:'à¶¯à·’à¶±à¶º',dd:'à¶¯à·’à¶± %d',M:'à¶¸à·à·ƒà¶º',MM:'à¶¸à·à·ƒ %d',y:'à·€à·ƒà¶»',yy:'à·€à·ƒà¶» %d'},dayOfMonthOrdinalParse:/\d{1,2} à·€à·à¶±à·’/,ordinal:function(number){return number+' à·€à·à¶±à·’';},meridiemParse:/à¶´à·™à¶» à·€à¶»à·”|à¶´à·ƒà·Š à·€à¶»à·”|à¶´à·™.à·€|à¶´.à·€./,isPM:function(input){return input==='à¶´.à·€.'||input==='à¶´à·ƒà·Š à·€à¶»à·”';},meridiem:function(hours,minutes,isLower){if(hours>11){return isLower?'à¶´.à·€.':'à¶´à·ƒà·Š à·€à¶»à·”';}else{return isLower?'à¶´à·™.à·€.':'à¶´à·™à¶» à·€à¶»à·”';}}});var months$9='januÃ¡r_februÃ¡r_marec_aprÃl_mÃ¡j_jÃºn_jÃºl_august_september_oktÃ³ber_november_december'.split('_'),monthsShort$6='jan_feb_mar_apr_mÃ¡j_jÃºn_jÃºl_aug_sep_okt_nov_dec'.split('_');function plural$5(n){return(n>1)&&(n<5);}
function translate$9(number,withoutSuffix,key,isFuture){var result=number+' ';switch(key){case 's':return(withoutSuffix||isFuture)?'pÃ¡r sekÃºnd':'pÃ¡r sekundami';case 'ss':if(withoutSuffix||isFuture){return result+(plural$5(number)?'sekundy':'sekÃºnd');}else{return result+'sekundami';}
break;case 'm':return withoutSuffix?'minÃºta':(isFuture?'minÃºtu':'minÃºtou');case 'mm':if(withoutSuffix||isFuture){return result+(plural$5(number)?'minÃºty':'minÃºt');}else{return result+'minÃºtami';}
break;case 'h':return withoutSuffix?'hodina':(isFuture?'hodinu':'hodinou');case 'hh':if(withoutSuffix||isFuture){return result+(plural$5(number)?'hodiny':'hodÃn');}else{return result+'hodinami';}
break;case 'd':return(withoutSuffix||isFuture)?'deÅˆ':'dÅˆom';case 'dd':if(withoutSuffix||isFuture){return result+(plural$5(number)?'dni':'dnÃ');}else{return result+'dÅˆami';}
break;case 'M':return(withoutSuffix||isFuture)?'mesiac':'mesiacom';case 'MM':if(withoutSuffix||isFuture){return result+(plural$5(number)?'mesiace':'mesiacov');}else{return result+'mesiacmi';}
break;case 'y':return(withoutSuffix||isFuture)?'rok':'rokom';case 'yy':if(withoutSuffix||isFuture){return result+(plural$5(number)?'roky':'rokov');}else{return result+'rokmi';}
break;}}
hooks.defineLocale('sk',{months:months$9,monthsShort:monthsShort$6,weekdays:'nedeÄ¾a_pondelok_utorok_streda_Å¡tvrtok_piatok_sobota'.split('_'),weekdaysShort:'ne_po_ut_st_Å¡t_pi_so'.split('_'),weekdaysMin:'ne_po_ut_st_Å¡t_pi_so'.split('_'),longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd D. MMMM YYYY H:mm'},calendar:{sameDay:'[dnes o] LT',nextDay:'[zajtra o] LT',nextWeek:function(){switch(this.day()){case 0:return '[v nedeÄ¾u o] LT';case 1:case 2:return '[v] dddd [o] LT';case 3:return '[v stredu o] LT';case 4:return '[vo Å¡tvrtok o] LT';case 5:return '[v piatok o] LT';case 6:return '[v sobotu o] LT';}},lastDay:'[vÄera o] LT',lastWeek:function(){switch(this.day()){case 0:return '[minulÃº nedeÄ¾u o] LT';case 1:case 2:return '[minulÃ½] dddd [o] LT';case 3:return '[minulÃº stredu o] LT';case 4:case 5:return '[minulÃ½] dddd [o] LT';case 6:return '[minulÃº sobotu o] LT';}},sameElse:'L'},relativeTime:{future:'za %s',past:'pred %s',s:translate$9,ss:translate$9,m:translate$9,mm:translate$9,h:translate$9,hh:translate$9,d:translate$9,dd:translate$9,M:translate$9,MM:translate$9,y:translate$9,yy:translate$9},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});function processRelativeTime$6(number,withoutSuffix,key,isFuture){var result=number+' ';switch(key){case 's':return withoutSuffix||isFuture?'nekaj sekund':'nekaj sekundami';case 'ss':if(number===1){result+=withoutSuffix?'sekundo':'sekundi';}else if(number===2){result+=withoutSuffix||isFuture?'sekundi':'sekundah';}else if(number<5){result+=withoutSuffix||isFuture?'sekunde':'sekundah';}else{result+='sekund';}
return result;case 'm':return withoutSuffix?'ena minuta':'eno minuto';case 'mm':if(number===1){result+=withoutSuffix?'minuta':'minuto';}else if(number===2){result+=withoutSuffix||isFuture?'minuti':'minutama';}else if(number<5){result+=withoutSuffix||isFuture?'minute':'minutami';}else{result+=withoutSuffix||isFuture?'minut':'minutami';}
return result;case 'h':return withoutSuffix?'ena ura':'eno uro';case 'hh':if(number===1){result+=withoutSuffix?'ura':'uro';}else if(number===2){result+=withoutSuffix||isFuture?'uri':'urama';}else if(number<5){result+=withoutSuffix||isFuture?'ure':'urami';}else{result+=withoutSuffix||isFuture?'ur':'urami';}
return result;case 'd':return withoutSuffix||isFuture?'en dan':'enim dnem';case 'dd':if(number===1){result+=withoutSuffix||isFuture?'dan':'dnem';}else if(number===2){result+=withoutSuffix||isFuture?'dni':'dnevoma';}else{result+=withoutSuffix||isFuture?'dni':'dnevi';}
return result;case 'M':return withoutSuffix||isFuture?'en mesec':'enim mesecem';case 'MM':if(number===1){result+=withoutSuffix||isFuture?'mesec':'mesecem';}else if(number===2){result+=withoutSuffix||isFuture?'meseca':'mesecema';}else if(number<5){result+=withoutSuffix||isFuture?'mesece':'meseci';}else{result+=withoutSuffix||isFuture?'mesecev':'meseci';}
return result;case 'y':return withoutSuffix||isFuture?'eno leto':'enim letom';case 'yy':if(number===1){result+=withoutSuffix||isFuture?'leto':'letom';}else if(number===2){result+=withoutSuffix||isFuture?'leti':'letoma';}else if(number<5){result+=withoutSuffix||isFuture?'leta':'leti';}else{result+=withoutSuffix||isFuture?'let':'leti';}
return result;}}
hooks.defineLocale('sl',{months:'januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december'.split('_'),monthsShort:'jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'nedelja_ponedeljek_torek_sreda_Äetrtek_petek_sobota'.split('_'),weekdaysShort:'ned._pon._tor._sre._Äet._pet._sob.'.split('_'),weekdaysMin:'ne_po_to_sr_Äe_pe_so'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[danes ob] LT',nextDay:'[jutri ob] LT',nextWeek:function(){switch(this.day()){case 0:return '[v] [nedeljo] [ob] LT';case 3:return '[v] [sredo] [ob] LT';case 6:return '[v] [soboto] [ob] LT';case 1:case 2:case 4:case 5:return '[v] dddd [ob] LT';}},lastDay:'[vÄeraj ob] LT',lastWeek:function(){switch(this.day()){case 0:return '[prejÅ¡njo] [nedeljo] [ob] LT';case 3:return '[prejÅ¡njo] [sredo] [ob] LT';case 6:return '[prejÅ¡njo] [soboto] [ob] LT';case 1:case 2:case 4:case 5:return '[prejÅ¡nji] dddd [ob] LT';}},sameElse:'L'},relativeTime:{future:'Äez %s',past:'pred %s',s:processRelativeTime$6,ss:processRelativeTime$6,m:processRelativeTime$6,mm:processRelativeTime$6,h:processRelativeTime$6,hh:processRelativeTime$6,d:processRelativeTime$6,dd:processRelativeTime$6,M:processRelativeTime$6,MM:processRelativeTime$6,y:processRelativeTime$6,yy:processRelativeTime$6},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});hooks.defineLocale('sq',{months:'Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_NÃ«ntor_Dhjetor'.split('_'),monthsShort:'Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_NÃ«n_Dhj'.split('_'),weekdays:'E Diel_E HÃ«nÃ«_E MartÃ«_E MÃ«rkurÃ«_E Enjte_E Premte_E ShtunÃ«'.split('_'),weekdaysShort:'Die_HÃ«n_Mar_MÃ«r_Enj_Pre_Sht'.split('_'),weekdaysMin:'D_H_Ma_MÃ«_E_P_Sh'.split('_'),weekdaysParseExact:true,meridiemParse:/PD|MD/,isPM:function(input){return input.charAt(0)==='M';},meridiem:function(hours,minutes,isLower){return hours<12?'PD':'MD';},longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Sot nÃ«] LT',nextDay:'[NesÃ«r nÃ«] LT',nextWeek:'dddd [nÃ«] LT',lastDay:'[Dje nÃ«] LT',lastWeek:'dddd [e kaluar nÃ«] LT',sameElse:'L'},relativeTime:{future:'nÃ« %s',past:'%s mÃ« parÃ«',s:'disa sekonda',ss:'%d sekonda',m:'njÃ« minutÃ«',mm:'%d minuta',h:'njÃ« orÃ«',hh:'%d orÃ«',d:'njÃ« ditÃ«',dd:'%d ditÃ«',M:'njÃ« muaj',MM:'%d muaj',y:'njÃ« vit',yy:'%d vite'},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var translator$1={words:{ss:['ÑÐµÐºÑƒÐ½Ð´Ð°','ÑÐµÐºÑƒÐ½Ð´Ðµ','ÑÐµÐºÑƒÐ½Ð´Ð¸'],m:['Ñ˜ÐµÐ´Ð°Ð½ Ð¼Ð¸Ð½ÑƒÑ‚','Ñ˜ÐµÐ´Ð½Ðµ Ð¼Ð¸Ð½ÑƒÑ‚Ðµ'],mm:['Ð¼Ð¸Ð½ÑƒÑ‚','Ð¼Ð¸Ð½ÑƒÑ‚Ðµ','Ð¼Ð¸Ð½ÑƒÑ‚Ð°'],h:['Ñ˜ÐµÐ´Ð°Ð½ ÑÐ°Ñ‚','Ñ˜ÐµÐ´Ð½Ð¾Ð³ ÑÐ°Ñ‚Ð°'],hh:['ÑÐ°Ñ‚','ÑÐ°Ñ‚Ð°','ÑÐ°Ñ‚Ð¸'],dd:['Ð´Ð°Ð½','Ð´Ð°Ð½Ð°','Ð´Ð°Ð½Ð°'],MM:['Ð¼ÐµÑÐµÑ†','Ð¼ÐµÑÐµÑ†Ð°','Ð¼ÐµÑÐµÑ†Ð¸'],yy:['Ð³Ð¾Ð´Ð¸Ð½Ð°','Ð³Ð¾Ð´Ð¸Ð½Ðµ','Ð³Ð¾Ð´Ð¸Ð½Ð°']},correctGrammaticalCase:function(number,wordKey){return number===1?wordKey[0]:(number>=2&&number<=4?wordKey[1]:wordKey[2]);},translate:function(number,withoutSuffix,key){var wordKey=translator$1.words[key];if(key.length===1){return withoutSuffix?wordKey[0]:wordKey[1];}else{return number+' '+translator$1.correctGrammaticalCase(number,wordKey);}}};hooks.defineLocale('sr-cyrl',{months:'Ñ˜Ð°Ð½ÑƒÐ°Ñ€_Ñ„ÐµÐ±Ñ€ÑƒÐ°Ñ€_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€Ð¸Ð»_Ð¼Ð°Ñ˜_Ñ˜ÑƒÐ½_Ñ˜ÑƒÐ»_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ¿Ñ‚ÐµÐ¼Ð±Ð°Ñ€_Ð¾ÐºÑ‚Ð¾Ð±Ð°Ñ€_Ð½Ð¾Ð²ÐµÐ¼Ð±Ð°Ñ€_Ð´ÐµÑ†ÐµÐ¼Ð±Ð°Ñ€'.split('_'),monthsShort:'Ñ˜Ð°Ð½._Ñ„ÐµÐ±._Ð¼Ð°Ñ€._Ð°Ð¿Ñ€._Ð¼Ð°Ñ˜_Ñ˜ÑƒÐ½_Ñ˜ÑƒÐ»_Ð°Ð²Ð³._ÑÐµÐ¿._Ð¾ÐºÑ‚._Ð½Ð¾Ð²._Ð´ÐµÑ†.'.split('_'),monthsParseExact:true,weekdays:'Ð½ÐµÐ´ÐµÑ™Ð°_Ð¿Ð¾Ð½ÐµÐ´ÐµÑ™Ð°Ðº_ÑƒÑ‚Ð¾Ñ€Ð°Ðº_ÑÑ€ÐµÐ´Ð°_Ñ‡ÐµÑ‚Ð²Ñ€Ñ‚Ð°Ðº_Ð¿ÐµÑ‚Ð°Ðº_ÑÑƒÐ±Ð¾Ñ‚Ð°'.split('_'),weekdaysShort:'Ð½ÐµÐ´._Ð¿Ð¾Ð½._ÑƒÑ‚Ð¾._ÑÑ€Ðµ._Ñ‡ÐµÑ‚._Ð¿ÐµÑ‚._ÑÑƒÐ±.'.split('_'),weekdaysMin:'Ð½Ðµ_Ð¿Ð¾_ÑƒÑ‚_ÑÑ€_Ñ‡Ðµ_Ð¿Ðµ_ÑÑƒ'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[Ð´Ð°Ð½Ð°Ñ Ñƒ] LT',nextDay:'[ÑÑƒÑ‚Ñ€Ð° Ñƒ] LT',nextWeek:function(){switch(this.day()){case 0:return '[Ñƒ] [Ð½ÐµÐ´ÐµÑ™Ñƒ] [Ñƒ] LT';case 3:return '[Ñƒ] [ÑÑ€ÐµÐ´Ñƒ] [Ñƒ] LT';case 6:return '[Ñƒ] [ÑÑƒÐ±Ð¾Ñ‚Ñƒ] [Ñƒ] LT';case 1:case 2:case 4:case 5:return '[Ñƒ] dddd [Ñƒ] LT';}},lastDay:'[Ñ˜ÑƒÑ‡Ðµ Ñƒ] LT',lastWeek:function(){var lastWeekDays=['[Ð¿Ñ€Ð¾ÑˆÐ»Ðµ] [Ð½ÐµÐ´ÐµÑ™Ðµ] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ð¾Ð³] [Ð¿Ð¾Ð½ÐµÐ´ÐµÑ™ÐºÐ°] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ð¾Ð³] [ÑƒÑ‚Ð¾Ñ€ÐºÐ°] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ðµ] [ÑÑ€ÐµÐ´Ðµ] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ð¾Ð³] [Ñ‡ÐµÑ‚Ð²Ñ€Ñ‚ÐºÐ°] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ð¾Ð³] [Ð¿ÐµÑ‚ÐºÐ°] [Ñƒ] LT','[Ð¿Ñ€Ð¾ÑˆÐ»Ðµ] [ÑÑƒÐ±Ð¾Ñ‚Ðµ] [Ñƒ] LT'];return lastWeekDays[this.day()];},sameElse:'L'},relativeTime:{future:'Ð·Ð° %s',past:'Ð¿Ñ€Ðµ %s',s:'Ð½ÐµÐºÐ¾Ð»Ð¸ÐºÐ¾ ÑÐµÐºÑƒÐ½Ð´Ð¸',ss:translator$1.translate,m:translator$1.translate,mm:translator$1.translate,h:translator$1.translate,hh:translator$1.translate,d:'Ð´Ð°Ð½',dd:translator$1.translate,M:'Ð¼ÐµÑÐµÑ†',MM:translator$1.translate,y:'Ð³Ð¾Ð´Ð¸Ð½Ñƒ',yy:translator$1.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});var translator$2={words:{ss:['sekunda','sekunde','sekundi'],m:['jedan minut','jedne minute'],mm:['minut','minute','minuta'],h:['jedan sat','jednog sata'],hh:['sat','sata','sati'],dd:['dan','dana','dana'],MM:['mesec','meseca','meseci'],yy:['godina','godine','godina']},correctGrammaticalCase:function(number,wordKey){return number===1?wordKey[0]:(number>=2&&number<=4?wordKey[1]:wordKey[2]);},translate:function(number,withoutSuffix,key){var wordKey=translator$2.words[key];if(key.length===1){return withoutSuffix?wordKey[0]:wordKey[1];}else{return number+' '+translator$2.correctGrammaticalCase(number,wordKey);}}};hooks.defineLocale('sr',{months:'januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar'.split('_'),monthsShort:'jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.'.split('_'),monthsParseExact:true,weekdays:'nedelja_ponedeljak_utorak_sreda_Äetvrtak_petak_subota'.split('_'),weekdaysShort:'ned._pon._uto._sre._Äet._pet._sub.'.split('_'),weekdaysMin:'ne_po_ut_sr_Äe_pe_su'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD.MM.YYYY',LL:'D. MMMM YYYY',LLL:'D. MMMM YYYY H:mm',LLLL:'dddd, D. MMMM YYYY H:mm'},calendar:{sameDay:'[danas u] LT',nextDay:'[sutra u] LT',nextWeek:function(){switch(this.day()){case 0:return '[u] [nedelju] [u] LT';case 3:return '[u] [sredu] [u] LT';case 6:return '[u] [subotu] [u] LT';case 1:case 2:case 4:case 5:return '[u] dddd [u] LT';}},lastDay:'[juÄe u] LT',lastWeek:function(){var lastWeekDays=['[proÅ¡le] [nedelje] [u] LT','[proÅ¡log] [ponedeljka] [u] LT','[proÅ¡log] [utorka] [u] LT','[proÅ¡le] [srede] [u] LT','[proÅ¡log] [Äetvrtka] [u] LT','[proÅ¡log] [petka] [u] LT','[proÅ¡le] [subote] [u] LT'];return lastWeekDays[this.day()];},sameElse:'L'},relativeTime:{future:'za %s',past:'pre %s',s:'nekoliko sekundi',ss:translator$2.translate,m:translator$2.translate,mm:translator$2.translate,h:translator$2.translate,hh:translator$2.translate,d:'dan',dd:translator$2.translate,M:'mesec',MM:translator$2.translate,y:'godinu',yy:translator$2.translate},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:7}});hooks.defineLocale('ss',{months:"Bhimbidvwane_Indlovana_Indlov'lenkhulu_Mabasa_Inkhwekhweti_Inhlaba_Kholwane_Ingci_Inyoni_Imphala_Lweti_Ingongoni".split('_'),monthsShort:'Bhi_Ina_Inu_Mab_Ink_Inh_Kho_Igc_Iny_Imp_Lwe_Igo'.split('_'),weekdays:'Lisontfo_Umsombuluko_Lesibili_Lesitsatfu_Lesine_Lesihlanu_Umgcibelo'.split('_'),weekdaysShort:'Lis_Umb_Lsb_Les_Lsi_Lsh_Umg'.split('_'),weekdaysMin:'Li_Us_Lb_Lt_Ls_Lh_Ug'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendar:{sameDay:'[Namuhla nga] LT',nextDay:'[Kusasa nga] LT',nextWeek:'dddd [nga] LT',lastDay:'[Itolo nga] LT',lastWeek:'dddd [leliphelile] [nga] LT',sameElse:'L'},relativeTime:{future:'nga %s',past:'wenteka nga %s',s:'emizuzwana lomcane',ss:'%d mzuzwana',m:'umzuzu',mm:'%d emizuzu',h:'lihora',hh:'%d emahora',d:'lilanga',dd:'%d emalanga',M:'inyanga',MM:'%d tinyanga',y:'umnyaka',yy:'%d iminyaka'},meridiemParse:/ekuseni|emini|entsambama|ebusuku/,meridiem:function(hours,minutes,isLower){if(hours<11){return 'ekuseni';}else if(hours<15){return 'emini';}else if(hours<19){return 'entsambama';}else{return 'ebusuku';}},meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='ekuseni'){return hour;}else if(meridiem==='emini'){return hour>=11?hour:hour+12;}else if(meridiem==='entsambama'||meridiem==='ebusuku'){if(hour===0){return 0;}
return hour+12;}},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:'%d',week:{dow:1,doy:4}});hooks.defineLocale('sv',{months:'januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december'.split('_'),monthsShort:'jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec'.split('_'),weekdays:'sÃ¶ndag_mÃ¥ndag_tisdag_onsdag_torsdag_fredag_lÃ¶rdag'.split('_'),weekdaysShort:'sÃ¶n_mÃ¥n_tis_ons_tor_fre_lÃ¶r'.split('_'),weekdaysMin:'sÃ¶_mÃ¥_ti_on_to_fr_lÃ¶'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'D MMMM YYYY',LLL:'D MMMM YYYY [kl.] HH:mm',LLLL:'dddd D MMMM YYYY [kl.] HH:mm',lll:'D MMM YYYY HH:mm',llll:'ddd D MMM YYYY HH:mm'},calendar:{sameDay:'[Idag] LT',nextDay:'[Imorgon] LT',lastDay:'[IgÃ¥r] LT',nextWeek:'[PÃ¥] dddd LT',lastWeek:'[I] dddd[s] LT',sameElse:'L'},relativeTime:{future:'om %s',past:'fÃ¶r %s sedan',s:'nÃ¥gra sekunder',ss:'%d sekunder',m:'en minut',mm:'%d minuter',h:'en timme',hh:'%d timmar',d:'en dag',dd:'%d dagar',M:'en mÃ¥nad',MM:'%d mÃ¥nader',y:'ett Ã¥r',yy:'%d Ã¥r'},dayOfMonthOrdinalParse:/\d{1,2}(e|a)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'e':(b===1)?'a':(b===2)?'a':(b===3)?'e':'e';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('sw',{months:'Januari_Februari_Machi_Aprili_Mei_Juni_Julai_Agosti_Septemba_Oktoba_Novemba_Desemba'.split('_'),monthsShort:'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ago_Sep_Okt_Nov_Des'.split('_'),weekdays:'Jumapili_Jumatatu_Jumanne_Jumatano_Alhamisi_Ijumaa_Jumamosi'.split('_'),weekdaysShort:'Jpl_Jtat_Jnne_Jtan_Alh_Ijm_Jmos'.split('_'),weekdaysMin:'J2_J3_J4_J5_Al_Ij_J1'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[leo saa] LT',nextDay:'[kesho saa] LT',nextWeek:'[wiki ijayo] dddd [saat] LT',lastDay:'[jana] LT',lastWeek:'[wiki iliyopita] dddd [saat] LT',sameElse:'L'},relativeTime:{future:'%s baadaye',past:'tokea %s',s:'hivi punde',ss:'sekunde %d',m:'dakika moja',mm:'dakika %d',h:'saa limoja',hh:'masaa %d',d:'siku moja',dd:'masiku %d',M:'mwezi mmoja',MM:'miezi %d',y:'mwaka mmoja',yy:'miaka %d'},week:{dow:1,doy:7}});var symbolMap$f={'1':'à¯§','2':'à¯¨','3':'à¯©','4':'à¯ª','5':'à¯«','6':'à¯¬','7':'à¯','8':'à¯®','9':'à¯¯','0':'à¯¦'},numberMap$e={'à¯§':'1','à¯¨':'2','à¯©':'3','à¯ª':'4','à¯«':'5','à¯¬':'6','à¯':'7','à¯®':'8','à¯¯':'9','à¯¦':'0'};hooks.defineLocale('ta',{months:'à®œà®©à®µà®°à®¿_à®ªà®¿à®ªà¯à®°à®µà®°à®¿_à®®à®¾à®°à¯à®šà¯_à®à®ªà¯à®°à®²à¯_à®®à¯‡_à®œà¯‚à®©à¯_à®œà¯‚à®²à¯ˆ_à®†à®•à®¸à¯à®Ÿà¯_à®šà¯†à®ªà¯à®Ÿà¯†à®®à¯à®ªà®°à¯_à®…à®•à¯à®Ÿà¯‹à®ªà®°à¯_à®¨à®µà®®à¯à®ªà®°à¯_à®Ÿà®¿à®šà®®à¯à®ªà®°à¯'.split('_'),monthsShort:'à®œà®©à®µà®°à®¿_à®ªà®¿à®ªà¯à®°à®µà®°à®¿_à®®à®¾à®°à¯à®šà¯_à®à®ªà¯à®°à®²à¯_à®®à¯‡_à®œà¯‚à®©à¯_à®œà¯‚à®²à¯ˆ_à®†à®•à®¸à¯à®Ÿà¯_à®šà¯†à®ªà¯à®Ÿà¯†à®®à¯à®ªà®°à¯_à®…à®•à¯à®Ÿà¯‹à®ªà®°à¯_à®¨à®µà®®à¯à®ªà®°à¯_à®Ÿà®¿à®šà®®à¯à®ªà®°à¯'.split('_'),weekdays:'à®žà®¾à®¯à®¿à®±à¯à®±à¯à®•à¯à®•à®¿à®´à®®à¯ˆ_à®¤à®¿à®™à¯à®•à®Ÿà¯à®•à®¿à®´à®®à¯ˆ_à®šà¯†à®µà¯à®µà®¾à®¯à¯à®•à®¿à®´à®®à¯ˆ_à®ªà¯à®¤à®©à¯à®•à®¿à®´à®®à¯ˆ_à®µà®¿à®¯à®¾à®´à®•à¯à®•à®¿à®´à®®à¯ˆ_à®µà¯†à®³à¯à®³à®¿à®•à¯à®•à®¿à®´à®®à¯ˆ_à®šà®©à®¿à®•à¯à®•à®¿à®´à®®à¯ˆ'.split('_'),weekdaysShort:'à®žà®¾à®¯à®¿à®±à¯_à®¤à®¿à®™à¯à®•à®³à¯_à®šà¯†à®µà¯à®µà®¾à®¯à¯_à®ªà¯à®¤à®©à¯_à®µà®¿à®¯à®¾à®´à®©à¯_à®µà¯†à®³à¯à®³à®¿_à®šà®©à®¿'.split('_'),weekdaysMin:'à®žà®¾_à®¤à®¿_à®šà¯†_à®ªà¯_à®µà®¿_à®µà¯†_à®š'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, HH:mm',LLLL:'dddd, D MMMM YYYY, HH:mm'},calendar:{sameDay:'[à®‡à®©à¯à®±à¯] LT',nextDay:'[à®¨à®¾à®³à¯ˆ] LT',nextWeek:'dddd, LT',lastDay:'[à®¨à¯‡à®±à¯à®±à¯] LT',lastWeek:'[à®•à®Ÿà®¨à¯à®¤ à®µà®¾à®°à®®à¯] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à®‡à®²à¯',past:'%s à®®à¯à®©à¯',s:'à®’à®°à¯ à®šà®¿à®² à®µà®¿à®¨à®¾à®Ÿà®¿à®•à®³à¯',ss:'%d à®µà®¿à®¨à®¾à®Ÿà®¿à®•à®³à¯',m:'à®’à®°à¯ à®¨à®¿à®®à®¿à®Ÿà®®à¯',mm:'%d à®¨à®¿à®®à®¿à®Ÿà®™à¯à®•à®³à¯',h:'à®’à®°à¯ à®®à®£à®¿ à®¨à¯‡à®°à®®à¯',hh:'%d à®®à®£à®¿ à®¨à¯‡à®°à®®à¯',d:'à®’à®°à¯ à®¨à®¾à®³à¯',dd:'%d à®¨à®¾à®Ÿà¯à®•à®³à¯',M:'à®’à®°à¯ à®®à®¾à®¤à®®à¯',MM:'%d à®®à®¾à®¤à®™à¯à®•à®³à¯',y:'à®’à®°à¯ à®µà®°à¯à®Ÿà®®à¯',yy:'%d à®†à®£à¯à®Ÿà¯à®•à®³à¯'},dayOfMonthOrdinalParse:/\d{1,2}à®µà®¤à¯/,ordinal:function(number){return number+'à®µà®¤à¯';},preparse:function(string){return string.replace(/[à¯§à¯¨à¯©à¯ªà¯«à¯¬à¯à¯®à¯¯à¯¦]/g,function(match){return numberMap$e[match];});},postformat:function(string){return string.replace(/\d/g,function(match){return symbolMap$f[match];});},meridiemParse:/à®¯à®¾à®®à®®à¯|à®µà¯ˆà®•à®±à¯ˆ|à®•à®¾à®²à¯ˆ|à®¨à®£à¯à®ªà®•à®²à¯|à®Žà®±à¯à®ªà®¾à®Ÿà¯|à®®à®¾à®²à¯ˆ/,meridiem:function(hour,minute,isLower){if(hour<2){return ' à®¯à®¾à®®à®®à¯';}else if(hour<6){return ' à®µà¯ˆà®•à®±à¯ˆ';}else if(hour<10){return ' à®•à®¾à®²à¯ˆ';}else if(hour<14){return ' à®¨à®£à¯à®ªà®•à®²à¯';}else if(hour<18){return ' à®Žà®±à¯à®ªà®¾à®Ÿà¯';}else if(hour<22){return ' à®®à®¾à®²à¯ˆ';}else{return ' à®¯à®¾à®®à®®à¯';}},meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à®¯à®¾à®®à®®à¯'){return hour<2?hour:hour+12;}else if(meridiem==='à®µà¯ˆà®•à®±à¯ˆ'||meridiem==='à®•à®¾à®²à¯ˆ'){return hour;}else if(meridiem==='à®¨à®£à¯à®ªà®•à®²à¯'){return hour>=10?hour:hour+12;}else{return hour+12;}},week:{dow:0,doy:6}});hooks.defineLocale('te',{months:'à°œà°¨à°µà°°à°¿_à°«à°¿à°¬à±à°°à°µà°°à°¿_à°®à°¾à°°à±à°šà°¿_à°à°ªà±à°°à°¿à°²à±_à°®à±‡_à°œà±‚à°¨à±_à°œà±à°²à±ˆ_à°†à°—à°¸à±à°Ÿà±_à°¸à±†à°ªà±à°Ÿà±†à°‚à°¬à°°à±_à°…à°•à±à°Ÿà±‹à°¬à°°à±_à°¨à°µà°‚à°¬à°°à±_à°¡à°¿à°¸à±†à°‚à°¬à°°à±'.split('_'),monthsShort:'à°œà°¨._à°«à°¿à°¬à±à°°._à°®à°¾à°°à±à°šà°¿_à°à°ªà±à°°à°¿._à°®à±‡_à°œà±‚à°¨à±_à°œà±à°²à±ˆ_à°†à°—._à°¸à±†à°ªà±._à°…à°•à±à°Ÿà±‹._à°¨à°µ._à°¡à°¿à°¸à±†.'.split('_'),monthsParseExact:true,weekdays:'à°†à°¦à°¿à°µà°¾à°°à°‚_à°¸à±‹à°®à°µà°¾à°°à°‚_à°®à°‚à°—à°³à°µà°¾à°°à°‚_à°¬à±à°§à°µà°¾à°°à°‚_à°—à±à°°à±à°µà°¾à°°à°‚_à°¶à±à°•à±à°°à°µà°¾à°°à°‚_à°¶à°¨à°¿à°µà°¾à°°à°‚'.split('_'),weekdaysShort:'à°†à°¦à°¿_à°¸à±‹à°®_à°®à°‚à°—à°³_à°¬à±à°§_à°—à±à°°à±_à°¶à±à°•à±à°°_à°¶à°¨à°¿'.split('_'),weekdaysMin:'à°†_à°¸à±‹_à°®à°‚_à°¬à±_à°—à±_à°¶à±_à°¶'.split('_'),longDateFormat:{LT:'A h:mm',LTS:'A h:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY, A h:mm',LLLL:'dddd, D MMMM YYYY, A h:mm'},calendar:{sameDay:'[à°¨à±‡à°¡à±] LT',nextDay:'[à°°à±‡à°ªà±] LT',nextWeek:'dddd, LT',lastDay:'[à°¨à°¿à°¨à±à°¨] LT',lastWeek:'[à°—à°¤] dddd, LT',sameElse:'L'},relativeTime:{future:'%s à°²à±‹',past:'%s à°•à±à°°à°¿à°¤à°‚',s:'à°•à±Šà°¨à±à°¨à°¿ à°•à±à°·à°£à°¾à°²à±',ss:'%d à°¸à±†à°•à°¨à±à°²à±',m:'à°’à°• à°¨à°¿à°®à°¿à°·à°‚',mm:'%d à°¨à°¿à°®à°¿à°·à°¾à°²à±',h:'à°’à°• à°—à°‚à°Ÿ',hh:'%d à°—à°‚à°Ÿà°²à±',d:'à°’à°• à°°à±‹à°œà±',dd:'%d à°°à±‹à°œà±à°²à±',M:'à°’à°• à°¨à±†à°²',MM:'%d à°¨à±†à°²à°²à±',y:'à°’à°• à°¸à°‚à°µà°¤à±à°¸à°°à°‚',yy:'%d à°¸à°‚à°µà°¤à±à°¸à°°à°¾à°²à±'},dayOfMonthOrdinalParse:/\d{1,2}à°µ/,ordinal:'%dà°µ',meridiemParse:/à°°à°¾à°¤à±à°°à°¿|à°‰à°¦à°¯à°‚|à°®à°§à±à°¯à°¾à°¹à±à°¨à°‚|à°¸à°¾à°¯à°‚à°¤à±à°°à°‚/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='à°°à°¾à°¤à±à°°à°¿'){return hour<4?hour:hour+12;}else if(meridiem==='à°‰à°¦à°¯à°‚'){return hour;}else if(meridiem==='à°®à°§à±à°¯à°¾à°¹à±à°¨à°‚'){return hour>=10?hour:hour+12;}else if(meridiem==='à°¸à°¾à°¯à°‚à°¤à±à°°à°‚'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'à°°à°¾à°¤à±à°°à°¿';}else if(hour<10){return 'à°‰à°¦à°¯à°‚';}else if(hour<17){return 'à°®à°§à±à°¯à°¾à°¹à±à°¨à°‚';}else if(hour<20){return 'à°¸à°¾à°¯à°‚à°¤à±à°°à°‚';}else{return 'à°°à°¾à°¤à±à°°à°¿';}},week:{dow:0,doy:6}});hooks.defineLocale('tet',{months:'Janeiru_Fevereiru_Marsu_Abril_Maiu_JuÃ±u_Jullu_Agustu_Setembru_Outubru_Novembru_Dezembru'.split('_'),monthsShort:'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez'.split('_'),weekdays:'Domingu_Segunda_Tersa_Kuarta_Kinta_Sesta_Sabadu'.split('_'),weekdaysShort:'Dom_Seg_Ters_Kua_Kint_Sest_Sab'.split('_'),weekdaysMin:'Do_Seg_Te_Ku_Ki_Ses_Sa'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ohin iha] LT',nextDay:'[Aban iha] LT',nextWeek:'dddd [iha] LT',lastDay:'[Horiseik iha] LT',lastWeek:'dddd [semana kotuk] [iha] LT',sameElse:'L'},relativeTime:{future:'iha %s',past:'%s liuba',s:'minutu balun',ss:'minutu %d',m:'minutu ida',mm:'minutu %d',h:'oras ida',hh:'oras %d',d:'loron ida',dd:'loron %d',M:'fulan ida',MM:'fulan %d',y:'tinan ida',yy:'tinan %d'},dayOfMonthOrdinalParse:/\d{1,2}(st|nd|rd|th)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});var suffixes$3={0:'-ÑƒÐ¼',1:'-ÑƒÐ¼',2:'-ÑŽÐ¼',3:'-ÑŽÐ¼',4:'-ÑƒÐ¼',5:'-ÑƒÐ¼',6:'-ÑƒÐ¼',7:'-ÑƒÐ¼',8:'-ÑƒÐ¼',9:'-ÑƒÐ¼',10:'-ÑƒÐ¼',12:'-ÑƒÐ¼',13:'-ÑƒÐ¼',20:'-ÑƒÐ¼',30:'-ÑŽÐ¼',40:'-ÑƒÐ¼',50:'-ÑƒÐ¼',60:'-ÑƒÐ¼',70:'-ÑƒÐ¼',80:'-ÑƒÐ¼',90:'-ÑƒÐ¼',100:'-ÑƒÐ¼'};hooks.defineLocale('tg',{months:'ÑÐ½Ð²Ð°Ñ€_Ñ„ÐµÐ²Ñ€Ð°Ð»_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€ÐµÐ»_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½_Ð¸ÑŽÐ»_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ½Ñ‚ÑÐ±Ñ€_Ð¾ÐºÑ‚ÑÐ±Ñ€_Ð½Ð¾ÑÐ±Ñ€_Ð´ÐµÐºÐ°Ð±Ñ€'.split('_'),monthsShort:'ÑÐ½Ð²_Ñ„ÐµÐ²_Ð¼Ð°Ñ€_Ð°Ð¿Ñ€_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½_Ð¸ÑŽÐ»_Ð°Ð²Ð³_ÑÐµÐ½_Ð¾ÐºÑ‚_Ð½Ð¾Ñ_Ð´ÐµÐº'.split('_'),weekdays:'ÑÐºÑˆÐ°Ð½Ð±Ðµ_Ð´ÑƒÑˆÐ°Ð½Ð±Ðµ_ÑÐµÑˆÐ°Ð½Ð±Ðµ_Ñ‡Ð¾Ñ€ÑˆÐ°Ð½Ð±Ðµ_Ð¿Ð°Ð½Ò·ÑˆÐ°Ð½Ð±Ðµ_Ò·ÑƒÐ¼ÑŠÐ°_ÑˆÐ°Ð½Ð±Ðµ'.split('_'),weekdaysShort:'ÑÑˆÐ±_Ð´ÑˆÐ±_ÑÑˆÐ±_Ñ‡ÑˆÐ±_Ð¿ÑˆÐ±_Ò·ÑƒÐ¼_ÑˆÐ½Ð±'.split('_'),weekdaysMin:'ÑÑˆ_Ð´Ñˆ_ÑÑˆ_Ñ‡Ñˆ_Ð¿Ñˆ_Ò·Ð¼_ÑˆÐ±'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[Ð˜Ð¼Ñ€Ó¯Ð· ÑÐ¾Ð°Ñ‚Ð¸] LT',nextDay:'[ÐŸÐ°Ð³Ð¾Ò³ ÑÐ¾Ð°Ñ‚Ð¸] LT',lastDay:'[Ð”Ð¸Ñ€Ó¯Ð· ÑÐ¾Ð°Ñ‚Ð¸] LT',nextWeek:'dddd[Ð¸] [Ò³Ð°Ñ„Ñ‚Ð°Ð¸ Ð¾ÑÐ½Ð´Ð° ÑÐ¾Ð°Ñ‚Ð¸] LT',lastWeek:'dddd[Ð¸] [Ò³Ð°Ñ„Ñ‚Ð°Ð¸ Ð³ÑƒÐ·Ð°ÑˆÑ‚Ð° ÑÐ¾Ð°Ñ‚Ð¸] LT',sameElse:'L'},relativeTime:{future:'Ð±Ð°ÑŠÐ´Ð¸ %s',past:'%s Ð¿ÐµÑˆ',s:'ÑÐºÑ‡Ð°Ð½Ð´ ÑÐ¾Ð½Ð¸Ñ',m:'ÑÐº Ð´Ð°Ò›Ð¸Ò›Ð°',mm:'%d Ð´Ð°Ò›Ð¸Ò›Ð°',h:'ÑÐº ÑÐ¾Ð°Ñ‚',hh:'%d ÑÐ¾Ð°Ñ‚',d:'ÑÐº Ñ€Ó¯Ð·',dd:'%d Ñ€Ó¯Ð·',M:'ÑÐº Ð¼Ð¾Ò³',MM:'%d Ð¼Ð¾Ò³',y:'ÑÐº ÑÐ¾Ð»',yy:'%d ÑÐ¾Ð»'},meridiemParse:/ÑˆÐ°Ð±|ÑÑƒÐ±Ò³|Ñ€Ó¯Ð·|Ð±ÐµÐ³Ð¾Ò³/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='ÑˆÐ°Ð±'){return hour<4?hour:hour+12;}else if(meridiem==='ÑÑƒÐ±Ò³'){return hour;}else if(meridiem==='Ñ€Ó¯Ð·'){return hour>=11?hour:hour+12;}else if(meridiem==='Ð±ÐµÐ³Ð¾Ò³'){return hour+12;}},meridiem:function(hour,minute,isLower){if(hour<4){return 'ÑˆÐ°Ð±';}else if(hour<11){return 'ÑÑƒÐ±Ò³';}else if(hour<16){return 'Ñ€Ó¯Ð·';}else if(hour<19){return 'Ð±ÐµÐ³Ð¾Ò³';}else{return 'ÑˆÐ°Ð±';}},dayOfMonthOrdinalParse:/\d{1,2}-(ÑƒÐ¼|ÑŽÐ¼)/,ordinal:function(number){var a=number%10,b=number>=100?100:null;return number+(suffixes$3[number]||suffixes$3[a]||suffixes$3[b]);},week:{dow:1,doy:7}});hooks.defineLocale('th',{months:'à¸¡à¸à¸£à¸²à¸„à¸¡_à¸à¸¸à¸¡à¸ à¸²à¸žà¸±à¸™à¸˜à¹Œ_à¸¡à¸µà¸™à¸²à¸„à¸¡_à¹€à¸¡à¸©à¸²à¸¢à¸™_à¸žà¸¤à¸©à¸ à¸²à¸„à¸¡_à¸¡à¸´à¸–à¸¸à¸™à¸²à¸¢à¸™_à¸à¸£à¸à¸Žà¸²à¸„à¸¡_à¸ªà¸´à¸‡à¸«à¸²à¸„à¸¡_à¸à¸±à¸™à¸¢à¸²à¸¢à¸™_à¸•à¸¸à¸¥à¸²à¸„à¸¡_à¸žà¸¤à¸¨à¸ˆà¸´à¸à¸²à¸¢à¸™_à¸˜à¸±à¸™à¸§à¸²à¸„à¸¡'.split('_'),monthsShort:'à¸¡.à¸„._à¸.à¸ž._à¸¡à¸µ.à¸„._à¹€à¸¡.à¸¢._à¸ž.à¸„._à¸¡à¸´.à¸¢._à¸.à¸„._à¸ª.à¸„._à¸.à¸¢._à¸•.à¸„._à¸ž.à¸¢._à¸˜.à¸„.'.split('_'),monthsParseExact:true,weekdays:'à¸à¸²à¸—à¸´à¸•à¸¢à¹Œ_à¸ˆà¸±à¸™à¸—à¸£à¹Œ_à¸à¸±à¸‡à¸„à¸²à¸£_à¸žà¸¸à¸˜_à¸žà¸¤à¸«à¸±à¸ªà¸šà¸”à¸µ_à¸¨à¸¸à¸à¸£à¹Œ_à¹€à¸ªà¸²à¸£à¹Œ'.split('_'),weekdaysShort:'à¸à¸²à¸—à¸´à¸•à¸¢à¹Œ_à¸ˆà¸±à¸™à¸—à¸£à¹Œ_à¸à¸±à¸‡à¸„à¸²à¸£_à¸žà¸¸à¸˜_à¸žà¸¤à¸«à¸±à¸ª_à¸¨à¸¸à¸à¸£à¹Œ_à¹€à¸ªà¸²à¸£à¹Œ'.split('_'),weekdaysMin:'à¸à¸²._à¸ˆ._à¸._à¸ž._à¸žà¸¤._à¸¨._à¸ª.'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'H:mm',LTS:'H:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY à¹€à¸§à¸¥à¸² H:mm',LLLL:'à¸§à¸±à¸™ddddà¸—à¸µà¹ˆ D MMMM YYYY à¹€à¸§à¸¥à¸² H:mm'},meridiemParse:/à¸à¹ˆà¸à¸™à¹€à¸—à¸µà¹ˆà¸¢à¸‡|à¸«à¸¥à¸±à¸‡à¹€à¸—à¸µà¹ˆà¸¢à¸‡/,isPM:function(input){return input==='à¸«à¸¥à¸±à¸‡à¹€à¸—à¸µà¹ˆà¸¢à¸‡';},meridiem:function(hour,minute,isLower){if(hour<12){return 'à¸à¹ˆà¸à¸™à¹€à¸—à¸µà¹ˆà¸¢à¸‡';}else{return 'à¸«à¸¥à¸±à¸‡à¹€à¸—à¸µà¹ˆà¸¢à¸‡';}},calendar:{sameDay:'[à¸§à¸±à¸™à¸™à¸µà¹‰ à¹€à¸§à¸¥à¸²] LT',nextDay:'[à¸žà¸£à¸¸à¹ˆà¸‡à¸™à¸µà¹‰ à¹€à¸§à¸¥à¸²] LT',nextWeek:'dddd[à¸«à¸™à¹‰à¸² à¹€à¸§à¸¥à¸²] LT',lastDay:'[à¹€à¸¡à¸·à¹ˆà¸à¸§à¸²à¸™à¸™à¸µà¹‰ à¹€à¸§à¸¥à¸²] LT',lastWeek:'[à¸§à¸±à¸™]dddd[à¸—à¸µà¹ˆà¹à¸¥à¹‰à¸§ à¹€à¸§à¸¥à¸²] LT',sameElse:'L'},relativeTime:{future:'à¸à¸µà¸ %s',past:'%sà¸—à¸µà¹ˆà¹à¸¥à¹‰à¸§',s:'à¹„à¸¡à¹ˆà¸à¸µà¹ˆà¸§à¸´à¸™à¸²à¸—à¸µ',ss:'%d à¸§à¸´à¸™à¸²à¸—à¸µ',m:'1 à¸™à¸²à¸—à¸µ',mm:'%d à¸™à¸²à¸—à¸µ',h:'1 à¸Šà¸±à¹ˆà¸§à¹‚à¸¡à¸‡',hh:'%d à¸Šà¸±à¹ˆà¸§à¹‚à¸¡à¸‡',d:'1 à¸§à¸±à¸™',dd:'%d à¸§à¸±à¸™',M:'1 à¹€à¸”à¸·à¸à¸™',MM:'%d à¹€à¸”à¸·à¸à¸™',y:'1 à¸›à¸µ',yy:'%d à¸›à¸µ'}});hooks.defineLocale('tl-ph',{months:'Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre'.split('_'),monthsShort:'Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis'.split('_'),weekdays:'Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado'.split('_'),weekdaysShort:'Lin_Lun_Mar_Miy_Huw_Biy_Sab'.split('_'),weekdaysMin:'Li_Lu_Ma_Mi_Hu_Bi_Sab'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'MM/D/YYYY',LL:'MMMM D, YYYY',LLL:'MMMM D, YYYY HH:mm',LLLL:'dddd, MMMM DD, YYYY HH:mm'},calendar:{sameDay:'LT [ngayong araw]',nextDay:'[Bukas ng] LT',nextWeek:'LT [sa susunod na] dddd',lastDay:'LT [kahapon]',lastWeek:'LT [noong nakaraang] dddd',sameElse:'L'},relativeTime:{future:'sa loob ng %s',past:'%s ang nakalipas',s:'ilang segundo',ss:'%d segundo',m:'isang minuto',mm:'%d minuto',h:'isang oras',hh:'%d oras',d:'isang araw',dd:'%d araw',M:'isang buwan',MM:'%d buwan',y:'isang taon',yy:'%d taon'},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:function(number){return number;},week:{dow:1,doy:4}});var numbersNouns='pagh_waâ€™_chaâ€™_wej_loS_vagh_jav_Soch_chorgh_Hut'.split('_');function translateFuture(output){var time=output;time=(output.indexOf('jaj')!==-1)?time.slice(0,-3)+'leS':(output.indexOf('jar')!==-1)?time.slice(0,-3)+'waQ':(output.indexOf('DIS')!==-1)?time.slice(0,-3)+'nem':time+' pIq';return time;}
function translatePast(output){var time=output;time=(output.indexOf('jaj')!==-1)?time.slice(0,-3)+'Huâ€™':(output.indexOf('jar')!==-1)?time.slice(0,-3)+'wen':(output.indexOf('DIS')!==-1)?time.slice(0,-3)+'ben':time+' ret';return time;}
function translate$a(number,withoutSuffix,string,isFuture){var numberNoun=numberAsNoun(number);switch(string){case 'ss':return numberNoun+' lup';case 'mm':return numberNoun+' tup';case 'hh':return numberNoun+' rep';case 'dd':return numberNoun+' jaj';case 'MM':return numberNoun+' jar';case 'yy':return numberNoun+' DIS';}}
function numberAsNoun(number){var hundred=Math.floor((number%1000)/100),ten=Math.floor((number%100)/10),one=number%10,word='';if(hundred>0){word+=numbersNouns[hundred]+'vatlh';}
if(ten>0){word+=((word!=='')?' ':'')+numbersNouns[ten]+'maH';}
if(one>0){word+=((word!=='')?' ':'')+numbersNouns[one];}
return(word==='')?'pagh':word;}
hooks.defineLocale('tlh',{months:'teraâ€™ jar waâ€™_teraâ€™ jar chaâ€™_teraâ€™ jar wej_teraâ€™ jar loS_teraâ€™ jar vagh_teraâ€™ jar jav_teraâ€™ jar Soch_teraâ€™ jar chorgh_teraâ€™ jar Hut_teraâ€™ jar waâ€™maH_teraâ€™ jar waâ€™maH waâ€™_teraâ€™ jar waâ€™maH chaâ€™'.split('_'),monthsShort:'jar waâ€™_jar chaâ€™_jar wej_jar loS_jar vagh_jar jav_jar Soch_jar chorgh_jar Hut_jar waâ€™maH_jar waâ€™maH waâ€™_jar waâ€™maH chaâ€™'.split('_'),monthsParseExact:true,weekdays:'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),weekdaysShort:'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),weekdaysMin:'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[DaHjaj] LT',nextDay:'[waâ€™leS] LT',nextWeek:'LLL',lastDay:'[waâ€™Huâ€™] LT',lastWeek:'LLL',sameElse:'L'},relativeTime:{future:translateFuture,past:translatePast,s:'puS lup',ss:translate$a,m:'waâ€™ tup',mm:translate$a,h:'waâ€™ rep',hh:translate$a,d:'waâ€™ jaj',dd:translate$a,M:'waâ€™ jar',MM:translate$a,y:'waâ€™ DIS',yy:translate$a},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});var suffixes$4={1:'\'inci',5:'\'inci',8:'\'inci',70:'\'inci',80:'\'inci',2:'\'nci',7:'\'nci',20:'\'nci',50:'\'nci',3:'\'Ã¼ncÃ¼',4:'\'Ã¼ncÃ¼',100:'\'Ã¼ncÃ¼',6:'\'ncÄ±',9:'\'uncu',10:'\'uncu',30:'\'uncu',60:'\'Ä±ncÄ±',90:'\'Ä±ncÄ±'};hooks.defineLocale('tr',{months:'Ocak_Åžubat_Mart_Nisan_MayÄ±s_Haziran_Temmuz_AÄŸustos_EylÃ¼l_Ekim_KasÄ±m_AralÄ±k'.split('_'),monthsShort:'Oca_Åžub_Mar_Nis_May_Haz_Tem_AÄŸu_Eyl_Eki_Kas_Ara'.split('_'),weekdays:'Pazar_Pazartesi_SalÄ±_Ã‡arÅŸamba_PerÅŸembe_Cuma_Cumartesi'.split('_'),weekdaysShort:'Paz_Pts_Sal_Ã‡ar_Per_Cum_Cts'.split('_'),weekdaysMin:'Pz_Pt_Sa_Ã‡a_Pe_Cu_Ct'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[bugÃ¼n saat] LT',nextDay:'[yarÄ±n saat] LT',nextWeek:'[gelecek] dddd [saat] LT',lastDay:'[dÃ¼n] LT',lastWeek:'[geÃ§en] dddd [saat] LT',sameElse:'L'},relativeTime:{future:'%s sonra',past:'%s Ã¶nce',s:'birkaÃ§ saniye',ss:'%d saniye',m:'bir dakika',mm:'%d dakika',h:'bir saat',hh:'%d saat',d:'bir gÃ¼n',dd:'%d gÃ¼n',M:'bir ay',MM:'%d ay',y:'bir yÄ±l',yy:'%d yÄ±l'},ordinal:function(number,period){switch(period){case 'd':case 'D':case 'Do':case 'DD':return number;default:if(number===0){return number+'\'Ä±ncÄ±';}
var a=number%10,b=number%100-a,c=number>=100?100:null;return number+(suffixes$4[a]||suffixes$4[b]||suffixes$4[c]);}},week:{dow:1,doy:7}});hooks.defineLocale('tzl',{months:'Januar_Fevraglh_MarÃ§_AvrÃ¯u_Mai_GÃ¼n_Julia_Guscht_Setemvar_ListopÃ¤ts_Noemvar_Zecemvar'.split('_'),monthsShort:'Jan_Fev_Mar_Avr_Mai_GÃ¼n_Jul_Gus_Set_Lis_Noe_Zec'.split('_'),weekdays:'SÃºladi_LÃºneÃ§i_Maitzi_MÃ¡rcuri_XhÃºadi_ViÃ©nerÃ§i_SÃ¡turi'.split('_'),weekdaysShort:'SÃºl_LÃºn_Mai_MÃ¡r_XhÃº_ViÃ©_SÃ¡t'.split('_'),weekdaysMin:'SÃº_LÃº_Ma_MÃ¡_Xh_Vi_SÃ¡'.split('_'),longDateFormat:{LT:'HH.mm',LTS:'HH.mm.ss',L:'DD.MM.YYYY',LL:'D. MMMM [dallas] YYYY',LLL:'D. MMMM [dallas] YYYY HH.mm',LLLL:'dddd, [li] D. MMMM [dallas] YYYY HH.mm'},meridiemParse:/d\'o|d\'a/i,isPM:function(input){return 'd\'o'===input.toLowerCase();},meridiem:function(hours,minutes,isLower){if(hours>11){return isLower?'d\'o':'D\'O';}else{return isLower?'d\'a':'D\'A';}},calendar:{sameDay:'[oxhi Ã ] LT',nextDay:'[demÃ  Ã ] LT',nextWeek:'dddd [Ã ] LT',lastDay:'[ieiri Ã ] LT',lastWeek:'[sÃ¼r el] dddd [lasteu Ã ] LT',sameElse:'L'},relativeTime:{future:'osprei %s',past:'ja%s',s:processRelativeTime$7,ss:processRelativeTime$7,m:processRelativeTime$7,mm:processRelativeTime$7,h:processRelativeTime$7,hh:processRelativeTime$7,d:processRelativeTime$7,dd:processRelativeTime$7,M:processRelativeTime$7,MM:processRelativeTime$7,y:processRelativeTime$7,yy:processRelativeTime$7},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:'%d.',week:{dow:1,doy:4}});function processRelativeTime$7(number,withoutSuffix,key,isFuture){var format={'s':['viensas secunds','\'iensas secunds'],'ss':[number+' secunds',''+number+' secunds'],'m':['\'n mÃut','\'iens mÃut'],'mm':[number+' mÃuts',''+number+' mÃuts'],'h':['\'n Ã¾ora','\'iensa Ã¾ora'],'hh':[number+' Ã¾oras',''+number+' Ã¾oras'],'d':['\'n ziua','\'iensa ziua'],'dd':[number+' ziuas',''+number+' ziuas'],'M':['\'n mes','\'iens mes'],'MM':[number+' mesen',''+number+' mesen'],'y':['\'n ar','\'iens ar'],'yy':[number+' ars',''+number+' ars']};return isFuture?format[key][0]:(withoutSuffix?format[key][0]:format[key][1]);}
hooks.defineLocale('tzm-latn',{months:'innayr_brË¤ayrË¤_marË¤sË¤_ibrir_mayyw_ywnyw_ywlywz_É£wÅ¡t_Å¡wtanbir_ktË¤wbrË¤_nwwanbir_dwjnbir'.split('_'),monthsShort:'innayr_brË¤ayrË¤_marË¤sË¤_ibrir_mayyw_ywnyw_ywlywz_É£wÅ¡t_Å¡wtanbir_ktË¤wbrË¤_nwwanbir_dwjnbir'.split('_'),weekdays:'asamas_aynas_asinas_akras_akwas_asimwas_asiá¸yas'.split('_'),weekdaysShort:'asamas_aynas_asinas_akras_akwas_asimwas_asiá¸yas'.split('_'),weekdaysMin:'asamas_aynas_asinas_akras_akwas_asimwas_asiá¸yas'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[asdkh g] LT',nextDay:'[aska g] LT',nextWeek:'dddd [g] LT',lastDay:'[assant g] LT',lastWeek:'dddd [g] LT',sameElse:'L'},relativeTime:{future:'dadkh s yan %s',past:'yan %s',s:'imik',ss:'%d imik',m:'minuá¸',mm:'%d minuá¸',h:'saÉ›a',hh:'%d tassaÉ›in',d:'ass',dd:'%d ossan',M:'ayowr',MM:'%d iyyirn',y:'asgas',yy:'%d isgasn'},week:{dow:6,doy:12}});hooks.defineLocale('tzm',{months:'âµ‰âµâµâ´°âµ¢âµ”_â´±âµ•â´°âµ¢âµ•_âµŽâ´°âµ•âµš_âµ‰â´±âµ”âµ‰âµ”_âµŽâ´°âµ¢âµ¢âµ“_âµ¢âµ“âµâµ¢âµ“_âµ¢âµ“âµâµ¢âµ“âµ£_âµ–âµ“âµ›âµœ_âµ›âµ“âµœâ´°âµâ´±âµ‰âµ”_â´½âµŸâµ“â´±âµ•_âµâµ“âµ¡â´°âµâ´±âµ‰âµ”_â´·âµ“âµŠâµâ´±âµ‰âµ”'.split('_'),monthsShort:'âµ‰âµâµâ´°âµ¢âµ”_â´±âµ•â´°âµ¢âµ•_âµŽâ´°âµ•âµš_âµ‰â´±âµ”âµ‰âµ”_âµŽâ´°âµ¢âµ¢âµ“_âµ¢âµ“âµâµ¢âµ“_âµ¢âµ“âµâµ¢âµ“âµ£_âµ–âµ“âµ›âµœ_âµ›âµ“âµœâ´°âµâ´±âµ‰âµ”_â´½âµŸâµ“â´±âµ•_âµâµ“âµ¡â´°âµâ´±âµ‰âµ”_â´·âµ“âµŠâµâ´±âµ‰âµ”'.split('_'),weekdays:'â´°âµ™â´°âµŽâ´°âµ™_â´°âµ¢âµâ´°âµ™_â´°âµ™âµ‰âµâ´°âµ™_â´°â´½âµ”â´°âµ™_â´°â´½âµ¡â´°âµ™_â´°âµ™âµ‰âµŽâµ¡â´°âµ™_â´°âµ™âµ‰â´¹âµ¢â´°âµ™'.split('_'),weekdaysShort:'â´°âµ™â´°âµŽâ´°âµ™_â´°âµ¢âµâ´°âµ™_â´°âµ™âµ‰âµâ´°âµ™_â´°â´½âµ”â´°âµ™_â´°â´½âµ¡â´°âµ™_â´°âµ™âµ‰âµŽâµ¡â´°âµ™_â´°âµ™âµ‰â´¹âµ¢â´°âµ™'.split('_'),weekdaysMin:'â´°âµ™â´°âµŽâ´°âµ™_â´°âµ¢âµâ´°âµ™_â´°âµ™âµ‰âµâ´°âµ™_â´°â´½âµ”â´°âµ™_â´°â´½âµ¡â´°âµ™_â´°âµ™âµ‰âµŽâµ¡â´°âµ™_â´°âµ™âµ‰â´¹âµ¢â´°âµ™'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd D MMMM YYYY HH:mm'},calendar:{sameDay:'[â´°âµ™â´·âµ… â´´] LT',nextDay:'[â´°âµ™â´½â´° â´´] LT',nextWeek:'dddd [â´´] LT',lastDay:'[â´°âµšâ´°âµâµœ â´´] LT',lastWeek:'dddd [â´´] LT',sameElse:'L'},relativeTime:{future:'â´·â´°â´·âµ… âµ™ âµ¢â´°âµ %s',past:'âµ¢â´°âµ %s',s:'âµ‰âµŽâµ‰â´½',ss:'%d âµ‰âµŽâµ‰â´½',m:'âµŽâµ‰âµâµ“â´º',mm:'%d âµŽâµ‰âµâµ“â´º',h:'âµ™â´°âµ„â´°',hh:'%d âµœâ´°âµ™âµ™â´°âµ„âµ‰âµ',d:'â´°âµ™âµ™',dd:'%d oâµ™âµ™â´°âµ',M:'â´°âµ¢oâµ“âµ”',MM:'%d âµ‰âµ¢âµ¢âµ‰âµ”âµ',y:'â´°âµ™â´³â´°âµ™',yy:'%d âµ‰âµ™â´³â´°âµ™âµ'},week:{dow:6,doy:12}});hooks.defineLocale('ug-cn',{months:'ÙŠØ§Ù†Û‹Ø§Ø±_ÙÛÛ‹Ø±Ø§Ù„_Ù…Ø§Ø±Øª_Ø¦Ø§Ù¾Ø±ÛÙ„_Ù…Ø§ÙŠ_Ø¦Ù‰ÙŠÛ‡Ù†_Ø¦Ù‰ÙŠÛ‡Ù„_Ø¦Ø§Û‹ØºÛ‡Ø³Øª_Ø³ÛÙ†ØªÛ•Ø¨Ù‰Ø±_Ø¦Û†ÙƒØªÛ•Ø¨Ù‰Ø±_Ù†ÙˆÙŠØ§Ø¨Ù‰Ø±_Ø¯ÛÙƒØ§Ø¨Ù‰Ø±'.split('_'),monthsShort:'ÙŠØ§Ù†Û‹Ø§Ø±_ÙÛÛ‹Ø±Ø§Ù„_Ù…Ø§Ø±Øª_Ø¦Ø§Ù¾Ø±ÛÙ„_Ù…Ø§ÙŠ_Ø¦Ù‰ÙŠÛ‡Ù†_Ø¦Ù‰ÙŠÛ‡Ù„_Ø¦Ø§Û‹ØºÛ‡Ø³Øª_Ø³ÛÙ†ØªÛ•Ø¨Ù‰Ø±_Ø¦Û†ÙƒØªÛ•Ø¨Ù‰Ø±_Ù†ÙˆÙŠØ§Ø¨Ù‰Ø±_Ø¯ÛÙƒØ§Ø¨Ù‰Ø±'.split('_'),weekdays:'ÙŠÛ•ÙƒØ´Û•Ù†Ø¨Û•_Ø¯ÛˆØ´Û•Ù†Ø¨Û•_Ø³Û•ÙŠØ´Û•Ù†Ø¨Û•_Ú†Ø§Ø±Ø´Û•Ù†Ø¨Û•_Ù¾Û•ÙŠØ´Û•Ù†Ø¨Û•_Ø¬ÛˆÙ…Û•_Ø´Û•Ù†Ø¨Û•'.split('_'),weekdaysShort:'ÙŠÛ•_Ø¯Ûˆ_Ø³Û•_Ú†Ø§_Ù¾Û•_Ø¬Ûˆ_Ø´Û•'.split('_'),weekdaysMin:'ÙŠÛ•_Ø¯Ûˆ_Ø³Û•_Ú†Ø§_Ù¾Û•_Ø¬Ûˆ_Ø´Û•'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY-MM-DD',LL:'YYYY-ÙŠÙ‰Ù„Ù‰M-Ø¦Ø§ÙŠÙ†Ù‰ÚD-ÙƒÛˆÙ†Ù‰',LLL:'YYYY-ÙŠÙ‰Ù„Ù‰M-Ø¦Ø§ÙŠÙ†Ù‰ÚD-ÙƒÛˆÙ†Ù‰ØŒ HH:mm',LLLL:'ddddØŒ YYYY-ÙŠÙ‰Ù„Ù‰M-Ø¦Ø§ÙŠÙ†Ù‰ÚD-ÙƒÛˆÙ†Ù‰ØŒ HH:mm'},meridiemParse:/ÙŠÛØ±Ù‰Ù… ÙƒÛÚ†Û•|Ø³Û•Ú¾Û•Ø±|Ú†ÛˆØ´ØªÙ‰Ù† Ø¨Û‡Ø±Û‡Ù†|Ú†ÛˆØ´|Ú†ÛˆØ´ØªÙ‰Ù† ÙƒÛÙŠÙ‰Ù†|ÙƒÛ•Ú†/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='ÙŠÛØ±Ù‰Ù… ÙƒÛÚ†Û•'||meridiem==='Ø³Û•Ú¾Û•Ø±'||meridiem==='Ú†ÛˆØ´ØªÙ‰Ù† Ø¨Û‡Ø±Û‡Ù†'){return hour;}else if(meridiem==='Ú†ÛˆØ´ØªÙ‰Ù† ÙƒÛÙŠÙ‰Ù†'||meridiem==='ÙƒÛ•Ú†'){return hour+12;}else{return hour>=11?hour:hour+12;}},meridiem:function(hour,minute,isLower){var hm=hour*100+minute;if(hm<600){return 'ÙŠÛØ±Ù‰Ù… ÙƒÛÚ†Û•';}else if(hm<900){return 'Ø³Û•Ú¾Û•Ø±';}else if(hm<1130){return 'Ú†ÛˆØ´ØªÙ‰Ù† Ø¨Û‡Ø±Û‡Ù†';}else if(hm<1230){return 'Ú†ÛˆØ´';}else if(hm<1800){return 'Ú†ÛˆØ´ØªÙ‰Ù† ÙƒÛÙŠÙ‰Ù†';}else{return 'ÙƒÛ•Ú†';}},calendar:{sameDay:'[Ø¨ÛˆÚ¯ÛˆÙ† Ø³Ø§Ø¦Û•Øª] LT',nextDay:'[Ø¦Û•ØªÛ• Ø³Ø§Ø¦Û•Øª] LT',nextWeek:'[ÙƒÛÙ„Û•Ø±ÙƒÙ‰] dddd [Ø³Ø§Ø¦Û•Øª] LT',lastDay:'[ØªÛ†Ù†ÛˆÚ¯ÛˆÙ†] LT',lastWeek:'[Ø¦Ø§Ù„Ø¯Ù‰Ù†Ù‚Ù‰] dddd [Ø³Ø§Ø¦Û•Øª] LT',sameElse:'L'},relativeTime:{future:'%s ÙƒÛÙŠÙ‰Ù†',past:'%s Ø¨Û‡Ø±Û‡Ù†',s:'Ù†Û•Ú†Ú†Û• Ø³ÛÙƒÙˆÙ†Øª',ss:'%d Ø³ÛÙƒÙˆÙ†Øª',m:'Ø¨Ù‰Ø± Ù…Ù‰Ù†Û‡Øª',mm:'%d Ù…Ù‰Ù†Û‡Øª',h:'Ø¨Ù‰Ø± Ø³Ø§Ø¦Û•Øª',hh:'%d Ø³Ø§Ø¦Û•Øª',d:'Ø¨Ù‰Ø± ÙƒÛˆÙ†',dd:'%d ÙƒÛˆÙ†',M:'Ø¨Ù‰Ø± Ø¦Ø§ÙŠ',MM:'%d Ø¦Ø§ÙŠ',y:'Ø¨Ù‰Ø± ÙŠÙ‰Ù„',yy:'%d ÙŠÙ‰Ù„'},dayOfMonthOrdinalParse:/\d{1,2}(-ÙƒÛˆÙ†Ù‰|-Ø¦Ø§ÙŠ|-Ú¾Û•Ù¾ØªÛ•)/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'-ÙƒÛˆÙ†Ù‰';case 'w':case 'W':return number+'-Ú¾Û•Ù¾ØªÛ•';default:return number;}},preparse:function(string){return string.replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/,/g,'ØŒ');},week:{dow:1,doy:7}});function plural$6(word,num){var forms=word.split('_');return num%10===1&&num%100!==11?forms[0]:(num%10>=2&&num%10<=4&&(num%100<10||num%100>=20)?forms[1]:forms[2]);}
function relativeTimeWithPlural$4(number,withoutSuffix,key){var format={'ss':withoutSuffix?'ÑÐµÐºÑƒÐ½Ð´Ð°_ÑÐµÐºÑƒÐ½Ð´Ð¸_ÑÐµÐºÑƒÐ½Ð´':'ÑÐµÐºÑƒÐ½Ð´Ñƒ_ÑÐµÐºÑƒÐ½Ð´Ð¸_ÑÐµÐºÑƒÐ½Ð´','mm':withoutSuffix?'Ñ…Ð²Ð¸Ð»Ð¸Ð½Ð°_Ñ…Ð²Ð¸Ð»Ð¸Ð½Ð¸_Ñ…Ð²Ð¸Ð»Ð¸Ð½':'Ñ…Ð²Ð¸Ð»Ð¸Ð½Ñƒ_Ñ…Ð²Ð¸Ð»Ð¸Ð½Ð¸_Ñ…Ð²Ð¸Ð»Ð¸Ð½','hh':withoutSuffix?'Ð³Ð¾Ð´Ð¸Ð½Ð°_Ð³Ð¾Ð´Ð¸Ð½Ð¸_Ð³Ð¾Ð´Ð¸Ð½':'Ð³Ð¾Ð´Ð¸Ð½Ñƒ_Ð³Ð¾Ð´Ð¸Ð½Ð¸_Ð³Ð¾Ð´Ð¸Ð½','dd':'Ð´ÐµÐ½ÑŒ_Ð´Ð½Ñ–_Ð´Ð½Ñ–Ð²','MM':'Ð¼Ñ–ÑÑÑ†ÑŒ_Ð¼Ñ–ÑÑÑ†Ñ–_Ð¼Ñ–ÑÑÑ†Ñ–Ð²','yy':'Ñ€Ñ–Ðº_Ñ€Ð¾ÐºÐ¸_Ñ€Ð¾ÐºÑ–Ð²'};if(key==='m'){return withoutSuffix?'Ñ…Ð²Ð¸Ð»Ð¸Ð½Ð°':'Ñ…Ð²Ð¸Ð»Ð¸Ð½Ñƒ';}
else if(key==='h'){return withoutSuffix?'Ð³Ð¾Ð´Ð¸Ð½Ð°':'Ð³Ð¾Ð´Ð¸Ð½Ñƒ';}
else{return number+' '+plural$6(format[key],+number);}}
function weekdaysCaseReplace(m,format){var weekdays={'nominative':'Ð½ÐµÐ´Ñ–Ð»Ñ_Ð¿Ð¾Ð½ÐµÐ´Ñ–Ð»Ð¾Ðº_Ð²Ñ–Ð²Ñ‚Ð¾Ñ€Ð¾Ðº_ÑÐµÑ€ÐµÐ´Ð°_Ñ‡ÐµÑ‚Ð²ÐµÑ€_Ð¿â€™ÑÑ‚Ð½Ð¸Ñ†Ñ_ÑÑƒÐ±Ð¾Ñ‚Ð°'.split('_'),'accusative':'Ð½ÐµÐ´Ñ–Ð»ÑŽ_Ð¿Ð¾Ð½ÐµÐ´Ñ–Ð»Ð¾Ðº_Ð²Ñ–Ð²Ñ‚Ð¾Ñ€Ð¾Ðº_ÑÐµÑ€ÐµÐ´Ñƒ_Ñ‡ÐµÑ‚Ð²ÐµÑ€_Ð¿â€™ÑÑ‚Ð½Ð¸Ñ†ÑŽ_ÑÑƒÐ±Ð¾Ñ‚Ñƒ'.split('_'),'genitive':'Ð½ÐµÐ´Ñ–Ð»Ñ–_Ð¿Ð¾Ð½ÐµÐ´Ñ–Ð»ÐºÐ°_Ð²Ñ–Ð²Ñ‚Ð¾Ñ€ÐºÐ°_ÑÐµÑ€ÐµÐ´Ð¸_Ñ‡ÐµÑ‚Ð²ÐµÑ€Ð³Ð°_Ð¿â€™ÑÑ‚Ð½Ð¸Ñ†Ñ–_ÑÑƒÐ±Ð¾Ñ‚Ð¸'.split('_')};if(m===true){return weekdays['nominative'].slice(1,7).concat(weekdays['nominative'].slice(0,1));}
if(!m){return weekdays['nominative'];}
var nounCase=(/(\[[Ð’Ð²Ð£Ñƒ]\]) ?dddd/).test(format)?'accusative':((/\[?(?:Ð¼Ð¸Ð½ÑƒÐ»Ð¾Ñ—|Ð½Ð°ÑÑ‚ÑƒÐ¿Ð½Ð¾Ñ—)? ?\] ?dddd/).test(format)?'genitive':'nominative');return weekdays[nounCase][m.day()];}
function processHoursFunction(str){return function(){return str+'Ð¾'+(this.hours()===11?'Ð±':'')+'] LT';};}
hooks.defineLocale('uk',{months:{'format':'ÑÑ–Ñ‡Ð½Ñ_Ð»ÑŽÑ‚Ð¾Ð³Ð¾_Ð±ÐµÑ€ÐµÐ·Ð½Ñ_ÐºÐ²Ñ–Ñ‚Ð½Ñ_Ñ‚Ñ€Ð°Ð²Ð½Ñ_Ñ‡ÐµÑ€Ð²Ð½Ñ_Ð»Ð¸Ð¿Ð½Ñ_ÑÐµÑ€Ð¿Ð½Ñ_Ð²ÐµÑ€ÐµÑÐ½Ñ_Ð¶Ð¾Ð²Ñ‚Ð½Ñ_Ð»Ð¸ÑÑ‚Ð¾Ð¿Ð°Ð´Ð°_Ð³Ñ€ÑƒÐ´Ð½Ñ'.split('_'),'standalone':'ÑÑ–Ñ‡ÐµÐ½ÑŒ_Ð»ÑŽÑ‚Ð¸Ð¹_Ð±ÐµÑ€ÐµÐ·ÐµÐ½ÑŒ_ÐºÐ²Ñ–Ñ‚ÐµÐ½ÑŒ_Ñ‚Ñ€Ð°Ð²ÐµÐ½ÑŒ_Ñ‡ÐµÑ€Ð²ÐµÐ½ÑŒ_Ð»Ð¸Ð¿ÐµÐ½ÑŒ_ÑÐµÑ€Ð¿ÐµÐ½ÑŒ_Ð²ÐµÑ€ÐµÑÐµÐ½ÑŒ_Ð¶Ð¾Ð²Ñ‚ÐµÐ½ÑŒ_Ð»Ð¸ÑÑ‚Ð¾Ð¿Ð°Ð´_Ð³Ñ€ÑƒÐ´ÐµÐ½ÑŒ'.split('_')},monthsShort:'ÑÑ–Ñ‡_Ð»ÑŽÑ‚_Ð±ÐµÑ€_ÐºÐ²Ñ–Ñ‚_Ñ‚Ñ€Ð°Ð²_Ñ‡ÐµÑ€Ð²_Ð»Ð¸Ð¿_ÑÐµÑ€Ð¿_Ð²ÐµÑ€_Ð¶Ð¾Ð²Ñ‚_Ð»Ð¸ÑÑ‚_Ð³Ñ€ÑƒÐ´'.split('_'),weekdays:weekdaysCaseReplace,weekdaysShort:'Ð½Ð´_Ð¿Ð½_Ð²Ñ‚_ÑÑ€_Ñ‡Ñ‚_Ð¿Ñ‚_ÑÐ±'.split('_'),weekdaysMin:'Ð½Ð´_Ð¿Ð½_Ð²Ñ‚_ÑÑ€_Ñ‡Ñ‚_Ð¿Ñ‚_ÑÐ±'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD.MM.YYYY',LL:'D MMMM YYYY Ñ€.',LLL:'D MMMM YYYY Ñ€., HH:mm',LLLL:'dddd, D MMMM YYYY Ñ€., HH:mm'},calendar:{sameDay:processHoursFunction('[Ð¡ÑŒÐ¾Ð³Ð¾Ð´Ð½Ñ– '),nextDay:processHoursFunction('[Ð—Ð°Ð²Ñ‚Ñ€Ð° '),lastDay:processHoursFunction('[Ð’Ñ‡Ð¾Ñ€Ð° '),nextWeek:processHoursFunction('[Ð£] dddd ['),lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return processHoursFunction('[ÐœÐ¸Ð½ÑƒÐ»Ð¾Ñ—] dddd [').call(this);case 1:case 2:case 4:return processHoursFunction('[ÐœÐ¸Ð½ÑƒÐ»Ð¾Ð³Ð¾] dddd [').call(this);}},sameElse:'L'},relativeTime:{future:'Ð·Ð° %s',past:'%s Ñ‚Ð¾Ð¼Ñƒ',s:'Ð´ÐµÐºÑ–Ð»ÑŒÐºÐ° ÑÐµÐºÑƒÐ½Ð´',ss:relativeTimeWithPlural$4,m:relativeTimeWithPlural$4,mm:relativeTimeWithPlural$4,h:'Ð³Ð¾Ð´Ð¸Ð½Ñƒ',hh:relativeTimeWithPlural$4,d:'Ð´ÐµÐ½ÑŒ',dd:relativeTimeWithPlural$4,M:'Ð¼Ñ–ÑÑÑ†ÑŒ',MM:relativeTimeWithPlural$4,y:'Ñ€Ñ–Ðº',yy:relativeTimeWithPlural$4},meridiemParse:/Ð½Ð¾Ñ‡Ñ–|Ñ€Ð°Ð½ÐºÑƒ|Ð´Ð½Ñ|Ð²ÐµÑ‡Ð¾Ñ€Ð°/,isPM:function(input){return /^(Ð´Ð½Ñ|Ð²ÐµÑ‡Ð¾Ñ€Ð°)$/.test(input);},meridiem:function(hour,minute,isLower){if(hour<4){return 'Ð½Ð¾Ñ‡Ñ–';}else if(hour<12){return 'Ñ€Ð°Ð½ÐºÑƒ';}else if(hour<17){return 'Ð´Ð½Ñ';}else{return 'Ð²ÐµÑ‡Ð¾Ñ€Ð°';}},dayOfMonthOrdinalParse:/\d{1,2}-(Ð¹|Ð³Ð¾)/,ordinal:function(number,period){switch(period){case 'M':case 'd':case 'DDD':case 'w':case 'W':return number+'-Ð¹';case 'D':return number+'-Ð³Ð¾';default:return number;}},week:{dow:1,doy:7}});var months$a=['Ø¬Ù†ÙˆØ±ÛŒ','ÙØ±ÙˆØ±ÛŒ','Ù…Ø§Ø±Ú†','Ø§Ù¾Ø±ÛŒÙ„','Ù…Ø¦ÛŒ','Ø¬ÙˆÙ†','Ø¬ÙˆÙ„Ø§Ø¦ÛŒ','Ø§Ú¯Ø³Øª','Ø³ØªÙ…Ø¨Ø±','Ø§Ú©ØªÙˆØ¨Ø±','Ù†ÙˆÙ…Ø¨Ø±','Ø¯Ø³Ù…Ø¨Ø±'];var days$2=['Ø§ØªÙˆØ§Ø±','Ù¾ÛŒØ±','Ù…Ù†Ú¯Ù„','Ø¨Ø¯Ú¾','Ø¬Ù…Ø¹Ø±Ø§Øª','Ø¬Ù…Ø¹Û','ÛÙØªÛ'];hooks.defineLocale('ur',{months:months$a,monthsShort:months$a,weekdays:days$2,weekdaysShort:days$2,weekdaysMin:days$2,longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'ddddØŒ D MMMM YYYY HH:mm'},meridiemParse:/ØµØ¨Ø|Ø´Ø§Ù…/,isPM:function(input){return 'Ø´Ø§Ù…'===input;},meridiem:function(hour,minute,isLower){if(hour<12){return 'ØµØ¨Ø';}
return 'Ø´Ø§Ù…';},calendar:{sameDay:'[Ø¢Ø¬ Ø¨ÙˆÙ‚Øª] LT',nextDay:'[Ú©Ù„ Ø¨ÙˆÙ‚Øª] LT',nextWeek:'dddd [Ø¨ÙˆÙ‚Øª] LT',lastDay:'[Ú¯Ø°Ø´ØªÛ Ø±ÙˆØ² Ø¨ÙˆÙ‚Øª] LT',lastWeek:'[Ú¯Ø°Ø´ØªÛ] dddd [Ø¨ÙˆÙ‚Øª] LT',sameElse:'L'},relativeTime:{future:'%s Ø¨Ø¹Ø¯',past:'%s Ù‚Ø¨Ù„',s:'Ú†Ù†Ø¯ Ø³ÛŒÚ©Ù†Úˆ',ss:'%d Ø³ÛŒÚ©Ù†Úˆ',m:'Ø§ÛŒÚ© Ù…Ù†Ù¹',mm:'%d Ù…Ù†Ù¹',h:'Ø§ÛŒÚ© Ú¯Ú¾Ù†Ù¹Û',hh:'%d Ú¯Ú¾Ù†Ù¹Û’',d:'Ø§ÛŒÚ© Ø¯Ù†',dd:'%d Ø¯Ù†',M:'Ø§ÛŒÚ© Ù…Ø§Û',MM:'%d Ù…Ø§Û',y:'Ø§ÛŒÚ© Ø³Ø§Ù„',yy:'%d Ø³Ø§Ù„'},preparse:function(string){return string.replace(/ØŒ/g,',');},postformat:function(string){return string.replace(/,/g,'ØŒ');},week:{dow:1,doy:4}});hooks.defineLocale('uz-latn',{months:'Yanvar_Fevral_Mart_Aprel_May_Iyun_Iyul_Avgust_Sentabr_Oktabr_Noyabr_Dekabr'.split('_'),monthsShort:'Yan_Fev_Mar_Apr_May_Iyun_Iyul_Avg_Sen_Okt_Noy_Dek'.split('_'),weekdays:'Yakshanba_Dushanba_Seshanba_Chorshanba_Payshanba_Juma_Shanba'.split('_'),weekdaysShort:'Yak_Dush_Sesh_Chor_Pay_Jum_Shan'.split('_'),weekdaysMin:'Ya_Du_Se_Cho_Pa_Ju_Sha'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'D MMMM YYYY, dddd HH:mm'},calendar:{sameDay:'[Bugun soat] LT [da]',nextDay:'[Ertaga] LT [da]',nextWeek:'dddd [kuni soat] LT [da]',lastDay:'[Kecha soat] LT [da]',lastWeek:'[O\'tgan] dddd [kuni soat] LT [da]',sameElse:'L'},relativeTime:{future:'Yaqin %s ichida',past:'Bir necha %s oldin',s:'soniya',ss:'%d soniya',m:'bir daqiqa',mm:'%d daqiqa',h:'bir soat',hh:'%d soat',d:'bir kun',dd:'%d kun',M:'bir oy',MM:'%d oy',y:'bir yil',yy:'%d yil'},week:{dow:1,doy:7}});hooks.defineLocale('uz',{months:'ÑÐ½Ð²Ð°Ñ€_Ñ„ÐµÐ²Ñ€Ð°Ð»_Ð¼Ð°Ñ€Ñ‚_Ð°Ð¿Ñ€ÐµÐ»_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½_Ð¸ÑŽÐ»_Ð°Ð²Ð³ÑƒÑÑ‚_ÑÐµÐ½Ñ‚ÑÐ±Ñ€_Ð¾ÐºÑ‚ÑÐ±Ñ€_Ð½Ð¾ÑÐ±Ñ€_Ð´ÐµÐºÐ°Ð±Ñ€'.split('_'),monthsShort:'ÑÐ½Ð²_Ñ„ÐµÐ²_Ð¼Ð°Ñ€_Ð°Ð¿Ñ€_Ð¼Ð°Ð¹_Ð¸ÑŽÐ½_Ð¸ÑŽÐ»_Ð°Ð²Ð³_ÑÐµÐ½_Ð¾ÐºÑ‚_Ð½Ð¾Ñ_Ð´ÐµÐº'.split('_'),weekdays:'Ð¯ÐºÑˆÐ°Ð½Ð±Ð°_Ð”ÑƒÑˆÐ°Ð½Ð±Ð°_Ð¡ÐµÑˆÐ°Ð½Ð±Ð°_Ð§Ð¾Ñ€ÑˆÐ°Ð½Ð±Ð°_ÐŸÐ°Ð¹ÑˆÐ°Ð½Ð±Ð°_Ð–ÑƒÐ¼Ð°_Ð¨Ð°Ð½Ð±Ð°'.split('_'),weekdaysShort:'Ð¯ÐºÑˆ_Ð”ÑƒÑˆ_Ð¡ÐµÑˆ_Ð§Ð¾Ñ€_ÐŸÐ°Ð¹_Ð–ÑƒÐ¼_Ð¨Ð°Ð½'.split('_'),weekdaysMin:'Ð¯Ðº_Ð”Ñƒ_Ð¡Ðµ_Ð§Ð¾_ÐŸÐ°_Ð–Ñƒ_Ð¨Ð°'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'D MMMM YYYY, dddd HH:mm'},calendar:{sameDay:'[Ð‘ÑƒÐ³ÑƒÐ½ ÑÐ¾Ð°Ñ‚] LT [Ð´Ð°]',nextDay:'[ÐÑ€Ñ‚Ð°Ð³Ð°] LT [Ð´Ð°]',nextWeek:'dddd [ÐºÑƒÐ½Ð¸ ÑÐ¾Ð°Ñ‚] LT [Ð´Ð°]',lastDay:'[ÐšÐµÑ‡Ð° ÑÐ¾Ð°Ñ‚] LT [Ð´Ð°]',lastWeek:'[Ð£Ñ‚Ð³Ð°Ð½] dddd [ÐºÑƒÐ½Ð¸ ÑÐ¾Ð°Ñ‚] LT [Ð´Ð°]',sameElse:'L'},relativeTime:{future:'Ð¯ÐºÐ¸Ð½ %s Ð¸Ñ‡Ð¸Ð´Ð°',past:'Ð‘Ð¸Ñ€ Ð½ÐµÑ‡Ð° %s Ð¾Ð»Ð´Ð¸Ð½',s:'Ñ„ÑƒÑ€ÑÐ°Ñ‚',ss:'%d Ñ„ÑƒÑ€ÑÐ°Ñ‚',m:'Ð±Ð¸Ñ€ Ð´Ð°ÐºÐ¸ÐºÐ°',mm:'%d Ð´Ð°ÐºÐ¸ÐºÐ°',h:'Ð±Ð¸Ñ€ ÑÐ¾Ð°Ñ‚',hh:'%d ÑÐ¾Ð°Ñ‚',d:'Ð±Ð¸Ñ€ ÐºÑƒÐ½',dd:'%d ÐºÑƒÐ½',M:'Ð±Ð¸Ñ€ Ð¾Ð¹',MM:'%d Ð¾Ð¹',y:'Ð±Ð¸Ñ€ Ð¹Ð¸Ð»',yy:'%d Ð¹Ð¸Ð»'},week:{dow:1,doy:7}});hooks.defineLocale('vi',{months:'thÃ¡ng 1_thÃ¡ng 2_thÃ¡ng 3_thÃ¡ng 4_thÃ¡ng 5_thÃ¡ng 6_thÃ¡ng 7_thÃ¡ng 8_thÃ¡ng 9_thÃ¡ng 10_thÃ¡ng 11_thÃ¡ng 12'.split('_'),monthsShort:'Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12'.split('_'),monthsParseExact:true,weekdays:'chá»§ nháºt_thá»© hai_thá»© ba_thá»© tÆ°_thá»© nÄƒm_thá»© sÃ¡u_thá»© báº£y'.split('_'),weekdaysShort:'CN_T2_T3_T4_T5_T6_T7'.split('_'),weekdaysMin:'CN_T2_T3_T4_T5_T6_T7'.split('_'),weekdaysParseExact:true,meridiemParse:/sa|ch/i,isPM:function(input){return /^ch$/i.test(input);},meridiem:function(hours,minutes,isLower){if(hours<12){return isLower?'sa':'SA';}else{return isLower?'ch':'CH';}},longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'DD/MM/YYYY',LL:'D MMMM [nÄƒm] YYYY',LLL:'D MMMM [nÄƒm] YYYY HH:mm',LLLL:'dddd, D MMMM [nÄƒm] YYYY HH:mm',l:'DD/M/YYYY',ll:'D MMM YYYY',lll:'D MMM YYYY HH:mm',llll:'ddd, D MMM YYYY HH:mm'},calendar:{sameDay:'[HÃ´m nay lÃºc] LT',nextDay:'[NgÃ y mai lÃºc] LT',nextWeek:'dddd [tuáº§n tá»›i lÃºc] LT',lastDay:'[HÃ´m qua lÃºc] LT',lastWeek:'dddd [tuáº§n rá»“i lÃºc] LT',sameElse:'L'},relativeTime:{future:'%s tá»›i',past:'%s trÆ°á»›c',s:'vÃ i giÃ¢y',ss:'%d giÃ¢y',m:'má»™t phÃºt',mm:'%d phÃºt',h:'má»™t giá»',hh:'%d giá»',d:'má»™t ngÃ y',dd:'%d ngÃ y',M:'má»™t thÃ¡ng',MM:'%d thÃ¡ng',y:'má»™t nÄƒm',yy:'%d nÄƒm'},dayOfMonthOrdinalParse:/\d{1,2}/,ordinal:function(number){return number;},week:{dow:1,doy:4}});hooks.defineLocale('x-pseudo',{months:'J~Ã¡Ã±ÃºÃ¡~rÃ½_F~Ã©brÃº~Ã¡rÃ½_~MÃ¡rc~h_Ãp~rÃl_~MÃ¡Ã½_~JÃºÃ±Ã©~_JÃºl~Ã½_ÃÃº~gÃºst~_SÃ©p~tÃ©mb~Ã©r_Ã“~ctÃ³b~Ã©r_Ã‘~Ã³vÃ©m~bÃ©r_~DÃ©cÃ©~mbÃ©r'.split('_'),monthsShort:'J~Ã¡Ã±_~FÃ©b_~MÃ¡r_~Ãpr_~MÃ¡Ã½_~JÃºÃ±_~JÃºl_~ÃÃºg_~SÃ©p_~Ã“ct_~Ã‘Ã³v_~DÃ©c'.split('_'),monthsParseExact:true,weekdays:'S~ÃºÃ±dÃ¡~Ã½_MÃ³~Ã±dÃ¡Ã½~_TÃºÃ©~sdÃ¡Ã½~_WÃ©d~Ã±Ã©sd~Ã¡Ã½_T~hÃºrs~dÃ¡Ã½_~FrÃd~Ã¡Ã½_S~Ã¡tÃºr~dÃ¡Ã½'.split('_'),weekdaysShort:'S~ÃºÃ±_~MÃ³Ã±_~TÃºÃ©_~WÃ©d_~ThÃº_~FrÃ_~SÃ¡t'.split('_'),weekdaysMin:'S~Ãº_MÃ³~_TÃº_~WÃ©_T~h_Fr~_SÃ¡'.split('_'),weekdaysParseExact:true,longDateFormat:{LT:'HH:mm',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY HH:mm',LLLL:'dddd, D MMMM YYYY HH:mm'},calendar:{sameDay:'[T~Ã³dÃ¡~Ã½ Ã¡t] LT',nextDay:'[T~Ã³mÃ³~rrÃ³~w Ã¡t] LT',nextWeek:'dddd [Ã¡t] LT',lastDay:'[Ã~Ã©st~Ã©rdÃ¡~Ã½ Ã¡t] LT',lastWeek:'[L~Ã¡st] dddd [Ã¡t] LT',sameElse:'L'},relativeTime:{future:'Ã~Ã± %s',past:'%s Ã¡~gÃ³',s:'Ã¡ ~fÃ©w ~sÃ©cÃ³~Ã±ds',ss:'%d s~Ã©cÃ³Ã±~ds',m:'Ã¡ ~mÃÃ±~ÃºtÃ©',mm:'%d m~ÃÃ±Ãº~tÃ©s',h:'Ã¡~Ã± hÃ³~Ãºr',hh:'%d h~Ã³Ãºrs',d:'Ã¡ ~dÃ¡Ã½',dd:'%d d~Ã¡Ã½s',M:'Ã¡ ~mÃ³Ã±~th',MM:'%d m~Ã³Ã±t~hs',y:'Ã¡ ~Ã½Ã©Ã¡r',yy:'%d Ã½~Ã©Ã¡rs'},dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(number){var b=number%10,output=(~~(number%100/10)===1)?'th':(b===1)?'st':(b===2)?'nd':(b===3)?'rd':'th';return number+output;},week:{dow:1,doy:4}});hooks.defineLocale('yo',{months:'Sáº¹Ìráº¹Ì_ÃˆrÃ¨lÃ¨_áº¸ráº¹Ì€nÃ _ÃŒgbÃ©_Ãˆbibi_Ã’kÃ¹du_Agáº¹mo_Ã’gÃºn_Owewe_á»ŒÌ€wÃ rÃ _BÃ©lÃº_á»ŒÌ€páº¹Ì€Ì€'.split('_'),monthsShort:'Sáº¹Ìr_Ãˆrl_áº¸rn_ÃŒgb_Ãˆbi_Ã’kÃ¹_Agáº¹_Ã’gÃº_Owe_á»ŒÌ€wÃ _BÃ©l_á»ŒÌ€páº¹Ì€Ì€'.split('_'),weekdays:'Ã€Ã¬kÃº_AjÃ©_ÃŒsáº¹Ìgun_á»Œjá»ÌrÃº_á»Œjá»Ìbá»_áº¸tÃ¬_Ã€bÃ¡máº¹Ìta'.split('_'),weekdaysShort:'Ã€Ã¬k_AjÃ©_ÃŒsáº¹Ì_á»Œjr_á»Œjb_áº¸tÃ¬_Ã€bÃ¡'.split('_'),weekdaysMin:'Ã€Ã¬_Aj_ÃŒs_á»Œr_á»Œb_áº¸t_Ã€b'.split('_'),longDateFormat:{LT:'h:mm A',LTS:'h:mm:ss A',L:'DD/MM/YYYY',LL:'D MMMM YYYY',LLL:'D MMMM YYYY h:mm A',LLLL:'dddd, D MMMM YYYY h:mm A'},calendar:{sameDay:'[Ã’nÃ¬ ni] LT',nextDay:'[á»ŒÌ€la ni] LT',nextWeek:'dddd [á»Œsáº¹Ì€ tÃ³n\'bá»] [ni] LT',lastDay:'[Ã€na ni] LT',lastWeek:'dddd [á»Œsáº¹Ì€ tÃ³lá»Ì] [ni] LT',sameElse:'L'},relativeTime:{future:'nÃ %s',past:'%s ká»jÃ¡',s:'Ã¬sáº¹jÃº aayÃ¡ die',ss:'aayÃ¡ %d',m:'Ã¬sáº¹jÃº kan',mm:'Ã¬sáº¹jÃº %d',h:'wÃ¡kati kan',hh:'wÃ¡kati %d',d:'á»já»Ì kan',dd:'á»já»Ì %d',M:'osÃ¹ kan',MM:'osÃ¹ %d',y:'á»dÃºn kan',yy:'á»dÃºn %d'},dayOfMonthOrdinalParse:/á»já»Ì\s\d{1,2}/,ordinal:'á»já»Ì %d',week:{dow:1,doy:4}});hooks.defineLocale('zh-cn',{months:'ä¸€æœˆ_äºŒæœˆ_ä¸‰æœˆ_å››æœˆ_äº”æœˆ_å…æœˆ_ä¸ƒæœˆ_å…«æœˆ_ä¹æœˆ_åæœˆ_åä¸€æœˆ_åäºŒæœˆ'.split('_'),monthsShort:'1æœˆ_2æœˆ_3æœˆ_4æœˆ_5æœˆ_6æœˆ_7æœˆ_8æœˆ_9æœˆ_10æœˆ_11æœˆ_12æœˆ'.split('_'),weekdays:'æ˜ŸæœŸæ—¥_æ˜ŸæœŸä¸€_æ˜ŸæœŸäºŒ_æ˜ŸæœŸä¸‰_æ˜ŸæœŸå››_æ˜ŸæœŸäº”_æ˜ŸæœŸå…'.split('_'),weekdaysShort:'å‘¨æ—¥_å‘¨ä¸€_å‘¨äºŒ_å‘¨ä¸‰_å‘¨å››_å‘¨äº”_å‘¨å…'.split('_'),weekdaysMin:'æ—¥_ä¸€_äºŒ_ä¸‰_å››_äº”_å…'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY/MM/DD',LL:'YYYYå¹´MæœˆDæ—¥',LLL:'YYYYå¹´MæœˆDæ—¥Ahç‚¹mmåˆ†',LLLL:'YYYYå¹´MæœˆDæ—¥ddddAhç‚¹mmåˆ†',l:'YYYY/M/D',ll:'YYYYå¹´MæœˆDæ—¥',lll:'YYYYå¹´MæœˆDæ—¥ HH:mm',llll:'YYYYå¹´MæœˆDæ—¥dddd HH:mm'},meridiemParse:/å‡Œæ™¨|æ—©ä¸Š|ä¸Šåˆ|ä¸åˆ|ä¸‹åˆ|æ™šä¸Š/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='å‡Œæ™¨'||meridiem==='æ—©ä¸Š'||meridiem==='ä¸Šåˆ'){return hour;}else if(meridiem==='ä¸‹åˆ'||meridiem==='æ™šä¸Š'){return hour+12;}else{return hour>=11?hour:hour+12;}},meridiem:function(hour,minute,isLower){var hm=hour*100+minute;if(hm<600){return 'å‡Œæ™¨';}else if(hm<900){return 'æ—©ä¸Š';}else if(hm<1130){return 'ä¸Šåˆ';}else if(hm<1230){return 'ä¸åˆ';}else if(hm<1800){return 'ä¸‹åˆ';}else{return 'æ™šä¸Š';}},calendar:{sameDay:'[ä»Šå¤©]LT',nextDay:'[æ˜Žå¤©]LT',nextWeek:'[ä¸‹]ddddLT',lastDay:'[æ˜¨å¤©]LT',lastWeek:'[ä¸Š]ddddLT',sameElse:'L'},dayOfMonthOrdinalParse:/\d{1,2}(æ—¥|æœˆ|å‘¨)/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'æ—¥';case 'M':return number+'æœˆ';case 'w':case 'W':return number+'å‘¨';default:return number;}},relativeTime:{future:'%så†…',past:'%så‰',s:'å‡ ç§’',ss:'%d ç§’',m:'1 åˆ†é’Ÿ',mm:'%d åˆ†é’Ÿ',h:'1 å°æ—¶',hh:'%d å°æ—¶',d:'1 å¤©',dd:'%d å¤©',M:'1 ä¸ªæœˆ',MM:'%d ä¸ªæœˆ',y:'1 å¹´',yy:'%d å¹´'},week:{dow:1,doy:4}});hooks.defineLocale('zh-hk',{months:'ä¸€æœˆ_äºŒæœˆ_ä¸‰æœˆ_å››æœˆ_äº”æœˆ_å…æœˆ_ä¸ƒæœˆ_å…«æœˆ_ä¹æœˆ_åæœˆ_åä¸€æœˆ_åäºŒæœˆ'.split('_'),monthsShort:'1æœˆ_2æœˆ_3æœˆ_4æœˆ_5æœˆ_6æœˆ_7æœˆ_8æœˆ_9æœˆ_10æœˆ_11æœˆ_12æœˆ'.split('_'),weekdays:'æ˜ŸæœŸæ—¥_æ˜ŸæœŸä¸€_æ˜ŸæœŸäºŒ_æ˜ŸæœŸä¸‰_æ˜ŸæœŸå››_æ˜ŸæœŸäº”_æ˜ŸæœŸå…'.split('_'),weekdaysShort:'é€±æ—¥_é€±ä¸€_é€±äºŒ_é€±ä¸‰_é€±å››_é€±äº”_é€±å…'.split('_'),weekdaysMin:'æ—¥_ä¸€_äºŒ_ä¸‰_å››_äº”_å…'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY/MM/DD',LL:'YYYYå¹´MæœˆDæ—¥',LLL:'YYYYå¹´MæœˆDæ—¥ HH:mm',LLLL:'YYYYå¹´MæœˆDæ—¥dddd HH:mm',l:'YYYY/M/D',ll:'YYYYå¹´MæœˆDæ—¥',lll:'YYYYå¹´MæœˆDæ—¥ HH:mm',llll:'YYYYå¹´MæœˆDæ—¥dddd HH:mm'},meridiemParse:/å‡Œæ™¨|æ—©ä¸Š|ä¸Šåˆ|ä¸åˆ|ä¸‹åˆ|æ™šä¸Š/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='å‡Œæ™¨'||meridiem==='æ—©ä¸Š'||meridiem==='ä¸Šåˆ'){return hour;}else if(meridiem==='ä¸åˆ'){return hour>=11?hour:hour+12;}else if(meridiem==='ä¸‹åˆ'||meridiem==='æ™šä¸Š'){return hour+12;}},meridiem:function(hour,minute,isLower){var hm=hour*100+minute;if(hm<600){return 'å‡Œæ™¨';}else if(hm<900){return 'æ—©ä¸Š';}else if(hm<1130){return 'ä¸Šåˆ';}else if(hm<1230){return 'ä¸åˆ';}else if(hm<1800){return 'ä¸‹åˆ';}else{return 'æ™šä¸Š';}},calendar:{sameDay:'[ä»Šå¤©]LT',nextDay:'[æ˜Žå¤©]LT',nextWeek:'[ä¸‹]ddddLT',lastDay:'[æ˜¨å¤©]LT',lastWeek:'[ä¸Š]ddddLT',sameElse:'L'},dayOfMonthOrdinalParse:/\d{1,2}(æ—¥|æœˆ|é€±)/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'æ—¥';case 'M':return number+'æœˆ';case 'w':case 'W':return number+'é€±';default:return number;}},relativeTime:{future:'%så…§',past:'%så‰',s:'å¹¾ç§’',ss:'%d ç§’',m:'1 åˆ†é˜',mm:'%d åˆ†é˜',h:'1 å°æ™‚',hh:'%d å°æ™‚',d:'1 å¤©',dd:'%d å¤©',M:'1 å€‹æœˆ',MM:'%d å€‹æœˆ',y:'1 å¹´',yy:'%d å¹´'}});hooks.defineLocale('zh-tw',{months:'ä¸€æœˆ_äºŒæœˆ_ä¸‰æœˆ_å››æœˆ_äº”æœˆ_å…æœˆ_ä¸ƒæœˆ_å…«æœˆ_ä¹æœˆ_åæœˆ_åä¸€æœˆ_åäºŒæœˆ'.split('_'),monthsShort:'1æœˆ_2æœˆ_3æœˆ_4æœˆ_5æœˆ_6æœˆ_7æœˆ_8æœˆ_9æœˆ_10æœˆ_11æœˆ_12æœˆ'.split('_'),weekdays:'æ˜ŸæœŸæ—¥_æ˜ŸæœŸä¸€_æ˜ŸæœŸäºŒ_æ˜ŸæœŸä¸‰_æ˜ŸæœŸå››_æ˜ŸæœŸäº”_æ˜ŸæœŸå…'.split('_'),weekdaysShort:'é€±æ—¥_é€±ä¸€_é€±äºŒ_é€±ä¸‰_é€±å››_é€±äº”_é€±å…'.split('_'),weekdaysMin:'æ—¥_ä¸€_äºŒ_ä¸‰_å››_äº”_å…'.split('_'),longDateFormat:{LT:'HH:mm',LTS:'HH:mm:ss',L:'YYYY/MM/DD',LL:'YYYYå¹´MæœˆDæ—¥',LLL:'YYYYå¹´MæœˆDæ—¥ HH:mm',LLLL:'YYYYå¹´MæœˆDæ—¥dddd HH:mm',l:'YYYY/M/D',ll:'YYYYå¹´MæœˆDæ—¥',lll:'YYYYå¹´MæœˆDæ—¥ HH:mm',llll:'YYYYå¹´MæœˆDæ—¥dddd HH:mm'},meridiemParse:/å‡Œæ™¨|æ—©ä¸Š|ä¸Šåˆ|ä¸åˆ|ä¸‹åˆ|æ™šä¸Š/,meridiemHour:function(hour,meridiem){if(hour===12){hour=0;}
if(meridiem==='å‡Œæ™¨'||meridiem==='æ—©ä¸Š'||meridiem==='ä¸Šåˆ'){return hour;}else if(meridiem==='ä¸åˆ'){return hour>=11?hour:hour+12;}else if(meridiem==='ä¸‹åˆ'||meridiem==='æ™šä¸Š'){return hour+12;}},meridiem:function(hour,minute,isLower){var hm=hour*100+minute;if(hm<600){return 'å‡Œæ™¨';}else if(hm<900){return 'æ—©ä¸Š';}else if(hm<1130){return 'ä¸Šåˆ';}else if(hm<1230){return 'ä¸åˆ';}else if(hm<1800){return 'ä¸‹åˆ';}else{return 'æ™šä¸Š';}},calendar:{sameDay:'[ä»Šå¤©] LT',nextDay:'[æ˜Žå¤©] LT',nextWeek:'[ä¸‹]dddd LT',lastDay:'[æ˜¨å¤©] LT',lastWeek:'[ä¸Š]dddd LT',sameElse:'L'},dayOfMonthOrdinalParse:/\d{1,2}(æ—¥|æœˆ|é€±)/,ordinal:function(number,period){switch(period){case 'd':case 'D':case 'DDD':return number+'æ—¥';case 'M':return number+'æœˆ';case 'w':case 'W':return number+'é€±';default:return number;}},relativeTime:{future:'%så…§',past:'%så‰',s:'å¹¾ç§’',ss:'%d ç§’',m:'1 åˆ†é˜',mm:'%d åˆ†é˜',h:'1 å°æ™‚',hh:'%d å°æ™‚',d:'1 å¤©',dd:'%d å¤©',M:'1 å€‹æœˆ',MM:'%d å€‹æœˆ',y:'1 å¹´',yy:'%d å¹´'}});hooks.locale('en');return hooks;})));