<?php

# заголовок
define('TITLE', 'Животные');

# определение данных
$params = PARAMS; // получение параметров
$refresh = $FUNC->random(8, true); // случайное число

####################
####################

# покупка животного
if (isset($params['param']) && $params['param'] == 'buy' && isset($params['num']) && 
isset($params['pet']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметров
$num = $FUNC->filter($params['num'], 'int'); // загон
$pet = $FUNC->filter($params['pet'], 'int'); // животное

# проверка загона на покупку, в базе данных
if (db_exist($DB, 'animal', 'id', array('num' => $num, 'pet' => 0, 'user' => USER['id'])) && 
$pet > 0 && $pet < 4) { $price = PRICE['anim_'. $pet]; $access = true; } else $access = false;

# проверка на возможность покупки
if ($access && $price <= USER['money']) {

# вывод загона из базы данных
$shelter = db_output($DB, 'animal', 'id', array('num' => $num, 'user' => USER['id']));

# время продукции
$prod = explode(';', ANIMAL['food_'. $pet]); $food = time() + $GAME->random($prod[0], $prod[1]); // продукция

# обновление данных, в базе данных
db_update($DB, 'animal', array('feed' => time(), 'food' => $food, 'pet' => $pet), array ('id' => $shelter['id'])); // загон
db_update($DB, 'users', array('money' => $price .';-'), array ('id' => USER['id'])); } } // монеты игрока

####################

# удаление животного, массовое удаление
if (isset($params['param']) && $params['param'] == 'deletion' && isset($params['act']) && 
$params['act'] == 'delete' && isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, загон
$num = $FUNC->filter($params['num'], 'int');

# проверка загона на удаление, в базе данных
if (db_exist($DB, 'animal', 'id', array('num' => $num, 'pet;!=' => 0, 'user' => USER['id']))) { // проверка загона
$shelter = db_output($DB, 'animal', 'id', array('num' => $num, 'user' => USER['id'])); // выбор загона
db_update($DB, 'animal', array('feed' => 0, 'food' => 0, 'pet' => 0), array ('id' => $shelter['id'])); } } // обновление загона

####################

# массовое удаление животных
if (isset($params['param']) && $params['param'] == 'deletion' && isset($params['token']) && $params['token'] == TOKEN) {

# проверка загонов на удаление, в базе данных
if (db_exist($DB, 'animal', 'id', array('pet;!=' => 0, 'user' => USER['id']))) $deletion = true; }

####################

# кормление животного
if (isset($params['param']) && $params['param'] == 'feed' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, загон
$num = $FUNC->filter($params['num'], 'int');

# проверка и вывод животного, из базы данных
if (db_exist($DB, 'animal', 'id', array('feed' => 0, 'food' => 0, 'num' => $num, 'pet;!=' => 0, 'user' => 
USER['id']))) { $out = db_output($DB, 'animal', 'pet', array('num' => $num, 'user' => USER['id']));
$object = explode(';', ANIMAL['eat_'. $out['pet']]); $access = true; } else $access = false;

# проверка загона на возможность кормления, в базе данных
if ($access && db_exist($DB, 'storage', 'id', array('count;>' => 0, 'object' => $object[1], 'type' => 'plant', 'user' => USER['id']))) { 

# выбор данных из базы данных
$shelter = db_output($DB, 'animal', array('id', 'pet'), array('num' => $num, 'user' => USER['id'])); // загон
$storage = db_output($DB, 'storage', array('id', 'count'), array('object' => $object[1], 'type' => 'plant', 'user' => USER['id'])); // растение

# обновление количества растений
$count = $storage['count'] - 1; if ($count == 0) db_delete($DB, 'storage', array('id' => $storage['id'])); // удаление при нуле
else db_update($DB, 'storage', array('count' => '1;-'), array('id' => $storage['id'])); // новое количество

# данные о кормлении животного
$prod = explode(';', ANIMAL['food_'. $shelter['pet']]);
$food = time() + $GAME->random($prod[0], $prod[1]);

# обновление статистики игрока, очки
db_update($DB, 'statistic', array('points' => '2;+'), array('id' => USER['id']));

# обновление данных, в базе данных
db_update($DB, 'settings', array('storage' => '1;-'), array ('id' => USER['id'])); // место на складе
db_update($DB, 'animal', array('feed' => time(), 'food' => $food), array ('id' => $shelter['id'])); } } // загон

####################

# сбор продуктов
if (isset($params['param']) && $params['param'] == 'food' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, загон
$num = $FUNC->filter($params['num'], 'int');

# проверка загона на сбор продуктов, в базе данных
if (db_exist($DB, 'animal', 'id', array('food;<' => time(), 'food;!=' => 0, 'num' => $num, 
'pet;!=' => 0, 'user' => USER['id'])) && SETUP['storage'] < DATA['storage']) { 

# выбор загона из базы данных
$shelter = db_output($DB, 'animal', array('id', 'pet'), array('num' => $num, 'user' => USER['id']));

# обновление количества продуктов на складе, в базе данных
if (db_exist($DB, 'storage', 'id', array('object' => $shelter['pet'], 'type' => 'food', 'user' => USER['id'])))
db_update($DB, 'storage', array('count' => '1;+'), array ('object' => $shelter['pet'], 'type' => 'food', 'user' => USER['id'])); // продукт имеется
else db_create($DB, 'storage', array('count' => 1, 'object' => $shelter['pet'], 'type' => 'food', 'user' => USER['id'])); // новый продукт

# обновление статистики игрока
db_update($DB, 'statistic', array('points' => '2;+', 'product' => '1;+'), array('id' => USER['id']));

# обновление данных, в базе данных
db_update($DB, 'settings', array('storage' => '1;+'), array ('id' => USER['id'])); // место на складе
db_update($DB, 'animal', array('feed' => 0, 'food' => 0), array ('id' => $shelter['id'])); } } // загон

####################

# выбор места для покупки животного
if (isset($params['param']) && $params['param'] == 'pet' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, животное
$num = $FUNC->filter($params['num'], 'int');

# проверка животного на покупку, в базе данных
if (db_exist($DB, 'animal', 'id', array('pet' => 0, 'user' => USER['id'])) && $num > 0 && $num < 4) $purchase = $num; }

####################
####################

# вывод животных из базы данных
$query = db_output($DB, 'animal', array('id', 'feed', 'food', 'num', 'pet'), array('user' => USER['id']), true, 'num', DATA['animal']);

# данные верхней ссылки
if (isset($deletion)) $top = array('icon' => 'back', 'link' => 'Вернуться к животным'); // назад
else $top = array('icon' => 'refresh', 'link' => 'Обновить'); // обновить

# данные нижней ссылки
$bottom = (db_exist($DB, 'animal', 'id', array('pet;!=' => 0, 'user' => USER['id']))) ? true : false;

# разбор животных, переработка данных в массиве
$index = 0; while ($assoc = $query->fetch_assoc()) {
$animal[$index] = $assoc; $index++; }

####################

# определение автообновления
$update = (isset($deletion)) ? false : 'update ';

# вывод животных
foreach ($animal as &$post) { $post['color'] = false; // стиль названия по умолчанию

# определение данных
$post['name'] = ($post['pet'] == 0) ? 'Пустое место' : ANIMAL['name_'. $post['pet']]; // заголовок
$post['image'] = ($post['pet'] == 0) ? 'area/empty' : $GAME->pet(ANIMAL['image_'. $post['pet']], $post['feed'], $post['food']); // картинка

# данные о животных
$eat = ($post['pet'] != 0) ? explode(';', ANIMAL['eat_'. $post['pet']]) : false; // кормление
$prod = ($post['pet'] != 0) ? 'Забрать '. mb_strtolower(ANIMAL['prod_'. $post['pet']]) : false; // продукт

####################

# время ожидания продукции
$odds = $post['food'] - time(); $harv = ($post['pet'] == 1) ? 'собрать' : 'забрать'; // время, тип продукта
$wait = ($post['food'] > time()) ? 'через '. $USER->when($odds, true, true) : 'можно '. $harv; // текст действия

# выбор места для покупки техники
if (isset($purchase)) { if (USER['money'] >= PRICE['anim_'. $purchase] && $post['pet'] == 0) { $post['icon'] = 'load';  // проверка баланса
$post['text'] = 'Поставить здесь'; $post['link'] = 'animal/buy/num/'. $post['num'] .'/pet/'. $purchase; } else { $lacks = PRICE['anim_'. $purchase] - USER['money']; // покупка возможна
$post['icon'] = 'cross'; $post['text'] = ($post['pet'] == 0) ? 'Не хватает '. $lacks .' монет' : 'Место занято'; $post['link'] = false; } } // покупка невозможна

####################

# массовое удаление животных
elseif (isset($params['param']) && $params['param'] == 'deletion' && isset($params['token']) && $params['token'] == TOKEN && 
db_exist($DB, 'animal', 'id', array('pet;!=' => 0, 'user' => USER['id']))) { $bottom = false; // удаление нижней ссылки

# действие, определение данных
if ($post['pet'] != 0) { $post['icon'] = 'delete'; $post['text'] = 'Убрать животное'; // иконка
$post['link'] = 'animal/deletion/act/delete/num/'. $post['num']; } else { // ссылка
$post['icon'] = 'cross'; $post['text'] = 'Нет действия'; $post['link'] = false; } }  // нет действия

####################

# вывод животных, определение действия
else { if ($post['pet'] == 0) { $post['icon'] = 'money'; $post['text'] = 'Купить животное'; $post['link'] = 'shop/animal/num/'. $post['num']; } // покупка животного
elseif ($post['feed'] == 0 && $post['food'] == 0 && $post['pet'] != 0 && db_exist($DB, 'storage', 'id', array('count;>' => 0, 'object' => $eat[1], 'type' => 'plant', 
'user' => USER['id']))) { $post['color'] = true; $post['icon'] = 'eat'; $post['text'] = 'Кормить '. $eat[0]; $post['link'] = 'animal/feed/num/'. $post['num']; } // кормление животного
elseif ($post['food'] < time() && $post['food'] != 0 && $post['pet'] != 0 && SETUP['storage'] < DATA['storage']) { $post['color'] = true; $post['icon'] = 'hand';  
$post['text'] = $prod; $post['link'] = 'animal/food/num/'. $post['num']; } elseif ($post['food'] < time() && $post['food'] != 0 && $post['pet'] != 0 && // сбор продуктов, есть место
SETUP['storage'] >= DATA['storage']) { $post['color'] = true; $post['icon'] = 'cross'; $post['text'] = 'Нет места на складе'; $post['link'] = false; } // сбор продуктов, нет места 
elseif ($post['feed'] < time() && $post['food'] < time() && $post['pet'] != 0 ) { $post['color'] = true; $post['icon'] = 'cross'; $post['text'] = 'Голодное животное'; // голодное животное
$post['link'] = false; } else { $post['icon'] = 'time'; $post['text'] = ANIMAL['prod_'. $post['pet']] .' '. $wait; $post['link'] = false; } } // ожидание продукции
$post['name'] = ($post['color']) ? '<span class="color">'. $post['name'] .'</span>' : $post['name']; } // стиль названия

?>