<?php

# заголовок
define('TITLE', 'Растения');

# определение данных
$params = PARAMS; // получение параметров
$refresh = $FUNC->random(8, true); // случайное число

####################
####################

# вскопка земли
if (isset($params['param']) && $params['param'] == 'digging' && isset($params['act']) && 
$params['act'] == 'dig' && isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, земля
$num = $FUNC->filter($params['num'], 'int');

# проверка земли на вскопку, в базе данных
if (db_exist($DB, 'garden', 'id', array('num' => $num, 'plant;!=' => 0, 'user' => USER['id']))) { // проверка земли
$garth = db_output($DB, 'garden', 'id', array('num' => $num, 'user' => USER['id'])); // выбор земли
db_update($DB, 'garden', array('harv' => 0, 'plant' => 0, 'seed' => 0), array('id' => $garth['id'])); } } // обновление земли

####################

# массовое вскапывание грядок
if (isset($params['param']) && $params['param'] == 'digging' && isset($params['token']) && $params['token'] == TOKEN) {

# проверка грядок на вскапывание, в базе данных
if (db_exist($DB, 'garden', 'id', array('plant;!=' => 0, 'user' => USER['id']))) $digging = true; }

####################

# сбор урожая
if (isset($params['param']) && $params['param'] == 'harv' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, земля
$num = $FUNC->filter($params['num'], 'int');

# проверка земли на сбор урожая, в базе данных
if (db_exist($DB, 'garden', 'id', array('harv;<' => time(), 'num' => $num, 
'plant;!=' => 0, 'user' => USER['id'])) && SETUP['storage'] < DATA['storage']) { 

# выбор земли из базы данных
$garth = db_output($DB, 'garden', array('id', 'plant'), array('num' => $num, 'user' => USER['id']));

# обновление количества растений на складе, в базе данных
if (db_exist($DB, 'storage', 'id', array('object' => $garth['plant'], 'type' => 'plant', 'user' => USER['id'])))
db_update($DB, 'storage', array('count' => '1;+'), array ('object' => $garth['plant'], 'type' => 'plant', 'user' => USER['id'])); // растение имеется
else db_create($DB, 'storage', array('count' => 1, 'object' => $garth['plant'], 'type' => 'plant', 'user' => USER['id'])); // новое растение

# данные об урожае растения
$crop = explode(';', PLANT['harv_'. $garth['plant']]); $harv = time() + $GAME->random($crop[0], $crop[1]);

# обновление статистики игрока
db_update($DB, 'statistic', array('points' => '1;+', 'product' => '1;+'), array('id' => USER['id']));

# обновление данных, в базе данных
db_update($DB, 'settings', array('storage' => '1;+'), array ('id' => USER['id'])); // место на складе
db_update($DB, 'garden', array('harv' => 0, 'plant' => 0, 'seed' => 0), array ('id' => $garth['id'])); } } // земля

####################

# посадка семян
if (isset($params['param']) && $params['param'] == 'seed' && isset($params['num']) && 
isset($params['plant']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметров
$num = $FUNC->filter($params['num'], 'int'); // земля
$plant = $FUNC->filter($params['plant'], 'int'); // растение

# проверка земли и семян на возможность посадки, в базе данных
if (db_exist($DB, 'garden', 'id', array('num' => $num, 'plant' => 0, 'user' => USER['id'])) && 
db_exist($DB, 'storage', 'id', array('object' => $plant, 'type' => 'seed', 'user' => USER['id']))) { 

# выбор данных из базы данных
$garth = db_output($DB, 'garden', 'id', array('num' => $num, 'user' => USER['id'])); // земля
$seed = db_output($DB, 'storage', array('id', 'count'), array('object' => $plant, 'type' => 'seed', 'user' => USER['id'])); // семена

# обновление количества семян
$count = $seed['count'] - 1; if ($count == 0) db_delete($DB, 'storage', array('id' => $seed['id'])); // удаление при нуле
else db_update($DB, 'storage', array('count' => '1;-'), array('id' => $seed['id'])); // новое количество

# данные об урожае
$crop = explode(';', PLANT['harv_'. $plant]); $harv = time() + $GAME->random($crop[0], $crop[1]);

# обновление данных
db_update($DB, 'settings', array('storage' => '1;-'), array ('id' => USER['id'])); // место на складе игрока
db_update($DB, 'garden', array('harv' => $harv, 'plant' => $plant, 'seed' => time()), array ('id' => $garth['id'])); } } // земля

####################

# листинг семян
if (isset($params['param']) && $params['param'] == 'seeds' && 
isset($params['num']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметра, земля
$num = $FUNC->filter($params['num'], 'int');

# проверка семян на складе, в базе данных
if (db_exist($DB, 'garden', 'id', array('num' => $num, 'plant' => 0, 'user' => USER['id']))) $seeds = true;

# проверка наличия семян, в базе данных
$seedes = (db_exist($DB, 'storage', 'id', array('type' => 'seed', 'user' => USER['id']))) ? true : false; }

####################
####################

# вывод растений или семян, из базы данных
if (isset($seeds) && $seedes) $query = db_output($DB, 'storage', array('count', 'object'), array('type' => 'seed', 'user' => USER['id']), true, 'object', 5); // семена
else $query = db_output($DB, 'garden', array('id', 'harv', 'num', 'plant', 'seed'), array('user' => USER['id']), true, 'num', DATA['garden']); // растения

# данные верхней ссылки
if (isset($seeds) || isset($digging)) $top = array('icon' => 'back', 'link' => 'Вернуться к растениям'); // назад
else $top = array('icon' => 'refresh', 'link' => 'Обновить'); // обновить

# данные нижней ссылки
if (isset($seeds)) $bottom = array('icon' => 'shop', 'link' => 'Купить семена', 'url' => 'shop/seeds'); // покупка семян
elseif (db_exist($DB, 'garden', 'id', array('plant;!=' => 0, 'user' => USER['id']))) $bottom = array(
'icon' => 'shovel', 'link' => 'Вскопать землю', 'url' => 'garden/digging/token/'. TOKEN); // вскапывание грядок

# разбор растений или семян, переработка данных в массиве
$index = 0; while ($assoc = $query->fetch_assoc()) {
$garden[$index] = $assoc; $index++; }

####################

# определение автообновления
$update = (isset($digging) || isset($seeds)) ? false : 'update ';

# вывод семян, определение данных
if (isset($seeds) && $seedes) { foreach ($garden as &$post) {
$post['name'] = PLANT['name_'. $post['object']]; // заголовок
$post['image'] = PLANT['image_'. $post['object']]; } // картинка

# вывод растений
} else { foreach ($garden as &$post) { $post['color'] = false; // стиль названия по умолчанию

# определение данных
$post['name'] = ($post['plant'] == 0) ? 'Пустая земля' : PLANT['name_'. $post['plant']]; // заголовок
$post['image'] = ($post['plant'] == 0) ? 'soil/ground' : $GAME->plant(PLANT['image_'. $post['plant']], $post['seed'], $post['harv']); // картинка

####################

# время ожидания урожая
$odds = $post['harv'] - time(); $wait = ($post['harv'] > time()) ? 'Урожай через '. $USER->when($odds, true, true) : 'Урожай созрел';

# массовое вскапывание грядок
if (isset($params['param']) && $params['param'] == 'digging' && isset($params['token']) && $params['token'] == TOKEN && 
db_exist($DB, 'garden', 'id', array('plant;!=' => 0, 'user' => USER['id']))) { unset($bottom); // удаление нижней ссылки

# действие, определение данных
if ($post['plant'] != 0) { $post['icon'] = 'shovel'; $post['text'] = 'Вскопать землю'; // иконка
$post['link'] = 'garden/digging/act/dig/num/'. $post['num']; } else {  // ссылка
$post['icon'] = 'cross'; $post['text'] = 'Земля вскопана'; $post['link'] = false; } }  // нет действия

####################

# вывод грядок, определение действия
else { if ($post['plant'] == 0) { $post['icon'] = 'plant'; $post['text'] = 'Посеять семена'; $post['link'] = 'garden/seeds/num/'. $post['num']; } // посадка семян
elseif ($post['harv'] < time() && $post['harv'] != 0 && SETUP['storage'] < DATA['storage']) { $post['color'] = true; 
$post['icon'] = 'hand'; $post['text'] = 'Собрать урожай'; $post['link'] = 'garden/harv/num/'. $post['num']; } // сбор урожая, есть место
elseif ($post['harv'] < time() && $post['harv'] != 0 && SETUP['storage'] >= DATA['storage']) { $post['color'] = true; 
$post['icon'] = 'cross'; $post['text'] = 'Нет места на складе'; $post['link'] = false; } // сбор урожая, нет места на складе
else { $post['icon'] = 'time'; $post['text'] = $wait; $post['link'] = false; } } // время ожидания
$post['name'] = ($post['color']) ? '<span class="color">'. $post['name'] .'</span>' : $post['name']; } } // стиль названия

?>