<?php

# заголовок
define('TITLE', 'Склад');

# определение данных
$params = PARAMS; // получение параметров
$refresh = $FUNC->random(8, true); // случайное число

####################
####################

# продажа продуктов
if (isset($params['param']) && $params['param'] == 'sale' && isset($params['type']) && 
isset($params['num']) && isset($params['count']) && isset($params['token']) && $params['token'] == TOKEN) {

# фильтрация параметров
$type = $FUNC->filter($params['type'], 'var'); // тип продукта
$num = $FUNC->filter($params['num'], 'int'); // номер
$count = $FUNC->filter($params['count'], 'int'); // количество

# проверка продуктов на наличие, в базе данных
if (db_exist($DB, 'storage', 'id', array('count;>=' => $count, 'object' => $num, 'type' => $type, 
'user' => USER['id'])) && $type != 'seed') { $cost = SALE[$type .'_'. $num] * $count; // стоимость продажи

# обновление количества продуктов на складе, изменение баланса, в базе данных
db_update($DB, 'settings', array('storage' => $count .';-'), array ('id' => USER['id'])); // место на складе игрока
$stock = db_output($DB, 'storage', array('id', 'count'), array('object' => $num, 'type' => $type, 'user' => USER['id'])); // вывод продукта
$amount = $stock['count'] - $count; if ($amount > 0) db_update($DB, 'storage', array('count' => $count .';-'), // обновление количества
array ('id' => $stock['id'])); else db_delete($DB, 'storage', array('id' => $stock['id'])); db_update($DB, 'statistic', array( // полное удаление, статистика
'money' => $cost .';+'), array('id' => USER['id'])); db_update($DB, 'users', array('money' => $cost .';+'), array('id' => USER['id'])); } } // баланс игрока

####################

# массовая продажа продуктов
if (isset($params['param']) && $params['param'] == 'sale' && isset($params['token']) && $params['token'] == TOKEN) {

# проверка наличия продуктов, в базе данных
if (db_exist($DB, 'storage', 'id', array('type;!=' =>'seed', 'user' => USER['id']))) $sale = true; }

####################
####################

# место на складе у игрока
$place = db_output($DB, 'settings', 'storage', array('id' => USER['id']));

# данные нижней ссылки, утилизация
$saled = (db_exist($DB, 'storage', 'id', array('type;!=' =>'seed', 'user' => USER['id'])) && !isset($sale)) ? true : false;

# данные верхней ссылки
if (isset($sale)) $top = array('icon' => 'back', 'link' => 'Вернуться на склад'); // назад
else $top = array('icon' => 'refresh', 'link' => 'Обновить'); // обновить

# стилевые данные, продажа продукции
$line = (!isset($sale)) ? ' class="line"' : false; $item = (isset($sale)) ? 'item sale' : 'item';

# проверка, вывод семян, из базы данных
if (!db_exist($DB, 'storage', 'id', array('type' => 'seed', 'user' => USER['id']))) $seeds = false; else 
$seed = db_output($DB, 'storage', array('count', 'object'), array('type' => 'seed', 'user' => USER['id']), true, 'object', 5);

# разбор семян, переработка данных в массиве
if (isset($seed)) { $index = 0; while ($assoc = $seed->fetch_assoc()) {
$seeds[$index] = $assoc; $index++; } foreach ($seeds as &$post) { // вывод растений
$post['name'] = PLANT['name_'. $post['object']]; // заголовок
$post['image'] = PLANT['image_'. $post['object']]; // картинка
$post['count'] = $post['count'] . ' шт.'; } } // количество

####################

# проверка, вывод растений, из базы данных
if (!db_exist($DB, 'storage', 'id', array('type' => 'plant', 'user' => USER['id']))) $plants = false; else 
$plant = db_output($DB, 'storage', array('count', 'object'), array('type' => 'plant', 'user' => USER['id']), true, 'object', 5);

# разбор растений, переработка данных в массиве
if (isset($plant)) { $index = 0; while ($assoc = $plant->fetch_assoc()) {
$plants[$index] = $assoc; $index++; } foreach ($plants as &$post) { // вывод растений
$post['sale'] = $GAME->word(SALE['plant_'. $post['object']], 'монета', 'монеты', 'монет'); // продажа
$post['name'] = PLANT['name_'. $post['object']]; // заголовок
$post['image'] = PLANT['image_'. $post['object']]; // картинка
$post['count'] = $post['count'] . ' шт.'; } } // количество

####################

# проверка, вывод продуктов животных, из базы данных
if (!db_exist($DB, 'storage', 'id', array('type' => 'food', 'user' => USER['id']))) $foods = false; else 
$food = db_output($DB, 'storage', array('count', 'object'), array('type' => 'food', 'user' => USER['id']), true, 'object', 3);

# разбор продуктов, переработка данных в массиве
if (isset($food)) { $index = 0; while ($assoc = $food->fetch_assoc()) {
$foods[$index] = $assoc; $index++; } foreach ($foods as &$post) { // вывод продуктов
$post['sale'] = $GAME->word(SALE['food_'. $post['object']], 'монета', 'монеты', 'монет'); // продажа
$post['name'] = ANIMAL['prod_'. $post['object']]; // заголовок
$post['image'] = ANIMAL['make_'. $post['object']]; // картинка
$post['count'] = $post['count'] . ' шт.'; } } // количество

####################

# проверка, вывод продуктов техники, из базы данных
if (!db_exist($DB, 'storage', 'id', array('type' => 'tech', 'user' => USER['id']))) $techs = false; else 
$tech = db_output($DB, 'storage', array('count', 'object'), array('type' => 'tech', 'user' => USER['id']), true, 'object', 3);

# разбор продуктов, переработка данных в массиве
if (isset($tech)) { $index = 0; while ($assoc = $tech->fetch_assoc()) {
$techs[$index] = $assoc; $index++; } foreach ($techs as &$post) { // вывод продуктов
$post['sale'] = $GAME->word(SALE['tech_'. $post['object']], 'монета', 'монеты', 'монет'); // продажа
$post['name'] = TECHNIC['prod_'. $post['object']]; // заголовок
$post['image'] = TECHNIC['make_'. $post['object']]; // картинка
$post['count'] = $post['count'] . ' шт.'; } } // количество

?>