<?php

# определение данных
$post = array(); // массив пост - данных
$class = array(); // стили полей
$value = array(); // введенные значения
$form = false; // имя формы
$go = false; // переадресация

# проверка отправки формы
if ($_SERVER['REQUEST_METHOD'] == 'POST') { 

# проверка полей
$post['nick'] = (isset($_POST['nick']) && $USER->filter($_POST['nick'], 'nick', DATA['nick'])) ? $_POST['nick'] : 'stopped'; // ник
$post['pass'] = (isset($_POST['pass']) && $USER->filter($_POST['pass'], 'pass', DATA['pass'])) ? $_POST['pass'] : 'stopped'; // пароль
$post['email'] = (isset($_POST['email']) && $USER->filter($_POST['email'], 'email')) ? $_POST['email'] : 'stopped'; // e-mail
$post['sex'] = (isset($_POST['sex']) && $USER->filter($_POST['sex'], 'sex')) ? $_POST['sex'] : 'stopped'; // пол (гендер)
$post['token'] = (isset($_POST['token']) && $_POST['token'] == TOKEN) ? 'true' : 'stopped'; // токен

# проверка в базе данных
if ($post['nick'] != 'stopped') { $post['nick'] = (db_exist($DB, 'users', 'id', array('nick' => $_POST['nick']))) ? 'stopped' : $_POST['nick']; } // ник
if ($post['email'] != 'stopped') { $post['email'] = (db_exist($DB, 'users', 'id', array('email' => $_POST['email']))) ? 'stopped' : $_POST['email']; } // e-mail

# определение наличия ошибок
if (in_array('stopped', $post)) { $save = true; // показ формы сохранения

# проверка полей, определение стилей
$class['nick'] = ($post['nick'] == 'stopped') ? 'no': 'ok'; // ник
$class['pass'] = ($post['pass'] == 'stopped') ? 'no': 'ok'; // пароль
$class['email'] = ($post['email'] == 'stopped') ? 'no': 'ok'; // e-mail
$class['sex'] = ($post['sex'] == 'stopped') ? 'no': 'ok'; // пол (гендер)

# проверка введенных значений, вывод данных
$value['nick'] = (isset($_POST['nick']) && !empty($_POST['nick'])) ? ' value="'. $_POST['nick'] .'"': false; // ник
$value['pass'] = (isset($_POST['pass']) && $USER->filter($_POST['pass'], 'pass', DATA['pass'])) ? ' value="'. $_POST['pass'] .'"': false; // пароль
$value['email'] = (isset($_POST['email']) && !empty($_POST['email'])) ? ' value="'. $_POST['email'] .'"': false; // e-mail
$value['sex_none'] = (isset($_POST['sex']) && $_POST['sex'] == 'none') ? ' selected ' : ' '; // пол (гендер), не указан
$value['sex_male'] = (isset($_POST['sex']) && $_POST['sex'] == 'male') ? ' selected ' : ' '; // пол (гендер), мужской
$value['sex_female'] = (isset($_POST['sex']) && $_POST['sex'] == 'female') ? ' selected ' : ' '; // пол (гендер), женский

# отсутствие ошибок
} else { $token = $FUNC->random(50); // токен активации

# сохранение профиля, в базе данных, статистика
db_update($DB, 'users', array('email' => $post['email'], 'nick' => trim($post['nick']), 
'pass' => $FUNC->hashing($_POST['pass']), 'sex' => $post['sex'], 'status' => 'user'), array ('id' => USER['id']));

# создание активации, в базе данных
db_create($DB, 'tokens', array('time' => time() + DATA['token'], 'token' => $token, 'type' => 'active', 'user' => USER['id']));

# отправка e-mail с активацией
$message = '<h2>Вы успешно зарегистрировались в онлайн - игре "'. SERV['name'] .'"!</h2><p>Для активации аккаунта 
перейдите по ссылке: <a href="https://'. SERV['host'] .'/activate/'. USER['id'] .'/token/'. $token .'">активировать</a></p>'; // сообщение
$headers = "From: ". SERV['name'] ." ". SERV['email'] ." \r\n"; // заголовок, от кого письмо
$headers .= "Content-type: text/html; charset=utf-8 \r\n"; // заголовок, кодировка
mail($post['email'], 'Регистрация', $message, $headers);  } } // отправка письма

?>