<?php

# ссылки на ошибки, вывод шаблонов
if (preg_match('#^/(cookie|failed|server)\z#ui', URL)) { require_once MODS .'error'. URL .'.php'; exit; }

# обработка платежа по итогу
elseif ($FUNC->url(URL, 'status', true)) { require_once MODS .'make/acts/unit.php'; exit; }

# обработка ссылок на вконтакте
elseif ($FUNC->url(URL, 'vk/auth', true)) { require_once MODS .'guest/acts/vk.php'; exit; } // авторизация
elseif ($FUNC->url(URL, 'vk/save', true)) { require_once MODS .'users/acts/vk.php'; exit; } // сохранение

# обработка ссылок, отдельные запросы
elseif ($FUNC->url(URL, 'form')) { require_once SYS .'rout/form.php'; exit; } // формы
elseif ($FUNC->url(URL, 'page')) { require_once SYS .'rout/nav.php'; exit; } // страницы
elseif ($FUNC->url(URL, 'load')) { require_once SYS .'rout/load.php'; exit; } // обновляемые блоки

# получение страницы из ссылки
if (!$FUNC->url(URL)) $FUNC->go('/error'); // ссылка неверная
elseif (URL == '/') $route = 'index'; // проверка индекса
else { $parts = $FUNC->parse(URL); // парсинг ссылки
$route = reset($parts); } // определение текущего роутера
if (!isset($route)) $route = 'stop'; // проверка целостности массива ссылки

# данные по умолчанию
$page = 'sheet'; // тип запроса
$status = 'all'; // любой статус
$param = false; // начальный параметр
$params = false; // общие параметры

# выборка модуля из списка
require_once SYS .'rout/page.php';

# проверка авторизации
require_once SYS .'main/auth.php';

# получение бонуса, зарегистрированный аккаунт
if (defined('USER') && USER['bonus'] < time() && URL != '/bonus') $FUNC->go('/bonus');

# не указан ник, зарегистрированный аккаунт
if (defined('USER') && USER['status'] != 'guest' && USER['nick'] == 'Гость' && URL != '/nick') $FUNC->go('/nick');

# запрос на индекс, проверка авторизации, переадресация
if ($route == 'index') { $link = (defined('USER')) ? '/garden' : '/start'; $FUNC->go($link); }

# страница отсутствует, показ ошибки
if (isset($stop)) { require_once MODS .'error/page.php'; exit; }

# запись данных навигации
define('ROUT', array('folder' => $folder, 'file' => $file));

# проверка и запись параметров
if ($param || $params) define('PARAMS', $FUNC->params($parts, key($parts), $param));

# проверка, подключение действия
if (file_exists(MODS . ROUT['folder'] .'/acts/'. ROUT['file'] .'.php'))
require_once MODS . ROUT['folder'] .'/acts/'. ROUT['file'] .'.php';

# вывод данных
ob_start('ob_gzhandler'); // буферизация, сжатие данных
header('Content-Type: text/html; charset=UTF-8'); // тип контента и кодировка

# проверка, подключение шаблонов
if (file_exists(MODS . ROUT['folder'] .'/temps/'. ROUT['file'] .'.php')) {
require_once MODS .'wraps/start.php'; require_once MODS .'wraps/head.php'; // шапка
require_once MODS . ROUT['folder'] .'/temps/'.  ROUT['file'] .'.php'; // шаблон модуля
require_once MODS .'wraps/act.php'; require_once MODS .'wraps/foot.php'; } // подвал

# окончание работы
if (session_status() == PHP_SESSION_ACTIVE) session_write_close(); // сессия
if (isset($DB)) $DB->close(); ob_end_flush(); // база данных, вывод буфер

?>