<?php
acms_header('Добавить ссылку', 'users'); 
is_active_module('PRIVATE_SURFING');

if (post('ok')){
  
  valid::create(array(
    
    'SURF_MESSAGE' => ['message', 'text', [10, 250], 'Описание', 0],
    'SURF_LINK' => ['link', 'link', [1, 250], 'Ссылка'],
    'SURF_TIME2' => ['time2', 'number_abs', [1, 99999999999], 'Время просмотра'],
    'SURF_REPLAY' => ['replay', 'number', [1, 99999999999], 'Повтор'],
    'SURF_SUM' => ['sum', 'number_abs', [1, 9999999], 'Бюджет ссылки'],
  
  ));
  
  if (ERROR_LOG == 1){
    
    redirect('/m/surfing/add/');
    
  }
  
  if (user('MONEY') < SURF_SUM){
    
    error('Недостаточно денег на вашем счету. Для начала пополните свой счет');
    redirect('/shopping/rep/');
    
  }
  
  $admin = db::get_string("SELECT `ID` FROM `USERS` WHERE `ACCESS` = '99' ORDER BY `ID` DESC LIMIT 1");
  
  if (isset($admin['ID'])) {
    
    $message = lg('Пользователь %s добавил ссылку в серфинг и ждет её одобрения. %s', '[b]'.user::login_mini(user('ID')).'[/b]', '[url=/m/surfing/moderation/]'.lg('Подробнее в модерации').'[/url]');
    messages::get(intval(config('SYSTEM')), $admin['ID'], $message);
    
  }
  
  db::get_add("INSERT INTO `SURFING` (`MESSAGE`, `USER_ID`, `TIME`, `LINK`, `BUDGET`, `REPLAY`, `TIME2`, `JTIME`, `BUDGET_REMAINS`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", [SURF_MESSAGE, user('ID'), TM, SURF_LINK, SURF_SUM, SURF_REPLAY, SURF_TIME2, TM, SURF_SUM]);  
  money_data(user('ID'), SURF_SUM, 2, lg('Пополнение бюджета ссылки в серфинге сайтов'), 1);
  
  success('Ссылка успешно добавлена и передана на модерацию. Ожидайте одобрения');
  redirect('/m/surfing/users/?id='.user('ID'));
  
}

?>
<div class='list-body'>
<div class='list-menu'>
<form class='ajax-form' action='/m/surfing/add/'>
<?=html::input('message', 'Описание ссылки (от 10 до 250 символов)', null, null, null, 'form-control-100', 'text', null, 'text-width')?>
<?=html::input('link', 'Укажите ссылку ('.lg('вместе с').' http/https)', null, null, null, 'form-control-100', 'text', null, 'link')?>  
<?=html::select('replay', array(
  21600 => ['Через 6 часов', 21600],
  43200 => ['Через 12 часов', 43200],
  86400 => ['Через 1 дня', 86400],
  172800 => ['Через 2 дня', 172800],
  259200 => ['Через 3 дня', 259200]
), 'Показывать повторно ссылку', 'form-control-100-modify-select', 'clock-o')?>
<?=html::select('time2', array(
  5 => ['5 '.lg('секунд').' ('.money(abs(config('SURF_5')), 2).' '.lg('за 1 просмотр').')', 5],
  10 => ['10 '.lg('секунд').' ('.money(abs(config('SURF_10')), 2).') '.lg('за 1 просмотр').')', 10],
  15 => ['15 '.lg('секунд').' ('.money(abs(config('SURF_15')), 2).') '.lg('за 1 просмотр').')', 15],
  20 => ['20 '.lg('секунд').' ('.money(abs(config('SURF_20')), 2).') '.lg('за 1 просмотр').')', 20],
  25 => ['25 '.lg('секунд').' ('.money(abs(config('SURF_25')), 2).') '.lg('за 1 просмотр').')', 25],
  30 => ['30 '.lg('секунд').' ('.money(abs(config('SURF_30')), 2).') '.lg('за 1 просмотр').')', 30],
  35 => ['35 '.lg('секунд').' ('.money(abs(config('SURF_35')), 2).') '.lg('за 1 просмотр').')', 35],
  40 => ['40 '.lg('секунд').' ('.money(abs(config('SURF_40')), 2).') '.lg('за 1 просмотр').')', 40]
), 'Время просмотра ссылки', 'form-control-100-modify-select', 'clock-o')?>
<?=html::input('sum', 'Бюджет', lg('Укажите бюджет ссылки: (мин. %s). У вас на счету %s', money(1, 2), '<b>'.money(user('MONEY'), 2).'</b>'), null, 0, 'form-control-50', 'number', null, 'money')?>  
<?=html::button('button ajax-button', 'ok', 'plus', 'Добавить ссылку')?>
<a href='/m/surfing/' class='button-o'><?=lg('Отмена')?></a>
</form>
</div>
</div>
<?

back('/m/surfing/');
acms_footer();