<?php
$account = db::get_string("SELECT `ID` FROM `USERS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
acms_header(lg('Ссылки %s', user::login_mini($account['ID'])), 'users'); 
is_active_module('PRIVATE_SURFING');

if (!isset($account['ID'])) {
  
  error('Неверная директива');
  redirect('/');
  
}

//Поднять в списке
if (get('top')) {
  
  $surf = db::get_string("SELECT * FROM `SURFING` WHERE `USER_ID` = ? AND `ACT` = '1' AND `ID` = ? LIMIT 1", [user('ID'), intval(get('top'))]);
  
  if (isset($surf['ID'])){
    
    if (user('MONEY') < config('SURF_TOP')) {
      
      error('Недостаточно денег на счету');
      redirect('/m/surfing/users/?id='.user('ID'));
      
    }
    
    db::get_set("UPDATE `SURFING` SET `JTIME` = ? WHERE `ID` = ? LIMIT 1", [TM, intval(get('top'))]);
    money_data(user('ID'), abs(config('SURF_TOP')), 2, lg('Списание средств за поднятие ссылки в серфинге сайтов'), 0);
    
    success('Вы успешно подняли ссылку в серфинге');
    redirect('/m/surfing/users/?id='.user('ID'));
    
  }
  
}

//Вложение в бюджет
if (get('budget')){
  
  $surf = db::get_string("SELECT * FROM `SURFING` WHERE `USER_ID` = ? AND `ACT` = '1' AND `ID` = ? LIMIT 1", [user('ID'), intval(get('budget'))]);
  
  if (isset($surf['ID'])){
    
    require (ROOT.'/modules/surfing/plugins/budget.php');
    
  }
  
}

//Остановить
if (get('stop') && db::get_column("SELECT COUNT(*) FROM `SURFING` WHERE `USER_ID` = ? AND `ACT` = '1' AND `ID` = ? LIMIT 1", [user('ID'), intval(get('stop'))]) > 0){
  
  db::get_set("UPDATE `SURFING` SET `ACT` = '2' WHERE `ID` = ? LIMIT 1", [intval(get('stop'))]);
  
  success('Ссылка успешно остановлена');
  redirect('/m/surfing/users/?id='.user('ID'));
  
}

//Запустить
if (get('start') && db::get_column("SELECT COUNT(*) FROM `SURFING` WHERE `USER_ID` = ? AND `ACT` = '2' AND `ID` = ? LIMIT 1", [user('ID'), intval(get('start'))]) == 1){
  
  db::get_set("UPDATE `SURFING` SET `ACT` = '1' WHERE `ID` = ? LIMIT 1", [intval(get('start'))]);
  
  success('Ссылка успешно запущена');
  redirect('/m/surfing/users/?id='.user('ID'));
  
}

?>
<div class='menu-nav-content'>
<a class='menu-nav' href='/m/surfing/'>
<?=lg('Серфинг')?>
</a>
<a class='menu-nav h' href='/m/surfing/users/?id=<?=user('ID')?>'>
<?=lg('Мои ссылки')?>
</a>
<a class='menu-nav' href='/m/surfing/history/'>
<?=lg('История')?>
</a>
<a class='menu-nav' href='/m/surfing/authors/'>
<?=lg('Рекламодатели')?>
</a>
</div>
<?php if ($account == user('ID')) : ?>
<div class='list'>
<a class='btn' href='/m/surfing/add/'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить ссылку')?></a>
</div>
<?php endif ?>
<?
  
require (ROOT.'/modules/surfing/plugins/delete.php');

$column = db::get_column("SELECT COUNT(*) FROM `SURFING` WHERE `USER_ID` = ?", [$account['ID']]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty();
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `SURFING` WHERE `USER_ID` = ? ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$account['ID']]);
while ($list = $data->fetch()){
  
  require (ROOT.'/modules/surfing/plugins/list_us.php');

}

if ($column > 0){

  ?></div><?
  
}

get_page('/m/surfing/users/?id='.$account['ID'].'&', $spage, $page);

back('/m/surfing/?get=go', 'Серфинг');
back('/', 'На главную');
acms_footer();